/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class AnimatedImageCanvas
extends Canvas
implements Runnable {
    private Image img = null;
    private Image topImage = null;
    private boolean cleared = false;
    private CanvasEventListener listener = null;
    private int backgroundColour = 0xFFFFFF;
    private int delay = 50;
    private int frame = 0;
    private int frame_width = 0;
    private int frame_height = 0;
    private int source_rows = 0;
    private int frames_per_row = 0;
    private int frames = 0;
    private Thread thread;

    public AnimatedImageCanvas() {
        this.setFullScreenMode(true);
    }

    public AnimatedImageCanvas(String res) {
        this.setFullScreenMode(true);
        this.loadImage(res, 0, 0);
    }

    public AnimatedImageCanvas(String res, int bgcol) {
        this.setFullScreenMode(true);
        this.loadImage(res, 0, 0, 1);
        this.backgroundColour = bgcol;
    }

    public AnimatedImageCanvas(String res, int frame_width, int frames) {
        this.setFullScreenMode(true);
        this.loadImage(res, frame_width, frames, 1);
    }

    public AnimatedImageCanvas(String res, int frame_width, int frames, int bgcol) {
        this.setFullScreenMode(true);
        this.loadImage(res, frame_width, frames, 1);
        this.backgroundColour = bgcol;
    }

    public AnimatedImageCanvas(String res, int frame_width, int frames, int bgcol, int nrows) {
        this.setFullScreenMode(true);
        this.loadImage(res, frame_width, frames, nrows);
        this.backgroundColour = bgcol;
    }

    public void setTopImage(Image i) {
        this.topImage = i;
    }

    public void loadImage(String res, int frame_width, int frames) {
        this.loadImage(res, frame_width, frames, 1);
    }

    public void loadImage(String res, int frame_width, int frames, int nrows) {
        this.frame_width = frame_width;
        this.frames = frames;
        this.source_rows = nrows;
        this.frames_per_row = frames / nrows;
        try {
            this.img = Image.createImage((String)res);
        }
        catch (IOException e) {
            System.out.println("Cannot load PNG: " + res);
        }
        if (this.img != null) {
            this.frame_height = this.img.getHeight() / nrows;
        }
    }

    public void setImage(Image img) {
        this.img = img;
        this.frame_height = img.getHeight();
        this.frame_width = 0;
        this.frames = 1;
        this.source_rows = 1;
        this.frames_per_row = 1;
    }

    public void setImage(Image img, int frame_width, int frames) {
        this.setImage(img, frame_width, frames, 1);
    }

    public void setImage(Image img, int frame_width, int frames, int nrows) {
        this.img = img;
        this.frame_width = frame_width;
        this.frames = frames;
        this.frame_height = img.getHeight() / nrows;
        this.source_rows = nrows;
        this.frames_per_row = frames / nrows;
    }

    public void setImageRows(int num_rows) {
        this.source_rows = num_rows;
        this.frame_height /= this.source_rows;
        this.frames_per_row = this.frames / this.source_rows;
    }

    public void setEventListener(CanvasEventListener c) {
        this.listener = c;
    }

    public void animate() {
        this.thread = new Thread(this);
        this.thread.start();
    }

    public void stop() {
        this.thread = null;
    }

    public void setDelay(int newval) {
        this.delay = newval;
    }

    public void setBackgroundColour(int bgcol) {
        this.backgroundColour = bgcol;
    }

    public void run() {
        Thread me = Thread.currentThread();
        while (me == this.thread) {
            try {
                this.frame = this.frame >= this.frames - 1 ? 0 : this.frame + 1;
                this.repaint();
                this.serviceRepaints();
                Thread.sleep(this.delay);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void paint(Graphics g) {
        g.setColor(this.backgroundColour);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.topImage != null) {
            g.drawImage(this.topImage, 0, 0, 0x10 | 4);
        }
        if (this.img != null) {
            if (this.frames > 1) {
                int x = (this.getWidth() >> 1) - (this.frame_width >> 1);
                int y = (this.getHeight() >> 1) - (this.frame_height >> 1);
                int imgXoffset = x - this.frame % this.frames_per_row * this.frame_width;
                int imgYoffset = y - this.frame / this.frames_per_row * this.frame_height;
                g.setClip(x, y, this.frame_width, this.frame_height);
                g.drawImage(this.img, imgXoffset, imgYoffset, 0x10 | 4);
            } else {
                int x = (this.getWidth() >> 1) - (this.img.getWidth() >> 1);
                int y = (this.getHeight() >> 1) - (this.img.getHeight() >> 1);
                g.drawImage(this.img, x, y, 0x10 | 4);
            }
        }
    }

    protected void hideNotify() {
        this.cleared = false;
    }

    protected void keyPressed(int keyCode) {
        if (this.listener != null) {
            this.listener.triggeredEvent(this);
        }
    }

    protected void pointerPressed(int x, int y) {
        if (this.listener != null) {
            this.listener.triggeredEvent(this);
        }
    }

    public void purge() {
        if (this.img != null) {
            this.img = null;
            System.gc();
        }
    }
}

