/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class SettingsMenuCanvas
extends Canvas {
    public int LINE_SPACING = 6;
    public Image topImage = null;
    public Image[] icons = new Image[10];
    public String[] items_sound = new String[]{"Sound", "Difficulty", "Reset"};
    public String[] icons_sound = new String[]{"sound", "diff", "reset"};
    public String[] items_nosound = new String[]{"Difficulty", "Reset"};
    public String[] icons_nosound = new String[]{"diff", "reset"};
    public String[] items = this.items_sound;
    public String[] list_icons = this.icons_sound;
    public Quiz parent;
    public int selectedIndex = 0;
    public String alertTitle;
    public String alertText;
    public boolean displayAlert = false;

    public SettingsMenuCanvas(Image t, Quiz q) {
        this.setFullScreenMode(true);
        this.topImage = t;
        this.parent = q;
        if (Common.DISABLE_SOUND) {
            this.items = this.items_nosound;
            this.list_icons = this.icons_nosound;
        }
        boolean loadIcons = true;
        if (this.getWidth() > 128) {
            this.LINE_SPACING = 6;
        } else if (this.getHeight() > 128) {
            this.LINE_SPACING = 6;
        } else {
            loadIcons = false;
            this.LINE_SPACING = 2;
        }
        if (loadIcons) {
            for (int i = 0; i < this.list_icons.length; ++i) {
                try {
                    this.icons[i] = null;
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void paint(Graphics g) {
        this.setFullScreenMode(true);
        g.setColor(0xFFFFFF);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        Font fnt = Font.getFont((int)0, (int)0, (int)0);
        g.setFont(fnt);
        g.setColor(0);
        int lineY = 0;
        if (this.topImage != null) {
            g.drawImage(this.topImage, 0, 0, 0x10 | 4);
            lineY += this.topImage.getHeight();
        }
        lineY += this.LINE_SPACING;
        int rowHeight = Common.fontRenderer.getHeight() + this.LINE_SPACING;
        int textOffset = this.LINE_SPACING / 2;
        for (int i = 0; i < this.items.length; ++i) {
            if (i == this.selectedIndex) {
                g.setColor(0x333333);
                g.fillRect(0, lineY - textOffset, this.getWidth(), rowHeight);
                Common.inverseFontRenderer.drawString(g, this.items[i], 10, lineY);
                g.setColor(0xFFFFFF);
            } else {
                Common.fontRenderer.drawString(g, this.items[i], 10, lineY);
                g.setColor(0);
            }
            if (this.icons[i] != null) {
                int iconY = (rowHeight - this.icons[i].getHeight()) / 2;
                g.drawImage(this.icons[i], this.getWidth() - 25, lineY - textOffset + iconY, 0x10 | 4);
            }
            lineY += Common.fontRenderer.getHeight() + this.LINE_SPACING;
        }
        g.setClip(0, 0, this.getWidth(), this.getHeight());
        g.setColor(0xD0D0D0);
        g.fillRect(0, this.getHeight() - Common.fontRenderer.getHeight() - 6, this.getWidth(), Common.fontRenderer.getHeight() + 6);
        if (this.displayAlert) {
            Common.drawAlert(g, this.alertTitle, this.alertText, this.getWidth(), this.getHeight());
            Common.drawCommands(g, null, "OK", this.getWidth(), this.getHeight());
        } else {
            Common.drawCommands(g, "Select", "Back", this.getWidth(), this.getHeight());
        }
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public void keyReleased(int keyCode) {
        if (this.displayAlert) {
            if (Common.isRSK(keyCode)) {
                this.hideAlert();
            }
            return;
        }
        if (Common.isLSK(keyCode)) {
            this.parent.settingsMenuSelect(this.selectedIndex);
            return;
        }
        if (Common.isRSK(keyCode)) {
            this.parent.displayList();
            return;
        }
        int ga = this.getGameAction(keyCode);
        if (ga == 1 || keyCode == 50) {
            --this.selectedIndex;
            if (this.selectedIndex < 0) {
                this.selectedIndex = this.items.length - 1;
            }
        } else if (ga == 6 || keyCode == 56) {
            ++this.selectedIndex;
            if (this.selectedIndex >= this.items.length) {
                this.selectedIndex = 0;
            }
        } else if (ga == 8) {
            this.parent.settingsMenuSelect(this.selectedIndex);
        }
        this.repaint();
    }

    public void displayAlert(String title, String text) {
        this.displayAlert = true;
        this.alertTitle = title;
        this.alertText = text;
        this.repaint();
    }

    public boolean alertOnDisplay() {
        return this.displayAlert;
    }

    public void hideAlert() {
        this.displayAlert = false;
        this.repaint();
    }
}

