/*
 * Decompiled with CFR 0.152.
 */
import java.util.Random;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Image;
import javax.microedition.midlet.MIDlet;

public class Quiz
extends MIDlet
implements CanvasEventListener,
HandyxScreenListener,
OptionCanvasListener,
Runnable {
    public final int LS_INIT;
    public final int LS_START;
    public final int LS_EXIT;
    public Display display;
    public AnimatedImageCanvas loadingScreen;
    public AnimatedImageCanvas splashScreen;
    public ScoresCanvas finalScoreCanvas;
    public HelperCanvas helperCanvas;
    public HandyxScreen closingScreen;
    public Image scoreHeaderImage;
    public Image questionHeaderImage;
    public Image instructionsImage;
    public Image settingsImage;
    public Image menuImage;
    public Image aboutImage;
    public OptionCanvas questionForm;
    public OptionCanvas answerForm;
    public OptionCanvas soundForm;
    public OptionCanvas difficultyForm;
    public OptionCanvas resetForm;
    public OptionCanvas aboutForm;
    public MenuCanvas menu;
    public OptionCanvas helpForm;
    public Image startIcon;
    public Image exitIcon;
    public Image resetIcon;
    public Image infoIcon;
    public Image helpIcon;
    public Image scoreIcon;
    public Image diffIcon;
    public Image soundIcon;
    public Questions theQuestions;
    public Question currentQuestionObj;
    public int currentQuestionNum;
    public int roundScore;
    public QuestionLoader qloader;
    public int difficulty = 0;
    private int a = 0;
    public SoundManager soundManager;
    public boolean sound_enabled = false;
    public int SOUND_ALLGOOD = 0;
    public int SOUND_ALLBAD = 1;
    public int SOUND_WRONG = 2;
    public int SOUND_CORRECT = 3;
    public int SOUND_START = 4;
    public int SOUND_SPLASH = this.SOUND_ALLGOOD;
    public String[] snds = new String[]{"/sound/applause.mid", "/sound/jeers.mid", "/sound/wrong.mid", "/sound/correct.mid", "/sound/whistle.mid"};
    public String[] snds_mime = new String[]{"audio/midi", "audio/midi", "audio/midi", "audio/midi", "audio/midi"};
    private int b = 3;
    public SettingsMenuCanvas settingsMenu;

    public Quiz() {
        this.LS_INIT = 0;
        this.LS_START = 1;
        this.LS_EXIT = 2;
        this.display = Display.getDisplay((MIDlet)this);
        GMG.getJadParameters(this);
        this.loadingScreen = new AnimatedImageCanvas("/loading.png", 35, 5, 0xFFFFFF, 1);
        this.loadingScreen.setFullScreenMode(true);
        this.loadingScreen.animate();
        this.display.setCurrent((Displayable)this.loadingScreen);
        this.a = 0;
        Thread thread = new Thread(this);
        thread.start();
    }

    public void setOptions(int n) {
        if (n == 0) {
            this.sound_enabled = true;
            n = 1;
        } else {
            this.sound_enabled = false;
            n = 0;
        }
        try {
            RecordManager.save(n, "quizsound");
            return;
        }
        catch (Exception exception) {
            System.out.println("sound saving exception");
            return;
        }
    }

    public void setDifficulty(int n) {
        try {
            this.difficulty = n;
            RecordManager.save(n, "quizdiff");
            return;
        }
        catch (Exception exception) {
            System.out.println("difficulty saving exception");
            return;
        }
    }

    public void loadOptions() {
        Exception exception;
        int n = 1;
        int n2 = 0;
        try {
            if (RecordManager.exists("quizsound")) {
                n = RecordManager.byteArrayToInt(RecordManager.load("quizsound"));
            }
        }
        catch (Exception exception2) {
            exception = exception2;
            exception2.printStackTrace();
        }
        try {
            if (RecordManager.exists("quizdiff")) {
                n2 = RecordManager.byteArrayToInt(RecordManager.load("quizdiff"));
            }
        }
        catch (Exception exception3) {
            exception = exception3;
            exception3.printStackTrace();
        }
        this.sound_enabled = n == 1;
        this.difficulty = n2;
    }

    public void run() {
        block11: {
            try {
                if (this.a == 0) {
                    this.soundManager = new SoundManager();
                    Common.loadResources();
                    try {
                        this.scoreHeaderImage = Image.createImage((String)"/score.png");
                        this.questionHeaderImage = Image.createImage((String)"/question.png");
                        this.instructionsImage = Image.createImage((String)"/help.png");
                        this.settingsImage = Image.createImage((String)"/settings.png");
                        this.menuImage = Image.createImage((String)"/menu.png");
                        this.aboutImage = Image.createImage((String)"/about.png");
                    }
                    catch (Exception exception) {}
                    this.loadOptions();
                    this.splashScreen = new AnimatedImageCanvas("/splash.png");
                    this.splashScreen.setFullScreenMode(true);
                    this.splashScreen.setEventListener(this);
                    if (this.sound_enabled) {
                        this.soundManager.playSound(this.snds[this.SOUND_SPLASH], this.snds_mime[this.SOUND_SPLASH]);
                    }
                    this.display.setCurrent((Displayable)this.splashScreen);
                    break block11;
                }
                if (this.a == 1) {
                    if (this.splashScreen != null) {
                        this.splashScreen.purge();
                        this.splashScreen = null;
                        System.gc();
                    }
                    this.resetForm = new OptionCanvas(this.settingsImage);
                    this.resetForm.setPageTitle("Reset Quiz");
                    this.resetForm.setText("This will clear your current progress, are you sure you want to reset the quiz?");
                    this.resetForm.addOption(Strings.CMD_NO);
                    this.resetForm.addOption(Strings.CMD_YES);
                    this.resetForm.setCommands(Strings.CMD_CANCEL, Strings.CMD_CONTINUE);
                    this.resetForm.setParent(this);
                    this.resetForm.setOptionCanvasListener(this);
                    this.soundForm = new OptionCanvas(this.settingsImage);
                    this.soundForm.setPageTitle("Sound");
                    this.soundForm.setText("Enable sound?");
                    this.soundForm.addOption(Strings.CMD_YES);
                    this.soundForm.addOption(Strings.CMD_NO);
                    if (this.sound_enabled) {
                        this.soundForm.setSelectedIndex(0);
                    } else {
                        this.soundForm.setSelectedIndex(1);
                    }
                    this.soundForm.setCommands(Strings.CMD_BACK, Strings.CMD_SAVE);
                    this.soundForm.setParent(this);
                    this.soundForm.setOptionCanvasListener(this);
                    this.difficultyForm = new OptionCanvas(this.settingsImage);
                    this.difficultyForm.setPageTitle(Strings.DIFFICULTY_TITLE);
                    this.difficultyForm.setText(Strings.DIFFICULTY_TEXT);
                    this.difficultyForm.addOption(Strings.NOVICE_LABEL);
                    this.difficultyForm.addOption(Strings.EXPERT_LABEL);
                    this.difficultyForm.addOption(Strings.TIME_LIMIT_LABEL);
                    this.difficultyForm.setSelectedIndex(this.difficulty);
                    this.difficultyForm.setCommands(Strings.CMD_BACK, Strings.CMD_SAVE);
                    this.difficultyForm.setParent(this);
                    this.difficultyForm.setOptionCanvasListener(this);
                    this.finalScoreCanvas = new ScoresCanvas();
                    this.finalScoreCanvas.setImage(this.scoreHeaderImage);
                    this.finalScoreCanvas.setBackgroundColour(0xFFFFFF);
                    this.finalScoreCanvas.setParent(this);
                    this.helperCanvas = new HelperCanvas();
                    this.helperCanvas.setImage(this.questionHeaderImage);
                    this.helperCanvas.setBackgroundColour(0xFFFFFF);
                    this.helperCanvas.setParent(this);
                    this.helpForm = new OptionCanvas(this.instructionsImage);
                    this.helpForm.setPageTitle("Instructions");
                    this.helpForm.setText(Strings.HELP_CONTENTS);
                    this.helpForm.setCommands(Strings.CMD_BACK, null);
                    this.helpForm.setOptionCanvasListener(this);
                    this.aboutForm = new OptionCanvas(this.aboutImage);
                    this.aboutForm.setPageTitle(Strings.ABOUT_TITLE);
                    this.aboutForm.setText("This quiz is brought to you by HandyX Ltd.\n\nFor more information visit www.handyx.net or contact us on mobile@sprite.net");
                    this.aboutForm.setCommands(Strings.CMD_BACK, null);
                    this.aboutForm.setOptionCanvasListener(this);
                    this.questionForm = new OptionCanvas(this.questionHeaderImage);
                    this.questionForm.setCommands(Strings.CMD_MENU, Strings.CMD_NEXT_QUESTION);
                    this.questionForm.setParent(this);
                    this.questionForm.setOptionCanvasListener(this);
                    this.answerForm = new OptionCanvas(this.questionHeaderImage);
                    this.answerForm.setCommands(Strings.CMD_MENU, Strings.CMD_NEXT_QUESTION);
                    this.answerForm.setParent(this);
                    this.answerForm.setOptionCanvasListener(this);
                    this.menu = new MenuCanvas(this.menuImage, this);
                    this.settingsMenu = new SettingsMenuCanvas(this.settingsImage, this);
                    this.theQuestions = new Questions(this);
                    this.display.setCurrent((Displayable)this.menu);
                    this.loadingScreen.setTopImage(this.questionHeaderImage);
                    break block11;
                }
                if (this.a == 2) {
                    this.closingScreen = new HandyxScreen(this, 5000, this.loadingScreen.getWidth(), this.loadingScreen.getHeight());
                    this.closingScreen.loadResources();
                    this.display.setCurrent((Displayable)this.closingScreen);
                }
                return;
            }
            catch (Exception exception) {}
        }
    }

    public void startApp() {
    }

    public void destroyApp(boolean bl) {
        if (this.questionForm != null) {
            this.questionForm.stopCountdown();
        }
    }

    public void pauseApp() {
    }

    public void displayList() {
        if (this.questionForm != null) {
            this.questionForm.stopCountdown();
        }
        this.display.setCurrent((Displayable)this.menu);
    }

    public void mainMenuSelect(int n) {
        switch (n) {
            case 0: {
                this.roundScore = 0;
                this.currentQuestionNum = 0;
                this.b = 3;
                if (this.sound_enabled) {
                    this.soundManager.playSound(this.snds[this.SOUND_START], this.snds_mime[this.SOUND_START]);
                }
                if (this.theQuestions.answeredAllQuestions()) {
                    this.finalScoreCanvas.setText(Strings.GAME_COMPLETE_TEXT);
                    this.finalScoreCanvas.smallFont(false);
                    this.finalScoreCanvas.setCommands(Strings.CMD_MENU, null);
                    this.display.setCurrent((Displayable)this.finalScoreCanvas);
                    return;
                }
                this.display.setCurrent((Displayable)this.loadingScreen);
                this.qloader = null;
                System.gc();
                this.qloader = new QuestionLoader(this, this.theQuestions);
                this.qloader.start();
                return;
            }
            case 1: {
                this.finalScoreCanvas.setText(Strings.fill(Strings.FINAL_SCORE_TEXT, Integer.toString(this.theQuestions.getScore()), Integer.toString(900)));
                this.finalScoreCanvas.smallFont(false);
                this.finalScoreCanvas.setCommands(Strings.CMD_BACK, null);
                this.display.setCurrent((Displayable)this.finalScoreCanvas);
                return;
            }
            case 2: {
                this.helpForm.resetScrolling();
                this.display.setCurrent((Displayable)this.helpForm);
                return;
            }
            case 3: {
                this.display.setCurrent((Displayable)this.settingsMenu);
                return;
            }
            case 4: {
                GMG.doGMG(this, this.display);
                return;
            }
            case 5: {
                this.aboutForm.resetScrolling();
                this.display.setCurrent((Displayable)this.aboutForm);
                return;
            }
            case 6: {
                this.exitApplication();
            }
        }
    }

    public void exitApplication() {
        this.display.setCurrent((Displayable)this.loadingScreen);
        this.a = 2;
        Thread thread = new Thread(this);
        thread.start();
    }

    public void screenCleared(HandyxScreen handyxScreen) {
        this.destroyApp(false);
        System.gc();
        this.notifyDestroyed();
    }

    public void displayResultsForm() {
        this.finalScoreCanvas.smallFont(false);
        if (this.roundScore == 10) {
            if (this.sound_enabled) {
                this.soundManager.playSound(this.snds[this.SOUND_ALLGOOD], this.snds_mime[this.SOUND_ALLGOOD]);
            }
            if (this.theQuestions.answeredAllQuestions()) {
                this.finalScoreCanvas.setText(Strings.GAME_COMPLETE_TEXT);
                this.finalScoreCanvas.setCommands(Strings.CMD_MENU, null);
            } else {
                this.finalScoreCanvas.setText(Strings.NEXT_ROUND_TEXT);
                this.finalScoreCanvas.setCommands(Strings.CMD_MENU, Strings.CMD_NEXT_ROUND);
            }
        } else {
            if (this.roundScore <= 5) {
                if (this.sound_enabled) {
                    this.soundManager.playSound(this.snds[this.SOUND_ALLBAD], this.snds_mime[this.SOUND_ALLBAD]);
                }
            } else if (this.sound_enabled) {
                this.soundManager.playSound(this.snds[this.SOUND_ALLGOOD], this.snds_mime[this.SOUND_ALLGOOD]);
            }
            String string = Strings.fill(Strings.ROUND_SCORE_TEXT, Integer.toString(this.roundScore));
            this.finalScoreCanvas.setText(string);
            this.finalScoreCanvas.setCommands(Strings.CMD_MENU, Strings.CMD_NEXT_ROUND);
        }
        this.display.setCurrent((Displayable)this.finalScoreCanvas);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void createQuestionForm(int n) {
        this.currentQuestionObj = this.theQuestions.get(n);
        this.currentQuestionObj.reset();
        String string = Strings.SCORE_LABEL + ": " + this.roundScore;
        this.questionForm.reset();
        this.questionForm.displayCountdown(this.difficulty == 2);
        this.questionForm.resetCountdown();
        this.questionForm.setPageTitle(Strings.fill(Strings.QUESTION_TITLE, Integer.toString(n + 1)) + string);
        this.questionForm.setText(this.currentQuestionObj.getQuestion());
        if (this.difficulty != 0) {
            this.currentQuestionObj.shuffle();
            this.questionForm.addOption(this.currentQuestionObj.getAnswer(0));
            this.questionForm.addOption(this.currentQuestionObj.getAnswer(1));
            this.questionForm.addOption(this.currentQuestionObj.getAnswer(2));
            return;
        }
        if (this.b != 2) {
            this.currentQuestionObj.shuffle();
            this.questionForm.addOption(this.currentQuestionObj.getAnswer(0));
            this.questionForm.addOption(this.currentQuestionObj.getAnswer(1));
            this.questionForm.addOption(this.currentQuestionObj.getAnswer(2));
            return;
        }
        Random random = new Random(System.currentTimeMillis());
        int n2 = 1;
        if (Math.abs(random.nextInt() % 100) < 50) {
            n2 = 2;
        }
        if (Math.abs(random.nextInt() % 100) < 50) {
            System.out.println(this.currentQuestionObj.toString());
            this.questionForm.addOption(this.currentQuestionObj.getAnswer(0));
            this.questionForm.addOption(this.currentQuestionObj.getAnswer(n2));
            return;
        }
        this.questionForm.addOption(this.currentQuestionObj.getAnswer(n2));
        this.questionForm.addOption(this.currentQuestionObj.getAnswer(0));
        this.currentQuestionObj.setCorrectAnswer(1);
        System.out.println(this.currentQuestionObj.toString());
    }

    public void displayQuizForm() {
        this.createQuestionForm(this.currentQuestionNum);
        this.questionForm.startCountdown();
        this.display.setCurrent((Displayable)this.questionForm);
    }

    public void displayAnswerForm(int n, int n2, boolean bl) {
        String string = Strings.WRONG_LABEL;
        if (bl) {
            string = Strings.RIGHT_LABEL;
        }
        this.currentQuestionObj = this.theQuestions.get(n);
        this.currentQuestionObj.reset();
        String string2 = Strings.SCORE_LABEL + ": " + this.roundScore;
        this.answerForm.reset();
        this.answerForm.setPageTitle(string + "\n" + string2);
        this.answerForm.setText(this.currentQuestionObj.getQuestion());
        this.answerForm.addOption(this.currentQuestionObj.getAnswer(this.currentQuestionObj.getCorrectAnswer()));
        this.answerForm.setSelectedIndex(0);
        this.display.setCurrent((Displayable)this.answerForm);
    }

    public void displayHelperForm(String string, String string2, int n) {
        if (this.sound_enabled) {
            this.soundManager.playSound(this.snds[this.SOUND_START], this.snds_mime[this.SOUND_START]);
        }
        this.helperCanvas.smallFont(false);
        this.b = n;
        this.helperCanvas.setText(string + string2);
        this.helperCanvas.setCommands(Strings.CMD_OK, null);
        this.display.setCurrent((Displayable)this.helperCanvas);
    }

    public void ontoNextQuestion() {
        int n;
        if (this.questionForm != null) {
            this.questionForm.stopCountdown();
        }
        if (this.currentQuestionNum >= 10) {
            return;
        }
        boolean bl = false;
        int n2 = this.currentQuestionObj.getCorrectAnswer();
        if (n2 == (n = this.questionForm.getSelectedIndex())) {
            ++this.roundScore;
            if (this.sound_enabled) {
                this.soundManager.playSound(this.snds[this.SOUND_CORRECT], this.snds_mime[this.SOUND_CORRECT]);
            }
            bl = true;
        } else if (this.sound_enabled) {
            this.soundManager.playSound(this.snds[this.SOUND_WRONG], this.snds_mime[this.SOUND_WRONG]);
        }
        ++this.currentQuestionNum;
        if (this.difficulty == 0) {
            this.displayAnswerForm(this.currentQuestionNum - 1, n2, bl);
            return;
        }
        if (this.currentQuestionNum >= 10) {
            if (this.roundScore == 10) {
                this.theQuestions.saveScores();
            }
            this.displayResultsForm();
            return;
        }
        this.displayQuizForm();
    }

    public void ontoNextRound() {
        this.roundScore = 0;
        this.currentQuestionNum = 0;
        this.b = 3;
        if (this.theQuestions.answeredAllQuestions()) {
            this.displayList();
            return;
        }
        this.display.setCurrent((Displayable)this.loadingScreen);
        this.qloader = null;
        System.gc();
        this.qloader = new QuestionLoader(this, this.theQuestions);
        this.qloader.start();
    }

    public void triggeredEvent(Canvas object) {
        if (object == this.splashScreen) {
            this.a = 1;
            this.display.setCurrent((Displayable)this.loadingScreen);
            object = new Thread(this);
            object.start();
        }
    }

    public void optionCanvasAction(OptionCanvas optionCanvas, int n) {
        if (optionCanvas == this.questionForm) {
            if (n == OptionCanvas.LEFT_SOFTKEY) {
                this.displayList();
                return;
            }
            if (n == OptionCanvas.RIGHT_SOFTKEY) {
                if (this.questionForm.alertOnDisplay()) {
                    this.questionForm.hideAlert();
                    return;
                }
                if (this.questionForm.getCheckedOption() < 0) {
                    if (this.sound_enabled) {
                        this.soundManager.playSound(this.snds[this.SOUND_START], this.snds_mime[this.SOUND_START]);
                    }
                    this.questionForm.displayAlert(Strings.ANSWER_TITLE, Strings.ANSWER_PROMPT);
                    return;
                }
                this.ontoNextQuestion();
                return;
            }
        } else if (optionCanvas == this.helpForm || optionCanvas == this.aboutForm) {
            if (n == OptionCanvas.LEFT_SOFTKEY || n == OptionCanvas.BACK_SOFTKEY) {
                this.displayList();
                return;
            }
        } else if (optionCanvas == this.soundForm) {
            if (n == OptionCanvas.LEFT_SOFTKEY || n == OptionCanvas.BACK_SOFTKEY) {
                this.displaySettingsMenu();
                return;
            }
            if (n == OptionCanvas.RIGHT_SOFTKEY) {
                this.setOptions(this.soundForm.getSelectedIndex());
                this.displaySettingsMenu();
                return;
            }
        } else if (optionCanvas == this.answerForm) {
            if (n == OptionCanvas.LEFT_SOFTKEY || n == OptionCanvas.BACK_SOFTKEY) {
                this.displayList();
                return;
            }
            if (n == OptionCanvas.RIGHT_SOFTKEY) {
                if (this.currentQuestionNum >= 10) {
                    if (this.roundScore == 10) {
                        this.theQuestions.saveScores();
                    }
                    this.displayResultsForm();
                    return;
                }
                if (this.b == 3 && this.currentQuestionNum - this.roundScore == 4) {
                    this.displayHelperForm(Strings.HELPER_TITLE_1, Strings.HELPER_TEXT_1, 2);
                    return;
                }
                if (this.roundScore == 0 && this.currentQuestionNum == 9) {
                    this.displayHelperForm(Strings.HELPER_TITLE_2, Strings.HELPER_TEXT_2, 1);
                    return;
                }
                this.displayQuizForm();
                return;
            }
        } else if (optionCanvas == this.resetForm) {
            if (n == OptionCanvas.LEFT_SOFTKEY || n == OptionCanvas.BACK_SOFTKEY) {
                this.displaySettingsMenu();
                return;
            }
            if (n == OptionCanvas.RIGHT_SOFTKEY) {
                if (this.resetForm.alertOnDisplay()) {
                    this.displaySettingsMenu();
                    this.resetForm.hideAlert();
                    return;
                }
                if (this.resetForm.getSelectedIndex() == 1) {
                    this.theQuestions.resetScores();
                    this.resetForm.displayAlert("Reset Quiz", "Your quiz progress has been reset.");
                    return;
                }
                this.displaySettingsMenu();
                return;
            }
        } else if (optionCanvas == this.difficultyForm) {
            if (n == OptionCanvas.LEFT_SOFTKEY || n == OptionCanvas.BACK_SOFTKEY) {
                this.displaySettingsMenu();
                return;
            }
            if (n == OptionCanvas.RIGHT_SOFTKEY) {
                this.setDifficulty(this.difficultyForm.getSelectedIndex());
                this.displaySettingsMenu();
            }
        }
    }

    public void displayGMGError() {
        this.menu.displayAlert("Network Error", GMG.GMG_CONNECTION_TEXT);
    }

    public void settingsMenuSelect(int n) {
        if (Common.DISABLE_SOUND) {
            ++n;
        }
        switch (n) {
            case 0: {
                this.soundForm.setSelectedIndex(this.sound_enabled ? 0 : 1);
                this.display.setCurrent((Displayable)this.soundForm);
                return;
            }
            case 1: {
                this.difficultyForm.setSelectedIndex(this.difficulty);
                this.display.setCurrent((Displayable)this.difficultyForm);
                return;
            }
            case 2: {
                this.resetForm.setSelectedIndex(0);
                this.display.setCurrent((Displayable)this.resetForm);
            }
        }
    }

    public void displaySettingsMenu() {
        this.display.setCurrent((Displayable)this.settingsMenu);
    }
}

