/*
 * Decompiled with CFR 0.152.
 */
package project;

import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import project.ColorProcessor;
import project.Drawer;

public class FontClass
extends Drawer {
    private Image[] img_font;
    private final int height;
    private final int[][] location;
    private int[][] color;
    private int cerrentColor;

    private FontClass(String FileName, int[][] color) throws IOException {
        InputStream is = this.getClass().getResourceAsStream(FileName);
        if (is == null) {
            throw new IOException();
        }
        int len = 0;
        try {
            len = is.available();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        byte[] temp = new byte[len];
        try {
            is.read(temp);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (is != null) {
            try {
                is.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.height = temp[0];
        this.location = new int[255][];
        int i = 1;
        while ((temp[i] & 0xFF) != 137 || (temp[i + 1] & 0xFF) != 80 || (temp[i + 2] & 0xFF) != 78 || (temp[i + 3] & 0xFF) != 71) {
            this.location[temp[i]] = new int[3];
            this.location[temp[i]][0] = temp[i + 1] & 0xFF;
            this.location[temp[i]][1] = temp[i + 2] & 0xFF;
            this.location[temp[i]][2] = temp[i + 3] & 0xFF;
            i += 4;
        }
        byte[] PNGbyte = new byte[len - i];
        System.arraycopy(temp, i, PNGbyte, 0, len - i);
        if (color != null) {
            this.img_font = new Image[color.length];
            this.color = color;
            int j = 0;
            while (j < this.img_font.length) {
                this.img_font[j] = this.setColor(PNGbyte, color[j]);
                ++j;
            }
        } else {
            this.img_font = new Image[1];
            this.img_font[0] = Image.createImage((byte[])PNGbyte, (int)0, (int)PNGbyte.length);
        }
    }

    public static FontClass factory(String FileName, int[][] color) throws IOException {
        return new FontClass(FileName, color);
    }

    private Image setColor(byte[] PNGbyte, int[] color) {
        byte[] im = null;
        try {
            im = ColorProcessor.ChangeColor(PNGbyte, color);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        if (im != null) {
            im = PNGbyte;
        }
        return Image.createImage((byte[])PNGbyte, (int)0, (int)PNGbyte.length);
    }

    public void setColor(int[] color) {
        int i = 0;
        while (i < this.color.length) {
            if (color == this.color[i]) {
                this.cerrentColor = i;
                return;
            }
            ++i;
        }
        throw new IndexOutOfBoundsException();
    }

    public void setColor(int id) {
        if (id >= this.color.length || id < 0) {
            throw new IndexOutOfBoundsException();
        }
        this.cerrentColor = id;
    }

    public void drawString(Graphics g, String string, int x, int y, int Anchor) {
        this.drawString(g, string, x, y, Anchor, 1);
    }

    public void drawString(Graphics g, String string, int x, int y, int Anchor, int separ) {
        this.testAnchor(Anchor);
        this.drawSLT(g, string, x + this.getDX(this.getWidth(string, separ), Anchor), y + this.getDY(this.height, Anchor), separ);
    }

    private void drawSLT(Graphics g, String string, int x, int y, int separ) throws NullPointerException {
        int[] oc = new int[]{g.getClipX(), g.getClipY(), g.getClipWidth(), g.getClipHeight()};
        int stringW = 0;
        int i = 0;
        while (i < string.length()) {
            try {
                this.setClip(g, this.getAnd(oc[0], oc[1], oc[2], oc[3], x + stringW, y, this.location[string.charAt(i) & Integer.MAX_VALUE][1], this.height));
                g.drawImage(this.img_font[this.cerrentColor], x + stringW - this.location[string.charAt(i) & Integer.MAX_VALUE][0], y - this.location[string.charAt(i) & Integer.MAX_VALUE][2] * this.height, 20);
                stringW += this.location[string.charAt(i) & Integer.MAX_VALUE][1] + separ;
            }
            catch (NullPointerException e) {
                System.out.println("'" + string.charAt(i) + "'" + "(" + i + ")" + " cannot be found in the font.");
            }
            ++i;
        }
        g.setClip(oc[0], oc[1], oc[2], oc[3]);
    }

    public int getWidth(String string, int separ) {
        int res = 0;
        int i = 0;
        while (i < string.length()) {
            try {
                res += this.location[string.charAt(i) & Integer.MAX_VALUE][1] + separ;
            }
            catch (NullPointerException e) {
                System.out.println("'" + string.charAt(i) + "' cannot be found in the font.");
            }
            ++i;
        }
        return res - separ;
    }

    public int getHeight() {
        return this.height;
    }
}

