/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic.screen;

import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;
import sk.inlogic.MainCanvas;
import sk.inlogic.RMSObjects;
import sk.inlogic.Resources;
import sk.inlogic.Sounds;
import sk.inlogic.powV2.PowV2ScoreItem;
import sk.inlogic.screen.IScreen;
import sk.inlogic.screen.ScreenMenu;
import sk.inlogic.screen.ScreenSelectBonusLevel;
import sk.inlogic.screen.ScreenSelectLevel;
import sk.inlogic.text.PreparedText;
import sk.inlogic.util.Keys;
import sk.inlogic.util.Rectangle;

public class ScreenSelectPack
implements IScreen {
    private MainCanvas mainCanvas;
    public static final int COMP_ID_CLASSIC = 0;
    public static final int COMP_ID_BONUS = 1;
    private static final int COMP_ID_SETTINGS = 2;
    private static final int COMP_ID_QUIT = 3;
    public static final int COMP_ID_NONE = 4;
    private static final int TOTAL_COMP_IDS = 5;
    private Rectangle[] rectItems = new Rectangle[5];
    private Rectangle rectDialog;
    private int selectedCompId;
    private int selectorCompId;
    private int interuption = 0;
    private int resource = 0;
    private int resourceFrame = 0;
    private int repeats = 0;
    private int logoAnimation = 0;
    private int fkAnimation = 0;
    private int fkIconAnimation = 0;
    private int buttonAnimationRight = 0;
    private int buttonAnimationLeft = 0;
    private int selectorAnimationRight = 0;
    private int selectorAnimationLeft = 0;
    private boolean activeButton = true;
    PreparedText title;
    private boolean bonusLocked = true;
    boolean check = false;
    private int scoresCount = 0;
    private int count = 0;
    private String[] levelStars = new String[60];
    int cycle = 10;
    int a;
    private boolean releasedTouch = false;
    private int sel = this.selectedCompId;
    private int s = this.selectedCompId;

    public ScreenSelectPack(MainCanvas mainCanvas, int selectedItem) {
        MainCanvas.counterX = 0;
        MainCanvas.counterY = 0;
        MainCanvas.slcPack = 0;
        MainCanvas.slcLvl = 0;
        this.mainCanvas = mainCanvas;
        this.selectedCompId = selectedItem;
        this.selectorCompId = selectedItem;
    }

    public void beforeShow() {
        Resources.loadImages(new int[]{15, 20, 17, 16});
        Resources.loadSprites(new int[]{18, 17, 15, 16, 23, 0, 13});
        Resources.loadGFont(3);
        this.calculatePositions();
        this.title = new PreparedText(Resources.resGFonts[3]);
        this.title.prepareText(Resources.resTexts[0].getHashedString(70), this.rectDialog.width);
        RMSObjects.createRMSConnect(0);
        if (!RMSObjects.rmsConnects[0].load()) {
            RMSObjects.rmsConnects[0].create();
        }
        this.unlockBonusPack();
    }

    public void afterHide() {
        Resources.freeImages(new int[]{15, 20, 17, 16});
        Resources.freeSprites(new int[]{18, 17, 15, 16, 23, 0, 13});
        Resources.freeGFont(3);
    }

    public void beforeInteruption() {
        this.check = MainCanvas.soundManager.IsSoundOn();
        MainCanvas.soundManager.Stop();
        this.interuption = 1;
    }

    public void afterInteruption() {
        if (this.interuption == 0 && MainCanvas.soundManager.IsSoundOn()) {
            MainCanvas.soundManager.Play(Sounds.SOUND_MENU, -1);
        }
    }

    private void calculatePositions() {
        int itemHeight = Resources.resSprs[15].getHeight();
        int itemWidth = Resources.resSprs[15].getWidth();
        int fkWidth = Resources.resSprs[0].getWidth();
        int fkHeight = Resources.resSprs[0].getHeight();
        this.rectDialog = new Rectangle(fkWidth, 0, MainCanvas.WIDTH - (fkWidth << 1), this.mainCanvas.getHeight());
        this.logoAnimation = 0 - Resources.resImgs[16].getHeight();
        int posX = 0;
        int posY = (MainCanvas.HEIGHT >> 1) - (itemHeight << 1);
        posY = Resources.resImgs[16].getHeight();
        this.rectItems[0] = new Rectangle(posX, posY += itemHeight >> 1, this.mainCanvas.getWidth(), itemHeight);
        this.rectItems[1] = new Rectangle(posX, posY += itemHeight, this.mainCanvas.getWidth(), itemHeight);
        this.rectItems[2] = new Rectangle(0, MainCanvas.HEIGHT - fkHeight, itemWidth + (itemWidth >> 1), fkHeight);
        this.rectItems[3] = new Rectangle(MainCanvas.WIDTH - itemWidth - (itemWidth >> 1), MainCanvas.HEIGHT - itemHeight, itemWidth + (itemWidth >> 1), itemHeight);
        this.fkAnimation = this.mainCanvas.getWidth() + Resources.resSprs[16].getWidth();
        this.fkIconAnimation = this.mainCanvas.getWidth() + Resources.resSprs[0].getWidth();
        this.buttonAnimationRight = 0 - this.mainCanvas.getWidth() / Resources.resSprs[16].getWidth() * Resources.resSprs[16].getWidth() - 5;
        this.buttonAnimationLeft = this.mainCanvas.getWidth();
        this.selectorAnimationRight = 0 - Resources.resImgs[17].getWidth();
        this.selectorAnimationLeft = this.mainCanvas.getWidth() + Resources.resImgs[17].getWidth();
    }

    private void unlockBonusPack() {
        Vector scores = RMSObjects.localScores.getScoresForGame(0);
        if (scores != null) {
            this.scoresCount = scores.size();
        }
        PowV2ScoreItem scoreItem = null;
        for (int i = 0; i < 60; ++i) {
            if (i < this.scoresCount) {
                scoreItem = (PowV2ScoreItem)scores.elementAt(i);
                this.levelStars[i] = Integer.toString(scoreItem.scoreValue);
                ++this.count;
                continue;
            }
            this.levelStars[i] = null;
        }
        if (this.levelStars[this.levelStars.length - 1] != null) {
            this.levelStars[this.levelStars.length - 1] = Integer.toString(scoreItem.scoreValue);
            this.bonusLocked = this.levelStars[this.levelStars.length - 1].equals("");
        }
    }

    private void reset() {
        this.logoAnimation = 0;
        this.fkAnimation = 0;
        this.fkIconAnimation = 0;
        this.buttonAnimationRight = 0;
        this.buttonAnimationLeft = 0;
        this.selectorAnimationRight = 0;
        this.selectorAnimationLeft = 0;
    }

    public void update(long lastRunLenght) {
        this.activeButton = true;
    }

    private void logoAnimation(boolean show) {
        block3: {
            block2: {
                if (!show) break block2;
                while (this.logoAnimation != this.rectItems[0].y / 2) {
                    ++this.logoAnimation;
                    this.mainCanvas.repaint();
                }
                break block3;
            }
            if (show) break block3;
            while (this.logoAnimation != 0 - this.rectItems[0].y / 2) {
                --this.logoAnimation;
                this.mainCanvas.repaint();
            }
        }
    }

    private void fkAnimation(boolean show) {
        if (show) {
            while (this.fkAnimation != this.mainCanvas.getWidth() - Resources.resSprs[16].getWidth()) {
                --this.fkAnimation;
                this.mainCanvas.repaint();
            }
            while (this.fkIconAnimation != this.mainCanvas.getWidth() - Resources.resSprs[0].getWidth()) {
                --this.fkIconAnimation;
                this.mainCanvas.repaint();
            }
        } else {
            while (this.fkIconAnimation != this.mainCanvas.getWidth()) {
                ++this.fkIconAnimation;
                this.mainCanvas.repaint();
            }
            while (this.fkAnimation != this.mainCanvas.getWidth()) {
                ++this.fkAnimation;
                this.mainCanvas.repaint();
            }
        }
    }

    private void buttonAnimation(boolean show) {
        if (show) {
            while (this.buttonAnimationRight != 5) {
                ++this.buttonAnimationRight;
                if (this.buttonAnimationLeft != 5) {
                    --this.buttonAnimationLeft;
                }
                this.mainCanvas.repaint();
            }
        } else {
            while (this.buttonAnimationRight != this.mainCanvas.getWidth() + 5) {
                ++this.buttonAnimationRight;
                if (this.buttonAnimationLeft != 0 - this.mainCanvas.getWidth() + 5) {
                    --this.buttonAnimationLeft;
                }
                this.mainCanvas.repaint();
            }
        }
    }

    private void selectorAnimation(boolean show) {
        this.activeButton = true;
    }

    public void paint(Graphics g) {
        g.setColor(0, 20, 80);
        g.fillRect(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
        this.paintBody(g);
        g.drawImage(Resources.resImgs[16], this.mainCanvas.getWidth() / 2, 0, 17);
        Image border = Resources.resImgs[15];
        this.paintDialogItems(g);
        this.paintFK(g);
    }

    private void paintTop(Graphics g) {
        Sprite time = Resources.resSprs[15];
        Sprite bg = Resources.resSprs[16];
        Image light = Resources.resImgs[17];
        Sprite icons = Resources.resSprs[17];
        Image border = Resources.resImgs[15];
        int posY = time.getHeight() / 2 - bg.getHeight() / 2;
        int animFrame = 0;
        animFrame = 1;
        Rectangle titleRect = new Rectangle(5 + bg.getWidth() / 2 + time.getWidth(), posY, MainCanvas.WIDTH, bg.getHeight());
        g.drawImage(light, 0, 0, 20);
        g.drawImage(light, 0, posY + bg.getHeight(), 20);
        bg.setFrame(0);
        bg.setPosition(5, posY);
        bg.paint(g);
        bg.setFrame(1);
        for (int i = bg.getWidth(); i < MainCanvas.WIDTH - 5 - bg.getWidth(); i += bg.getWidth()) {
            bg.setPosition(i, posY);
            bg.paint(g);
        }
        this.title.drawText(g, titleRect, 0, 6);
        bg.setFrame(2);
        bg.setPosition(MainCanvas.WIDTH - bg.getWidth() - 5, posY);
        bg.paint(g);
        time.setFrame(animFrame);
        time.setPosition(5 + bg.getWidth() / 2, 0);
        time.paint(g);
        icons.setFrame(2);
        icons.setPosition(5 + bg.getWidth() / 2 + time.getWidth() / 2 - icons.getWidth() / 2, posY);
        icons.paint(g);
        g.drawImage(border, 0, this.rectDialog.y + this.rectDialog.height - border.getHeight(), 20);
        g.drawImage(border, 0, this.rectDialog.y - border.getHeight(), 20);
    }

    private void paintBody(Graphics g) {
        g.setColor(10, 60, 120);
        g.setColor(10, 60, 120);
    }

    private void paintBottom(Graphics g) {
        Image border = Resources.resImgs[15];
        Sprite s = Resources.resSprs[18];
        s.setFrame(0);
        s.setPosition(this.mainCanvas.getWidth() / 2 - s.getWidth() / 2, this.mainCanvas.getHeight() - Resources.resSprs[18].getHeight());
        s.paint(g);
        g.drawImage(border, 0, this.mainCanvas.getHeight() - Resources.resSprs[18].getHeight(), 20);
    }

    private void paintDialogItems(Graphics g) {
        int i;
        Sprite sprBtns1 = Resources.resSprs[15];
        Sprite botom = Resources.resSprs[16];
        Sprite icons = Resources.resSprs[17];
        this.title.prepareText(Resources.resTexts[0].getHashedString(70), this.rectDialog.width);
        int animFrame = 1;
        int posY = sprBtns1.getHeight() / 2 - botom.getHeight() / 2;
        animFrame = 1;
        Image light = Resources.resImgs[17];
        botom = this.selectorCompId == 0 ? Resources.resSprs[16] : Resources.resSprs[23];
        botom.setFrame(0);
        botom.setPosition(5, this.rectItems[0].y + posY);
        botom.paint(g);
        botom.setFrame(1);
        for (i = botom.getWidth(); i < MainCanvas.WIDTH - 5 - botom.getWidth(); i += botom.getWidth()) {
            if (i > MainCanvas.WIDTH - 5 - botom.getWidth() - botom.getWidth() / 4) continue;
            botom.setPosition(5 + i, this.rectItems[0].y + posY);
            botom.paint(g);
        }
        botom.setFrame(2);
        botom.setPosition(5 + MainCanvas.WIDTH - botom.getWidth() - 10, this.rectItems[0].y + posY);
        botom.paint(g);
        botom = this.selectorCompId == 1 ? Resources.resSprs[16] : Resources.resSprs[23];
        botom.setFrame(0);
        botom.setPosition(5, this.rectItems[1].y + posY);
        botom.paint(g);
        botom.setFrame(1);
        for (i = botom.getWidth(); i < MainCanvas.WIDTH - 5 - botom.getWidth(); i += botom.getWidth()) {
            if (i > MainCanvas.WIDTH - 5 - botom.getWidth() - botom.getWidth() / 4) continue;
            botom.setPosition(5 + i, this.rectItems[1].y + posY);
            botom.paint(g);
        }
        botom.setFrame(2);
        botom.setPosition(5 + MainCanvas.WIDTH - botom.getWidth() - 10, this.rectItems[1].y + posY);
        botom.paint(g);
        sprBtns1.setFrame(0 + (this.selectorCompId == 0 ? animFrame : 0));
        sprBtns1.setPosition(5 + botom.getWidth() / 2, this.rectItems[0].y);
        sprBtns1.paint(g);
        Rectangle r = new Rectangle(5 + botom.getWidth() / 2 + sprBtns1.getWidth(), this.rectItems[0].y + posY, MainCanvas.WIDTH, botom.getHeight());
        Rectangle l = new Rectangle(5 + botom.getWidth() / 2 + sprBtns1.getWidth(), this.rectItems[0].y + posY, MainCanvas.WIDTH, botom.getHeight());
        this.title.drawText(g, r, 0, 6);
        icons.setFrame(0);
        icons.setPosition(5 + botom.getWidth() / 2 + sprBtns1.getWidth() / 2 - icons.getWidth() / 2, this.rectItems[0].y + sprBtns1.getHeight() / 2 - icons.getHeight() / 2);
        icons.paint(g);
        sprBtns1.setFrame(0 + (this.selectorCompId == 1 ? animFrame : 0));
        sprBtns1.setPosition(5 + botom.getWidth() / 2, this.rectItems[1].y);
        sprBtns1.paint(g);
        this.title.prepareText(Resources.resTexts[0].getHashedString(71), this.rectDialog.width);
        l.y = this.rectItems[1].y + posY;
        this.title.drawText(g, l, 0, 6);
        if (this.bonusLocked) {
            g.drawImage(Resources.resImgs[20], 5 + botom.getWidth() / 2 + sprBtns1.getWidth() / 2 - Resources.resImgs[20].getWidth() / 2, this.rectItems[1].y + sprBtns1.getHeight() / 2 - Resources.resImgs[20].getHeight() / 2, 20);
        } else {
            icons.setFrame(0);
            icons.setPosition(5 + botom.getWidth() / 2 + sprBtns1.getWidth() / 2 - icons.getWidth() / 2, this.rectItems[1].y + sprBtns1.getHeight() / 2 - icons.getHeight() / 2);
            icons.paint(g);
        }
        Sprite sprKEY = Resources.resSprs[13];
    }

    private void paintFK(Graphics g) {
        Sprite funKey = Resources.resSprs[16];
        Sprite fk = Resources.resSprs[0];
        funKey.setFrame(2);
        funKey.setPosition(0, this.mainCanvas.getHeight() - funKey.getHeight());
        funKey.paint(g);
        fk.setFrame(1);
        fk.setPosition(0, this.mainCanvas.getHeight() - funKey.getHeight() + funKey.getHeight() / 2 - fk.getHeight() / 2);
        fk.paint(g);
        funKey.setFrame(1);
        funKey.setPosition(0 - funKey.getWidth() / 2, this.mainCanvas.getHeight() - funKey.getHeight());
        funKey.paint(g);
        funKey.setFrame(2);
        funKey.setPosition(funKey.getWidth() / 2, this.mainCanvas.getHeight() - funKey.getHeight());
        funKey.paint(g);
        fk.setFrame(1);
        fk.setPosition(0, this.mainCanvas.getHeight() - funKey.getHeight() + funKey.getHeight() / 2 - fk.getHeight() / 2);
        fk.paint(g);
        funKey.setFrame(1);
        funKey.setPosition(this.mainCanvas.getWidth() - funKey.getWidth() / 2, this.mainCanvas.getHeight() - funKey.getHeight());
        funKey.paint(g);
        funKey.setFrame(0);
        funKey.setPosition(this.mainCanvas.getWidth() - funKey.getWidth() - funKey.getWidth() / 2, this.mainCanvas.getHeight() - funKey.getHeight());
        funKey.paint(g);
        fk.setFrame(9);
        fk.setPosition(this.mainCanvas.getWidth() - Resources.resSprs[0].getWidth(), this.mainCanvas.getHeight() - funKey.getHeight() + funKey.getHeight() / 2 - fk.getHeight() / 2);
        fk.paint(g);
    }

    public void keyPressed(int keyCode) {
        if (this.interuption == 1) {
            this.interuption = 0;
            this.afterInteruption();
        }
    }

    public void keyReleased(int keyCode) {
        this.a = keyCode;
        if (this.activeButton) {
            if (Keys.isFKLeftCode(keyCode)) {
                switch (this.selectedCompId) {
                    case 0: {
                        this.mainCanvas.changeLastActiveScreen(new ScreenSelectLevel(this.mainCanvas, 0));
                        break;
                    }
                    case 1: {
                        if (this.bonusLocked) break;
                        this.mainCanvas.changeLastActiveScreen(new ScreenSelectBonusLevel(this.mainCanvas, 0));
                    }
                }
            } else if (Keys.isFKRightCode(keyCode)) {
                this.mainCanvas.changeLastActiveScreen(new ScreenMenu(this.mainCanvas, 0));
            } else {
                if (keyCode != 49 && keyCode != 51 && keyCode != 57 && keyCode != 55) {
                    switch (this.selectedCompId) {
                        case 0: {
                            if (Keys.isActionGeneratedByKey(1, keyCode)) {
                                this.selectedCompId = 1;
                                break;
                            }
                            if (Keys.isActionGeneratedByKey(2, keyCode)) {
                                this.selectedCompId = 1;
                                break;
                            }
                            if (!Keys.isActionGeneratedByKey(5, keyCode)) break;
                            this.mainCanvas.changeLastActiveScreen(new ScreenSelectLevel(this.mainCanvas, 0));
                            break;
                        }
                        case 1: {
                            if (Keys.isActionGeneratedByKey(1, keyCode)) {
                                this.selectedCompId = 0;
                                break;
                            }
                            if (Keys.isActionGeneratedByKey(2, keyCode)) {
                                this.selectedCompId = 0;
                                break;
                            }
                            if (!Keys.isActionGeneratedByKey(5, keyCode) || this.bonusLocked) break;
                            this.mainCanvas.changeLastActiveScreen(new ScreenSelectBonusLevel(this.mainCanvas, 0));
                        }
                    }
                }
                this.selectorCompId = this.selectedCompId;
                this.a = this.selectedCompId;
            }
            this.mainCanvas.repaint();
        }
    }

    public void pointerPressed(int x, int y) {
        for (int i = 0; i < this.rectItems.length; ++i) {
            if (i == 4) {
                this.selectorCompId = this.selectedCompId = 4;
                this.mainCanvas.repaint();
                break;
            }
            if (i == 4 || !this.rectItems[i].contains(x, y)) continue;
            this.sel = i <= 4 ? i : this.sel;
            this.selectedCompId = i;
            this.s = i;
            switch (this.selectedCompId) {
                case 2: {
                    Keys.keyPressed(-6);
                    break;
                }
                case 3: {
                    Keys.keyPressed(-7);
                    break;
                }
                default: {
                    this.selectorCompId = i;
                    this.a = this.selectedCompId;
                    Keys.keyPressed(53);
                    this.mainCanvas.repaint();
                    break;
                }
            }
            break;
        }
    }

    public void pointerDragged(int x, int y) {
        if (this.selectedCompId != 4) {
            if (!this.rectItems[this.selectedCompId].contains(x, y)) {
                switch (this.selectedCompId) {
                    case 2: {
                        Keys.keyReleased(-6);
                        break;
                    }
                    case 3: {
                        Keys.keyReleased(-7);
                        break;
                    }
                    default: {
                        Keys.keyReleased(53);
                        break;
                    }
                }
            }
        } else {
            this.selectorCompId = this.selectedCompId = 4;
            this.mainCanvas.repaint();
        }
    }

    public void pointerReleased(int x, int y) {
        if (this.selectedCompId != 4) {
            switch (this.selectedCompId) {
                case 3: {
                    this.mainCanvas.changeLastActiveScreen(new ScreenMenu(this.mainCanvas, this.selectorCompId));
                    if (!Keys.isKeyPressed(-7)) break;
                    this.keyReleased(-7);
                    Keys.keyReleased(-7);
                    break;
                }
                default: {
                    this.activeButton = true;
                    if (!Keys.isKeyPressed(53)) break;
                    this.keyReleased(53);
                    Keys.keyReleased(53);
                }
            }
        }
        this.selectorCompId = this.selectedCompId = 4;
        this.mainCanvas.repaint();
    }
}

