/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic.screen;

import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;
import sk.inlogic.MainCanvas;
import sk.inlogic.Resources;
import sk.inlogic.Sounds;
import sk.inlogic.screen.IScreen;
import sk.inlogic.screen.ScreenMenu;
import sk.inlogic.text.PreparedText;
import sk.inlogic.util.Keys;
import sk.inlogic.util.Rectangle;

public class ScreenInstructions
implements IScreen {
    private MainCanvas mainCanvas;
    private boolean needRepaint;
    private boolean scrollUP = false;
    private boolean scrollDOWN = true;
    private static final int COMP_ID_BACK = 0;
    private static final int COMP_ID_ARR_UP = 1;
    private static final int COMP_ID_ARR_DOWN = 2;
    private static final int TOTAL_COMP_IDS = 3;
    private int interuption = 0;
    private Rectangle[] rectItems = new Rectangle[3];
    private Rectangle rectDialog;
    private Rectangle rectText;
    private int selectedCompId;
    private static PreparedText preparedText;
    private int textOffsetY;
    private int resource = 0;
    private int resourceFrame = 0;
    private int repeats = 0;
    private int resourceFrame1 = 0;
    private int repeats1 = 0;
    private PreparedText title;
    private int fkAnimation = 0;
    private int fkIconAnimation = 0;
    private int logoAnimation = 0;
    private int textAnimation = 0;
    private int bottomShow = 0;
    private int bottomHide = 0;
    private int bottomAnimationS = 0;
    private int bottomAnimationH = 0;
    private int topAnimation = 0;
    private int topMove = 0;
    boolean bottom = false;
    private int bodyAnimation2 = 0;
    private int bodyAnimation = 0;
    int pomocna = 0;
    int pomocna2 = 0;
    int cycle = 10;
    int textAnimation2 = 0;
    private int deltaY = 0;
    private boolean checker = false;
    int a;

    public ScreenInstructions(MainCanvas mainCanvas) {
        this.mainCanvas = mainCanvas;
        this.resourceFrame = 0;
    }

    public void beforeShow() {
        Resources.loadImages(new int[]{15, 17});
        Resources.loadSprites(new int[]{19, 17, 15, 16, 18, 16, 0});
        Resources.loadGFont(3);
        this.calculatePositions();
        Resources.loadText(0);
        this.textOffsetY = 0;
        if (Resources.sysFont) {
            preparedText = new PreparedText(Font.getDefaultFont());
            preparedText.setFontColor(13813276);
        } else {
            Resources.loadGFont(3);
            preparedText = new PreparedText(Resources.resGFonts[3]);
        }
        String controls = Resources.resTexts[0].getHashedString(16);
        preparedText.prepareText(Resources.resTexts[0].getHashedString(1) + "\n\n" + controls + "\n\n" + Resources.resTexts[0].getHashedString(18), this.rectText.width);
        preparedText.setLineHeightCorrection(-2);
        this.title = new PreparedText(Resources.resGFonts[3]);
        this.title.prepareText(Resources.resTexts[0].getHashedString(22), this.rectText.width);
    }

    public void afterHide() {
        Resources.freeImages(new int[]{15, 17});
        Resources.freeSprites(new int[]{19, 17, 15, 16, 18, 16, 0});
        Resources.freeGFont(3);
    }

    public void beforeInteruption() {
        MainCanvas.soundManager.Stop();
        this.interuption = 1;
    }

    public void afterInteruption() {
        if (this.interuption == 0 && MainCanvas.soundManager.IsSoundOn()) {
            MainCanvas.soundManager.Play(Sounds.SOUND_MENU, -1);
        }
    }

    private void calculatePositions() {
        int fkWidth = Resources.resSprs[0].getWidth();
        int fkHeight = Resources.resSprs[0].getHeight();
        int itemWidth = Resources.resSprs[15].getWidth();
        int itemHeight = Resources.resSprs[15].getHeight();
        int sprArrwUpDownWidth = Resources.resSprs[19].getWidth();
        int sprArrwUpDownHeight = Resources.resSprs[19].getHeight();
        this.rectDialog = new Rectangle(0, Resources.resSprs[15].getHeight() + Resources.resImgs[15].getHeight(), MainCanvas.WIDTH, MainCanvas.HEIGHT - Resources.resSprs[18].getHeight() - Resources.resSprs[15].getHeight());
        this.rectItems[0] = new Rectangle(MainCanvas.WIDTH - itemWidth - (itemWidth >> 1), MainCanvas.HEIGHT - itemHeight, itemWidth + (itemWidth >> 1), itemHeight);
        int textMarginLeft = 16;
        this.rectText = new Rectangle(this.rectDialog.x + textMarginLeft, this.rectDialog.y + Resources.resImgs[15].getHeight() + sprArrwUpDownHeight, this.rectDialog.width - (textMarginLeft << 1) - 4, this.rectDialog.height - fkHeight * 2);
        int dialogCenterX = this.rectDialog.getCenterX();
        this.rectItems[1] = new Rectangle(dialogCenterX - (sprArrwUpDownWidth >> 1), this.rectText.y - (sprArrwUpDownHeight << 1), sprArrwUpDownWidth, sprArrwUpDownHeight << 1);
        this.rectItems[2] = new Rectangle(dialogCenterX - (sprArrwUpDownWidth >> 1), this.rectText.getBottom(), sprArrwUpDownWidth, sprArrwUpDownHeight << 1);
        this.fkAnimation = this.mainCanvas.getWidth() + Resources.resSprs[16].getWidth();
        this.fkIconAnimation = this.mainCanvas.getWidth() + Resources.resSprs[0].getWidth();
        this.bodyAnimation = this.rectDialog.y + this.rectDialog.height;
        this.bottomAnimationH = this.bottomHide = this.mainCanvas.getHeight();
        this.bottomAnimationS = this.bottomShow = this.mainCanvas.getHeight() - Resources.resSprs[18].getHeight();
        this.topAnimation = 0 - Resources.resSprs[16].getHeight();
        this.bodyAnimation = this.rectDialog.y + this.rectDialog.height;
        this.textAnimation = this.bottomAnimationS;
        this.pomocna = this.rectText.y;
        this.pomocna2 = this.rectText.y = this.rectText.y + this.rectText.height + 2 * Resources.resGFonts[3].getHeight();
    }

    public void update(long lastRunLenght) {
        if (Keys.isKeyPressed(-7)) {
            this.scrollDOWN = false;
            this.scrollUP = false;
            this.mainCanvas.repaint();
        }
        this.needRepaint = false;
        this.textMove();
        if (this.needRepaint) {
            this.mainCanvas.repaint();
        }
    }

    private void textAnimation(boolean show) {
        if (show) {
            while (this.rectText.y != this.pomocna) {
                --this.rectText.y;
                this.mainCanvas.repaint();
            }
        } else {
            while (this.rectText.y != this.mainCanvas.getHeight()) {
                ++this.rectText.y;
                this.mainCanvas.repaint();
            }
        }
    }

    private void topAnimationShow() {
        while (this.topAnimation != 0) {
            ++this.topAnimation;
            this.mainCanvas.repaint();
        }
    }

    private void topAnimationHide() {
        while (this.topAnimation != 0 - Resources.resSprs[15].getHeight()) {
            --this.topAnimation;
            this.mainCanvas.repaint();
        }
    }

    private void bodyAnimationShow() {
        while (this.bodyAnimation != this.rectDialog.y) {
            --this.bodyAnimation;
            ++this.bodyAnimation2;
            this.mainCanvas.repaint();
        }
    }

    private void bodyAnimationHide() {
        while (this.bodyAnimation < this.bottomAnimationS) {
            ++this.bodyAnimation;
            --this.bodyAnimation2;
            this.mainCanvas.repaint();
        }
        this.bottom = false;
    }

    private void bottomAnimationShow() {
        while (this.bottomHide != this.bottomAnimationS) {
            --this.bottomHide;
            this.mainCanvas.repaint();
        }
        this.bottom = true;
    }

    private void bottomAnimationHide() {
        while (this.bottomHide != this.bottomAnimationH) {
            ++this.bottomHide;
            this.mainCanvas.repaint();
        }
    }

    private void fkAnimation(boolean show) {
        if (show) {
            while (this.fkAnimation != this.mainCanvas.getWidth() - Resources.resSprs[16].getWidth()) {
                --this.fkAnimation;
                this.mainCanvas.repaint();
            }
            while (this.fkIconAnimation != this.mainCanvas.getWidth() - Resources.resSprs[0].getWidth()) {
                --this.fkIconAnimation;
                this.mainCanvas.repaint();
            }
        } else {
            while (this.fkIconAnimation != this.mainCanvas.getWidth()) {
                ++this.fkIconAnimation;
                this.mainCanvas.repaint();
            }
            while (this.fkAnimation != this.mainCanvas.getWidth()) {
                ++this.fkAnimation;
                this.mainCanvas.repaint();
            }
        }
    }

    private void textMove() {
        if (Keys.isActionPressed(1)) {
            if (Resources.sysFont) {
                this.textOffsetY -= Font.getDefaultFont().getHeight() >> 1;
                this.scrollUP = true;
                this.scrollDOWN = true;
            } else {
                this.textOffsetY -= Resources.resGFonts[3].getHeight() >> 1;
                this.scrollUP = true;
                this.scrollDOWN = true;
            }
            if (this.textOffsetY < 0) {
                this.textOffsetY = 0;
                this.scrollUP = false;
                this.scrollDOWN = true;
            }
            this.needRepaint = true;
        } else if (Keys.isActionPressed(2)) {
            int maxOffsetY = preparedText.getTextHeight() - this.rectText.height;
            if (Resources.sysFont) {
                this.textOffsetY += Font.getDefaultFont().getHeight() >> 1;
                this.scrollUP = true;
                this.scrollDOWN = true;
            } else {
                this.textOffsetY += Resources.resGFonts[3].getHeight() >> 1;
                this.scrollUP = true;
                this.scrollDOWN = true;
            }
            if (this.textOffsetY > maxOffsetY) {
                this.textOffsetY = maxOffsetY;
                this.scrollUP = true;
                this.scrollDOWN = false;
            }
            this.needRepaint = true;
        }
    }

    public void paint(Graphics g) {
        g.setColor(0, 20, 80);
        g.fillRect(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
        this.paintBody(g);
        this.paintDialog(g);
        this.paintTop(g);
        this.paintBottom(g);
        this.paintFK(g);
    }

    private void paintBottom(Graphics g) {
        Image border = Resources.resImgs[15];
        g.drawImage(border, 0, this.rectDialog.y - border.getHeight(), 20);
        Sprite s = Resources.resSprs[18];
        s.setFrame(0);
        s.setPosition(this.mainCanvas.getWidth() / 2 - s.getWidth() / 2, this.mainCanvas.getHeight() - Resources.resSprs[18].getHeight());
        s.paint(g);
        g.drawImage(border, 0, this.rectDialog.y + this.rectDialog.height - border.getHeight(), 20);
    }

    private void paintBody(Graphics g) {
        g.setColor(10, 60, 120);
        g.fillRect(this.rectDialog.x, this.rectDialog.y, this.rectDialog.width, this.rectDialog.height);
    }

    private void paintTop(Graphics g) {
        Sprite time = Resources.resSprs[15];
        Sprite bg = Resources.resSprs[16];
        Image light = Resources.resImgs[17];
        Sprite icons = Resources.resSprs[17];
        Image border = Resources.resImgs[15];
        Rectangle tit = new Rectangle();
        boolean animFrame = false;
        int posY = time.getHeight() / 2 - bg.getHeight() / 2;
        Rectangle titleRect = new Rectangle(5 + bg.getWidth() / 2 + time.getWidth(), posY, MainCanvas.WIDTH, bg.getHeight());
        g.drawImage(light, 0, 0, 20);
        g.drawImage(light, 0, posY + bg.getHeight(), 20);
        bg.setFrame(0);
        bg.setPosition(5, posY);
        bg.paint(g);
        bg.setFrame(1);
        for (int i = bg.getWidth(); i < MainCanvas.WIDTH - 5 - bg.getWidth(); i += bg.getWidth()) {
            bg.setPosition(i, posY);
            bg.paint(g);
        }
        this.title.drawText(g, titleRect, 0, 6);
        bg.setFrame(2);
        bg.setPosition(MainCanvas.WIDTH - bg.getWidth() - 5, posY);
        bg.paint(g);
        time.setFrame(1);
        time.setPosition(5 + bg.getWidth() / 2, 0);
        time.paint(g);
        icons.setFrame(1);
        icons.setPosition(5 + bg.getWidth() / 2 + time.getWidth() / 2 - icons.getWidth() / 2, posY);
        icons.paint(g);
        g.drawImage(border, 0, this.rectDialog.y + this.rectDialog.height - border.getHeight(), 20);
    }

    private void updateArrow() {
        if (!this.checker) {
            if (this.deltaY < 4) {
                ++this.deltaY;
            } else if (this.deltaY == 4) {
                this.checker = true;
            }
        } else if (this.deltaY > 0) {
            --this.deltaY;
        } else if (this.deltaY == 0) {
            this.checker = false;
        }
        this.mainCanvas.repaint();
    }

    private void paintDialog(Graphics g) {
        this.paintDialogItems(g);
    }

    private void paintDialogItems(Graphics g) {
        if (preparedText.getTextHeight() >= this.rectText.height) {
            Sprite sprArrwUpDown = Resources.resSprs[19];
            if (this.scrollUP) {
                sprArrwUpDown.setFrame(0);
                sprArrwUpDown.setTransform(1);
                sprArrwUpDown.setPosition(this.rectItems[1].x, this.rectItems[1].getBottom() - sprArrwUpDown.getHeight() - this.deltaY);
                sprArrwUpDown.paint(g);
            }
            if (this.scrollDOWN) {
                sprArrwUpDown.setFrame(0);
                sprArrwUpDown.setTransform(0);
                sprArrwUpDown.setPosition(this.rectItems[2].x, this.rectItems[2].y + this.deltaY);
                sprArrwUpDown.paint(g);
            }
        }
        this.rectText.y = this.pomocna;
        preparedText.drawText(g, this.rectText, this.textOffsetY, 20);
    }

    private void paintFK(Graphics g) {
        Sprite funKey = Resources.resSprs[16];
        Sprite fk = Resources.resSprs[0];
        funKey.setFrame(1);
        funKey.setPosition(this.mainCanvas.getWidth() - funKey.getWidth() / 2, this.mainCanvas.getHeight() - funKey.getHeight());
        funKey.paint(g);
        funKey.setFrame(0);
        funKey.setPosition(this.mainCanvas.getWidth() - funKey.getWidth() - funKey.getWidth() / 2, this.mainCanvas.getHeight() - funKey.getHeight());
        funKey.paint(g);
        fk.setFrame(9);
        fk.setPosition(this.mainCanvas.getWidth() - Resources.resSprs[0].getWidth(), this.mainCanvas.getHeight() - funKey.getHeight() + funKey.getHeight() / 2 - fk.getHeight() / 2);
        fk.paint(g);
        funKey.setFrame(0);
        funKey.setPosition(this.fkAnimation, this.mainCanvas.getHeight() - funKey.getHeight());
        funKey.paint(g);
        fk.setFrame(9);
        fk.setPosition(this.fkIconAnimation, this.mainCanvas.getHeight() - funKey.getHeight() + funKey.getHeight() / 2 - fk.getHeight() / 2);
        fk.paint(g);
    }

    public void startAnimation(int repeat) {
        this.repeats = repeat;
        this.resourceFrame = 0;
    }

    public void keyPressed(int keyCode) {
        if (this.interuption == 1) {
            this.interuption = 0;
            this.afterInteruption();
        }
        if (keyCode == 49 || keyCode == 51 || keyCode == 57 || keyCode == 55) {
            // empty if block
        }
        this.mainCanvas.repaint();
    }

    public void keyReleased(int keyCode) {
        this.a = keyCode;
        if (keyCode != 49 && keyCode != 51 && keyCode != 57 && keyCode != 55 && Keys.isFKRightCode(keyCode)) {
            this.mainCanvas.changeLastActiveScreen(new ScreenMenu(this.mainCanvas, 1));
            this.mainCanvas.repaint();
        }
    }

    public void pointerPressed(int x, int y) {
        block5: for (int i = 0; i < this.rectItems.length; ++i) {
            if (!this.rectItems[i].contains(x, y)) continue;
            this.selectedCompId = i;
            switch (this.selectedCompId) {
                case 0: {
                    Keys.keyPressed(-7);
                    continue block5;
                }
                case 1: {
                    Keys.keyPressed(50);
                    continue block5;
                }
                case 2: {
                    Keys.keyPressed(56);
                    continue block5;
                }
                default: {
                    this.mainCanvas.keyPressed(53);
                }
            }
        }
    }

    public void pointerDragged(int x, int y) {
        if (!this.rectItems[this.selectedCompId].contains(x, y)) {
            switch (this.selectedCompId) {
                case 0: {
                    Keys.keyReleased(-7);
                    break;
                }
                default: {
                    Keys.keyReleased(53);
                }
            }
        }
        if (y > MainCanvas.HEIGHT / 2 && y < MainCanvas.HEIGHT - Resources.resSprs[0].getHeight()) {
            if (x >= this.rectDialog.x && x <= this.rectDialog.x + this.rectDialog.width) {
                this.dragDown();
            }
        } else if (y < MainCanvas.HEIGHT / 2 && y > 0 + Resources.resSprs[0].getHeight() && x >= this.rectDialog.x && x <= this.rectDialog.x + this.rectDialog.width) {
            this.dragUp();
        }
    }

    public void dragUp() {
        if (Resources.sysFont) {
            this.textOffsetY -= Font.getDefaultFont().getHeight() >> 1;
            this.scrollUP = true;
            this.scrollDOWN = true;
        } else {
            this.textOffsetY -= Resources.resGFonts[3].getHeight() >> 1;
            this.scrollUP = true;
            this.scrollDOWN = true;
        }
        if (this.textOffsetY < 0) {
            this.textOffsetY = 0;
            this.scrollUP = false;
            this.scrollDOWN = true;
        }
        this.needRepaint = true;
        this.mainCanvas.repaint();
    }

    public void dragDown() {
        int maxOffsetY = preparedText.getTextHeight() - this.rectText.height;
        if (Resources.sysFont) {
            this.textOffsetY += Font.getDefaultFont().getHeight() >> 1;
            this.scrollUP = true;
            this.scrollDOWN = true;
        } else {
            this.textOffsetY += Resources.resGFonts[3].getHeight() >> 1;
            this.scrollUP = true;
            this.scrollDOWN = true;
        }
        if (this.textOffsetY > maxOffsetY) {
            this.textOffsetY = maxOffsetY;
            this.scrollUP = true;
            this.scrollDOWN = false;
        }
        this.needRepaint = true;
        this.mainCanvas.repaint();
    }

    public void pointerReleased(int x, int y) {
        switch (this.selectedCompId) {
            case 0: {
                if (!Keys.isKeyPressed(-7)) break;
                this.keyReleased(-7);
                Keys.keyReleased(-7);
                break;
            }
            case 1: {
                if (!Keys.isKeyPressed(50)) break;
                this.keyReleased(50);
                Keys.keyReleased(50);
                break;
            }
            case 2: {
                if (!Keys.isKeyPressed(56)) break;
                this.keyReleased(56);
                Keys.keyReleased(56);
                break;
            }
            default: {
                if (Keys.isKeyPressed(50)) {
                    this.keyReleased(50);
                    Keys.keyReleased(50);
                }
                if (Keys.isKeyPressed(56)) {
                    this.keyReleased(56);
                    Keys.keyReleased(56);
                }
                if (!Keys.isKeyPressed(53)) break;
                this.keyReleased(53);
                Keys.keyReleased(53);
            }
        }
    }
}

