/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Random;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import sk.inlogic.Jewel;
import sk.inlogic.MainCanvas;
import sk.inlogic.Resources;
import sk.inlogic.Tile;
import sk.inlogic.rms.RMSHandler;
import sk.inlogic.util.RandomNum;
import sk.inlogic.util.Rectangle;

public class Game
implements RMSHandler {
    public static final int MODE_MOVES = 0;
    public static final int MODE_TIME_ATTACK = 1;
    public static final int MODE_ESCAPE = 2;
    public static final int MODE_FALL = 3;
    public static final int MODE_MIXED_TIME_AND_BLOCKS = 4;
    public static final int MODE_BLOCK = 5;
    public static final int MODE_MIXED_TIME_AND_ESCAPE = 6;
    public static final int MODE_MIXED_TIME_AND_MOVES = 7;
    public static final int MODE_ENDLESS = 20;
    public static final int MODE_ACTION = 60;
    public static final int MODE_MIXED = 8;
    public static final int JEWELSINROW = 8;
    public static final int JEWELSCOUNT = 64;
    private static final int SCOREPERJEWEL = 5;
    private static int TIMEPERJEWEL;
    private static final int STATUS_INITLEVEL = 0;
    private static final int STATUS_FALL = 1;
    private static final int STATUS_READY = 2;
    private static final int STATUS_SWAP = 3;
    private static final int STATUS_SWAPBACK = 4;
    private static final int STATUS_DESTROY = 5;
    private static final int STATUS_LEVELDONE = 6;
    private static final int STATUS_GAMEOVER = 7;
    private static final int STATUS_ESCAPESWAP = 8;
    private int loseMode = 0;
    public static final int LOSE_OUT_OF_MOVES = 1;
    public static final int LOSE_OUT_OF_OPTIONS = 2;
    public static final int LOSE_OUT_OF_TIME = 3;
    public static final int LOSE_BUBBLE_ESCAPED = 4;
    public static final int LOSE_SCORE = 5;
    public static int lose;
    private Jewel[] jewels = new Jewel[64];
    private Jewel[] fallBonus = new Jewel[8];
    public static Rectangle rectGameArea;
    private int status;
    private int gameMode;
    private int gameLevel;
    private long timeElapsed;
    private int score;
    private int scoreBomb;
    private int scoreEsc;
    private int scoreDown;
    private int multiplicator;
    public int hint;
    private int selectorFrame;
    private long progressMain;
    private long progressMainFinal;
    public static int progressSecondary;
    private int progressSecondaryFinal;
    private int maxSpecialGems;
    public int synchro;
    private boolean isFinishedScreen;
    private int selectorPos;
    private int swappedPos;
    private boolean isDragged;
    private int totalColors;
    private boolean allowEscapeSwap;
    private boolean penalty;
    private boolean block = false;
    private boolean ecs = false;
    private boolean down = false;
    private boolean goodScore = false;
    public Tile[][] world = new Tile[4][4];
    private Jewel[][] numbers = new Jewel[4][4];
    public static Jewel[][] destroyNumbres;
    int xOffset;
    int yOffset;
    private int speedX;
    private int speedY;
    boolean addNewTile = false;
    int PosX = 0;
    int PosY = 0;
    boolean playGround = true;

    private void prepareWorld() {
        Image numBg = Resources.resImgs[16];
        this.xOffset = (Game.rectGameArea.width - 4 * numBg.getWidth()) / 5;
        this.yOffset = (Game.rectGameArea.height - 4 * numBg.getHeight()) / 5;
        for (int x = 0; x < 4; ++x) {
            for (int y = 0; y < 4; ++y) {
                this.world[x][y] = new Tile(Game.rectGameArea.x + x * numBg.getWidth() + this.xOffset * x + this.xOffset, Game.rectGameArea.y + numBg.getHeight() / 2 + y * numBg.getHeight() + this.yOffset * y + this.yOffset, false);
            }
        }
    }

    public void prepareStartNumbers() {
        Image numBg = Resources.resImgs[16];
        this.speedX = numBg.getWidth() + this.xOffset;
        this.speedY = numBg.getHeight() + this.yOffset;
        Random generator = new Random();
        int x = RandomNum.getRandomUInt(4);
        int y = RandomNum.getRandomUInt(4);
        while (this.numbers[x][y] != null) {
            x = RandomNum.getRandomUInt(4);
            y = RandomNum.getRandomUInt(4);
        }
        this.numbers[x][y] = new Jewel(RandomNum.getRandomUInt(9) % 8 == 0 ? 4 : 2, this.world[x][y].getX(), this.world[x][y].getY());
        this.numbers[x][y].speedX = numBg.getWidth() + this.xOffset;
        this.numbers[x][y].speedY = numBg.getHeight() + this.yOffset;
    }

    public void restartGame() {
        rectGameArea = new Rectangle(MainCanvas.WIDTH - (Jewel.BLOCKSIZE << 3) >> 1, MainCanvas.HEIGHT - (Jewel.BLOCKSIZE << 3) >> 1, Jewel.BLOCKSIZE << 3, Jewel.BLOCKSIZE << 3);
        this.restartGameWord();
        this.prepareWorld();
        this.status = 0;
        this.prepareStartNumbers();
        this.prepareStartNumbers();
    }

    private void restartGameWord() {
        for (int x = 0; x < 4; ++x) {
            for (int y = 0; y < 4; ++y) {
                this.numbers[x][y] = null;
            }
        }
        this.score = 0;
    }

    private boolean checkFullWorld() {
        for (int x = 0; x < 4; ++x) {
            for (int y = 0; y < 4; ++y) {
                if (this.numbers[x][y] != null) continue;
                return false;
            }
        }
        return true;
    }

    private void checkgameOver() {
        if (!this.checkFullWorld()) {
            return;
        }
        int check = 0;
        for (int x = 0; x < 4; ++x) {
            for (int y = 0; y < 4; ++y) {
                if (x + 1 < 4 && this.numbers[x][y].getValue() == this.numbers[x + 1][y].getValue()) {
                    ++check;
                }
                if (y + 1 >= 4 || this.numbers[x][y].getValue() != this.numbers[x][y + 1].getValue()) continue;
                ++check;
            }
        }
        if (check == 0) {
            this.status = 7;
        }
    }

    private void resetAllJoin() {
        for (int x = 0; x < 4; ++x) {
            for (int y = 0; y < 4; ++y) {
                if (this.numbers[x][y] == null) continue;
                this.numbers[x][y].isJoined = false;
            }
        }
    }

    public void nullNumber(int x, int y) {
        if (destroyNumbres[x][y] != null) {
            Game.destroyNumbres[x][y] = null;
        }
    }

    public void numbersRight() {
        for (int y = 0; y < 4; ++y) {
            for (int x = 3; x >= 0; --x) {
                if (this.numbers[x][y] == null || x >= 3) continue;
                this.rightPos(x, y);
            }
        }
        this.checkgameOver();
        if (this.addNewTile) {
            this.prepareStartNumbers();
            this.addNewTile = false;
            this.resetAllJoin();
        }
    }

    private void rightPos(int x, int y) {
        if (x + 1 > 3) {
            return;
        }
        if (this.numbers[x + 1][y] == null) {
            this.numbers[x + 1][y] = this.numbers[x][y];
            this.numbers[x + 1][y].setNewPosition(this.world[x + 1][y].getX(), this.world[x + 1][y].getY());
            this.numbers[x + 1][y].update();
            this.numbers[x][y] = null;
            this.rightPos(x + 1, y);
            this.addNewTile = true;
        } else if (this.numbers[x + 1][y] != null && !this.numbers[x + 1][y].isJoined && !this.numbers[x][y].isJoined) {
            if (this.numbers[x + 1][y].getValue() == this.numbers[x][y].getValue()) {
                Game.destroyNumbres[x][y] = new Jewel(this.numbers[x][y].getValue(), this.numbers[x][y].getActualPositionX(), this.numbers[x][y].getActualPositionY());
                Game.destroyNumbres[x][y].speedX = this.numbers[x][y].speedX;
                Game.destroyNumbres[x][y].speedY = this.numbers[x][y].speedY;
                destroyNumbres[x][y].setNewPosition(this.world[x + 1][y].getX(), this.world[x + 1][y].getY(), x, y, true);
                destroyNumbres[x][y].update();
                this.score += this.numbers[x + 1][y].getValue() * 2;
                this.numbers[x][y] = null;
                this.numbers[x + 1][y].isJoined = true;
                this.numbers[x + 1][y].setValue(this.numbers[x + 1][y].getValue() * 2);
                if (this.numbers[x + 1][y].getValue() == 2048) {
                    this.status = 6;
                }
                this.addNewTile = true;
            } else {
                return;
            }
        }
    }

    public void numbersLeft() {
        for (int y = 0; y < 4; ++y) {
            for (int x = 0; x < 4; ++x) {
                if (this.numbers[x][y] == null || x <= 0) continue;
                this.leftPos(x, y);
            }
        }
        this.checkgameOver();
        if (this.addNewTile) {
            this.prepareStartNumbers();
            this.addNewTile = false;
            this.resetAllJoin();
        }
    }

    private void leftPos(int x, int y) {
        if (x - 1 < 0) {
            return;
        }
        if (this.numbers[x - 1][y] == null) {
            this.numbers[x - 1][y] = this.numbers[x][y];
            this.numbers[x - 1][y].setNewPosition(this.world[x - 1][y].getX(), this.world[x - 1][y].getY());
            this.numbers[x][y] = null;
            this.numbers[x - 1][y].update();
            this.leftPos(x - 1, y);
            this.addNewTile = true;
        } else if (this.numbers[x - 1][y] != null && !this.numbers[x - 1][y].isJoined && !this.numbers[x][y].isJoined) {
            if (this.numbers[x - 1][y].getValue() == this.numbers[x][y].getValue()) {
                Game.destroyNumbres[x][y] = new Jewel(this.numbers[x][y].getValue(), this.numbers[x][y].getActualPositionX(), this.numbers[x][y].getActualPositionY());
                Game.destroyNumbres[x][y].speedX = this.numbers[x][y].speedX;
                Game.destroyNumbres[x][y].speedY = this.numbers[x][y].speedY;
                destroyNumbres[x][y].setNewPosition(this.world[x - 1][y].getX(), this.world[x - 1][y].getY(), x, y, true);
                destroyNumbres[x][y].update();
                this.score += this.numbers[x - 1][y].getValue() * 2;
                this.numbers[x][y] = null;
                this.numbers[x - 1][y].isJoined = true;
                this.numbers[x - 1][y].setValue(this.numbers[x - 1][y].getValue() * 2);
                if (this.numbers[x - 1][y].getValue() == 2048) {
                    this.status = 6;
                }
                this.addNewTile = true;
            } else {
                return;
            }
        }
    }

    public void numbersUp() {
        for (int x = 0; x < 4; ++x) {
            for (int y = 0; y < 4; ++y) {
                if (this.numbers[x][y] == null || y <= 0) continue;
                this.upPos(x, y);
            }
        }
        this.checkgameOver();
        if (this.addNewTile) {
            this.prepareStartNumbers();
            this.addNewTile = false;
            this.resetAllJoin();
        }
    }

    private void upPos(int x, int y) {
        if (y - 1 < 0) {
            return;
        }
        if (this.numbers[x][y - 1] == null) {
            this.numbers[x][y - 1] = this.numbers[x][y];
            this.numbers[x][y - 1].setNewPosition(this.world[x][y - 1].getX(), this.world[x][y - 1].getY());
            this.numbers[x][y] = null;
            this.numbers[x][y - 1].update();
            this.upPos(x, y - 1);
            this.addNewTile = true;
        } else if (this.numbers[x][y - 1] != null && !this.numbers[x][y - 1].isJoined && !this.numbers[x][y].isJoined) {
            if (this.numbers[x][y - 1].getValue() == this.numbers[x][y].getValue()) {
                Game.destroyNumbres[x][y] = new Jewel(this.numbers[x][y].getValue(), this.numbers[x][y].getActualPositionX(), this.numbers[x][y].getActualPositionY());
                Game.destroyNumbres[x][y].speedX = this.numbers[x][y].speedX;
                Game.destroyNumbres[x][y].speedY = this.numbers[x][y].speedY;
                destroyNumbres[x][y].setNewPosition(this.world[x][y - 1].getX(), this.world[x][y - 1].getY(), x, y, true);
                destroyNumbres[x][y].update();
                this.score += this.numbers[x][y - 1].getValue() * 2;
                this.numbers[x][y] = null;
                this.numbers[x][y - 1].isJoined = true;
                this.numbers[x][y - 1].setValue(this.numbers[x][y - 1].getValue() * 2);
                if (this.numbers[x][y - 1].getValue() == 2048) {
                    this.status = 6;
                }
                this.addNewTile = true;
            } else {
                return;
            }
        }
    }

    public void numbersDown() {
        for (int y = 3; y >= 0; --y) {
            for (int x = 0; x < 4; ++x) {
                if (this.numbers[x][y] == null || y >= 3) continue;
                this.downPos(x, y);
            }
        }
        this.checkgameOver();
        if (this.addNewTile) {
            this.prepareStartNumbers();
            this.addNewTile = false;
            this.resetAllJoin();
        }
    }

    private void downPos(int x, int y) {
        if (y + 1 > 3) {
            return;
        }
        if (this.numbers[x][y + 1] == null) {
            this.numbers[x][y + 1] = this.numbers[x][y];
            this.numbers[x][y + 1].setNewPosition(this.world[x][y + 1].getX(), this.world[x][y + 1].getY());
            this.numbers[x][y + 1].update();
            this.numbers[x][y] = null;
            this.downPos(x, y + 1);
            this.addNewTile = true;
        } else if (this.numbers[x][y + 1] != null && !this.numbers[x][y + 1].isJoined && !this.numbers[x][y].isJoined) {
            if (this.numbers[x][y + 1].getValue() == this.numbers[x][y].getValue()) {
                Game.destroyNumbres[x][y] = new Jewel(this.numbers[x][y].getValue(), this.numbers[x][y].getActualPositionX(), this.numbers[x][y].getActualPositionY());
                Game.destroyNumbres[x][y].speedX = this.numbers[x][y].speedX;
                Game.destroyNumbres[x][y].speedY = this.numbers[x][y].speedY;
                destroyNumbres[x][y].setNewPosition(this.world[x][y + 1].getX(), this.world[x][y + 1].getY(), x, y, true);
                destroyNumbres[x][y].update();
                this.score += this.numbers[x][y + 1].getValue() * 2;
                this.numbers[x][y + 1].isJoined = true;
                this.numbers[x][y] = null;
                this.numbers[x][y + 1].setValue(this.numbers[x][y + 1].getValue() * 2);
                if (this.numbers[x][y + 1].getValue() == 2048) {
                    this.status = 6;
                }
                this.addNewTile = true;
            } else {
                return;
            }
        }
    }

    public void DragOrDrop() {
        if (this.status == 2) {
            boolean bl = this.isDragged = !this.isDragged;
            if (!this.isDragged) {
                this.selectorFrame = 1;
            }
        }
    }

    public void pointerPressed(int x, int y) {
        System.out.println("GAME: Press: x: " + x + " , y: " + y);
        this.PosX = x;
        this.PosY = y;
    }

    public void pointerReleased(int x, int y) {
        System.out.println("GAME: Released: x: " + x + " , y: " + y);
        System.out.println("GAME releasse: POS X: " + this.PosX + " , POS Y: " + this.PosY + " , x: " + x + " , y: " + y + " , yOffset: " + this.yOffset);
        int positionX = this.PosX - x;
        int positionY = this.PosY - y;
        if (Math.abs(x - this.PosX) > Math.abs(y - this.PosY)) {
            if (this.PosX > x) {
                System.out.println("LEFT");
                this.numbersLeft();
            } else if (this.PosX < x) {
                this.numbersRight();
                System.out.println("RIGHT");
            }
        } else if (this.PosY > y) {
            this.numbersUp();
            System.out.println("UP");
        } else if (this.PosY < y) {
            this.numbersDown();
            System.out.println("DOWN");
        }
    }

    public int getScore() {
        return this.score;
    }

    public boolean isGameOver() {
        return this.status == 7;
    }

    public boolean isLevelDone() {
        return this.status == 6;
    }

    public void update(long lastRunLenght) {
        for (int x = 0; x < 4; ++x) {
            for (int y = 0; y < 4; ++y) {
                if (this.numbers[x][y] != null) {
                    this.numbers[x][y].update();
                }
                if (destroyNumbres[x][y] == null || !Game.destroyNumbres[x][y].isDelete) continue;
                this.nullNumber(x, y);
            }
        }
    }

    public void paint(Graphics g) {
        Image numBg = Resources.resImgs[16];
        for (int x = 0; x < 4; ++x) {
            for (int y = 0; y < 4; ++y) {
                if (this.world[x][y] != null && this.playGround) {
                    g.drawImage(numBg, this.world[x][y].getX(), this.world[x][y].getY(), 6);
                }
                if (destroyNumbres[x][y] != null) {
                    destroyNumbres[x][y].paint(g);
                    Game.destroyNumbres[x][y] = null;
                }
                if (this.numbers[x][y] == null) continue;
                this.numbers[x][y].paint(g);
            }
        }
        this.playGround = false;
    }

    public void load(DataInputStream dis, String rmsName) throws IOException {
        this.status = dis.readInt();
        this.gameMode = dis.readInt();
        this.gameLevel = dis.readInt();
        this.timeElapsed = dis.readLong();
        this.score = dis.readInt();
        this.multiplicator = dis.readInt();
        this.hint = dis.readInt();
        this.progressMain = dis.readLong();
        this.progressMainFinal = dis.readLong();
        this.progressSecondaryFinal = dis.readInt();
        progressSecondary = dis.readInt();
        this.selectorPos = dis.readInt();
        this.swappedPos = dis.readInt();
        this.isDragged = dis.readBoolean();
        this.totalColors = dis.readInt();
        this.allowEscapeSwap = dis.readBoolean();
        this.maxSpecialGems = dis.readInt();
        for (int i = 0; i < 64; ++i) {
            this.jewels[i].load(dis);
        }
    }

    public void save(DataOutputStream dos, String rmsName) throws IOException {
        dos.writeInt(this.status);
        dos.writeInt(this.gameMode);
        dos.writeInt(this.gameLevel);
        dos.writeLong(this.timeElapsed);
        dos.writeInt(this.score);
        dos.writeInt(this.multiplicator);
        dos.writeInt(this.hint);
        dos.writeLong(this.progressMain);
        dos.writeLong(this.progressMainFinal);
        dos.writeInt(this.progressSecondaryFinal);
        dos.writeInt(progressSecondary);
        dos.writeInt(this.selectorPos);
        dos.writeInt(this.swappedPos);
        dos.writeBoolean(this.isDragged);
        dos.writeInt(this.totalColors);
        dos.writeBoolean(this.allowEscapeSwap);
        dos.writeInt(this.maxSpecialGems);
        for (int i = 0; i < 64; ++i) {
            this.jewels[i].save(dos);
        }
    }

    public void setDefault(DataOutputStream dos, String rmsName) throws IOException {
        dos.writeInt(0);
        dos.writeInt(this.gameMode);
        dos.writeInt(1);
        dos.writeLong(0L);
        dos.writeInt(0);
        dos.writeInt(1);
        dos.writeLong(0L);
        dos.writeLong(1000L);
        dos.writeInt(1000);
        dos.writeInt(5);
        dos.writeInt(0);
        dos.writeInt(27);
        dos.writeInt(0);
        dos.writeBoolean(false);
        dos.writeInt(5);
        dos.writeBoolean(true);
    }

    private void setLoseMode(int loseMode) {
        this.loseMode = loseMode;
    }

    public int getLoseMode() {
        return this.loseMode;
    }

    static {
        lose = 0;
        destroyNumbres = new Jewel[4][4];
    }
}

