/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic.screen;

import java.util.Vector;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;
import sk.inlogic.Jewel;
import sk.inlogic.MainCanvas;
import sk.inlogic.RMSObjects;
import sk.inlogic.Resources;
import sk.inlogic.Settings;
import sk.inlogic.Sounds;
import sk.inlogic.powV2.PowV2ScoreItem;
import sk.inlogic.screen.IScreen;
import sk.inlogic.screen.ScreenMenu;
import sk.inlogic.text.PreparedText;
import sk.inlogic.util.Keys;
import sk.inlogic.util.Rectangle;

public class ScreenGame
implements IScreen {
    private MainCanvas mainCanvas;
    private int status;
    private int gameMode;
    private int interuption = 0;
    private static final int STATUS_GAME = 0;
    private static final int STATUS_INGAMEMENU = 1;
    private static final int STATUS_RESULTDIALOG = 2;
    private static final int STATUS_INSTRUCTIONS = 3;
    private static final int STATUS_TUTORIAL = 4;
    private static final int STATUS_RESTARTSCREEN = 5;
    private static final int STATUS_REALY_QUIT = 6;
    private static final int COMP_ID_HINT = 0;
    private static final int COMP_ID_MENU = 1;
    private static final int COMP_ID_RESUME = 2;
    private static final int COMP_ID_RESTART = 3;
    private static final int COMP_ID_SOUNDS = 4;
    private static final int COMP_ID_MAINMENU = 5;
    private static final int COMP_ID_INSTRUCTION = 6;
    private static final int COMP_ID_ARR_UP = 7;
    private static final int COMP_ID_ARR_DOWN = 8;
    private static final int TOTAL_COMP_IDS = 9;
    private Rectangle[] rectItems = new Rectangle[9];
    private Rectangle rectGameArea;
    private Rectangle rectTitle;
    private Rectangle rectPanel;
    private Rectangle rectText;
    private Rectangle rectBest;
    private Rectangle rectActual;
    private int selectedCompId;
    private int icount;
    private static PreparedText menuItem;
    private static PreparedText instruction;
    private static PreparedText bestScore;
    private static PreparedText actualScore;
    private int textOffsetY;
    private boolean needRepaint;
    private boolean scrollUP = false;
    private boolean scrollDOWN = true;
    int bestScoreSave = 0;
    private int scoresCount = 0;
    int cycle = 10;
    int lvl = 0;
    int checkButton = 2;
    int checkButton2 = 2;
    int posX = 0;
    int posY = 0;

    public ScreenGame(MainCanvas mainCanvas, boolean tutorial) {
        this.mainCanvas = mainCanvas;
        this.status = tutorial ? 4 : 0;
    }

    public void beforeShow() {
        Resources.loadImages(new int[]{13});
        Resources.loadSprites(new int[]{1, 1});
        Resources.loadImages(new int[]{19, 16, 14, 22, 23, 15, 17, 18, 20, 21, 13});
        Resources.loadSprites(new int[]{7, 10, 2, 4, 9, 6, 8, 5});
        Resources.loadGFonts(new int[]{3, 0, 1});
        this.calculatePositions();
        this.prepareTxt();
        RMSObjects.game.restartGame();
    }

    private void prepareTxt() {
        instruction = new PreparedText(Resources.resGFonts[0]);
        menuItem = new PreparedText(Resources.resGFonts[3]);
        bestScore = new PreparedText(Resources.resGFonts[1]);
        actualScore = new PreparedText(Resources.resGFonts[1]);
        String controls = Resources.resTexts[0].getHashedString(17) + "\n\n\n\n" + "\n\n\n\n";
        controls = Resources.resTexts[0].getHashedString(17) + "\n                                                             \n                                         \n                 \n  ";
        instruction.prepareText(Resources.resTexts[0].getHashedString(1) + "\n\n" + controls, this.rectText.width);
        instruction.setLineHeightCorrection(-2);
        this.loadBestScore();
    }

    public void afterHide() {
        Resources.freeSprites(new int[]{1});
        Resources.freeImages(new int[]{19, 16, 14, 22, 23, 15, 17, 18, 20, 21, 13});
        Resources.freeSprites(new int[]{7, 10, 2, 4, 9, 6, 8, 5});
        Resources.freeGFont(0);
        Resources.freeGFont(1);
    }

    private void loadBestScore() {
        Vector scores;
        RMSObjects.createRMSConnect(1);
        if (!RMSObjects.rmsConnects[1].load()) {
            RMSObjects.rmsConnects[1].create();
        }
        if ((scores = RMSObjects.bestScores.getScoresForGame(0)) != null) {
            this.scoresCount = scores.size();
        }
        PowV2ScoreItem scoreItem = null;
        if (this.scoresCount > 0) {
            scoreItem = (PowV2ScoreItem)scores.elementAt(0);
            this.bestScoreSave = scoreItem.scoreValue;
        }
    }

    private void saveBestScore() {
        PowV2ScoreItem scoreItem = new PowV2ScoreItem();
        scoreItem.powGameId = 0;
        scoreItem.scorePos = 0;
        scoreItem.userName = "0";
        if (RMSObjects.game.getScore() > this.bestScoreSave) {
            scoreItem.scoreValue = RMSObjects.game.getScore();
            RMSObjects.bestScores.userName = Integer.toString(0);
            RMSObjects.bestScores.insertScoreItem(scoreItem, 0);
            if (!RMSObjects.rmsConnects[1].isExist()) {
                RMSObjects.rmsConnects[1].create();
            }
            RMSObjects.rmsConnects[1].save();
        }
    }

    public void beforeInteruption() {
        if (this.status == 0) {
            this.setGameMenuStatus();
        }
        MainCanvas.soundManager.Stop();
    }

    public void afterInteruption() {
        MainCanvas.soundManager.Play(Sounds.SOUND_GAME, -1);
    }

    private void calculatePositions() {
        Jewel.BLOCKSIZE = Resources.resSprs[1].getWidth();
        this.rectGameArea = new Rectangle(MainCanvas.WIDTH - (Jewel.BLOCKSIZE << 3) >> 1, MainCanvas.HEIGHT - (Jewel.BLOCKSIZE << 3) >> 1, Jewel.BLOCKSIZE << 3, Jewel.BLOCKSIZE << 3);
        int itemHeight = Resources.resImgs[13].getHeight();
        int itemWidth = Resources.resImgs[13].getWidth();
        int fkWidth = Resources.resSprs[8].getWidth();
        int posX = (MainCanvas.WIDTH - itemWidth) / 2;
        int posY = (MainCanvas.HEIGHT >> 1) - (itemHeight << 1);
        this.rectPanel = new Rectangle(fkWidth, itemHeight * 2, MainCanvas.WIDTH - fkWidth * 2, MainCanvas.HEIGHT - itemHeight * 4);
        Sprite panel = Resources.resSprs[4];
        this.rectText = new Rectangle(fkWidth + panel.getWidth(), itemHeight * 2 + panel.getWidth(), MainCanvas.WIDTH - fkWidth * 2 - 2 * panel.getWidth(), MainCanvas.HEIGHT - itemHeight * 4 - 2 * panel.getWidth());
        this.rectTitle = new Rectangle(posX, itemHeight / 2, itemWidth, itemHeight);
        posY = this.rectPanel.getTop() + itemHeight;
        this.rectItems[3] = new Rectangle(posX, posY, itemWidth, itemHeight);
        this.rectItems[4] = new Rectangle(posX, posY += itemHeight + itemHeight / 4, itemWidth, itemHeight);
        this.rectItems[6] = new Rectangle(posX, posY += itemHeight + itemHeight / 4, itemWidth, itemHeight);
        this.rectItems[5] = new Rectangle(posX, posY += itemHeight + itemHeight / 4, itemWidth, itemHeight);
        this.rectItems[0] = new Rectangle(0, MainCanvas.HEIGHT - Resources.resSprs[8].getWidth(), Resources.resSprs[8].getWidth() + (Resources.resSprs[8].getWidth() >> 1), itemHeight);
        this.rectItems[1] = new Rectangle(MainCanvas.WIDTH - Resources.resSprs[8].getWidth() - (Resources.resSprs[8].getWidth() >> 1), MainCanvas.HEIGHT - itemHeight, Resources.resSprs[8].getWidth() + (Resources.resSprs[8].getWidth() >> 1), itemHeight);
    }

    public void update(long lastRunLenght) {
        if (this.status == 0) {
            RMSObjects.game.update(lastRunLenght);
            if (RMSObjects.game.isLevelDone()) {
                this.status = 2;
            } else if (RMSObjects.game.isGameOver()) {
                this.status = 2;
                this.icount = -1;
                if (this.getTopScore() < RMSObjects.game.getScore()) {
                    this.icount = 0;
                }
            }
            this.mainCanvas.repaint();
        }
        if (this.status == 2 && this.icount >= 0) {
            ++this.icount;
            this.icount %= 10;
            this.mainCanvas.repaint();
        }
        if (this.status == 3) {
            this.needRepaint = false;
            this.textMove();
            if (this.needRepaint) {
                this.mainCanvas.repaint();
            }
        }
        if (this.status == 1) {
            // empty if block
        }
    }

    public void textMove() {
        this.needRepaint = false;
        if (Keys.isActionPressed(1)) {
            if (Resources.sysFont) {
                this.textOffsetY -= Font.getDefaultFont().getHeight() >> 1;
                this.scrollUP = true;
                this.scrollDOWN = true;
            } else {
                this.textOffsetY -= Resources.resGFonts[3].getHeight() >> 1;
                this.scrollUP = true;
                this.scrollDOWN = true;
            }
            if (this.textOffsetY < 0) {
                this.textOffsetY = 0;
                this.scrollUP = false;
                this.scrollDOWN = true;
            }
            this.needRepaint = true;
        } else if (Keys.isActionPressed(2)) {
            int maxOffsetY = instruction.getTextHeight() - this.rectText.height;
            if (Resources.sysFont) {
                this.textOffsetY += Font.getDefaultFont().getHeight() >> 1;
                this.scrollUP = true;
                this.scrollDOWN = true;
            } else {
                this.textOffsetY += Resources.resGFonts[3].getHeight() >> 1;
                this.scrollUP = true;
                this.scrollDOWN = true;
            }
            if (this.textOffsetY > maxOffsetY) {
                this.textOffsetY = maxOffsetY;
                this.scrollUP = true;
                this.scrollDOWN = false;
            }
            this.needRepaint = true;
        }
        if (this.needRepaint) {
            this.mainCanvas.repaint();
        }
    }

    public void paint(Graphics g) {
        g.setColor(0x646464);
        g.fillRect(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
        this.paintPanelTop(g);
        this.paintPanelBottom(g);
        Image numBg = Resources.resImgs[16];
        for (int x = 0; x < 4; ++x) {
            for (int y = 0; y < 4; ++y) {
                if (RMSObjects.game.world[x][y] == null) continue;
                g.drawImage(numBg, RMSObjects.game.world[x][y].getX(), RMSObjects.game.world[x][y].getY(), 6);
            }
        }
        RMSObjects.game.paint(g);
        this.paintFK(g);
        switch (this.status) {
            case 1: {
                this.paintPatern(g);
                this.paintTop(g);
                this.paintCenterPanel(g);
                this.paintMenuDialogItems(g);
                this.paintFK(g);
                break;
            }
            case 2: {
                this.paintPatern(g);
                this.paintCenterPanel(g);
                this.paintTop(g);
                this.paintFK(g);
                break;
            }
            case 3: {
                this.paintPatern(g);
                this.paintTop(g);
                this.paintCenterPanel(g);
                this.paintInstructions(g);
                this.paintArrows(g);
                this.paintFK(g);
                break;
            }
            case 4: {
                this.paintPatern(g);
                this.paintTop(g);
                this.paintCenterPanel(g);
                this.paintTutorial(g);
                this.paintFK(g);
                break;
            }
            case 5: {
                this.paintPatern(g);
                this.paintCenterPanel(g);
                this.paintTop(g);
                this.paintFK(g);
                break;
            }
            case 6: {
                this.paintPatern(g);
                this.paintCenterPanel(g);
                this.paintTop(g);
                this.paintFK(g);
            }
        }
    }

    private void paintArrows(Graphics g) {
        Sprite arrow = Resources.resSprs[2];
        if (this.scrollDOWN && this.scrollUP) {
            arrow.setPosition(this.mainCanvas.getWidth() / 2 - arrow.getWidth() - arrow.getWidth() / 2, this.mainCanvas.getHeight() - arrow.getHeight());
            arrow.setFrame(1);
            arrow.paint(g);
            arrow.setPosition(this.mainCanvas.getWidth() / 2 + arrow.getWidth() - arrow.getWidth() / 2, this.mainCanvas.getHeight() - arrow.getHeight());
            arrow.setFrame(0);
            arrow.paint(g);
        } else if (!this.scrollDOWN && this.scrollUP) {
            arrow.setPosition(this.mainCanvas.getWidth() / 2 - arrow.getWidth() / 2, this.mainCanvas.getHeight() - arrow.getHeight());
            arrow.setFrame(0);
            arrow.paint(g);
        }
        if (this.scrollDOWN && !this.scrollUP) {
            arrow.setPosition(this.mainCanvas.getWidth() / 2 - arrow.getWidth() / 2, this.mainCanvas.getHeight() - arrow.getHeight());
            arrow.setFrame(1);
            arrow.paint(g);
        }
    }

    public void panelTop(Graphics g) {
        Image buttomActive = Resources.resImgs[13];
        switch (this.status) {
            case 1: {
                g.drawImage(buttomActive, this.rectTitle.x, this.rectTitle.y, 20);
                break;
            }
            case 3: {
                g.drawImage(buttomActive, this.rectTitle.x, this.rectTitle.y, 20);
                menuItem.prepareText(Resources.resTexts[0].getHashedString(23), this.rectTitle.width);
                menuItem.drawText(g, this.rectTitle, 0, 3);
                break;
            }
            case 6: {
                g.drawImage(buttomActive, this.rectTitle.x, this.rectTitle.y, 20);
                break;
            }
            case 4: {
                g.drawImage(buttomActive, this.rectTitle.x, this.rectTitle.y, 20);
                break;
            }
            case 2: {
                g.drawImage(buttomActive, this.rectTitle.x, this.rectTitle.y, 20);
            }
        }
    }

    private void paintTutorial(Graphics g) {
        Sprite hand = Resources.resSprs[7];
        Image tutorial = Resources.resImgs[23];
        g.drawImage(tutorial, this.rectPanel.getCenterX(), this.rectPanel.getCenterY(), 3);
        hand.setPosition(this.rectPanel.getCenterX() - hand.getWidth(), this.rectPanel.getCenterY());
        hand.paint(g);
    }

    private void paintInstructions(Graphics g) {
        instruction.drawText(g, this.rectText, this.textOffsetY, 20);
    }

    private void paintPanelTop(Graphics g) {
        Image topLeft = Resources.resImgs[20];
        Sprite ornament = Resources.resSprs[9];
        int leftOffset = (this.rectGameArea.width - 4 * Resources.resImgs[16].getWidth()) / 5;
        Rectangle rext = new Rectangle(this.mainCanvas.getWidth() - (leftOffset << 1) - topLeft.getWidth(), topLeft.getHeight() >> 2, topLeft.getWidth(), topLeft.getHeight());
        ornament.setPosition(0, 0);
        ornament.setTransform(1);
        ornament.paint(g);
        g.drawImage(topLeft, leftOffset, topLeft.getHeight() >> 2, 20);
        g.drawImage(topLeft, this.mainCanvas.getWidth() - leftOffset, topLeft.getHeight() >> 2, 24);
        String score = RMSObjects.game.getScore() + "";
        String addscore = "";
        if (score.length() == 1) {
            addscore = "______";
        }
        if (score.length() == 2) {
            addscore = "_____";
        }
        if (score.length() == 3) {
            addscore = "____";
        }
        if (score.length() == 4) {
            addscore = "___";
        }
        if (score.length() == 5) {
            addscore = "__";
        }
        if (score.length() == 6) {
            addscore = "_";
        }
        if (score.length() == 7) {
            addscore = "";
        }
        actualScore.prepareText(addscore + RMSObjects.game.getScore(), topLeft.getWidth());
        actualScore.drawText(g, rext, 0, 10);
        score = this.bestScoreSave + "";
        String s = "";
        if (score.length() == 1) {
            s = "______";
        }
        if (score.length() == 2) {
            s = "_____";
        }
        if (score.length() == 3) {
            s = "____";
        }
        if (score.length() == 4) {
            s = "___";
        }
        if (score.length() == 5) {
            s = "__";
        }
        if (score.length() == 6) {
            s = "_";
        }
        if (score.length() == 7) {
            s = "";
        }
        actualScore.prepareText(s + this.bestScoreSave, topLeft.getWidth());
        rext = new Rectangle(leftOffset << 1, topLeft.getHeight() >> 2, topLeft.getWidth(), topLeft.getHeight());
        actualScore.drawText(g, rext, 0, 6);
    }

    public void paintScore(Graphics g) {
    }

    public void paintTop(Graphics g) {
        switch (this.status) {
            case 5: {
                Image buttomActive = Resources.resImgs[13];
                g.drawImage(buttomActive, this.rectItems[3].x, this.rectItems[3].y, 20);
                menuItem.prepareText(Resources.resTexts[0].getHashedString(78), this.rectTitle.width);
                menuItem.drawText(g, this.rectItems[3], 0, 3);
                break;
            }
            case 3: {
                Image buttomActive = Resources.resImgs[13];
                g.drawImage(buttomActive, this.rectTitle.x, this.rectTitle.y, 20);
                menuItem.prepareText(Resources.resTexts[0].getHashedString(22), this.rectTitle.width);
                menuItem.drawText(g, this.rectTitle, 0, 3);
                break;
            }
            case 4: {
                Image buttomActive = Resources.resImgs[13];
                g.drawImage(buttomActive, this.rectTitle.x, this.rectTitle.y, 20);
                menuItem.prepareText(Resources.resTexts[0].getHashedString(79), this.rectTitle.width);
                menuItem.drawText(g, this.rectTitle, 0, 3);
                break;
            }
            case 2: {
                Image buttomActive = Resources.resImgs[13];
                g.drawImage(buttomActive, this.rectItems[3].x, this.rectItems[3].y, 20);
                if (RMSObjects.game.isGameOver()) {
                    menuItem.prepareText(Resources.resTexts[0].getHashedString(13), this.rectTitle.width);
                    menuItem.drawText(g, this.rectItems[3], 0, 3);
                    break;
                }
                menuItem.prepareText("WIN", this.rectTitle.width);
                menuItem.drawText(g, this.rectItems[3], 0, 3);
                break;
            }
            case 6: {
                Image buttomActive = Resources.resImgs[13];
                g.drawImage(buttomActive, this.rectItems[3].x, this.rectItems[3].y, 20);
                menuItem.prepareText(Resources.resTexts[0].getHashedString(2), this.rectTitle.width);
                menuItem.drawText(g, this.rectItems[3], 0, 3);
            }
        }
    }

    private void paintPanelBottom(Graphics g) {
        Sprite ornament = Resources.resSprs[9];
        ornament.setPosition(this.mainCanvas.getWidth() / 2 - ornament.getWidth() / 2, this.mainCanvas.getHeight() - ornament.getHeight());
        ornament.setTransform(0);
        ornament.paint(g);
    }

    private void paintFK(Graphics g) {
        Sprite bgFK = Resources.resSprs[8];
        Sprite fgFK = Resources.resSprs[5];
        if (this.status == 0) {
            bgFK.setTransform(0);
            bgFK.setPosition(this.mainCanvas.getWidth() - bgFK.getWidth(), this.mainCanvas.getHeight() - bgFK.getHeight());
            bgFK.paint(g);
            fgFK.setFrame(4);
            fgFK.setPosition(this.mainCanvas.getWidth() - (bgFK.getWidth() >> 1) - (fgFK.getWidth() >> 1), this.mainCanvas.getHeight() - (bgFK.getHeight() >> 1) - (fgFK.getHeight() >> 1));
            fgFK.paint(g);
        } else if (this.status == 2) {
            if (RMSObjects.game.isGameOver()) {
                bgFK.setTransform(2);
                bgFK.setPosition(0, this.mainCanvas.getHeight() - bgFK.getHeight());
                bgFK.paint(g);
                bgFK.setTransform(0);
                bgFK.setPosition(this.mainCanvas.getWidth() - bgFK.getWidth(), this.mainCanvas.getHeight() - bgFK.getHeight());
                bgFK.paint(g);
                fgFK.setFrame(3);
                fgFK.setPosition((bgFK.getWidth() >> 1) - (fgFK.getWidth() >> 1), this.mainCanvas.getHeight() - (bgFK.getHeight() >> 1) - (fgFK.getHeight() >> 1));
                fgFK.paint(g);
                fgFK.setFrame(2);
                fgFK.setPosition(this.mainCanvas.getWidth() - (bgFK.getWidth() >> 1) - (fgFK.getWidth() >> 1), this.mainCanvas.getHeight() - (bgFK.getHeight() >> 1) - (fgFK.getHeight() >> 1));
                fgFK.paint(g);
            } else if (RMSObjects.game.isLevelDone()) {
                bgFK.setTransform(2);
                bgFK.setPosition(0, this.mainCanvas.getHeight() - bgFK.getHeight());
                bgFK.paint(g);
                fgFK.setFrame(1);
                fgFK.setPosition((bgFK.getWidth() >> 1) - (fgFK.getWidth() >> 1), this.mainCanvas.getHeight() - (bgFK.getHeight() >> 1) - (fgFK.getHeight() >> 1));
                fgFK.paint(g);
            }
        } else if (this.status == 3) {
            bgFK.setTransform(0);
            bgFK.setPosition(this.mainCanvas.getWidth() - bgFK.getWidth(), this.mainCanvas.getHeight() - bgFK.getHeight());
            bgFK.paint(g);
            fgFK.setFrame(2);
            fgFK.setPosition(this.mainCanvas.getWidth() - (bgFK.getWidth() >> 1) - (fgFK.getWidth() >> 1), this.mainCanvas.getHeight() - (bgFK.getHeight() >> 1) - (fgFK.getHeight() >> 1));
            fgFK.paint(g);
        } else if (this.status == 1) {
            bgFK.setTransform(0);
            bgFK.setPosition(this.mainCanvas.getWidth() - bgFK.getWidth(), this.mainCanvas.getHeight() - bgFK.getHeight());
            bgFK.paint(g);
            fgFK.setFrame(2);
            fgFK.setPosition(this.mainCanvas.getWidth() - (bgFK.getWidth() >> 1) - (fgFK.getWidth() >> 1), this.mainCanvas.getHeight() - (bgFK.getHeight() >> 1) - (fgFK.getHeight() >> 1));
            fgFK.paint(g);
        } else if (this.status == 4) {
            bgFK.setTransform(0);
            bgFK.setPosition(this.mainCanvas.getWidth() - bgFK.getWidth(), this.mainCanvas.getHeight() - bgFK.getHeight());
            bgFK.paint(g);
            fgFK.setFrame(2);
            fgFK.setPosition(this.mainCanvas.getWidth() - (bgFK.getWidth() >> 1) - (fgFK.getWidth() >> 1), this.mainCanvas.getHeight() - (bgFK.getHeight() >> 1) - (fgFK.getHeight() >> 1));
            fgFK.paint(g);
        } else if (this.status == 5) {
            bgFK.setTransform(2);
            bgFK.setPosition(0, this.mainCanvas.getHeight() - bgFK.getHeight());
            bgFK.paint(g);
            bgFK.setTransform(0);
            bgFK.setPosition(this.mainCanvas.getWidth() - bgFK.getWidth(), this.mainCanvas.getHeight() - bgFK.getHeight());
            bgFK.paint(g);
            fgFK.setFrame(3);
            fgFK.setPosition((bgFK.getWidth() >> 1) - (fgFK.getWidth() >> 1), this.mainCanvas.getHeight() - (bgFK.getHeight() >> 1) - (fgFK.getHeight() >> 1));
            fgFK.paint(g);
            fgFK.setFrame(2);
            fgFK.setPosition(this.mainCanvas.getWidth() - (bgFK.getWidth() >> 1) - (fgFK.getWidth() >> 1), this.mainCanvas.getHeight() - (bgFK.getHeight() >> 1) - (fgFK.getHeight() >> 1));
            fgFK.paint(g);
        } else if (this.status == 6) {
            bgFK.setTransform(2);
            bgFK.setPosition(0, this.mainCanvas.getHeight() - bgFK.getHeight());
            bgFK.paint(g);
            bgFK.setTransform(0);
            bgFK.setPosition(this.mainCanvas.getWidth() - bgFK.getWidth(), this.mainCanvas.getHeight() - bgFK.getHeight());
            bgFK.paint(g);
            fgFK.setFrame(1);
            fgFK.setPosition((bgFK.getWidth() >> 1) - (fgFK.getWidth() >> 1), this.mainCanvas.getHeight() - (bgFK.getHeight() >> 1) - (fgFK.getHeight() >> 1));
            fgFK.paint(g);
            fgFK.setFrame(2);
            fgFK.setPosition(this.mainCanvas.getWidth() - (bgFK.getWidth() >> 1) - (fgFK.getWidth() >> 1), this.mainCanvas.getHeight() - (bgFK.getHeight() >> 1) - (fgFK.getHeight() >> 1));
            fgFK.paint(g);
        }
    }

    public void paintPatern(Graphics g) {
        Image patern = Resources.resImgs[18];
        int x = 0;
        while (true) {
            if (x >= MainCanvas.WIDTH) break;
            int y = 0;
            while (true) {
                if (y >= MainCanvas.HEIGHT) break;
                g.drawImage(patern, x, y, 20);
                y += patern.getHeight();
            }
            x += patern.getWidth();
        }
    }

    public void paintCenterPanel(Graphics g) {
        Sprite panel = Resources.resSprs[4];
        int xPos = this.rectPanel.width / panel.getWidth() % panel.getWidth() == 0 ? this.rectPanel.width / panel.getWidth() : this.rectPanel.width / panel.getWidth() + 1;
        int yPos = this.rectPanel.height / panel.getHeight() % panel.getHeight() == 0 ? this.rectPanel.height / panel.getHeight() : this.rectPanel.height / panel.getHeight() + 1;
        int xPos2 = 0;
        int yPos2 = 0;
        for (int x = this.rectPanel.x; x < this.rectPanel.x + this.rectPanel.width; x += panel.getWidth()) {
            for (int y = this.rectPanel.y; y < this.rectPanel.y + this.rectPanel.height; y += panel.getHeight()) {
                if (xPos2 == 0 && yPos2 == 0) {
                    panel.setFrame(0);
                } else if (xPos2 == xPos && yPos2 == 0) {
                    panel.setFrame(2);
                } else if (xPos2 == 0 && yPos2 == yPos) {
                    panel.setFrame(6);
                } else if (xPos2 == xPos && yPos2 == yPos) {
                    panel.setFrame(8);
                } else {
                    panel.setFrame(4);
                }
                panel.setPosition(x, y);
                panel.paint(g);
                ++yPos2;
            }
            yPos2 = 0;
            ++xPos2;
        }
    }

    private void paintMenuDialogItems(Graphics g) {
        Image buttomActive = Resources.resImgs[13];
        Image buttomInActive = Resources.resImgs[14];
        if (this.selectedCompId == 3) {
            g.drawImage(buttomActive, this.rectItems[3].x, this.rectItems[3].y, 20);
        } else {
            g.drawImage(buttomInActive, this.rectItems[3].x, this.rectItems[3].y, 20);
        }
        if (this.selectedCompId == 6) {
            g.drawImage(buttomActive, this.rectItems[6].x, this.rectItems[6].y, 20);
        } else {
            g.drawImage(buttomInActive, this.rectItems[6].x, this.rectItems[6].y, 20);
        }
        if (this.selectedCompId == 4) {
            g.drawImage(buttomActive, this.rectItems[4].x, this.rectItems[4].y, 20);
        } else {
            g.drawImage(buttomInActive, this.rectItems[4].x, this.rectItems[4].y, 20);
        }
        if (this.selectedCompId == 5) {
            g.drawImage(buttomActive, this.rectItems[5].x, this.rectItems[5].y, 20);
        } else {
            g.drawImage(buttomInActive, this.rectItems[5].x, this.rectItems[5].y, 20);
        }
        menuItem.prepareText(Resources.resTexts[0].getHashedString(25), this.rectItems[3].width);
        menuItem.drawText(g, this.rectItems[3], 0, 3);
        menuItem.prepareText(Resources.resTexts[0].getHashedString(22), this.rectItems[3].width);
        menuItem.drawText(g, this.rectItems[6], 0, 3);
        menuItem.prepareText(MainCanvas.soundManager.IsSoundOn() ? Resources.resTexts[0].getHashedString(26) : Resources.resTexts[0].getHashedString(27), this.rectItems[4].width);
        menuItem.drawText(g, this.rectItems[4], 0, 3);
        menuItem.prepareText(Resources.resTexts[0].getHashedString(19), this.rectItems[3].width);
        menuItem.drawText(g, this.rectItems[5], 0, 3);
    }

    private int getTopScore() {
        Vector scores = RMSObjects.localScores.getScoresForGame(0);
        int scoresCount = 0;
        if (scores != null) {
            scoresCount = scores.size();
        }
        PowV2ScoreItem scoreItem = null;
        if (scoresCount > 0) {
            scoreItem = (PowV2ScoreItem)scores.elementAt(0);
            return scoreItem.scoreValue;
        }
        return 0;
    }

    public void keyPressed(int keyCode) {
    }

    public void keyReleased(int keyCode) {
        switch (this.status) {
            case 4: {
                if (!Keys.isFKRightCode(keyCode)) break;
                this.status = 0;
                break;
            }
            case 0: {
                if (Keys.isFKRightCode(keyCode)) {
                    this.setGameMenuStatus();
                    break;
                }
                if (keyCode == 49 || keyCode == 51 || keyCode == 57 || keyCode == 55) break;
                if (Keys.isActionGeneratedByKey(3, keyCode)) {
                    RMSObjects.game.numbersLeft();
                    break;
                }
                if (Keys.isActionGeneratedByKey(4, keyCode)) {
                    RMSObjects.game.numbersRight();
                    break;
                }
                if (Keys.isActionGeneratedByKey(1, keyCode)) {
                    RMSObjects.game.numbersUp();
                    break;
                }
                if (!Keys.isActionGeneratedByKey(2, keyCode)) break;
                RMSObjects.game.numbersDown();
                break;
            }
            case 1: {
                if (keyCode == 49 || keyCode == 51 || keyCode == 57 || keyCode == 55) break;
                this.keyReleasedMenuGame(keyCode);
                if (this.selectedCompId != 3 && this.selectedCompId != 6 && this.selectedCompId != 5) break;
                this.checkButton2 = this.selectedCompId;
                break;
            }
            case 2: {
                this.keyReleasedResult(keyCode);
                break;
            }
            case 3: {
                if (keyCode == 49 || keyCode == 51 || keyCode == 57 || keyCode == 55 || !Keys.isFKRightCode(keyCode)) break;
                this.status = 1;
                this.textOffsetY = 0;
                this.scrollUP = false;
                this.scrollDOWN = true;
                this.selectedCompId = 6;
                break;
            }
            case 6: {
                if (Keys.isFKLeftCode(keyCode)) {
                    this.mainCanvas.changeLastActiveScreen(new ScreenMenu(this.mainCanvas, 0));
                    if (!MainCanvas.soundManager.IsSoundOn()) break;
                    MainCanvas.soundManager.Stop();
                    MainCanvas.soundManager.Play(Sounds.SOUND_MENU, -1);
                    break;
                }
                if (!Keys.isFKRightCode(keyCode)) break;
                this.status = 1;
                break;
            }
            case 5: {
                if (Keys.isFKLeftCode(keyCode)) {
                    MainCanvas.moveCounter = 0;
                    if (this.gameMode == 4 || this.gameMode == 5) {
                        RMSObjects.game.restartGame();
                    } else {
                        RMSObjects.game.restartGame();
                    }
                    this.status = 0;
                    break;
                }
                if (!Keys.isFKRightCode(keyCode)) break;
                this.status = 1;
            }
        }
        this.mainCanvas.repaint();
    }

    private void setGameMenuStatus() {
        this.status = 1;
        this.selectedCompId = 3;
    }

    private void keyReleasedMenuGame(int keyCode) {
        switch (this.selectedCompId) {
            case 2: {
                break;
            }
            case 3: {
                if (Keys.isActionGeneratedByKey(1, keyCode)) {
                    this.selectedCompId = 5;
                    break;
                }
                if (Keys.isActionGeneratedByKey(2, keyCode)) {
                    this.selectedCompId = 4;
                    break;
                }
                if (!Keys.isActionGeneratedByKey(5, keyCode)) break;
                this.status = 5;
                this.mainCanvas.repaint();
                break;
            }
            case 4: {
                if (Keys.isActionGeneratedByKey(1, keyCode)) {
                    this.selectedCompId = 3;
                    break;
                }
                if (Keys.isActionGeneratedByKey(2, keyCode)) {
                    this.selectedCompId = 6;
                    break;
                }
                if (!Keys.isActionGeneratedByKey(5, keyCode)) break;
                if (MainCanvas.soundManager.IsSoundOn()) {
                    MainCanvas.soundManager.SetSoundOn(false);
                    Settings.musicOn = false;
                    MainCanvas.soundManager.Stop();
                    break;
                }
                MainCanvas.soundManager.SetSoundOn(true);
                Settings.musicOn = true;
                MainCanvas.soundManager.Play(Sounds.SOUND_GAME, -1);
                break;
            }
            case 6: {
                if (Keys.isActionGeneratedByKey(1, keyCode)) {
                    this.selectedCompId = 4;
                    break;
                }
                if (Keys.isActionGeneratedByKey(2, keyCode)) {
                    this.selectedCompId = 5;
                    break;
                }
                if (!Keys.isActionGeneratedByKey(5, keyCode)) break;
                this.status = 3;
                break;
            }
            case 5: {
                if (Keys.isActionGeneratedByKey(1, keyCode)) {
                    this.selectedCompId = 6;
                    break;
                }
                if (Keys.isActionGeneratedByKey(2, keyCode)) {
                    this.selectedCompId = 3;
                    break;
                }
                if (!Keys.isActionGeneratedByKey(5, keyCode)) break;
                this.status = 6;
            }
        }
        if (Keys.isFKRightCode(keyCode)) {
            this.status = 0;
        }
    }

    private void keyReleasedResult(int keyCode) {
        if (RMSObjects.game.isGameOver()) {
            if (Keys.isFKRightCode(keyCode)) {
                this.saveBestScore();
                this.mainCanvas.changeLastActiveScreen(new ScreenMenu(this.mainCanvas, 0));
                if (MainCanvas.soundManager.IsSoundOn()) {
                    MainCanvas.soundManager.Stop();
                    MainCanvas.soundManager.Play(Sounds.SOUND_MENU, -1);
                }
            } else if (Keys.isFKLeftCode(keyCode)) {
                this.saveBestScore();
                this.loadBestScore();
                MainCanvas.moveCounter = 0;
                RMSObjects.game.restartGame();
                this.status = 0;
                MainCanvas.soundManager.Stop();
                if (MainCanvas.soundManager.IsSoundOn()) {
                    MainCanvas.soundManager.Play(Sounds.SOUND_GAME, -1);
                }
            }
        } else if (RMSObjects.game.isLevelDone()) {
            if (Keys.isFKLeftCode(keyCode)) {
                this.saveBestScore();
                this.mainCanvas.changeLastActiveScreen(new ScreenMenu(this.mainCanvas, 0));
                MainCanvas.soundManager.Stop();
                if (MainCanvas.soundManager.IsSoundOn()) {
                    MainCanvas.soundManager.Play(Sounds.SOUND_MENU, -1);
                }
            } else if (Keys.isActionGeneratedByKey(5, keyCode)) {
                // empty if block
            }
        }
    }

    public void pointerPressed(int x, int y) {
        this.posX = x;
        this.posY = y;
        if (this.selectedCompId == 3 || this.selectedCompId == 6 || this.selectedCompId == 5) {
            this.checkButton = this.selectedCompId;
        }
        if (this.status == 0 && this.rectGameArea.contains(x, y)) {
            System.out.println("SCENE: Press: x: " + x + " , y: " + y);
            RMSObjects.game.pointerPressed(x, y);
            return;
        }
        block5: for (int i = 0; i < this.rectItems.length; ++i) {
            if (!this.existComponentInState(i, this.status) || this.rectItems[i] == null || !this.rectItems[i].contains(x, y)) continue;
            this.selectedCompId = i;
            if (this.selectedCompId == 3 || this.selectedCompId == 6 || this.selectedCompId == 5) {
                this.checkButton2 = this.selectedCompId;
            }
            switch (this.selectedCompId) {
                case 0: {
                    if (this.status != 1) {
                        Keys.keyPressed(-6);
                        continue block5;
                    }
                    Keys.keyPressed(-6);
                    continue block5;
                }
                case 1: {
                    if (this.status == 3) {
                        this.status = 1;
                        this.textOffsetY = 0;
                        this.scrollUP = false;
                        this.scrollDOWN = true;
                        this.selectedCompId = 6;
                        this.mainCanvas.repaint();
                        continue block5;
                    }
                    Keys.keyPressed(-7);
                    continue block5;
                }
                case 4: {
                    if (MainCanvas.soundManager.IsSoundOn()) {
                        MainCanvas.soundManager.SetSoundOn(false);
                        MainCanvas.soundManager.Stop();
                    } else {
                        MainCanvas.soundManager.SetSoundOn(true);
                        MainCanvas.soundManager.Play(Sounds.SOUND_GAME, -1);
                    }
                    if (this.selectedCompId == 4) {
                        this.selectedCompId = this.checkButton2;
                    }
                    this.mainCanvas.repaint();
                    continue block5;
                }
                default: {
                    Keys.keyPressed(53);
                    this.mainCanvas.repaint();
                }
            }
        }
    }

    private boolean existComponentInState(int i, int status) {
        if (status == 0) {
            if (i == 1) {
                return true;
            }
            if (i == 0) {
                return true;
            }
        } else if (status == 6) {
            if (i == 1) {
                return true;
            }
            if (i == 0) {
                return true;
            }
        } else if (status == 1) {
            if (i == 0) {
                return true;
            }
            if (i == 1) {
                return true;
            }
            if (i == 2) {
                return true;
            }
            if (i == 3) {
                return true;
            }
            if (i == 4) {
                return true;
            }
            if (i == 6) {
                return true;
            }
            if (i == 5) {
                return true;
            }
        } else if (status == 3) {
            if (i == 1) {
                return true;
            }
        } else if (status == 2) {
            if (i == 1) {
                return true;
            }
            if (i == 0) {
                return true;
            }
        } else if (status == 5) {
            if (i == 1) {
                return true;
            }
            if (i == 0) {
                return true;
            }
        } else if (status == 3) {
            if (i == 1) {
                return true;
            }
        } else if (status == 4) {
            if (i == 0) {
                return true;
            }
            if (i == 1) {
                return true;
            }
        }
        return false;
    }

    public void pointerDragged(int x, int y) {
        if (this.status == 3) {
            if (this.posY > y) {
                this.dragDown();
            } else if (this.posY < y) {
                this.dragUp();
            }
        }
        if (!this.rectItems[this.selectedCompId].contains(x, y)) {
            switch (this.selectedCompId) {
                case 0: {
                    Keys.keyReleased(-6);
                    break;
                }
                case 1: {
                    if (this.status == 3) {
                        this.status = 1;
                        this.textOffsetY = 0;
                        this.scrollUP = false;
                        this.scrollDOWN = true;
                        this.selectedCompId = 6;
                        break;
                    }
                    if (this.status == 4) {
                        this.status = 0;
                        break;
                    }
                    Keys.keyReleased(-7);
                    break;
                }
                default: {
                    Keys.keyReleased(53);
                    if (this.status != 1) break;
                }
            }
        }
    }

    public void pointerReleased(int x, int y) {
        if (this.status == 0 && this.rectGameArea.contains(x, y)) {
            System.out.println("SCENE: Released: x: " + x + " , y: " + y);
            RMSObjects.game.pointerReleased(x, y);
            return;
        }
        switch (this.selectedCompId) {
            case 0: {
                if (!Keys.isKeyPressed(-6)) break;
                this.keyReleased(-6);
                Keys.keyReleased(-6);
                if (this.selectedCompId != 6 && (this.selectedCompId == 3 || this.selectedCompId == 5)) {
                    if (this.checkButton2 == 6 || this.checkButton2 == 3 || this.checkButton2 == 5) {
                        this.selectedCompId = this.checkButton2;
                        break;
                    }
                    this.selectedCompId = 3;
                    break;
                }
                this.selectedCompId = this.checkButton;
                break;
            }
            case 1: {
                if (this.status == 3) {
                    this.status = 1;
                    this.textOffsetY = 0;
                    this.scrollUP = false;
                    this.scrollDOWN = true;
                    this.selectedCompId = 6;
                    break;
                }
                if (this.status == 4) {
                    this.status = 0;
                    break;
                }
                if (!Keys.isKeyPressed(-7)) break;
                if (this.status == 0) {
                    this.selectedCompId = 2;
                }
                this.keyReleased(-7);
                Keys.keyReleased(-7);
                break;
            }
            default: {
                if (Keys.isKeyPressed(53)) {
                    this.keyReleased(53);
                    Keys.keyReleased(53);
                }
                if (this.status != 1) break;
            }
        }
        if (this.selectedCompId == 4) {
            this.selectedCompId = 3;
        }
    }

    public void dragUp() {
        if (Resources.sysFont) {
            this.textOffsetY -= Font.getDefaultFont().getHeight() >> 1;
            this.scrollUP = true;
            this.scrollDOWN = true;
        } else {
            this.textOffsetY -= Resources.resGFonts[0].getHeight() >> 1;
            this.scrollUP = true;
            this.scrollDOWN = true;
        }
        if (this.textOffsetY < 0) {
            this.textOffsetY = 0;
            this.scrollUP = false;
            this.scrollDOWN = true;
        }
        this.needRepaint = true;
        this.mainCanvas.repaint();
    }

    public void dragDown() {
        int maxOffsetY = instruction.getTextHeight() - this.rectPanel.height;
        if (Resources.sysFont) {
            this.textOffsetY += Font.getDefaultFont().getHeight() >> 1;
            this.scrollUP = true;
            this.scrollDOWN = true;
        } else {
            this.textOffsetY += Resources.resGFonts[0].getHeight() >> 1;
            this.scrollUP = true;
            this.scrollDOWN = true;
        }
        if (this.textOffsetY > maxOffsetY) {
            this.textOffsetY = maxOffsetY;
            this.scrollUP = true;
            this.scrollDOWN = false;
        }
        this.needRepaint = true;
        this.mainCanvas.repaint();
    }
}

