/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic.screen;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.Sprite;
import sk.inlogic.MainCanvas;
import sk.inlogic.Resources;
import sk.inlogic.screen.IScreen;
import sk.inlogic.screen.ScreenSplash;
import sk.inlogic.util.Keys;
import sk.inlogic.util.Rectangle;

public class ScreenLanguage
implements IScreen {
    private MainCanvas mainCanvas;
    private static String[] langCodes = new String[]{"en", "de", "fr", "es", "pt", "sk"};
    private Rectangle[] rectItems = new Rectangle[6];
    private int selectedCompId;
    private static final int selectorPadding = 0;
    int x;
    int y;

    public ScreenLanguage(MainCanvas mainCanvas) {
        this.mainCanvas = mainCanvas;
    }

    public void beforeShow() {
        Resources.loadSprite(20);
        this.calculatePositions();
        this.selectedCompId = 0;
        this.calculateSelectorPos();
    }

    public void afterHide() {
        Resources.freeSprite(20);
    }

    public void beforeInteruption() {
    }

    public void afterInteruption() {
    }

    private void calculatePositions() {
        int btnHeight;
        int btnWidth;
        Resources.loadSprite(20);
        if (this.mainCanvas.getWidth() == 176 && this.mainCanvas.getHeight() == 220) {
            btnWidth = 44;
            btnHeight = 44;
        } else {
            btnWidth = Resources.resSprs[20].getWidth();
            btnHeight = Resources.resSprs[20].getHeight();
        }
        int spaceX = (MainCanvas.WIDTH - btnWidth * 2) / 3;
        int spaceY = (MainCanvas.HEIGHT - btnHeight * 3) / 4;
        for (int i = 0; i < 6; ++i) {
            this.rectItems[i] = new Rectangle(spaceX + i % 2 * (btnWidth + spaceX), spaceY + i / 2 * (btnHeight + spaceY), btnWidth, btnHeight);
        }
    }

    private void calculateSelectorPos() {
        if (MainCanvas.touchActivated) {
            return;
        }
    }

    public void update(long lastRunLenght) {
    }

    public void keyPressed(int keyCode) {
        this.mainCanvas.repaint();
    }

    public void keyReleased(int keyCode) {
        if (keyCode != 49 && keyCode != 51 && keyCode != 57 && keyCode != 55) {
            if (Keys.isActionGeneratedByKey(3, keyCode)) {
                if (this.selectedCompId % 2 == 1) {
                    --this.selectedCompId;
                    this.calculateSelectorPos();
                }
            } else if (Keys.isActionGeneratedByKey(4, keyCode)) {
                if (this.selectedCompId % 2 == 0) {
                    ++this.selectedCompId;
                    this.calculateSelectorPos();
                }
            } else if (Keys.isActionGeneratedByKey(1, keyCode)) {
                if (this.selectedCompId / 2 > 0) {
                    this.selectedCompId -= 2;
                    this.calculateSelectorPos();
                }
            } else if (Keys.isActionGeneratedByKey(2, keyCode)) {
                if (this.selectedCompId != 5 && this.selectedCompId != 4 && this.selectedCompId / 2 < 3) {
                    this.selectedCompId += 2;
                    this.calculateSelectorPos();
                }
            } else if (Keys.isActionGeneratedByKey(5, keyCode)) {
                Resources.initLangDirs(langCodes[this.selectedCompId]);
                this.mainCanvas.changeLastActiveScreen(new ScreenSplash(this.mainCanvas));
            } else if (Keys.isActionGeneratedByKey(-6, keyCode)) {
                Resources.initLangDirs(langCodes[this.selectedCompId]);
            } else if (Keys.isActionGeneratedByKey(-7, keyCode)) {
                Resources.initLangDirs(langCodes[this.selectedCompId]);
            }
        }
        this.mainCanvas.repaint();
        this.mainCanvas.repaint();
    }

    public void paint(Graphics g) {
        Sprite flag = Resources.resSprs[20];
        if (this.mainCanvas.getWidth() != 480) {
            g.setClip(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
            g.setColor(15, 60, 130);
            g.fillRect(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
            flag.setFrame(this.selectedCompId == 0 ? 0 : 1);
            flag.setPosition(this.rectItems[0].x, this.rectItems[0].y);
            flag.paint(g);
            flag.setFrame(this.selectedCompId == 1 ? 2 : 3);
            flag.setPosition(this.rectItems[1].x, this.rectItems[1].y);
            flag.paint(g);
            flag.setFrame(this.selectedCompId == 2 ? 4 : 5);
            flag.setPosition(this.rectItems[2].x, this.rectItems[2].y);
            flag.paint(g);
            flag.setFrame(this.selectedCompId == 3 ? 6 : 7);
            flag.setPosition(this.rectItems[3].x, this.rectItems[3].y);
            flag.paint(g);
            flag.setFrame(this.selectedCompId == 4 ? 8 : 9);
            flag.setPosition(this.rectItems[4].x, this.rectItems[4].y);
            flag.paint(g);
            flag.setFrame(this.selectedCompId == 5 ? 10 : 11);
            flag.setPosition(this.rectItems[5].x, this.rectItems[5].y);
            flag.paint(g);
            if (MainCanvas.touchActivated) {
                flag.setFrame(0);
                flag.setPosition(this.rectItems[0].x, this.rectItems[0].y);
                flag.paint(g);
                flag.setFrame(2);
                flag.setPosition(this.rectItems[1].x, this.rectItems[1].y);
                flag.paint(g);
                flag.setFrame(4);
                flag.setPosition(this.rectItems[2].x, this.rectItems[2].y);
                flag.paint(g);
                flag.setFrame(6);
                flag.setPosition(this.rectItems[3].x, this.rectItems[3].y);
                flag.paint(g);
                flag.setFrame(8);
                flag.setPosition(this.rectItems[4].x, this.rectItems[4].y);
                flag.paint(g);
                flag.setFrame(10);
                flag.setPosition(this.rectItems[5].x, this.rectItems[5].y);
                flag.paint(g);
            }
        } else if (this.mainCanvas.getWidth() >= 480) {
            if (MainCanvas.HEIGHT == 320) {
                flag.setFrame(0);
                flag.setPosition(this.rectItems[0].x, this.rectItems[0].y);
                flag.paint(g);
                flag.setFrame(2);
                flag.setPosition(this.rectItems[1].x, this.rectItems[1].y);
                flag.paint(g);
                flag.setFrame(4);
                flag.setPosition(this.rectItems[2].x, this.rectItems[2].y);
                flag.paint(g);
                flag.setFrame(6);
                flag.setPosition(this.rectItems[3].x, this.rectItems[3].y);
                flag.paint(g);
                flag.setFrame(8);
                flag.setPosition(this.rectItems[4].x, this.rectItems[4].y);
                flag.paint(g);
                flag.setFrame(10);
                flag.setPosition(this.rectItems[5].x, this.rectItems[5].y);
                flag.paint(g);
                return;
            }
            if (MainCanvas.HEIGHT == 360) {
                flag.setFrame(0);
                flag.setPosition(this.rectItems[0].x, this.rectItems[0].y);
                flag.paint(g);
                flag.setFrame(2);
                flag.setPosition(this.rectItems[1].x, this.rectItems[1].y);
                flag.paint(g);
                flag.setFrame(4);
                flag.setPosition(this.rectItems[2].x, this.rectItems[2].y);
                flag.paint(g);
                flag.setFrame(6);
                flag.setPosition(this.rectItems[3].x, this.rectItems[3].y);
                flag.paint(g);
                flag.setFrame(8);
                flag.setPosition(this.rectItems[4].x, this.rectItems[4].y);
                flag.paint(g);
                flag.setFrame(10);
                flag.setPosition(this.rectItems[5].x, this.rectItems[5].y);
                flag.paint(g);
                return;
            }
            if (MainCanvas.HEIGHT == 640) {
                flag.setFrame(0);
                flag.setPosition(this.rectItems[0].x, this.rectItems[0].y);
                flag.paint(g);
                flag.setFrame(2);
                flag.setPosition(this.rectItems[1].x, this.rectItems[1].y);
                flag.paint(g);
                flag.setFrame(4);
                flag.setPosition(this.rectItems[2].x, this.rectItems[2].y);
                flag.paint(g);
                flag.setFrame(6);
                flag.setPosition(this.rectItems[3].x, this.rectItems[3].y);
                flag.paint(g);
                flag.setFrame(8);
                flag.setPosition(this.rectItems[4].x, this.rectItems[4].y);
                flag.paint(g);
                flag.setFrame(10);
                flag.setPosition(this.rectItems[5].x, this.rectItems[5].y);
                flag.paint(g);
                return;
            }
            flag.setFrame(0);
            flag.setPosition(this.rectItems[0].x, this.rectItems[0].y);
            flag.paint(g);
            flag.setFrame(1);
            flag.setPosition(this.rectItems[1].x, this.rectItems[1].y);
            flag.paint(g);
            flag.setFrame(2);
            flag.setPosition(this.rectItems[2].x, this.rectItems[2].y);
            flag.paint(g);
            flag.setFrame(3);
            flag.setPosition(this.rectItems[3].x, this.rectItems[3].y);
            flag.paint(g);
            flag.setFrame(4);
            flag.setPosition(this.rectItems[4].x, this.rectItems[4].y);
            flag.paint(g);
            flag.setFrame(5);
            flag.setPosition(this.rectItems[5].x, this.rectItems[5].y);
            flag.paint(g);
            if (MainCanvas.touchActivated) {
                flag.setFrame(0);
                flag.setPosition(this.rectItems[0].x, this.rectItems[0].y);
                flag.paint(g);
                flag.setFrame(1);
                flag.setPosition(this.rectItems[1].x, this.rectItems[1].y);
                flag.paint(g);
                flag.setFrame(2);
                flag.setPosition(this.rectItems[2].x, this.rectItems[2].y);
                flag.paint(g);
                flag.setFrame(3);
                flag.setPosition(this.rectItems[3].x, this.rectItems[3].y);
                flag.paint(g);
                flag.setFrame(4);
                flag.setPosition(this.rectItems[4].x, this.rectItems[4].y);
                flag.paint(g);
                flag.setFrame(5);
                flag.setPosition(this.rectItems[5].x, this.rectItems[5].y);
                flag.paint(g);
                return;
            }
        }
    }

    public void pointerPressed(int x, int y) {
        for (int i = 0; i < this.rectItems.length; ++i) {
            if (!this.rectItems[i].contains(x, y)) continue;
            this.selectedCompId = i;
            switch (this.selectedCompId) {
                default: 
            }
            Keys.keyPressed(53);
        }
    }

    public void pointerDragged(int x, int y) {
        if (!this.rectItems[this.selectedCompId].contains(x, y)) {
            switch (this.selectedCompId) {
                default: 
            }
            Keys.keyReleased(53);
        }
    }

    public void pointerReleased(int x, int y) {
        switch (this.selectedCompId) {
            default: 
        }
        if (Keys.isKeyPressed(53)) {
            this.keyReleased(53);
            Keys.keyReleased(53);
        }
    }
}

