/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic.screen;

import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.Sprite;
import sk.inlogic.Level;
import sk.inlogic.MainCanvas;
import sk.inlogic.RMSObjects;
import sk.inlogic.Resources;
import sk.inlogic.Sounds;
import sk.inlogic.powV2.PowV2ScoreItem;
import sk.inlogic.screen.IScreen;
import sk.inlogic.screen.ScreenGame;
import sk.inlogic.screen.ScreenSelectPack;
import sk.inlogic.text.PreparedText;
import sk.inlogic.util.Keys;
import sk.inlogic.util.Rectangle;

public class ScreenSelectBonusLevel
implements IScreen {
    MainCanvas mainCanvas;
    int mode;
    long modeDelay;
    private static final int COMP_ID_BACK = 0;
    private static final int COMP_ID_ARR_UP = 1;
    private static final int COMP_ID_ARR_DOWN = 2;
    private static final int COMP_ID_ALLLEVELS = 3;
    private static final int TOTAL_COMP_IDS = 4;
    Rectangle[] rectItems = new Rectangle[4];
    Rectangle[] rectLevel = new Rectangle[20];
    Rectangle rectDialog;
    Rectangle rectSelector;
    private int selectedCompId;
    private int gameMode;
    private PreparedText preparedText;
    private PreparedText levelNum;
    private PreparedText levelStar;
    private Rectangle rectTop;
    private Rectangle rectDown;
    private Rectangle rectBody;
    private int dy = 0;
    private int selectorDx = 0;
    private int selectorDy = 0;
    private int counterX = 0;
    private int counterY = 0;
    private int resourceFrame = 0;
    private int repeats = 0;
    private int repeat = 0;
    private int selectedPack = 0;
    private int selectdLevel = 0;
    private int levelNumber = 0;
    private String[] levelStars = new String[20];
    private String[] levelnames = new String[20];
    private int x = 0;
    private int y = 0;
    private int scoresCount = 0;
    private int count = 0;
    private int interuption = 0;
    public boolean animatedMenu = false;
    int cycle = 10;
    Rectangle selectedLevel;
    Rectangle rectStar;
    int check = 0;

    public ScreenSelectBonusLevel(MainCanvas mainCanvas, int selectedLevel) {
        this.mainCanvas = mainCanvas;
        this.counterX = MainCanvas.counterX;
        this.counterY = MainCanvas.counterY;
        this.selectedPack = 0;
    }

    public void beforeShow() {
        MainCanvas.totalBonusStars = 0;
        Resources.loadImages(new int[]{20, 18, 19});
        System.out.println("haha");
        Resources.loadSprites(new int[]{15, 19, 16, 1, 0});
        Resources.loadGFont(1);
        Resources.loadGFont(0);
        this.preparedText = new PreparedText(Resources.resGFonts[0]);
        this.calculatePositions();
        this.levelNum = new PreparedText(Resources.resGFonts[1]);
        this.levelStar = new PreparedText(Resources.resGFonts[1]);
        for (int i = 0; i < 20; ++i) {
            this.levelStars[i] = null;
            this.levelnames[i] = null;
        }
        RMSObjects.createRMSConnect(9);
        if (!RMSObjects.rmsConnects[9].load()) {
            RMSObjects.rmsConnects[9].create();
        }
        this.prepareLevelStars();
    }

    private void prepareLevelStars() {
        Vector scores = RMSObjects.localScoresBonus.getScoresForGame(0);
        if (scores != null) {
            this.scoresCount = scores.size();
        }
        PowV2ScoreItem scoreItem = null;
        for (int i = 0; i < 20; ++i) {
            if (i < this.scoresCount) {
                scoreItem = (PowV2ScoreItem)scores.elementAt(i);
                this.levelStars[i] = Integer.toString(scoreItem.scoreValue);
                MainCanvas.totalBonusStars += scoreItem.scoreValue;
                ++this.count;
                continue;
            }
            this.levelStars[i] = null;
        }
    }

    public void afterHide() {
        Resources.freeImages(new int[]{20, 18, 19});
        Resources.freeSprites(new int[]{15, 19, 15, 16, 1, 0});
        Resources.freeGFont(0);
    }

    public void beforeInteruption() {
        MainCanvas.soundManager.Stop();
    }

    public void afterInteruption() {
        MainCanvas.soundManager.Play(Sounds.SOUND_MENU, -1);
    }

    private void calculatePositions() {
        int fkWidth = Resources.resSprs[0].getWidth();
        int fkHeight = Resources.resSprs[0].getHeight();
        int sprArrwUpDownWidth = Resources.resSprs[19].getWidth();
        int sprArrwUpDownHeigth = Resources.resSprs[19].getHeight();
        int itemWidth = Resources.resSprs[16].getWidth();
        int marginLeft = fkWidth;
        this.rectDialog = new Rectangle(marginLeft, 0, MainCanvas.WIDTH - (marginLeft << 1), this.mainCanvas.getHeight());
        this.rectTop = new Rectangle(0, 0, this.mainCanvas.getWidth(), Resources.resSprs[16].getHeight());
        this.rectDown = new Rectangle(0, this.mainCanvas.getHeight() - Resources.resSprs[16].getHeight(), this.mainCanvas.getWidth(), Resources.resSprs[16].getHeight());
        this.rectBody = new Rectangle(Resources.resSprs[16].getWidth() / 2, this.rectTop.height, this.mainCanvas.getWidth() - Resources.resSprs[16].getWidth() / 2, this.mainCanvas.getHeight() - this.rectTop.height - this.rectDown.height);
        this.rectItems[0] = new Rectangle(MainCanvas.WIDTH - itemWidth - (itemWidth >> 1), MainCanvas.HEIGHT - fkHeight, itemWidth + (itemWidth >> 1), fkHeight);
        this.rectItems[1] = new Rectangle(this.rectTop.getCenterX() - sprArrwUpDownWidth / 2, this.rectTop.getCenterY() - sprArrwUpDownHeigth / 2, sprArrwUpDownWidth, sprArrwUpDownHeigth);
        this.rectItems[2] = new Rectangle(this.rectDown.getCenterX() - sprArrwUpDownWidth / 2, this.rectDown.getCenterY() - sprArrwUpDownHeigth / 2, sprArrwUpDownWidth, sprArrwUpDownHeigth);
        this.rectItems[3] = new Rectangle(0, this.rectTop.getCenterY() + sprArrwUpDownHeigth, this.mainCanvas.getWidth(), this.mainCanvas.getHeight() - this.rectTop.height - this.rectDown.height);
        this.dy = Resources.resSprs[16].getHeight();
        this.selectorDx = Resources.resSprs[16].getWidth();
        this.selectorDy = this.dy;
    }

    public void update(long lastRunLenght) {
    }

    public void paint(Graphics g) {
        g.setColor(0, 20, 80);
        g.fillRect(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
        this.paintTop(g);
        this.paintBody(g);
        this.paintBottom(g);
        this.paintFK(g);
    }

    private void paintTop(Graphics g) {
    }

    private void paintBottom(Graphics g) {
    }

    private void paintBody(Graphics g) {
        Sprite level = Resources.resSprs[15];
        int posunX = (this.mainCanvas.getWidth() - 2 * this.rectBody.x - 4 * level.getWidth()) / 4;
        int posunY = (this.mainCanvas.getHeight() - 2 * this.rectBody.y - 5 * level.getHeight()) / 4;
        System.out.println("pX: " + posunX + "  pY: " + posunY);
        switch (this.selectedPack) {
            case 0: {
                this.levelNumber = 0;
                break;
            }
            default: {
                this.levelNumber = 0;
            }
        }
        for (int y = 0; y < 5; ++y) {
            for (int x = 0; x < 4; ++x) {
                if (this.rectBody.y + y * (level.getHeight() + posunY) < this.rectBody.height + this.rectBody.y - level.getHeight()) {
                    level.setPosition(this.rectBody.x + x * (posunX + level.getWidth()), this.rectBody.y + y * level.getHeight());
                }
                if (this.levelNumber < 20) {
                    this.rectLevel[this.levelNumber] = new Rectangle(this.rectBody.x + x * (posunX + level.getWidth()), this.rectBody.y + y * (level.getHeight() + posunY), level.getWidth(), level.getHeight());
                }
                if (level.getX() == x * posunX + this.rectBody.x + this.counterX * level.getWidth() + this.x * level.getWidth() && level.getY() == y * posunY + this.rectBody.y + this.counterY * level.getHeight() + this.y * level.getHeight()) {
                    System.out.println("levelNumber: " + this.levelNumber);
                    System.out.println("preslo-: " + level.getX() + " " + level.getY());
                    System.out.println("kokot>: " + (x * posunX + this.rectBody.x + this.counterX * level.getWidth() + this.x * level.getWidth()) + " " + (this.rectBody.y + this.counterY * level.getHeight() + this.y * level.getHeight()));
                    System.out.println("--------------------------------------------------------------------");
                    level.setFrame(0);
                } else {
                    System.out.println("levelNumber: " + this.levelNumber);
                    System.out.println("ale nie nepreslo>: " + level.getX() + " " + level.getY());
                    System.out.println("som tu ty pica>: " + (x * posunX + this.rectBody.x + this.counterX * level.getWidth() + this.x * level.getWidth()) + " " + (this.rectBody.y + this.counterY * level.getHeight() + this.y * level.getHeight()));
                    level.setFrame(0);
                }
                if (this.rectBody.y + y * level.getHeight() - this.repeat * level.getHeight() >= this.rectBody.y + this.rectBody.height || this.rectBody.y + y * level.getHeight() - this.repeat * level.getHeight() < this.rectBody.y) continue;
                int s = 0;
                try {
                    if (this.levelStars[this.levelNumber] != null) {
                        s = Integer.parseInt(this.levelStars[this.levelNumber]);
                    }
                }
                catch (Exception r) {
                    // empty catch block
                }
                ++this.levelNumber;
                g.setColor(0, 49, 49);
                String num = this.levelNumber < 10 ? " " + this.levelNumber + " " : "" + this.levelNumber;
                this.levelNum.prepareText(num, level.getWidth());
                switch (s) {
                    case 1: {
                        this.levelStar.prepareText("*", level.getWidth());
                        break;
                    }
                    case 2: {
                        this.levelStar.prepareText("**", level.getWidth());
                        break;
                    }
                    case 3: {
                        this.levelStar.prepareText("***", level.getWidth());
                        break;
                    }
                    default: {
                        this.levelStar.prepareText("", level.getWidth());
                    }
                }
                this.selectedLevel = new Rectangle(this.rectBody.x + x * (level.getWidth() + posunX), level.getY() - this.levelNum.getTextHeight() / 2, level.getWidth(), level.getHeight());
                this.rectStar = new Rectangle(this.rectBody.x + x * (level.getWidth() + posunX), level.getY() - this.levelNum.getTextHeight() / 2, level.getWidth(), level.getHeight());
                if (this.levelNumber <= this.count + 1) {
                    level.paint(g);
                    this.levelNum.drawText(g, this.selectedLevel, 0, 3);
                    this.levelStar.drawText(g, this.rectStar, 0, 33);
                    continue;
                }
                if (this.rectBody.y + y * (level.getHeight() + posunY) >= this.rectBody.height + this.rectBody.y - level.getHeight() / 4) continue;
                level.paint(g);
                g.drawImage(Resources.resImgs[20], level.getX() + (level.getWidth() >> 1), level.getY() + (level.getHeight() >> 1), 3);
            }
        }
        ++this.check;
    }

    private void paintFK(Graphics g) {
        Sprite funKey = Resources.resSprs[16];
        Sprite fk = Resources.resSprs[0];
        funKey.setFrame(1);
        funKey.setPosition(this.mainCanvas.getWidth() - funKey.getWidth() / 2, this.mainCanvas.getHeight() - funKey.getHeight());
        funKey.paint(g);
        funKey.setFrame(0);
        funKey.setPosition(this.mainCanvas.getWidth() - funKey.getWidth() / 2 - funKey.getWidth(), this.mainCanvas.getHeight() - funKey.getHeight());
        funKey.paint(g);
        fk.setFrame(9);
        fk.setPosition(MainCanvas.WIDTH - fk.getWidth(), this.mainCanvas.getHeight() - funKey.getHeight() + funKey.getHeight() / 2 - fk.getHeight() / 2);
        fk.paint(g);
    }

    public void keyPressed(int keyCode) {
        if (keyCode == 49 || keyCode == 51 || keyCode == 57 || keyCode == 55) {
            // empty if block
        }
    }

    public void keyReleased(int keyCode) {
        if (keyCode != 49 && keyCode != 51 && keyCode != 57 && keyCode != 55) {
            if (Keys.isFKLeftCode(keyCode)) {
                ScreenGame sg;
                if (this.selectdLevel <= this.count) {
                    Level.getBonusLevel(this.selectdLevel);
                    this.gameMode = Level.gameMode;
                    sg = new ScreenGame(this.mainCanvas, this.gameMode, this.selectdLevel, true);
                    this.mainCanvas.changeLastActiveScreen(sg);
                    MainCanvas.soundManager.Stop();
                    if (MainCanvas.soundManager.IsSoundOn()) {
                        MainCanvas.soundManager.Play(Sounds.SOUND_GAME, -1);
                    }
                }
                if (this.count == 2 && this.selectdLevel == 0) {
                    Level.getBonusLevel(this.selectdLevel);
                    this.gameMode = Level.gameMode;
                    sg = new ScreenGame(this.mainCanvas, this.gameMode, this.selectdLevel, true);
                    this.mainCanvas.changeLastActiveScreen(sg);
                    MainCanvas.soundManager.Stop();
                    if (MainCanvas.soundManager.IsSoundOn()) {
                        MainCanvas.soundManager.Play(Sounds.SOUND_GAME, -1);
                    }
                }
            } else if (Keys.isFKRightCode(keyCode)) {
                this.mainCanvas.changeLastActiveScreen(new ScreenSelectPack(this.mainCanvas, 1));
            } else if (Keys.isActionGeneratedByKey(5, keyCode)) {
                Level.getBonusLevel(this.selectdLevel);
                this.gameMode = Level.gameMode;
                ScreenGame sg = new ScreenGame(this.mainCanvas, this.gameMode, this.selectdLevel, true);
                this.mainCanvas.changeLastActiveScreen(sg);
                MainCanvas.soundManager.Stop();
                if (MainCanvas.soundManager.IsSoundOn()) {
                    MainCanvas.soundManager.Play(Sounds.SOUND_GAME, -1);
                }
                if (this.count == 2 && this.selectdLevel == 0) {
                    Level.getBonusLevel(this.selectdLevel);
                    this.gameMode = Level.gameMode;
                    sg = new ScreenGame(this.mainCanvas, this.gameMode, this.selectdLevel, true);
                    this.mainCanvas.changeLastActiveScreen(sg);
                    MainCanvas.soundManager.Stop();
                    if (MainCanvas.soundManager.IsSoundOn()) {
                        MainCanvas.soundManager.Play(Sounds.SOUND_GAME, -1);
                    }
                }
            } else if (Keys.isActionGeneratedByKey(3, keyCode)) {
                if (this.counterX > 0) {
                    --this.counterX;
                    --MainCanvas.counterX;
                    --this.selectdLevel;
                }
            } else if (Keys.isActionGeneratedByKey(4, keyCode)) {
                if (this.counterX < 3) {
                    ++this.counterX;
                    ++this.selectdLevel;
                    ++MainCanvas.counterX;
                }
            } else if (Keys.isActionGeneratedByKey(1, keyCode)) {
                if (this.counterY > 0) {
                    --this.counterY;
                    --MainCanvas.counterY;
                    this.selectdLevel -= 4;
                } else if (this.selectedPack > 0) {
                    this.counterX = 0;
                    this.counterY = 0;
                    MainCanvas.counterX = 0;
                    MainCanvas.counterY = 0;
                }
            } else if (Keys.isActionGeneratedByKey(2, keyCode) && this.counterY < 4) {
                ++this.counterY;
                ++MainCanvas.counterY;
                this.selectdLevel += 4;
            }
        }
        this.mainCanvas.repaint();
        System.out.println("selectedLevel " + this.selectdLevel);
    }

    public void pointerPressed(int x, int y) {
        block6: for (int i = 0; i < this.rectItems.length; ++i) {
            if (!this.rectItems[i].contains(x, y)) continue;
            this.selectedCompId = i;
            switch (this.selectedCompId) {
                case 1: {
                    Keys.keyPressed(50);
                    Keys.resetAllPressedKeysAndActions();
                    continue block6;
                }
                case 2: {
                    Keys.keyPressed(56);
                    Keys.resetAllPressedKeysAndActions();
                    continue block6;
                }
                case 0: {
                    Keys.keyPressed(-7);
                    continue block6;
                }
                case 3: {
                    continue block6;
                }
            }
        }
    }

    public void pointerDragged(int x, int y) {
        if (!this.rectItems[this.selectedCompId].contains(x, y)) {
            switch (this.selectedCompId) {
                case 1: {
                    Keys.keyReleased(49);
                    break;
                }
                case 2: {
                    Keys.keyReleased(49);
                    break;
                }
                case 0: {
                    Keys.keyReleased(-7);
                    break;
                }
            }
        }
    }

    public void pointerReleased(int x, int y) {
        switch (this.selectedCompId) {
            case 1: {
                this.keyReleased(49);
                this.mainCanvas.repaint();
                break;
            }
            case 2: {
                this.keyReleased(49);
                this.mainCanvas.repaint();
                break;
            }
            case 0: {
                if (!Keys.isKeyPressed(-7)) break;
                this.keyReleased(-7);
                Keys.keyReleased(-7);
                break;
            }
            case 3: {
                for (int i = 0; i < this.rectLevel.length; ++i) {
                    if (!this.rectLevel[i].contains(x, y) || i + this.selectedPack * 20 > this.count) continue;
                    Level.getBonusLevel(i + this.selectedPack * 20);
                    System.out.println("level: " + (i + this.selectedPack * 20));
                    this.gameMode = Level.gameMode;
                    ScreenGame sg = new ScreenGame(this.mainCanvas, this.gameMode, i + this.selectedPack * 20, true);
                    this.mainCanvas.changeLastActiveScreen(sg);
                    MainCanvas.soundManager.Stop();
                    if (!MainCanvas.soundManager.IsSoundOn()) continue;
                    MainCanvas.soundManager.Play(Sounds.SOUND_GAME, -1);
                }
                this.mainCanvas.repaint();
                break;
            }
            default: {
                this.keyReleased(5);
            }
        }
    }
}

