/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.Sprite;
import sk.inlogic.Block;
import sk.inlogic.Flame;
import sk.inlogic.Jewel;
import sk.inlogic.Level;
import sk.inlogic.MainCanvas;
import sk.inlogic.Resources;
import sk.inlogic.Sounds;
import sk.inlogic.Storm;
import sk.inlogic.rms.RMSHandler;
import sk.inlogic.util.Particles;
import sk.inlogic.util.RandomNum;
import sk.inlogic.util.Rectangle;

public class Game
implements RMSHandler {
    public static final int MODE_MOVES = 0;
    public static final int MODE_TIME_ATTACK = 1;
    public static final int MODE_ESCAPE = 2;
    public static final int MODE_FALL = 3;
    public static final int MODE_MIXED_TIME_AND_BLOCKS = 4;
    public static final int MODE_BLOCK = 5;
    public static final int MODE_MIXED_TIME_AND_ESCAPE = 6;
    public static final int MODE_MIXED_TIME_AND_MOVES = 7;
    public static final int MODE_ENDLESS = 20;
    public static final int MODE_ACTION = 60;
    public static final int MODE_MIXED = 8;
    public static final int JEWELSINROW = 8;
    public static final int JEWELSCOUNT = 64;
    private static final int SCOREPERJEWEL = 5;
    private static int TIMEPERJEWEL;
    private static final int STATUS_INITLEVEL = 0;
    private static final int STATUS_FALL = 1;
    private static final int STATUS_READY = 2;
    private static final int STATUS_SWAP = 3;
    private static final int STATUS_SWAPBACK = 4;
    private static final int STATUS_DESTROY = 5;
    private static final int STATUS_LEVELDONE = 6;
    private static final int STATUS_GAMEOVER = 7;
    private static final int STATUS_ESCAPESWAP = 8;
    private int loseMode = 0;
    public static final int LOSE_OUT_OF_MOVES = 1;
    public static final int LOSE_OUT_OF_OPTIONS = 2;
    public static final int LOSE_OUT_OF_TIME = 3;
    public static final int LOSE_BUBBLE_ESCAPED = 4;
    public static final int LOSE_SCORE = 5;
    public static int lose;
    private Jewel[] jewels = new Jewel[64];
    private Jewel[] fallBonus = new Jewel[8];
    public static Rectangle rectGameArea;
    private int status;
    private int gameMode;
    private int gameLevel;
    private long timeElapsed;
    private int score;
    private int scoreBomb;
    private int scoreEsc;
    private int scoreDown;
    private int multiplicator;
    public int hint;
    private int selectorFrame;
    private long progressMain;
    private long progressMainFinal;
    public static int progressSecondary;
    private int progressSecondaryFinal;
    private int maxSpecialGems;
    public int synchro;
    private boolean isFinishedScreen;
    private int selectorPos;
    private int swappedPos;
    private boolean isDragged;
    private int totalColors;
    private boolean allowEscapeSwap;
    private boolean penalty;
    private boolean block = false;
    private boolean ecs = false;
    private boolean down = false;
    private boolean goodScore = false;
    public static int lc;
    public static boolean blockChecker;
    public static boolean bhint;

    public void restartGame(int gameMode, int gameLevel, int score, int totalCol) {
        int i;
        Storm.reset(0);
        this.gameMode = gameMode;
        this.gameLevel = gameLevel;
        this.score = score;
        this.penalty = false;
        this.selectorFrame = 1;
        this.totalColors = totalCol;
        rectGameArea = new Rectangle(MainCanvas.WIDTH - (Jewel.BLOCKSIZE << 3) >> 1, MainCanvas.HEIGHT - (Jewel.BLOCKSIZE << 3) >> 1, Jewel.BLOCKSIZE << 3, Jewel.BLOCKSIZE << 3);
        this.synchro = 0;
        this.selectorPos = 27;
        this.isDragged = false;
        this.timeElapsed = 0L;
        this.status = 0;
        this.isFinishedScreen = false;
        this.multiplicator = 1;
        this.hint = -1;
        Block.reset();
        Flame.reset();
        Particles.resetParticles();
        this.initLevelVariables();
        int deltaY0 = -8 * Jewel.BLOCKSIZE;
        for (i = 0; i < 64; ++i) {
            if (i < 8) {
                this.fallBonus[i] = null;
            }
            this.jewels[i] = new Jewel();
            do {
                this.jewels[i].setColor(RandomNum.getRandomUInt(this.totalColors));
            } while (!this.validatePosition(i));
            this.jewels[i].setAccY(256);
            if (i < 56) continue;
            this.jewels[i].setDeltaY(deltaY0 - RandomNum.getRandomUInt(2 * Jewel.BLOCKSIZE));
        }
        this.initModeVariables();
        for (i = 55; i >= 0; --i) {
            this.jewels[i].setDeltaY(this.jewels[i + 8].getDeltaY() - RandomNum.getRandomUInt(2 * Jewel.BLOCKSIZE));
        }
        this.scoreBomb = 0;
        this.scoreEsc = 0;
        this.scoreDown = 0;
        this.block = false;
        this.ecs = false;
        this.down = false;
    }

    private void initLevelVariables() {
        switch (this.gameMode) {
            case 20: {
                TIMEPERJEWEL = 0;
                this.progressMainFinal = 500 * (this.gameLevel + 2) * (this.gameLevel + 2);
                break;
            }
            case 0: {
                this.progressMainFinal = Level.moves;
                break;
            }
            case 7: {
                this.progressMainFinal = Level.time * 1000L;
                TIMEPERJEWEL = 400 - (this.gameLevel - 7) * 50;
                if (this.gameLevel > 6) {
                    TIMEPERJEWEL = 400 - (this.gameLevel - 7) * 50;
                    break;
                }
                if (this.gameLevel > 4) {
                    TIMEPERJEWEL = 400 - (this.gameLevel - 5) * 100;
                    break;
                }
                if (this.gameLevel > 2) {
                    TIMEPERJEWEL = 300 - (this.gameLevel - 3) * 75;
                    break;
                }
                TIMEPERJEWEL = 300 - (this.gameLevel - 1) * 150;
                break;
            }
            case 1: {
                this.progressMainFinal = Level.time * 1000L;
                TIMEPERJEWEL = 400 - (this.gameLevel - 7) * 50;
                if (this.gameLevel > 6) {
                    TIMEPERJEWEL = 400 - (this.gameLevel - 7) * 50;
                    break;
                }
                if (this.gameLevel > 4) {
                    TIMEPERJEWEL = 400 - (this.gameLevel - 5) * 100;
                    break;
                }
                if (this.gameLevel > 2) {
                    TIMEPERJEWEL = 300 - (this.gameLevel - 3) * 75;
                    break;
                }
                TIMEPERJEWEL = 300 - (this.gameLevel - 1) * 150;
                break;
            }
            case 8: {
                this.progressMainFinal = Level.time * 1000L;
                TIMEPERJEWEL = 400 - (this.gameLevel - 7) * 50;
                if (this.gameLevel > 6) {
                    TIMEPERJEWEL = 400 - (this.gameLevel - 7) * 50;
                    break;
                }
                if (this.gameLevel > 4) {
                    TIMEPERJEWEL = 400 - (this.gameLevel - 5) * 100;
                    break;
                }
                if (this.gameLevel > 2) {
                    TIMEPERJEWEL = 300 - (this.gameLevel - 3) * 75;
                    break;
                }
                TIMEPERJEWEL = 300 - (this.gameLevel - 1) * 150;
                break;
            }
            case 60: {
                if (this.gameLevel > 6) {
                    this.progressMainFinal = 90000 - (this.gameLevel - 7) * 5000;
                    TIMEPERJEWEL = 400 - (this.gameLevel - 7) * 50;
                    break;
                }
                if (this.gameLevel > 4) {
                    this.progressMainFinal = 100000 - (this.gameLevel - 5) * 10000;
                    TIMEPERJEWEL = 400 - (this.gameLevel - 5) * 100;
                    break;
                }
                if (this.gameLevel > 2) {
                    this.progressMainFinal = 110000 - (this.gameLevel - 3) * 10000;
                    TIMEPERJEWEL = 300 - (this.gameLevel - 3) * 75;
                    break;
                }
                this.progressMainFinal = 120000 - (this.gameLevel - 1) * 10000;
                TIMEPERJEWEL = 300 - (this.gameLevel - 1) * 150;
                break;
            }
            case 2: {
                this.maxSpecialGems = 4 + Level.escapedJewels;
                TIMEPERJEWEL = 0;
                this.progressMainFinal = Level.escapedJewels * 3000 / 2;
                this.progressSecondaryFinal = Level.escapedJewels;
                break;
            }
            case 6: {
                this.maxSpecialGems = 4 + Level.escapedJewels;
                TIMEPERJEWEL = 0;
                this.progressMainFinal = 3000L;
                this.progressSecondaryFinal = Level.escapedJewels;
                break;
            }
            case 3: {
                this.maxSpecialGems = 4 + Level.diamondsCount;
                TIMEPERJEWEL = 0;
                this.progressMainFinal = Level.moves;
                this.progressSecondaryFinal = Level.diamondsCount;
                break;
            }
            case 4: {
                TIMEPERJEWEL = 0;
                this.progressMainFinal = Level.time * 1000L;
                lc = this.gameLevel;
                Block.createBlockShape(this.gameLevel);
                break;
            }
            case 5: {
                this.progressMainFinal = Level.moves;
                lc = this.gameLevel;
                Block.createBlockShape(this.gameLevel);
            }
        }
    }

    private void initModeVariables() {
        switch (this.gameMode) {
            case 0: {
                this.progressMain = 0L;
                break;
            }
            case 1: {
                this.progressMain = this.progressMainFinal;
                break;
            }
            case 20: {
                this.progressMain = 0L;
                break;
            }
            case 2: {
                this.progressMain = this.progressMainFinal;
                this.jewels[56 + RandomNum.getRandomUInt(8)].setBonus(7);
                progressSecondary = 0;
                break;
            }
            case 60: {
                this.progressMain = this.progressMainFinal / 2L;
                break;
            }
            case 3: {
                this.jewels[RandomNum.getRandomUInt(8)].setBonus(6);
                progressSecondary = 0;
            }
            case 4: {
                this.progressMain = this.progressMainFinal;
                break;
            }
            case 6: {
                this.progressMain = 0L;
                progressSecondary = 0;
                break;
            }
            case 5: {
                this.progressMain = 0L;
                break;
            }
            case 7: {
                this.progressMain = this.progressMainFinal;
            }
        }
    }

    private boolean validatePosition(int pos) {
        if (pos / 8 > 1 && this.jewels[pos].isColorDepended() && this.jewels[pos].getColor() == this.jewels[pos - 8].getColor() && this.jewels[pos - 8].isColorDepended() && this.jewels[pos].getColor() == this.jewels[pos - 16].getColor() && this.jewels[pos - 16].isColorDepended()) {
            return false;
        }
        return pos % 8 <= 1 || !this.jewels[pos].isColorDepended() || this.jewels[pos].getColor() != this.jewels[pos - 1].getColor() || !this.jewels[pos - 1].isColorDepended() || this.jewels[pos].getColor() != this.jewels[pos - 2].getColor() || !this.jewels[pos - 2].isColorDepended();
    }

    public void moveUp() {
        if ((this.status == 2 || this.status == 5 || this.status == 1) && this.selectorPos >= 8) {
            if (this.isDragged) {
                this.swappedPos = this.selectorPos - 8;
                this.swap(this.selectorPos, this.swappedPos);
                this.selectorPos -= 8;
                this.swappedPos += 8;
                this.setStatus(3);
                MainCanvas.moveCheck = true;
            } else {
                this.selectorPos -= 8;
            }
        }
    }

    public void moveDown() {
        if ((this.status == 2 || this.status == 5 || this.status == 1) && this.selectorPos < 56) {
            if (this.isDragged) {
                this.swappedPos = this.selectorPos + 8;
                this.swap(this.selectorPos, this.swappedPos);
                this.selectorPos += 8;
                this.swappedPos -= 8;
                this.setStatus(3);
                MainCanvas.moveCheck = true;
            } else {
                this.selectorPos += 8;
            }
        }
    }

    public void moveLeft() {
        if ((this.status == 2 || this.status == 5 || this.status == 1) && this.selectorPos % 8 > 0) {
            if (this.isDragged) {
                this.swappedPos = this.selectorPos - 1;
                this.swap(this.selectorPos, this.swappedPos);
                --this.selectorPos;
                ++this.swappedPos;
                this.setStatus(3);
                MainCanvas.moveCheck = true;
            } else {
                --this.selectorPos;
            }
        }
    }

    public void moveRight() {
        if ((this.status == 2 || this.status == 5 || this.status == 1) && this.selectorPos % 8 < 7) {
            if (this.isDragged) {
                this.swappedPos = this.selectorPos + 1;
                this.swap(this.selectorPos, this.swappedPos);
                ++this.selectorPos;
                --this.swappedPos;
                this.setStatus(3);
                MainCanvas.moveCheck = true;
            } else {
                ++this.selectorPos;
            }
        }
    }

    private void swap(int pos1, int pos2) {
        int dx = 0;
        int dy = 0;
        int vx = 0;
        int vy = 0;
        if (pos2 == pos1 - 8) {
            dy = Jewel.BLOCKSIZE;
            vy = -Jewel.MOVE_VELOCITY;
        } else if (pos2 == pos1 + 8) {
            dy = -Jewel.BLOCKSIZE;
            vy = Jewel.MOVE_VELOCITY;
        } else if (pos2 == pos1 - 1) {
            dx = Jewel.BLOCKSIZE;
            vx = -Jewel.MOVE_VELOCITY;
        } else if (pos2 == pos1 + 1) {
            dx = -Jewel.BLOCKSIZE;
            vx = Jewel.MOVE_VELOCITY;
        } else {
            return;
        }
        this.jewels[pos1].setDeltaX(dx);
        this.jewels[pos1].setDeltaY(dy);
        this.jewels[pos1].setVelX(vx);
        this.jewels[pos1].setVelY(vy);
        this.jewels[pos2].setDeltaX(-dx);
        this.jewels[pos2].setDeltaY(-dy);
        this.jewels[pos2].setVelX(-vx);
        this.jewels[pos2].setVelY(-vy);
        Jewel gb = this.jewels[pos1];
        this.jewels[pos1] = this.jewels[pos2];
        this.jewels[pos2] = gb;
        if (this.jewels[pos1].getResource() == 0) {
            this.jewels[pos1].startAnimation(1);
        }
        if (this.jewels[pos2].getResource() == 0) {
            this.jewels[pos2].startAnimation(1);
        }
    }

    public void DragOrDrop() {
        if (this.status == 2) {
            boolean bl = this.isDragged = !this.isDragged;
            if (!this.isDragged) {
                this.selectorFrame = 1;
            }
        }
    }

    public void bomb() {
        this.jewels[this.selectorPos].setBonus(5);
    }

    public void pointerPressed(int x, int y) {
        if (this.status == 2 || this.status == 5 || this.status == 1) {
            int i = (x - Game.rectGameArea.x) / (Game.rectGameArea.width / 8);
            int j = (y - 1 - Game.rectGameArea.y) / (Game.rectGameArea.height / 8);
            int pointedPos = j * 8 + i;
            if (this.isDragged) {
                if (this.selectorPos == pointedPos - 1) {
                    this.moveRight();
                } else if (this.selectorPos == pointedPos + 1) {
                    this.moveLeft();
                } else if (this.selectorPos == pointedPos - 8) {
                    this.moveDown();
                } else if (this.selectorPos == pointedPos + 8) {
                    this.moveUp();
                } else {
                    this.selectorPos = pointedPos;
                }
            } else {
                this.selectorPos = pointedPos;
            }
            if (this.status == 2) {
                this.isDragged = true;
            }
        }
    }

    public int getMode() {
        return this.gameMode;
    }

    public int getLevel() {
        return this.gameLevel;
    }

    public int getScore() {
        return this.score;
    }

    public int getBombScore() {
        return this.scoreBomb;
    }

    public int getEscScore() {
        return this.scoreEsc;
    }

    public int getDownScore() {
        return this.scoreDown;
    }

    public int getTimeInSec() {
        return (int)(this.timeElapsed / 1000L);
    }

    public int getProgresRate() {
        return (int)((this.progressMain << 8) / this.progressMainFinal);
    }

    public String getProgresText() {
        return Integer.toString(progressSecondary) + "/" + Integer.toString(this.progressSecondaryFinal);
    }

    public boolean isGameOver() {
        return this.isFinishedScreen && this.status == 7;
    }

    public boolean isLevelDone() {
        return this.isFinishedScreen && this.status == 6;
    }

    public void update(long lastRunLenght) {
        if (this.isFinishedScreen) {
            return;
        }
        this.updateJewels(lastRunLenght);
        this.selectorFrame = this.isDragged ? (this.selectorFrame + 1) % 4 : 1;
        switch (this.status) {
            case 0: {
                this.updateStatusInitLevel();
                break;
            }
            case 2: {
                this.updateTime(lastRunLenght);
                break;
            }
            case 3: {
                this.updateStatusSwap();
                this.updateTime(lastRunLenght);
                break;
            }
            case 4: {
                this.updateStatusSwapBack();
                this.updateTime(lastRunLenght);
                break;
            }
            case 1: {
                this.updateStatusFall();
                this.updateTime(lastRunLenght);
                break;
            }
            case 5: {
                this.updateStatusDestroy();
                this.updateTime(lastRunLenght);
                break;
            }
            case 8: {
                this.updateStatusSwap();
                this.updateStatusEscapeSwap();
                this.updateTime(lastRunLenght);
                break;
            }
            case 6: 
            case 7: {
                this.updateStatusFinishLevel();
            }
        }
        Particles.update();
        Flame.update();
    }

    private void updateTime(long lastRunLenght) {
        if (lastRunLenght < 1000L) {
            this.timeElapsed += lastRunLenght;
            if (!(this.gameMode != 1 && this.gameMode != 60 && this.gameMode != 2 && this.gameMode != 7 && this.gameMode != 4 && this.gameMode != 6 || this.gameMode == 2 && this.status != 2 && this.status != 3 && this.status != 4)) {
                this.progressMain -= lastRunLenght;
                if (this.progressMain < 0L) {
                    if (this.gameMode == 6) {
                        if ((long)this.getTimeInSec() > Level.time) {
                            if (progressSecondary < this.progressSecondaryFinal && this.getScore() < Level.minScore && MainCanvas.moveCounter > Level.moves) {
                                this.setStatus(7);
                            }
                        } else if ((long)this.getTimeInSec() == Level.time) {
                            if (progressSecondary >= this.progressSecondaryFinal && this.getScore() + this.getResidueScore() >= Level.minScore) {
                                this.score += this.getResidueScore();
                                if (MainCanvas.moveCounter == Level.moves) {
                                    this.setStatus(6);
                                }
                            }
                        } else {
                            this.swapEscapeGems();
                        }
                    } else if (this.gameMode == 2) {
                        this.swapEscapeGems();
                    } else if (this.gameMode == 1) {
                        if (Level.minScore <= this.getScore() + this.getResidueScore()) {
                            this.setStatus(6);
                        } else if ((long)this.getTimeInSec() == Level.time) {
                            this.setStatus(7);
                            this.setLoseMode(3);
                        }
                    } else if (this.gameMode == 4) {
                        if (Block.count() > 0) {
                            if ((long)this.getTimeInSec() >= Level.time) {
                                this.setStatus(7);
                                this.setLoseMode(3);
                            } else {
                                this.setStatus(2);
                            }
                        } else if ((long)this.getTimeInSec() >= Level.time) {
                            if (this.getScore() + this.getResidueScore() >= Level.minScore) {
                                this.score += this.getResidueScore();
                                this.setStatus(6);
                            } else {
                                this.setStatus(7);
                                this.setLoseMode(3);
                            }
                        } else {
                            this.setStatus(2);
                        }
                    } else if (this.gameMode == 7) {
                        if ((long)this.getTimeInSec() >= Level.time) {
                            if (MainCanvas.moveCounter >= Level.moves) {
                                if (Level.minScore <= this.getScore()) {
                                    this.setStatus(6);
                                } else {
                                    this.setStatus(7);
                                    this.setLoseMode(3);
                                }
                            } else {
                                this.setStatus(7);
                                this.setLoseMode(1);
                            }
                        } else {
                            this.setStatus(2);
                        }
                    } else {
                        this.setStatus(7);
                        this.setLoseMode(3);
                    }
                }
            }
        }
    }

    private void updateJewels(long lastRunLenght) {
        this.synchro = (int)((long)this.synchro + lastRunLenght);
        if (this.synchro > 50) {
            for (int pos = 0; pos < 64; ++pos) {
                this.jewels[pos].update();
                if (pos >= 8 || this.fallBonus[pos] == null) continue;
                this.fallBonus[pos].updateFall();
                Sprite Source = Resources.resSprs[7];
                if (this.fallBonus[pos].getBonus() != 6) {
                    Particles.createParticle(Game.rectGameArea.x + pos % 8 * Jewel.BLOCKSIZE + (Jewel.BLOCKSIZE >> 1) + this.fallBonus[pos].getDeltaX(), Game.rectGameArea.y + 7 * Jewel.BLOCKSIZE + (Jewel.BLOCKSIZE >> 1) + this.fallBonus[pos].getDeltaY(), RandomNum.getRandomInt(8, 3), -RandomNum.getRandomUInt(16) - 12, RandomNum.getRandomInt(3), RandomNum.getRandomUInt(4) + 2, Source, 3 + RandomNum.getRandomUInt(3), RandomNum.getRandomUInt(10) + 15, 1);
                    Particles.createParticle(Game.rectGameArea.x + pos % 8 * Jewel.BLOCKSIZE + (Jewel.BLOCKSIZE >> 1) + this.fallBonus[pos].getDeltaX(), Game.rectGameArea.y + 7 * Jewel.BLOCKSIZE + (Jewel.BLOCKSIZE >> 1) + this.fallBonus[pos].getDeltaY(), RandomNum.getRandomInt(8, 3), -RandomNum.getRandomUInt(16) - 12, RandomNum.getRandomInt(3), RandomNum.getRandomUInt(4) + 2, Source, 3 + RandomNum.getRandomUInt(3), RandomNum.getRandomUInt(10) + 15, 1);
                    Particles.createParticle(Game.rectGameArea.x + pos % 8 * Jewel.BLOCKSIZE + (Jewel.BLOCKSIZE >> 1) + this.fallBonus[pos].getDeltaX(), Game.rectGameArea.y + 7 * Jewel.BLOCKSIZE + (Jewel.BLOCKSIZE >> 1) + this.fallBonus[pos].getDeltaY(), RandomNum.getRandomInt(8, 3), -RandomNum.getRandomUInt(16) - 12, RandomNum.getRandomInt(3), RandomNum.getRandomUInt(4) + 2, Source, 3 + RandomNum.getRandomUInt(3), RandomNum.getRandomUInt(10) + 15, 1);
                    Particles.createParticle(Game.rectGameArea.x + pos % 8 * Jewel.BLOCKSIZE + (Jewel.BLOCKSIZE >> 1) + this.fallBonus[pos].getDeltaX(), Game.rectGameArea.y + 7 * Jewel.BLOCKSIZE + (Jewel.BLOCKSIZE >> 1) + this.fallBonus[pos].getDeltaY(), RandomNum.getRandomInt(8, 3), -RandomNum.getRandomUInt(16) - 12, RandomNum.getRandomInt(3), RandomNum.getRandomUInt(4) + 2, Source, 3 + RandomNum.getRandomUInt(3), RandomNum.getRandomUInt(10) + 15, 1);
                    Particles.createParticle(Game.rectGameArea.x + pos % 8 * Jewel.BLOCKSIZE + (Jewel.BLOCKSIZE >> 1) + this.fallBonus[pos].getDeltaX(), Game.rectGameArea.y + 7 * Jewel.BLOCKSIZE + (Jewel.BLOCKSIZE >> 1) + this.fallBonus[pos].getDeltaY(), RandomNum.getRandomInt(8, 3), -RandomNum.getRandomUInt(16) - 12, RandomNum.getRandomInt(3), RandomNum.getRandomUInt(4) + 2, Source, 3 + RandomNum.getRandomUInt(3), RandomNum.getRandomUInt(10) + 15, 1);
                    Particles.createParticle(Game.rectGameArea.x + pos % 8 * Jewel.BLOCKSIZE + (Jewel.BLOCKSIZE >> 1) + this.fallBonus[pos].getDeltaX(), Game.rectGameArea.y + 7 * Jewel.BLOCKSIZE + (Jewel.BLOCKSIZE >> 1) + this.fallBonus[pos].getDeltaY(), RandomNum.getRandomInt(8, 3), -RandomNum.getRandomUInt(16) - 12, RandomNum.getRandomInt(3), RandomNum.getRandomUInt(4) + 2, Source, 3 + RandomNum.getRandomUInt(3), RandomNum.getRandomUInt(10) + 15, 1);
                    Particles.createParticle(Game.rectGameArea.x + pos % 8 * Jewel.BLOCKSIZE + (Jewel.BLOCKSIZE >> 1) + this.fallBonus[pos].getDeltaX(), Game.rectGameArea.y + 7 * Jewel.BLOCKSIZE + (Jewel.BLOCKSIZE >> 1) + this.fallBonus[pos].getDeltaY(), RandomNum.getRandomInt(8, 3), -RandomNum.getRandomUInt(16) - 12, RandomNum.getRandomInt(3), RandomNum.getRandomUInt(4) + 2, Source, 3 + RandomNum.getRandomUInt(3), RandomNum.getRandomUInt(10) + 15, 1);
                    Particles.createParticle(Game.rectGameArea.x + pos % 8 * Jewel.BLOCKSIZE + (Jewel.BLOCKSIZE >> 1) + this.fallBonus[pos].getDeltaX(), Game.rectGameArea.y + 7 * Jewel.BLOCKSIZE + (Jewel.BLOCKSIZE >> 1) + this.fallBonus[pos].getDeltaY(), RandomNum.getRandomInt(8, 3), -RandomNum.getRandomUInt(16) - 12, RandomNum.getRandomInt(3), RandomNum.getRandomUInt(4) + 2, Source, 3 + RandomNum.getRandomUInt(3), RandomNum.getRandomUInt(10) + 15, 1);
                }
                if (this.fallBonus[pos].getDeltaY() <= 3 * Jewel.BLOCKSIZE / 2) continue;
                Particles.createParticle(Game.rectGameArea.x + pos % 8 * Jewel.BLOCKSIZE + (Jewel.BLOCKSIZE >> 1) + this.fallBonus[pos].getDeltaX(), Game.rectGameArea.y + 7 * Jewel.BLOCKSIZE + (Jewel.BLOCKSIZE >> 1) + this.fallBonus[pos].getDeltaY(), RandomNum.getRandomInt(8, 3), -RandomNum.getRandomUInt(16) - 12, RandomNum.getRandomInt(3), RandomNum.getRandomUInt(4) + 2, Source, 3 + RandomNum.getRandomUInt(3), RandomNum.getRandomUInt(10) + 15, 1);
                Particles.createParticle(Game.rectGameArea.x + pos % 8 * Jewel.BLOCKSIZE + (Jewel.BLOCKSIZE >> 1) + this.fallBonus[pos].getDeltaX(), Game.rectGameArea.y + 7 * Jewel.BLOCKSIZE + (Jewel.BLOCKSIZE >> 1) + this.fallBonus[pos].getDeltaY(), RandomNum.getRandomInt(8, 3), -RandomNum.getRandomUInt(16) - 12, RandomNum.getRandomInt(3), RandomNum.getRandomUInt(4) + 2, Source, 3 + RandomNum.getRandomUInt(3), RandomNum.getRandomUInt(10) + 15, 1);
                Particles.createParticle(Game.rectGameArea.x + pos % 8 * Jewel.BLOCKSIZE + (Jewel.BLOCKSIZE >> 1) + this.fallBonus[pos].getDeltaX(), Game.rectGameArea.y + 7 * Jewel.BLOCKSIZE + (Jewel.BLOCKSIZE >> 1) + this.fallBonus[pos].getDeltaY(), RandomNum.getRandomInt(8, 3), -RandomNum.getRandomUInt(16) - 12, RandomNum.getRandomInt(3), RandomNum.getRandomUInt(4) + 2, Source, 3 + RandomNum.getRandomUInt(3), RandomNum.getRandomUInt(10) + 15, 1);
                Particles.createParticle(Game.rectGameArea.x + pos % 8 * Jewel.BLOCKSIZE + (Jewel.BLOCKSIZE >> 1) + this.fallBonus[pos].getDeltaX(), Game.rectGameArea.y + 7 * Jewel.BLOCKSIZE + (Jewel.BLOCKSIZE >> 1) + this.fallBonus[pos].getDeltaY(), RandomNum.getRandomInt(8, 3), -RandomNum.getRandomUInt(16) - 12, RandomNum.getRandomInt(3), RandomNum.getRandomUInt(4) + 2, Source, 3 + RandomNum.getRandomUInt(3), RandomNum.getRandomUInt(10) + 15, 1);
                Particles.createParticle(Game.rectGameArea.x + pos % 8 * Jewel.BLOCKSIZE + (Jewel.BLOCKSIZE >> 1) + this.fallBonus[pos].getDeltaX(), Game.rectGameArea.y + 7 * Jewel.BLOCKSIZE + (Jewel.BLOCKSIZE >> 1) + this.fallBonus[pos].getDeltaY(), RandomNum.getRandomInt(8, 3), -RandomNum.getRandomUInt(16) - 12, RandomNum.getRandomInt(3), RandomNum.getRandomUInt(4) + 2, Source, 3 + RandomNum.getRandomUInt(3), RandomNum.getRandomUInt(10) + 15, 1);
                this.fallBonus[pos] = null;
            }
            this.synchro -= 50;
        }
    }

    private void updateStatusInitLevel() {
        for (int pos = 0; pos < 8; ++pos) {
            if (!this.jewels[pos].isMoving()) continue;
            return;
        }
        this.setStatus(2);
    }

    private void updateStatusFinishLevel() {
        for (int pos = 0; pos < 8; ++pos) {
            if (this.jewels[pos].getDeltaY() >= 8 * Jewel.BLOCKSIZE) continue;
            return;
        }
        this.isFinishedScreen = true;
    }

    private void updateStatusSwap() {
        if (!this.jewels[this.selectorPos].isMoving()) {
            this.isDragged = false;
            this.destroyPosition(this.selectorPos);
            this.destroyPosition(this.swappedPos);
            if (this.status == 3) {
                this.swap(this.selectorPos, this.swappedPos);
                int back = this.selectorPos;
                this.selectorPos = this.swappedPos;
                this.swappedPos = back;
                this.setStatus(4);
            }
        }
    }

    private void updateStatusEscapeSwap() {
        int pos;
        for (pos = 0; pos < 64; ++pos) {
            if (this.jewels[pos].getBonus() != 7) continue;
            if (this.jewels[pos].getDeltaY() < -30) {
                this.setStatus(7);
                this.setLoseMode(4);
                return;
            }
            if (this.jewels[pos].getDeltaY() == 0) continue;
            return;
        }
        for (pos = 0; pos < 64; ++pos) {
            if (this.jewels[pos].getBonus() != 7) continue;
            this.destroyPosition(pos);
            if (pos >= 56) continue;
            this.destroyPosition(pos + 8);
        }
        if (this.status == 8) {
            this.setStatus(2);
        }
    }

    private void destroyPosition(int pos) {
        int toppos;
        int vsize;
        int leftpos = this.getLeftBoundColorBlock(pos);
        int hsize = this.getHSizeOfColorBlock(leftpos);
        if (hsize > 2) {
            this.destroyBlockHorizontally(leftpos, hsize);
            this.setStatus(5);
        }
        if ((vsize = this.getVSizeOfColorBlock(toppos = this.getTopBoundColorPosition(pos))) > 2) {
            this.destroyBlockVertically(toppos, vsize);
            this.setStatus(5);
        }
        if (this.jewels[pos].getBonus() == 2) {
            this.destroyJewelOnPosition(pos);
            this.setStatus(5);
        }
        if (this.jewels[pos].getBonus() == 1 && (pos == this.selectorPos || pos == this.swappedPos) && (this.jewels[this.selectorPos].getBonus() == 1 && this.jewels[this.swappedPos].getBonus() == 1 || this.jewels[this.swappedPos].getBonus() == 1 && this.jewels[this.selectorPos].getBonus() == 1)) {
            this.destroyBonusBombBomb(this.selectorPos);
            this.destroyBonusBombBomb(this.swappedPos);
            this.setStatus(5);
        }
        if (this.jewels[pos].getBonus() == 5 && (pos == this.selectorPos || pos == this.swappedPos) && (this.jewels[this.selectorPos].getBonus() == 5 && this.jewels[this.swappedPos].getBonus() == 5 || this.jewels[this.swappedPos].getBonus() == 5 && this.jewels[this.selectorPos].getBonus() == 5)) {
            this.destroyBonusCrossCross(this.selectorPos);
            this.destroyBonusCrossCross(this.swappedPos);
            this.setStatus(5);
        }
        if (hsize > 2 && vsize > 2) {
            this.jewels[pos].setBonus(5);
            if (hsize > 4) {
                this.jewels[pos - 1].setBonus(2);
            } else if (hsize > 3) {
                if (leftpos < pos - 1) {
                    this.jewels[pos - 1].setBonus(1);
                } else {
                    this.jewels[pos + 1].setBonus(1);
                }
            }
            if (vsize > 4) {
                this.jewels[toppos].setBonus(2);
            } else if (vsize > 3) {
                this.jewels[toppos].setBonus(1);
            }
        } else if (hsize > 4) {
            this.jewels[pos].setBonus(2);
        } else if (vsize > 4) {
            this.jewels[pos].setBonus(2);
        } else if (hsize > 3) {
            this.jewels[pos].setBonus(1);
        } else if (vsize > 3) {
            this.jewels[pos].setBonus(1);
        }
    }

    private void destroyBonusBombCross(int pos) {
    }

    private void destroyBonusBombBomb(int pos) {
        if (pos % 8 > 0) {
            this.destroyJewelOnPosition(pos - 1);
            Flame.setFlame(pos - 1);
            if (pos / 8 > 0) {
                this.destroyJewelOnPosition(pos - 8 - 1);
                Flame.setFlame(pos - 8 - 1);
            }
            if (pos / 8 < 7) {
                this.destroyJewelOnPosition(pos + 8 - 1);
                Flame.setFlame(pos + 8 - 1);
            }
        }
        if (pos % 8 < 7) {
            this.destroyJewelOnPosition(pos + 1);
            Flame.setFlame(pos + 1);
            if (pos / 8 > 0) {
                this.destroyJewelOnPosition(pos - 8 + 1);
                Flame.setFlame(pos - 8 + 1);
            }
            if (pos / 8 < 7) {
                this.destroyJewelOnPosition(pos + 8 + 1);
                Flame.setFlame(pos + 8 + 1);
            }
        }
        if (pos / 8 > 0) {
            this.destroyJewelOnPosition(pos - 8);
            Flame.setFlame(pos - 8);
        }
        if (pos / 8 < 7) {
            this.destroyJewelOnPosition(pos + 8);
            Flame.setFlame(pos + 8);
        }
        this.setExplosionMove(pos);
        this.setStatus(2);
    }

    private void destroyBonusCrossCross(int pos) {
        int i;
        for (i = pos % 8; i < 64; i += 8) {
            this.destroyJewelOnPosition(i);
            Flame.setFlame(i);
        }
        for (i = pos / 8 * 8; i < (pos / 8 + 1) * 8; ++i) {
            this.destroyJewelOnPosition(i);
            Flame.setFlame(i);
        }
        this.setStatus(2);
    }

    private int getLeftBoundColorBlock(int pos) {
        if (!this.jewels[pos].isColorDepended()) {
            return pos;
        }
        while (pos % 8 > 0 && this.jewels[pos - 1].isColorDepended() && this.jewels[pos].getColor() == this.jewels[pos - 1].getColor()) {
            --pos;
        }
        return pos;
    }

    private int getTopBoundColorPosition(int pos) {
        if (!this.jewels[pos].isColorDepended()) {
            return pos;
        }
        while (pos / 8 > 0 && this.jewels[pos - 8].isColorDepended() && this.jewels[pos].getColor() == this.jewels[pos - 8].getColor()) {
            pos -= 8;
        }
        return pos;
    }

    private int getHSizeOfColorBlock(int pos) {
        int size = 1;
        if (!this.jewels[pos].isColorDepended()) {
            return size;
        }
        int i = pos;
        while (i % 8 < 7 && this.jewels[i + 1].isColorDepended() && this.jewels[i].getColor() == this.jewels[i + 1].getColor()) {
            ++size;
            ++i;
        }
        return size;
    }

    private int getVSizeOfColorBlock(int pos) {
        int size = 1;
        if (!this.jewels[pos].isColorDepended()) {
            return size;
        }
        int i = pos;
        while (i / 8 < 7 && this.jewels[i + 8].isColorDepended() && this.jewels[i].getColor() == this.jewels[i + 8].getColor()) {
            ++size;
            i += 8;
        }
        return size;
    }

    private void destroyBlockHorizontally(int pos, int size) {
        for (int i = pos; i < pos + size; ++i) {
            this.destroyJewelOnPosition(i);
        }
    }

    private void destroyBlockVertically(int pos, int size) {
        for (int i = pos; i < pos + size * 8; i += 8) {
            this.destroyJewelOnPosition(i);
        }
    }

    private void destroyJewelOnPosition(int pos) {
        if (this.jewels[pos].getResource() != 1) {
            Block.destroy(pos);
            if (this.gameMode == 5 && blockChecker) {
                Particles.createParticle(Game.rectGameArea.x + pos % 8 * Jewel.BLOCKSIZE + Jewel.BLOCKSIZE / 2, Game.rectGameArea.y + pos / 8 * Jewel.BLOCKSIZE + Jewel.BLOCKSIZE / 2, RandomNum.getRandomInt(8, 3), -RandomNum.getRandomUInt(16) - 12, RandomNum.getRandomInt(3), RandomNum.getRandomUInt(4) + 2, 3, 8933921, RandomNum.getRandomUInt(10) + 15, 0);
                Particles.createParticle(Game.rectGameArea.x + pos % 8 * Jewel.BLOCKSIZE + Jewel.BLOCKSIZE / 2, Game.rectGameArea.y + pos / 8 * Jewel.BLOCKSIZE + Jewel.BLOCKSIZE / 2, RandomNum.getRandomInt(8, 3), -RandomNum.getRandomUInt(16) - 12, RandomNum.getRandomInt(3), RandomNum.getRandomUInt(4) + 2, 3, 8933921, RandomNum.getRandomUInt(10) + 15, 0);
                Particles.createParticle(Game.rectGameArea.x + pos % 8 * Jewel.BLOCKSIZE + Jewel.BLOCKSIZE / 2, Game.rectGameArea.y + pos / 8 * Jewel.BLOCKSIZE + Jewel.BLOCKSIZE / 2, RandomNum.getRandomInt(8, 3), -RandomNum.getRandomUInt(16) - 12, RandomNum.getRandomInt(3), RandomNum.getRandomUInt(4) + 2, 3, 8933921, RandomNum.getRandomUInt(10) + 15, 0);
                Particles.createParticle(Game.rectGameArea.x + pos % 8 * Jewel.BLOCKSIZE + Jewel.BLOCKSIZE / 2, Game.rectGameArea.y + pos / 8 * Jewel.BLOCKSIZE + Jewel.BLOCKSIZE / 2, RandomNum.getRandomInt(8, 3), -RandomNum.getRandomUInt(16) - 12, RandomNum.getRandomInt(3), RandomNum.getRandomUInt(4) + 2, 3, 8933921, RandomNum.getRandomUInt(10) + 15, 0);
                Particles.createParticle(Game.rectGameArea.x + pos % 8 * Jewel.BLOCKSIZE + Jewel.BLOCKSIZE / 2, Game.rectGameArea.y + pos / 8 * Jewel.BLOCKSIZE + Jewel.BLOCKSIZE / 2, RandomNum.getRandomInt(8, 3), -RandomNum.getRandomUInt(16) - 12, RandomNum.getRandomInt(3), RandomNum.getRandomUInt(4) + 2, 3, 8933921, RandomNum.getRandomUInt(10) + 15, 0);
                Particles.createParticle(Game.rectGameArea.x + pos % 8 * Jewel.BLOCKSIZE + Jewel.BLOCKSIZE / 2, Game.rectGameArea.y + pos / 8 * Jewel.BLOCKSIZE + Jewel.BLOCKSIZE / 2, RandomNum.getRandomInt(8, 3), -RandomNum.getRandomUInt(16) - 12, RandomNum.getRandomInt(3), RandomNum.getRandomUInt(4) + 2, 3, 8933921, RandomNum.getRandomUInt(10) + 15, 0);
                Particles.createParticle(Game.rectGameArea.x + pos % 8 * Jewel.BLOCKSIZE + Jewel.BLOCKSIZE / 2, Game.rectGameArea.y + pos / 8 * Jewel.BLOCKSIZE + Jewel.BLOCKSIZE / 2, RandomNum.getRandomInt(8, 3), -RandomNum.getRandomUInt(16) - 12, RandomNum.getRandomInt(3), RandomNum.getRandomUInt(4) + 2, 3, 8933921, RandomNum.getRandomUInt(10) + 15, 0);
                Particles.createParticle(Game.rectGameArea.x + pos % 8 * Jewel.BLOCKSIZE + Jewel.BLOCKSIZE / 2, Game.rectGameArea.y + pos / 8 * Jewel.BLOCKSIZE + Jewel.BLOCKSIZE / 2, RandomNum.getRandomInt(8, 3), -RandomNum.getRandomUInt(16) - 12, RandomNum.getRandomInt(3), RandomNum.getRandomUInt(4) + 2, 3, 8933921, RandomNum.getRandomUInt(10) + 15, 0);
                Particles.createParticle(Game.rectGameArea.x + pos % 8 * Jewel.BLOCKSIZE + Jewel.BLOCKSIZE / 2, Game.rectGameArea.y + pos / 8 * Jewel.BLOCKSIZE + Jewel.BLOCKSIZE / 2, RandomNum.getRandomInt(8, 3), -RandomNum.getRandomUInt(16) - 12, RandomNum.getRandomInt(3), RandomNum.getRandomUInt(4) + 2, 3, 8933921, RandomNum.getRandomUInt(10) + 15, 0);
            }
            this.addScoreAndTime(1);
            this.jewels[pos].setResource(1);
            this.jewels[pos].startAnimation(1);
            if (this.jewels[pos].getBonus() != 6) {
                if (Resources.resSprs[7] == null) {
                    Resources.loadSprite(7);
                }
                Sprite Source = Resources.resSprs[7];
                Particles.createParticle(Game.rectGameArea.x + pos % 8 * Jewel.BLOCKSIZE + Jewel.BLOCKSIZE / 2, Game.rectGameArea.y + pos / 8 * Jewel.BLOCKSIZE + Jewel.BLOCKSIZE / 2, RandomNum.getRandomInt(8, 3), -RandomNum.getRandomUInt(16) - 12, RandomNum.getRandomInt(3), RandomNum.getRandomUInt(4) + 2, Source, this.jewels[pos].getColor() * 6 + 1 + RandomNum.getRandomUInt(6), RandomNum.getRandomUInt(10) + 15, 0);
                Particles.createParticle(Game.rectGameArea.x + pos % 8 * Jewel.BLOCKSIZE + Jewel.BLOCKSIZE / 2, Game.rectGameArea.y + pos / 8 * Jewel.BLOCKSIZE + Jewel.BLOCKSIZE / 2, RandomNum.getRandomInt(8, 3), -RandomNum.getRandomUInt(16) - 12, RandomNum.getRandomInt(3), RandomNum.getRandomUInt(4) + 2, Source, this.jewels[pos].getColor() * 6 + 1 + RandomNum.getRandomUInt(6), RandomNum.getRandomUInt(10) + 15, 0);
                Particles.createParticle(Game.rectGameArea.x + pos % 8 * Jewel.BLOCKSIZE + Jewel.BLOCKSIZE / 2, Game.rectGameArea.y + pos / 8 * Jewel.BLOCKSIZE + Jewel.BLOCKSIZE / 2, RandomNum.getRandomInt(8, 3), -RandomNum.getRandomUInt(16) - 12, RandomNum.getRandomInt(3), RandomNum.getRandomUInt(4) + 2, Source, this.jewels[pos].getColor() * 6 + 1 + RandomNum.getRandomUInt(6), RandomNum.getRandomUInt(10) + 15, 0);
                Particles.createParticle(Game.rectGameArea.x + pos % 8 * Jewel.BLOCKSIZE + Jewel.BLOCKSIZE / 2, Game.rectGameArea.y + pos / 8 * Jewel.BLOCKSIZE + Jewel.BLOCKSIZE / 2, RandomNum.getRandomInt(8, 3), -RandomNum.getRandomUInt(16) - 12, RandomNum.getRandomInt(3), RandomNum.getRandomUInt(4) + 2, Source, this.jewels[pos].getColor() * 6 + 1 + RandomNum.getRandomUInt(6), RandomNum.getRandomUInt(10) + 15, 0);
                Particles.createParticle(Game.rectGameArea.x + pos % 8 * Jewel.BLOCKSIZE + Jewel.BLOCKSIZE / 2, Game.rectGameArea.y + pos / 8 * Jewel.BLOCKSIZE + Jewel.BLOCKSIZE / 2, RandomNum.getRandomInt(8, 3), -RandomNum.getRandomUInt(16) - 12, RandomNum.getRandomInt(3), RandomNum.getRandomUInt(4) + 2, Source, this.jewels[pos].getColor() * 6 + 1 + RandomNum.getRandomUInt(6), RandomNum.getRandomUInt(10) + 15, 0);
                Particles.createParticle(Game.rectGameArea.x + pos % 8 * Jewel.BLOCKSIZE + Jewel.BLOCKSIZE / 2, Game.rectGameArea.y + pos / 8 * Jewel.BLOCKSIZE + Jewel.BLOCKSIZE / 2, RandomNum.getRandomInt(8, 3), -RandomNum.getRandomUInt(16) - 12, RandomNum.getRandomInt(3), RandomNum.getRandomUInt(4) + 2, 3, this.getParticlesColor(this.jewels[pos].getColor()), RandomNum.getRandomUInt(10) + 15, 0);
                Particles.createParticle(Game.rectGameArea.x + pos % 8 * Jewel.BLOCKSIZE + Jewel.BLOCKSIZE / 2, Game.rectGameArea.y + pos / 8 * Jewel.BLOCKSIZE + Jewel.BLOCKSIZE / 2, RandomNum.getRandomInt(8, 3), -RandomNum.getRandomUInt(16) - 12, RandomNum.getRandomInt(3), RandomNum.getRandomUInt(4) + 2, 3, this.getParticlesColor(this.jewels[pos].getColor()), RandomNum.getRandomUInt(10) + 15, 0);
                Particles.createParticle(Game.rectGameArea.x + pos % 8 * Jewel.BLOCKSIZE + Jewel.BLOCKSIZE / 2, Game.rectGameArea.y + pos / 8 * Jewel.BLOCKSIZE + Jewel.BLOCKSIZE / 2, RandomNum.getRandomInt(8, 3), -RandomNum.getRandomUInt(16) - 12, RandomNum.getRandomInt(3), RandomNum.getRandomUInt(4) + 2, 3, this.getParticlesColor(this.jewels[pos].getColor()), RandomNum.getRandomUInt(10) + 15, 0);
                Particles.createParticle(Game.rectGameArea.x + pos % 8 * Jewel.BLOCKSIZE + Jewel.BLOCKSIZE / 2, Game.rectGameArea.y + pos / 8 * Jewel.BLOCKSIZE + Jewel.BLOCKSIZE / 2, RandomNum.getRandomInt(8, 3), -RandomNum.getRandomUInt(16) - 12, RandomNum.getRandomInt(3), RandomNum.getRandomUInt(4) + 2, 3, this.getParticlesColor(this.jewels[pos].getColor()), RandomNum.getRandomUInt(10) + 15, 0);
                Particles.createParticle(Game.rectGameArea.x + pos % 8 * Jewel.BLOCKSIZE + Jewel.BLOCKSIZE / 2, Game.rectGameArea.y + pos / 8 * Jewel.BLOCKSIZE + Jewel.BLOCKSIZE / 2, RandomNum.getRandomInt(8, 3), -RandomNum.getRandomUInt(16) - 12, RandomNum.getRandomInt(3), RandomNum.getRandomUInt(4) + 2, 3, this.getParticlesColor(this.jewels[pos].getColor()), RandomNum.getRandomUInt(10) + 15, 0);
            }
            if (this.jewels[pos].getBonus() == 7) {
                this.score += 250;
                this.scoreEsc += 250;
            }
            if (this.jewels[pos].getBonus() == 1) {
                if (pos % 8 > 0) {
                    this.destroyJewelOnPosition(pos - 1);
                    Flame.setFlame(pos - 1);
                    if (pos / 8 > 0) {
                        this.destroyJewelOnPosition(pos - 8 - 1);
                        Flame.setFlame(pos - 8 - 1);
                    }
                    if (pos / 8 < 7) {
                        this.destroyJewelOnPosition(pos + 8 - 1);
                        Flame.setFlame(pos + 8 - 1);
                    }
                }
                if (pos % 8 < 7) {
                    this.destroyJewelOnPosition(pos + 1);
                    Flame.setFlame(pos + 1);
                    if (pos / 8 > 0) {
                        this.destroyJewelOnPosition(pos - 8 + 1);
                        Flame.setFlame(pos - 8 + 1);
                    }
                    if (pos / 8 < 7) {
                        this.destroyJewelOnPosition(pos + 8 + 1);
                        Flame.setFlame(pos + 8 + 1);
                    }
                }
                if (pos / 8 > 0) {
                    this.destroyJewelOnPosition(pos - 8);
                    Flame.setFlame(pos - 8);
                }
                if (pos / 8 < 7) {
                    this.destroyJewelOnPosition(pos + 8);
                    Flame.setFlame(pos + 8);
                }
                this.setExplosionMove(pos);
            } else if (this.jewels[pos].getBonus() == 5) {
                int i;
                for (i = pos % 8; i < 64; i += 8) {
                    this.destroyJewelOnPosition(i);
                    Flame.setFlame(i);
                }
                for (i = pos / 8 * 8; i < (pos / 8 + 1) * 8; ++i) {
                    this.destroyJewelOnPosition(i);
                    Flame.setFlame(i);
                }
            } else if (this.jewels[pos].getBonus() == 2) {
                int color = -1;
                if ((pos == this.selectorPos || pos == this.swappedPos) && this.jewels[this.selectorPos].getBonus() == 2 && this.jewels[this.swappedPos].getBonus() == 2) {
                    for (int i = 0; i < 64; ++i) {
                        this.destroyJewelOnPosition(i);
                    }
                } else if ((pos == this.selectorPos || pos == this.swappedPos) && this.jewels[this.selectorPos].getBonus() == 2 && this.jewels[this.swappedPos].getBonus() == 5) {
                    int i;
                    for (i = 0; i < 64; ++i) {
                        if (this.jewels[i].getColor() != this.jewels[this.swappedPos].getColor()) continue;
                        this.jewels[i].setBonus(5);
                        this.destroyJewelOnPosition(i);
                    }
                    for (i = 0; i < 64; ++i) {
                        if (this.jewels[i].getBonus() != 5) continue;
                        this.destroyJewelOnPosition(i);
                    }
                } else if ((pos == this.selectorPos || pos == this.swappedPos) && this.jewels[this.swappedPos].getBonus() == 2 && this.jewels[this.selectorPos].getBonus() == 5) {
                    int i;
                    for (i = 0; i < 64; ++i) {
                        if (this.jewels[i].getColor() != this.jewels[this.selectorPos].getColor()) continue;
                        this.jewels[i].setBonus(5);
                        this.destroyJewelOnPosition(i);
                    }
                    for (i = 0; i < 64; ++i) {
                        if (this.jewels[i].getBonus() != 5) continue;
                        this.destroyJewelOnPosition(i);
                    }
                } else if ((pos == this.selectorPos || pos == this.swappedPos) && this.jewels[this.selectorPos].getBonus() == 2 && this.jewels[this.swappedPos].getBonus() == 1) {
                    int i;
                    for (i = 0; i < 64; ++i) {
                        if (this.jewels[i].getColor() != this.jewels[this.swappedPos].getColor()) continue;
                        this.jewels[i].setBonus(1);
                        this.destroyJewelOnPosition(i);
                    }
                    for (i = 0; i < 64; ++i) {
                        if (this.jewels[i].getBonus() != 1) continue;
                        this.destroyJewelOnPosition(i);
                    }
                } else if ((pos == this.selectorPos || pos == this.swappedPos) && this.jewels[this.swappedPos].getBonus() == 2 && this.jewels[this.selectorPos].getBonus() == 1) {
                    int i;
                    for (i = 0; i < 64; ++i) {
                        if (this.jewels[i].getColor() != this.jewels[this.selectorPos].getColor()) continue;
                        this.jewels[i].setBonus(1);
                        this.destroyJewelOnPosition(i);
                    }
                    for (i = 0; i < 64; ++i) {
                        if (this.jewels[i].getBonus() != 1) continue;
                        this.destroyJewelOnPosition(i);
                    }
                } else {
                    color = pos == this.selectorPos && this.jewels[this.swappedPos].isColorDepended() ? this.jewels[this.swappedPos].getColor() : (pos == this.swappedPos && this.jewels[this.selectorPos].isColorDepended() ? this.jewels[this.selectorPos].getColor() : (pos >= 8 && this.jewels[pos - 8].getBonus() == 7 ? this.jewels[pos - 8].getColor() : RandomNum.getRandomUInt(this.totalColors)));
                    if (Storm.getCount() == 0) {
                        Storm.reset(pos);
                    }
                    int i = pos;
                    while ((i = this.getNearestOf(i, color)) != -1) {
                        this.destroyJewelOnPosition(i);
                        Storm.addPoint(i);
                        if (i != -1) continue;
                    }
                    for (int j = 0; j < 64; ++j) {
                        if (this.jewels[j].getColor() != color || !this.jewels[j].isColorDepended() || this.jewels[j].getResource() == 1) continue;
                        this.destroyJewelOnPosition(j);
                        Storm.addPoint(j);
                    }
                }
            } else if (this.jewels[pos].getBonus() == 7) {
                ++progressSecondary;
            }
        }
        if (MainCanvas.moveCheck) {
            ++MainCanvas.moveCounter;
            MainCanvas.moveCheck = false;
        }
    }

    private void setExplosionMove(int pos) {
        int vel = Game.rectGameArea.width * 1024 / 240;
        int acc = Game.rectGameArea.width * 256 / 240;
        for (int i = 1; i < 3; ++i) {
            int p1 = pos - i * 8 - i;
            int p2 = pos + i * 8 + i;
            for (int j = 0; j <= i * 2; ++j) {
                int k;
                if (p1 + j >= 0 && p1 + j < 64 && (p1 + j) / 8 == pos / 8 - i) {
                    this.jewels[p1 + j].setDeltaY(-1);
                    this.jewels[p1 + j].setVelY(-vel / i);
                    this.jewels[p1 + j].setAccY(acc / i);
                    k = j - i;
                    this.jewels[p1 + j].setDeltaX(k);
                    this.jewels[p1 + j].setVelX(k * vel / i);
                    this.jewels[p1 + j].setAccX(-k * acc / i);
                }
                if (p1 + j * 8 >= 0 && p1 + j * 8 < 64 && p1 / 8 + j - (p1 < 0 ? 1 : 0) == pos / 8 - i + j) {
                    this.jewels[p1 + j * 8].setDeltaX(-1);
                    this.jewels[p1 + j * 8].setVelX(-vel / i);
                    this.jewels[p1 + j * 8].setAccX(acc / i);
                    k = j - i;
                    this.jewels[p1 + j * 8].setDeltaY(k);
                    this.jewels[p1 + j * 8].setVelY(k * vel / i);
                    this.jewels[p1 + j * 8].setAccY(-k * acc / i);
                }
                if (p2 - j >= 0 && p2 - j < 64 && (p2 - j) / 8 == pos / 8 + i) {
                    this.jewels[p2 - j].setDeltaY(1);
                    this.jewels[p2 - j].setVelY(vel / i);
                    this.jewels[p2 - j].setAccY(-acc / i);
                    k = i - j;
                    this.jewels[p2 - j].setDeltaX(k);
                    this.jewels[p2 - j].setVelX(k * vel / i);
                    this.jewels[p2 - j].setAccX(-k * acc / i);
                }
                if (p2 - j * 8 < 0 || p2 - j * 8 >= 64 || p2 / 8 - j + (p2 >= 64 ? 1 : 0) != pos / 8 + i - j) continue;
                this.jewels[p2 - j * 8].setDeltaX(1);
                this.jewels[p2 - j * 8].setVelX(vel / i);
                this.jewels[p2 - j * 8].setAccX(-acc / i);
                k = i - j;
                this.jewels[p2 - j * 8].setDeltaY(k);
                this.jewels[p2 - j * 8].setVelY(k * vel / i);
                this.jewels[p2 - j * 8].setAccY(-k * acc / i);
            }
        }
    }

    private int getNearestOf(int pos, int color) {
        for (int i = 1; i < 8; ++i) {
            int j;
            for (j = pos - i - i * 8; j <= pos + i - i * 8; ++j) {
                if (j < 0 || j >= 64 || this.jewels[j].getColor() != color || !this.jewels[j].isColorDepended() || this.jewels[j].getResource() == 1) continue;
                return j;
            }
            for (j = pos - i; j <= pos + i; ++j) {
                if (j < 0 || j >= 64 || this.jewels[j].getColor() != color || !this.jewels[j].isColorDepended() || this.jewels[j].getResource() == 1) continue;
                return j;
            }
            for (j = pos - i + i * 8; j <= pos + i + i * 8; ++j) {
                if (j < 0 || j >= 64 || this.jewels[j].getColor() != color || !this.jewels[j].isColorDepended() || this.jewels[j].getResource() == 1) continue;
                return j;
            }
        }
        return -1;
    }

    private void updateStatusSwapBack() {
        if (!this.jewels[this.selectorPos].isMoving()) {
            this.setStatus(2);
        }
    }

    private void updateStatusFall() {
        for (int pos = 0; pos < 8; ++pos) {
            if (!this.jewels[pos].isMoving()) continue;
            return;
        }
        this.destroyJewels();
        if (this.status == 1) {
            if (Level.type == Level.TYPE_MOVES) {
                if (MainCanvas.moveCounter == Level.moves) {
                    if (this.getScore() + this.getResidueScore() >= Level.minScore) {
                        this.score = this.getScore() + this.getResidueScore();
                        this.setStatus(6);
                    } else {
                        this.setStatus(7);
                        this.setLoseMode(1);
                    }
                } else {
                    this.setStatus(2);
                }
            } else if (Level.type == Level.TYPE_TIME_ATTACK) {
                if ((long)this.getTimeInSec() == Level.time) {
                    if (this.getScore() + this.getResidueScore() >= Level.minScore) {
                        this.score = this.getScore() + this.getResidueScore();
                        this.setStatus(6);
                    } else {
                        this.setStatus(7);
                        this.setLoseMode(3);
                    }
                } else {
                    this.setStatus(2);
                }
            } else if (this.gameMode == 7) {
                if ((long)this.getTimeInSec() >= Level.time) {
                    if (MainCanvas.moveCounter >= Level.moves) {
                        if (Level.minScore <= this.getScore()) {
                            this.setStatus(6);
                        } else {
                            this.setStatus(7);
                            this.setLoseMode(3);
                        }
                    } else {
                        this.setStatus(7);
                    }
                } else {
                    this.setStatus(2);
                }
            } else if (this.gameMode == 4) {
                if (Block.count() > 0) {
                    this.setStatus(2);
                } else if ((long)this.getTimeInSec() >= Level.time) {
                    if (this.getScore() + this.getResidueScore() >= Level.minScore) {
                        this.score = this.getScore() + this.getResidueScore();
                        this.setStatus(6);
                    } else {
                        this.setStatus(7);
                        this.setLoseMode(3);
                    }
                } else {
                    this.setStatus(2);
                }
            } else if (this.gameMode == 5) {
                if (Block.count() > 0) {
                    if (MainCanvas.moveCounter < Level.moves) {
                        this.setStatus(2);
                    } else {
                        this.setStatus(7);
                        this.setLoseMode(1);
                    }
                } else if (MainCanvas.moveCounter >= Level.moves) {
                    this.score += (Level.moves - MainCanvas.moveCounter) * 100;
                    if (this.getScore() + this.getResidueScore() >= Level.minScore) {
                        this.score = this.getScore() + this.getResidueScore();
                        this.setStatus(6);
                    } else {
                        this.setStatus(7);
                        this.setLoseMode(1);
                    }
                } else if (MainCanvas.moveCounter < Level.moves) {
                    this.setStatus(2);
                } else {
                    this.setStatus(7);
                }
            } else if (this.gameMode == 3) {
                if (MainCanvas.moveCounter == Level.moves) {
                    if (Level.minScore <= this.getScore() + this.getResidueScore()) {
                        if (progressSecondary >= this.progressSecondaryFinal) {
                            this.score = this.getScore() + this.getResidueScore();
                            this.setStatus(6);
                        } else {
                            this.setStatus(7);
                            this.setLoseMode(1);
                        }
                    } else {
                        this.setStatus(7);
                        this.setLoseMode(1);
                    }
                } else if (MainCanvas.moveCounter >= Level.moves) {
                    this.setStatus(7);
                } else {
                    this.setStatus(2);
                }
            } else if (this.gameMode == 2) {
                if (MainCanvas.moveCounter == Level.moves) {
                    if (Level.minScore <= this.getScore() + this.getResidueScore()) {
                        if (progressSecondary >= this.progressSecondaryFinal) {
                            this.score = this.getScore() + this.getResidueScore();
                            this.setStatus(6);
                        } else {
                            this.setStatus(7);
                            this.setLoseMode(1);
                        }
                    } else {
                        this.setStatus(7);
                        this.setLoseMode(1);
                    }
                } else if (MainCanvas.moveCounter < Level.moves) {
                    if (this.allowEscapeSwap) {
                        this.swapEscapeGems();
                    } else {
                        this.setStatus(2);
                    }
                } else if (MainCanvas.moveCounter > Level.moves) {
                    this.setStatus(7);
                }
            } else if (this.gameMode == 6) {
                if ((long)this.getTimeInSec() >= Level.time) {
                    if (progressSecondary >= this.progressSecondaryFinal) {
                        if (this.getScore() + this.getResidueScore() >= Level.minScore) {
                            if (MainCanvas.moveCounter <= Level.moves) {
                                this.score = this.getScore() + this.getResidueScore();
                                this.setStatus(6);
                            } else {
                                this.setStatus(7);
                            }
                        } else {
                            this.setStatus(7);
                        }
                    } else {
                        this.setStatus(7);
                    }
                } else {
                    this.setStatus(2);
                }
            }
        }
    }

    private void swapEscapeGems() {
        int pos;
        this.allowEscapeSwap = false;
        this.progressMain = this.progressMainFinal;
        for (pos = 0; pos < 8; ++pos) {
            if (this.jewels[pos].getBonus() != 7) continue;
            this.jewels[pos].setDeltaY(-1);
            this.jewels[pos].setVelY(-(Jewel.MOVE_VELOCITY << 8));
            this.setStatus(8);
        }
        for (pos = 8; pos < 64; ++pos) {
            if (this.jewels[pos].getBonus() != 7 || this.jewels[pos - 8].getBonus() == 7) continue;
            Jewel gb = this.jewels[pos];
            gb.setDeltaY(Jewel.BLOCKSIZE);
            gb.setVelY(-Jewel.MOVE_VELOCITY);
            this.jewels[pos] = this.jewels[pos - 8];
            this.jewels[pos].setDeltaY(-Jewel.BLOCKSIZE);
            this.jewels[pos].setVelY(Jewel.MOVE_VELOCITY);
            this.jewels[pos - 8] = gb;
            this.setStatus(8);
        }
        int escapeCount = 0;
        for (int i = 0; i < 64; ++i) {
            if (this.jewels[i].getBonus() != 7) continue;
            ++escapeCount;
        }
        int p = RandomNum.getRandomUInt(100);
        if (p < (this.maxSpecialGems - escapeCount) * 100 / this.maxSpecialGems) {
            int pos2 = 56 + RandomNum.getRandomUInt(8);
            for (int i = 0; i < 8 && this.jewels[pos2].getBonus() != 0; ++i) {
                if (++pos2 < 64) continue;
                pos2 -= 8;
            }
            this.jewels[pos2].setBonus(7);
        }
    }

    private void setFadeFall(int pos) {
        this.jewels[pos].setResource(4);
        this.jewels[pos].startAnimation(-1);
        int dx = Resources.resSprs[0].getWidth() - Game.rectGameArea.x - pos % 8 * Jewel.BLOCKSIZE;
        this.jewels[pos].setVelX(dx << 3);
        this.jewels[pos].setVelY(-Game.rectGameArea.width * 3840 / 240);
        this.jewels[pos].setAccY(Game.rectGameArea.width * 256 / 240);
        this.fallBonus[pos % 8] = this.jewels[pos];
        this.jewels[pos] = new Jewel();
        this.jewels[pos].setResource(4);
        this.setStatus(5);
        ++progressSecondary;
        this.score += 250;
        this.scoreDown += 250;
    }

    private void destroyJewels() {
        for (int pos = 0; pos < 64; ++pos) {
            if (pos >= 56 && this.jewels[pos].getBonus() == 6) {
                this.setFadeFall(pos);
                continue;
            }
            int leftpos = this.getLeftBoundColorBlock(pos);
            int hsize = this.getHSizeOfColorBlock(leftpos);
            int toppos = this.getTopBoundColorPosition(pos);
            int vsize = this.getVSizeOfColorBlock(toppos);
            if (hsize > 2 && vsize > 2) {
                this.destroyBlockHorizontally(leftpos, hsize);
                this.destroyBlockVertically(toppos, vsize);
                this.jewels[pos].setBonus(5);
                this.setStatus(5);
                continue;
            }
            if (hsize > 2 && pos == leftpos + hsize - 1) {
                if (this.jewels[pos].getResource() != 1) {
                    this.destroyBlockHorizontally(leftpos, hsize);
                }
                if (hsize > 4) {
                    this.jewels[pos].setBonus(2);
                } else if (hsize > 3) {
                    this.jewels[pos].setBonus(1);
                }
                this.setStatus(5);
                continue;
            }
            if (vsize <= 2 || pos != toppos + (vsize - 1) * 8) continue;
            if (this.jewels[pos].getResource() != 1) {
                this.destroyBlockVertically(toppos, vsize);
            }
            if (vsize > 4) {
                this.jewels[toppos].setBonus(2);
            } else if (vsize > 3) {
                this.jewels[pos].setBonus(1);
            }
            this.setStatus(5);
        }
    }

    private void updateStatusDestroy() {
        int p;
        int pos;
        int col = -1;
        int fallCount = 0;
        for (pos = 0; pos < 64; ++pos) {
            if (this.jewels[pos].getResource() != 1 || this.jewels[pos].getAnimationRepeats() == 0) continue;
            return;
        }
        for (pos = 0; pos < 64; ++pos) {
            if (this.jewels[pos].getBonus() == 6) {
                ++fallCount;
            }
            if (this.jewels[pos].getResource() != 4 && (this.jewels[pos].getResource() != 1 || this.jewels[pos].getAnimationRepeats() != 0)) continue;
            this.leachJewelOnTop(pos);
            if (this.status == 1) continue;
            if (this.gameMode == 3) {
                col = pos % 8;
            }
            Storm.reset(0);
            this.setStatus(1);
            ++this.multiplicator;
        }
        if (col >= 0 && (p = RandomNum.getRandomUInt(100)) < (this.maxSpecialGems - fallCount) * 100 / this.maxSpecialGems) {
            this.jewels[col].setBonus(6);
        }
    }

    private void leachJewelOnTop(int pos) {
        Jewel gb = this.jewels[pos];
        for (int i = pos; i >= 8; i -= 8) {
            this.jewels[i] = this.jewels[i - 8];
            int dy = this.jewels[i].getDeltaY();
            this.jewels[i].setDeltaY(dy - Jewel.BLOCKSIZE);
            this.jewels[i].setVelY(Jewel.MOVE_VELOCITY);
            this.jewels[i].setAccY(128);
        }
        this.jewels[pos % 8] = gb;
        gb.reset();
        gb.setColor(RandomNum.getRandomUInt(this.totalColors));
        int dy = this.jewels[pos % 8 + 8].getDeltaY();
        if (dy > -Jewel.BLOCKSIZE) {
            dy = -Jewel.BLOCKSIZE;
        }
        gb.setDeltaY(dy);
        gb.setVelY(Jewel.MOVE_VELOCITY);
        gb.setAccY(128);
    }

    private void addScoreAndTime(int mul) {
        int scoretoadd = (10 * this.multiplicator + 40) / 10;
        this.score += scoretoadd;
    }

    public int getGameOverMessage() {
        if (this.hint == -1) {
            return 12;
        }
        if (this.progressMain <= 0L) {
            return 11;
        }
        return 0;
    }

    private void setStatus(int next_status) {
        if (next_status != this.status) {
            this.status = next_status;
            if (this.status == 6 || this.status == 7) {
                if (MainCanvas.soundManager.IsSoundOn()) {
                    if (this.status == 6) {
                        MainCanvas.soundManager.Play(Sounds.SOUND_WIN, 1);
                    }
                    if (this.status == 7) {
                        MainCanvas.soundManager.Play(Sounds.SOUND_OVER, 1);
                    }
                }
                for (int i = 0; i < 64; ++i) {
                    if (this.jewels[i].getBonus() == 7 && this.jewels[i].getDeltaY() < 0) {
                        this.jewels[i].setDeltaX(MainCanvas.WIDTH);
                        this.jewels[i].setVelX(0);
                        this.jewels[i].setAccX(0);
                    }
                    this.jewels[i].setDeltaY(1);
                    this.jewels[i].setVelY(Game.rectGameArea.width * 1280 / 240);
                    this.jewels[i].setAccY(Game.rectGameArea.width * 256 / 240);
                    if (this.jewels[i].getBonus() == 1) {
                        this.score += 50;
                        continue;
                    }
                    if (this.jewels[i].getBonus() == 5) {
                        this.score += 100;
                        continue;
                    }
                    if (this.jewels[i].getBonus() != 2) continue;
                    this.score += 250;
                }
            } else if (this.status == 2) {
                this.allowEscapeSwap = true;
                this.multiplicator = 1;
                int turns = this.getMovesCount();
                if (turns == 0 && this.gameMode == 20) {
                    this.setStatus(1);
                    this.swapJewels();
                }
            }
        }
    }

    private void swapJewels() {
        for (int i = 0; i < 64; ++i) {
            if (this.jewels[i].isMoving()) continue;
            int direction = RandomNum.getRandomUInt(4);
            if (direction == 0) {
                if (i % 8 >= 7 || this.jewels[i + 1].isMoving()) continue;
                this.swap(i, i + 1);
                continue;
            }
            if (direction == 1) {
                if (i / 8 >= 7 || this.jewels[i + 8].isMoving()) continue;
                this.swap(i, i + 8);
                continue;
            }
            if (direction == 2) {
                if (i % 8 <= 0 || this.jewels[i - 1].isMoving()) continue;
                this.swap(i, i - 1);
                continue;
            }
            if (direction != 3 || i / 8 <= 0 || this.jewels[i - 8].isMoving()) continue;
            this.swap(i, i - 8);
        }
    }

    private int getMovesCount() {
        int count = 0;
        this.penalty = false;
        this.hint = -1;
        int p0 = RandomNum.getRandomUInt(100);
        for (int pos = 0; pos < 64; ++pos) {
            if (this.jewels[pos].getBonus() == 2) {
                if (p0 >= 100 / ++count) continue;
                this.hint = pos;
                continue;
            }
            if (this.jewels[pos].getBonus() == 6) continue;
            int row = pos / 8;
            int col = pos % 8;
            if (col > 0 && col < 7) {
                if (row > 0 && this.isDestructible(pos, pos - 1 - 8) && this.isDestructible(pos, pos + 1 - 8)) {
                    if (p0 >= 100 / ++count) continue;
                    this.hint = pos;
                    continue;
                }
                if (row < 7 && this.isDestructible(pos, pos - 1 + 8) && this.isDestructible(pos, pos + 1 + 8)) {
                    if (p0 >= 100 / ++count) continue;
                    this.hint = pos;
                    continue;
                }
            }
            if (col > 1) {
                if (row > 0 && this.isDestructible(pos, pos - 1 - 8) && this.isDestructible(pos, pos - 2 - 8)) {
                    if (p0 >= 100 / ++count) continue;
                    this.hint = pos;
                    continue;
                }
                if (row < 7 && this.isDestructible(pos, pos - 1 + 8) && this.isDestructible(pos, pos - 2 + 8)) {
                    if (p0 >= 100 / ++count) continue;
                    this.hint = pos;
                    continue;
                }
            }
            if (col > 2 && this.isDestructible(pos, pos - 2) && this.isDestructible(pos, pos - 3)) {
                if (p0 >= 100 / ++count) continue;
                this.hint = pos;
                continue;
            }
            if (col < 6) {
                if (row > 0 && this.isDestructible(pos, pos + 1 - 8) && this.isDestructible(pos, pos + 2 - 8)) {
                    if (p0 >= 100 / ++count) continue;
                    this.hint = pos;
                    continue;
                }
                if (row < 7 && this.isDestructible(pos, pos + 1 + 8) && this.isDestructible(pos, pos + 2 + 8)) {
                    if (p0 >= 100 / ++count) continue;
                    this.hint = pos;
                    continue;
                }
            }
            if (col < 5 && this.isDestructible(pos, pos + 2) && this.isDestructible(pos, pos + 3)) {
                if (p0 >= 100 / ++count) continue;
                this.hint = pos;
                continue;
            }
            if (row > 0 && row < 7) {
                if (col > 0 && this.isDestructible(pos, pos - 1 - 8) && this.isDestructible(pos, pos - 1 + 8)) {
                    if (p0 >= 100 / ++count) continue;
                    this.hint = pos;
                    continue;
                }
                if (col < 7 && this.isDestructible(pos, pos + 1 - 8) && this.isDestructible(pos, pos + 1 + 8)) {
                    if (p0 >= 100 / ++count) continue;
                    this.hint = pos;
                    continue;
                }
            }
            if (row > 1) {
                if (col > 0 && this.isDestructible(pos, pos - 1 - 8) && this.isDestructible(pos, pos - 1 - 16)) {
                    if (p0 >= 100 / ++count) continue;
                    this.hint = pos;
                    continue;
                }
                if (col < 7 && this.isDestructible(pos, pos + 1 - 8) && this.isDestructible(pos, pos + 1 - 16)) {
                    if (p0 >= 100 / ++count) continue;
                    this.hint = pos;
                    continue;
                }
            }
            if (row > 2 && this.isDestructible(pos, pos - 16) && this.isDestructible(pos, pos - 24)) {
                if (p0 >= 100 / ++count) continue;
                this.hint = pos;
                continue;
            }
            if (row < 6) {
                if (col > 0 && this.isDestructible(pos, pos - 1 + 8) && this.isDestructible(pos, pos - 1 + 16)) {
                    if (p0 >= 100 / ++count) continue;
                    this.hint = pos;
                    continue;
                }
                if (col < 7 && this.isDestructible(pos, pos + 1 + 8) && this.isDestructible(pos, pos + 1 + 16)) {
                    if (p0 >= 100 / ++count) continue;
                    this.hint = pos;
                    continue;
                }
            }
            if (row >= 5 || !this.isDestructible(pos, pos + 16) || !this.isDestructible(pos, pos + 24) || p0 >= 100 / ++count) continue;
            this.hint = pos;
        }
        return count;
    }

    private boolean isDestructible(int pos1, int pos2) {
        if (this.jewels[pos2].getBonus() == 2) {
            return false;
        }
        if (this.jewels[pos2].getBonus() == 6) {
            return false;
        }
        return this.jewels[pos1].getColor() == this.jewels[pos2].getColor();
    }

    public void showHint() {
        bhint = true;
        if (this.status == 2) {
            if (!this.penalty) {
                this.penalty = true;
                if (this.gameMode == 60) {
                    this.progressMain = 96L * this.progressMain / 100L;
                } else if (this.gameMode == 1) {
                    this.progressMain = 96L * this.progressMain / 100L;
                } else if (this.gameMode == 7) {
                    this.progressMain = 96L * this.progressMain / 100L;
                } else if (this.gameMode == 4) {
                    this.progressMain -= 2000L;
                } else if (this.gameMode == 2) {
                    this.progressMain = 6L * this.progressMain / 10L;
                }
            }
            this.selectorPos = this.hint;
            if (this.jewels[this.selectorPos].getAnimationRepeats() == 0) {
                this.jewels[this.selectorPos].startAnimation(1);
            }
        }
    }

    private int getResidueScore() {
        int score = 0;
        for (int i = 0; i < 64; ++i) {
            if (this.jewels[i].getBonus() == 1) {
                score += 50;
                this.scoreBomb += 50;
                continue;
            }
            if (this.jewels[i].getBonus() == 5) {
                score += 100;
                this.scoreBomb += 100;
                continue;
            }
            if (this.jewels[i].getBonus() != 2) continue;
            score += 250;
            this.scoreBomb += 250;
        }
        return score;
    }

    public void paint(Graphics g) {
        int y;
        int x;
        int pos;
        g.setColor(0, 20, 80);
        g.fillRect(0, Game.rectGameArea.y, MainCanvas.WIDTH, Game.rectGameArea.height);
        g.setClip(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
        g.setColor(0);
        g.fillRect(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
        g.setClip(Game.rectGameArea.x, Game.rectGameArea.y, Game.rectGameArea.width, Game.rectGameArea.height);
        Sprite sprBlock = Resources.resSprs[6];
        Sprite sprFlame = Resources.resSprs[9];
        for (pos = 0; pos < 64; ++pos) {
            if (Block.getValue(pos) <= 0) continue;
            x = Game.rectGameArea.x + pos % 8 * Jewel.BLOCKSIZE;
            y = Game.rectGameArea.y + pos / 8 * Jewel.BLOCKSIZE;
            sprBlock.setRefPixelPosition(x, y);
            sprBlock.setFrame(3 - Block.getValue(pos));
            sprBlock.paint(g);
        }
        for (pos = 0; pos < 64; ++pos) {
            x = Game.rectGameArea.x + pos % 8 * Jewel.BLOCKSIZE;
            y = Game.rectGameArea.y + pos / 8 * Jewel.BLOCKSIZE;
            boolean shake = false;
            if (this.gameMode == 2 && this.jewels[pos].getBonus() == 7 && pos / 8 < 3) {
                shake = true;
            }
            if (this.status == 7 && this.jewels[pos].getDeltaY() <= 0) continue;
            this.jewels[pos].paint(g, x, y, shake);
            if (pos < 56 || this.fallBonus[pos % 8] == null) continue;
            g.setClip(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
            this.fallBonus[pos % 8].paint(g, x, y, false);
            g.setClip(Game.rectGameArea.x, Game.rectGameArea.y, Game.rectGameArea.width, Game.rectGameArea.height);
        }
        int delta = (sprFlame.getWidth() - Jewel.BLOCKSIZE) / 2;
        for (int pos2 = 0; pos2 < 64; ++pos2) {
            int frame = Flame.getFrame(pos2);
            if (frame < 0 || frame >= 8) continue;
            int x2 = Game.rectGameArea.x + pos2 % 8 * Jewel.BLOCKSIZE;
            int y2 = Game.rectGameArea.y + pos2 / 8 * Jewel.BLOCKSIZE;
            sprFlame.setRefPixelPosition(x2 + this.jewels[pos2].getDeltaX() - delta, y2 + this.jewels[pos2].getDeltaY() - delta);
            sprFlame.setFrame(frame);
            sprFlame.paint(g);
        }
        Sprite sprSelector = Resources.resSprs[5];
        sprSelector.setFrame(this.selectorFrame % 2);
        if (this.status != 1) {
            sprSelector.setRefPixelPosition(Game.rectGameArea.x + this.selectorPos % 8 * Jewel.BLOCKSIZE + this.jewels[this.selectorPos].getDeltaX(), Game.rectGameArea.y + this.selectorPos / 8 * Jewel.BLOCKSIZE + this.jewels[this.selectorPos].getDeltaY());
        } else {
            sprSelector.setRefPixelPosition(Game.rectGameArea.x + this.selectorPos % 8 * Jewel.BLOCKSIZE, Game.rectGameArea.y + this.selectorPos / 8 * Jewel.BLOCKSIZE);
        }
        sprSelector.paint(g);
        Particles.paint(g, 0);
        Storm.paint(g, rectGameArea);
        g.setClip(0, 0, MainCanvas.WIDTH, MainCanvas.HEIGHT);
        Particles.paint(g, 1);
    }

    private int getParticlesColor(int color) {
        switch (color) {
            case 0: {
                return 15406336;
            }
            case 1: {
                return 16769536;
            }
            case 2: {
                return 2616064;
            }
            case 3: {
                return 40155;
            }
            case 4: {
                return 9654235;
            }
            case 5: {
                return 15180800;
            }
            case 6: {
                return 15287771;
            }
            case 999: {
                return 10265768;
            }
        }
        return 15406336;
    }

    public void load(DataInputStream dis, String rmsName) throws IOException {
        this.status = dis.readInt();
        this.gameMode = dis.readInt();
        this.gameLevel = dis.readInt();
        this.timeElapsed = dis.readLong();
        this.score = dis.readInt();
        this.multiplicator = dis.readInt();
        this.hint = dis.readInt();
        this.progressMain = dis.readLong();
        this.progressMainFinal = dis.readLong();
        this.progressSecondaryFinal = dis.readInt();
        progressSecondary = dis.readInt();
        this.selectorPos = dis.readInt();
        this.swappedPos = dis.readInt();
        this.isDragged = dis.readBoolean();
        this.totalColors = dis.readInt();
        this.allowEscapeSwap = dis.readBoolean();
        this.maxSpecialGems = dis.readInt();
        for (int i = 0; i < 64; ++i) {
            this.jewels[i].load(dis);
            Block.setValue(i, dis.readInt());
        }
    }

    public void save(DataOutputStream dos, String rmsName) throws IOException {
        dos.writeInt(this.status);
        dos.writeInt(this.gameMode);
        dos.writeInt(this.gameLevel);
        dos.writeLong(this.timeElapsed);
        dos.writeInt(this.score);
        dos.writeInt(this.multiplicator);
        dos.writeInt(this.hint);
        dos.writeLong(this.progressMain);
        dos.writeLong(this.progressMainFinal);
        dos.writeInt(this.progressSecondaryFinal);
        dos.writeInt(progressSecondary);
        dos.writeInt(this.selectorPos);
        dos.writeInt(this.swappedPos);
        dos.writeBoolean(this.isDragged);
        dos.writeInt(this.totalColors);
        dos.writeBoolean(this.allowEscapeSwap);
        dos.writeInt(this.maxSpecialGems);
        for (int i = 0; i < 64; ++i) {
            this.jewels[i].save(dos);
            dos.writeInt(Block.getValue(i));
        }
    }

    public void setDefault(DataOutputStream dos, String rmsName) throws IOException {
        dos.writeInt(0);
        dos.writeInt(this.gameMode);
        dos.writeInt(1);
        dos.writeLong(0L);
        dos.writeInt(0);
        dos.writeInt(1);
        dos.writeLong(0L);
        dos.writeLong(1000L);
        dos.writeInt(1000);
        dos.writeInt(5);
        dos.writeInt(0);
        dos.writeInt(27);
        dos.writeInt(0);
        dos.writeBoolean(false);
        dos.writeInt(5);
        dos.writeBoolean(true);
    }

    private void setLoseMode(int loseMode) {
        this.loseMode = loseMode;
    }

    public int getLoseMode() {
        return this.loseMode;
    }

    static {
        lose = 0;
        blockChecker = false;
        bhint = false;
    }
}

