/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Random;
import javax.microedition.lcdui.Graphics;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

public class Utils {
    public static int numtexts;
    public static DataInputStream _dis;
    public static final byte RC_L = 0;
    public static final byte RC_T = 1;
    public static final byte RC_R = 2;
    public static final byte RC_B = 3;
    public static final int PTD_FONT_ID = 0;
    public static final int PTD_LINE_COUNT = 1;
    public static final int PTD_LINE_MAX_WIDTH = 2;
    public static final int PTD_BOX_LEFT = 3;
    public static final int PTD_BOX_TOP = 4;
    public static final int PTD_BOX_RIGHT = 5;
    public static final int PTD_BOX_BOTTOM = 6;
    public static final int PTD_Y_OFFSET = 7;
    public static final int PTD_Y_OFFSET_MAX = 8;
    public static final int PTD_BASE_INDEX = 9;
    public static final long D_MUL = 1000000L;
    public static final long D_MUL_SQR = 1000000000000L;
    public static final long D180 = 3141592L;
    public static final long D270 = 4712388L;
    public static final long D360 = 6283184L;
    public static final long D90 = 1570796L;
    private static Random _rnd;

    public static final DataInputStream setFileStream(String a_sFile) {
        _dis = null;
        _dis = new DataInputStream(((Object)((Object)M._instance)).getClass().getResourceAsStream(a_sFile));
        return _dis;
    }

    public static String[] loadText(Object instance, String filename) throws IOException {
        InputStream is = instance.getClass().getResourceAsStream(filename);
        DataInputStream dis = new DataInputStream(is);
        numtexts = dis.readUnsignedShort();
        String[] TEXTS = new String[numtexts];
        for (int i = 0; i < numtexts; ++i) {
            TEXTS[i] = dis.readUTF();
        }
        return TEXTS;
    }

    public static final void setClip(Graphics a_g, int[] a_rcClip) {
        a_g.setClip(a_rcClip[0], a_rcClip[1], a_rcClip[2] - a_rcClip[0], a_rcClip[3] - a_rcClip[1]);
    }

    public static final int getAnchorX(int a_iW, int a_iAnchor) {
        if ((a_iAnchor & 1) == 1) {
            return -(a_iW >>> 1);
        }
        if ((a_iAnchor & 8) == 8) {
            return -a_iW;
        }
        return 0;
    }

    public static final int getAnchorY(int a_iH, int a_iAnchor) {
        if ((a_iAnchor & 2) == 2) {
            return -(a_iH >>> 1);
        }
        if ((a_iAnchor & 0x20) == 32) {
            return -a_iH;
        }
        return 0;
    }

    public static final int cutPeriods(int a_Value, int a_Period) {
        int result;
        if (a_Value >= 0) {
            result = a_Value % a_Period;
        } else {
            result = a_Period - -a_Value % a_Period;
            if (result == a_Period) {
                result = 0;
            }
        }
        return result;
    }

    public static final int interpolateColor(int a_rgbColorFrom, int a_rgbColorTo, int a_iStep, int a_iSteps) {
        if (a_iStep <= 0) {
            return a_rgbColorFrom;
        }
        if (a_iStep >= a_iSteps - 1) {
            return a_rgbColorTo;
        }
        int iRevStep = a_iSteps - a_iStep;
        int r1 = (a_rgbColorFrom & 0xFF0000) >>> 16;
        int r2 = (a_rgbColorTo & 0xFF0000) >>> 16;
        int g1 = (a_rgbColorFrom & 0xFF00) >>> 8;
        int g2 = (a_rgbColorTo & 0xFF00) >>> 8;
        int b1 = a_rgbColorFrom & 0xFF;
        int b2 = a_rgbColorTo & 0xFF;
        int r = (r1 * iRevStep + r2 * a_iStep) / a_iSteps;
        int g = (g1 * iRevStep + g2 * a_iStep) / a_iSteps;
        int b = (b1 * iRevStep + b2 * a_iStep) / a_iSteps;
        return r << 16 | g << 8 | b;
    }

    public static final int[] rc_new_rect(int a_iLeft, int a_iTop, int a_iRight, int a_iBottom) {
        int[] result = new int[]{a_iLeft, a_iTop, a_iRight, a_iBottom};
        return result;
    }

    public static final String getDigits(int a_iNumber, int a_iDigitCount) {
        return Utils.getDigits("" + a_iNumber, a_iDigitCount);
    }

    public static final String getDigits(String a_sValue, int a_iDigitCount) {
        String result = "" + a_sValue;
        while (result.length() < a_iDigitCount) {
            result = "0" + result;
        }
        return result;
    }

    public static final long cutPeriods(long a_Value, long a_Period) {
        long result;
        if (a_Value >= 0L) {
            result = a_Value % a_Period;
        } else {
            result = a_Period - -a_Value % a_Period;
            if (result == a_Period) {
                result = 0L;
            }
        }
        return result;
    }

    public static final long Sqrt(long a_lValue) {
        return Utils.sqrt(a_lValue, a_lValue / 1000000L);
    }

    public static final long sqrt(long x, long y) {
        while (y > 0L) {
            long yn = (y + x / y) / 2L;
            long diff = Math.abs(yn - y);
            y = yn;
            if (diff >= 2L) continue;
            break;
        }
        return y;
    }

    public static final long D2Rad(int a_Degree) {
        return ((long)a_Degree * 3141592L + 179L) / 180L;
    }

    public static final int sgn(float a_iValue) {
        return a_iValue > 0.0f ? 1 : (a_iValue < 0.0f ? -1 : 0);
    }

    public static final int sgn(int a_iValue) {
        return a_iValue > 0 ? 1 : (a_iValue < 0 ? -1 : 0);
    }

    public static final float abs(float a_iValue) {
        return a_iValue >= 0.0f ? a_iValue : -a_iValue;
    }

    public static final int abs(int a_iValue) {
        return a_iValue >= 0 ? a_iValue : -a_iValue;
    }

    public static final long sinMulN(long a_x, long a_N) {
        long dy;
        boolean bChangeSign;
        long x = Utils.cutPeriods(a_x, 6283184L);
        boolean bl = bChangeSign = x > 3141592L;
        if (x >= 4712388L) {
            x = 6283184L - x;
        } else if (x >= 3141592L) {
            x -= 3141592L;
        } else if (x >= 1570796L) {
            x = 3141592L - x;
        }
        long _x_2 = -x * x;
        long y = dy = x;
        int _2k = 2;
        while (dy > 0L) {
            dy = _x_2 * dy / (long)(_2k * (_2k + 1)) / 1000000000000L;
            y += dy;
            _2k += 2;
        }
        return ((bChangeSign ? -y : y) * a_N + 1000000L - 1L) / 1000000L;
    }

    public static final boolean hasRS(String a_name) {
        boolean result;
        block3: {
            result = false;
            try {
                String[] rs = RecordStore.listRecordStores();
                if (rs == null) break block3;
                for (int i = 0; i < rs.length; ++i) {
                    String s = rs[i];
                    if (!s.equals(a_name)) continue;
                    result = true;
                    break;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public static void deleteRS(String a_name) {
        try {
            if (Utils.hasRS(a_name)) {
                RecordStore.deleteRecordStore((String)a_name);
            }
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
    }

    public static int rndInt(int a_iMaxNumber) {
        if (a_iMaxNumber < 0) {
            return 0;
        }
        return (_rnd.nextInt() & Integer.MAX_VALUE) % (a_iMaxNumber + 1);
    }

    public static final DataInputStream getFile(String a_Name) {
        return new DataInputStream(((Object)((Object)M._instance)).getClass().getResourceAsStream(a_Name));
    }

    public static final byte[] readByteArray(DataInputStream a_dis, int a_iSize) throws Exception {
        byte[] result = new byte[a_iSize];
        a_dis.read(result);
        return result;
    }

    public static final short[] readShortArray(DataInputStream a_dis, int a_iSize) throws Exception {
        short[] result = new short[a_iSize];
        for (int i = 0; i < a_iSize; ++i) {
            result[i] = a_dis.readShort();
        }
        return result;
    }

    public static final boolean[] readBoolArray(DataInputStream a_dis, int a_iSize) throws Exception {
        boolean[] result = new boolean[a_iSize];
        for (int i = 0; i < a_iSize; ++i) {
            result[i] = a_dis.readBoolean();
        }
        return result;
    }

    public static final short[] readShiftedArray(DataInputStream a_dis, int a_iSize, int aShift) throws Exception {
        short[] result = new short[a_iSize];
        for (int i = 0; i < a_iSize; ++i) {
            result[i] = (short)(a_dis.readUnsignedByte() << aShift);
        }
        return result;
    }

    static {
        _dis = null;
        _rnd = new Random(System.currentTimeMillis());
    }
}

