/*
 * Decompiled with CFR 0.152.
 */
package generic.engine2d;

import generic.Cache;
import generic.MathExt;
import generic.engine2d.Transform2D;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;

public class Node2D {
    private Vector m_children;
    private Node2D m_parent;
    protected boolean m_renderingEnabled = true;
    private int m_translationX;
    private int m_translationY;
    private int m_rotation;
    private int m_scaleX = 65536;
    private int m_scaleY = 65536;
    protected Transform2D m_nodeTransform;
    protected final Transform2D m_cachedTransform = new Transform2D();
    protected Transform2D m_parentTransform = null;
    protected boolean m_cachedTransformIsValid = false;
    private static final int MAX_HIERARCHY_DEPTH = 10;
    private static Node2D[] m_tempNodeList = new Node2D[10];
    protected static Transform2D m_tempTransform = new Transform2D();
    private static final int MAX_POINTS = 300;
    private int m_color = 0xFF0000;
    private short[][] m_lines;
    private int[] m_lineColors;
    private short m_dotSize;
    private short[][] m_cachedLines;
    private short[] m_cachedDot;

    private static short[] getCache() {
        return Cache.getInstance(1).acquireShortArray(600);
    }

    private static void releaseCache(short[] sArray) {
        Cache.getInstance(1).releaseShortArray(sArray);
    }

    public final void setRenderingEnable(boolean bl) {
        this.m_renderingEnabled = bl;
    }

    public final boolean isRenderingEnabled() {
        return this.m_renderingEnabled;
    }

    public final void setTranslationx(int n, int n2) {
        if (this.m_translationX != n || this.m_translationY != n2) {
            this.m_translationX = n;
            this.m_translationY = n2;
            this.m_cachedTransformIsValid = false;
        }
    }

    public final void setTranslationx(int[] nArray) {
        this.m_translationX = nArray[0];
        this.m_translationY = nArray[1];
    }

    public final void getTranslationx(int[] nArray) {
        nArray[0] = this.m_translationX;
        nArray[1] = this.m_translationY;
    }

    public final int getTranslationXx() {
        return this.m_translationX;
    }

    public final int getTranslationYx() {
        return this.m_translationY;
    }

    public final void setRotationDegreesx(int n) {
        this.setRotationRadiansx(MathExt.degreesToRadiansF(n));
    }

    public final void setRotationRadiansx(int n) {
        if (this.m_rotation != n) {
            this.m_rotation = n;
            this.m_cachedTransformIsValid = false;
        }
    }

    public final int getRotation() {
        return this.m_rotation;
    }

    public final void setScalex(int n) {
        this.setScalex(n, n);
    }

    public final void setScalex(int n, int n2) {
        if (this.m_scaleX != n || this.m_scaleY != n2) {
            this.m_scaleX = n;
            this.m_scaleY = n2;
            this.m_cachedTransformIsValid = false;
        }
    }

    public final int getScaleXx() {
        return this.m_scaleX;
    }

    public final int getScaleYx() {
        return this.m_scaleY;
    }

    public final void setTransform(Transform2D transform2D) {
        if (transform2D != null) {
            if (this.m_nodeTransform == null) {
                this.m_nodeTransform = new Transform2D();
            }
            this.m_nodeTransform.set(transform2D);
        } else {
            this.m_nodeTransform = null;
        }
        this.m_cachedTransformIsValid = false;
    }

    public final void getTransform(Transform2D transform2D) {
        if (this.m_nodeTransform != null) {
            transform2D.set(this.m_nodeTransform);
        }
    }

    public final void setColor(int n) {
        this.m_color = n;
    }

    public final int getColor() {
        return this.m_color;
    }

    public final void setLines(short[][] sArray, int[] nArray) {
        this.m_lines = sArray;
        this.m_lineColors = nArray;
        if (sArray != null) {
            this.m_cachedLines = new short[sArray.length][];
            for (int i = 0; i < sArray.length; ++i) {
                this.m_cachedLines[i] = new short[sArray[i].length];
            }
        }
    }

    public final short[][] getLines() {
        return this.m_lines;
    }

    public void setDotSize(int n) {
        this.m_dotSize = (short)n;
        this.m_cachedDot = new short[2];
    }

    public int getDotSize() {
        return this.m_dotSize;
    }

    public final void cacheTransform(Transform2D transform2D) {
        if (!this.m_renderingEnabled || this.m_lines == null && this.m_children == null && this.m_dotSize <= 0) {
            return;
        }
        Transform2D transform2D2 = m_tempTransform;
        if (transform2D != null) {
            transform2D2.set(transform2D);
            this.getCompositeTransformCumulative(transform2D2);
        } else {
            this.getCompositeTransform(transform2D2);
        }
        if (this.m_lines != null) {
            this.cacheLines(transform2D2);
        }
        if (this.m_dotSize > 0) {
            this.cacheDot(transform2D2);
        }
        if (this.m_children != null) {
            this.m_parentTransform.set(transform2D2);
            int n = this.m_children.size();
            for (int i = 0; i < n; ++i) {
                ((Node2D)this.m_children.elementAt(i)).cacheTransform(this.m_parentTransform);
            }
        }
    }

    private final void cacheLines(Transform2D transform2D) {
        short[][] sArray = this.m_lines;
        short[] sArray2 = Node2D.getCache();
        short[][] sArray3 = this.m_cachedLines;
        int n = sArray.length;
        for (int i = 0; i < n; ++i) {
            short[] sArray4 = sArray[i];
            int n2 = sArray4.length >> 1;
            System.arraycopy(sArray4, 0, sArray2, 0, sArray4.length);
            transform2D.transformx(sArray2, n2);
            for (int j = 0; j < sArray4.length; ++j) {
                sArray3[i][j] = sArray2[j];
            }
        }
        Node2D.releaseCache(sArray2);
    }

    private final void cacheDot(Transform2D transform2D) {
        short[] sArray = Node2D.getCache();
        short[] sArray2 = this.m_cachedDot;
        sArray[0] = 0;
        sArray[1] = 0;
        transform2D.transformx(sArray, 1);
        sArray2[0] = sArray[0];
        sArray2[1] = sArray[1];
        Node2D.releaseCache(sArray);
    }

    public final void render(Graphics graphics, Transform2D transform2D) {
        if (!this.m_renderingEnabled || this.m_lines == null && this.m_children == null && this.m_dotSize <= 0) {
            return;
        }
        if (transform2D != null) {
            this.cacheTransform(transform2D);
        }
        if (this.m_lines != null) {
            graphics.setColor(this.m_color);
            this.renderLines(graphics);
        }
        if (this.m_dotSize > 0) {
            graphics.setColor(this.m_color);
            this.renderDot(graphics);
        }
        if (this.m_children != null) {
            int n = this.m_children.size();
            for (int i = 0; i < n; ++i) {
                ((Node2D)this.m_children.elementAt(i)).render(graphics, null);
            }
        }
    }

    private void renderLines(Graphics graphics) {
        short[][] sArray = this.m_cachedLines;
        int[] nArray = this.m_lineColors;
        int n = sArray.length;
        for (int i = 0; i < n; ++i) {
            if (nArray != null) {
                graphics.setColor(nArray[i]);
            }
            short[] sArray2 = sArray[i];
            int n2 = sArray2.length >> 1;
            int n3 = 0;
            for (int j = 0; j < n2 - 1; ++j) {
                short s = sArray2[n3 + 0];
                short s2 = sArray2[n3 + 1];
                short s3 = sArray2[n3 + 2];
                short s4 = sArray2[n3 + 3];
                graphics.drawLine((int)s, (int)s2, (int)s3, (int)s4);
                n3 += 2;
            }
        }
    }

    private void renderDot(Graphics graphics) {
        short[] sArray = this.m_cachedDot;
        graphics.fillRect(sArray[0] - (this.m_dotSize >> 1), sArray[1] - (this.m_dotSize >> 1), (int)this.m_dotSize, (int)this.m_dotSize);
    }

    public final void getCompositeTransform(Transform2D transform2D) {
        this.updateCachedTransform();
        transform2D.set(this.m_cachedTransform);
    }

    public final void getCompositeTransformCumulative(Transform2D transform2D) {
        this.updateCachedTransform();
        transform2D.postMultiply(this.m_cachedTransform);
    }

    protected final void updateCachedTransform() {
        if (!this.m_cachedTransformIsValid) {
            Transform2D transform2D = this.m_cachedTransform;
            transform2D.setIdentity();
            if (this.m_translationX != 0 || this.m_translationY != 0) {
                transform2D.postTranslatex(this.m_translationX, this.m_translationY);
            }
            if (this.m_rotation != 0) {
                transform2D.postRotatex(this.m_rotation);
            }
            if (this.m_scaleX != 65536 || this.m_scaleY != 65536) {
                transform2D.postScalex(this.m_scaleX, this.m_scaleY);
            }
            if (this.m_nodeTransform != null) {
                transform2D.postMultiply(this.m_nodeTransform);
            }
            this.m_cachedTransformIsValid = true;
        }
    }

    public final void getCompositeTransformCumulativeInv(Transform2D transform2D) {
        Transform2D transform2D2 = this.m_cachedTransform;
        transform2D2.setIdentity();
        if (this.m_nodeTransform != null) {
            transform2D2.postMultiply(this.m_nodeTransform);
        }
        if (this.m_scaleX != 65536 || this.m_scaleY != 65536) {
            transform2D2.postScalex(this.m_scaleX, this.m_scaleY);
        }
        if (this.m_rotation != 0) {
            transform2D2.postRotatex(this.m_rotation);
        }
        if (this.m_translationX != 0 || this.m_translationY != 0) {
            transform2D2.postTranslatex(this.m_translationX, this.m_translationY);
        }
        this.m_cachedTransformIsValid = false;
        transform2D.postMultiply(this.m_cachedTransform);
    }

    public final void addChild(Node2D node2D) {
        Node2D node2D2 = node2D.getParent();
        if (node2D2 != null) {
            node2D2.removeChild(node2D);
        }
        if (this.m_children == null) {
            this.m_children = new Vector();
            this.m_parentTransform = new Transform2D();
        }
        this.m_children.addElement(node2D);
        node2D.m_parent = this;
    }

    public final void removeChild(Node2D node2D) {
        if (this.m_children != null) {
            this.m_children.removeElement(node2D);
        }
    }

    public final Node2D getParent() {
        return this.m_parent;
    }

    public final boolean isDescendantOf(Node2D node2D) {
        for (Node2D node2D2 = this.getParent(); node2D2 != null; node2D2 = node2D2.getParent()) {
            if (node2D2 != node2D) continue;
            return true;
        }
        return false;
    }

    public boolean getTransformTo(Node2D node2D, Transform2D transform2D) {
        int n;
        Node2D node2D2 = this;
        boolean bl = false;
        int n2 = 0;
        while (node2D2 != node2D) {
            Node2D.m_tempNodeList[n2++] = node2D2;
            if (node2D2.m_parent == null) break;
            node2D2 = node2D2.m_parent;
        }
        for (n = n2 - 1; n >= 0; --n) {
            m_tempNodeList[n].getCompositeTransformCumulative(transform2D);
        }
        if (node2D2 == node2D) {
            bl = true;
        }
        for (n = 0; n < m_tempNodeList.length; ++n) {
            Node2D.m_tempNodeList[n] = null;
        }
        return bl;
    }
}

