/*
 * Decompiled with CFR 0.152.
 */
package generic;

import com.ea.sdk.SDKString;
import constants.Layout2Constants;
import game.AppEngine;
import game.Scene;
import generic.AnimPlayer;
import generic.MathExt;
import generic.ResourceManager;
import generic.TextManager;
import java.io.DataInputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class LayoutManager2
implements Layout2Constants {
    public static final int SUBLAYOUT_HIDE = -1;
    private int[] m_colors;
    private int[] m_imageIds;
    private Image[] m_images;
    private AnimPlayer[] m_animPlayers;
    private int m_animPlayerIndex;
    private short[] m_events;
    private short[] m_vertices;
    private short[] m_scratchVertices;
    private short[] m_keyframes;
    private static final int KEYFRAME_INTERPOLATION_SHIFT = 14;
    private static final int KEYFRAME_INTERPOLATION_MASK = 3;
    private static final int KEYFRAME_TARGET_MASK = 16383;
    private short[] m_displayList;
    private short[] m_layoutEventOffset;
    private short[] m_layoutVertexOffset;
    private short[] m_layoutKeyframeOffset;
    private short[] m_layoutDisplayListOffset;
    private TextManager m_textManager;
    private ResourceManager m_resourceManager;
    private Scene m_scene;
    private int m_scrollOffsetF;
    private static final int SCROLL_SPEED_F = 1092;
    private static final int SCROLL_HSPACE = 30;
    private static final int SCROLL_DELAY = 500;
    private int m_scrollTimeout;
    private static final int MAX_ANIM_PLAYERS = 8;
    private static final int[] s_entityVertexCount = new int[12];
    private boolean isAcceptButtonVisible = true;

    public LayoutManager2(DataInputStream dataInputStream, TextManager textManager, ResourceManager resourceManager) {
        this.m_textManager = textManager;
        this.m_resourceManager = resourceManager;
        try {
            this.loadData(dataInputStream);
        }
        catch (IOException iOException) {
            AppEngine.ASSERT(false, "Failed to load layout data");
        }
        catch (NegativeArraySizeException negativeArraySizeException) {
            System.out.println("inside 1 exception ");
        }
        catch (Exception exception) {
            System.out.println("inside 2 exception ");
        }
    }

    private final void loadData(DataInputStream dataInputStream) throws IOException, NegativeArraySizeException {
        int n;
        int n2;
        int n3;
        int n4 = dataInputStream.readByte();
        int n5 = dataInputStream.readByte() * 3;
        int[] nArray = new int[n5];
        for (n3 = 0; n3 < n5; ++n3) {
            nArray[n3] = dataInputStream.readUnsignedByte();
        }
        this.m_colors = nArray;
        n3 = dataInputStream.readByte();
        this.m_imageIds = new int[n3];
        this.m_images = new Image[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            this.m_imageIds[n2] = this.readSymbol(dataInputStream);
        }
        n2 = dataInputStream.readShort();
        short s = dataInputStream.readShort();
        short s2 = dataInputStream.readShort();
        short s3 = dataInputStream.readShort();
        this.m_layoutEventOffset = new short[n4 + 1];
        this.m_layoutVertexOffset = new short[n4 + 1];
        this.m_layoutKeyframeOffset = new short[n4 + 1];
        this.m_layoutDisplayListOffset = new short[n4 + 1];
        this.m_events = new short[s3];
        this.m_displayList = new short[n2];
        this.m_vertices = new short[s];
        this.m_scratchVertices = new short[s];
        this.m_keyframes = new short[s2];
        short s4 = 0;
        short s5 = 0;
        short s6 = 0;
        short s7 = 0;
        for (int i = 0; i < n4; ++i) {
            int n6;
            int n7;
            int n8;
            this.m_layoutEventOffset[i] = s4;
            this.m_layoutVertexOffset[i] = s5;
            this.m_layoutKeyframeOffset[i] = s6;
            this.m_layoutDisplayListOffset[i] = s7;
            n = dataInputStream.readByte();
            int n9 = dataInputStream.readByte();
            for (n8 = 0; n8 < n9; ++n8) {
                short s8 = s4;
                s4 = (short)(s4 + 1);
                this.m_events[s8] = dataInputStream.readShort();
                short s9 = s4;
                s4 = (short)(s4 + 1);
                this.m_events[s9] = dataInputStream.readByte();
                short s10 = s4;
                s4 = (short)(s4 + 1);
                this.m_events[s10] = dataInputStream.readByte();
            }
            n8 = dataInputStream.readByte();
            for (n7 = 0; n7 < n8; ++n7) {
                short s11 = s5;
                s5 = (short)(s5 + 1);
                this.m_vertices[s11] = dataInputStream.readShort();
                short s12 = s5;
                s5 = (short)(s5 + 1);
                this.m_vertices[s12] = dataInputStream.readShort();
                short s13 = s5;
                s5 = (short)(s5 + 1);
                this.m_vertices[s13] = (short)dataInputStream.readUnsignedByte();
                short s14 = s5;
                s5 = (short)(s5 + 1);
                this.m_vertices[s14] = (short)dataInputStream.readUnsignedByte();
            }
            n7 = dataInputStream.readShort();
            for (n6 = 0; n6 < n7; ++n6) {
                this.m_keyframes[s6] = dataInputStream.readShort();
                short s15 = s6;
                s6 = (short)(s6 + 1);
                this.m_keyframes[s15] = (short)(this.m_keyframes[s15] | dataInputStream.readByte() << 14);
                short s16 = s6;
                s6 = (short)(s6 + 1);
                this.m_keyframes[s16] = dataInputStream.readShort();
                short s17 = s6;
                s6 = (short)(s6 + 1);
                this.m_keyframes[s17] = dataInputStream.readShort();
            }
            block20: for (n6 = 0; n6 < n; ++n6) {
                short s18 = s7;
                s7 = (short)(s7 + 1);
                short s19 = dataInputStream.readByte();
                this.m_displayList[s18] = s19;
                short s20 = s19;
                switch (s20) {
                    case 0: {
                        short s21 = s7;
                        s7 = (short)(s7 + 1);
                        this.m_displayList[s21] = (short)dataInputStream.readUnsignedByte();
                        continue block20;
                    }
                    case 1: {
                        short s22 = s7;
                        s7 = (short)(s7 + 1);
                        this.m_displayList[s22] = (short)dataInputStream.readUnsignedByte();
                        continue block20;
                    }
                    case 2: {
                        short s23 = s7;
                        s7 = (short)(s7 + 1);
                        this.m_displayList[s23] = (short)dataInputStream.readUnsignedByte();
                        continue block20;
                    }
                    case 4: {
                        short s24 = s7;
                        s7 = (short)(s7 + 1);
                        this.m_displayList[s24] = this.readSymbol(dataInputStream);
                        short s25 = s7;
                        s7 = (short)(s7 + 1);
                        this.m_displayList[s25] = dataInputStream.readShort();
                        short s26 = s7;
                        s7 = (short)(s7 + 1);
                        this.m_displayList[s26] = dataInputStream.readShort();
                        continue block20;
                    }
                    case 5: {
                        short s27 = s7;
                        s7 = (short)(s7 + 1);
                        this.m_displayList[s27] = dataInputStream.readShort();
                        short s28 = s7;
                        s7 = (short)(s7 + 1);
                        this.m_displayList[s28] = dataInputStream.readShort();
                        short s29 = s7;
                        s7 = (short)(s7 + 1);
                        this.m_displayList[s29] = this.readSymbol(dataInputStream);
                        continue block20;
                    }
                    case 6: {
                        short s30 = s7;
                        s7 = (short)(s7 + 1);
                        this.m_displayList[s30] = dataInputStream.readShort();
                        short s31 = s7;
                        s7 = (short)(s7 + 1);
                        this.m_displayList[s31] = dataInputStream.readShort();
                        short s32 = s7;
                        s7 = (short)(s7 + 1);
                        this.m_displayList[s32] = this.readSymbol(dataInputStream);
                        short s33 = s7;
                        s7 = (short)(s7 + 1);
                        this.m_displayList[s33] = dataInputStream.readByte();
                        continue block20;
                    }
                    case 7: {
                        short s34 = s7;
                        s7 = (short)(s7 + 1);
                        this.m_displayList[s34] = this.readSymbol(dataInputStream);
                        short s35 = s7;
                        s7 = (short)(s7 + 1);
                        this.m_displayList[s35] = dataInputStream.readShort();
                        short s36 = s7;
                        s7 = (short)(s7 + 1);
                        this.m_displayList[s36] = this.readSymbol(dataInputStream);
                        short s37 = s7;
                        s7 = (short)(s7 + 1);
                        this.m_displayList[s37] = dataInputStream.readByte();
                        continue block20;
                    }
                    case 8: {
                        short s38 = s7;
                        s7 = (short)(s7 + 1);
                        this.m_displayList[s38] = (short)dataInputStream.readUnsignedByte();
                        continue block20;
                    }
                    case 9: {
                        short s39 = s7;
                        s7 = (short)(s7 + 1);
                        this.m_displayList[s39] = (short)dataInputStream.readUnsignedByte();
                        short s40 = s7;
                        s7 = (short)(s7 + 1);
                        this.m_displayList[s40] = (short)dataInputStream.readUnsignedByte();
                        short s41 = s7;
                        s7 = (short)(s7 + 1);
                        this.m_displayList[s41] = (short)dataInputStream.readUnsignedByte();
                        short s42 = s7;
                        s7 = (short)(s7 + 1);
                        this.m_displayList[s42] = (short)dataInputStream.readUnsignedByte();
                        short s43 = s7;
                        s7 = (short)(s7 + 1);
                        this.m_displayList[s43] = (short)dataInputStream.readUnsignedByte();
                        continue block20;
                    }
                    case 10: {
                        short s44 = s7;
                        s7 = (short)(s7 + 1);
                        this.m_displayList[s44] = (short)dataInputStream.readUnsignedByte();
                        short s45 = s7;
                        s7 = (short)(s7 + 1);
                        this.m_displayList[s45] = (short)dataInputStream.readUnsignedByte();
                        short s46 = s7;
                        s7 = (short)(s7 + 1);
                        this.m_displayList[s46] = (short)dataInputStream.readUnsignedByte();
                        short s47 = s7;
                        s7 = (short)(s7 + 1);
                        this.m_displayList[s47] = (short)dataInputStream.readUnsignedByte();
                        short s48 = s7;
                        s7 = (short)(s7 + 1);
                        this.m_displayList[s48] = (short)dataInputStream.readUnsignedByte();
                        continue block20;
                    }
                    case 3: {
                        short s49 = s7;
                        s7 = (short)(s7 + 1);
                        this.m_displayList[s49] = this.readSymbol(dataInputStream);
                        continue block20;
                    }
                    case 11: {
                        short s50 = s7;
                        s7 = (short)(s7 + 1);
                        this.m_displayList[s50] = this.readSymbol(dataInputStream);
                        short s51 = s7;
                        s7 = (short)(s7 + 1);
                        this.m_displayList[s51] = (short)dataInputStream.readUnsignedByte();
                        continue block20;
                    }
                    default: {
                        AppEngine.ASSERT(false, "Unknown entity type");
                    }
                }
            }
        }
        this.m_layoutEventOffset[i] = s4;
        this.m_layoutVertexOffset[i] = s5;
        this.m_layoutKeyframeOffset[i] = s6;
        this.m_layoutDisplayListOffset[i] = s7;
        AppEngine.ASSERT(s5 == this.m_vertices.length, "Incorrect vertex list length");
        AppEngine.ASSERT(s6 == this.m_keyframes.length, "Incorrect keyframe array length");
        AppEngine.ASSERT(s7 == this.m_displayList.length, "Incorrect display list length");
        this.m_animPlayers = new AnimPlayer[8];
        for (n = 0; n < this.m_animPlayers.length; ++n) {
            this.m_animPlayers[n] = new AnimPlayer();
        }
    }

    private final short readSymbol(DataInputStream dataInputStream) {
        try {
            return dataInputStream.readShort();
        }
        catch (IOException iOException) {
            return -1;
        }
    }

    public void setScene(Scene scene) {
        this.m_scene = scene;
    }

    public int getMenuItemTime(int n, int n2) {
        int n3 = this.m_layoutEventOffset[n];
        short s = this.m_layoutEventOffset[n + 1];
        int n4 = 0;
        int n5 = n3;
        while (n5 < s) {
            short s2 = this.m_events[n5++];
            short s3 = this.m_events[n5++];
            short s4 = this.m_events[n5++];
            if (s3 != 0) continue;
            if (n4 == n2) {
                return s2;
            }
            ++n4;
        }
        AppEngine.debug("Invalid menu item index requested in LayoutManager.getMenuItemTime().");
        return 0;
    }

    public int getAnimationTime(int n, int n2) {
        int n3 = this.m_layoutEventOffset[n];
        short s = this.m_layoutEventOffset[n + 1];
        int n4 = n3;
        while (n4 < s) {
            short s2 = this.m_events[n4++];
            short s3 = this.m_events[n4++];
            short s4 = this.m_events[n4++];
            if (s3 != 1 || s4 != n2) continue;
            return s2;
        }
        return -1;
    }

    public int getAnimationStopTime(int n, int n2) {
        int n3 = this.m_layoutEventOffset[n];
        short s = this.m_layoutEventOffset[n + 1];
        int n4 = n3;
        while (n4 < s) {
            short s2 = this.m_events[n4++];
            short s3 = this.m_events[n4++];
            short s4 = this.m_events[n4++];
            if (s3 != 2 || s2 < n2) continue;
            return s2;
        }
        return -1;
    }

    public void resetScrollOffset() {
        this.m_scrollOffsetF = 0;
        this.m_scrollTimeout = 500;
    }

    public void updateScrollOffset(int n) {
        if (this.m_scrollTimeout > 0) {
            this.m_scrollTimeout -= n;
        } else {
            this.m_scrollOffsetF += MathExt.mulF(n << 16, 1092);
        }
    }

    public void updateAnims(int n) {
        AnimPlayer[] animPlayerArray = this.m_animPlayers;
        for (int i = 0; i < animPlayerArray.length; ++i) {
            animPlayerArray[i].updateAnim(n);
        }
        this.m_animPlayerIndex = 0;
    }

    public void resetAnims() {
        AnimPlayer[] animPlayerArray = this.m_animPlayers;
        for (int i = 0; i < animPlayerArray.length; ++i) {
            animPlayerArray[i].startAnim(0, 16);
            animPlayerArray[i].setAnimating(false);
        }
    }

    private void interpolateVertices(int n, int n2) {
        short s = this.m_layoutVertexOffset[n];
        int n3 = this.m_layoutVertexOffset[n + 1] - s;
        System.arraycopy(this.m_vertices, s, this.m_scratchVertices, s, n3);
        short[] sArray = this.m_scratchVertices;
        short[] sArray2 = this.m_keyframes;
        int n4 = this.m_layoutKeyframeOffset[n];
        short s2 = this.m_layoutKeyframeOffset[n + 1];
        int n5 = -1;
        int n6 = 0;
        int n7 = -1;
        while (n4 < s2) {
            int n8 = sArray2[n4++];
            int n9 = n8 >> 14 & 3;
            int n10 = sArray2[n4++];
            int n11 = sArray2[n4++];
            if ((n8 &= 0x3FFF) != n5 && n6 < n2 && n5 != -1) {
                sArray[s + n5] = n7;
            }
            if (n8 != n5) {
                n6 = 0;
                n7 = sArray[s + n8];
            }
            if (n10 == n2) {
                sArray[s + n8] = n11;
            } else if (n6 < n2 && n10 > n2) {
                switch (n9) {
                    case 0: {
                        sArray[s + n8] = n7;
                        break;
                    }
                    case 1: {
                        sArray[s + n8] = this.interpolateLinear(n2, n6, n7, n10, n11);
                        break;
                    }
                    case 2: {
                        sArray[s + n8] = this.interpolateSmooth(n2, n6, n7, n10, n11);
                    }
                }
            }
            n5 = n8;
            n6 = n10;
            n7 = n11;
        }
        if (n6 < n2 && n5 != -1) {
            sArray[s + n5] = n7;
        }
    }

    private short interpolateLinear(int n, int n2, int n3, int n4, int n5) {
        int n6 = n4 - n2;
        int n7 = n - n2;
        int n8 = n6 - n7;
        return (short)((n8 * n3 + n7 * n5) / n6);
    }

    private short interpolateSmooth(int n, int n2, int n3, int n4, int n5) {
        int n6 = MathExt.smoothstepF(n2 << 16, n4 << 16, n << 16);
        return (short)((65536 - n6) * n3 + n6 * n5 >> 16);
    }

    private static int transformX(int n, int n2, int n3) {
        return n + n3 * n2 / 255;
    }

    private static int transformY(int n, int n2, int n3) {
        return n + n3 * n2 / 255;
    }

    public void loadImage(int n) {
        Image[] imageArray = this.m_images;
        int[] nArray = this.m_imageIds;
        int n2 = nArray.length;
        for (int i = 0; i < n2; ++i) {
            if (nArray[i] != n || imageArray[i] != null) continue;
            Image image = null;
            for (int j = 3; j > 0; ++j) {
                image = this.m_resourceManager.loadImage(nArray[i]);
                if (image != null) {
                    imageArray[i] = image;
                    return;
                }
                System.gc();
                Thread.yield();
                try {
                    Thread.sleep(50L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    public void unloadImage(int n) {
        for (int i = 0; i < this.m_imageIds.length; ++i) {
            if (this.m_imageIds[i] != n || this.m_images[i] == null) continue;
            this.m_images[i] = null;
        }
    }

    private static final int getEntityVertexCount(int n) {
        return s_entityVertexCount[n];
    }

    public void setAcceptButtonVisible(boolean bl) {
        this.isAcceptButtonVisible = bl;
    }

    public void drawLayout(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        this.interpolateVertices(n, n6);
        Scene scene = this.m_scene;
        short[] sArray = this.m_displayList;
        short[] sArray2 = this.m_scratchVertices;
        int n7 = this.m_layoutVertexOffset[n];
        int n8 = this.m_layoutDisplayListOffset[n];
        short s = this.m_layoutDisplayListOffset[n + 1];
        AnimPlayer[] animPlayerArray = this.m_animPlayers;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        while (n8 < s) {
            short s2;
            int n13;
            if ((n13 = LayoutManager2.getEntityVertexCount(s2 = sArray[n8++])) == 1) {
                n9 = sArray2[n7++];
                n10 = sArray2[n7++];
                n9 = LayoutManager2.transformX(n9, sArray2[n7++], n4) + n2;
                n10 = LayoutManager2.transformY(n10, sArray2[n7++], n5) + n3;
            } else {
                n9 = sArray2[n7++];
                n10 = sArray2[n7++];
                n9 = LayoutManager2.transformX(n9, sArray2[n7++], n4) + n2;
                n10 = LayoutManager2.transformY(n10, sArray2[n7++], n5) + n3;
                n11 = sArray2[n7++];
                n12 = sArray2[n7++];
                n11 = LayoutManager2.transformX(n11, sArray2[n7++], n4) + n2;
                n12 = LayoutManager2.transformY(n12, sArray2[n7++], n5) + n3;
            }
            switch (s2) {
                case 0: {
                    this.drawFillRect(graphics, n9, n10, n11, n12, sArray[n8 + 0]);
                    ++n8;
                    break;
                }
                case 2: {
                    scene.drawLayoutPoint(graphics, sArray[n8 + 0], n9, n10);
                    ++n8;
                    break;
                }
                case 1: {
                    scene.drawLayoutRect(graphics, sArray[n8 + 0], n9, n10, n11, n12);
                    ++n8;
                    break;
                }
                case 4: {
                    this.m_textManager.drawString(sArray[n8 + 0], (int)sArray[n8 + 2], n9, n10, (int)sArray[n8 + 1]);
                    n8 += 3;
                    break;
                }
                case 5: {
                    if (n == 1 && !this.isAcceptButtonVisible && n9 < n4 >> 2) {
                        n8 += 3;
                        break;
                    }
                    this.m_textManager.drawString(scene.getLayoutString(sArray[n8 + 0]), (int)sArray[n8 + 2], n9, n10, (int)sArray[n8 + 1]);
                    n8 += 3;
                    break;
                }
                case 6: {
                    this.drawWrappedString(graphics, scene.getLayoutString(sArray[n8 + 0]), sArray[n8 + 1], sArray[n8 + 2], sArray[n8 + 3], n9, n10, n11, n12);
                    n8 += 4;
                    break;
                }
                case 7: {
                    this.drawWrappedString(graphics, this.m_textManager.getString(sArray[n8 + 0]), sArray[n8 + 1], sArray[n8 + 2], sArray[n8 + 3], n9, n10, n11, n12);
                    n8 += 4;
                    break;
                }
                case 8: {
                    this.drawImage(graphics, n9, n10, sArray[n8 + 0]);
                    ++n8;
                    break;
                }
                case 9: {
                    this.drawPattern(graphics, n9, n10, n11, n12, sArray[n8 + 0], sArray[n8 + 1], sArray[n8 + 2], sArray[n8 + 3], sArray[n8 + 4]);
                    n8 += 5;
                    break;
                }
                case 10: {
                    if (n == 1 && !this.isAcceptButtonVisible && n9 < n4 >> 2) {
                        n8 += 5;
                        break;
                    }
                    this.drawImageRegion(graphics, n9, n10, sArray[n8 + 0], sArray[n8 + 1], sArray[n8 + 2], sArray[n8 + 3], sArray[n8 + 4]);
                    n8 += 5;
                    break;
                }
                case 3: {
                    animPlayerArray[this.m_animPlayerIndex].startAnim(sArray[n8 + 0], 4);
                    animPlayerArray[this.m_animPlayerIndex++].drawAnim(graphics, n9, n10);
                    ++n8;
                    break;
                }
                case 11: {
                    int n14 = scene.getSubLayoutTime(sArray[n8 + 1]);
                    if (n14 != -1) {
                        short s3 = sArray[n8 + 0];
                        this.drawLayout(graphics, s3, n9, n10, n11 - n9, n12 - n10, n14);
                    }
                    n8 += 2;
                }
            }
        }
    }

    private void drawFillRect(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        int n6 = n5 * 3;
        int[] nArray = this.m_colors;
        graphics.setColor(nArray[n6], nArray[n6 + 1], nArray[n6 + 2]);
        graphics.fillRect(n, n2, n3 - n, n4 - n2);
    }

    private void drawImage(Graphics graphics, int n, int n2, int n3) {
        Image image = this.m_images[n3];
        if (image == null) {
            return;
        }
        graphics.drawImage(image, n, n2, 20);
    }

    private void drawImageRegion(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        Image image = this.m_images[n3];
        if (image == null) {
            return;
        }
        AppEngine.ASSERT(n4 >= 0 && n6 <= image.getWidth() && n5 >= 0 && n7 <= image.getHeight(), "image region out of bounds");
        AppEngine.ASSERT(n4 < n6 && n5 < n7, "image region inverted");
        graphics.drawRegion(image, n4, n5, n6 - n4, n7 - n5, 0, n, n2, 20);
    }

    private void drawPattern(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        Image image = this.m_images[n5];
        if (image == null) {
            return;
        }
        int n10 = graphics.getClipX();
        int n11 = graphics.getClipY();
        int n12 = graphics.getClipWidth();
        int n13 = graphics.getClipHeight();
        int n14 = n8 - n6;
        int n15 = n9 - n7;
        graphics.setClip(n, n2, n3 - n, n4 - n2);
        while (n2 < n4) {
            for (int i = n; i < n3; i += n14) {
                graphics.drawRegion(image, n6, n7, n14, n15, 0, i, n2, 20);
            }
            n2 += n15;
        }
        graphics.setClip(n10, n11, n12, n13);
    }

    private void drawWrappedString(Graphics graphics, SDKString sDKString, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        if (sDKString.length() == 0) {
            return;
        }
        if (n3 == 1) {
            this.drawScrollingString(graphics, sDKString, n2, n4, n5, n6, n7);
            return;
        }
        TextManager textManager = this.m_textManager;
        int n8 = textManager.wrapString(sDKString, n2, n6 - n4);
        if ((n & 1) != 0) {
            n4 += n6 - n4 >> 1;
        } else if ((n & 8) != 0) {
            n4 = n6;
        }
        if ((n & 2) != 0) {
            int n9 = n8 * textManager.getLineHeight(n2);
            n5 += n7 - n5 - n9 >> 1;
        } else if ((n & 0x20) != 0) {
            int n10 = n8 * textManager.getLineHeight(n2);
            n5 = n7 - n10;
        }
        textManager.drawWrappedString(n2, n4, n5, n & 0xFFFFFFCD);
    }

    private void drawScrollingString(Graphics graphics, SDKString sDKString, int n, int n2, int n3, int n4, int n5) {
        TextManager textManager = this.m_textManager;
        int n6 = graphics.getClipX();
        int n7 = graphics.getClipY();
        int n8 = graphics.getClipWidth();
        int n9 = graphics.getClipHeight();
        int n10 = textManager.getStringWidth(sDKString, n);
        if (n10 < n4 - n2) {
            textManager.drawString(sDKString, n, (n2 + n4) / 2, n3, 17);
        } else {
            int n11 = this.m_scrollOffsetF >> 16;
            graphics.setClip(n2, n3, n4 - n2, n5 - n3);
            textManager.drawString(sDKString, n, n2 - (n11 %= (n10 += 30)), n3, 20);
            textManager.drawString(sDKString, n, n2 - n11 + n10, n3, 20);
            graphics.setClip(n6, n7, n8, n9);
        }
    }

    static {
        LayoutManager2.s_entityVertexCount[2] = 1;
        LayoutManager2.s_entityVertexCount[8] = 1;
        LayoutManager2.s_entityVertexCount[10] = 1;
        LayoutManager2.s_entityVertexCount[3] = 1;
        LayoutManager2.s_entityVertexCount[4] = 1;
        LayoutManager2.s_entityVertexCount[5] = 1;
        LayoutManager2.s_entityVertexCount[1] = 2;
        LayoutManager2.s_entityVertexCount[0] = 2;
        LayoutManager2.s_entityVertexCount[7] = 2;
        LayoutManager2.s_entityVertexCount[6] = 2;
        LayoutManager2.s_entityVertexCount[9] = 2;
        LayoutManager2.s_entityVertexCount[11] = 2;
    }
}

