/*
 * Decompiled with CFR 0.152.
 */
package generic;

import java.io.DataInputStream;
import java.io.InputStream;

public final class ImageExt {
    private int m_width;
    private int m_height;
    private byte[] m_indices;
    private int m_paletteSize;
    private byte[] m_palette;

    public ImageExt(InputStream inputStream) {
        this.loadImage(inputStream);
    }

    public final int getHeight() {
        return this.m_height;
    }

    public final int getWidth() {
        return this.m_width;
    }

    public final void loadPalette(InputStream inputStream) {
        try {
            inputStream.read(this.m_palette, 0, this.m_paletteSize * 3);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static final int readInt(DataInputStream dataInputStream) throws Exception {
        return dataInputStream.readUnsignedByte() | dataInputStream.readUnsignedByte() << 8 | dataInputStream.readUnsignedByte() << 16 | dataInputStream.readUnsignedByte() << 24;
    }

    private static final short readShort(DataInputStream dataInputStream) throws Exception {
        return (short)(dataInputStream.readUnsignedByte() | dataInputStream.readUnsignedByte() << 8);
    }

    public final void loadImage(InputStream inputStream) {
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        try {
            dataInputStream.readByte();
            dataInputStream.readByte();
            ImageExt.readInt(dataInputStream);
            ImageExt.readShort(dataInputStream);
            ImageExt.readShort(dataInputStream);
            ImageExt.readInt(dataInputStream);
            ImageExt.readInt(dataInputStream);
            int n = ImageExt.readInt(dataInputStream);
            int n2 = ImageExt.readInt(dataInputStream);
            ImageExt.readShort(dataInputStream);
            short s = ImageExt.readShort(dataInputStream);
            ImageExt.readInt(dataInputStream);
            ImageExt.readInt(dataInputStream);
            ImageExt.readInt(dataInputStream);
            ImageExt.readInt(dataInputStream);
            int n3 = ImageExt.readInt(dataInputStream);
            ImageExt.readInt(dataInputStream);
            if (s == 8 && n3 == 0) {
                n3 = 256;
            }
            if (s == 8) {
                int n4;
                this.m_paletteSize = n3;
                this.m_palette = new byte[this.m_paletteSize * 3];
                for (n4 = 0; n4 < this.m_paletteSize; ++n4) {
                    this.m_palette[n4 * 3 + 2] = (byte)dataInputStream.readUnsignedByte();
                    this.m_palette[n4 * 3 + 1] = (byte)dataInputStream.readUnsignedByte();
                    this.m_palette[n4 * 3 + 0] = (byte)dataInputStream.readUnsignedByte();
                    dataInputStream.skip(1L);
                }
                this.m_width = n;
                this.m_height = n2;
                this.m_indices = new byte[this.m_width * this.m_height];
                n4 = 4 - (this.m_width & 3) & 3;
                if (n4 > 0) {
                    for (int i = n2 - 1; i >= 0; --i) {
                        dataInputStream.readFully(this.m_indices, i * this.m_width, this.m_width);
                        dataInputStream.skip(n4);
                    }
                } else {
                    for (int i = n2 - 1; i >= 0; --i) {
                        dataInputStream.readFully(this.m_indices, i * this.m_width, this.m_width);
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static final void writeInt(byte[] byArray, int n, int n2) {
        byArray[n + 0] = (byte)(n2 & 0xFF);
        byArray[n + 1] = (byte)(n2 >> 8 & 0xFF);
        byArray[n + 2] = (byte)(n2 >> 16 & 0xFF);
        byArray[n + 3] = (byte)(n2 >> 24 & 0xFF);
    }

    private static final void writeShort(byte[] byArray, int n, short s) {
        byArray[n + 0] = (byte)(s & 0xFF);
        byArray[n + 1] = (byte)(s >> 8 & 0xFF);
    }

    public final byte[] getBMPStream() {
        int n;
        int n2 = 4 - (this.m_width & 3) & 3;
        int n3 = 54 + this.m_paletteSize * 4 + (this.m_width + n2) * this.m_height;
        int n4 = 54 + this.m_paletteSize * 4;
        byte[] byArray = new byte[n3];
        byArray[0] = 66;
        byArray[1] = 77;
        ImageExt.writeInt(byArray, 2, n3);
        ImageExt.writeShort(byArray, 6, (short)0);
        ImageExt.writeShort(byArray, 8, (short)0);
        ImageExt.writeInt(byArray, 10, n4);
        ImageExt.writeInt(byArray, 14, 40);
        ImageExt.writeInt(byArray, 18, this.m_width);
        ImageExt.writeInt(byArray, 22, this.m_height);
        ImageExt.writeShort(byArray, 26, (short)1);
        ImageExt.writeShort(byArray, 28, (short)8);
        ImageExt.writeInt(byArray, 30, 0);
        ImageExt.writeInt(byArray, 34, 0);
        ImageExt.writeInt(byArray, 38, 2835);
        ImageExt.writeInt(byArray, 42, 2835);
        ImageExt.writeInt(byArray, 46, this.m_paletteSize);
        ImageExt.writeInt(byArray, 50, this.m_paletteSize);
        int n5 = 54;
        for (n = 0; n < this.m_paletteSize; ++n) {
            byArray[n5 + 0] = this.m_palette[n * 3 + 2];
            byArray[n5 + 1] = this.m_palette[n * 3 + 1];
            byArray[n5 + 2] = this.m_palette[n * 3 + 0];
            byArray[n5 + 3] = 0;
            n5 += 4;
        }
        for (n = this.m_height - 1; n >= 0; --n) {
            System.arraycopy(this.m_indices, n * this.m_width, byArray, n5, this.m_width);
            n5 += this.m_width + n2;
        }
        return byArray;
    }

    public final void blitIn(ImageExt imageExt, int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int[] nArray = new int[imageExt.m_paletteSize];
        byte[] byArray = new byte[(imageExt.m_paletteSize + this.m_paletteSize) * 3];
        System.arraycopy(this.m_palette, 0, byArray, 0, this.m_paletteSize * 3);
        this.m_palette = byArray;
        for (n9 = 0; n9 < imageExt.m_paletteSize; ++n9) {
            n8 = imageExt.m_palette[n9 * 3 + 0];
            n7 = imageExt.m_palette[n9 * 3 + 1];
            n6 = imageExt.m_palette[n9 * 3 + 2];
            n5 = 0;
            for (n5 = this.m_paletteSize - 1; n5 >= 0 && (n8 != this.m_palette[n5 * 3 + 0] || n7 != this.m_palette[n5 * 3 + 1] || n6 != this.m_palette[n5 * 3 + 2]); --n5) {
            }
            if (n5 < 0) {
                n5 = this.m_paletteSize++;
                this.m_palette[n5 * 3 + 0] = imageExt.m_palette[n9 * 3 + 0];
                this.m_palette[n5 * 3 + 1] = imageExt.m_palette[n9 * 3 + 1];
                this.m_palette[n5 * 3 + 2] = imageExt.m_palette[n9 * 3 + 2];
            }
            nArray[n9] = n5;
        }
        if (this.m_paletteSize <= 256) {
            n9 = n2 + n4 < this.m_height ? n4 : this.m_height - n2;
            n8 = n + n3 < this.m_width ? n3 : this.m_width - n;
            for (n7 = 0; n7 < n9; ++n7) {
                n6 = n7 * imageExt.m_width;
                n5 = (n7 + n2) * this.m_width + n;
                for (int i = n8 - 1; i >= 0; --i) {
                    short s;
                    short s2 = imageExt.m_indices[n6 + i];
                    if (s2 < 0) {
                        s2 = (short)(s2 + 256);
                    }
                    if ((s = (short)((byte)nArray[s2])) < 0) {
                        s = (short)(s + 256);
                    }
                    this.m_indices[n5 + i] = (byte)s;
                }
            }
        }
    }

    public final void flipY() {
        byte[] byArray = new byte[this.m_width];
        for (int i = 0; i < this.m_height >> 1; ++i) {
            System.arraycopy(this.m_indices, i * this.m_width, byArray, 0, this.m_width);
            System.arraycopy(this.m_indices, (this.m_height - i - 1) * this.m_width, this.m_indices, i * this.m_width, this.m_width);
            System.arraycopy(byArray, 0, this.m_indices, (this.m_height - i - 1) * this.m_width, this.m_width);
        }
    }

    public final void clearToColour(int n) {
        this.m_palette[3] = (byte)(n >> 16 & 0xFF);
        this.m_palette[4] = (byte)(n >> 8 & 0xFF);
        this.m_palette[5] = (byte)(n & 0xFF);
        for (int i = 0; i < this.m_indices.length; ++i) {
            this.m_indices[i] = 1;
        }
    }
}

