/*
 * Decompiled with CFR 0.152.
 */
package game;

import com.ea.nfs10.MonkeyApp;
import com.ea.sdk.SDKSoundManager;
import com.ea.sdk.SDKString;
import com.ea.sdk.SDKUtils;
import constants.AnimConstants;
import constants.CarConstants;
import constants.ColourConstants;
import constants.EventConstants;
import constants.FlowConstants;
import constants.FontConstants;
import constants.IStringConstants;
import constants.InputConstants;
import constants.Layout2Constants;
import constants.ObjectConstants;
import constants.ResourceConstants;
import constants.SoundEventConstants;
import constants.SplineConstants;
import constants.TrackConstants;
import constants.TrackSectionConstants;
import game.DummyTextManager;
import game.GlobalConstants;
import game.MoreGames;
import game.Scene;
import game.SceneGame;
import game.SceneMenu;
import generic.AnimationManager;
import generic.Cache;
import generic.FlowManager;
import generic.LayoutManager2;
import generic.MathExt;
import generic.PostEffects;
import generic.ResourceManager;
import generic.TextManager;
import generic.generic2d.Transform;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Random;
import java.util.Timer;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreNotFoundException;

public final class AppEngine
extends Canvas
implements AnimConstants,
ColourConstants,
FontConstants,
IStringConstants,
ResourceConstants,
SoundEventConstants,
FlowConstants,
InputConstants,
Layout2Constants,
GlobalConstants,
CarConstants,
ObjectConstants,
TrackConstants,
TrackSectionConstants,
SplineConstants,
EventConstants {
    private MonkeyApp m_midlet;
    private boolean m_gameRunning;
    private Scene m_currentScene;
    private boolean m_paused;
    private boolean m_gameDataLoaded;
    private static final int[] TROPHY_NAMES = new int[]{190, 137, 139, 141, 143, 145, 147, 149, 152, 154, 156, 158, 160, 162, 164, 166, 169, 171, 173, 176, 178, 180, 182, 184, 186, 188};
    private static final int[] TROPHY_DESCRIPTIONS = new int[]{191, 138, 140, 142, 144, 146, 148, 150, 153, 155, 157, 159, 161, 163, 165, 167, 170, 172, 174, 177, 179, 181, 183, 185, 187, 189};
    private MoreGames m_moreGames = null;
    private boolean m_moreGamesActive = false;
    private ResourceManager m_resourceManager = null;
    private int m_musicID;
    private final boolean isSimultaneousSounds;
    private SDKSoundManager m_soundManager;
    private Random m_randomInstance;
    private TextManager m_textManager;
    private FlowManager m_flowManager;
    private LayoutManager2 m_layoutManager2;
    private static int[] s_tempInt16 = new int[16];
    private boolean m_runGarbageCollect;
    private static AppEngine s_singletonAppEngine = null;
    private static int s_debugMemoryCount = 0;
    public int selectedEvent = 0;
    public Thread m_gameThread = null;
    private static Timer s_gameTimer = null;
    private static final long SLEEP_TIME = 15L;
    private static boolean s_paintScheduled = false;
    long timeStartFrame;
    private static Image s_screenBuffer = null;
    private static Graphics s_screenBufferG = null;
    private final int KEY_BUFFER_LENGTH;
    private int m_keysPressedDown;
    private int m_commandPressedDown;
    private int[] m_keyBuffer;
    private int[] m_keyArgs = new int[2];
    private static int m_keyBufferIndex;
    public static final int KEYCODE_LSOFTKEY = -6;
    public static final int KEYCODE_RSOFTKEY = -7;
    public static final int KEYCODE_BACKKEY = -8;
    public static final int KEYCODE_BACKKEY_SE = -11;
    public static final int KEYCODE_LSOFTKEY_MOTO = -21;
    public static final int KEYCODE_RSOFTKEY_MOTO = -22;
    public static final int KEYCODE_MSOFTKEY_MOTO = -23;
    public static final int KEYCODE_QKEY_RIM = 113;
    public static final int KEYCODE_PKEY_RIM = 112;
    public static final int KEYCODE_TRACKBALLKEY_RIM = -8;
    public static final int KEYCODE_ESCAPE_RIM = 27;
    private static final int MILLISECONDS_IN_SECOND = 1000;
    private static final int SECONDS_IN_MINUTE = 60;
    private static final int MINUTES_IN_HOUR = 60;
    private static final int MAX_TIME_DECIMALS = 3;
    private static final SDKString GLYPH_STAR_RANK_FALSE;
    private static final SDKString GLYPH_STAR_RANK_TRUE;
    private static final SDKString GLYPH_STAR_STYLE_FALSE;
    private static final SDKString GLYPH_STAR_STYLE_TRUE;
    private static final SDKString GLYPH_MEDAL_GOLD;
    private static final SDKString GLYPH_MEDAL_SILVER;
    private static final SDKString GLYPH_MEDAL_BRONZE;
    private static final SDKString GLYPH_MEDAL_NONE;
    private final SDKString GLYPH_PROGRESS_FALSE = new SDKString("{");
    private final SDKString GLYPH_PROGRESS_TRUE = new SDKString("|");
    private final SDKString GLYPH_PROGRESS_HIGHLIGHT = new SDKString("}");
    private static final int MAX_SCROLLERS = 2;
    private static int[] s_scrollerStringId;
    private static int[] s_scrollerStringWidth;
    private static long[] s_scrollerTime;
    private static int[] s_scrollerOffset;
    private static SDKString[] s_scrollerStringArray;
    public static final int SCROLLER_INITIAL_PAUSE = 1500;
    public static final int SCROLLER_PIXELS_PER_SECOND = 20;
    public static final int SCROLLER_PIXEL_MARGIN = 20;
    private static PostEffects s_postEffects;
    private PostEffects m_postEffectsTexture;
    private boolean m_renderBloomNextFrame;
    private static int s_nextScene;
    private static int s_nextSceneState;
    public static final int VIBRATION_SHORT = 250;
    public static final int VIBRATION_MEDIUM = 400;
    public static final int VIBRATION_LONG = 600;
    public static final byte CHEATS_NUM = 6;
    public static final byte CHEAT_MENU_UNLOCK_EVENTS = 0;
    public static final byte CHEAT_MENU_MONEY = 1;
    public static final byte CHEAT_MENU_CARS = 2;
    public static final byte CHEAT_MENU_EVENT_COMPLETE = 3;
    public static final byte CHEAT_RACE_WIN = 4;
    public static final byte CHEAT_RACE_LOSE = 5;
    public static final int CHEAT_MONEY_AMOUNT = 1000000;
    private boolean[] m_cheatUsed;
    private static final int[][] CHEAT_CODES;
    public static final int SOFTKEYBAR_HEIGHT = 40;
    public static final int SOFTKEYBAR_WIDTH = 50;
    private boolean isSFX = false;
    private final int SOUND_STATE_OFF;
    private final int SOUND_STATE_MUSIC;
    private final int SOUND_STATE_SFX;
    private int soundState = 0;
    private static int soundVolume;
    private int m_timeSinceLastSoundStart;
    private boolean isMusicPlaying = false;
    public static final int LOAD_APPENGINE = 1;
    public static final int LOAD_SCENEMENU = 2;
    public static final int LOAD_SCENEGAME = 4;
    public static final int LOAD_SCENEMENU_INTRO = 8;
    public static final int LOAD_MOREGAMES = 16;
    public static final int LOAD_SCENEMENU_PROMPT = 32;
    public static final long UNLOAD_SCENEGAME = -4L;
    public static final short BIT_SKYLINE = 32;
    public static final short BIT_SKYPARALLAX = 64;
    public static final short BIT_GRASS_DARK = 128;
    public static final short BIT_GRASS_LIGHT = 256;
    public static final short LOAD_FOREST = 512;
    public static final short LOAD_DESERT = 2048;
    public static final short LOAD_COASTAL = 4096;
    public static final byte CAR_MASK_SHIFT = 14;
    public static final short[] LAYOUT_IMAGE_IDS;
    public final short IMAGE_COUNT;
    public static final long[] IMAGE_IDS;
    private static final String RMS_SETTINGS = "nfs10set";
    private static final String RMS_DATA = "nfs10dat";
    private static final int SETTINGS_VERSION = 173;
    private static boolean s_rmsSoundEnabled;
    private static boolean s_rmsVibrationEnabled;
    private static boolean s_rmsCarMarkersEnabled;
    private static boolean s_rmsSpeedunitsMPH;
    private static boolean s_rmsTutorialCompleted;
    private int m_rmsGSLangIndex;
    public static final byte QUICKRACE_NUM_LAPS = 3;
    public static final int CAREER_INITIAL_WALLET = 5000;
    public static final byte ACC_ENGINE = 0;
    public static final byte ACC_TRANSMISSION = 1;
    public static final byte ACC_TYRES = 2;
    public static final byte ACC_NITRO = 3;
    public static final byte ACC_KIT = 4;
    public static final byte TUNERSHOP_NUM_ACC = 4;
    public static final byte MAX_CARS = 30;
    public static final short MAX_TRACKSIDE_OBJECTS_2D = 100;
    public static final int NUM_OPPONENT_CAR_TYPES_PER_RACE = 1;
    public static final int NUM_CIVILIAN_CAR_TYPES_PER_RACE = 1;
    private static int[] s_allowedCivAppearances;
    private static int[] s_allowedOppAppearances;
    private int m_civAppearanceCounter = 0;
    private int m_oppAppearanceCounter = 0;
    private static byte s_rmsNumTimesCallToActionShown;
    private static short[] s_careerTunerMenuStringIDs;
    private static int[][] s_careerTunerAccessoryPrices;
    private static int[][] s_careerTunerAccessoryBoostsF;
    private static boolean s_rmsGameExists;
    private static byte s_rmsCareerActiveCar;
    private static int s_rmsCareerMoney;
    private static byte s_rmsSectorUnlockedQuickRace;
    private static byte[] s_rmsCarsOwned;
    private static byte s_careerNumCarsOwned;
    private static byte[] s_carsNotOwned;
    private static byte[][] s_rmsAccessoryLevel;
    private static int[] s_rmsTrackBestLapTimes;
    private static int[] s_rmsTrackBestRaceTimes;
    private static byte[] s_rmsTrackRanks;
    private static int[] s_rmsTrackSpeedcameraTotal;
    private static int[] s_rmsTrackPatrolTickets;
    public static final byte AWARD_PLACE_3RD = 1;
    public static final byte AWARD_PLACE_2ND = 3;
    public static final byte AWARD_PLACE_1ST = 7;
    public static final byte AWARD_SPECIAL_1 = 8;
    public static final byte AWARD_SPECIAL_2 = 24;
    private int m_raceTime;
    private byte m_raceRank;
    private static byte[] s_rmsEventAwards;
    public static final int DRIVER_PERSONALITY_HISTORY_LENGTH = 5;
    private static final int DRIVER_PERSONALITY_AGGRESSION_MASK = -65536;
    private static final int DRIVER_PERSONALITY_PRECISION_MASK = 65535;
    private static final int DRIVER_PERSONALITY_AGGRESSION_SHIFT = 16;
    private static final int DRIVER_PERSONALITY_PRECISION_SHIFT = 0;
    private static int[] s_rmsPersonalityHistory;
    public static final byte PROFILE_RANK_1ST = 3;
    public static final byte PROFILE_RANK_2ND = 2;
    public static final byte PROFILE_RANK_3RD = 1;
    public static final byte PROFILE_RANK_NONE = -1;
    private static byte[] s_rmsRankHistory;
    private static int s_rmsProfileTotal;
    private static byte s_rmsWelcomeDisplayed;
    public static final int WELCOME_TIER_1 = 0;
    public static final int WELCOME_TIER_2 = 1;
    public static final int WELCOME_TIER_3 = 2;
    public static final int WELCOME_CAREER = 3;
    public static final int WELCOME_TIERS = 4;
    public static final int WELCOME_MYCARS = 5;
    public static final int WELCOME_PROFILE = 6;
    public int prevBestRaceTime;
    public int prevRank;
    private byte[] lastCarsUnlocked = new byte[4];
    private int lastCarsUnlockedAmount = 0;
    private byte m_nextRaceNumLaps;
    public static final int MAX_CASH = 99999999;
    private int m_currentTrack;
    private byte m_numTracks;
    private byte[] m_trackEnvironments;
    private int[] m_trackGrassColours;
    private short[] m_trackDataResIDs;
    private byte[] m_trackFlags;
    private int[] m_trackDistances;
    private int m_lastTrackLength;
    private int m_currentRaceType;
    private byte m_currentRaceEventIndex;
    private int m_carNowRacingParamTyres;
    private int m_carNowRacingParamSteeringInc;
    private int m_carNowRacingParamSteeringRecentreInc;
    private int m_carNowRacingParamSteeringMax;
    private int[] m_carNowRacingGearAccels;
    private int[] m_carNowRacingGearMaxSpeeds;
    private int[] m_carNowRacingGearMinSpeeds;
    private int m_carNowRacingNitroExtra;
    private static final SDKString GLYPH_LOAD_FALSE;
    private static final SDKString GLYPH_LOAD_TRUE;
    private int[][] m_splineBoundingBoxes;
    private int[][][] m_splineNodes;
    private byte[] m_carsAll;
    private short[] m_carMakes;
    private short[] m_carDescriptions;
    private int[] m_playerCarLoadMasks;
    private int[] m_oppCarLoadMasks;
    private short[] m_cpuCarAnimIDs;
    private short[] m_cpuCarOncomingAnimIDs;
    private short[] m_carSelectAnimIDs;
    private short[] m_carSelectImageIDs;
    private short[][] m_carAngleAnimIDs;
    private short[][] m_carBrakelightAngleAnimIDs;
    private short[] m_carSpinoutLeftAnimIDs;
    private short[] m_carSpinoutRightAnimIDs;
    private int[] m_carPrices;
    private int[] m_carUpgradeScales;
    private int[] m_carFlags;
    private int[][] m_carBoundingRects;
    private int[] m_carWidths;
    private int[] m_carLengths;
    private int[] m_carParamTyres;
    private int[] m_carParamSteeringInc;
    private int[] m_carParamSteeringRecentreInc;
    private int[] m_carParamSteeringMax;
    private int[] m_carBountyUnlockValue;
    private short[] m_carUnlockingEvent;
    private byte[] m_carNumGears;
    private int[][] m_carGearAccels;
    private int[][] m_carGearMaxSpeeds;
    private int[][] m_carGearMinSpeeds;
    private short[] m_objectCarTypes;
    private short[] m_objectFlags;
    private short[] m_objectCosts;
    private int[] m_objectWeights;
    private int m_playerCarIndex;
    public boolean m_isPlayerCop;
    private byte m_numEvents;
    private byte[] d_eventTier;
    private byte[] d_eventStage;
    private byte[] d_eventStarsNeeded;
    private byte[] d_eventTypes;
    private byte[] d_eventTrackIDs;
    private short[] d_eventEnvironments;
    private byte[] d_eventTrackMirrored;
    private byte[] d_eventTrackReversed;
    private byte[] d_eventNightMode;
    private byte[] d_eventLaps;
    private int[] d_eventLenght;
    private int[] d_eventRewards1;
    private int[] d_eventRewards2;
    private int[] d_eventRewards3;
    private int[] d_eventPrice;
    private int[] d_eventDiffMinF;
    private int[] d_eventDiffMaxF;
    private int[] d_eventTrafficScaleF;
    private byte[] d_eventTrafficMax;
    private byte[] d_eventTrafficFlags;
    private byte[] d_eventCopPatrols;
    private byte[] d_eventCopTraps;
    private byte[] d_eventRoadblocksAvailable;
    private byte[] d_eventSpikesAvailable;
    private int[][] d_eventParamsF;
    private int[] d_eventPursiutHitRaise;
    private int[] d_eventPursiutRaiseSpeed;
    private int[] d_eventPatrolTime;
    private int[] d_eventNextLeft;
    private int[] d_eventNextRight;
    private int[] d_eventNextUp;
    private int[] d_eventNextDown;
    private int[] d_eventMapPosX;
    private int[] d_eventMapPosY;
    private int[] d_eventPlayerCar;
    private int[][] d_eventOpponents;
    private int[] d_allowedEventOpponents;
    private int[] d_eventUnlockingEventID1;
    private int[] d_eventUnlockingEventID2;
    private int[] d_eventBountyRequired;
    private static final int EVENT_PARAMS_SIZE = 3;
    public static final int EVENT_PARAM_THIRD_PLACE = 0;
    public static final int EVENT_PARAM_SECOND_PLACE = 1;
    public static final int EVENT_PARAM_FIRST_PLACE = 2;
    private static final int CUTSCENE_TYPE_COUNT = 5;
    public static final int STEP_ELEM_ANIM = 0;
    public static final int STEP_ELEM_STRING = 1;
    public static final int STEP_ELEM_COUNT = 2;
    private short[][][][] m_cutsceneSteps;
    public static final int MPH_TO_KPH_MULTIPLIER = 105447;
    public static final int RACE_TYPE_TUTORIAL = 1;
    public static final int RACE_TYPE_QUICK = 2;
    public static final int RACE_TYPE_CAREER = 3;
    private byte m_postTutorialState;
    private int m_rmsBounty;
    public static int dummyBounty;
    int total_bonusDeductions = 0;
    private int m_rmsEventsCompleted;
    private int m_rmsEventsUnlocked;
    public static final int TROPHY_GOLDEN_NACHO = 1;
    public static final int TROPHY_MEDALLIST = 2;
    public static final int TROPHY_CLOSE_ENCOUNTERS = 4;
    public static final int TROPHY_SPEED_FREAK = 8;
    public static final int TROPHY_SPEED_RACER = 16;
    public static final int TROPHY_MY_SWEET_16 = 32;
    public static final int TROPHY_THRIFT_NINJA = 64;
    public static final int TROPHY_CROSS_COUNTRY = 128;
    public static final int TROPHY_CAR_COLLECTOR = 256;
    public static final int TROPHY_CRUSHER = 512;
    public static final int TROPHY_CALL_OF_DUTY = 1024;
    public static final int TROPHY_THE_PRIZE = 2048;
    public static final int TROPHY_STREET_RACER = 4096;
    public static final int TROPHY_BIG_FIRST_CRASH = 8192;
    public static final int TROPHY_SAFE_DRIVER = 16384;
    public static final int TROPHY_NEED_FOR_SPEED = 32768;
    public static final int TROPHY_TRAINING_IS_THE_KEY = 65536;
    public static final int TROPHY_NITRO_MANIAC = 131072;
    public static final int TROPHY_KAMIKAZE = 262144;
    public static final int TROPHY_CADET = 524288;
    public static final int TROPHY_TEST_DRIVER = 0x100000;
    public static final int TROPHY_PRISONER = 0x200000;
    public static final int TROPHY_TOP_COP = 0x400000;
    public static final int TROPHY_THRASHER = 0x800000;
    public static final int TROPHY_DODGER = 0x1000000;
    public static final int TROPHY_IRON_WHEELS = 0x2000000;
    public static final int TROPHY_COP_TROPHIES = 4720128;
    public static final int TROPHY_TROPHIES_NUM = 23;
    public static final int TROPHY_NOT_AVIALABLE_TROPHIES = 0x3800000;
    private static final int TROPHY_DATA_TRAFFIC_CRUSH_NUM = 0;
    private static final int TROPHY_DATA_DESTROYED_OBJECTS_NUM = 1;
    private static final int TROPHY_DATA_MILES_DRIVEN = 2;
    private static final int TROPHY_DATA_VEHICLE_RAM_NUM = 3;
    private static final int TROPHY_DATA_TICKETS_ISSUED_NUM = 4;
    private static final int TROPHY_DATA_ROADBLOCKS_AVOIDED_NUM = 5;
    private static final int TROPHY_DATA_SPIKES_AVOIDED_NUM = 6;
    private static final int TROPHY_DATA_NOS_USED_NUM = 7;
    private static final int TROPHY_DATA_MILES_UPSTREAM = 8;
    private static final int TROPHY_DATA_VEHICLE_RACE_COMPLETED = 9;
    private static final int TROPHY_DATA_BUSTED_NUM = 10;
    private static final int TROPHY_DATA_NUM = 11;
    private int[] m_rmsTrophyData = new int[11];
    private int m_rmsTrophiesReached;
    private static final int TROPHY_DATA_TRAFFIC_CRUSH_MIN = 100;
    private static final int TROPHY_DATA_DESTROYED_OBJECTS_MIN = 500;
    private static final int TROPHY_DATA_MILES_DRIVEN_MIN = 0xC80000;
    private static final int TROPHY_DATA_VEHICLE_RAM_MIN = 50;
    private static final int TROPHY_DATA_TICKETS_ISSUED_MIN = 30;
    private static final int TROPHY_DATA_ROADBLOCKS_AVOIDED_MIN = 10;
    private static final int TROPHY_DATA_SPIKES_AVOIDED_MIN = 10;
    private static final int TROPHY_DATA_NOS_USED_MIN = 100;
    private static final int TROPHY_DATA_MILES_UPSTREAM_MIN = 0x640000;
    private static final int TROPHY_DATA_BUSTED_MIN = 10;
    private static final int TROPHY_DATA_WIN_BY_LESS_THAN = 250;
    private static final int TROPHY_DATA_TOP_SPEED_MIN = 250;
    private static final int TROPHY_NOTIFICATION_PERIOD = 3000;
    private static final int TROPHY_NOTIFICATION_QUEUE_SIZE = 5;
    private int[] m_trophyNotificationQueue = new int[5];
    private int m_trophyQueueFront;
    private int m_trophyQueueBack;
    private int m_trophyTimer;
    private boolean m_updateTrophies;
    private boolean[] d_unlockedEvents;
    private int[] d_lastUnlockedEvents = null;
    private boolean wasEventsUnlocked = false;
    private boolean wasLastEventUnlocked = false;
    private int unCompliteEvents = 0;
    private final SDKString m_unlockNotifyBuffer = new SDKString(256, 0);
    int m_driverProfileCountPrecision;
    int m_driverProfileCountAggression;
    int m_driverProfileCountRank;
    int m_driverProfileCountLosses;
    private int m_trophyTimeStep;
    private boolean m_drawTrophyPopup;
    private int m_trophyPopupName;
    private boolean m_showIntroductionFlow = true;
    private int m_raceMenuState;

    public boolean isEngineLoaded() {
        return this.m_gameDataLoaded;
    }

    public SDKString getTrophyName(int n) {
        return this.m_textManager.getString(TROPHY_NAMES[n]);
    }

    public SDKString getTrophyDescription(int n) {
        return this.m_textManager.getString(TROPHY_DESCRIPTIONS[n]);
    }

    public String getVersion() {
        return this.m_midlet.getAppProperty("MIDlet-Version");
    }

    public MoreGames getMoreGames() {
        return this.m_moreGames;
    }

    public boolean isMoreGamesAvailable() {
        return this.m_moreGames != null && this.m_moreGames.isAvailable();
    }

    private void initMoreGames() {
        if (this.m_moreGames != null) {
            return;
        }
        this.m_moreGames = new MoreGames(this.getScreenWidth(), this.getScreenHeight());
        Object[] objectArray = this.m_textManager.getFonts();
        Object[] objectArray2 = new Object[]{DummyTextManager.moreGamesFont, DummyTextManager.moreGamesFont, DummyTextManager.moreGamesFont, DummyTextManager.moreGamesFont, DummyTextManager.moreGamesFont};
        this.m_moreGames.setFonts(objectArray2);
        this.m_moreGames.setProductData(this.loadBlock("/moregames"));
        this.m_moreGames.setFonts(objectArray2);
        AppEngine.doGC();
    }

    private byte[] loadBlock(String string) {
        byte[] byArray = null;
        InputStream inputStream = null;
        byte[] byArray2 = new byte[10000];
        SDKString sDKString = new SDKString("");
        try {
            int n;
            inputStream = sDKString.getClass().getResourceAsStream(string);
            if (inputStream != null && (n = inputStream.read(byArray2)) != -1) {
                byArray = new byte[n];
                System.arraycopy(byArray2, 0, byArray, 0, n);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return byArray;
    }

    private void unloadMoreGames() {
        this.m_moreGamesActive = false;
        this.m_moreGames = null;
        AppEngine.doGC();
    }

    public void setMoreGamesActive(boolean bl) {
        boolean bl2 = this.m_moreGamesActive = bl && this.m_moreGames.isAvailable();
        if (bl) {
            this.unloadLayoutImages(2);
            AppEngine.doGC();
            this.loadImages(16L);
            this.m_moreGames.setScreenSize(this.getScreenWidth(), this.getScreenHeight());
            this.m_moreGames.reset("mnu");
        } else {
            this.unloadImages(16L, 0);
            AppEngine.doGC();
            this.loadLayoutImages(2);
        }
    }

    private boolean updateMoreGames() {
        if (this.m_moreGamesActive) {
            this.m_moreGames.update();
            if (this.m_moreGames.isActive()) {
                return true;
            }
            this.setMoreGamesActive(false);
        }
        return false;
    }

    private boolean renderMoreGames(Graphics graphics) {
        if (this.m_moreGamesActive) {
            this.m_moreGames.paint(graphics);
            s_paintScheduled = false;
            return true;
        }
        return false;
    }

    private boolean moreGamesKeyPressed(int n) {
        if (this.m_moreGamesActive) {
            if (n == -11) {
                return true;
            }
            if (n == -8) {
                return true;
            }
            this.m_moreGames.processKey(n);
            return true;
        }
        return false;
    }

    public ResourceManager getResourceManager() {
        return this.m_resourceManager;
    }

    public SDKSoundManager getSoundManager() {
        return this.m_soundManager;
    }

    public static int[] getTempIntArray() {
        return s_tempInt16;
    }

    public int getHalfWidth() {
        return this.getWidth() >> 1;
    }

    public int getHalfHeight() {
        return this.getHeight() >> 1;
    }

    public static void createAppEngine(MonkeyApp monkeyApp) {
        s_singletonAppEngine = new AppEngine(monkeyApp);
    }

    public static AppEngine getCanvas() {
        return s_singletonAppEngine;
    }

    public static final void DEBUG_MEMORY(String string) {
        System.out.println(++s_debugMemoryCount + ". " + string);
    }

    private AppEngine(MonkeyApp monkeyApp) {
        SDKSoundManager sDKSoundManager;
        this.KEY_BUFFER_LENGTH = 8;
        this.SOUND_STATE_OFF = 0;
        this.SOUND_STATE_MUSIC = 1;
        this.SOUND_STATE_SFX = 2;
        SDKUtils.setMidlet(monkeyApp);
        this.m_midlet = monkeyApp;
        this.m_gameRunning = false;
        this.m_keyBuffer = new int[8];
        m_keyBufferIndex = 0;
        this.m_runGarbageCollect = false;
        this.m_resourceManager = new ResourceManager();
        this.m_textManager = new DummyTextManager();
        this.m_soundManager = sDKSoundManager = SDKSoundManager.getManager();
        sDKSoundManager.setSoundEnabled(false);
        this.m_soundManager.setPlaybackType(0);
        sDKSoundManager.setLoader(this.m_resourceManager);
        this.m_musicID = -1;
        this.m_rmsGSLangIndex = -1;
        this.isSimultaneousSounds = false;
        this.m_randomInstance = new Random();
        this.m_gameDataLoaded = false;
        this.resetTrophies();
        int n = 0;
        while (IMAGE_IDS[n << 1] != -1L) {
            n = (short)(n + 1);
        }
        this.IMAGE_COUNT = (short)n;
        AnimationManager.loadColorsFile(this.m_resourceManager);
        this.loadAllSounds();
        if (!AnimationManager.loadSubimageFile(this.m_resourceManager)) {
            // empty if block
        }
        if (!AnimationManager.loadAnimFile(this.m_resourceManager)) {
            // empty if block
        }
        this.loadTrackData();
        this.loadSplineData();
        this.loadCarData();
        this.loadObjectData();
        this.loadTunershopData();
        this.loadEventData();
        this.loadRMSAppSettings();
        this.resetRMSGameData();
        this.loadRMSGameData();
        this.loadImages(1L);
        this.m_textManager.initWraps();
        AppEngine.DEBUG_MEMORY("init wraps");
        this.m_layoutManager2 = new LayoutManager2(new DataInputStream(this.m_resourceManager.loadBinaryFile(59)), this.m_textManager, this.m_resourceManager);
        this.loadLayoutImages(41);
        this.m_flowManager = new FlowManager(new DataInputStream(this.m_resourceManager.loadBinaryFile(47)), this.m_layoutManager2, this.m_textManager, -1);
    }

    public synchronized void start() {
        this.m_textManager.loadStringsAndFonts();
        AppEngine.DEBUG_MEMORY("loaded strings");
        int n = 1;
        if (SDKUtils.chooseLanguage(this.rmsGetLanguage()) == -1) {
            n = 0;
        }
        this.changeScene(0, n);
        this.initMoreGames();
        this.m_moreGames.setScreenSize(this.getScreenWidth(), this.getScreenHeight());
        SceneGame sceneGame = new SceneGame(this, this.m_textManager, this.m_flowManager, this.m_layoutManager2);
        sceneGame = null;
        AppEngine.doGC();
        this.m_paused = false;
        this.m_gameDataLoaded = true;
    }

    public void end() {
        this.m_gameRunning = false;
        if (this.m_currentScene != null) {
            this.m_currentScene.end();
        }
        this.saveRMSAppSettings();
        this.saveRMSGameData();
        this.requestGC(true);
        this.m_soundManager.stopSounds();
    }

    public void showNotify() {
        if (this.m_paused) {
            this.resumeGame();
            this.startThread();
        }
        AppEngine.doGC();
    }

    public void hideNotify() {
        this.pauseGame();
    }

    public void startSingleThread() {
        this.timeStartFrame = System.currentTimeMillis();
        this.m_gameRunning = true;
        this.m_gameThread = new Thread(){

            public void run() {
                if (AppEngine.this.m_gameRunning) {
                    if (!(AppEngine.this.m_paused || AppEngine.this.m_paused || s_paintScheduled)) {
                        s_paintScheduled = true;
                        long l = System.currentTimeMillis();
                        AppEngine.this.runLoop((int)(l - AppEngine.this.timeStartFrame));
                        AppEngine.this.timeStartFrame = l;
                        AppEngine.this.repaint();
                    }
                    try {
                        Thread.sleep(15L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (!AppEngine.this.m_gameRunning) {
                    AppEngine.this.m_midlet.quitApp(true);
                    return;
                }
                MonkeyApp.m_display.callSerially((Runnable)AppEngine.this.m_gameThread);
            }
        };
        this.m_gameThread.start();
    }

    public void startThread() {
        this.m_gameRunning = true;
        if (this.m_gameThread == null) {
            this.startSingleThread();
        }
    }

    public void runLoop(int n) {
        int n2 = this.updateKeyBuffer();
        if (n > 0) {
            this.update(n);
        }
        this.clearKeyBit(n2);
        if (this.m_runGarbageCollect) {
            AppEngine.doGC();
            this.m_runGarbageCollect = false;
        }
    }

    private int updateKeyBuffer() {
        int n;
        int n2;
        int[] nArray = this.m_keyBuffer;
        for (n2 = m_keyBufferIndex - 1; n2 >= 0; --n2) {
            if (nArray[n2] >= 0) continue;
            this.m_keysPressedDown &= ~(-nArray[n2]);
            if (-nArray[n2] != 131072 && -nArray[n2] != 262144 && -nArray[n2] != 524288) continue;
            this.m_commandPressedDown = 0;
        }
        n2 = 1;
        int n3 = 2;
        for (n = m_keyBufferIndex - 1; n >= 0; --n) {
            if (nArray[n] <= 0) continue;
            this.m_keysPressedDown |= nArray[n];
            if (nArray[n] == 262144) {
                if (this.m_flowManager.getCurrentState() == 45 || this.m_flowManager.getCurrentState() == 6) continue;
                this.m_commandPressedDown |= n3;
                continue;
            }
            if (nArray[n] != 131072 || this.m_flowManager.getCurrentState() == 45 || this.m_flowManager.getCurrentState() == 6) continue;
            this.m_commandPressedDown |= n2;
        }
        n = 0;
        for (int i = 1; i <= 18; ++i) {
            for (int j = 0; j < m_keyBufferIndex; ++j) {
                if (nArray[j] < 0) {
                    n |= -nArray[j];
                } else if (n == 1 << i && nArray[j] > 0) {
                    n &= ~nArray[j];
                }
                nArray[j] = 0;
            }
        }
        m_keyBufferIndex = 0;
        return n;
    }

    public void endGame() {
        this.m_soundManager.stopSounds();
        this.m_gameRunning = false;
    }

    public void pauseGame() {
        if (this.m_paused) {
            return;
        }
        this.clearCommandKeys();
        this.clearKeysPressedDown();
        if (this.m_currentScene != null) {
            this.m_currentScene.pause();
        }
        this.m_soundManager.stopSounds();
        this.m_paused = true;
    }

    public void resumeGame() {
        if (this.m_currentScene != null) {
            this.m_currentScene.resume();
        }
        this.clearCommandKeys();
        this.clearKeysPressedDown();
        m_keyBufferIndex = 0;
        this.m_paused = false;
    }

    public boolean isPaused() {
        return this.m_paused;
    }

    private final void update(int n) {
        this.m_timeSinceLastSoundStart += n;
        if (this.updateMoreGames()) {
            return;
        }
        if (n > 200) {
            n = 200;
        }
        if (s_nextScene != -1) {
            this.performChangeScene(s_nextScene, s_nextSceneState);
            s_nextScene = -1;
            s_nextSceneState = -1;
        }
        if (this.m_currentScene != null) {
            this.m_keyArgs[1] = this.m_keysPressedDown;
            this.m_keyArgs[0] = this.m_commandPressedDown;
            this.m_currentScene.processInput(0, this.m_keyArgs);
            try {
                this.m_currentScene.update(n);
            }
            catch (Throwable throwable) {
                AppEngine.debug("EXU: " + throwable.toString());
                throwable.printStackTrace();
            }
        }
        this.updateTrophies(n);
    }

    public int getScreenWidth() {
        return this.getWidth();
    }

    public int getScreenHeight() {
        return this.getHeight();
    }

    public final synchronized void paint(Graphics graphics) {
        if (this.renderMoreGames(graphics)) {
            return;
        }
        if (s_screenBuffer == null || s_screenBuffer.getWidth() != this.getWidth() || s_screenBuffer.getHeight() != this.getHeight()) {
            s_screenBuffer = Image.createImage((int)this.getWidth(), (int)this.getHeight());
            s_screenBufferG = s_screenBuffer.getGraphics();
        }
        Graphics graphics2 = s_screenBufferG;
        SDKUtils.setGraphics(graphics2);
        if (!this.m_gameDataLoaded) {
            AnimationManager.setColor(graphics2, 234);
            graphics2.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        if (this.m_currentScene != null && this.m_gameRunning) {
            try {
                if (this.m_renderBloomNextFrame) {
                    this.renderBackgroundDim(graphics2, true);
                    this.m_renderBloomNextFrame = false;
                }
                this.m_currentScene.render(graphics2);
                if (this.m_drawTrophyPopup) {
                    this.renderTrophyPopup(graphics2, this.m_trophyTimeStep);
                }
            }
            catch (Throwable throwable) {
                AppEngine.debug("EXR: " + throwable.toString());
                throwable.printStackTrace();
            }
        }
        graphics.drawImage(s_screenBuffer, 0, 0, 0);
        s_paintScheduled = false;
    }

    public void drawCrossLine(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        graphics.setColor(255, 0, 0);
        for (int i = n5; i < n5 * -1; ++i) {
            graphics.drawLine(n + i, n2 - i, n3 + i, n4 - i);
            graphics.drawLine(n + i, n4 + i, n3 + i, n2 + i);
        }
    }

    public static final void ASSERT(boolean bl, String string) {
    }

    public static final void ASSERT(boolean bl) {
    }

    private int translateKeyCode(int n) {
        switch (n) {
            case 49: {
                return 2;
            }
            case 50: {
                return 4;
            }
            case 51: {
                return 8;
            }
            case 52: {
                return 16;
            }
            case 53: {
                return 32;
            }
            case 54: {
                return 64;
            }
            case 55: {
                return 128;
            }
            case 56: {
                return 256;
            }
            case 57: {
                return 512;
            }
            case 48: {
                return 1;
            }
            case 35: {
                return 1024;
            }
            case 42: {
                return 2048;
            }
            case -6: {
                return 131072;
            }
            case -7: {
                return 262144;
            }
        }
        switch (this.getGameAction(n)) {
            case 8: {
                return 4096;
            }
            case 1: {
                return 8192;
            }
            case 6: {
                return 16384;
            }
            case 2: {
                return 32768;
            }
            case 5: {
                return 65536;
            }
        }
        return 0;
    }

    public void keyPressed(int n) {
        if (n == -10) {
            return;
        }
        if (this.noKeyPressStateKeyPressed()) {
            return;
        }
        if (this.moreGamesKeyPressed(n)) {
            return;
        }
        if (this.m_flowManager.isInTransition()) {
            return;
        }
        int n2 = this.translateKeyCode(n);
        if (n2 != 0 && m_keyBufferIndex < this.m_keyBuffer.length) {
            this.m_keyBuffer[AppEngine.m_keyBufferIndex++] = n2;
        }
    }

    public boolean noKeyPressStateKeyPressed() {
        int n = this.m_flowManager.getCurrentState();
        switch (n) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                return true;
            }
        }
        return false;
    }

    public void keyReleased(int n) {
        int n2 = this.translateKeyCode(n);
        if (n2 != 0 && m_keyBufferIndex < this.m_keyBuffer.length) {
            this.m_keyBuffer[AppEngine.m_keyBufferIndex++] = -n2;
        }
    }

    public void clearKeyBit(int n) {
        this.m_keysPressedDown &= ~n;
    }

    public void clearKeysPressedDown() {
        this.m_keysPressedDown = 0;
    }

    public void clearCommandKeys() {
        this.m_commandPressedDown = 0;
        this.clearKeyBit(524288);
    }

    public final void intToSDKString(int n, boolean bl, SDKString sDKString) {
        boolean bl2;
        SDKString sDKString2 = this.m_textManager.getString(3);
        boolean bl3 = bl2 = n < 0;
        if (bl2) {
            n = -n;
        }
        int n2 = 0;
        if (n == 0) {
            sDKString.setCharAt(0, '0');
            n2 = 1;
        } else {
            int n3 = -1;
            boolean bl4 = false;
            for (int i = 1000000000; i > 0; i /= 10) {
                n3 = n / i;
                if (n3 != 0 || bl4) {
                    if (bl2 && !bl4) {
                        sDKString.setCharAt(0, '-');
                        ++n2;
                    }
                    bl4 = true;
                    sDKString.setCharAt(n2, (char)(48 + n3));
                    ++n2;
                    if (bl && (i == 1000000000 || i == 1000000 || i == 1000)) {
                        sDKString.setLength(n2);
                        sDKString.append(sDKString2);
                        n2 = sDKString.length();
                    }
                }
                n -= n3 * i;
            }
        }
        sDKString.setLength(n2);
    }

    public final void timeToSDKString(int n, int n2, SDKString sDKString) {
        boolean bl = false;
        if (n < 0) {
            n = -n;
            bl = true;
        }
        int n3 = n / 1000;
        int n4 = n3 / 60;
        int n5 = n4 / 60;
        n %= 1000;
        n3 %= 60;
        n4 %= 60;
        n2 = n2 <= 3 ? n2 : 3;
        int n6 = 1000;
        for (int i = 0; i < n2; ++i) {
            n6 /= 10;
        }
        n /= n6;
        SDKString sDKString2 = this.m_textManager.clearStringBuffer();
        sDKString.setLength(0);
        if (bl) {
            sDKString.setCharAt(0, '-');
            sDKString.setLength(1);
        }
        if (n5 > 0) {
            this.intToSDKString(n5, false, sDKString2);
            if (sDKString2.length() == 1) {
                sDKString.setCharAt(sDKString.length(), '0');
                sDKString.setLength(sDKString.length() + 1);
            }
            sDKString.append(sDKString2);
            sDKString.setCharAt(sDKString.length(), ':');
            sDKString.setLength(sDKString.length() + 1);
        }
        this.intToSDKString(n4, false, sDKString2);
        if (sDKString2.length() == 1) {
            sDKString.setCharAt(sDKString.length(), '0');
            sDKString.setLength(sDKString.length() + 1);
        }
        sDKString.append(sDKString2);
        sDKString.append(this.m_textManager.getString(2));
        this.intToSDKString(n3, false, sDKString2);
        if (sDKString2.length() == 1) {
            sDKString.setCharAt(sDKString.length(), '0');
            sDKString.setLength(sDKString.length() + 1);
        }
        sDKString.append(sDKString2);
        if (n2 > 0) {
            this.intToSDKString(n, false, sDKString2);
            sDKString.append(this.m_textManager.getString(4));
            int n7 = sDKString2.length();
            if (n7 < n2) {
                int n8 = 0;
                while (n8 + n7 < n2) {
                    sDKString.setCharAt(sDKString.length() + n8, '0');
                    ++n8;
                }
                sDKString.setLength(sDKString.length() + n8);
            }
            sDKString.append(sDKString2);
        }
    }

    public void appendTimeToBuffer(int n, SDKString sDKString) {
        if (n == -1) {
            this.m_textManager.appendStringIdToBuffer(6);
        } else {
            this.timeToSDKString(n, 1, sDKString);
        }
    }

    public final int eventParamTimeToMilliseconds(int n) {
        return (n >> 16) * 1000;
    }

    public final void moneyToSDKString(int n, SDKString sDKString) {
        boolean bl;
        this.intToSDKString(n, true, sDKString);
        boolean bl2 = bl = n < 0;
        if (bl) {
            int n2 = sDKString.length();
            for (int i = 0; i < n2 - 1; ++i) {
                sDKString.setCharAt(i, sDKString.charAt(i + 1));
            }
            sDKString.setLength(n2 - 1);
        }
        SDKString sDKString2 = this.m_textManager.getString(5).replaceFirst(sDKString);
        sDKString.setLength(0);
        if (bl) {
            sDKString.setCharAt(0, '-');
            sDKString.setLength(1);
        }
        sDKString.append(sDKString2);
    }

    public static void starsToSDKString(byte by, SDKString sDKString) {
        AppEngine.starsRankToSDKString(by, sDKString);
        AppEngine.starsStyleToSDKString(by, sDKString);
    }

    public static void starsRankToSDKString(byte by, SDKString sDKString) {
        for (int i = 1; i < 8; i <<= 1) {
            if ((i & by) != 0) {
                sDKString.append(GLYPH_STAR_RANK_TRUE);
                continue;
            }
            sDKString.append(GLYPH_STAR_RANK_FALSE);
        }
    }

    public static void starsStyleToSDKString(byte by, SDKString sDKString) {
        for (int i = 8; i < 32; i <<= 1) {
            if ((i & by) != 0) {
                sDKString.append(GLYPH_STAR_STYLE_TRUE);
                continue;
            }
            sDKString.append(GLYPH_STAR_STYLE_FALSE);
        }
    }

    public static SDKString getMedalString(byte by) {
        if (((by = (byte)(by & 7)) & 4) != 0) {
            return GLYPH_MEDAL_GOLD;
        }
        if ((by & 2) != 0) {
            return GLYPH_MEDAL_SILVER;
        }
        if ((by & 1) != 0) {
            return GLYPH_MEDAL_BRONZE;
        }
        return GLYPH_MEDAL_NONE;
    }

    public final void upgradeProgressToSDKString(int n, int n2, boolean bl, SDKString sDKString) {
        int n3;
        AppEngine.ASSERT(n >= 0 && n <= n2, "Invalid progress count");
        sDKString.setLength(0);
        for (n3 = 0; n3 < n; ++n3) {
            sDKString.append(this.GLYPH_PROGRESS_HIGHLIGHT);
        }
        if (bl && n < n2) {
            sDKString.append(this.GLYPH_PROGRESS_TRUE);
            ++n;
        }
        for (n3 = n; n3 < n2; ++n3) {
            sDKString.append(this.GLYPH_PROGRESS_FALSE);
        }
    }

    public void resetScrollers() {
        for (int i = 0; i < s_scrollerStringId.length; ++i) {
            AppEngine.s_scrollerStringId[i] = -1;
            AppEngine.s_scrollerStringArray[i] = null;
        }
    }

    private void setupScroller(int n, int n2, int n3) {
        if (n < s_scrollerStringId.length) {
            AppEngine.s_scrollerTime[n] = 0L;
            AppEngine.s_scrollerStringId[n] = n3;
            AppEngine.s_scrollerStringArray[n] = null;
            if (s_scrollerStringId[n] != -1) {
                AppEngine.s_scrollerStringWidth[n] = this.m_textManager.getStringWidth(n3, n2);
                AppEngine.s_scrollerOffset[n] = 0;
            }
        }
    }

    private void setupScroller(int n, int n2, SDKString sDKString) {
        if (n < s_scrollerStringId.length) {
            AppEngine.s_scrollerTime[n] = 0L;
            AppEngine.s_scrollerStringId[n] = -1;
            AppEngine.s_scrollerStringArray[n] = sDKString;
            if (s_scrollerStringId[n] != -1) {
                AppEngine.s_scrollerStringWidth[n] = this.m_textManager.getStringWidth(sDKString, n2);
                AppEngine.s_scrollerOffset[n] = 0;
            }
        }
    }

    public void updateScrollers(long l) {
        for (int i = 0; i < s_scrollerStringId.length; ++i) {
            if (s_scrollerStringId[i] == -1 && s_scrollerStringArray[i] == null) continue;
            int n = i;
            s_scrollerTime[n] = s_scrollerTime[n] + l;
            if (s_scrollerTime[i] <= 1500L) continue;
            long l2 = s_scrollerTime[i] - 1500L;
            AppEngine.s_scrollerOffset[i] = (int)(l2 * 20L >> 10);
            int n2 = s_scrollerStringWidth[i] + 20;
            if (s_scrollerOffset[i] < n2) continue;
            int n3 = i;
            s_scrollerOffset[n3] = s_scrollerOffset[n3] - n2;
            int n4 = i;
            s_scrollerTime[n4] = s_scrollerTime[n4] - (long)((n2 << 10) / 20);
        }
    }

    public void renderScroller(int n, Graphics graphics, int n2, int n3, int n4, int n5, int n6, int n7) {
        if (n >= s_scrollerStringId.length) {
            return;
        }
        TextManager textManager = this.m_textManager;
        if (s_scrollerStringId[n] != n2) {
            this.setupScroller(n, n3, n2);
        }
        if (s_scrollerStringWidth[n] <= n6) {
            textManager.drawString(n2, n3, n4, n5, n7);
        } else {
            int n8 = graphics.getClipX();
            int n9 = graphics.getClipY();
            int n10 = graphics.getClipWidth();
            int n11 = graphics.getClipHeight();
            int n12 = n4;
            if ((n7 & 1) != 0) {
                n12 = n4 - (n6 >> 1);
            } else if ((n7 & 8) != 0) {
                n12 = n4 - n6;
            }
            graphics.setClip(n12, n9, n6, n11);
            textManager.drawString(s_scrollerStringId[n], n3, n4 - s_scrollerOffset[n], n5, n7);
            textManager.drawString(s_scrollerStringId[n], n3, n4 - s_scrollerOffset[n] + s_scrollerStringWidth[n] + 20, n5, n7);
            graphics.setClip(n8, n9, n10, n11);
        }
    }

    public void renderBackgroundDim(Graphics graphics, boolean bl) {
        int n = 0;
        n = !bl ? this.getHeight() - 40 : this.getHeight();
        if (this.m_currentScene instanceof SceneMenu) {
            this.m_layoutManager2.drawLayout(graphics, 41, 0, 0, this.getWidth(), n, 0);
        } else {
            this.m_layoutManager2.drawLayout(graphics, 43, 0, 0, this.getWidth(), n, 0);
        }
    }

    public void renderFade(Graphics graphics, int n) {
        int n2 = n | n << 8 | n << 16;
    }

    public void renderFade(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
    }

    public void renderBloomNextFrame() {
        this.m_renderBloomNextFrame = true;
    }

    public static final void doGC() {
        System.gc();
        Thread.yield();
        try {
            Thread.sleep(15L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void requestGC(boolean bl) {
        if (bl) {
            AppEngine.doGC();
            this.m_runGarbageCollect = false;
        } else {
            this.m_runGarbageCollect = true;
        }
    }

    public Scene getScene() {
        return this.m_currentScene;
    }

    public SceneGame getSceneGame() {
        return this.m_currentScene instanceof SceneGame ? (SceneGame)this.m_currentScene : null;
    }

    public SceneMenu getSceneMenu() {
        return this.m_currentScene instanceof SceneMenu ? (SceneMenu)this.m_currentScene : null;
    }

    public void changeScene(int n, int n2) {
        s_nextScene = n;
        s_nextSceneState = n2;
    }

    private void performChangeScene(int n, int n2) {
        try {
            if (this.m_currentScene != null) {
                this.unloadLayoutImages(14);
                this.unloadMoreGames();
                this.m_postEffectsTexture = null;
                this.m_currentScene.end();
                this.m_currentScene = null;
                this.m_layoutManager2.setScene(null);
                this.m_flowManager.clearScene();
            }
            this.requestGC(true);
            switch (n) {
                case 0: {
                    this.m_currentRaceEventIndex = (byte)this.selectedEvent;
                    this.m_currentScene = new SceneMenu(this, this.m_textManager, this.m_flowManager, this.m_layoutManager2);
                    this.m_flowManager.setCompositingEnabled(true);
                    this.initMoreGames();
                    break;
                }
                case 1: {
                    this.m_currentScene = new SceneGame(this, this.m_textManager, this.m_flowManager, this.m_layoutManager2);
                    this.m_flowManager.setCompositingEnabled(false);
                    break;
                }
            }
            this.m_layoutManager2.setScene(this.m_currentScene);
            this.m_flowManager.setScene(this.m_currentScene, n2);
            this.m_currentScene.start(n2);
        }
        catch (Throwable throwable) {
            AppEngine.debug("EXES: " + throwable.toString());
            throwable.printStackTrace();
        }
        this.clearKeysPressedDown();
        this.clearCommandKeys();
        this.repaint();
    }

    public int rand(int n, int n2) {
        int n3 = n2 + 1 - n;
        return n + this.m_randomInstance.nextInt(n3);
    }

    public int randPercent() {
        return this.rand(0, 99);
    }

    public void vibrate(int n) {
        if (s_rmsVibrationEnabled) {
            this.m_soundManager.vibrate(n);
        }
    }

    public boolean isVibrationEnabled() {
        return s_rmsVibrationEnabled;
    }

    public void setVibrationEnabled(boolean bl) {
        s_rmsVibrationEnabled = bl;
        if (bl) {
            this.vibrate(250);
        }
        this.saveRMSAppSettings();
    }

    public final void setVibrationEnabledWithoutConfirmation(boolean bl) {
        s_rmsVibrationEnabled = bl;
        this.saveRMSAppSettings();
    }

    public static void debug(String string) {
    }

    public static void timerBegin() {
    }

    public static void timerEnd(String string) {
    }

    public static void timerEnd(String string, int n) {
    }

    private final void DEBUG_CHEATS(String string) {
    }

    public boolean cheatUsed(int n) {
        return this.m_cheatUsed[n];
    }

    public void cheatUnset(int n) {
        this.m_cheatUsed[n] = false;
    }

    private void processKeysCheats(int n) {
        for (int n2 = 0; n2 < CHEAT_CODES.length; n2 = (int)((byte)(n2 + 1))) {
            int[] nArray = CHEAT_CODES[n2];
            int n3 = nArray.length - 1;
            int n4 = nArray[0];
            int n5 = nArray[n4 + 1];
            if (n5 == n) {
                if (++n4 == n3) {
                    boolean bl = false;
                    n4 = 0;
                    nArray[0] = 0;
                    switch (n2) {
                        case 0: 
                        case 1: 
                        case 2: {
                            if (!(this.m_currentScene instanceof SceneMenu)) break;
                            if (n2 == 0) {
                                this.DEBUG_CHEATS("cheat activated - unlock all events");
                                bl = true;
                                break;
                            }
                            if (n2 == 1) {
                                this.DEBUG_CHEATS("cheat activated - extra career ca$h");
                                bl = true;
                                this.increaseBounty(1000000);
                                this.awardCareerPrizeMoney(1000000);
                                break;
                            }
                            if (n2 != 2) break;
                            this.DEBUG_CHEATS("cheat activated - all career cars");
                            bl = true;
                            break;
                        }
                        case 4: 
                        case 5: {
                            if (!(this.m_currentScene instanceof SceneGame)) break;
                            if (n2 == 4) {
                                this.DEBUG_CHEATS("cheat activated - instant win race");
                                bl = true;
                                break;
                            }
                            if (n2 != 5) break;
                            this.DEBUG_CHEATS("cheat activated - instant lose race");
                            bl = true;
                            break;
                        }
                        case 3: {
                            int n6 = this.getFirstUncompletedEvent();
                            if (n6 == -1) break;
                            this.completeEvent(n6);
                            this.rmsSetEventAwards(n6, (byte)7);
                        }
                    }
                    if (!bl) continue;
                    this.m_cheatUsed[n2] = true;
                    this.vibrate(250);
                    continue;
                }
                nArray[0] = n4;
                continue;
            }
            nArray[0] = 0;
        }
    }

    public boolean isSoundEnabled() {
        return s_rmsSoundEnabled;
    }

    public void setSoundVolume(int n) {
        AppEngine.debug("setSoundVolume " + n);
        if (n < 0) {
            return;
        }
        soundVolume = n;
        this.m_soundManager.setSoundVolume(soundVolume);
    }

    public int getSoundVolume() {
        return soundVolume;
    }

    public void switchSoundState(boolean bl) {
        int n = bl ? 1 : -1;
        this.soundState += n;
        if (this.soundState < 0) {
            this.soundState += 2;
        }
        this.soundState %= 2;
        switch (this.soundState) {
            case 0: {
                this.setSoundStateOff();
                break;
            }
            case 1: {
                this.setSoundStateMusic();
                break;
            }
            case 2: {
                this.setSoundStateSFX();
            }
        }
    }

    private void setSoundStateOff() {
        s_rmsSoundEnabled = false;
        this.m_soundManager.setSoundEnabled(s_rmsSoundEnabled);
        this.isSFX = false;
        this.isMusicPlaying = false;
        this.soundState = 0;
        this.saveRMSAppSettings();
    }

    private void setSoundStateMusic() {
        s_rmsSoundEnabled = true;
        this.m_soundManager.setSoundEnabled(s_rmsSoundEnabled);
        if (this.m_musicID == -1) {
            this.isSFX = true;
            this.playSound(4, true);
            this.isSFX = false;
        } else {
            this.isSFX = false;
            this.isMusicPlaying = false;
            this.startMusic(this.m_musicID);
        }
        this.soundState = 1;
        this.saveRMSAppSettings();
    }

    private void setSoundStateSFX() {
    }

    public void setSoundEnabled(boolean bl) {
        s_rmsSoundEnabled = bl;
        this.m_soundManager.setSoundEnabled(bl);
        if (bl) {
            if (this.m_musicID != -1) {
                this.startMusic(this.m_musicID);
            } else {
                boolean bl2 = this.isSFX;
                this.isSFX = true;
                this.playSound(4, true);
                this.isSFX = bl2;
            }
        }
        this.isMusicPlaying = bl;
        this.saveRMSAppSettings();
    }

    public final void loadAllSounds() {
    }

    public final void loadSound(int n) {
        if (SoundEventConstants.SOUND_DATA_SETS[n] != -1) {
            this.m_soundManager.loadSound(n);
        }
    }

    public final void unloadSound(int n) {
        if (SoundEventConstants.SOUND_DATA_SETS[n] != -1) {
            this.m_soundManager.unloadSound(n);
        }
    }

    public final void playSound(int n) {
        this.playSound(n, false);
    }

    public final void playSound(int n, boolean bl) {
        if (SoundEventConstants.SOUND_DATA_SETS.length > n && SoundEventConstants.SOUND_DATA_SETS[n] >= 0 && (!this.isSimultaneousSounds && this.isSFX || this.isSimultaneousSounds && s_rmsSoundEnabled)) {
            AppEngine.doGC();
            this.m_soundManager.setCurrentLoop(1);
            if (!this.isSimultaneousSounds) {
                this.m_soundManager.setPlaybackType(bl ? 0 : 1);
            }
            this.m_soundManager.playSound(n);
            this.m_timeSinceLastSoundStart = 0;
        }
    }

    public void startMusic(int n) {
        this.m_musicID = n;
        if (this.isMusicPlaying && n == this.m_musicID || !this.isSimultaneousSounds && this.isSFX) {
            return;
        }
        if (this.m_musicID != n && this.m_musicID != -1) {
            this.m_soundManager.stopSound(this.m_musicID);
        }
        if (n == -1) {
            this.m_soundManager.setCurrentLoop(1);
        } else if (SoundEventConstants.SOUND_DATA_SETS.length <= n || SoundEventConstants.SOUND_DATA_SETS[n] >= 0 && s_rmsSoundEnabled) {
            AppEngine.doGC();
            this.m_soundManager.setCurrentLoop(-1);
            this.m_soundManager.setPlaybackType(0);
            this.m_soundManager.playSound(n);
            this.isMusicPlaying = true;
        }
    }

    public final void stopMusic() {
        this.stopMusic(false);
    }

    public final void stopMusic(boolean bl) {
        if (!bl && !this.isMusicPlaying) {
            return;
        }
        this.isMusicPlaying = false;
        this.DEBUG_SOUND("stopMusic()");
        if (this.m_musicID != -1) {
            this.m_soundManager.stopSound(this.m_musicID);
            this.m_musicID = -1;
            AppEngine.doGC();
        }
    }

    private void DEBUG_SOUND(String string) {
    }

    private void loadImages(long l) {
        ResourceManager resourceManager = this.getResourceManager();
        int n = 0;
        while (IMAGE_IDS[n << 1] != -1L) {
            if ((IMAGE_IDS[(n << 1) + 1] & l) != 0L) {
                int n2 = (int)IMAGE_IDS[n << 1];
                boolean bl = AnimationManager.loadImage(resourceManager, n2);
                while (!bl) {
                    try {
                        Thread.sleep(16L);
                        System.gc();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    bl = AnimationManager.loadImage(resourceManager, n2);
                }
            }
            ++n;
        }
    }

    public void unloadImages(long l, int n) {
        int n2 = 0;
        int n3 = 0;
        while (IMAGE_IDS[n3 << 1] != -1L) {
            if ((IMAGE_IDS[(n3 << 1) + 1] & l) != 0L) {
                n2 += AnimationManager.unloadImage((int)IMAGE_IDS[n3 << 1], n) ? 1 : 0;
            }
            ++n3;
        }
    }

    public void loadLayoutImages(int n) {
        AppEngine.doGC();
        int n2 = 0;
        while (LAYOUT_IMAGE_IDS[n2] != -1) {
            if ((LAYOUT_IMAGE_IDS[n2 + 1] & n) != 0) {
                AppEngine.doGC();
                this.m_layoutManager2.loadImage(LAYOUT_IMAGE_IDS[n2]);
            }
            n2 += 2;
        }
    }

    public void unloadLayoutImages(int n) {
        int n2 = 0;
        while (LAYOUT_IMAGE_IDS[n2] != -1) {
            if ((LAYOUT_IMAGE_IDS[n2 + 1] & n) != 0) {
                this.m_layoutManager2.unloadImage(LAYOUT_IMAGE_IDS[n2]);
            }
            n2 += 2;
        }
        AppEngine.doGC();
    }

    public static final void fillArray(boolean[] blArray, boolean bl) {
        for (int i = 0; i < blArray.length; ++i) {
            blArray[i] = bl;
        }
    }

    public static final void fillArray(char[] cArray, char c) {
        for (int i = 0; i < cArray.length; ++i) {
            cArray[i] = c;
        }
    }

    public static final void fillArray(byte[] byArray, int n) {
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = (byte)n;
        }
    }

    public static final void fillArray(short[] sArray, int n) {
        for (int i = 0; i < sArray.length; ++i) {
            sArray[i] = (short)n;
        }
    }

    public static final void fillArray(int[] nArray, int n) {
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = n;
        }
    }

    public static final void fillArray(int[][] nArray, int n) {
        for (int i = 0; i < nArray.length; ++i) {
            AppEngine.fillArray(nArray[i], n);
        }
    }

    public static final void fillArray(short[][] sArray, int n) {
        for (int i = 0; i < sArray.length; ++i) {
            AppEngine.fillArray(sArray[i], n);
        }
    }

    public static final int indexOf(int n, int[] nArray) {
        return AppEngine.indexOf(n, nArray, 0);
    }

    public static final int indexOf(int n, short[] sArray) {
        return AppEngine.indexOf(n, sArray, 0);
    }

    public static final int indexOf(int n, byte[] byArray) {
        return AppEngine.indexOf(n, byArray, 0);
    }

    public static final int indexOf(int n, int[] nArray, int n2) {
        for (int i = n2; i < nArray.length; ++i) {
            if (nArray[i] != n) continue;
            return i;
        }
        return -1;
    }

    public static final int indexOf(int n, short[] sArray, int n2) {
        for (int i = n2; i < sArray.length; ++i) {
            if (sArray[i] != n) continue;
            return i;
        }
        return -1;
    }

    public static final int indexOf(int n, byte[] byArray, int n2) {
        for (int i = n2; i < byArray.length; ++i) {
            if (byArray[i] != n) continue;
            return i;
        }
        return -1;
    }

    public static final int countOf(int n, int[] nArray) {
        int n2 = 0;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] != n) continue;
            ++n2;
        }
        return n2;
    }

    public static final int countOf(int n, short[] sArray) {
        int n2 = 0;
        for (int i = 0; i < sArray.length; ++i) {
            if (sArray[i] != n) continue;
            ++n2;
        }
        return n2;
    }

    public static final int countOf(int n, byte[] byArray) {
        int n2 = 0;
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] != n) continue;
            ++n2;
        }
        return n2;
    }

    public static final int[] copyArray(int[] nArray) {
        if (nArray == null) {
            return null;
        }
        int[] nArray2 = new int[nArray.length];
        System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
        return nArray2;
    }

    public void setTutorialCompleted(boolean bl) {
        s_rmsTutorialCompleted = bl;
    }

    public boolean getTutorialCompleted() {
        return s_rmsTutorialCompleted;
    }

    private void resetRMSAppSettings() {
        s_rmsSoundEnabled = false;
        s_rmsVibrationEnabled = true;
        s_rmsCarMarkersEnabled = true;
        s_rmsSpeedunitsMPH = true;
        s_rmsNumTimesCallToActionShown = 0;
        this.m_rmsGSLangIndex = -1;
    }

    public void resetRMSGameDataExceptCars() {
        byte[] byArray = s_rmsCarsOwned;
        byte[] byArray2 = s_carsNotOwned;
        byte by = s_careerNumCarsOwned;
        s_rmsCarsOwned = null;
        s_carsNotOwned = null;
        this.resetRMSGameData();
        s_rmsCarsOwned = byArray;
        s_carsNotOwned = byArray2;
        s_careerNumCarsOwned = by;
    }

    public void resetRMSGameData() {
        int n;
        int n2 = this.getNumCars();
        if (this.m_cheatUsed == null) {
            this.m_cheatUsed = new boolean[6];
        }
        for (n = 0; n < 6; n = (int)((byte)(n + 1))) {
            this.m_cheatUsed[n] = false;
        }
        s_rmsGameExists = false;
        s_rmsWelcomeDisplayed = 0;
        s_rmsCareerActiveCar = 0;
        s_rmsCareerMoney = this.getCarPrice(0) + this.getUpgradePrice(0, 3, 1) + 5000;
        if (s_rmsTrackBestLapTimes == null) {
            s_rmsTrackBestLapTimes = new int[this.m_numEvents];
        }
        AppEngine.fillArray(s_rmsTrackBestLapTimes, 0);
        if (s_rmsTrackBestRaceTimes == null) {
            s_rmsTrackBestRaceTimes = new int[this.m_numEvents];
        }
        AppEngine.fillArray(s_rmsTrackBestRaceTimes, 0);
        if (s_rmsTrackRanks == null) {
            s_rmsTrackRanks = new byte[this.m_numEvents];
        }
        AppEngine.fillArray(s_rmsTrackRanks, 0);
        if (s_rmsTrackSpeedcameraTotal == null) {
            s_rmsTrackSpeedcameraTotal = new int[this.m_numEvents];
        }
        AppEngine.fillArray(s_rmsTrackSpeedcameraTotal, 0);
        if (s_rmsTrackPatrolTickets == null) {
            s_rmsTrackPatrolTickets = new int[this.m_numEvents];
        }
        AppEngine.fillArray(s_rmsTrackPatrolTickets, 0);
        this.m_rmsEventsCompleted = 0;
        this.m_rmsEventsUnlocked = 1;
        this.m_rmsBounty = 45000;
        if (s_rmsEventAwards == null) {
            s_rmsEventAwards = new byte[this.getEventCount()];
        }
        AppEngine.fillArray(s_rmsEventAwards, 0);
        if (s_rmsPersonalityHistory == null) {
            s_rmsPersonalityHistory = new int[5];
        }
        AppEngine.fillArray(s_rmsPersonalityHistory, 0);
        if (s_rmsRankHistory == null) {
            s_rmsRankHistory = new byte[5];
        }
        AppEngine.fillArray(s_rmsRankHistory, 0);
        s_rmsProfileTotal = 0;
        if (s_rmsCarsOwned == null) {
            s_rmsCarsOwned = new byte[n2];
        }
        if (s_carsNotOwned == null) {
            s_carsNotOwned = new byte[n2];
        }
        for (n = 0; n < n2; n = (int)((byte)(n + 1))) {
            AppEngine.s_rmsCarsOwned[n] = -1;
            AppEngine.s_carsNotOwned[n] = n;
        }
        s_careerNumCarsOwned = 0;
        if (s_rmsAccessoryLevel == null) {
            s_rmsAccessoryLevel = new byte[n2][4];
        }
        for (n = 0; n < n2; ++n) {
            AppEngine.fillArray(s_rmsAccessoryLevel[n], 0);
        }
        s_rmsTutorialCompleted = false;
        this.updateDriverProfile();
        this.initUnlockNotification();
        this.resetTrophies();
        this.unlockCareerCar((byte)0);
        this.lastCarsUnlockedAmount = 0;
        this.selectedEvent = 0;
    }

    private void loadRMSAppSettings() {
        this.DEBUG_RMS("loadGameData");
        RecordStore recordStore = null;
        ByteArrayInputStream byteArrayInputStream = null;
        FilterInputStream filterInputStream = null;
        try {
            recordStore = RecordStore.openRecordStore((String)RMS_SETTINGS, (boolean)false);
            byte[] byArray = recordStore.getRecord(1);
            byteArrayInputStream = new ByteArrayInputStream(byArray);
            filterInputStream = new DataInputStream(byteArrayInputStream);
            int n = ((DataInputStream)filterInputStream).readInt();
            if (n == 173) {
                s_rmsSoundEnabled = ((DataInputStream)filterInputStream).readBoolean();
                s_rmsSoundEnabled = false;
                s_rmsVibrationEnabled = ((DataInputStream)filterInputStream).readBoolean();
                s_rmsCarMarkersEnabled = ((DataInputStream)filterInputStream).readBoolean();
                s_rmsSpeedunitsMPH = ((DataInputStream)filterInputStream).readBoolean();
                s_rmsNumTimesCallToActionShown = ((DataInputStream)filterInputStream).readByte();
                this.m_rmsGSLangIndex = ((DataInputStream)filterInputStream).readByte();
            } else {
                this.resetRMSAppSettings();
                this.saveRMSAppSettings();
            }
        }
        catch (RecordStoreNotFoundException recordStoreNotFoundException) {
            this.DEBUG_RMS("game settings recordstore not found");
            this.resetRMSAppSettings();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            filterInputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            byteArrayInputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (recordStore != null) {
            try {
                recordStore.closeRecordStore();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void loadRMSGameData() {
        this.DEBUG_RMS("loadGameData");
        RecordStore recordStore = null;
        ByteArrayInputStream byteArrayInputStream = null;
        FilterInputStream filterInputStream = null;
        try {
            recordStore = RecordStore.openRecordStore((String)RMS_DATA, (boolean)false);
            byte[] byArray = recordStore.getRecord(1);
            if (!SceneMenu.checkRMS(byArray)) {
                byArray = null;
            }
            byteArrayInputStream = new ByteArrayInputStream(byArray);
            filterInputStream = new DataInputStream(byteArrayInputStream);
            int n = ((DataInputStream)filterInputStream).readInt();
            byte by = ((DataInputStream)filterInputStream).readByte();
            if (n == 173 && by == this.m_numEvents) {
                int n2;
                s_rmsGameExists = ((DataInputStream)filterInputStream).readBoolean();
                s_rmsWelcomeDisplayed = ((DataInputStream)filterInputStream).readByte();
                s_rmsTutorialCompleted = ((DataInputStream)filterInputStream).readBoolean();
                s_rmsCareerActiveCar = ((DataInputStream)filterInputStream).readByte();
                int n3 = this.getNumCars();
                s_careerNumCarsOwned = 0;
                for (n2 = 0; n2 < n3; n2 = (int)((byte)(n2 + 1))) {
                    AppEngine.s_rmsCarsOwned[n2] = ((DataInputStream)filterInputStream).readByte();
                    if (s_rmsCarsOwned[n2] == -1) continue;
                    s_careerNumCarsOwned = (byte)(s_careerNumCarsOwned + 1);
                    this.removeCarFromList(s_carsNotOwned, s_rmsCarsOwned[n2]);
                }
                s_rmsCareerMoney = ((DataInputStream)filterInputStream).readInt();
                for (n2 = 0; n2 < n3; ++n2) {
                    for (int i = 0; i < 4; ++i) {
                        AppEngine.s_rmsAccessoryLevel[n2][i] = ((DataInputStream)filterInputStream).readByte();
                    }
                }
                this.m_rmsEventsCompleted = ((DataInputStream)filterInputStream).readInt();
                this.m_rmsEventsUnlocked = ((DataInputStream)filterInputStream).readInt();
                for (n2 = 0; n2 < this.m_numEvents; ++n2) {
                    AppEngine.s_rmsEventAwards[n2] = ((DataInputStream)filterInputStream).readByte();
                }
                for (n2 = 0; n2 < 5; ++n2) {
                    AppEngine.s_rmsPersonalityHistory[n2] = ((DataInputStream)filterInputStream).readInt();
                }
                for (n2 = 0; n2 < 5; ++n2) {
                    AppEngine.s_rmsRankHistory[n2] = ((DataInputStream)filterInputStream).readByte();
                }
                s_rmsProfileTotal = ((DataInputStream)filterInputStream).readInt();
                for (n2 = 0; n2 < this.m_numEvents; ++n2) {
                    AppEngine.s_rmsTrackBestLapTimes[n2] = ((DataInputStream)filterInputStream).readInt();
                    AppEngine.s_rmsTrackBestRaceTimes[n2] = ((DataInputStream)filterInputStream).readInt();
                    AppEngine.s_rmsTrackRanks[n2] = ((DataInputStream)filterInputStream).readByte();
                    AppEngine.s_rmsTrackSpeedcameraTotal[n2] = ((DataInputStream)filterInputStream).readInt();
                    AppEngine.s_rmsTrackPatrolTickets[n2] = ((DataInputStream)filterInputStream).readInt();
                }
                this.m_rmsBounty = ((DataInputStream)filterInputStream).readInt();
                this.m_rmsTrophiesReached = ((DataInputStream)filterInputStream).readInt();
                for (n2 = 0; n2 < 11; ++n2) {
                    this.m_rmsTrophyData[n2] = ((DataInputStream)filterInputStream).readInt();
                }
                this.updateDriverProfile();
                this.initUnlockNotification();
            } else {
                this.resetRMSGameData();
                this.saveRMSGameData();
            }
        }
        catch (RecordStoreNotFoundException recordStoreNotFoundException) {
            this.DEBUG_RMS("game settings recordstore not found");
            this.resetRMSGameData();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            filterInputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            byteArrayInputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (recordStore != null) {
            try {
                recordStore.closeRecordStore();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public boolean saveRMSAppSettings() {
        this.DEBUG_RMS("saveGameData");
        boolean bl = false;
        RecordStore recordStore = null;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            dataOutputStream.writeInt(173);
            dataOutputStream.writeBoolean(s_rmsSoundEnabled);
            dataOutputStream.writeBoolean(s_rmsVibrationEnabled);
            dataOutputStream.writeBoolean(s_rmsCarMarkersEnabled);
            dataOutputStream.writeBoolean(s_rmsSpeedunitsMPH);
            dataOutputStream.writeByte(s_rmsNumTimesCallToActionShown);
            dataOutputStream.writeByte(this.m_rmsGSLangIndex);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            recordStore = RecordStore.openRecordStore((String)RMS_SETTINGS, (boolean)true);
            if (recordStore.getNumRecords() == 0) {
                recordStore.addRecord(byArray, 0, byArray.length);
            } else {
                recordStore.setRecord(1, byArray, 0, byArray.length);
            }
        }
        catch (Exception exception) {
            bl = true;
        }
        try {
            dataOutputStream.close();
        }
        catch (Exception exception) {
            bl = true;
        }
        try {
            byteArrayOutputStream.close();
        }
        catch (Exception exception) {
            bl = true;
        }
        if (recordStore != null) {
            try {
                recordStore.closeRecordStore();
            }
            catch (Exception exception) {
                bl = true;
            }
        }
        return !bl;
    }

    public boolean saveRMSGameData() {
        this.DEBUG_RMS("saveGameData");
        boolean bl = false;
        RecordStore recordStore = null;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            int n;
            int n2 = this.getNumCars();
            dataOutputStream.writeInt(173);
            dataOutputStream.writeByte(this.m_numEvents);
            dataOutputStream.writeBoolean(s_rmsGameExists);
            dataOutputStream.writeByte(s_rmsWelcomeDisplayed);
            dataOutputStream.writeBoolean(s_rmsTutorialCompleted);
            dataOutputStream.writeByte(s_rmsCareerActiveCar);
            for (n = 0; n < n2; ++n) {
                dataOutputStream.writeByte(s_rmsCarsOwned[n]);
            }
            dataOutputStream.writeInt(s_rmsCareerMoney);
            for (n = 0; n < n2; ++n) {
                for (int i = 0; i < 4; ++i) {
                    dataOutputStream.writeByte(s_rmsAccessoryLevel[n][i]);
                }
            }
            dataOutputStream.writeInt(this.m_rmsEventsCompleted);
            dataOutputStream.writeInt(this.m_rmsEventsUnlocked);
            for (n = 0; n < this.m_numEvents; ++n) {
                dataOutputStream.writeByte(s_rmsEventAwards[n]);
            }
            for (n = 0; n < 5; ++n) {
                dataOutputStream.writeInt(s_rmsPersonalityHistory[n]);
            }
            for (n = 0; n < 5; ++n) {
                dataOutputStream.writeByte(s_rmsRankHistory[n]);
            }
            dataOutputStream.writeInt(s_rmsProfileTotal);
            for (n = 0; n < this.m_numEvents; ++n) {
                dataOutputStream.writeInt(s_rmsTrackBestLapTimes[n]);
                dataOutputStream.writeInt(s_rmsTrackBestRaceTimes[n]);
                dataOutputStream.writeByte(s_rmsTrackRanks[n]);
                dataOutputStream.writeInt(s_rmsTrackSpeedcameraTotal[n]);
                dataOutputStream.writeInt(s_rmsTrackPatrolTickets[n]);
            }
            dataOutputStream.writeInt(this.m_rmsBounty);
            dataOutputStream.writeInt(this.m_rmsTrophiesReached);
            for (n = 0; n < 11; ++n) {
                dataOutputStream.writeInt(this.m_rmsTrophyData[n]);
            }
            byte[] byArray = SceneMenu.getSignedData(byteArrayOutputStream);
            recordStore = RecordStore.openRecordStore((String)RMS_DATA, (boolean)true);
            if (recordStore.getNumRecords() == 0) {
                recordStore.addRecord(byArray, 0, byArray.length);
            } else {
                recordStore.setRecord(1, byArray, 0, byArray.length);
            }
        }
        catch (Exception exception) {
            bl = true;
        }
        try {
            dataOutputStream.close();
        }
        catch (Exception exception) {
            bl = true;
        }
        try {
            byteArrayOutputStream.close();
        }
        catch (Exception exception) {
            bl = true;
        }
        if (recordStore != null) {
            try {
                recordStore.closeRecordStore();
            }
            catch (Exception exception) {
                bl = true;
            }
        }
        return !bl;
    }

    public int rmsGetLanguage() {
        return this.m_rmsGSLangIndex;
    }

    public void rmsSetLanguage(int n) {
        this.m_rmsGSLangIndex = n;
        this.saveRMSGameData();
    }

    public int getRMSOptionString(int n) {
        if (n == 11) {
            return this.m_soundManager.isSoundEnabled() ? 10 : 9;
        }
        if (n == 12) {
            return s_rmsVibrationEnabled ? 10 : 9;
        }
        return -1;
    }

    public int getRMSOptionMaxStringLength(int n, int n2) {
        switch (n) {
            case 11: 
            case 12: {
                int n3 = this.m_textManager.getStringWidth(10, n2);
                int n4 = this.m_textManager.getStringWidth(9, n2);
                return n3 > n4 ? n3 : n4;
            }
        }
        return 0;
    }

    public int rmsGetNumTimesCallToActionShown() {
        return s_rmsNumTimesCallToActionShown;
    }

    public void rmsSetNumTimesCallToActionShown(int n) {
        s_rmsNumTimesCallToActionShown = (byte)n;
        this.saveRMSGameData();
    }

    private void loadTunershopData() {
        try {
            InputStream inputStream = this.m_resourceManager.loadBinaryFile(81);
            DataInputStream dataInputStream = new DataInputStream(inputStream);
            int n = dataInputStream.readByte();
            dataInputStream.close();
            dataInputStream = null;
            inputStream = null;
            System.gc();
            short[] sArray = new short[n];
            int[][] nArrayArray = new int[n][];
            int[][] nArrayArray2 = new int[n][];
            inputStream = this.m_resourceManager.loadBinaryFile(81);
            dataInputStream = new DataInputStream(inputStream);
            n = dataInputStream.readByte();
            for (int i = 0; i < n; ++i) {
                sArray[i] = this.lookupTunerShopData(dataInputStream);
                int n2 = dataInputStream.readByte();
                nArrayArray[i] = new int[n2];
                nArrayArray2[i] = new int[n2];
                for (int j = 0; j < n2; ++j) {
                    nArrayArray[i][j] = dataInputStream.readInt();
                    nArrayArray2[i][j] = dataInputStream.readInt();
                }
            }
            s_careerTunerMenuStringIDs = sArray;
            s_careerTunerAccessoryPrices = nArrayArray;
            s_careerTunerAccessoryBoostsF = nArrayArray2;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private short lookupTunerShopData(DataInputStream dataInputStream) throws IOException {
        return dataInputStream.readShort();
    }

    public short[] getCareerTunerMenuStringIDs() {
        return s_careerTunerMenuStringIDs;
    }

    public int[][] getCareerTunerAccessoryPrices() {
        return s_careerTunerAccessoryPrices;
    }

    public int[][] getCareerTunerAccessoryBoostsF() {
        return s_careerTunerAccessoryBoostsF;
    }

    public byte getCarAccessoryLevel(int n, int n2) {
        return s_rmsAccessoryLevel[n][n2];
    }

    public void purchaseCareerTunerAccessory(int n, int n2) {
        byte by = (byte)(this.getCarAccessoryLevel(n, n2) + 1);
        if (by <= this.getCareerTunerAccessoryPrices()[n2].length) {
            s_rmsCareerMoney -= this.getUpgradePrice(n, n2, by);
            AppEngine.s_rmsAccessoryLevel[n][n2] = by;
        }
        this.saveRMSGameData();
    }

    public int getUpgradePrice(int n, int n2, int n3) {
        int n4 = s_careerTunerAccessoryPrices[n2][n3 - 1];
        return MathExt.mulF(n4, this.m_carUpgradeScales[n]);
    }

    public boolean areCarMarkersEnabled() {
        return s_rmsCarMarkersEnabled;
    }

    public boolean areSpeedunitsMPH() {
        return s_rmsSpeedunitsMPH;
    }

    public void setCarMarkersEnabled(boolean bl) {
        s_rmsCarMarkersEnabled = bl;
        this.saveRMSAppSettings();
    }

    public void setSpeedunitsMPH(boolean bl) {
        s_rmsSpeedunitsMPH = bl;
        this.saveRMSAppSettings();
    }

    public boolean rmsGameExists() {
        return s_rmsGameExists;
    }

    public void rmsSetGameExists(boolean bl) {
        s_rmsGameExists = bl;
        this.saveRMSGameData();
    }

    public boolean rmsGetTierWelcomeDisplayed(int n) {
        return (s_rmsWelcomeDisplayed & 1 << n) != 0;
    }

    public void rmsSetTierWelcomeDisplayed(int n) {
        s_rmsWelcomeDisplayed = (byte)(s_rmsWelcomeDisplayed | 1 << n);
        this.saveRMSGameData();
    }

    public byte rmsGetCareerActiveCar() {
        return s_rmsCareerActiveCar;
    }

    public void rmsSetCareerActiveCar(byte by) {
        s_rmsCareerActiveCar = by;
    }

    public int rmsGetCareerMoney() {
        return s_rmsCareerMoney;
    }

    public int rmsGetTrackBestLapTime(int n) {
        return s_rmsTrackBestLapTimes[n];
    }

    public int rmsGetTrackBestRaceTime(int n) {
        return s_rmsTrackBestRaceTimes[n];
    }

    public int rmsGetTrackSpeedcameraTotal(int n) {
        return this.getValueInDistanceUnits(s_rmsTrackSpeedcameraTotal[n]);
    }

    public int rmsGetTrackPatrolTickets(int n) {
        return s_rmsTrackPatrolTickets[n];
    }

    public boolean isEventTypeKnown(int n) {
        int n2 = this.m_numEvents;
        while (--n2 >= 0) {
            if (this.getEventType(n2) != n || s_rmsTrackBestRaceTimes[n2] == 0) continue;
            return true;
        }
        return false;
    }

    public byte rmsGetEventRank(int n) {
        return s_rmsTrackRanks[n];
    }

    public int rmsGetBiggestDriftScore() {
        byte[] byArray = s_rmsTrackRanks;
        byte by = 0;
        for (int i = s_rmsTrackRanks.length - 1; i >= 0; --i) {
            if (byArray[i] <= by) continue;
            by = byArray[i];
        }
        return by;
    }

    public void rmsAddDriverProfile(int n, int n2, byte by) {
        int n3;
        System.arraycopy(s_rmsPersonalityHistory, 0, s_rmsPersonalityHistory, 1, 4);
        System.arraycopy(s_rmsRankHistory, 0, s_rmsRankHistory, 1, 4);
        AppEngine.s_rmsPersonalityHistory[0] = n3 = n << 16 & 0xFFFF0000 | n2 << 0 & 0xFFFF;
        AppEngine.s_rmsRankHistory[0] = by;
        s_rmsProfileTotal += n + n2;
        this.updateDriverProfile();
    }

    public int rmsGetProfileTotal() {
        return s_rmsProfileTotal;
    }

    public void rmsSetEventAwards(int n, byte by) {
        int n2 = n;
        s_rmsEventAwards[n2] = (byte)(s_rmsEventAwards[n2] | by);
        this.saveRMSGameData();
    }

    public byte rmsGetEventAwards(int n) {
        return s_rmsEventAwards[n];
    }

    public int rmsGetEventStarCount(int n) {
        int n2 = 0;
        byte by = this.rmsGetEventAwards(n);
        for (int i = 1; i < 256; i <<= 1) {
            if ((i & by) == 0) continue;
            ++n2;
        }
        return n2;
    }

    public int rmsGetTierStarCount(int n) {
        int n2 = 0;
        for (byte by = 0; by < this.m_numEvents; by = (byte)(by + 1)) {
            if (this.d_eventTier[by] != n) continue;
            n2 += this.rmsGetEventStarCount(by);
        }
        return n2;
    }

    public int rmsGetStarCount() {
        int n = 0;
        for (byte by = 0; by < this.m_numEvents; by = (byte)(by + 1)) {
            n += this.rmsGetEventStarCount(by);
        }
        return n;
    }

    public void submitBestLapTime(int n) {
        int n2 = s_rmsTrackBestLapTimes[this.m_currentRaceEventIndex];
        if (n2 <= 0 || n < n2) {
            AppEngine.s_rmsTrackBestLapTimes[this.m_currentRaceEventIndex] = n;
        }
    }

    public void submitBestRaceTime(int n) {
        int n2 = s_rmsTrackBestRaceTimes[this.m_currentRaceEventIndex];
        this.prevBestRaceTime = s_rmsTrackBestRaceTimes[this.m_currentRaceEventIndex];
        if (n2 == 0 || n < n2) {
            AppEngine.s_rmsTrackBestRaceTimes[this.m_currentRaceEventIndex] = n;
            if (n < n2 && n2 != 0 && this.getEventType(this.m_currentRaceEventIndex) != 2) {
                this.updateTrophyData(65536);
            }
        }
    }

    public void submitTrackSpeedcameraTotal(int n) {
        int n2 = s_rmsTrackSpeedcameraTotal[this.m_currentRaceEventIndex];
        if (n2 < n) {
            AppEngine.s_rmsTrackSpeedcameraTotal[this.m_currentRaceEventIndex] = n;
        }
    }

    public void submitTrackPatrolTicket(int n) {
        int n2 = s_rmsTrackPatrolTickets[this.m_currentRaceEventIndex];
        if (n2 < n) {
            AppEngine.s_rmsTrackPatrolTickets[this.m_currentRaceEventIndex] = n;
        }
    }

    public void setRaceTime(int n) {
        this.m_raceTime = n;
    }

    public void submitEventRank(byte by) {
        byte by2 = s_rmsTrackRanks[this.m_currentRaceEventIndex];
        this.prevRank = s_rmsTrackRanks[this.m_currentRaceEventIndex];
        if (by2 == 0 || by > by2) {
            AppEngine.s_rmsTrackRanks[this.m_currentRaceEventIndex] = by;
            if (by == 3) {
                this.updateTrophyData(1);
                if (this.isPlayerCop()) {
                    this.updateTrophyData(0x400000);
                    this.updateTrophyData(524288);
                } else {
                    this.updateTrophyData(4096);
                    this.updateTrophyData(2048);
                }
            }
            if (by != -1) {
                this.updateTrophyData(2);
                if (this.getEventType(this.m_currentRaceEventIndex) == 2 && by2 != 0) {
                    this.updateTrophyData(65536);
                }
            }
        }
    }

    public void setRaceRank(byte by) {
        this.m_raceRank = by;
    }

    public void unlockCareerCar(byte by) {
        if (by != 0) {
            this.m_rmsBounty -= this.getCarPrice(by);
        }
        this.addCarToList(s_rmsCarsOwned, by);
        this.removeCarFromList(s_carsNotOwned, by);
        s_careerNumCarsOwned = (byte)(s_careerNumCarsOwned + 1);
        this.rmsSetCareerActiveCar(by);
        this.lastCarsUnlocked[this.lastCarsUnlockedAmount] = by;
        ++this.lastCarsUnlockedAmount;
        this.updateTrophyData(256);
        this.updateTrophyData(32);
    }

    public int getCarTradeValue(byte by) {
        int[][] nArray = this.getCareerTunerAccessoryPrices();
        int n = this.getCarUpgradeScale(by);
        int n2 = this.getCarPrice(by);
        for (int i = 0; i < 4; ++i) {
            byte by2 = this.getCarAccessoryLevel(by, i);
            if (by2 <= 0) continue;
            int n3 = nArray[i][by2 - 1];
            n2 += MathExt.mulF(n3, n);
        }
        return n2 >> 1;
    }

    public byte getEventUnlockedCar(int n) {
        for (int i = 0; i < this.m_carsAll.length; ++i) {
            if (this.getCarUnlockingEvent(this.m_carsAll[i]) != n) continue;
            return this.m_carsAll[i];
        }
        return -1;
    }

    public boolean careerCarOwned(byte by) {
        if (this.cheatUsed(2)) {
            return true;
        }
        for (int i = 0; i < s_rmsCarsOwned.length; ++i) {
            if (s_rmsCarsOwned[i] != by) continue;
            return true;
        }
        return false;
    }

    public byte[] getOwnedCars() {
        return s_rmsCarsOwned;
    }

    public byte getOwnedCarsCount() {
        return s_careerNumCarsOwned;
    }

    public byte getNthOwnedCar(byte by) {
        return s_rmsCarsOwned[by];
    }

    public byte[] getUnownedCars() {
        return s_carsNotOwned;
    }

    public byte getUnownedCarsCount() {
        return (byte)(this.getNumCars() - this.getOwnedCarsCount());
    }

    public byte getNthNonOwnedCar(byte by) {
        return s_carsNotOwned[by];
    }

    public byte[] getAllCars() {
        return this.m_carsAll;
    }

    private void addCarToList(byte[] byArray, byte by) {
        for (int i = 0; byArray[i] != -1 && i < byArray.length; ++i) {
        }
        byArray[i] = by;
    }

    private void removeCarFromList(byte[] byArray, byte by) {
        int n;
        int n2 = this.getNumCars();
        int n3 = -1;
        for (n = 0; n < n2; ++n) {
            if (byArray[n] != by) continue;
            n3 = n;
            break;
        }
        if (n3 >= 0) {
            for (n = n3; n < s_rmsCarsOwned.length - 1; ++n) {
                byArray[n] = byArray[n + 1];
            }
            byArray[n2 - 1] = -1;
        }
    }

    public byte getEventSectorQuickRaceUnlockLevel() {
        return s_rmsSectorUnlockedQuickRace;
    }

    public byte getEventTier(int n) {
        return this.d_eventTier[n];
    }

    public void setNextRaceNumLaps(int n) {
        this.m_nextRaceNumLaps = (byte)n;
    }

    public byte getNextRaceNumLaps() {
        return this.m_nextRaceNumLaps;
    }

    public void awardCareerPrizeMoney(int n) {
        if ((s_rmsCareerMoney += n) > 99999999) {
            s_rmsCareerMoney = 99999999;
        }
    }

    public void loadTrackData() {
        try {
            InputStream inputStream = this.m_resourceManager.loadBinaryFile(79);
            DataInputStream dataInputStream = new DataInputStream(inputStream);
            this.m_numTracks = dataInputStream.readByte();
            dataInputStream.close();
            dataInputStream = null;
            inputStream = null;
            System.gc();
            int n = this.m_numTracks;
            byte[] byArray = new byte[n];
            short[] sArray = new short[n];
            byte[] byArray2 = new byte[n];
            int[] nArray = new int[n];
            inputStream = this.m_resourceManager.loadBinaryFile(79);
            dataInputStream = new DataInputStream(inputStream);
            dataInputStream.readByte();
            for (int i = 0; i < n; ++i) {
                byArray[i] = dataInputStream.readByte();
                sArray[i] = this.lookupTrackData(dataInputStream);
                byArray2[i] = dataInputStream.readByte();
                nArray[i] = dataInputStream.readInt();
            }
            this.m_trackEnvironments = byArray;
            this.m_trackDataResIDs = sArray;
            this.m_trackFlags = byArray2;
            this.m_trackDistances = nArray;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private short lookupTrackData(DataInputStream dataInputStream) throws IOException {
        return dataInputStream.readShort();
    }

    public void loadTrack(int n) {
        this.m_currentTrack = n;
    }

    public int getCurrentTrack() {
        return this.m_currentTrack;
    }

    public byte getTrackEnvironment() {
        return this.m_trackEnvironments[this.m_currentTrack];
    }

    public short getTrackDataResID() {
        return this.m_trackDataResIDs[this.m_currentTrack];
    }

    public byte getTrackFlags(int n) {
        return this.m_trackFlags[n];
    }

    public int getTrackDistance(int n) {
        return this.m_trackDistances[n];
    }

    public void setLastTrackLength(int n) {
        this.m_lastTrackLength = n;
    }

    public int getLastTrackLength() {
        return this.m_lastTrackLength;
    }

    public SDKString getLoadingProgressString(int n, SDKString sDKString) {
        int n2;
        int n3 = n * 17 / 100;
        for (n2 = 0; n2 < n3; ++n2) {
            sDKString.append(GLYPH_LOAD_TRUE);
        }
        for (n2 = n3; n2 < 17; ++n2) {
            sDKString.append(GLYPH_LOAD_FALSE);
        }
        return sDKString;
    }

    public void loadSplineData() {
        try {
            InputStream inputStream = this.m_resourceManager.loadBinaryFile(76);
            DataInputStream dataInputStream = new DataInputStream(inputStream);
            byte by = dataInputStream.readByte();
            int[][] nArray = new int[by][4];
            int[][][] nArrayArray = new int[by][][];
            for (byte by2 = 0; by2 < by; by2 = (byte)(by2 + 1)) {
                nArray[by2][0] = dataInputStream.readInt();
                nArray[by2][1] = dataInputStream.readInt();
                nArray[by2][2] = dataInputStream.readInt();
                nArray[by2][3] = dataInputStream.readInt();
                byte by3 = dataInputStream.readByte();
                nArrayArray[by2] = new int[by3][4];
                for (byte by4 = 0; by4 < by3; by4 = (byte)(by4 + 1)) {
                    nArrayArray[by2][by4][0] = dataInputStream.readInt();
                    nArrayArray[by2][by4][1] = dataInputStream.readInt();
                    nArrayArray[by2][by4][2] = dataInputStream.readInt();
                    nArrayArray[by2][by4][3] = dataInputStream.readByte();
                }
            }
            this.m_splineBoundingBoxes = nArray;
            this.m_splineNodes = nArrayArray;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public int[] getSplineBoundingBox(int n) {
        return this.m_splineBoundingBoxes[n];
    }

    public int[][] getSplineNodes(int n) {
        return this.m_splineNodes[n];
    }

    public void loadCarData() {
        try {
            InputStream inputStream = this.m_resourceManager.loadBinaryFile(6);
            DataInputStream dataInputStream = new DataInputStream(inputStream);
            int n = dataInputStream.readUnsignedByte();
            System.gc();
            byte[] byArray = new byte[n];
            short[] sArray = new short[n];
            short[] sArray2 = new short[n];
            int[] nArray = new int[n];
            int[] nArray2 = new int[n];
            short[] sArray3 = new short[n];
            short[] sArray4 = new short[n];
            short[] sArray5 = new short[n];
            short[] sArray6 = new short[n];
            short[][] sArrayArray = new short[n][];
            short[][] sArrayArray2 = new short[n][];
            short[] sArray7 = new short[n];
            short[] sArray8 = new short[n];
            int[] nArray3 = new int[n];
            int[] nArray4 = new int[n];
            int[] nArray5 = new int[n];
            int[][] nArrayArray = new int[n][];
            int[] nArray6 = new int[n];
            int[] nArray7 = new int[n];
            int[] nArray8 = new int[n];
            int[] nArray9 = new int[n];
            int[] nArray10 = new int[n];
            int[] nArray11 = new int[n];
            int[] nArray12 = new int[n];
            short[] sArray9 = new short[n];
            byte[] byArray2 = new byte[n];
            int[][] nArrayArray2 = new int[n][];
            int[][] nArrayArray3 = new int[n][];
            int[][] nArrayArray4 = new int[n][];
            for (int i = 0; i < n; ++i) {
                int n2;
                int n3;
                byArray[i] = (byte)i;
                sArray[i] = this.lookupCarData(dataInputStream);
                sArray2[i] = this.lookupCarData(dataInputStream);
                nArray[i] = dataInputStream.readInt();
                nArray2[i] = dataInputStream.readInt();
                sArray3[i] = this.lookupCarData(dataInputStream);
                sArray4[i] = this.lookupCarData(dataInputStream);
                sArray5[i] = this.lookupCarData(dataInputStream);
                sArray6[i] = this.lookupCarData(dataInputStream);
                short[] sArray10 = new short[9];
                for (n3 = 0; n3 < 9; ++n3) {
                    sArray10[n3] = this.lookupCarData(dataInputStream);
                }
                sArrayArray[i] = sArray10;
                sArray10 = new short[9];
                for (n3 = 0; n3 < 9; ++n3) {
                    sArray10[n3] = this.lookupCarData(dataInputStream);
                }
                sArrayArray2[i] = sArray10;
                sArray7[i] = this.lookupCarData(dataInputStream);
                sArray8[i] = this.lookupCarData(dataInputStream);
                nArray3[i] = dataInputStream.readInt();
                nArray4[i] = dataInputStream.readInt();
                nArray5[i] = dataInputStream.readInt();
                int[] nArray13 = new int[4];
                for (n2 = 0; n2 < 4; ++n2) {
                    nArray13[n2] = MathExt.mulF(dataInputStream.readInt(), 78643);
                }
                nArrayArray[i] = nArray13;
                nArray6[i] = nArray13[3] - nArray13[1];
                nArray7[i] = nArray13[2] - nArray13[0];
                nArray8[i] = dataInputStream.readInt();
                nArray9[i] = dataInputStream.readInt();
                nArray10[i] = 2 * dataInputStream.readInt();
                nArray11[i] = dataInputStream.readInt();
                nArray12[i] = dataInputStream.readInt();
                sArray9[i] = this.lookupCarData(dataInputStream);
                n2 = dataInputStream.readByte();
                byArray2[i] = (byte)n2;
                nArrayArray2[i] = new int[n2];
                nArrayArray3[i] = new int[n2];
                nArrayArray4[i] = new int[n2];
                for (int j = 0; j < n2; ++j) {
                    nArrayArray2[i][j] = dataInputStream.readInt();
                    nArrayArray4[i][j] = dataInputStream.readInt() << 12;
                    nArrayArray3[i][j] = j == 0 ? 0 : MathExt.mulF(nArrayArray4[i][j - 1], 54613);
                }
            }
            this.m_carsAll = byArray;
            this.m_carMakes = sArray;
            this.m_carDescriptions = sArray2;
            this.m_playerCarLoadMasks = nArray;
            this.m_oppCarLoadMasks = nArray2;
            this.m_cpuCarAnimIDs = sArray3;
            this.m_cpuCarOncomingAnimIDs = sArray4;
            this.m_carSelectAnimIDs = sArray5;
            this.m_carSelectImageIDs = sArray6;
            this.m_carAngleAnimIDs = sArrayArray;
            this.m_carBrakelightAngleAnimIDs = sArrayArray2;
            this.m_carSpinoutLeftAnimIDs = sArray7;
            this.m_carSpinoutRightAnimIDs = sArray8;
            this.m_carPrices = nArray3;
            this.m_carUpgradeScales = nArray4;
            this.m_carFlags = nArray5;
            this.m_carBoundingRects = nArrayArray;
            this.m_carLengths = nArray6;
            this.m_carWidths = nArray7;
            this.m_carParamTyres = nArray8;
            this.m_carParamSteeringInc = nArray9;
            this.m_carParamSteeringRecentreInc = nArray10;
            this.m_carParamSteeringMax = nArray11;
            this.m_carBountyUnlockValue = nArray12;
            this.m_carUnlockingEvent = sArray9;
            this.m_carNumGears = byArray2;
            this.m_carGearAccels = nArrayArray2;
            this.m_carGearMinSpeeds = nArrayArray3;
            this.m_carGearMaxSpeeds = nArrayArray4;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private short lookupCarData(DataInputStream dataInputStream) throws IOException {
        return dataInputStream.readShort();
    }

    public int getNumCars() {
        return this.m_carDescriptions.length;
    }

    public short getCarDescriptionStringID(int n) {
        return this.m_carDescriptions[n];
    }

    public int getQuickrace() {
        int n = this.rand(0, this.getEventCount());
        int n2 = 0;
        while (n >= 0) {
            if (++n2 >= 0 + this.getEventCount()) {
                n2 = 0;
            }
            if (this.getEventType(n2) == 7 || (!this.isPlayerCop() || !this.isCopModeEvent(n2)) && (this.isPlayerCop() || this.isCopModeEvent(n2))) continue;
            --n;
        }
        return n2;
    }

    public byte getCarFromDescriptionStringID(short s) {
        byte by = this.getNumCars();
        for (byte by2 = 0; by2 != by; by2 = (byte)(by2 + 1)) {
            if (this.m_carDescriptions[by2] != s) continue;
            return by2;
        }
        return -1;
    }

    public short getCarMakeStringID(short s) {
        return this.m_carMakes[s];
    }

    public int getCarPrice(int n) {
        return this.m_carPrices[n];
    }

    public int getCarUpgradeScale(int n) {
        return this.m_carUpgradeScales[n];
    }

    public int getNumCarsBuyable() {
        int n = 0;
        for (int i = 0; i < this.m_carFlags.length; ++i) {
            if (!this.getCarFlags(i, 1)) continue;
            ++n;
        }
        return n;
    }

    public boolean getCarFlags(int n, int n2) {
        return (this.m_carFlags[n] & n2) != 0;
    }

    public int getAllowedCivilianAppearance() {
        this.m_civAppearanceCounter %= s_allowedCivAppearances.length;
        return s_allowedCivAppearances[this.m_civAppearanceCounter++];
    }

    public int getAllowedOpponentAppearance() {
        this.m_oppAppearanceCounter %= s_allowedOppAppearances.length;
        return s_allowedOppAppearances[this.m_oppAppearanceCounter++];
    }

    public int[] getAllowedCivilianAppearances() {
        return s_allowedCivAppearances;
    }

    public void setAllowedCivilianAppearances() {
        int n;
        int n2;
        int n3 = this.getNumCars();
        int n4 = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            if (!this.getCarFlags(n2, 8)) continue;
            ++n4;
        }
        AppEngine.ASSERT(n4 >= 1, "The requested number of civilian car types exceeds the total number.");
        int[] nArray = new int[n4];
        n2 = 0;
        for (n = 0; n < n3; ++n) {
            if (!this.getCarFlags(n, 8)) continue;
            nArray[n2] = n;
            ++n2;
        }
        this.shuffleIntArray(nArray);
        for (n = 0; n < s_allowedCivAppearances.length; ++n) {
            AppEngine.s_allowedCivAppearances[n] = nArray[n];
        }
    }

    public int[] getAllowedOpponentAppearances() {
        return s_allowedOppAppearances;
    }

    public void setAllowedOpponentAppearances() {
        int n;
        int n2;
        int n3 = this.getPlayerCarIndex();
        int n4 = this.getNumCars();
        int n5 = 0;
        for (n2 = 0; n2 < n4; ++n2) {
            if (!this.getCarFlags(n2, 2) || n2 == n3) continue;
            ++n5;
        }
        AppEngine.ASSERT(n5 >= 1, "The requested number of opponent car types exceeds the total number of allowed types.");
        int[] nArray = new int[n5];
        n2 = 0;
        for (n = 0; n < n4; ++n) {
            if (!this.getCarFlags(n, 2) || n == n3) continue;
            nArray[n2] = n;
            ++n2;
        }
        this.shuffleIntArray(nArray);
        for (n = 0; n < s_allowedOppAppearances.length; ++n) {
            AppEngine.s_allowedOppAppearances[n] = nArray[n];
        }
    }

    private void shuffleIntArray(int[] nArray) {
        for (int i = 0; i < 128; ++i) {
            int n;
            int n2 = this.rand(0, nArray.length - 1);
            if (n2 == (n = this.rand(0, nArray.length - 1))) continue;
            int n3 = nArray[n2];
            nArray[n2] = nArray[n];
            nArray[n] = n3;
        }
    }

    public short getCpuCarAnimID(int n) {
        return this.m_cpuCarAnimIDs[n];
    }

    public short getCpuCarOncomingAnimID(int n) {
        return this.m_cpuCarOncomingAnimIDs[n];
    }

    public short getObjectAnimID(int n, boolean bl) {
        switch (n) {
            default: 
        }
        return -1;
    }

    public short getCarSelectAnimID(int n) {
        return this.m_carSelectAnimIDs[n];
    }

    public short getCarSelectImageID(int n) {
        return this.m_carSelectImageIDs[n];
    }

    public short[] getCarAngleAnimIDs(int n) {
        return this.m_carAngleAnimIDs[n];
    }

    public long getPlayerCarLoadMask(int n) {
        return (long)this.m_playerCarLoadMasks[n] << 14;
    }

    public long getOppCarLoadMask(int n) {
        return (long)this.m_oppCarLoadMasks[n] << 14;
    }

    public short[] getCarBrakelightAngleAnimIDs(int n) {
        return this.m_carBrakelightAngleAnimIDs[n];
    }

    public short getCarSpinoutLeftAnimID(int n) {
        return this.m_carSpinoutLeftAnimIDs[n];
    }

    public short getCarSpinoutRightAnimID(int n) {
        return this.m_carSpinoutRightAnimIDs[n];
    }

    public int[] getCarBoundingRect(int n) {
        return this.m_carBoundingRects[n];
    }

    public int getCarWidth(int n) {
        return this.m_carWidths[n];
    }

    public int getCarLength(int n) {
        return this.m_carLengths[n];
    }

    public int getCarParamTyres() {
        return this.getCarParamTyres(this.m_playerCarIndex);
    }

    public int getCarParamTyres(int n) {
        return this.m_carParamTyres[n];
    }

    public int getCarParamSteeringInc() {
        return this.getCarParamSteeringInc(this.m_playerCarIndex);
    }

    public int getCarParamSteeringInc(int n) {
        return this.m_carParamSteeringInc[n];
    }

    public int getCarParamSteeringRecentreInc() {
        return this.getCarParamSteeringRecentreInc(this.m_playerCarIndex);
    }

    public int getCarParamSteeringRecentreInc(int n) {
        return this.m_carParamSteeringRecentreInc[n];
    }

    public int getCarParamSteeringMax() {
        return this.getCarParamSteeringMax(this.m_playerCarIndex);
    }

    public int getCarParamSteeringMax(int n) {
        return this.m_carParamSteeringMax[n];
    }

    public int getCarBountyUnlockValue(int n) {
        return this.m_carBountyUnlockValue[n];
    }

    public short getCarUnlockingEvent(short s) {
        return this.m_carUnlockingEvent[s];
    }

    public byte getCarNumGears() {
        return this.getCarNumGears(this.m_playerCarIndex);
    }

    public byte getCarNumGears(int n) {
        return this.m_carNumGears[n];
    }

    public int getCarGearAccel(byte by) {
        return this.getCarGearAccel(this.m_playerCarIndex, by);
    }

    public int getCarGearAccel(int n, byte by) {
        int n2 = this.m_carGearAccels[n][by];
        return this.m_carGearAccels[n][by];
    }

    public int[] getCarGearAccelData() {
        return this.getCarGearAccelData(this.m_playerCarIndex);
    }

    public int[] getCarGearAccelData(int n) {
        return this.m_carGearAccels[n];
    }

    public int[] getCarGearMinSpeedData() {
        return this.getCarGearMinSpeedData(this.m_playerCarIndex);
    }

    public int[] getCarGearMinSpeedData(int n) {
        return this.m_carGearMinSpeeds[n];
    }

    public int[] getCarGearMaxSpeedData() {
        return this.getCarGearMaxSpeedData(this.m_playerCarIndex);
    }

    public int[] getCarGearMaxSpeedData(int n) {
        return this.m_carGearMaxSpeeds[n];
    }

    public int getCarGearMinSpeed(byte by) {
        return this.getCarGearMinSpeed(this.m_playerCarIndex, by);
    }

    public int getCarGearMinSpeed(int n, byte by) {
        return this.m_carGearMinSpeeds[n][by];
    }

    public int getCarGearMaxSpeed(byte by) {
        return this.getCarGearMaxSpeed(this.m_playerCarIndex, by);
    }

    public int getCarGearMaxSpeed(int n, byte by) {
        return this.m_carGearMaxSpeeds[n][by];
    }

    private void loadObjectData() {
        try {
            InputStream inputStream = this.m_resourceManager.loadBinaryFile(65);
            DataInputStream dataInputStream = new DataInputStream(inputStream);
            int n = dataInputStream.readByte();
            dataInputStream.close();
            dataInputStream = null;
            inputStream = null;
            System.gc();
            this.m_objectCarTypes = new short[n];
            this.m_objectFlags = new short[n];
            this.m_objectCosts = new short[n];
            this.m_objectWeights = new int[n];
            inputStream = this.m_resourceManager.loadBinaryFile(65);
            dataInputStream = new DataInputStream(inputStream);
            n = dataInputStream.readByte();
            for (int i = 0; i < n; ++i) {
                this.m_objectCarTypes[i] = this.lookupObjectData(dataInputStream);
                this.m_objectFlags[i] = dataInputStream.readByte();
                this.m_objectCosts[i] = dataInputStream.readShort();
                this.m_objectWeights[i] = dataInputStream.readInt();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private short lookupObjectData(DataInputStream dataInputStream) throws IOException {
        return dataInputStream.readShort();
    }

    public int getObjectFlags(int n) {
        return this.m_objectFlags[n];
    }

    public int getObjectCost(int n) {
        return this.m_objectCosts[n];
    }

    public int getObjectWeight(int n) {
        return this.m_objectWeights[n];
    }

    public int getPlayerCarIndex() {
        return this.m_playerCarIndex;
    }

    public void setPlayerCarIndex(int n) {
        this.m_playerCarIndex = n;
    }

    public boolean isPlayerCop() {
        return this.m_isPlayerCop;
    }

    public void setIsPlayerCop(boolean bl) {
        this.m_isPlayerCop = bl;
    }

    private void loadEventData() {
        try {
            int n;
            InputStream inputStream = this.m_resourceManager.loadBinaryFile(46);
            DataInputStream dataInputStream = new DataInputStream(inputStream);
            this.m_numEvents = n = dataInputStream.readByte();
            dataInputStream.close();
            dataInputStream = null;
            inputStream = null;
            System.gc();
            this.d_eventTier = new byte[n];
            this.d_eventStage = new byte[n];
            this.d_eventStarsNeeded = new byte[n];
            this.d_eventTypes = new byte[n];
            this.d_eventTrackIDs = new byte[n];
            this.d_eventTrackMirrored = new byte[n];
            this.d_eventTrackReversed = new byte[n];
            this.d_eventNightMode = new byte[n];
            this.d_eventEnvironments = new short[n];
            this.d_eventLaps = new byte[n];
            this.d_eventLenght = new int[n];
            this.d_eventRewards1 = new int[n];
            this.d_eventRewards2 = new int[n];
            this.d_eventRewards3 = new int[n];
            this.d_eventPrice = new int[n];
            this.d_eventDiffMinF = new int[n];
            this.d_eventDiffMaxF = new int[n];
            this.d_eventTrafficScaleF = new int[n];
            this.d_eventTrafficMax = new byte[n];
            this.d_eventTrafficFlags = new byte[n];
            this.d_eventCopPatrols = new byte[n];
            this.d_eventCopTraps = new byte[n];
            this.d_eventRoadblocksAvailable = new byte[n];
            this.d_eventSpikesAvailable = new byte[n];
            this.d_eventOpponents = new int[n][];
            this.d_eventParamsF = new int[n][3];
            this.d_eventPursiutHitRaise = new int[n];
            this.d_eventPursiutRaiseSpeed = new int[n];
            this.d_eventPatrolTime = new int[n];
            this.d_eventNextLeft = new int[n];
            this.d_eventNextRight = new int[n];
            this.d_eventNextUp = new int[n];
            this.d_eventNextDown = new int[n];
            this.d_eventMapPosX = new int[n];
            this.d_eventMapPosY = new int[n];
            this.d_eventPlayerCar = new int[n];
            this.d_eventUnlockingEventID1 = new int[n];
            this.d_eventUnlockingEventID2 = new int[n];
            this.d_eventBountyRequired = new int[n];
            this.m_cutsceneSteps = new short[n][][][];
            inputStream = this.m_resourceManager.loadBinaryFile(46);
            dataInputStream = new DataInputStream(inputStream);
            dataInputStream.readByte();
            for (int i = 0; i < n; ++i) {
                int n2;
                this.d_eventTier[i] = dataInputStream.readByte();
                this.d_eventStage[i] = dataInputStream.readByte();
                this.d_eventStarsNeeded[i] = dataInputStream.readByte();
                this.d_eventTypes[i] = dataInputStream.readByte();
                this.d_eventTrackIDs[i] = (byte)this.lookupEventData(dataInputStream);
                this.d_eventEnvironments[i] = this.lookupEventData(dataInputStream);
                this.d_eventTrackMirrored[i] = dataInputStream.readByte();
                this.d_eventTrackReversed[i] = dataInputStream.readByte();
                this.d_eventNightMode[i] = dataInputStream.readByte();
                this.d_eventLaps[i] = dataInputStream.readByte();
                this.d_eventLenght[i] = dataInputStream.readInt();
                this.d_eventRewards1[i] = dataInputStream.readInt();
                this.d_eventRewards2[i] = dataInputStream.readInt();
                this.d_eventRewards3[i] = dataInputStream.readInt();
                this.d_eventPrice[i] = dataInputStream.readInt();
                this.d_eventDiffMinF[i] = dataInputStream.readInt();
                this.d_eventDiffMaxF[i] = dataInputStream.readInt();
                this.d_eventTrafficScaleF[i] = dataInputStream.readInt();
                this.d_eventTrafficMax[i] = dataInputStream.readByte();
                this.d_eventTrafficFlags[i] = dataInputStream.readByte();
                this.d_eventCopTraps[i] = dataInputStream.readByte();
                this.d_eventCopPatrols[i] = dataInputStream.readByte();
                this.d_eventRoadblocksAvailable[i] = dataInputStream.readByte();
                this.d_eventSpikesAvailable[i] = dataInputStream.readByte();
                for (n2 = 0; n2 < 3; ++n2) {
                    this.d_eventParamsF[i][n2] = dataInputStream.readInt();
                }
                this.d_eventPursiutHitRaise[i] = dataInputStream.readInt();
                this.d_eventPursiutRaiseSpeed[i] = dataInputStream.readInt();
                this.d_eventPatrolTime[i] = dataInputStream.readInt();
                this.d_eventMapPosX[i] = dataInputStream.readInt();
                this.d_eventMapPosY[i] = dataInputStream.readInt();
                this.d_eventNextLeft[i] = dataInputStream.readInt();
                this.d_eventNextRight[i] = dataInputStream.readInt();
                this.d_eventNextUp[i] = dataInputStream.readInt();
                this.d_eventNextDown[i] = dataInputStream.readInt();
                this.d_eventPlayerCar[i] = this.lookupEventOpponentData(dataInputStream);
                this.d_eventUnlockingEventID1[i] = this.lookupEventData(dataInputStream);
                this.d_eventUnlockingEventID2[i] = this.lookupEventData(dataInputStream);
                this.d_eventBountyRequired[i] = dataInputStream.readInt();
                this.m_cutsceneSteps[i] = new short[5][][];
                n2 = dataInputStream.readByte();
                int n3 = dataInputStream.readByte();
                this.d_eventOpponents[i] = new int[n3];
                for (int j = 0; j < n3; ++j) {
                    this.d_eventOpponents[i][j] = this.lookupEventOpponentData(dataInputStream);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private short lookupEventData(DataInputStream dataInputStream) throws IOException {
        return dataInputStream.readShort();
    }

    private short lookupCutsceneAnims(DataInputStream dataInputStream) throws IOException {
        return dataInputStream.readShort();
    }

    private short lookupCutsceneStrings(DataInputStream dataInputStream) throws IOException {
        return dataInputStream.readShort();
    }

    private short lookupEventOpponentData(DataInputStream dataInputStream) throws IOException {
        return dataInputStream.readShort();
    }

    public byte getEventCount() {
        return this.m_numEvents;
    }

    public byte getEventCount(int n) {
        byte[] byArray = this.d_eventTier;
        byte by = 0;
        for (int i = this.m_numEvents - 1; i >= 0; --i) {
            if (byArray[i] != n) continue;
            by = (byte)(by + 1);
        }
        return by;
    }

    public int getEventId(int n, int n2) {
        int n3 = this.m_numEvents;
        byte[] byArray = this.d_eventTier;
        for (int i = 0; i <= n3; ++i) {
            if (byArray[i] != n) continue;
            return i + n2;
        }
        return -1;
    }

    public short getEventEnvironment(int n) {
        return this.d_eventEnvironments[n];
    }

    public byte getEventType(int n) {
        return this.d_eventTypes[n];
    }

    public final short getEventTypeNameId(int n) {
        switch (n) {
            case 0: {
                return 125;
            }
            case 1: {
                return 126;
            }
            case 2: {
                return 127;
            }
            case 3: {
                return 128;
            }
            case 4: {
                return 129;
            }
            case 5: {
                return 130;
            }
            case 6: {
                return 131;
            }
        }
        AppEngine.ASSERT(false, "invalid event type");
        return 24;
    }

    public final short getEventTypeDescriptionId(int n) {
        switch (n) {
            case 0: {
                return 125;
            }
            case 1: {
                return 126;
            }
            case 2: {
                return 127;
            }
            case 3: {
                return 128;
            }
            case 4: {
                return 129;
            }
            case 5: {
                return 130;
            }
            case 6: {
                return 131;
            }
        }
        AppEngine.ASSERT(false, "invalid event type");
        return 24;
    }

    public byte getEventTrackID(int n) {
        return this.d_eventTrackIDs[n];
    }

    public byte getEventTrackMirrored(int n) {
        return this.d_eventTrackMirrored[n];
    }

    public byte getEventTrackReversed(int n) {
        return this.d_eventTrackReversed[n];
    }

    public byte getEventNightMode(int n) {
        return this.d_eventNightMode[n];
    }

    public byte getEventLaps(int n) {
        return this.d_eventLaps[n];
    }

    public int getValueInDistanceUnits(int n) {
        return this.areSpeedunitsMPH() ? n : MathExt.mulF(n, 105447);
    }

    public int getEventLenghtF(int n) {
        return this.getValueInDistanceUnits(this.d_eventLenght[n]);
    }

    public int getEventReward(int n, int n2) {
        switch (n2) {
            case 3: {
                return this.d_eventRewards1[n];
            }
            case 2: {
                return this.d_eventRewards2[n];
            }
            case 1: {
                return this.d_eventRewards3[n];
            }
        }
        return 0;
    }

    public int[] getEventParamsF(int n) {
        return this.d_eventParamsF[n];
    }

    public int getEventPursuitHitRiseF(int n) {
        return this.d_eventPursiutHitRaise[n];
    }

    public int getEventPursuitRiseSpeedF(int n) {
        return this.d_eventPursiutRaiseSpeed[n];
    }

    public int getEventPatrolTime(int n) {
        return this.d_eventPatrolTime[n];
    }

    public int getEventNextLeft(int n) {
        return this.d_eventNextLeft[n] - 1;
    }

    public int getEventNextRight(int n) {
        return this.d_eventNextRight[n] - 1;
    }

    public int getEventNextUp(int n) {
        return this.d_eventNextUp[n] - 1;
    }

    public int getEventNextDown(int n) {
        return this.d_eventNextDown[n] - 1;
    }

    public int getEventMapPosX(int n) {
        return this.d_eventMapPosX[n];
    }

    public int getEventMapPosY(int n) {
        return this.d_eventMapPosY[n];
    }

    public int getEventPlayerCarIndex(int n) {
        return this.d_eventPlayerCar[n];
    }

    public int getEventUnlockingEventID1(int n) {
        return this.d_eventUnlockingEventID1[n];
    }

    public int getEventUnlockingEventID2(int n) {
        return this.d_eventUnlockingEventID2[n];
    }

    public int getEventBountyRequired(int n) {
        return this.d_eventBountyRequired[n];
    }

    public byte getCurrentEventType() {
        return this.getEventType(this.getCurrentRaceEventIndex());
    }

    public int getEnvironmentName(int n) {
        switch (n) {
            case 1: {
                return 223;
            }
            case 0: {
                return 224;
            }
            case 2: {
                return 225;
            }
        }
        return -1;
    }

    public boolean isCopModeEvent(int n) {
        byte by = this.getEventType(n);
        return by == 5 || by == 6;
    }

    public int getCurrentEventDiffMin() {
        return this.isPlayerCop() ? MathExt.mulF(this.d_eventDiffMinF[this.getCurrentRaceEventIndex()], 0) : this.d_eventDiffMinF[this.getCurrentRaceEventIndex()];
    }

    public int getCurrentEventDiffMax() {
        return this.isPlayerCop() ? MathExt.mulF(this.d_eventDiffMaxF[this.getCurrentRaceEventIndex()], 0) : this.d_eventDiffMaxF[this.getCurrentRaceEventIndex()];
    }

    public int getCurrentEventTrafficScale() {
        return this.d_eventTrafficScaleF[this.getCurrentRaceEventIndex()];
    }

    public int getCurrentEventTrafficMax() {
        return this.d_eventTrafficMax[this.getCurrentRaceEventIndex()];
    }

    public int getCurrentEventTrafficFlags() {
        return this.d_eventTrafficFlags[this.getCurrentRaceEventIndex()];
    }

    public int getCurrentEventCopPatrols() {
        return this.isPlayerCop() ? 0 : this.d_eventCopPatrols[this.getCurrentRaceEventIndex()];
    }

    public int getCurrentEventCopTraps() {
        return this.isPlayerCop() ? 0 : this.d_eventCopTraps[this.getCurrentRaceEventIndex()];
    }

    public int getCurrentEventRoadblocksAvailable() {
        return this.d_eventRoadblocksAvailable[this.getCurrentRaceEventIndex()];
    }

    public int getCurrentEventSpikesAvailable() {
        return this.d_eventSpikesAvailable[this.getCurrentRaceEventIndex()];
    }

    public int[] getCurrentEventOpponents() {
        if (this.isPlayerCop()) {
            return this.d_allowedEventOpponents;
        }
        return this.d_eventOpponents[this.getCurrentRaceEventIndex()];
    }

    public void setCurrentEventOpponents() {
        int n;
        this.d_allowedEventOpponents = AppEngine.copyArray(this.d_eventOpponents[this.getCurrentRaceEventIndex()]);
        if (!this.isPlayerCop()) {
            return;
        }
        int n2 = this.d_allowedEventOpponents.length;
        for (n = 0; n < this.d_allowedEventOpponents.length; ++n) {
            if (this.d_allowedEventOpponents[n] != this.getPlayerCarIndex()) continue;
            --n2;
        }
        int[] nArray = new int[n2];
        for (n = 0; n < this.d_allowedEventOpponents.length; ++n) {
            if (this.d_allowedEventOpponents[n] == this.getPlayerCarIndex()) continue;
            nArray[--n2] = this.d_allowedEventOpponents[n];
        }
        for (n = 0; n < this.d_allowedEventOpponents.length; ++n) {
            if (this.d_allowedEventOpponents[n] != this.getPlayerCarIndex()) continue;
            this.d_allowedEventOpponents[n] = nArray[this.rand(0, nArray.length - 1)];
        }
    }

    public short[][][] getCurrentEventCutscenes() {
        return this.m_cutsceneSteps[this.getCurrentRaceEventIndex()];
    }

    public void setRaceParameters(int n, int n2) {
        this.m_currentRaceType = n;
        this.m_currentRaceEventIndex = (byte)n2;
        this.setCarNowRacingParameters();
    }

    public void setCarNowRacingParameters() {
        this.m_carNowRacingParamTyres = this.getCarParamTyres();
        this.m_carNowRacingParamSteeringInc = this.getCarParamSteeringInc();
        this.m_carNowRacingParamSteeringRecentreInc = this.getCarParamSteeringRecentreInc();
        this.m_carNowRacingParamSteeringMax = this.getCarParamSteeringMax();
        this.m_carNowRacingGearAccels = AppEngine.copyArray(this.getCarGearAccelData());
        this.m_carNowRacingGearMinSpeeds = AppEngine.copyArray(this.getCarGearMinSpeedData());
        this.m_carNowRacingGearMaxSpeeds = AppEngine.copyArray(this.getCarGearMaxSpeedData());
        this.m_carNowRacingNitroExtra = 65536;
        if (this.isCurrentRaceCareer()) {
            this.m_carNowRacingParamTyres = MathExt.mulF(this.m_carNowRacingParamTyres, this.getCareerAccessoryAdjustment(2));
            this.m_carNowRacingParamSteeringInc = MathExt.mulF(this.m_carNowRacingParamSteeringInc, this.getCareerAccessoryAdjustment(2));
            int n = this.getCareerAccessoryAdjustment(1);
            int n2 = this.getCareerAccessoryAdjustment(0);
            int n3 = this.getCarNumGears();
            for (int i = 0; i < n3; ++i) {
                this.m_carNowRacingGearAccels[i] = MathExt.mulF(this.m_carNowRacingGearAccels[i], n);
                this.m_carNowRacingGearMaxSpeeds[i] = MathExt.mulF(this.m_carNowRacingGearMaxSpeeds[i], n2);
            }
            this.m_carNowRacingNitroExtra = this.getCareerAccessoryAdjustment(3);
        } else {
            this.m_carNowRacingNitroExtra = this.getCareerAccessoryAdjustment(3, this.m_playerCarIndex, 1);
        }
    }

    public int getCarNowRacingParamTyres() {
        return this.m_carNowRacingParamTyres;
    }

    public int getCarNowRacingParamSteeringInc() {
        return this.m_carNowRacingParamSteeringInc;
    }

    public int getCarNowRacingParamSteeringRecentreInc() {
        return this.m_carNowRacingParamSteeringRecentreInc;
    }

    public int getCarNowRacingParamSteeringMax() {
        return this.m_carNowRacingParamSteeringMax;
    }

    public int getCarNowRacingNitroLevel() {
        return this.getCarAccessoryLevel(this.m_playerCarIndex, 3);
    }

    public int getCarNowRacingNitroExtra() {
        return this.m_carNowRacingNitroExtra;
    }

    public int[] getCarNowRacingGearAccelData() {
        return this.m_carNowRacingGearAccels;
    }

    public int[] getCarNowRacingGearMinSpeedData() {
        return this.m_carNowRacingGearMinSpeeds;
    }

    public int[] getCarNowRacingGearMaxSpeedData() {
        return this.m_carNowRacingGearMaxSpeeds;
    }

    public int getCareerAccessoryAdjustment(int n) {
        return this.getCareerAccessoryAdjustment(n, this.m_playerCarIndex);
    }

    public int getCareerAccessoryAdjustment(int n, int n2) {
        byte by = s_rmsAccessoryLevel[n2][n];
        return this.getCareerAccessoryAdjustment(n, n2, by);
    }

    public int getCareerAccessoryAdjustment(int n, int n2, int n3) {
        if (n3 > 0) {
            return s_careerTunerAccessoryBoostsF[n][n3 - 1];
        }
        return 65536;
    }

    public boolean isCurrentRaceCareer() {
        return this.m_currentRaceType == 3;
    }

    public boolean isCurrentRaceTutorial() {
        return this.m_currentRaceType == 1;
    }

    public void setPostTutorialState(byte by) {
        this.m_postTutorialState = by;
    }

    public byte getPostTutorialState() {
        return this.m_postTutorialState;
    }

    public byte getCurrentRaceEventIndex() {
        return this.m_currentRaceEventIndex;
    }

    public void startRace(int n) {
        byte by = this.getEventLaps(n);
        byte by2 = this.getEventTrackID(n);
        this.loadTrack(by2);
        this.setNextRaceNumLaps(by);
        this.stopMusic();
        this.m_flowManager.transitionScene(1, 45);
    }

    public static void postRotatex(Transform transform, int n, int n2, int n3, int n4) {
        transform.postRotatex(n, n2, n3, n4);
    }

    public static void postTranslatex(Transform transform, int n, int n2, int n3) {
        transform.postTranslatex(n, n2, n3);
    }

    public static void postScalex(Transform transform, int n, int n2, int n3) {
        transform.postScalex(n, n2, n3);
    }

    public static void transformx(Transform transform, int[] nArray) {
        transform.transformx(nArray);
    }

    public int getBounty() {
        return this.m_rmsBounty;
    }

    public void increaseBounty(int n) {
        this.m_rmsBounty += n;
    }

    public void increasedummyBounty(int n) {
        dummyBounty += n;
        this.total_bonusDeductions -= n;
    }

    public void reduceBounty(int n) {
        this.m_rmsBounty -= n;
        this.total_bonusDeductions = 0;
    }

    public int getdummyBounty() {
        return dummyBounty;
    }

    public void reducedummyBounty(int n) {
        dummyBounty -= n;
        this.total_bonusDeductions += n;
    }

    public void completeEvent(int n) {
        if (n >= 0) {
            this.unCompliteEvents = this.unCompliteEvenetsNum();
            this.m_rmsEventsCompleted |= 1 << n;
            this.updateUnlocks();
        }
    }

    public void unlockEvent(int n) {
        this.m_rmsBounty -= this.getEventPrice(n);
        if (n >= 0) {
            this.m_rmsEventsUnlocked |= 1 << n;
            this.updateUnlocks();
        }
    }

    public boolean isEventComplete(int n) {
        return (this.m_rmsEventsCompleted & 1 << n) != 0;
    }

    public int getFirstUncompletedEvent() {
        for (int i = 0; i < this.m_numEvents; ++i) {
            if (this.isEventComplete(i)) continue;
            return i;
        }
        return -1;
    }

    public int getFirstLockedEvent() {
        for (int i = 0; i <= 23; ++i) {
            if (this.isEventUnlocked(i)) continue;
            return i;
        }
        return -1;
    }

    public int getEventStarsRequired(int n) {
        return this.d_eventStarsNeeded[n];
    }

    public boolean updateTrophyData(int n) {
        return this.updateTrophyData(n, -1);
    }

    public boolean updateTrophyData(int n, int n2) {
        if (this.isTrophyAvailable(n) && !this.isTrophyReached(n)) {
            if (this.isTrophyDataDefined(n)) {
                int n3 = this.getTrophyData(n);
                if (n == 0x100000) {
                    int n4 = this.getNumCarsBuyable();
                    AppEngine.ASSERT(n2 >= 0 && n2 < n4);
                    n3 |= 1 << n2 + (this.m_isPlayerCop ? n4 : 0);
                } else {
                    n3 += n2;
                }
                this.setTrophyData(n, n3);
            }
            if (this.checkTrophyReached(n, n2)) {
                this.reachTrophy(n);
                if (!this.trophyNotificationEnqueue(n)) {
                    AppEngine.ASSERT(false, "Trophy notiffication queue is full!");
                }
                return true;
            }
        }
        return false;
    }

    public boolean isTrophyReached(int n) {
        return this.isTrophyAvailable(n) && (this.m_rmsTrophiesReached & n) != 0;
    }

    private boolean reachTrophy(int n) {
        if (this.isTrophyAvailable(n) && !this.isTrophyReached(n)) {
            this.m_rmsTrophiesReached |= n;
            return true;
        }
        return false;
    }

    public void resetTrophies() {
        this.m_rmsTrophiesReached = 0;
        for (int i = 0; i < this.m_rmsTrophyData.length; ++i) {
            this.m_rmsTrophyData[i] = 0;
        }
        this.m_trophyQueueFront = 0;
        this.m_trophyQueueBack = -1;
        this.m_trophyTimer = 0;
        this.m_updateTrophies = true;
    }

    private void updateTrophies(int n) {
        this.m_trophyTimeStep += n;
        if (this.m_trophyTimer >= 0) {
            this.m_trophyTimer -= n;
        }
        if (this.m_updateTrophies && !this.trophyNotificationIsQueueEmpty() && this.m_trophyTimer < 0) {
            this.notiffyTrophyReached(this.trophyNotificationDequeue());
            this.m_trophyTimer = 3000;
        }
    }

    private boolean checkTrophyReached(int n, int n2) {
        boolean bl = false;
        if (!this.isTrophyAvailable(n)) {
            return bl;
        }
        block0 : switch (n) {
            case 1: {
                bl = true;
                for (int i = 0; i < this.m_numEvents - 1; ++i) {
                    if (this.isEventComplete(i) && this.rmsGetEventRank(i) == 3) continue;
                    bl = false;
                    break block0;
                }
                break;
            }
            case 2: {
                bl = true;
                for (int i = 0; i < this.m_numEvents - 1; ++i) {
                    if (this.isEventComplete(i) && this.rmsGetEventRank(i) != -1) continue;
                    bl = false;
                    break block0;
                }
                break;
            }
            case 4: {
                if (!this.isTrophyDataDefined(n)) break;
                int n3 = this.getTrophyData(n);
                bl = n3 >= 100;
                break;
            }
            case 8: {
                bl = true;
                break;
            }
            case 16: {
                bl = true;
                break;
            }
            case 0x800000: {
                if (!this.isTrophyDataDefined(n)) break;
                int n4 = this.getTrophyData(n);
                bl = n4 >= 500;
                break;
            }
            case 64: {
                bl = n2 < 250;
                break;
            }
            case 128: {
                if (!this.isTrophyDataDefined(n)) break;
                int n5 = this.getTrophyData(n);
                bl = n5 >= 0xC80000;
                break;
            }
            case 256: {
                bl = s_carsNotOwned[s_carsNotOwned.length - this.getNumCarsBuyable()] == -1;
                break;
            }
            case 512: {
                if (!this.isTrophyDataDefined(n)) break;
                int n6 = this.getTrophyData(n);
                bl = n6 >= 50;
                break;
            }
            case 1024: {
                if (!this.isTrophyDataDefined(n)) break;
                int n7 = this.getTrophyData(n);
                bl = n7 >= 30;
                break;
            }
            case 0x1000000: {
                if (!this.isTrophyDataDefined(n)) break;
                int n8 = this.getTrophyData(n);
                bl = n8 >= 10;
                break;
            }
            case 0x2000000: {
                if (!this.isTrophyDataDefined(n)) break;
                int n9 = this.getTrophyData(n);
                bl = n9 >= 10;
                break;
            }
            case 8192: {
                bl = true;
                break;
            }
            case 16384: {
                bl = true;
                break;
            }
            case 32768: {
                bl = n2 > 250;
                break;
            }
            case 65536: {
                bl = true;
                break;
            }
            case 131072: {
                if (!this.isTrophyDataDefined(n)) break;
                int n10 = this.getTrophyData(n);
                bl = n10 >= 100;
                break;
            }
            case 262144: {
                if (!this.isTrophyDataDefined(n)) break;
                int n11 = this.getTrophyData(n);
                bl = n11 >= 0x640000;
                break;
            }
            case 524288: {
                bl = true;
                break;
            }
            case 0x100000: {
                int n12 = this.getNumCarsBuyable();
                int n13 = this.getTrophyData(n);
                bl = true;
                for (int i = 0; i < n12 && bl; ++i) {
                    if ((n13 & 1 << i) != 0) continue;
                    bl = false;
                }
                break;
            }
            case 0x200000: {
                if (!this.isTrophyDataDefined(n)) break;
                int n14 = this.getTrophyData(n);
                bl = n14 >= 10;
                break;
            }
            case 0x400000: {
                bl = true;
                for (int i = 0; i < this.m_numEvents; ++i) {
                    if (!this.isCopModeEvent(i) || this.isEventComplete(i) && this.rmsGetEventRank(i) == 3) continue;
                    bl = false;
                    break block0;
                }
                break;
            }
            case 32: {
                bl = this.getOwnedCarsCount() == 2;
                break;
            }
            case 2048: {
                bl = true;
                for (int i = 0; i < this.m_numEvents - 1; ++i) {
                    if (this.isCopModeEvent(i) || this.isEventComplete(i) && this.rmsGetEventRank(i) == 3) continue;
                    bl = false;
                    break block0;
                }
                break;
            }
            case 4096: {
                int n15 = 0;
                for (int i = 0; i < this.m_numEvents && n15 < 2; ++i) {
                    if (this.isCopModeEvent(i) || !this.isEventComplete(i) || this.rmsGetEventRank(i) != 3) continue;
                    ++n15;
                }
                bl = n15 == 1;
                break;
            }
        }
        return bl;
    }

    private int getTrophyDataIdx(int n) {
        switch (n) {
            case 4: {
                return 0;
            }
            case 0x800000: {
                return 1;
            }
            case 128: {
                return 2;
            }
            case 512: {
                return 3;
            }
            case 1024: {
                return 4;
            }
            case 0x1000000: {
                return 5;
            }
            case 0x2000000: {
                return 6;
            }
            case 131072: {
                return 7;
            }
            case 262144: {
                return 8;
            }
            case 0x200000: {
                return 10;
            }
            case 0x100000: {
                return 9;
            }
        }
        return -1;
    }

    private boolean isTrophyDataDefined(int n) {
        if (this.isTrophyAvailable(n)) {
            int n2 = this.getTrophyDataIdx(n);
            return n2 >= 0 && n2 < this.m_rmsTrophyData.length;
        }
        return false;
    }

    private int getTrophyData(int n) {
        if (this.isTrophyAvailable(n) && this.isTrophyDataDefined(n)) {
            int n2 = this.getTrophyDataIdx(n);
            return this.m_rmsTrophyData[n2];
        }
        return -1;
    }

    private boolean setTrophyData(int n, int n2) {
        int n3 = this.getTrophyDataIdx(n);
        if (n3 >= 0 && n3 < this.m_rmsTrophyData.length) {
            this.m_rmsTrophyData[n3] = n2;
            return true;
        }
        return false;
    }

    public boolean isTrophyAvailable(int n) {
        return (0x3800000 & n) == 0;
    }

    private boolean trophyNotificationEnqueue(int n) {
        if (!this.trophyNotificationIsQueueFull()) {
            if (this.trophyNotificationIsQueueEmpty()) {
                this.m_trophyNotificationQueue[this.m_trophyQueueFront] = n;
                this.m_trophyQueueBack = this.m_trophyQueueFront;
                if (this.m_trophyTimer < 0) {
                    this.m_trophyTimer = 0;
                }
            } else {
                this.m_trophyQueueBack = (this.m_trophyQueueBack + 1) % this.m_trophyNotificationQueue.length;
                this.m_trophyNotificationQueue[this.m_trophyQueueBack] = n;
            }
            return true;
        }
        return false;
    }

    private int trophyNotificationDequeue() {
        int n = -1;
        if (!this.trophyNotificationIsQueueEmpty()) {
            n = this.m_trophyNotificationQueue[this.m_trophyQueueFront];
            if (this.m_trophyQueueBack == this.m_trophyQueueFront) {
                this.m_trophyQueueBack = -1;
            }
            this.m_trophyQueueFront = (this.m_trophyQueueFront + 1) % this.m_trophyNotificationQueue.length;
        }
        return n;
    }

    private boolean trophyNotificationIsQueueEmpty() {
        return this.m_trophyQueueBack == -1;
    }

    private boolean trophyNotificationIsQueueFull() {
        if (this.trophyNotificationIsQueueEmpty()) {
            return false;
        }
        int n = (this.m_trophyQueueBack + 1) % this.m_trophyNotificationQueue.length;
        return n == this.m_trophyQueueFront;
    }

    private void notiffyTrophyReached(int n) {
        if (this.isTrophyAvailable(n)) {
            this.m_drawTrophyPopup = true;
            this.m_trophyTimeStep = 0;
            int n2 = 0;
            while (n != 1 && n > 0) {
                ++n2;
                n >>= 1;
            }
            this.m_trophyPopupName = TROPHY_NAMES[n2];
        }
    }

    public void setTrophyNottificationEnabled(boolean bl) {
        if (this.m_updateTrophies != bl) {
            if (!this.m_updateTrophies) {
                this.m_trophyTimer = 0;
            }
            this.m_updateTrophies = bl;
        }
    }

    public boolean isEventUnlocked(int n) {
        if (this.cheatUsed(0)) {
            return true;
        }
        return (this.m_rmsEventsUnlocked & 1 << n) != 0;
    }

    private void initUnlockNotification() {
        this.d_unlockedEvents = new boolean[this.m_numEvents];
        for (int i = 0; i < this.m_numEvents; ++i) {
            this.d_unlockedEvents[i] = this.isEventUnlocked(i);
        }
    }

    public void unlockAllEvent() {
        for (int i = 0; i < this.m_numEvents; ++i) {
            this.d_unlockedEvents[i] = true;
            this.m_rmsEventsUnlocked |= 1 << i;
        }
    }

    private void updateUnlocks() {
        int n;
        this.wasEventsUnlocked = false;
        int n2 = 0;
        for (n = 0; n < this.m_numEvents; ++n) {
            if (this.d_unlockedEvents[n] || !this.isEventUnlocked(n)) continue;
            ++n2;
        }
        if (n2 > 0) {
            this.d_lastUnlockedEvents = new int[n2];
            n = 0;
            for (int i = 0; i < this.m_numEvents; ++i) {
                if (this.d_unlockedEvents[i] || !this.isEventUnlocked(i)) continue;
                this.d_unlockedEvents[i] = true;
                this.m_rmsEventsUnlocked |= 1 << i;
                this.d_lastUnlockedEvents[n++] = i;
            }
            this.wasEventsUnlocked = true;
        }
        this.wasLastEventUnlocked = false;
        n = this.unCompliteEvenetsNum();
        if (n == 1 && this.unCompliteEvents == n + 1) {
            this.wasLastEventUnlocked = true;
        }
    }

    public int unCompliteEvenetsNum() {
        int n = 0;
        for (int i = 0; i < this.m_numEvents; ++i) {
            if (this.isEventComplete(i)) continue;
            ++n;
        }
        return n;
    }

    public int[] getUnlockAnimationNodes() {
        return this.d_lastUnlockedEvents;
    }

    public void clearUnlockAnimationNodes() {
        this.d_lastUnlockedEvents = null;
    }

    public SDKString getNextUnlockNotification() {
        TextManager textManager = this.m_textManager;
        if (this.wasLastEventUnlocked) {
            this.wasLastEventUnlocked = false;
            this.m_unlockNotifyBuffer.setLength(0);
            this.m_unlockNotifyBuffer.append(textManager.getString(228));
            return this.m_unlockNotifyBuffer;
        }
        if (this.lastCarsUnlockedAmount > 0) {
            --this.lastCarsUnlockedAmount;
            byte by = this.lastCarsUnlocked[this.lastCarsUnlockedAmount];
            short s = this.getCarDescriptionStringID(by);
            SDKString sDKString = textManager.getString(227).replaceFirst(this.m_textManager.getString(s));
            this.m_unlockNotifyBuffer.setLength(0);
            this.m_unlockNotifyBuffer.append(sDKString);
            return this.m_unlockNotifyBuffer;
        }
        if (this.wasEventsUnlocked) {
            this.wasEventsUnlocked = false;
            this.m_unlockNotifyBuffer.setLength(0);
            this.m_unlockNotifyBuffer.append(textManager.getString(226));
            return this.m_unlockNotifyBuffer;
        }
        return null;
    }

    private void updateDriverProfile() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i < 5; ++i) {
            int n5 = (s_rmsPersonalityHistory[i] & 0xFFFF0000) >> 16;
            int n6 = (s_rmsPersonalityHistory[i] & 0xFFFF) >> 0;
            byte by = s_rmsRankHistory[i];
            if (n5 > n6) {
                ++n2;
            }
            if (n6 > n5) {
                ++n;
            }
            if (by < 0) {
                ++n4;
            }
            n3 += by;
        }
        this.m_driverProfileCountPrecision = n;
        this.m_driverProfileCountAggression = n2;
        this.m_driverProfileCountRank = n3;
        this.m_driverProfileCountLosses = n4;
    }

    private void renderTrophyPopup(Graphics graphics, int n) {
        this.m_layoutManager2.drawLayout(graphics, 89, 0, this.getScreenHeight() >> 1, this.getScreenWidth(), this.getScreenHeight(), n);
    }

    public void renderDriverProfileDiamond(Graphics graphics, int n, int n2, int n3, int n4) {
        int n5 = (n + n3) / 2 + 1;
        int n6 = (n2 + n4) / 2 + 1;
        int n7 = (n3 - n) / 2;
        int n8 = (n4 - n2) / 2;
        int n9 = n5 - n7 * this.m_driverProfileCountPrecision / 5;
        int n10 = n5 + n7 * this.m_driverProfileCountAggression / 5;
        int n11 = n6 - Math.max(0, n8 * this.m_driverProfileCountRank / 5 / 3);
        int n12 = n6 + n8 * this.m_driverProfileCountLosses / 5;
        if (n9 == n5) {
            n9 -= 5;
        }
        if (n10 == n5) {
            n10 += 5;
        }
        if (n11 == n6) {
            n11 -= 5;
        }
        if (n12 == n6) {
            n12 += 5;
        }
        AnimationManager.setColor(graphics, 235);
        graphics.fillTriangle(n9, n6, n5, n11, n10, n6);
        graphics.fillTriangle(n9, n6, n5, n12, n10, n6);
    }

    public int getDriverProfileDriverLevel() {
        return this.rmsGetProfileTotal();
    }

    public SDKString getConfirmationText(int n) {
        TextManager textManager = this.m_textManager;
        switch (n) {
            case 30: {
                return textManager.getString(51);
            }
            case 31: {
                return textManager.getString(54);
            }
            case 25: 
            case 26: 
            case 29: {
                return textManager.getString(52);
            }
            case 27: 
            case 28: {
                return textManager.getString(124);
            }
            case 17: {
                if (SceneMenu.purchaseIdx != 0) {
                    return textManager.getString(63);
                }
                return textManager.getString(63);
            }
            case 18: {
                return textManager.getString(63);
            }
            case 15: {
                return textManager.getString(59);
            }
            case 16: {
                return textManager.getString(58);
            }
        }
        return new SDKString("XXX");
    }

    public SDKString getPreraceRankLegendString(byte by, SDKString sDKString) {
        byte by2 = this.getEventType(this.m_currentRaceEventIndex);
        TextManager textManager = this.m_textManager;
        int[] nArray = this.getEventParamsF(this.m_currentRaceEventIndex);
        switch (by2) {
            case 0: 
            case 1: 
            case 2: {
                if (by == 3) {
                    return textManager.getString(194);
                }
                if (by == 2) {
                    return textManager.getString(195);
                }
                if (by == 1) {
                    return textManager.getString(196);
                }
                return sDKString;
            }
            case 3: {
                int n = 0;
                if (by == 3) {
                    n = this.getValueInDistanceUnits(this.getEventParamsF(this.m_currentRaceEventIndex)[2]);
                } else if (by == 2) {
                    n = this.getValueInDistanceUnits(this.getEventParamsF(this.m_currentRaceEventIndex)[1]);
                } else if (by == 1) {
                    n = this.getValueInDistanceUnits(this.getEventParamsF(this.m_currentRaceEventIndex)[0]);
                }
                this.intToSDKString(n >> 16, false, sDKString);
                sDKString.append(" ");
                sDKString.append(this.getLayoutString(134, sDKString));
                return sDKString;
            }
            case 4: 
            case 5: {
                if (by == 3) {
                    this.timeToSDKString(this.eventParamTimeToMilliseconds(nArray[2]), 2, sDKString);
                } else if (by == 2) {
                    this.timeToSDKString(this.eventParamTimeToMilliseconds(nArray[1]), 2, sDKString);
                } else if (by == 1) {
                    this.timeToSDKString(this.eventParamTimeToMilliseconds(nArray[0]), 2, sDKString);
                }
                return sDKString;
            }
            case 6: {
                int[] nArray2 = this.getEventParamsF(this.getCurrentRaceEventIndex());
                int[] nArray3 = Cache.getInstance().acquireIntArray(1);
                if (by == 3) {
                    nArray3[0] = nArray2[2] >> 16;
                } else if (by == 2) {
                    nArray3[0] = nArray2[1] >> 16;
                } else if (by == 1) {
                    nArray3[0] = nArray2[0] >> 16;
                }
                SDKString sDKString2 = this.m_textManager.getString(197);
                this.m_textManager.replace(sDKString, sDKString2, nArray3);
                Cache.getInstance().releaseIntArray(nArray3);
                return sDKString;
            }
        }
        return textManager.getString(24);
    }

    public SDKString getLayoutString(int n, SDKString sDKString) {
        switch (n) {
            case 194: {
                if (!SceneMenu.bonus_speed_freak) {
                    return this.m_textManager.getString(279);
                }
                return this.m_textManager.getString(280);
            }
            case 195: {
                if (!SceneMenu.bonus_mp) {
                    return this.m_textManager.getString(279);
                }
                return this.m_textManager.getString(280);
            }
            case 1: {
                switch (this.soundState) {
                    case 0: {
                        return this.m_textManager.getString(9);
                    }
                    case 1: {
                        if (this.isSimultaneousSounds) {
                            return this.m_textManager.getString(10);
                        }
                        return this.m_textManager.getString(14);
                    }
                    case 2: {
                        return this.m_textManager.getString(15);
                    }
                }
                return this.m_textManager.getString(9);
            }
            case 2: {
                if (this.isVibrationEnabled()) {
                    return this.m_textManager.getString(10);
                }
                return this.m_textManager.getString(9);
            }
            case 3: {
                if (this.areCarMarkersEnabled()) {
                    return this.m_textManager.getString(10);
                }
                return this.m_textManager.getString(9);
            }
            case 134: {
                if (this.areSpeedunitsMPH()) {
                    return this.m_textManager.getString(235);
                }
                return this.m_textManager.getString(236);
            }
            case 88: {
                this.appendTimeToBuffer(this.m_raceTime, sDKString);
                return sDKString;
            }
            case 95: {
                this.moneyToSDKString(this.getEventReward(this.m_currentRaceEventIndex, this.m_raceRank), sDKString);
                return sDKString;
            }
            case 186: {
                sDKString.append("");
                return sDKString;
            }
            case 187: {
                sDKString.append("");
                return sDKString;
            }
            case 73: {
                if (this.isCurrentRaceCareer()) {
                    AppEngine.starsToSDKString(this.rmsGetEventAwards(this.m_currentRaceEventIndex), sDKString);
                }
                return sDKString;
            }
            case 173: {
                if (this.isEventUnlocked(this.m_currentRaceEventIndex)) {
                    return sDKString.append(this.m_textManager.getString(209));
                }
                return sDKString.append("");
            }
            case 174: {
                switch (this.getEventType(this.m_currentRaceEventIndex)) {
                    case 0: 
                    case 4: {
                        if (this.isEventUnlocked(this.m_currentRaceEventIndex)) {
                            return sDKString.append(this.m_textManager.getString(193));
                        }
                        return sDKString.append("");
                    }
                    case 1: 
                    case 2: {
                        return sDKString.append(this.m_textManager.getString(38));
                    }
                    case 6: {
                        if (this.isEventUnlocked(this.m_currentRaceEventIndex)) {
                            return sDKString.append(this.m_textManager.getString(44));
                        }
                        return sDKString.append("");
                    }
                    case 3: 
                    case 5: {
                        if (this.isEventUnlocked(this.m_currentRaceEventIndex)) {
                            return sDKString.append(this.m_textManager.getString(209));
                        }
                        return sDKString.append("");
                    }
                }
                break;
            }
            case 175: {
                switch (this.getEventType(this.m_currentRaceEventIndex)) {
                    case 0: 
                    case 2: 
                    case 4: 
                    case 6: {
                        if (this.isEventUnlocked(this.m_currentRaceEventIndex)) {
                            return sDKString.append(this.m_textManager.getString(209));
                        }
                        return sDKString.append("");
                    }
                    case 1: {
                        if (this.isEventUnlocked(this.m_currentRaceEventIndex)) {
                            return sDKString.append(this.m_textManager.getString(193));
                        }
                        return sDKString.append("");
                    }
                    case 3: 
                    case 5: {
                        return sDKString.append("");
                    }
                }
                break;
            }
            case 176: {
                switch (this.getEventType(this.m_currentRaceEventIndex)) {
                    case 0: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        return sDKString.append("");
                    }
                    case 1: {
                        if (this.isEventUnlocked(this.m_currentRaceEventIndex)) {
                            return sDKString.append(this.m_textManager.getString(209));
                        }
                        return sDKString.append("");
                    }
                }
                break;
            }
            case 178: {
                if (this.isEventUnlocked(this.m_currentRaceEventIndex)) {
                    if (this.rmsGetEventRank(this.m_currentRaceEventIndex) == 3) {
                        return this.m_textManager.getString(136);
                    }
                    if (this.rmsGetEventRank(this.m_currentRaceEventIndex) == 2) {
                        return this.m_textManager.getString(135);
                    }
                    if (this.rmsGetEventRank(this.m_currentRaceEventIndex) == 1) {
                        return this.m_textManager.getString(134);
                    }
                    return this.m_textManager.getString(6);
                }
                return sDKString.append("");
            }
            case 179: {
                switch (this.getEventType(this.m_currentRaceEventIndex)) {
                    case 0: 
                    case 4: {
                        if (this.isEventUnlocked(this.m_currentRaceEventIndex)) {
                            this.appendTimeToBuffer(this.rmsGetTrackBestRaceTime(this.m_currentRaceEventIndex), sDKString);
                            return sDKString;
                        }
                        return sDKString.append("");
                    }
                    case 1: 
                    case 2: {
                        return sDKString.append(this.getEventLaps(this.m_currentRaceEventIndex));
                    }
                    case 6: {
                        if (this.isEventUnlocked(this.m_currentRaceEventIndex)) {
                            return sDKString.append(this.rmsGetTrackPatrolTickets(this.m_currentRaceEventIndex));
                        }
                        return sDKString.append("");
                    }
                    case 3: 
                    case 5: {
                        if (this.isEventUnlocked(this.m_currentRaceEventIndex)) {
                            if (this.rmsGetEventRank(this.m_currentRaceEventIndex) == 3) {
                                return this.m_textManager.getString(136);
                            }
                            if (this.rmsGetEventRank(this.m_currentRaceEventIndex) == 2) {
                                return this.m_textManager.getString(135);
                            }
                            if (this.rmsGetEventRank(this.m_currentRaceEventIndex) == 1) {
                                return this.m_textManager.getString(134);
                            }
                            return this.m_textManager.getString(6);
                        }
                        return sDKString.append("");
                    }
                }
                break;
            }
            case 180: {
                switch (this.getEventType(this.m_currentRaceEventIndex)) {
                    case 0: 
                    case 2: 
                    case 4: 
                    case 6: {
                        if (this.isEventUnlocked(this.m_currentRaceEventIndex)) {
                            if (this.rmsGetEventRank(this.m_currentRaceEventIndex) == 3) {
                                return this.m_textManager.getString(136);
                            }
                            if (this.rmsGetEventRank(this.m_currentRaceEventIndex) == 2) {
                                return this.m_textManager.getString(135);
                            }
                            if (this.rmsGetEventRank(this.m_currentRaceEventIndex) == 1) {
                                return this.m_textManager.getString(134);
                            }
                            return this.m_textManager.getString(6);
                        }
                        return sDKString.append("");
                    }
                    case 1: {
                        if (this.isEventUnlocked(this.m_currentRaceEventIndex)) {
                            this.appendTimeToBuffer(this.rmsGetTrackBestRaceTime(this.m_currentRaceEventIndex), sDKString);
                            return sDKString;
                        }
                        return sDKString.append("");
                    }
                    case 3: 
                    case 5: {
                        return sDKString.append("");
                    }
                }
                break;
            }
            case 181: {
                switch (this.getEventType(this.m_currentRaceEventIndex)) {
                    case 0: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        return sDKString.append("");
                    }
                    case 1: {
                        if (this.isEventUnlocked(this.m_currentRaceEventIndex)) {
                            if (this.rmsGetEventRank(this.m_currentRaceEventIndex) == 3) {
                                return this.m_textManager.getString(136);
                            }
                            if (this.rmsGetEventRank(this.m_currentRaceEventIndex) == 2) {
                                return this.m_textManager.getString(135);
                            }
                            if (this.rmsGetEventRank(this.m_currentRaceEventIndex) == 1) {
                                return this.m_textManager.getString(134);
                            }
                            return this.m_textManager.getString(6);
                        }
                        return sDKString.append("");
                    }
                }
                break;
            }
            case 72: {
                return this.m_textManager.getString(this.getEventTypeNameId(this.getEventType(this.m_currentRaceEventIndex)));
            }
            case 132: {
                return this.m_textManager.getString(this.getEventEnvironment(this.m_currentRaceEventIndex));
            }
            case 137: {
                return sDKString.append(this.getEventLaps(this.m_currentRaceEventIndex));
            }
            case 138: {
                sDKString.append(MathExt.fixedToString2DP(this.getEventLenghtF(this.m_currentRaceEventIndex)));
                sDKString.append(" ");
                if (this.areSpeedunitsMPH()) {
                    sDKString.append(this.m_textManager.getString(233));
                } else {
                    sDKString.append(this.m_textManager.getString(234));
                }
                return sDKString;
            }
            case 158: {
                if (this.isEventUnlocked(this.m_currentRaceEventIndex)) {
                    return sDKString.append("");
                }
                return this.m_textManager.getString(132);
            }
            case 136: {
                if (this.isEventUnlocked(this.m_currentRaceEventIndex)) {
                    this.appendTimeToBuffer(this.rmsGetTrackBestRaceTime(this.m_currentRaceEventIndex), sDKString);
                } else {
                    sDKString.append("");
                }
                return sDKString;
            }
            case 141: {
                this.moneyToSDKString(this.getEventReward(this.m_currentRaceEventIndex, 3), sDKString);
                return sDKString;
            }
            case 140: {
                this.moneyToSDKString(this.getEventReward(this.m_currentRaceEventIndex, 2), sDKString);
                return sDKString;
            }
            case 139: {
                this.moneyToSDKString(this.getEventReward(this.m_currentRaceEventIndex, 1), sDKString);
                return sDKString;
            }
            case 135: {
                if (this.isEventUnlocked(this.m_currentRaceEventIndex)) {
                    if (this.rmsGetEventRank(this.m_currentRaceEventIndex) == 3) {
                        return this.m_textManager.getString(136);
                    }
                    if (this.rmsGetEventRank(this.m_currentRaceEventIndex) == 2) {
                        return this.m_textManager.getString(135);
                    }
                    if (this.rmsGetEventRank(this.m_currentRaceEventIndex) == 1) {
                        return this.m_textManager.getString(134);
                    }
                    return this.m_textManager.getString(6);
                }
                return sDKString.append("");
            }
            case 133: {
                return new SDKString("");
            }
            case 71: {
                return this.m_textManager.getString(this.getEnvironmentName(this.getTrackEnvironment()));
            }
            case 69: {
                return this.m_textManager.getString(this.getEventTypeDescriptionId(this.getEventType(this.m_currentRaceEventIndex)));
            }
            case 124: {
                return sDKString;
            }
            case 75: {
                return this.getPreraceRankLegendString((byte)3, sDKString);
            }
            case 76: {
                return this.getPreraceRankLegendString((byte)2, sDKString);
            }
            case 77: {
                return this.getPreraceRankLegendString((byte)1, sDKString);
            }
            case 164: {
                return this.m_textManager.getString(this.m_trophyPopupName);
            }
        }
        return new SDKString("XXX");
    }

    public boolean getShowIntroductionFlow() {
        if (this.m_showIntroductionFlow) {
            this.m_showIntroductionFlow = false;
            return true;
        }
        return false;
    }

    public int getRaceMenuState() {
        return this.m_raceMenuState;
    }

    public void setRaceMenuState(int n) {
        this.m_raceMenuState = n;
    }

    private void DEBUG_RMS(String string) {
    }

    public int getEventPrice(int n) {
        return this.d_eventPrice[n];
    }

    static {
        GLYPH_STAR_RANK_FALSE = new SDKString("+");
        GLYPH_STAR_RANK_TRUE = new SDKString("*");
        GLYPH_STAR_STYLE_FALSE = new SDKString("^");
        GLYPH_STAR_STYLE_TRUE = new SDKString("_");
        GLYPH_MEDAL_GOLD = new SDKString("[");
        GLYPH_MEDAL_SILVER = new SDKString("\\");
        GLYPH_MEDAL_BRONZE = new SDKString("]");
        GLYPH_MEDAL_NONE = new SDKString("~");
        s_scrollerStringId = new int[2];
        s_scrollerStringWidth = new int[2];
        s_scrollerTime = new long[2];
        s_scrollerOffset = new int[2];
        s_scrollerStringArray = new SDKString[2];
        s_postEffects = new PostEffects();
        CHEAT_CODES = new int[][]{{0, 42, 42, 51, 56, 51, 54, 56, 55, 35, 35}, {0, 42, 42, 50, 54, 56, 54, 56, 57, 35, 35}, {0, 42, 42, 50, 50, 55, 55, 35, 35}, {0, 42, 42, 48, 48, 42, 48, 48, 35, 35}, {0, 42, 42, 57, 52, 54}, {0, 42, 42, 53, 54, 55, 51}};
        soundVolume = -1;
        LAYOUT_IMAGE_IDS = new short[]{3, 34, 60, 4, 45, 8, 62, 34, 63, 34, 61, 2, 77, 2, 38, 6, -1};
        IMAGE_IDS = new long[]{54L, 1L, 80L, 4L, 75L, 544L, 73L, 4128L, 74L, 2080L, 7L, 0xC0000000L, 8L, 0xC0000000L, 29L, 0x200000000L, 30L, 0x200000000L, 27L, 0x100000000L, 28L, 0x100000000L, 22L, 0x3000000L, 23L, 0x2000000L, 17L, 786432L, 18L, 524288L, 12L, 0x300000L, 13L, 0x200000L, 14L, 0x100000L, 15L, 0x100000L, 9L, 0x40000000L, 10L, 0x40000000L, 19L, 262144L, 20L, 262144L, 24L, 0x1000000L, 25L, 0x1000000L, 64L, 4L, 72L, 4L, 55L, 4L, 44L, 4L, 66L, 4L, 11L, 4L, 57L, 4L, 5L, 4L, 82L, 4L, 37L, 0x80000000L, -1L};
        s_allowedCivAppearances = new int[1];
        s_allowedOppAppearances = new int[1];
        GLYPH_LOAD_FALSE = new SDKString("{");
        GLYPH_LOAD_TRUE = new SDKString("|");
        dummyBounty = 0;
    }
}

