/*
 * Decompiled with CFR 0.152.
 */
package game;

import com.ea.sdk.SDKString;
import constants.FlowConstants;
import constants.ResourceConstants;
import constants.TrackSectionConstants;
import game.AppEngine;
import game.NonUniformSpline;
import game.Scene;
import game.SceneMenu;
import game.TrackObject;
import generic.AnimPlayer;
import generic.AnimationManager;
import generic.BoundingRectangle;
import generic.Cache;
import generic.FlowManager;
import generic.LayoutManager2;
import generic.MathExt;
import generic.ResourceManager;
import generic.TextManager;
import generic.generic2d.Transform;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

final class SceneGame
extends Scene
implements FlowConstants {
    private static final int[] s_tempInt4_1 = new int[4];
    private static final int[] s_tempInt4_2 = new int[4];
    private static final int[] s_tempInt4_3 = new int[4];
    private static final int[] s_tempInt4_4 = new int[4];
    private static final int[] s_tempInt2_1 = new int[2];
    public static final Transform s_tempTransform = new Transform();
    private static final int CAMERASHAKE_MAX_RANGE = 1966;
    private static final int BOOST_GAUGE_MAX = 0x640000;
    private static final int BOOST_DEPLETE_RATE = 1091829;
    private static final int BOOST_RESTORE_RATE = 36044;
    private static final int BOOST_MIN_USABLE_AMOUNT = 0x140000;
    public static final int BOOST_MAX_TIME = 196608;
    private static final int BOOST_FLASH_TIME = 1000;
    private static final int BOOST_FLASH_PERIOD = 200;
    private static final int DEFAULT_LATERAL_STEER_MAX = 131072;
    private static final int HWY_BATTLE_DISTANCE = 0x320000;
    private static final int HUD_ROLLON_SPEED = 0x460000;
    private static final int HUD_ROLLON_FAST_SPEED = 0xE60000;
    private static final int MINIMAP_ROLLON_SPEED = 0x1E0000;
    private static final int MINIMAP_ROLLON_FAST_SPEED = 0x780000;
    private static int HUD_STARTLIGHTS_POSITION_Y = 36;
    private static int HUD_NEEDLE_POSITION_X;
    private static int HUD_NEEDLE_POSITION_Y;
    private static int HUD_NEEDLESPEED_POSITION_X;
    private static int HUD_NEEDLESPEED_POSITION_Y;
    private static int HUD_SPEED_POSITION_X;
    private static int HUD_SPEED_POSITION_Y;
    private static int TRACK_VIEWPORT_HEIGHT;
    private static int HUD_LAPTIME_POSITION_Y;
    private static int HUD_UPPER_HORIZ_LINE_POSITION_Y;
    private static int HUD_MAP_LINE_POSITION_Y;
    private static int HUD_MAP_LINE_LEFT_POSITION_X;
    private static int HUD_MAP_LINE_RIGHT_POSITION_X;
    private static int HUD_NEEDLE_LENGTH_F;
    private static int HUD_NEEDLE_MIN_ANGLE_F;
    private static int HUD_NEEDLE_TOTAL_ANGLE_F;
    private static int HUD_NEEDLESPEED_LENGTH_F;
    private static int HUD_NEEDLESPEED_MIN_ANGLE_F;
    private static int HUD_NEEDLESPEED_TOTAL_ANGLE_F;
    private static int HUD_PURSUIT_BAR_ANIM_FRAMES;
    private static int HUD_PURSUIT_LEVEL_ICON_WIDTH;
    private static int HUD_PURSUIT_LEVEL_ICON_MARGIN;
    private static final int SOFTKEY_BAR_HEIGHT = 16;
    private static final int MAX_DRIFT_ROTATION = 51472;
    private static final int MAX_DRIFT_ROTATION_SPEED = 200;
    private static final int DRIFT_RECENTRE_ROTATION_SPEED = 80;
    public static final int LATERAL_DRIFT_FADE_RATE = 14745;
    public static final int LATERAL_DRIFT_ACCUMULATE_RATE = 49152;
    public static final int LATERAL_DRIFT_STEER_MULT = 52428;
    public static final int SPEED_DOWNSHIFT = 12;
    private static final int COLLISION_MINRANGE_X = 58982;
    private static final int COLLISION_MINRANGE_Z = 58982;
    public static final int NOCOLLISION_BEHIND_DIST = 196608;
    private static final int COLLISION_STEER_FACTOR = 45875;
    private static final int FIRST_EVENT_ID_WITH_SPIKES = 7;
    static final int KEY_SPEEDBREAKER = 4128;
    static final int KEY_BRAKE = 16640;
    static final int KEY_BOOST = 8196;
    static final int KEY_STEER_LEFT = 32784;
    static final int KEY_STEER_RIGHT = 65600;
    static final int KEY_USE_ROADBLOCK = 2;
    static final int KEY_USE_SPIKES = 8;
    private int m_timeCumulated;
    private int m_timeSinceLastCollision;
    private boolean m_driftBoosting;
    private int m_prevSpeed;
    public static final int PLAYER_COP_CAR_2D = 0;
    public static final int VIEW_DISTANCE_F = 655360;
    private static final int VIEW_DISTANCE_INVF;
    public static final int TRACK_WIDTH_MULTIPLIER_F = 52428;
    private static short[] TRACK1_WIDTHS;
    private static short[] TRACK1_OFFSETS;
    private static short[] TRACK2_WIDTHS;
    private static short[] TRACK2_OFFSETS;
    private static final int VIEW_OPPONENT_CAR_LOD1 = 394723;
    private static final int VIEW_OPPONENT_CAR_LOD2 = 274006;
    private static final int VIEW_OPPONENT_CAR_LOD3 = 202309;
    private static final int VIEW_OPPONENT_CAR_LOD4 = 153288;
    private static final int VIEW_OPPONENT_CAR_LOD5 = 116523;
    private static final int VIEW_OPPONENT_CAR_LOD6 = 86966;
    private static final int VIEW_OPPONENT_CAR_LOD7 = 61800;
    private static final int VIEW_OBJECT_LOD1 = 537591;
    private static final int VIEW_OBJECT_LOD2 = 458752;
    private static final int VIEW_OBJECT_LOD3 = 393216;
    private static final int VIEW_OBJECT_LOD4 = 327680;
    private static final int VIEW_OBJECT_LOD5 = 262144;
    private static final int VIEW_OBJECT_LOD6 = 196608;
    private static final int VIEW_OBJECT_LOD7 = 65536;
    private static final int MAX_VISIBLE_CAR_DISTANCE = 655360;
    private static final int CAMERA_DIST = 52428;
    private static final int ROAD_FACTOR = 131;
    private static final int CAMERA_PERSP_INVF;
    private static final int SCALE_ROAD_HEIGHT_F;
    private static int SCALE_HORIZON_F;
    private static int SCALE_INV_ROAD_F;
    private static final int ROAD_BEND_SHIFT_DOWN = 4;
    private static final int SLOPE_ARRAY_ENTRIES_MAX = 16;
    private static final int INTERP_LENGTH = 327680;
    public static final int CAR_COLLISION_SPARK_OFFSET_FRONT_Y = -12;
    public static final int CAR_COLLISION_SPARK_OFFSET_BACK_Y = -12;
    public static final int INDICATOR_OFFSET = 3;
    public static final int MAX_VISIBLE_HEALTH_DISTANCE = 602932;
    public static final int MAX_VISIBLE_MARKER_DISTANCE_A = 602932;
    public static final int MAX_VISIBLE_MARKER_DISTANCE_B = 301466;
    private static final short[] CAR_SPEEDLINES_ANIM_IDS;
    private static final short[] CAR_NITRO_ANIM_IDS;
    private static final short[] CAR_NITRO_ZONDA_ANIM_IDS;
    private static final short[] CAR_NITRO_KOENIGSEGG_ANIM_IDS;
    private static final short[] CAR_NITRO_PORSCHE_ANIM_IDS;
    private static final short[] CAR_NITRO_AUDI_R8_ANIM_IDS;
    private static final short[] CAR_NITRO_GALLARDO_ANIM_IDS;
    private static final short[] CAR_NITRO_MERCEDES_ANIM_IDS;
    private static final short[] CAR_SMOKE_ANIM_IDS;
    private static final short[] CAR_DUST_ANIM_IDS;
    private static final short[] COP_LIGHT_ANIM_IDS;
    private static final int[][] SKYGRADIENTS;
    private static final int INTRO_TRACK_HEIGHT_OFFSET_END = 62;
    private static final int INTRO_TRACK_HEIGHT_OFFSET_START = 10;
    private static final int OUTRO_DURATION = 4000;
    private int m_introDurationF;
    private static final int BOOST_SHAKE_SCALING_2D = 13;
    private static final int COLLISION_SHAKE_SCALING_2D = 13;
    private Image m_imgTrackPacked;
    private static final int PRIM_OFFROAD_COLOUR = 0;
    private static final int PRIM_OFFROAD_STARTY = 1;
    private static final int PRIM_OFFROAD_HEIGHT = 2;
    private static final int PRIM_OFFROAD_RECORD_COUNT = 3;
    private static final int PRIM_OFFROAD_MAX_BLOCKS = 16;
    private int[] m_primitiveOffroadBlocks;
    private int m_primitiveOffroadBlocksCount;
    private int m_primitiveOffroadBlockHeight;
    private int m_grassColourDark;
    private int m_grassColourLight;
    private int m_grassColourLast;
    private int[] m_slopeArrayDistanceF;
    private int[] m_slopeArraySlopeF;
    private int[] m_slopeSourceHeights;
    private int[] m_slopeDestYs;
    private int m_numSlopeSections;
    private int m_playerCarSlopeCurr;
    private int[] m_trackBendOffsets;
    private int m_currBendFactor;
    private int[] m_trackSectionSlope;
    private short[] m_trackSectionScenery;
    private int[] m_splineSectionIndex;
    private int m_currentStaticObjIndex;
    private int[] m_trackNodeSlope;
    private int m_prevStartSection = -1;
    private int m_prevEndSection = -1;
    private Image m_imgSkyline;
    private int m_renderCityOffsetXF = 0;
    private int m_firstCarRenderIndex = 0;
    private int m_currCarRenderIndex = 0;
    private int m_currStaticObjRenderIndex = 0;
    private int m_firstStaticObjRenderIndex = 0;
    private int[] m_perspectiveRangesF = null;
    private AnimPlayer m_playerCarAnimPlayer;
    private short[] m_carAnimIDs;
    private short[] m_carBrakeLightsAnimIDs;
    private int m_playerCarAnimId;
    private int m_carAngleLimit01F;
    private int m_carAngleLimit02F;
    private int m_carAngleLimit03F;
    private int m_carAngleLimit04F;
    private int m_raceIntroTotalTime;
    private int m_raceOutroTotalTime;
    private int m_raceIntroCameraOffsetF;
    private int m_viewPosF = 0;
    private int m_viewNode = 0;
    private boolean m_playerBumpedFront = false;
    private int m_playerImpactSparkX = 0;
    private int m_playerImpactSparkY = 0;
    private AnimPlayer m_playerImpactSparkAnimPlayer;
    private AnimPlayer m_smokeAnimPlayer;
    private AnimPlayer m_dustAnimPlayer;
    private AnimPlayer m_speedLinesAnimPlayer;
    private AnimPlayer m_nitroAirburstAnimPlayer;
    private AnimPlayer m_slipstreamAnimPlayer;
    private AnimPlayer m_brakeLightsAnimPlayer;
    private AnimPlayer m_boostAnimPlayer;
    private short m_crashLeftAnimID;
    private short m_crashRightAnimID;
    private static int VIEWPORT_LEFT;
    private static int VIEWPORT_TOP;
    private static int VIEWPORT_WIDTH;
    private static int VIEWPORT_HEIGHT;
    private static int VIEWPORT_CENTRE_X;
    private static final short WRAPWIDTH_CONFIRM = 145;
    private static final short WRAPWIDTH_EVENT_DESCRIPTION = 145;
    private static final byte TUTORIAL_STATE_NONE = 0;
    private static final byte TUTORIAL_STATE_ACCELERATION = 1;
    private static final byte TUTORIAL_STATE_ACCELERATION_POST = 2;
    private static final byte TUTORIAL_STATE_BRAKE = 3;
    private static final byte TUTORIAL_STATE_BRAKE_POST = 4;
    private static final byte TUTORIAL_STATE_STEERING = 5;
    private static final byte TUTORIAL_STATE_STEERING_POST = 6;
    private static final byte TUTORIAL_STATE_TRAFFIC = 7;
    private static final byte TUTORIAL_STATE_TRAFFIC_POST = 8;
    private static final byte TUTORIAL_STATE_SPEEDBREAKER = 9;
    private static final byte TUTORIAL_STATE_SPEEDBREAKER_POST = 10;
    private static final byte TUTORIAL_STATE_NITRO = 11;
    private static final byte TUTORIAL_STATE_NITRO_POST = 12;
    private static final byte TUTORIAL_STATE_NITRO_GAIN = 13;
    private static final byte TUTORIAL_STATE_NITRO_GAIN_POST = 14;
    private static final byte TUTORIAL_STATE_PURSUIT = 15;
    private static final byte TUTORIAL_STATE_PURSUIT_POST = 16;
    private static final byte TUTORIAL_STATE_PURSUIT2 = 17;
    private static final byte TUTORIAL_STATE_PURSUIT2_POST = 18;
    private static final byte TUTORIAL_STATE_PURSUIT_LOSE = 19;
    private static final byte TUTORIAL_STATE_PURSUIT_LOSE_POST = 20;
    private static final byte TUTORIAL_STATE_ROADBLOCKS = 21;
    private static final byte TUTORIAL_STATE_ROADBLOCKS_POST = 22;
    private static final byte TUTORIAL_STATE_COP_TIME = 23;
    private static final byte TUTORIAL_STATE_COP_INTRO = 24;
    private static final byte TUTORIAL_STATE_COP_INTRO_POST = 25;
    private static final byte TUTORIAL_STATE_COP_SAFETY = 26;
    private static final byte TUTORIAL_STATE_COP_SAFETY_POST = 27;
    private static final byte TUTORIAL_STATE_COP_PURSUIT = 28;
    private static final byte TUTORIAL_STATE_COP_PURSUIT_POST = 29;
    private static final byte TUTORIAL_STATE_COP_RAM = 30;
    private static final byte TUTORIAL_STATE_COP_RAM_POST = 31;
    private static final byte TUTORIAL_STATE_COP_ROADBLOCK = 32;
    private static final byte TUTORIAL_STATE_COP_ROADBLOCK_POST = 33;
    private static final byte TUTORIAL_STATE_COP_SPIKES = 34;
    private static final byte TUTORIAL_STATE_COP_SPIKES_POST = 35;
    private static final byte TUTORIAL_STATE_COP_BUST = 36;
    private static final byte TUTORIAL_STATE_COP_BUST_POST = 37;
    private static final byte TUTORIAL_STATE_COP_END = 38;
    private int m_tutorialState;
    private boolean m_tutorialBoostUsed;
    private static final int TUTORIAL_COP_DIST_FOR_NOTIFICATION = 589824;
    private TrackObject m_tutorialCop;
    private TrackObject m_tutorialCriminal;
    private TrackObject m_lastBlockade;
    private static final int TUTORIAL_FINISH_OVERSHOOT = 655360;
    private static final int TUTORIAL_FINISH_ACCURACY = 327680;
    private int m_tutorialFinishPos;
    private static final int TUTORIAL_BOOST_GAIN_REQUIRED = 786432;
    private int m_tutorialBoostToGain;
    private static final int TUTORIAL_RAMMING_PURSUIT_REQUIRED = 0x140000;
    private int m_tutorialStage;
    private final int TUTORIAL_RACER_STAGE_COUNT;
    private final int TUTORIAL_COP_STAGE_COUNT;
    private boolean m_eventTutorialShown;
    public static final int DAYTIME_DAY = 0;
    public static final int DAYTIME_NIGHT = 1;
    private int m_event;
    private int m_eventType;
    private byte m_numTrackSections;
    private byte m_trackFlags;
    private int m_trackStartLineDistF;
    private int m_trackStartLineSection;
    private int m_trackFinishLineDistF;
    private int m_trackFinishLineSection;
    private static final int SPEED_CAMERA_TIMER_NUMERATOR = 200;
    private static final int SPEED_CAMERA_TRIGER_DIST = 131072;
    private static final int SPEED_CAMERA_NOTIFY_DIST = 655360;
    private static final int SPEED_CAMERA_COOL_WORDING_DIST = 0x140000;
    private int[] m_speedCameraIndexes;
    private int[] m_speedCameraSpeeds;
    private int[] m_speedCameraSpeedsTrackOrder;
    private int m_speedCamerasPassed;
    private int m_speedCameraFlashTimer = 0;
    private int m_playerCarMovementDirF;
    private int m_playerCarFacingDirF;
    private int m_cameraTraceObjectMovementDirF;
    private static final byte BBOX_LEFT = 0;
    private static final byte BBOX_BACK = 1;
    private static final byte BBOX_RIGHT = 2;
    private static final byte BBOX_FRONT = 3;
    private int[] m_carCollisionBB1 = new int[4];
    private int[] m_carCollisionBB2 = new int[4];
    private int[] m_cameraShakeOffset = new int[]{0, 0, 0};
    private TrackObject m_cameraTraceObject;
    private TrackObject m_playerCar;
    private TrackObject[] m_trackObjects;
    private static final byte TRACK_OBJ_ANIMID = 0;
    private static final byte TRACK_OBJ_ONLYPRIMITIVES = 1;
    private static final byte TRACK_OBJ_SPLINEPOS = 2;
    private static final byte TRACK_OBJ_LATERALPOS = 3;
    private static final byte TRACK_OBJ_RENDERSRCY = 4;
    private static final byte TRACK_OBJ_RENDERCLIPY = 5;
    private static final byte TRACK_OBJ_RENDERDISTF = 6;
    private static final byte TRACK_OBJ_RENDERPOSX = 7;
    private static final byte TRACK_OBJ_RENDERPOSY = 8;
    private static final byte TRACK_OBJ_TRACKSECTION = 9;
    private static final byte TRACK_OBJ_NUMVARS = 10;
    private int[][] m_staticTrackObjects;
    private TrackObject[] m_carsTrackOrder;
    private TrackObject[] m_carsRaceOrder;
    private TrackObject m_copAhead;
    private TrackObject m_copBehind;
    private TrackObject m_racerAhead;
    private TrackObject m_racerBehind;
    private int m_playerLeadDistance;
    private int m_boostGaugeLevelF;
    private boolean m_playerIsBoosting;
    private int m_posBeforeBoost;
    private int m_boostFlashTime;
    private int m_bestLapTime;
    private byte m_raceMaxLaps;
    private int m_biggestDriftScore;
    private static final int LAP_DISPLAY_TIME = 2500;
    private static final int LAP_DISPLAY_TIME_FIN = 2000;
    private int m_lapDisplayTime;
    private int m_lastLapTime;
    private boolean m_cleanRace;
    private boolean m_cleanOvertake;
    private int m_playerTimeInLead;
    private int m_profileAggression;
    private int m_profilePrecision;
    private int m_profileAggressionMultiplier;
    private int m_profileAggressionMultiplierTime;
    private TrackObject m_profileAggressionOpponent;
    private static final int PROFILE_AGGRESSION_MULTIPLIER_TIMEOUT = 5000;
    private NonUniformSpline m_trackRailSpline;
    private BoundingRectangle[] m_trackBoundingBoxes;
    private int[] m_objectRefXs;
    private int[] m_objectRefZs;
    private short[] m_objectRefSections;
    private byte[] m_objectRefTypes;
    private boolean[] m_objectRefSpawned;
    private static final int HISPEED_STYLEPOINTS = 20;
    private int m_takeoutTimer;
    private static final int MIN_AVG_SPEED_BONUS = 573440;
    private int m_playerCarSteeringAngleF;
    private int m_playerCarSteeringOffsetF;
    private int m_playerCarDriftingAngleCurrentF;
    private int m_playerCarTyresF;
    private int m_playerCarTyresInvF;
    private int m_playerCarSteeringIncF;
    private int m_playerCarSteeringMaxF;
    private int m_playerCarSteeringRecentreIncF;
    private int m_playerCarSteeringPowerF;
    private static final int STEERING_POWER_INC = 65536;
    private int[] m_playerCarLowRevSpeedsF;
    private int[] m_playerCarRevDivsF;
    private int m_playerCarLateralDriftF;
    private int m_steeringFlags;
    public static final int STEERING_LEFT = 1;
    public static final int STEERING_RIGHT = 2;
    private int[] m_tempFirepoint = new int[2];
    private short[] m_loadingStatLabels;
    private SDKString[] m_loadingStatValues;
    private int m_driftScoreThisRace;
    private static int[][] s_tempInt4x4;
    private static final int MAX_PURSUERS = 4;
    private int m_pursuerCount;
    private short m_copCrashCounter;
    public static final int PURSUIT_BUSTED_LEVEL = 0x640000;
    public static final int PURSUIT_MAX_TUTORIAL_LEVEL = 0x5A0000;
    public static final int PURSUIT_ALARM_LEVEL = 0x4B0000;
    public static final int PURSUIT_GO_AWAY_LEVEL = -6553600;
    private static final int PURSUIT_MINIMUM_LEVEL = -5898240;
    private static final int PURSUIT_PLAYER_RISE_SPEED = 393216;
    private static final int PURSUIT_CRIMINAL_RISE_SPEED = 0x140000;
    private static final int PATROL_CRIMINAL_RISE_SPEED = 0x230000;
    public static final int PATROL_HIT_RISE = 0x280000;
    public static final int PURSUIT_HIT_RISE = 0x120000;
    private static final int PURSUIT_SIDE_HIT_RISE = 0x230000;
    private static final int PURSUIT_HIT_COOLDOWN_TIME = 500;
    public static final int PURSUIT_CRIMINAL_CONTACT_DISTANCE = 262144;
    public static final int PURSUIT_CRIMINAL_FAR_DISTANCE = 655360;
    public static final int PATROL_CRIMINAL_CONTACT_DISTANCE = 655360;
    public static final int PATROL_CRIMINAL_FAR_DISTANCE = 0x140000;
    private static final int PURSUIT_CRIMINAL_CONTACT_DECREASE_SPEED = 6553;
    private static final int PURSUIT_CRIMINAL_FAR_DECREASE_SPEED = 262144;
    private static final int PATROL_CRIMINAL_CONTACT_DECREASE_SPEED = 0;
    private static final int PATROL_CRIMINAL_FAR_DECREASE_SPEED = 983040;
    public static final int PURSUIT_PLAYER_CONTACT_DISTANCE = 524288;
    public static final int PURSUIT_PLAYER_FAR_DISTANCE = 786432;
    public static final int PURSUIT_PLAYER_AWAY_DISTANCE = 0x120000;
    private static final int PURSUIT_PLAYER_CONTACT_DECREASE_SPEED = 0;
    private static final int PURSUIT_PLAYER_FAR_DECREASE_SPEED = 0x100000;
    private static final int PURSUIT_LEVEL_FLASH_DELAY = 300;
    private static final int PURSUIT_LEVEL_DISPLAY_DELAY = 3000;
    private int m_pursuitLevel = 0;
    private int m_pursuitLevelFlashTimer = 0;
    private int m_pursuitLevelDelayTimer = 0;
    private short m_copHeatLevel;
    private static final short HEAT_LEVEL_0 = 0;
    private static final short HEAT_LEVEL_1 = 1;
    private static final short HEAT_LEVEL_2 = 2;
    private static final short HEAT_LEVEL_3 = 3;
    private short m_costToState;
    private SDKString m_stringBufferCostToState;
    private int m_numObjectsDestroyed;
    private static int LOADING_BAR_OFFSET;
    private TrackObject[] m_pursuers = new TrackObject[4];
    private int musicID = -1;
    private static final int MAX_UPDATE_LOADING_TIME = 64;
    private long m_loadMask;
    private int m_updateLoadingTime;
    private int m_loadedAnimImages;
    private int m_loadingState;
    private static final int LOADING_INIT = 0;
    private static final int LOADING_INIT_3D = 1;
    private static final int LOADING_TRACK = 2;
    private static final int LOADING_POST_TRACK = 3;
    private static final int LOADING_ANIMS = 4;
    private static final int LOADING_IMAGES = 5;
    private static final int LOADING_CARS = 6;
    private static final int LOADING_CHASSIS_FX = 7;
    private static final int LOADING_WHEEL_FX = 8;
    private static final int LOADING_SKYDOME = 9;
    private static final int LOADING_SETUP = 10;
    private static final int LOADING_SOUND = 11;
    private static final int LOADING_PRE_FINISHED = 12;
    private static final int LOADING_FINISHED = 13;
    private int m_nitroLevel;
    private boolean m_interrupted;
    private boolean m_refreshViewport;
    private boolean m_raceOutroFinished = false;
    private static final byte STARTLIGHTS_STATE_NONE = -1;
    private static final byte STARTLIGHTS_STATE_SLIDEIN = 0;
    private static final byte STARTLIGHTS_STATE_IN = 1;
    private static final byte STARTLIGHTS_STATE_SLIDEOUT = 2;
    private static final int STARTLIGHTS_SLIDE_TIME = 1250;
    private byte m_startLightsState = (byte)-1;
    private AnimPlayer m_startLightsAnimPlayer;
    private AnimPlayer m_policeMarkAnimPlayer;
    private AnimPlayer m_minimapBlinking;
    private int m_startLightsTimer;
    private static final int[] BB_CONSTRUCTION_BARRIER;
    private static final int[] BB_DUMPSTER;
    private int m_collisionShakeTime;
    private int m_collisionShakeRange;
    private static final int COLLISION_SHAKE_TIME = 32768;
    private static final int COLLISION_SHAKE_MAXRANGE = 3276;
    public static final int COLLISION_SHAKE_TOPSPEED = 491520;
    public static final int COLLISION_SHAKE_TOPSPEED_INV = 8738;
    private final int PERSONALITY_SPEED_THRESHOLD_F;
    private final int PERSONALITY_SPEED_THRESHOLD_OFF_F;
    private boolean m_playerPersonalitySpeeding;
    private boolean isHardTurnSoundPlayed = false;
    private int lastCarDriftAngleF = 0;
    public static final int LOW_STEERING_THRESH = 122880;
    private boolean m_beingBlocked;
    private static final int COLLISION_STEER_AMOUNT = 98304;
    private static final int COLLISION_COPBASH_AMOUNT = 117964;
    private static final int COLLISION_STEER_RECENTER = 39321;
    private static final int CORNER_SMOKE_SPEED = 368640;
    private static final int CORNER_CALIB_SPEED = 442368;
    private static final int CORNER_CALIB_SPEED_INV = 9709;
    private static final int[] CORNER_VALUES;
    private static final int RACEGRID_LATPOS_START = 26214;
    private static final int RACEGRID_LATPOS_SPACING = 52428;
    private static final int RACEGRID_ROWPOS_SPACING = 78643;
    private static final int TRAFFIC_SPAWN_MIN_DISTANCE = 786432;
    private static final int TRAFFIC_SPAWN_MAX_DISTANCE = 5324800;
    private static final int TRAFFIC_SPAWN_MIN_DELAY = 4000;
    private static final int TRAFFIC_SPAWN_MAX_DELAY = 15000;
    public static final int TRAFFIC_AHEAD_DIST = 655360;
    public static final int TRAFFIC_BEHIND_DIST = 458752;
    private static final int TRAFFIC_SPAWN_CLEAR = 131072;
    private static final int LAT_TRAFFIC_AHEAD_DIST = 655360;
    private static final int TRAFFIC_SLOW_PLAYER = 163840;
    private int m_trafficDensityScaleF;
    private int m_trafficMax;
    private int m_trafficDensityScaleInvF;
    private int m_trafficFlagsEvent;
    private int m_trafficFlagsCurr;
    private int m_aheadLeftTrafficTimer;
    private int m_aheadRightTrafficTimer;
    private int m_aheadLeftTrafficDistance;
    private int m_aheadRightTrafficDistance;
    private boolean m_proxToAheadSpawn;
    private boolean m_proxToBehindSpawn;
    private int m_aheadCopSpawnDistance;
    private int m_aheadCopDistanceMin;
    private int m_aheadCopDistanceMax;
    private int m_copCount;
    private int m_copTrapPatrolsRatioF;
    private int m_copTrapsSpawned;
    private int m_copPatrolsSpawned;
    private static final int MAX_LAT_TRAFFIC = 1;
    private int m_civilianCount;
    private int m_latCivilianCount;
    private int m_racerCount;
    private TrackObject m_pursuedCar;
    private int m_lasSpawnedRaceAppearane = -1;
    private int m_stopPursuitTimer = -1;
    private int m_nextRespawnTimer;
    private int m_patrolTimeLeft;
    private int m_patrolCriminalsCaught;
    private static final int PATROL_TIME_TO_STOP_PURSUIT = 1500;
    private static final int PATROL_TIME_TO_SPAWN_MIN = 1000;
    private static final int PATROL_TIME_TO_SPAWN_MAX = 5000;
    private static final int PATROL_DISTANCE_TO_SPAWN_MIN = 655360;
    private static final int PATROL_DISTANCE_TO_SPAWN_MAX = 0x280000;
    public static final int PATROL_DEFAULT_TIME = 240000;
    private int m_endRaceLeadDistance;
    private final int SCREEN_WIDTH;
    private final int SCREEN_HEIGHT;
    private static final int COLLISION_CHECK_AHEAD_N = 3;
    private static final int PROXIMITY_CHECK_AHEAD_N = 3;
    private static final int PROXIMITY_RANGE = 419430;
    private static final int PROXIMITY_RANGE_BEHIND = -58982;
    private static final int PROXIMITY_LAT = 52428;
    private static final int CLOSE_CALL_MIN_SPEED_F = 393216;
    private static final int CLOSE_CALL_MINDIST_X_F = 45875;
    private static final int CLOSE_CALL_MINDIST_Z_F = 19660;
    private static final int NEAR_MISS_MIN_SPEED_F = 393216;
    private static final int NEAR_MISS_COOLDOWN_TIME = 500;
    private static final int COLLISION_COOLDOWN_TIME = 250;
    private int m_nearMissTimer;
    private static final int SMALLEST_FLIP_SPEED = 491520;
    private static final int TINY_BUMP_F = 65536;
    private static final int SMALL_BUMP_F = 131072;
    private static final int MED_BUMP_F = 319815;
    private int m_collisionSteer;
    private static final int HUD_SMALL_VIEWPORT_HEIGHT = 10;
    private int m_hudRightEdgeOffsetF;
    private int m_hudLeftEdgeOffsetF;
    private static final int HUD_DIMENSIONS_X = 0;
    private static final int HUD_DIMENSIONS_Y = 1;
    private static final int HUD_DIMENSIONS_W = 2;
    private static final int HUD_DIMENSIONS_H = 3;
    private static final int HUD_DIMENSIONS_C = 4;
    private static final int MINIMAP_W = 45;
    private int[] m_hudNitroIconDim = new int[4];
    private int[] m_hudSpeedoDim = new int[4];
    private static final int HUD_LAP_TIME = 4000;
    private int m_hudLapTimer = 4000;
    private static int HUD_LAPS_X;
    private static int HUD_LAPS_Y;
    private static int HUD_LAPS_KO_W;
    private static final int HE_MAP = 1;
    private static final int HE_NITRUS_FLASH = 2;
    private static final int HE_BRAKE_ICON = 4;
    private static final int HE_NOS_ICON = 8;
    private static final int HE_TACHO = 16;
    private static final int HE_TACHO_NEEDLE = 32;
    private static final int HE_TACHO_NEEDLE_COVER = 64;
    private static final int HE_SPEED = 128;
    private static final int HE_EVENT_PROGRESS = 512;
    private static final int HE_NOS_LEVEL = 1024;
    private static final int HE_DRIFT_BAR = 2048;
    private static final int HE_BUSTESCAPE_MSG = 8192;
    private static final int HE_NOTIFY_BOX = 32768;
    private static final int HE_SOFTKEYBAR = 131072;
    private static final int HE_SOFTKEYS = 262144;
    private static final int HE_TUT_COUNT = 524288;
    private static final int HE_COP_TIMER = 0x100000;
    private static final int HE_EMPTYHUD = 0x200000;
    private static final int HE_ALL = -1;
    private int m_hudRedrawFlags;
    private int m_hudText;
    private int m_hudInd;
    private boolean m_hudPauseStopMusic;
    private boolean m_wasPaused = false;
    private final SDKString m_stringBufferCoolWordingText = new SDKString(32, 0);
    private int m_coolWordingBoxTime;
    private static final int COOLWORDING_BOX_TIME = 3000;
    private final SDKString m_stringBufferNotifyText = new SDKString(32, 0);
    private int m_notifyBoxTime;
    private static final int NOTIFY_BOX_TIME = 3000;
    private SDKString m_copRewardMessage = new SDKString(32, 0);
    private final int HUD_CARPOS_Y_STEP;
    private int m_lastRank;
    private static final int SPEED_BOX_EDGE = 9;
    private static final int SPEEDBOX_FILLTYPE_NONE = 0;
    private static final int SPEEDBOX_FILLTYPE_CLEAR = 1;
    private static final int SPEEDBOX_FILLTYPE_FLASH = 2;
    private static final int STYLEPOINTS_TYPE_DRIFT = 1;
    private static final int STYLEPOINTS_TYPE_HISPEED = 2;
    private static final int SCORE_STATE_NONE = 0;
    private static final int SCORE_STATE_PAUSED = 1;
    private static final int SCORE_STATE_PLAYING = 2;
    private static final int SCORE_STATE_FAIL = 3;
    private static final int SCORE_TYPE_NONE = 0;
    private static final int SCORE_TYPE_MONEY = 1;
    private static final int SCORE_TYPE_POINTS = 2;
    private static final int SCORE_TYPE_PRECISION = 3;
    private static final int SCORE_TYPE_AGGRESSION = 4;
    private int m_scoreState;
    private int m_scoreTime;
    private int m_scoreTotal;
    private int m_scoreType;
    private static final int SPEEDBREAKER_DISPLAY_TIME = 1000;
    private static final int SPEEDBREAKER_MIN_SPEED = 163840;
    private static final int SPEEDBREAKER_GAUGE_MAX = 0x640000;
    private static final int SPEEDBREAKER_DEPLETE_RATE = 1835;
    private static final int SPEEDBREAKER_RESTORE_RATE = 3276;
    private static final int SPEEDBREAKER_MIN_USABLE_AMOUNT = 0x190000;
    private boolean m_speedBreakActivated;
    private int m_speedBreakDisplayTime = -1;
    private int m_speedBreakLevelF = 0x640000;
    private int m_speedBrakeDivF;
    private static final int TUTORIAL_ACC_SUCCESS_SPEED = 409600;
    private static final int TUTORIAL_BRAKE_SUCCESS_SPEED = 245760;
    private static final int TUTORIAL_STATECHANGE_DELAY = 2000;
    private static final int TUTORIAL_INFO_DELAY = 2000;
    private static final int TUTORIAL_STATE_DELAY = 5000;
    private static final int TUTORIAL_ENEMY_SPAWN_DIST = 327680;
    private static final int TUTORIAL_CIVILIANS_SPAWN_DIST = 131072;
    private static final int TUTORIAL_OPPONENT_APP = 0;
    private boolean m_tutorialKeyPressed;
    private int m_tutorialStateTimer;
    private TrackObject m_tutorialEnemy;
    private int m_tutorialMessage;
    private int m_tutorialMessageYF;
    private int m_tutorialMessageState;
    private int m_tutorialMessageNext;
    private static int HUD_STYLE_STARS_DURATION;
    private static int HUD_STYLE_STARS_PERIOD;
    private int m_hudMedalFlashTime;
    private int m_careerBountyReward;
    private int m_careerExtraBounty;
    private static final int PERSONALITY_ACTION_DRIFT = 1;
    private static final int PERSONALITY_ACTION_BUMP = 2;
    private static final int PERSONALITY_ACTION_CLEAN_LAP = 3;
    private static final int PERSONALITY_ACTION_CLEAN_OVERTAKE = 4;
    private static final int PERSONALITY_ACTION_RACING_LINE = 5;
    private static final int PERSONALITY_ACTION_CLOSE_CALL = 6;
    private static final int PERSONALITY_ACTION_SPEED = 7;
    private static final int PERSONALITY_ACTION_BOOST = 8;
    public static final int TRACK_EVENT_NEAR_MISS = 1;
    public static final int TRACK_EVENT_DESTROY_OBSTACLE = 2;
    public static final int TRACK_EVENT_DESTROY_BARRICADE = 3;
    public static final int TRACK_EVENT_TRAFFIC_HIT = 4;
    public static final int TRACK_EVENT_CRUISER_TOTALED = 5;
    public static final int TRACK_EVENT_OPPONENT_HIT = 6;
    public static final int TRACK_EVENT_CRIMINAL_BUSTED = 7;
    private static final int NOS_INCREASE_OBSTACLE_DESTROYED = 327680;
    private static final int NOS_INCREASE_CRUISER_TOTALED = 0x320000;
    private static final int NOS_INCREASE_BARRICADE_DESTROYED = 0x140000;
    private static final int NOS_INCREASE_NEAR_MISS = 655360;
    private static final int NOS_INCREASE_CRIMINAL_BUSTED = 0x640000;
    private static final int SCORE_INCREASE_NEAR_MISS = 10;
    private static final int SCORE_INCREASE_CRUISER_TOTALED = 500;
    private static final int SCORE_INCREASE_BARRICADE_DESTROYED = 50;
    private static final int SCORE_INCREASE_OPPONENT_HIT = 20;
    private SDKString m_personalityMessage;
    private int m_racingLineCurvature;
    private int m_racingLineState;
    private int m_racingLineTimeInside;
    private int m_racingLineTimeOutside;
    private final int RACING_LINE_STATE_FAIL;
    private final int RACING_LINE_STATE_OK;
    private int m_resultStringID;
    private int[][] m_resultStats;
    private boolean isBusted;
    private static final SDKString SDK_BAD_TEXT;
    private static final SDKString SDK_SPACE;
    private static final SDKString SDK_SLASH;
    private int m_menuHighlightFlashTimeout;
    private boolean m_menuHighlightActivatingSelection;
    private static final int MENU_HIGHLIGHT_FLASH_PERIOD = 100;
    private static final int MENU_HIGHLIGHT_FLASH_DURATION = 600;

    private final void loadTrackWidthsAndOffsets() {
        try {
            InputStream inputStream = this.m_engine.getResourceManager().loadBinaryFile(78);
            DataInputStream dataInputStream = new DataInputStream(inputStream);
            int n = dataInputStream.readByte();
            block8: for (int i = 0; i < n; ++i) {
                short[] sArray = new short[64];
                for (int j = 0; j < 64; ++j) {
                    sArray[j] = dataInputStream.readShort();
                }
                switch (i) {
                    case 0: {
                        TRACK1_WIDTHS = sArray;
                        continue block8;
                    }
                    case 1: {
                        TRACK1_OFFSETS = sArray;
                        continue block8;
                    }
                    case 2: {
                        TRACK2_WIDTHS = sArray;
                        continue block8;
                    }
                    case 3: {
                        TRACK2_OFFSETS = sArray;
                    }
                }
            }
        }
        catch (IOException iOException) {
            AppEngine.debug("Failed loadTrackWidthsAndOffsets()");
        }
    }

    public int getDayTime() {
        return 1 == this.m_engine.getEventNightMode(this.m_engine.getCurrentRaceEventIndex()) ? 1 : 0;
    }

    public final int getEventType() {
        return this.m_eventType;
    }

    public final byte getTrackFlags() {
        return this.m_trackFlags;
    }

    public final int getPlayerCarSteeringOffset() {
        return this.m_playerCarSteeringOffsetF;
    }

    private final void updateSteeringPower(int n) {
        int n2 = n << 6;
        int n3 = this.m_playerCarSteeringPowerF;
        if (this.isSteering(1)) {
            if (n3 > 0) {
                n3 = 0;
            }
            n3 -= MathExt.mulF(65536, n2);
        } else if (this.isSteering(2)) {
            if (n3 < 0) {
                n3 = 0;
            }
            n3 += MathExt.mulF(65536, n2);
        } else {
            n3 = 0;
        }
        this.m_playerCarSteeringPowerF = n3;
    }

    public final int getPlayerCarSteeringPower() {
        return this.m_playerCarSteeringPowerF;
    }

    public final boolean isDriftBoosting() {
        return this.m_driftBoosting;
    }

    public final boolean isSteering(int n) {
        int n2 = n == 1 ? 2 : 1;
        return (this.m_steeringFlags & n) != 0 && (this.m_steeringFlags & n2) == 0;
    }

    public void increasePursuitLevel(int n) {
        this.m_pursuitLevel += n;
        this.setPursuitLevel(this.m_pursuitLevel);
    }

    public void decreasePursuitLevel(int n) {
        this.increasePursuitLevel(-n);
    }

    public int getPursuitLevel() {
        return this.m_pursuitLevel;
    }

    private void startDramaticCrash() {
        this.m_playerCar.startDramaticCrash(11);
        this.m_engine.updateTrophyData(8192);
    }

    void startPlayerPursuit(TrackObject trackObject) {
        this.m_playerCar.initCopLights();
        this.m_playerCar.setFlags(0x200000);
        trackObject.setFlags(32);
        this.m_pursuedCar = trackObject;
        this.setPursuitLevel(0);
        this.m_pursuitLevelFlashTimer = 0;
    }

    public final void startPursuit(TrackObject trackObject) {
        boolean bl = false;
        if (this.m_pursuerCount < 4) {
            for (int i = 0; i < 4; ++i) {
                if (this.m_pursuers[i] != null) continue;
                this.m_pursuers[i] = trackObject;
                ++this.m_pursuerCount;
                bl = true;
                break;
            }
        }
        if (!bl) {
            return;
        }
        if (this.m_pursuitLevel < 0 || this.m_pursuerCount == 1) {
            this.setPursuitLevel(0);
            this.m_pursuitLevelFlashTimer = 0;
        }
    }

    public final void stopPursuit(TrackObject trackObject) {
        for (int i = 0; i < 4; ++i) {
            if (this.m_pursuers[i] != trackObject) continue;
            this.m_pursuers[i] = null;
            --this.m_pursuerCount;
            break;
        }
    }

    void stopPursuit() {
        for (int i = 0; i < 4; ++i) {
            if (this.m_pursuers[i] == null) continue;
            this.m_pursuers[i].destroy();
            this.m_pursuers[i] = null;
        }
        this.m_pursuerCount = 0;
        this.m_copTrapsSpawned = 0;
        this.m_copPatrolsSpawned = 0;
        this.m_trafficFlagsCurr = this.m_trafficFlagsEvent;
        this.setCustomMessageText(257, true);
    }

    public final TrackObject[] getPursuers() {
        return this.m_pursuers;
    }

    public final int getPursuersCount() {
        return this.m_pursuerCount;
    }

    public final void dumpPursuers() {
    }

    public final short getCopHeatLevel() {
        return (short)this.getPursuersCount();
    }

    public SceneGame(AppEngine appEngine, TextManager textManager, FlowManager flowManager, LayoutManager2 layoutManager2) {
        super(appEngine, textManager, flowManager, layoutManager2);
        this.TUTORIAL_RACER_STAGE_COUNT = 8;
        this.TUTORIAL_COP_STAGE_COUNT = 5;
        this.PERSONALITY_SPEED_THRESHOLD_F = 589824;
        this.PERSONALITY_SPEED_THRESHOLD_OFF_F = 65536;
        this.SCREEN_WIDTH = 176;
        this.SCREEN_HEIGHT = 208;
        this.HUD_CARPOS_Y_STEP = 10;
        this.RACING_LINE_STATE_FAIL = -1;
        this.RACING_LINE_STATE_OK = 0;
        this.m_eventType = appEngine.getCurrentEventType();
        this.m_event = this.m_engine.getCurrentRaceEventIndex();
        this.m_raceMaxLaps = appEngine.getNextRaceNumLaps();
        this.m_trackFlags = appEngine.getTrackFlags(appEngine.getCurrentTrack());
        this.m_speedBrakeDivF = MathExt.divF(65536, 0x640000);
        this.m_trackRailSpline = new NonUniformSpline();
        if (this.m_trackObjects == null) {
            TrackObject[] trackObjectArray = new TrackObject[30];
            for (int i = 0; i < 30; ++i) {
                trackObjectArray[i] = new TrackObject(this);
                trackObjectArray[i].setID(i);
            }
            this.m_trackObjects = trackObjectArray;
            this.m_carsTrackOrder = new TrackObject[30];
        }
        this.setPursuitLevel(0);
        this.initDisplayDimensionsAndOffsets();
    }

    public void start(int n) {
        this.m_flowManager.transition(45);
    }

    private final int getEventMusic() {
        if (this.musicID != -1) {
            return this.musicID;
        }
        int n = this.m_engine.rand(0, 2);
        switch (n) {
            case 0: {
                this.musicID = 0;
                break;
            }
            case 1: {
                this.musicID = 3;
                break;
            }
            case 2: {
                this.musicID = 2;
                break;
            }
            default: {
                this.musicID = 0;
            }
        }
        return this.musicID;
    }

    private final void loadSounds() {
        this.m_engine.loadSound(this.getEventMusic());
        this.m_engine.loadSound(7);
        this.m_engine.loadSound(8);
        this.m_engine.loadSound(9);
        this.m_engine.loadSound(10);
        this.m_engine.loadSound(11);
    }

    public final void unloadSounds() {
        this.m_engine.unloadSound(this.getEventMusic());
        this.m_engine.unloadSound(7);
        this.m_engine.unloadSound(8);
        this.m_engine.unloadSound(9);
        this.m_engine.unloadSound(10);
        this.m_engine.unloadSound(11);
    }

    private void DEBUG_SCENEGAMELOADING(String string) {
    }

    private void updateLoading(int n) {
        if (!this.m_flowManager.isInTransition()) {
            try {
                this.updateLoadingState(n);
            }
            catch (Throwable throwable) {
                AppEngine.debug("EXL: " + throwable.toString());
                throwable.printStackTrace();
            }
        }
    }

    private void yield() {
        System.gc();
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void updateLoadingState(int n) {
        AppEngine.timerBegin();
        AppEngine appEngine = this.m_engine;
        ResourceManager resourceManager = appEngine.getResourceManager();
        this.yield();
        switch (this.m_loadingState) {
            case 0: {
                this.m_stringBufferCostToState = this.m_textManager.clearStringBuffer();
                this.m_loadingProgress = 3;
                ++this.m_loadingState;
                break;
            }
            case 1: {
                this.m_loadingProgress = 10;
                ++this.m_loadingState;
                break;
            }
            case 2: {
                try {
                    this.loadTrack(appEngine.getTrackDataResID());
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    throw new RuntimeException("IOException loading track data.");
                }
                this.loadTrackWidthsAndOffsets();
                SCALE_HORIZON_F = MathExt.divF(TRACK1_WIDTHS[0] << 16, TRACK1_WIDTHS[63] << 16);
                SCALE_INV_ROAD_F = MathExt.divF(65536 - SCALE_HORIZON_F, 0x3F0000);
                this.m_trackBendOffsets = new int[64];
                this.m_slopeArrayDistanceF = new int[16];
                this.m_slopeArraySlopeF = new int[16];
                this.m_slopeDestYs = new int[16];
                this.m_slopeSourceHeights = new int[16];
                this.initPerspectiveRanges();
                this.initLoading2DAssets();
                this.m_loadingProgress = 35;
                ++this.m_loadingState;
                break;
            }
            case 3: {
                this.m_loadingProgress = 40;
                ++this.m_loadingState;
                break;
            }
            case 4: {
                if (!this.updateLoading2DAssets(n)) break;
                this.m_updateLoadingTime = Integer.MAX_VALUE;
                ++this.m_loadingState;
                break;
            }
            case 5: {
                this.m_engine.loadLayoutImages(4);
                this.m_loadingProgress = 60;
                ++this.m_loadingState;
            }
            case 6: {
                this.m_nitroLevel = 1;
                this.m_loadingProgress = 75;
                ++this.m_loadingState;
                break;
            }
            case 7: {
                this.m_loadingProgress = 80;
                ++this.m_loadingState;
                break;
            }
            case 8: {
                this.m_loadingProgress = 85;
                ++this.m_loadingState;
                break;
            }
            case 9: {
                this.m_loadingProgress = 88;
                ++this.m_loadingState;
                break;
            }
            case 10: {
                this.initCar();
                this.m_playerImpactSparkAnimPlayer = new AnimPlayer();
                this.m_playerImpactSparkAnimPlayer.startAnim(143, 16);
                this.m_playerImpactSparkAnimPlayer.setAnimating(false);
                this.m_playerCarAnimPlayer = new AnimPlayer();
                this.m_playerCarAnimPlayer.startAnim(this.m_carAnimIDs[4], 20);
                this.m_brakeLightsAnimPlayer = new AnimPlayer();
                this.m_brakeLightsAnimPlayer.startAnim(this.m_carBrakeLightsAnimIDs[4], 20);
                if (appEngine.getCarNowRacingNitroLevel() > 0) {
                    this.m_boostAnimPlayer = new AnimPlayer();
                    this.m_boostAnimPlayer.startAnim(200, 20);
                    this.m_boostAnimPlayer.setAnimating(false);
                } else {
                    this.m_boostAnimPlayer = new AnimPlayer();
                }
                this.m_smokeAnimPlayer = new AnimPlayer();
                this.m_smokeAnimPlayer.startAnim(142, 4);
                this.m_smokeAnimPlayer.setAnimating(false);
                this.m_dustAnimPlayer = new AnimPlayer();
                this.m_dustAnimPlayer.startAnim(215, 4);
                this.m_dustAnimPlayer.setAnimating(false);
                this.m_slipstreamAnimPlayer = new AnimPlayer();
                this.m_slipstreamAnimPlayer.startAnim(216, 4);
                this.m_slipstreamAnimPlayer.setAnimating(false);
                this.m_speedLinesAnimPlayer = new AnimPlayer();
                this.m_nitroAirburstAnimPlayer = new AnimPlayer();
                this.m_nitroAirburstAnimPlayer.startAnim(217, 4);
                this.m_nitroAirburstAnimPlayer.setAnimating(false);
                this.m_startLightsAnimPlayer = new AnimPlayer();
                this.m_policeMarkAnimPlayer = new AnimPlayer();
                this.m_minimapBlinking = new AnimPlayer();
                this.m_loadingProgress = 90;
                ++this.m_loadingState;
                break;
            }
            case 11: {
                this.loadSounds();
                this.m_loadingProgress = 93;
                ++this.m_loadingState;
                break;
            }
            case 12: {
                this.m_loadingProgress = 99;
                ++this.m_loadingState;
                break;
            }
            case 13: {
                this.m_loadingProgress = 100;
                this.endState();
                break;
            }
            default: {
                this.m_loadingState = 0;
                this.m_loadingProgress = 0;
            }
        }
        AppEngine.timerEnd("updateLoadingState: (" + this.m_loadingState + ")");
    }

    private void initLoading2DAssets() {
        int n;
        this.m_loadMask = 4L;
        this.m_engine.setCurrentEventOpponents();
        AppEngine appEngine = this.m_engine;
        byte by = appEngine.getTrackEnvironment();
        this.m_primitiveOffroadBlocks = new int[48];
        switch (by) {
            case 1: {
                this.m_loadMask |= 0x200L;
                this.m_grassColourDark = 6850074;
                this.m_grassColourLight = 6389271;
                break;
            }
            case 0: {
                this.m_loadMask |= 0x800L;
                this.m_grassColourDark = 14922121;
                this.m_grassColourLight = 13804414;
                break;
            }
            case 2: {
                this.m_loadMask |= 0x1000L;
                this.m_grassColourDark = 11633507;
                this.m_grassColourLight = 9990486;
                break;
            }
            default: {
                AppEngine.ASSERT(false, "invalid environment in SceneGame.initLoading2DAssets");
            }
        }
        int n2 = appEngine.isPlayerCop() ? 3 : appEngine.getPlayerCarIndex();
        this.m_loadMask |= appEngine.getPlayerCarLoadMask(n2);
        if (this.m_copCount > 0) {
            this.m_loadMask |= appEngine.getOppCarLoadMask(3);
        }
        appEngine.setAllowedCivilianAppearances();
        int[] nArray = appEngine.getCurrentEventOpponents();
        int[] nArray2 = appEngine.getAllowedCivilianAppearances();
        for (n = 0; n < nArray.length; ++n) {
            this.m_loadMask |= appEngine.getOppCarLoadMask(nArray[n]);
        }
        for (n = 0; n < nArray2.length; ++n) {
            this.m_loadMask |= appEngine.getOppCarLoadMask(nArray2[n]);
        }
        if (this.m_eventType == 7) {
            this.m_loadMask |= appEngine.getOppCarLoadMask(0);
        }
    }

    private boolean updateLoading2DAssets(int n) {
        ResourceManager resourceManager = this.m_engine.getResourceManager();
        if (this.m_updateLoadingTime <= 0) {
            int n2 = 0;
            while (n2 < 1 && this.m_loadedAnimImages < this.m_engine.IMAGE_COUNT) {
                int n3 = this.m_loadedAnimImages << 1;
                int n4 = (int)AppEngine.IMAGE_IDS[n3 + 0];
                long l = AppEngine.IMAGE_IDS[n3 + 1];
                boolean bl = false;
                if ((l & this.m_loadMask) != 0L) {
                    if (n4 == 80) {
                        this.m_imgTrackPacked = resourceManager.loadImage(n4);
                        if (this.m_imgTrackPacked == null) {
                            bl = true;
                            this.DEBUG_LOAD_2D_ASSETS("Failed track load.");
                        } else {
                            ++n2;
                            this.DEBUG_LOAD_2D_ASSETS("Track loaded.");
                        }
                    } else if ((l & 0x20L) != 0L) {
                        this.m_imgSkyline = resourceManager.loadImage(n4);
                        if (this.m_imgSkyline == null) {
                            bl = true;
                            this.DEBUG_LOAD_2D_ASSETS("Failed skyline load.");
                        } else {
                            ++n2;
                            this.DEBUG_LOAD_2D_ASSETS("Skyline loaded.");
                        }
                    } else if (AnimationManager.loadImage(resourceManager, n4)) {
                        ++n2;
                        this.DEBUG_LOAD_2D_ASSETS("Normal image loaded.");
                    } else {
                        bl = true;
                        this.DEBUG_LOAD_2D_ASSETS("Failed normal image load.");
                    }
                }
                if (!bl) {
                    ++this.m_loadedAnimImages;
                } else {
                    AppEngine.debug(ResourceConstants.RESOURCE_FILENAMES_LIST[n4]);
                }
                this.m_loadingProgress = 40 + 10 * this.m_loadedAnimImages / this.m_engine.IMAGE_COUNT;
            }
            this.m_updateLoadingTime = 64;
        } else {
            this.m_updateLoadingTime -= n;
        }
        return this.m_loadingProgress == 50;
    }

    private final void DEBUG_LOAD_2D_ASSETS(String string) {
    }

    private void initCar() {
        AppEngine appEngine = this.m_engine;
        int n = appEngine.isPlayerCop() ? 3 : appEngine.getPlayerCarIndex();
        this.m_carAnimIDs = appEngine.getCarAngleAnimIDs(n);
        this.m_carBrakeLightsAnimIDs = appEngine.getCarBrakelightAngleAnimIDs(n);
        this.m_crashLeftAnimID = appEngine.getCarSpinoutLeftAnimID(n);
        this.m_crashRightAnimID = appEngine.getCarSpinoutRightAnimID(n);
    }

    private void initPerspectiveRanges() {
        int n = MathExt.divF(196608, MathExt.divF(MathExt.sinF(17157), MathExt.cosF(17157)));
        int n2 = MathExt.atan2F(851968, 65536);
        int n3 = n2 - 17157;
        int[] nArray = new int[64];
        for (int i = 0; i < 64; ++i) {
            int n4 = 17157 + i * n3 / 64;
            nArray[63 - i] = MathExt.divF(MathExt.sinF(n4), MathExt.cosF(n4));
        }
        this.m_perspectiveRangesF = nArray;
    }

    private void restartRace() {
        this.m_flowManager.transition(49);
    }

    private void startRace() {
        TrackObject trackObject;
        this.stopPursuit();
        this.setPursuitLevel(0);
        this.m_pursuitLevelFlashTimer = 0;
        this.m_pursuitLevelDelayTimer = 0;
        this.m_stopPursuitTimer = -1;
        this.m_nextRespawnTimer = 0;
        this.m_patrolCriminalsCaught = 0;
        this.m_copTrapsSpawned = 0;
        this.m_copPatrolsSpawned = 0;
        this.m_nearMissTimer = 0;
        this.m_careerExtraBounty = 0;
        this.createTrackObjects();
        this.initStaticObjects();
        this.updateTrackVisibility();
        this.m_timeCumulated = 0;
        this.m_lastBlockade = null;
        this.m_tutorialState = 0;
        this.m_tutorialMessage = -1;
        if (this.m_speedCameraSpeeds != null) {
            AppEngine.fillArray(this.m_speedCameraSpeeds, 0);
            AppEngine.fillArray(this.m_speedCameraSpeedsTrackOrder, 0);
        }
        this.m_speedCamerasPassed = 0;
        this.m_pursuedCar = null;
        this.m_startLightsState = (byte)-1;
        this.m_boostGaugeLevelF = 0x640000;
        this.m_playerIsBoosting = false;
        this.m_boostFlashTime = 0;
        this.m_cleanRace = true;
        this.m_playerPersonalitySpeeding = false;
        this.m_playerTimeInLead = 0;
        this.m_profileAggressionMultiplier = 1;
        AppEngine.fillArray(this.m_objectRefSpawned, false);
        this.m_playerCarSteeringAngleF = 0;
        this.m_playerCarSteeringOffsetF = 0;
        this.m_playerCarDriftingAngleCurrentF = 0;
        this.m_playerCarFacingDirF = 0;
        this.m_playerCarLateralDriftF = 0;
        this.m_driftScoreThisRace = 0;
        this.m_numObjectsDestroyed = 0;
        this.m_costToState = 0;
        this.m_engine.moneyToSDKString(0, this.m_stringBufferCostToState);
        this.m_playerImpactSparkAnimPlayer.setAnimating(false);
        this.m_brakeLightsAnimPlayer.startAnim(this.m_carBrakeLightsAnimIDs[4], 20);
        this.m_boostAnimPlayer.setAnimating(false);
        this.m_smokeAnimPlayer.setAnimating(false);
        this.m_dustAnimPlayer.setAnimating(false);
        this.m_slipstreamAnimPlayer.setAnimating(false);
        this.endSpeedBreaker();
        this.setCarParameters();
        this.updateTrackObjects(0);
        this.initTrackObjectOrderArrays();
        this.sortCarsTrackOrder();
        if (this.m_carsRaceOrder != null) {
            this.sortCarsRaceOrder();
        }
        for (int i = 0; i < this.m_trackObjects.length; ++i) {
            trackObject = this.m_trackObjects[i];
            if (!trackObject.isInitialised()) continue;
            trackObject.setRenderPosY(0);
        }
        trackObject = null;
        this.m_playerCarFacingDirF = this.m_playerCarMovementDirF;
        this.m_beingBlocked = false;
        this.m_collisionSteer = 0;
        this.m_notifyBoxTime = 0;
        this.m_coolWordingBoxTime = 0;
        this.initHUD();
        this.m_hudText = 0;
        this.hudRedraw(-1);
        this.updateHUD(0);
        this.resetEffects();
        this.m_playerCar.reset();
        this.adjustViewpoint();
        this.m_currBendFactor = this.calcBendFactor();
        this.calcTrackBendOffsets();
        this.m_raceOutroTotalTime = 0;
        if (this.m_loadingProgress == 100 && !this.m_interrupted) {
            this.m_engine.startMusic(this.getEventMusic());
        }
        this.m_engine.cheatUnset(5);
        this.m_engine.cheatUnset(4);
        this.m_lastRank = this.getProfileRank();
    }

    public void resetEffects() {
        this.m_speedBreakActivated = false;
        this.m_speedBreakDisplayTime = -1;
        this.m_scoreState = 0;
        AppEngine.fillArray(this.m_cameraShakeOffset, 0);
        this.m_collisionShakeTime = 0;
        this.m_playerCarSteeringOffsetF = 0;
        this.m_playerCarDriftingAngleCurrentF = 0;
        this.m_playerCarFacingDirF = this.m_playerCarMovementDirF;
        this.m_steeringFlags = 0;
        this.updatePlayerCarRotationAndPosition(0);
        this.m_playerCar.setBoosting(false);
        this.m_boostAnimPlayer.setAnimating(false);
        this.m_smokeAnimPlayer.setAnimating(false);
        this.m_dustAnimPlayer.setAnimating(false);
        this.m_slipstreamAnimPlayer.setAnimating(false);
        this.m_speedLinesAnimPlayer.setAnimating(false);
        this.m_nitroAirburstAnimPlayer.setAnimating(false);
    }

    private final void DEBUG_LOADTRACK(String string) {
    }

    private void loadTrack(short s) throws IOException {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        AppEngine appEngine = this.m_engine;
        ResourceManager resourceManager = appEngine.getResourceManager();
        this.m_trackRailSpline.clear();
        InputStream inputStream = resourceManager.loadBinaryFile(s);
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        int[] nArray = s_tempInt4_1;
        int[][] nArray2 = s_tempInt4x4;
        this.m_numTrackSections = dataInputStream.readByte();
        this.m_trackSectionSlope = new int[this.m_numTrackSections];
        this.m_trackSectionScenery = new short[this.m_numTrackSections];
        this.m_splineSectionIndex = new int[this.m_numTrackSections];
        boolean bl = appEngine.getEventTrackReversed(appEngine.getCurrentRaceEventIndex()) == 1;
        boolean bl2 = appEngine.getEventTrackMirrored(appEngine.getCurrentRaceEventIndex()) == 1;
        this.m_trackBoundingBoxes = new BoundingRectangle[this.m_numTrackSections];
        Transform transform = s_tempTransform;
        for (n7 = 0; n7 < this.m_numTrackSections; ++n7) {
            int n8;
            int n9;
            n6 = dataInputStream.readInt();
            n5 = dataInputStream.readInt();
            n4 = dataInputStream.readShort();
            n3 = dataInputStream.readByte();
            n2 = (n3 & 1) != 0 ? 1 : 0;
            this.m_splineSectionIndex[n7] = n = TrackSectionConstants.TRACK_SECTION_LOOKUPS[dataInputStream.readShort()];
            transform.setIdentity();
            AppEngine.postTranslatex(transform, n6, 0, n5);
            if (n2 != 0) {
                AppEngine.postScalex(transform, -65536, 65536, 65536);
            }
            AppEngine.postRotatex(transform, -(n4 << 16), 0, 65536, 0);
            this.m_trackSectionSlope[n7] = dataInputStream.readInt();
            this.m_trackSectionScenery[n7] = dataInputStream.readShort();
            int n10 = 0;
            Object object = appEngine.getSplineNodes(n);
            for (n9 = 0; n9 < ((int[][])object).length; ++n9) {
                System.arraycopy(object[n9], 0, nArray, 0, 3);
                nArray[3] = 65536;
                AppEngine.transformx(transform, nArray);
                n8 = object[n9][3];
                if (n2 != 0) {
                    n8 = -n8;
                }
                if (bl2) {
                    nArray[0] = -nArray[0];
                    n8 = -n8;
                }
                if (bl) {
                    n8 = -n8;
                }
                this.m_trackRailSpline.addNode(nArray[0], nArray[1], nArray[2], n8, n3 | n10, n7);
            }
            object = appEngine.getSplineBoundingBox(n);
            nArray2[0][0] = (int)object[0];
            nArray2[0][1] = 0;
            nArray2[0][2] = (int)object[1];
            nArray2[0][3] = 65536;
            nArray2[1][0] = (int)object[0];
            nArray2[1][1] = 0;
            nArray2[1][2] = (int)object[3];
            nArray2[1][3] = 65536;
            nArray2[2][0] = (int)object[2];
            nArray2[2][1] = 0;
            nArray2[2][2] = (int)object[1];
            nArray2[2][3] = 65536;
            nArray2[3][0] = (int)object[2];
            nArray2[3][1] = 0;
            nArray2[3][2] = (int)object[3];
            nArray2[3][3] = 65536;
            AppEngine.transformx(transform, nArray2[0]);
            AppEngine.transformx(transform, nArray2[1]);
            AppEngine.transformx(transform, nArray2[2]);
            AppEngine.transformx(transform, nArray2[3]);
            if (bl2) {
                nArray2[0][0] = -nArray2[0][0];
                nArray2[1][0] = -nArray2[1][0];
                nArray2[2][0] = -nArray2[2][0];
                nArray2[3][0] = -nArray2[3][0];
            }
            this.m_trackBoundingBoxes[n7] = new BoundingRectangle();
            int n11 = Math.min(Math.min(nArray2[0][0], nArray2[1][0]), Math.min(nArray2[2][0], nArray2[3][0]));
            n9 = Math.min(Math.min(nArray2[0][2], nArray2[1][2]), Math.min(nArray2[2][2], nArray2[3][2]));
            n8 = Math.max(Math.max(nArray2[0][0], nArray2[1][0]), Math.max(nArray2[2][0], nArray2[3][0]));
            int n12 = Math.max(Math.max(nArray2[0][2], nArray2[1][2]), Math.max(nArray2[2][2], nArray2[3][2]));
            this.m_trackBoundingBoxes[n7].set(n11, n9, n8, n12);
        }
        this.yield();
        this.m_trackRailSpline.buildSpline((this.m_trackFlags & 2) == 0, bl);
        n7 = this.m_trackRailSpline.getNodeCount();
        this.m_trackNodeSlope = new int[n7];
        n6 = -1;
        n5 = -1;
        n4 = 0;
        n3 = 0;
        for (n2 = 0; n2 < n7; ++n2) {
            if (n6 != this.m_trackRailSpline.getSectionAtNode(n2)) {
                n6 = this.m_trackRailSpline.getSectionAtNode(n2);
                n5 = (n6 + 1) % this.m_numTrackSections;
                n3 = 0;
                n4 = 0;
                n = n2;
                while (n < n7 && n6 == this.m_trackRailSpline.getSectionAtNode(n)) {
                    ++n;
                    ++n4;
                }
            }
            n = this.m_trackSectionSlope[n5] - this.m_trackSectionSlope[n6];
            n = MathExt.divF(n, n4 << 16);
            this.m_trackNodeSlope[n2] = this.m_trackSectionSlope[n6] + n * n3;
            ++n3;
        }
        n2 = dataInputStream.readShort();
        int[] nArray3 = s_tempInt4_1;
        int[] nArray4 = new int[n2];
        int[] nArray5 = new int[n2];
        byte[] byArray = new byte[n2];
        short[] sArray = new short[n2];
        boolean[] blArray = new boolean[n2];
        for (int i = 0; i < n2; ++i) {
            byte by;
            int n13 = dataInputStream.readInt();
            int n14 = dataInputStream.readInt();
            byArray[i] = (byte)TrackSectionConstants.TRACK_SECTION_LOOKUPS[dataInputStream.readShort()];
            if (bl2) {
                n13 = -n13;
                if (byArray[i] == 11) {
                    byArray[i] = 12;
                } else if (byArray[i] == 12) {
                    byArray[i] = 11;
                }
                if (byArray[i] == 13) {
                    byArray[i] = 14;
                } else if (byArray[i] == 14) {
                    byArray[i] = 13;
                }
            }
            if (bl) {
                if (byArray[i] == 13) {
                    byArray[i] = 14;
                } else if (byArray[i] == 14) {
                    byArray[i] = 13;
                }
            }
            if ((by = this.determineObjectTrackSection(n13, n14)) == -1) continue;
            sArray[i] = by;
            this.m_trackRailSpline.coordWorldToSpline(nArray3, n13, n14, by, bl);
            nArray4[i] = nArray3[0];
            nArray5[i] = nArray3[1];
            if (bl2 && (byArray[i] == 11 || byArray[i] == 12)) {
                nArray4[i] = -nArray4[i];
            }
            blArray[i] = false;
        }
        this.m_objectRefXs = nArray4;
        this.m_objectRefZs = nArray5;
        this.m_objectRefSections = sArray;
        this.m_objectRefTypes = byArray;
        this.m_objectRefSpawned = blArray;
        n2 = 0;
        int n15 = this.m_trackRailSpline.getMaxDistance();
        if ((this.m_trackFlags & 2) != 0) {
            int n16 = AppEngine.indexOf(18, this.m_objectRefTypes);
            AppEngine.ASSERT(n16 != -1, "no start line in point-to-point track");
            n2 = this.m_objectRefZs[n16];
            n16 = AppEngine.indexOf(19, this.m_objectRefTypes);
            AppEngine.ASSERT(n16 != -1, "no finish line in point-to-point track");
            n15 = this.m_objectRefZs[n16];
            AppEngine.ASSERT(this.m_raceMaxLaps == 1, "only one lap for point to points!");
            this.m_raceMaxLaps = 1;
        }
        this.m_trackStartLineDistF = n2;
        this.m_trackFinishLineDistF = n15;
        if (this.m_eventType == 3) {
            int n17 = AppEngine.countOf(21, this.m_objectRefTypes);
            AppEngine.ASSERT(n17 > 0, "argh! No cameras!");
            if (n17 > 0) {
                this.m_speedCameraIndexes = new int[n17];
                int n18 = -1;
                for (int i = 0; i < n17; ++i) {
                    int n19 = AppEngine.indexOf(21, this.m_objectRefTypes, n18 + 1);
                    AppEngine.ASSERT(n19 != -1, "argh! No cameras!");
                    this.m_speedCameraIndexes[i] = n18 = n19;
                }
                this.m_speedCameraSpeeds = new int[n17];
                this.m_speedCameraSpeedsTrackOrder = new int[n17];
            }
        }
        this.m_copCount = 0;
        for (int i = 0; i < this.m_objectRefTypes.length; ++i) {
            if (this.m_objectRefTypes[i] != 4 && this.m_objectRefTypes[i] != 5) continue;
            ++this.m_copCount;
        }
        this.m_copCount += this.m_engine.getCurrentEventCopPatrols();
        this.m_copCount += this.m_engine.getCurrentEventCopTraps();
        this.m_copCount += this.m_engine.getCurrentEventSpikesAvailable();
        this.m_copCount += this.m_engine.getCurrentEventRoadblocksAvailable();
    }

    public BoundingRectangle getTrackSectionBoundingRect(int n) {
        return this.m_trackBoundingBoxes[n];
    }

    private final void setCarParameters() {
        int n;
        AppEngine appEngine = this.m_engine;
        TrackObject trackObject = this.m_playerCar;
        this.m_playerCarTyresF = appEngine.getCarNowRacingParamTyres();
        this.m_playerCarTyresInvF = MathExt.divF(65536, this.m_playerCarTyresF);
        this.m_playerCarSteeringIncF = appEngine.getCarNowRacingParamSteeringInc();
        this.m_playerCarSteeringMaxF = appEngine.getCarNowRacingParamSteeringMax();
        this.m_playerCarSteeringRecentreIncF = appEngine.getCarNowRacingParamSteeringRecentreInc();
        this.m_playerCarSteeringIncF = MathExt.mulF(this.m_playerCarSteeringIncF, 45875);
        this.m_carAngleLimit01F = n = this.m_playerCarSteeringMaxF >> 5;
        this.m_carAngleLimit02F = this.m_carAngleLimit01F + (n << 1);
        this.m_carAngleLimit03F = this.m_carAngleLimit02F + (n << 2);
        this.m_carAngleLimit04F = this.m_carAngleLimit03F + (n << 2);
        int[] nArray = new int[appEngine.getCarNumGears()];
        nArray[0] = 0;
        nArray[1] = 0;
        for (int i = 2; i < nArray.length; ++i) {
            nArray[i] = trackObject.getGearMaxSpeed(i - 2);
        }
        this.m_playerCarLowRevSpeedsF = nArray;
        int[] nArray2 = new int[appEngine.getCarNumGears()];
        for (int i = 0; i < nArray2.length; ++i) {
            nArray2[i] = MathExt.divF(65536, trackObject.getGearMaxSpeed(i) - this.m_playerCarLowRevSpeedsF[i]);
        }
        this.m_playerCarRevDivsF = nArray2;
    }

    public void pause() {
        if (this.m_interrupted) {
            return;
        }
        this.m_engine.stopMusic(true);
        int n = this.m_flowManager.getCurrentState();
        switch (n) {
            case 47: 
            case 48: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 58: {
                this.m_interrupted = true;
                this.m_flowManager.transitionPush(60);
            }
        }
    }

    public void resume() {
        this.m_refreshViewport = true;
        int n = this.m_flowManager.getCurrentState();
        switch (n) {
            case 45: {
                if (this.m_loadingState <= 3) {
                    this.m_loadingState = 0;
                    break;
                }
                --this.m_loadingState;
                break;
            }
            case 57: {
                this.m_engine.startMusic(this.musicID);
            }
        }
    }

    public void end() {
        AppEngine appEngine = this.m_engine;
        appEngine.getSoundManager().stopSounds();
        appEngine.unloadImages(-4L, 0);
        this.unloadSounds();
        appEngine.requestGC(false);
    }

    public void update(int n) {
        AppEngine appEngine = this.m_engine;
        this.m_flowManager.update(n);
        if (this.m_flowManager.getCurrentState() == 50 || this.m_flowManager.getCurrentState() == 58) {
            if (appEngine.cheatUsed(4)) {
                this.m_flowManager.transitionSwapTop(51);
            } else if (appEngine.cheatUsed(5)) {
                this.m_flowManager.transitionSwapTop(this.m_eventType == 4 ? 53 : 52);
            }
        }
        if (this.m_hudPauseStopMusic) {
            switch (this.m_flowManager.getCurrentState()) {
                case 47: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 58: {
                    this.m_engine.startMusic(this.getEventMusic());
                    this.m_hudPauseStopMusic = false;
                    this.m_interrupted = false;
                }
            }
        }
        switch (this.m_flowManager.getCurrentState()) {
            case 45: {
                if (this.m_loadingProgress < 100) {
                    this.updateLoading(n);
                }
                this.m_layoutManager.updateScrollOffset(n);
                break;
            }
            case 46: {
                this.m_flowManager.transitionSwapTop(47);
                break;
            }
            case 47: {
                this.updateRaceIntro(n);
                this.updateTrackVisibility();
                break;
            }
            case 48: {
                this.updateMain(n);
                break;
            }
            case 50: 
            case 58: {
                if (this.m_eventType == 7) {
                    if (this.m_tutorialState != 0) {
                        this.updateMain(n);
                    }
                    this.updateTutorial(n);
                    break;
                }
                this.updateMain(n);
                break;
            }
            case 51: 
            case 52: 
            case 53: {
                this.updateRaceOutro(n);
                break;
            }
            case 59: {
                appEngine.stopMusic();
                this.m_flowManager.transitionScene(0, 6);
            }
        }
        this.updateHUD(n);
        if (!this.isPaused()) {
            if (this.m_wasPaused) {
                this.onResume();
                this.m_wasPaused = false;
            }
            this.m_timeCumulated += n;
            this.m_timeSinceLastCollision += n;
            this.updateHUDMedal(n);
            if (this.m_notifyBoxTime > 0) {
                this.updateNotifyBox(n);
            }
            if (this.m_coolWordingBoxTime > 0) {
                this.updateCoolWordingBox(n);
            }
            if (this.m_lapDisplayTime > 0) {
                this.m_lapDisplayTime -= n;
            }
            this.updatePursuitLevelTimers(n);
        } else if (!this.m_wasPaused) {
            this.m_wasPaused = true;
        }
    }

    public void setPursuitLevel(int n) {
        this.m_pursuitLevel = Math.min(n, 0x640000);
        this.m_pursuitLevel = Math.max(this.m_pursuitLevel, -6553600);
        this.m_pursuitLevelDelayTimer = 3000;
    }

    private void updatePursuitLevelTimers(int n) {
        this.m_pursuitLevelFlashTimer = this.m_pursuitLevelFlashTimer > 300 ? (this.m_pursuitLevelFlashTimer -= 600) : (this.m_pursuitLevelFlashTimer += n);
        if (this.m_pursuitLevelDelayTimer > 0) {
            this.m_pursuitLevelDelayTimer -= n;
        }
    }

    private void updateMain(int n) {
        int n2 = n;
        int n3 = this.m_eventType;
        if (this.m_startLightsState != -1) {
            this.updateStartLights(n2);
            if (this.m_startLightsState != 2) {
                return;
            }
        }
        if (this.m_nearMissTimer > 0) {
            this.m_nearMissTimer -= n;
        }
        if (this.m_playerCar.getRacePos() == 0) {
            if (this.m_playerTimeInLead < 0) {
                this.m_playerTimeInLead = 0;
            }
            this.m_playerTimeInLead += n;
        } else {
            if (this.m_playerTimeInLead > 0) {
                this.m_playerTimeInLead = 0;
            }
            this.m_playerTimeInLead -= n;
        }
        if (this.m_flowManager.getCurrentState() != 50 && this.m_flowManager.getCurrentState() != 58) {
            return;
        }
        if (this.m_eventType == 6) {
            this.updatePatrolModeRacerSpawners(n);
        }
        if (this.m_eventType != 7) {
            this.updateCopSpawners(n);
            this.updateTrafficSpawners(n);
        }
        this.updateCarMovement(n);
        this.updateCityScroll(n);
        this.m_currBendFactor = this.calcBendFactor();
        this.calcTrackBendOffsets();
        this.m_playerCarSlopeCurr = this.getCarSlope();
        this.updateAnims(n);
        this.updateCollisionShake(n);
        this.updateTrackVisibility();
        this.updateAggressionMultiplier(n);
    }

    private void updateBoost(int n) {
        boolean bl;
        boolean bl2;
        int n2;
        int n3 = n << 6;
        if (this.m_boostFlashTime > 0) {
            this.m_boostFlashTime -= n;
            if (this.m_boostFlashTime < 0) {
                this.m_boostFlashTime = 0;
            }
        }
        if (this.m_playerCar.isBoosting() && !this.m_playerIsBoosting && this.m_nitroLevel > 0) {
            this.m_playerIsBoosting = true;
            this.m_engine.playSound(9, true);
            this.m_posBeforeBoost = this.m_playerCar.getRacePos();
            this.m_engine.updateTrophyData(131072, 1);
        } else if (!this.m_playerCar.isBoosting()) {
            this.m_driftBoosting = false;
            if (this.m_playerIsBoosting) {
                this.m_playerIsBoosting = false;
                for (n2 = 0; n2 < 3; ++n2) {
                    this.m_cameraShakeOffset[n2] = 0;
                }
            }
            if (this.isBoostAvailable() && (n2 = this.m_boostGaugeLevelF) < 0x640000) {
                if ((n2 += MathExt.mulF(36044, n3)) > 0x640000) {
                    n2 = 0x640000;
                }
                this.m_boostGaugeLevelF = n2;
            }
        } else if (!this.m_driftBoosting) {
            this.m_boostGaugeLevelF -= MathExt.mulF(1091829, n3);
            if (this.m_boostGaugeLevelF < 0) {
                this.m_boostGaugeLevelF = 0;
                this.m_playerCar.setBoosting(false);
            }
            if (this.m_posBeforeBoost - (n2 = this.m_playerCar.getRacePos()) > 1) {
                this.m_engine.updateTrophyData(16, 1);
            }
        }
        int n4 = this.m_playerCar.getSpeedFactor();
        boolean bl3 = bl2 = this.m_playerCar.isBoosting() && !this.m_driftBoosting;
        boolean bl4 = bl2 && n4 > 39321 || this.m_driftBoosting;
        boolean bl5 = bl = bl4 && n4 > 58982 && !this.m_driftBoosting;
        if (bl2 && !this.m_boostAnimPlayer.isAnimating()) {
            this.m_boostAnimPlayer.setAnimating(true);
        } else if (!bl2 && this.m_boostAnimPlayer.isAnimating()) {
            this.m_boostAnimPlayer.setAnimating(false);
        } else if (bl2) {
            this.m_boostAnimPlayer.updateAnim(n);
        }
        if (bl4 && !this.m_speedLinesAnimPlayer.isAnimating()) {
            this.m_speedLinesAnimPlayer.setAnimating(true);
        } else if (!bl4 && this.m_speedLinesAnimPlayer.isAnimating()) {
            this.m_speedLinesAnimPlayer.setAnimating(false);
        } else if (bl4) {
            this.m_speedLinesAnimPlayer.updateAnim(n);
        }
        if (bl3) {
            int n5 = MathExt.smoothstepF(0, 0xC00000, this.m_playerCar.getBoostTimeRemaining() << 6);
            int n6 = MathExt.mulF(n5, 1966);
            for (int i = 0; i < 3; ++i) {
                this.m_cameraShakeOffset[i] = this.m_engine.rand(-(n5 >> 13), n5 >> 13);
            }
        }
    }

    private void adjustViewpoint() {
        NonUniformSpline nonUniformSpline = this.m_trackRailSpline;
        this.m_viewPosF = this.m_playerCar.getSplineDistance() - 52428;
        if (this.m_viewPosF < 0) {
            this.m_viewPosF += nonUniformSpline.getMaxDistance();
        }
        this.m_viewNode = this.m_playerCar.getSplineNode();
    }

    private void updateCityScroll(int n) {
        int n2 = MathExt.mulF(n << 16, 65);
        if (this.m_currBendFactor != 0 && this.m_playerCar.getSpeedF() > 0) {
            int n3 = 12;
            int n4 = MathExt.mulF(this.m_currBendFactor << n3, this.m_playerCar.getSpeedFactor());
            int n5 = MathExt.mulF(n4, n2);
            this.moveSkyLine(n5);
        }
    }

    private void moveSkyLine(int n) {
        this.m_renderCityOffsetXF += n;
        int n2 = this.m_imgSkyline.getWidth() << 16;
        while (this.m_renderCityOffsetXF < 0) {
            this.m_renderCityOffsetXF += n2;
        }
        while (this.m_renderCityOffsetXF >= n2) {
            this.m_renderCityOffsetXF -= n2;
        }
    }

    private void updateRaceIntro(int n) {
        this.m_introDurationF = 3000;
        this.m_playerCarSlopeCurr = this.getCarSlope();
        this.m_raceIntroTotalTime += n;
        if (this.m_raceIntroTotalTime < this.m_introDurationF) {
            int n2 = MathExt.smoothstepF(0, this.m_introDurationF, this.m_raceIntroTotalTime);
            this.m_raceIntroCameraOffsetF = MathExt.mulF(n2, 0x340000);
        } else {
            this.endState();
        }
    }

    private void updateRaceOutro(int n) {
        this.m_raceOutroTotalTime += n;
        if (this.m_raceOutroTotalTime < 4000) {
            int n2 = 6;
            this.m_playerCarAnimId = this.getAnimIDIndexFromAngle(this.m_raceOutroTotalTime << n2);
            if (this.m_eventType == 4 && this.m_flowManager.getCurrentState() == 51) {
                this.m_playerCar.unsetFlags(1024);
            } else {
                this.m_playerCar.setFlags(1024);
            }
            this.updateCarMovement(n);
            this.updateAnims(n);
            this.m_raceOutroFinished = false;
        } else if (!this.m_raceOutroFinished) {
            this.m_raceOutroFinished = true;
            this.endState();
        }
    }

    private void calcIntroSlopeHeights() {
        this.m_slopeSourceHeights[0] = 64;
        this.m_slopeDestYs[0] = 12 + (this.m_raceIntroCameraOffsetF + 32768 >> 16);
        this.m_numSlopeSections = 1;
    }

    private void calcTrackBendOffsets() {
        int n = this.m_currBendFactor;
        int n2 = MathExt.mulF(this.m_playerCar.getLateralPosF(), TRACK1_WIDTHS[32] << 15) + 32768;
        n2 = MathExt.mulF(n2, 52428) >> 16;
        int n3 = VIEWPORT_CENTRE_X + this.m_cameraShakeOffset[0] - n2;
        int n4 = VIEWPORT_CENTRE_X * n2;
        for (int i = 0; i < 64; ++i) {
            int n5 = 0;
            int n6 = 64 - (i & 0xFFFE);
            if (n2 != 0) {
                n5 = (64 - i) * n4;
                n5 = MathExt.mulF(n5, CAMERA_PERSP_INVF) >> 16;
            }
            this.m_trackBendOffsets[i] = (n >> 4) + n5;
            n = (n >> 1) + (n >> 2) + (n >> 3);
        }
    }

    private final void DEBUG_BENDFACTOR(String string) {
    }

    private int calcBendFactor() {
        int n;
        NonUniformSpline nonUniformSpline = this.m_trackRailSpline;
        int n2 = 0;
        int n3 = 655360;
        int n4 = this.m_viewPosF;
        int n5 = this.m_viewNode;
        int n6 = nonUniformSpline.getNodeCount();
        int n7 = nonUniformSpline.getDistanceAtNode(n5 + 1) - n4;
        if (n7 < 0) {
            n7 += nonUniformSpline.getMaxDistance();
        }
        while (n7 < n3) {
            n = nonUniformSpline.getDistanceAtNode(n5 + 1);
            int n8 = n - n4;
            if (n8 < 0) {
                n8 += nonUniformSpline.getMaxDistance();
            }
            int n9 = nonUniformSpline.getNodeCornerRating(n5);
            n3 -= n8;
            n2 += n9 * (n8 >> 11);
            n4 += n8;
            if (++n5 > n6) {
                n5 -= n6;
                n4 -= nonUniformSpline.getMaxDistance();
            }
            if ((n7 = nonUniformSpline.getDistanceAtNode(n5 + 1) - n4) >= 0) continue;
            n7 += nonUniformSpline.getMaxDistance();
        }
        n = nonUniformSpline.getNodeCornerRating(n5);
        return n2 += n * (n3 >> 11);
    }

    private void fillSlopeArray() {
        int n;
        NonUniformSpline nonUniformSpline = this.m_trackRailSpline;
        int n2 = nonUniformSpline.getMaxDistance();
        int n3 = nonUniformSpline.getNodeCount();
        int n4 = this.m_viewPosF;
        int n5 = nonUniformSpline.getNodeAtDistance(this.m_playerCar.getSplineDistance());
        int n6 = 655360;
        int n7 = 65536;
        int n8 = this.m_playerCarSlopeCurr - 65536;
        int n9 = 0;
        int n10 = n5 + 1;
        if (n10 == n3) {
            n = n2 - n4;
        } else {
            n = nonUniformSpline.getDistanceAtNode(n10) - n4;
            if (n < 0) {
                n += n2;
            }
        }
        int[] nArray = this.m_slopeArrayDistanceF;
        int[] nArray2 = this.m_slopeArraySlopeF;
        int[] nArray3 = this.m_trackNodeSlope;
        while (n <= n6) {
            nArray[n9] = n;
            nArray2[n9] = n7;
            ++n9;
            n6 -= n;
            n4 += n;
            if (++n5 >= n3) {
                n5 -= n3;
                n4 -= n2;
            }
            if ((n10 = n5 + 1) == n3) {
                n = n2 - n4;
            } else {
                n = nonUniformSpline.getDistanceAtNode(n10) - n4;
                if (n < 0) {
                    n += n2;
                }
            }
            n7 = nArray3[n5] - n8;
        }
        nArray[n9] = n6;
        nArray2[n9] = n7;
        this.m_numSlopeSections = ++n9;
    }

    private void calcSlopeHeights() {
        int n = 0;
        int n2 = 0;
        int n3 = this.m_numSlopeSections;
        int[] nArray = this.m_slopeArraySlopeF;
        int[] nArray2 = this.m_slopeArrayDistanceF;
        int[] nArray3 = this.m_slopeSourceHeights;
        int[] nArray4 = this.m_slopeDestYs;
        for (int i = 0; i < n3; ++i) {
            int n4 = nArray[i];
            n2 += nArray2[i];
            int n5 = MathExt.mulF(nArray2[i], SCALE_ROAD_HEIGHT_F);
            nArray3[i] = n5 + 32768 >> 16;
            nArray4[i] = (n += MathExt.mulF(n5, n4)) + 32768 >> 16;
        }
    }

    private void updateAnims(int n) {
        if (!(this.m_playerCar.hasFinishedRace() && this.m_playerCar.getSpeedF() == 0 || !this.m_playerCar.isAnimatingCollision() && this.m_playerCar.getSpeedF() <= 0)) {
            this.m_playerCarAnimPlayer.updateAnim(n);
            this.m_brakeLightsAnimPlayer.updateAnim(n);
        }
        if (this.m_playerImpactSparkAnimPlayer.isAnimating()) {
            this.m_playerImpactSparkAnimPlayer.updateAnim(n);
        }
        if (this.m_nitroAirburstAnimPlayer.isAnimating()) {
            this.m_nitroAirburstAnimPlayer.updateAnim(n);
        }
    }

    private final void updateStartLights(int n) {
        switch (this.m_startLightsState) {
            case 0: {
                this.m_startLightsTimer += n;
                if (this.m_startLightsTimer <= 1250) break;
                this.m_startLightsTimer = 1250;
                this.m_startLightsState = 1;
                break;
            }
            case 1: {
                if (this.m_startLightsAnimPlayer.isAnimating()) {
                    this.m_startLightsAnimPlayer.updateAnim(n);
                    break;
                }
                this.m_startLightsState = (byte)2;
                this.m_flowManager.transitionSwapTop(50);
                break;
            }
            case 2: {
                this.m_startLightsTimer -= n;
                if (this.m_startLightsTimer >= 0) break;
                this.m_startLightsTimer = 0;
                this.m_startLightsState = (byte)-1;
                return;
            }
        }
    }

    private void updatePoliceMark(int n) {
        if (this.m_policeMarkAnimPlayer.isAnimating()) {
            this.m_policeMarkAnimPlayer.updateAnim(n);
        }
    }

    private void updateMinimapBlinking(int n) {
        if (this.m_minimapBlinking.isAnimating()) {
            this.m_minimapBlinking.updateAnim(n);
        }
    }

    private void renderStartLights(Graphics graphics) {
        int n = AnimationManager.getAnimFrameHeight(226, 0);
        int n2 = AnimationManager.getAnimFrameY(226, 0) + (n >> 1);
        int n3 = -(n2 + n << 16);
        int n4 = MathExt.linearstepF(0, 1250, this.m_startLightsTimer);
        int n5 = VIEWPORT_CENTRE_X;
        int n6 = n3 + MathExt.mulF(n4, 0 - n3) >> 16;
        this.m_startLightsAnimPlayer.drawAnim(graphics, n5, n6);
    }

    private int[] getObstacleBoundingRect(int n) {
        int[] nArray = new int[4];
        switch (n) {
            case 23: 
            case 24: {
                nArray[0] = BB_CONSTRUCTION_BARRIER[0];
                nArray[1] = BB_CONSTRUCTION_BARRIER[1];
                nArray[2] = BB_CONSTRUCTION_BARRIER[2];
                nArray[3] = BB_CONSTRUCTION_BARRIER[3];
                break;
            }
            default: {
                nArray[0] = BB_DUMPSTER[0];
                nArray[1] = BB_DUMPSTER[1];
                nArray[2] = BB_DUMPSTER[2];
                nArray[3] = BB_DUMPSTER[3];
            }
        }
        return nArray;
    }

    int[] getObjectLocalBB(TrackObject trackObject) {
        int[] nArray = new int[4];
        nArray = trackObject.getFlags(1) ? this.m_engine.getCarBoundingRect(trackObject.getAppearance()) : this.getObstacleBoundingRect(trackObject.getObjectType());
        return nArray;
    }

    private void calculateObjectCollisonBB(TrackObject trackObject, int[] nArray) {
        int n = this.m_trackRailSpline.getTrackingDistance(trackObject.getID());
        int n2 = trackObject.getLateralPosF();
        int[] nArray2 = this.getObjectLocalBB(trackObject);
        nArray[1] = n + nArray2[1];
        nArray[3] = n + nArray2[3];
        nArray[2] = n2 + nArray2[2];
        nArray[0] = n2 + nArray2[0];
    }

    public final void startCollisionShake(int n) {
        if (this.m_collisionShakeTime > 0) {
            return;
        }
        n = Math.max(0, n);
        n = Math.min(65536, n);
        this.m_collisionShakeTime = 32768;
        this.m_collisionShakeRange = MathExt.mulF(3276, n);
    }

    private final void updateCollisionShake(int n) {
        int n2 = n << 6;
        if (this.m_collisionShakeTime > 0) {
            this.m_collisionShakeTime -= n2;
            this.m_collisionShakeTime = Math.max(0, this.m_collisionShakeTime);
            int n3 = MathExt.smoothstepF(0, 32768, this.m_collisionShakeTime);
            int n4 = MathExt.mulF(n3, this.m_collisionShakeRange);
            for (int i = 0; i < 3; ++i) {
                this.m_cameraShakeOffset[i] = this.m_engine.rand(-n3 >> 13, n3 >> 13);
            }
        }
    }

    private final void DEBUG_RENDER2D(String string) {
    }

    private void updateCarMovement(int n) {
        this.updateCarMovement(n, true);
    }

    private void updateCarMovement(int n, boolean bl) {
        int n2 = this.m_playerCar.getRacePos();
        if (bl) {
            this.updatePlayerCar(n);
        }
        this.updateTrackObjects(n);
        this.sortCarsTrackOrder();
        if (this.m_carsRaceOrder != null) {
            this.sortCarsRaceOrder();
        }
        this.updateCollisionsAndProximity();
        if (this.m_playerCar.getRacePos() < n2) {
            this.m_cleanOvertake = true;
        }
    }

    private void updatePlayerCar(int n) {
        TrackObject trackObject = this.m_playerCar;
        this.updatePlayerCarSteering(n);
        this.updatePlayerCarLateralPos(n);
        this.updateBoost(n);
        this.updatePlayerCarSkidEffects(n);
        this.updateSteeringPower(n);
        int n2 = trackObject.getSpeedF();
        if (n2 > trackObject.getBestSpeedF()) {
            trackObject.setBestSpeedF(n2);
            this.m_engine.updateTrophyData(32768, n2 >> 12);
        }
        if (this.m_flowManager.getCurrentState() == 50 && n2 == 0 && !trackObject.getFlags(1024)) {
            this.m_engine.playSound(7, true);
        }
        if (n2 > 589824 && !this.m_playerPersonalitySpeeding && !this.m_playerIsBoosting) {
            this.m_playerPersonalitySpeeding = true;
        } else if (this.m_playerPersonalitySpeeding && n2 < 65536) {
            this.m_playerPersonalitySpeeding = false;
        }
    }

    private void updatePlayerCarRotationAndPosition(int n) {
        int n2;
        int n3 = n << 6;
        TrackObject trackObject = this.m_playerCar;
        int[] nArray = this.m_trackRailSpline.getTrackingTangent(trackObject.getID());
        int n4 = MathExt.getVectorYawRadF(nArray[0], 0, nArray[2]);
        this.m_playerCarMovementDirF = MathExt.normaliseAngleRadiansF(n4);
        int n5 = n2 = this.m_playerCarSteeringOffsetF;
        int n6 = n5 - this.m_playerCarDriftingAngleCurrentF;
        int n7 = this.m_playerCarDriftingAngleCurrentF != 0 ? 80 : 200;
        if (n6 < 0) {
            n7 = -n7;
        }
        int n8 = MathExt.mulF(n7, n << 16);
        if (n7 > 0 && n8 > n6 || n7 < 0 && n8 < n6) {
            n8 = n6;
        }
        this.m_playerCarDriftingAngleCurrentF += n8;
        int n9 = this.m_playerCarDriftingAngleCurrentF + trackObject.getCollisionYawF();
        int n10 = this.m_playerCarMovementDirF;
        this.m_playerCarFacingDirF = MathExt.normaliseAngleRadiansF(n10 + n9);
        int n11 = MathExt.normaliseAngleRadiansF(this.m_playerCarMovementDirF - this.m_playerCarFacingDirF);
        this.m_playerCarAnimId = this.getAnimIDIndexFromAngle(n11);
        if (this.isSteering(1)) {
            if (!this.isHardTurnSoundPlayed) {
                this.m_engine.playSound(7);
            }
            this.isHardTurnSoundPlayed = true;
        } else if (this.isSteering(2)) {
            if (!this.isHardTurnSoundPlayed) {
                this.m_engine.playSound(7);
            }
            this.isHardTurnSoundPlayed = true;
        }
    }

    private void updatePlayerCarSteering(int n) {
        int n2;
        int n3 = n << 6;
        int n4 = this.m_playerCar.getSpeedFactor();
        int n5 = this.m_playerCarSteeringIncF;
        int n6 = this.m_playerCarSteeringRecentreIncF;
        int n7 = this.m_playerCarSteeringMaxF << 3;
        int n8 = this.m_playerCarSteeringAngleF;
        if (n4 == 0) {
            n2 = n7;
        } else {
            n2 = MathExt.divF(this.m_playerCarSteeringMaxF, n4);
            n2 = Math.min(n2, n7);
        }
        if (!this.m_playerCar.getFlags(1024) || this.m_playerCar.getSpeedF() > 0) {
            int n9;
            if (this.isSteering(1)) {
                n9 = MathExt.mulF(n5, n3);
                if ((n8 -= n9) < -n2) {
                    if (!this.isHardTurnSoundPlayed) {
                        this.m_engine.playSound(7);
                    }
                    this.isHardTurnSoundPlayed = true;
                    n8 = -n2;
                }
            } else if (this.isSteering(2)) {
                n9 = MathExt.mulF(n5, n3);
                if ((n8 += n9) > n2) {
                    if (!this.isHardTurnSoundPlayed) {
                        this.m_engine.playSound(7);
                    }
                    this.isHardTurnSoundPlayed = true;
                    n8 = n2;
                }
            } else if (n8 != 0) {
                if (n8 > 0) {
                    if ((n8 -= MathExt.mulF(n6, n3)) < 0) {
                        n8 = 0;
                    }
                } else if ((n8 += MathExt.mulF(n6, n3)) > 0) {
                    n8 = 0;
                }
            }
            if (this.m_playerCarDriftingAngleCurrentF > 0 && this.lastCarDriftAngleF < 0 || this.m_playerCarDriftingAngleCurrentF < 0 && this.lastCarDriftAngleF > 0 || this.m_playerCarDriftingAngleCurrentF == 0) {
                this.isHardTurnSoundPlayed = false;
            }
            this.lastCarDriftAngleF = this.m_playerCarDriftingAngleCurrentF;
        }
        TrackObject trackObject = this.m_playerCar;
        int n10 = trackObject.getLateralPosF();
        int n11 = trackObject.getLeftWallF();
        int n12 = trackObject.getRightWallF();
        if (n8 > 0 && n10 >= n12 || n8 < 0 && n10 <= n11) {
            n8 = MathExt.mulF(n8, 45875);
        }
        this.m_playerCarSteeringAngleF = n8;
        this.m_playerCarSteeringOffsetF = -(n8 >> 3);
        trackObject.resetWalls();
    }

    public final void stoppedBlocking() {
        this.m_beingBlocked = false;
    }

    private void updatePlayerCarLateralPos(int n) {
        TrackObject trackObject = this.m_playerCar;
        int n2 = n << 6;
        int n3 = 0;
        int n4 = trackObject.getSpeedFactor();
        int n5 = MathExt.divF(this.m_playerCarSteeringAngleF, this.m_playerCarSteeringMaxF);
        n5 = MathExt.mulF(n5, n4);
        n3 = MathExt.mulF(n5, 131072);
        n3 = MathExt.mulF(n3, n2);
        int n6 = 0;
        int n7 = trackObject.getSplineCurvature();
        n6 = MathExt.mulF(this.getPlayerCarLateralDrift(), n2);
        if (n7 < 0 && this.isSteering(1) || n7 > 0 && this.isSteering(2)) {
            n6 = MathExt.mulF(n6, this.m_playerCarTyresInvF);
            n6 = MathExt.mulF(n6, 52428);
        }
        int n8 = n7 == 0 ? 14745 : 49152;
        if (n6 < 0 && this.m_playerCarLateralDriftF > 0 || n6 > 0 && this.m_playerCarLateralDriftF < 0) {
            this.m_playerCarLateralDriftF = 0;
        }
        if (this.m_playerCarLateralDriftF < n6) {
            this.m_playerCarLateralDriftF += MathExt.mulF(n8, n2);
            if (this.m_playerCarLateralDriftF > n6) {
                this.m_playerCarLateralDriftF = n6;
            }
        } else if (this.m_playerCarLateralDriftF > n6) {
            this.m_playerCarLateralDriftF -= MathExt.mulF(n8, n2);
            if (this.m_playerCarLateralDriftF < n6) {
                this.m_playerCarLateralDriftF = n6;
            }
        }
        int n9 = n8 = trackObject.getLateralPosF();
        n9 = trackObject.isAnimatingCollision() ? (n9 += n3 >> 1) : (n9 += n3);
        n9 += this.m_playerCarLateralDriftF;
        int n10 = MathExt.mulF(trackObject.getLateralForceF(), n2);
        n9 += n10;
        if (this.m_collisionSteer != 0) {
            n9 += MathExt.mulF(this.m_collisionSteer, n2);
            if (this.m_collisionSteer > 0) {
                this.m_collisionSteer -= MathExt.mulF(39321, n2);
                if (this.m_collisionSteer < 0) {
                    this.m_collisionSteer = 0;
                }
            } else {
                this.m_collisionSteer += MathExt.mulF(39321, n2);
                if (this.m_collisionSteer > 0) {
                    this.m_collisionSteer = 0;
                }
            }
        }
        trackObject.setLateralSpeedF(MathExt.divF(n9 - n8, n2));
        this.moveSkyLine(trackObject.getLateralSpeedF());
        trackObject.setLateralPosF(n9);
        boolean bl = n9 < -72089 || n9 > 72089;
        boolean bl2 = false;
        boolean bl3 = false;
        if (n7 < 0 && n9 < Short.MIN_VALUE || n7 > 0 && n9 > 32768) {
            bl2 = true;
        }
        if (n7 < 0 && n9 > 0 || n7 > 0 && n9 < 0) {
            bl3 = true;
        }
        this.updatePlayerRaceLineCheck(n7, bl2, bl3, bl);
        if (bl) {
            trackObject.setFlags(2048);
            if (this.m_pursuerCount > 0 && !this.m_beingBlocked) {
                for (int i = 0; i < 4; ++i) {
                    TrackObject trackObject2 = this.m_pursuers[i];
                    if (trackObject2 == null || trackObject2.getDistanceFromPlayerF() <= 6553) continue;
                    trackObject2.blockPlayer();
                    this.m_beingBlocked = true;
                    break;
                }
            }
        } else {
            trackObject.unsetFlags(2048);
        }
    }

    private void updatePlayerCarSkidEffects(int n) {
        boolean bl;
        int n2;
        TrackObject trackObject = this.m_playerCar;
        int n3 = trackObject.getSplineCurvature();
        int n4 = trackObject.getLateralPosF();
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        if (!trackObject.isCrashing() && !trackObject.hasPuncturedTyres()) {
            if (n4 < -72089 || n4 > 72089) {
                if (trackObject.getSpeedF() > 122880) {
                    if (n4 < -72089) {
                        n2 = -72089 - n4;
                        bl2 = true;
                        if (n2 > 19660) {
                            bl3 = true;
                        }
                    } else {
                        n2 = n4 - 72089;
                        bl3 = true;
                        if (n2 > 19660) {
                            bl2 = true;
                        }
                    }
                }
            } else if (trackObject.isAccelerating() && !trackObject.isBraking() && trackObject.getSpeedFactor() < 13107) {
                bl4 = true;
                bl5 = true;
            } else if (n3 != 0 && trackObject.getSpeedF() > 368640) {
                if (n3 < -1 && this.isSteering(1)) {
                    bl5 = true;
                } else if (n3 > 1 && this.isSteering(2)) {
                    bl4 = true;
                }
            } else {
                bl4 = false;
                bl5 = false;
            }
        } else if (trackObject.hasPuncturedTyres()) {
            bl4 = true;
            bl5 = true;
        }
        n2 = bl2 || bl3 ? 1 : 0;
        boolean bl6 = bl = bl4 || bl5;
        if (n2 != 0 && !this.m_dustAnimPlayer.isAnimating()) {
            this.m_dustAnimPlayer.setAnimating(true);
        }
        if (bl && n2 == 0 && !this.m_smokeAnimPlayer.isAnimating()) {
            this.m_smokeAnimPlayer.setAnimating(true);
        }
        if (n2 == 0 && this.m_dustAnimPlayer.isAnimating()) {
            this.m_dustAnimPlayer.setAnimating(false);
        }
        if ((!bl || n2 != 0) && this.m_smokeAnimPlayer.isAnimating()) {
            this.m_smokeAnimPlayer.setAnimating(false);
        }
        this.m_smokeAnimPlayer.updateAnim(n);
        this.m_dustAnimPlayer.updateAnim(n);
    }

    private int getPlayerCarLateralDrift() {
        TrackObject trackObject = this.m_playerCar;
        int n = trackObject.getSplineCurvature();
        if (n == 0) {
            return 0;
        }
        int n2 = trackObject.getSpeedF();
        n2 = MathExt.mulF(n2, 9709);
        int n3 = MathExt.mulF(CORNER_VALUES[Math.abs(n)], n2);
        return n > 0 ? -n3 : n3;
    }

    private final void DEBUG_CREATION(String string) {
    }

    public TrackObject createObject(int n, int n2, int n3, int n4) {
        TrackObject trackObject = null;
        int n5 = this.getFreeObjectIDX();
        AppEngine.ASSERT(n == 0 && n5 == 0 || n != 0 && n5 != 0, "player must be created first!");
        if (n5 != -1 && this.m_trackObjects[n5].init(n)) {
            trackObject = this.m_trackObjects[n5];
            if (n2 != -1) {
                trackObject.setAppearance(n2);
            }
            this.loadTrackObjectAssets(trackObject);
            trackObject.setLocation(n3, n4);
            this.postObjectCreation(n, trackObject);
            if (trackObject.isRacer() && n3 >= 0) {
                trackObject.crossedLine();
            }
        }
        return trackObject;
    }

    private final void postObjectCreation(int n, TrackObject trackObject) {
        switch (n) {
            case 5: {
                trackObject.stateTransition((short)1);
            }
        }
    }

    private final int getFreeObjectIDX() {
        for (int i = 0; i < this.m_trackObjects.length; ++i) {
            if (this.m_trackObjects[i].isInitialised()) continue;
            return i;
        }
        return -1;
    }

    private void loadTrackObjectAssets(TrackObject trackObject) {
        if (trackObject.isPlayerCar()) {
            this.loadPlayerCarAssets(trackObject);
        } else if (trackObject.getFlags(1)) {
            this.loadCarAssets(trackObject);
        }
    }

    private void loadPlayerCarAssets(TrackObject trackObject) {
        AppEngine appEngine = this.m_engine;
        trackObject.setNumGears(appEngine.getCarNumGears());
        trackObject.setGearAccelData(appEngine.getCarNowRacingGearAccelData());
        trackObject.setGearMinSpeedData(appEngine.getCarNowRacingGearMinSpeedData());
        trackObject.setGearMaxSpeedData(appEngine.getCarNowRacingGearMaxSpeedData());
    }

    private void loadCarAssets(TrackObject trackObject) {
        AppEngine appEngine = this.m_engine;
        int n = trackObject.getAppearance();
        trackObject.setNumGears(appEngine.getCarNumGears(n));
        trackObject.setGearAccelData(appEngine.getCarGearAccelData(n));
        trackObject.setGearMinSpeedData(appEngine.getCarGearMinSpeedData(n));
        trackObject.setGearMaxSpeedData(appEngine.getCarGearMaxSpeedData(n));
        if (trackObject.getFlags(4)) {
            // empty if block
        }
    }

    private void createTrackObjects() {
        TrackObject trackObject;
        int n;
        int n2;
        Object object;
        int n3;
        AppEngine appEngine = this.m_engine;
        TrackObject[] trackObjectArray = this.m_trackObjects;
        for (n3 = 0; n3 < 30; ++n3) {
            if (!trackObjectArray[n3].isInitialised()) continue;
            trackObjectArray[n3].destroy();
        }
        n3 = this.m_eventType;
        this.m_trafficDensityScaleF = appEngine.getCurrentEventTrafficScale();
        this.m_trafficMax = appEngine.getCurrentEventTrafficMax();
        this.m_trafficFlagsEvent = this.m_trafficFlagsCurr = appEngine.getCurrentEventTrafficFlags();
        int[] nArray = appEngine.getCurrentEventOpponents();
        int n4 = nArray.length;
        int n5 = this.m_trackStartLineDistF;
        int[] nArray2 = new int[]{26214, -26214, 26214, -26214};
        int[] nArray3 = new int[]{n5, n5, n5 - 78643, n5 - 78643};
        int n6 = this.m_engine.isPlayerCop() ? 0 : 1;
        int n7 = nArray2[n6];
        int n8 = nArray3[n6];
        switch (n3) {
            case 5: {
                n8 += 65536;
                n4 = 1;
                break;
            }
            case 6: 
            case 7: {
                n4 = 0;
            }
        }
        this.m_playerCar = this.createObject(0, -1, n8, n7);
        appEngine.setCarNowRacingParameters();
        if ((this.m_trackFlags & 2) != 0) {
            this.m_playerCar.incNumLapsCompleted();
        }
        if (n4 > 0) {
            object = new int[n4];
            int[] nArray4 = new int[n4];
            if (n4 > 1) {
                int n9;
                for (n9 = 0; n9 < n4; ++n9) {
                    object[n9] = -1;
                }
                n9 = appEngine.getCurrentEventDiffMin();
                n2 = appEngine.getCurrentEventDiffMax();
                n = MathExt.divF(n2 - n9, n4 - 1 << 16);
                int n10 = n9;
                for (int i = 0; i < n4; ++i) {
                    int n11 = appEngine.rand(0, n4 - 1);
                    while (object[n11] != -1) {
                        if (++n11 != n4) continue;
                        n11 = 0;
                    }
                    object[n11] = n10;
                    nArray4[n11] = nArray[i];
                    n10 += n;
                }
            } else {
                object[0] = appEngine.getCurrentEventDiffMax();
                nArray4[0] = nArray[0];
            }
            trackObject = null;
            n2 = 0;
            n = 0;
            while (n < n4) {
                if (n2 == n6) {
                    ++n2;
                }
                if ((trackObject = this.createObject(3, nArray4[n], nArray3[n2], nArray2[n2])) != null) {
                    trackObject.setDifficulty((int)object[n]);
                    if (this.m_eventType == 5) {
                        trackObject.setSpeedF(409600);
                        trackObject.setGearForSpeed(409600);
                    }
                }
                if ((this.m_trackFlags & 2) != 0) {
                    trackObject.incNumLapsCompleted();
                }
                ++n;
                ++n2;
            }
            if (this.m_carsRaceOrder == null) {
                this.m_carsRaceOrder = new TrackObject[n4 + 1];
            }
        }
        if (n3 == 4) {
            int n12 = 52428;
            trackObject = this.createObject(4, -1, n8 - 131072, n12);
            ++this.m_copPatrolsSpawned;
            trackObject.stateTransition((short)3);
            trackObject.setSpeedF(655360);
            trackObject.setGearForSpeed(655360);
        }
        object = this.m_trackRailSpline;
        this.m_trackStartLineSection = ((NonUniformSpline)object).getSectionAtNode(((NonUniformSpline)object).getNodeAtDistance(this.m_trackStartLineDistF));
        this.m_trackFinishLineSection = ((NonUniformSpline)object).getSectionAtNode(((NonUniformSpline)object).getNodeAtDistance(this.m_trackFinishLineDistF));
        if (this.m_trafficDensityScaleF > 0) {
            this.m_trafficDensityScaleInvF = MathExt.divF(65536, this.m_trafficDensityScaleF);
            this.m_aheadLeftTrafficTimer = this.setTrafficTimer(4000, 15000);
            this.m_aheadLeftTrafficDistance = this.setTrafficDistance(786432, 5324800);
            this.m_aheadRightTrafficTimer = this.setTrafficTimer(4000, 15000);
            this.m_aheadRightTrafficDistance = this.setTrafficDistance(786432, 5324800);
        } else {
            this.m_trafficFlagsCurr = 3;
            this.m_trafficFlagsEvent = 3;
        }
        int n13 = this.m_trackFinishLineDistF - this.m_trackStartLineDistF;
        int n14 = appEngine.getCurrentEventCopPatrols() + appEngine.getCurrentEventCopTraps();
        if (n14 > 0) {
            n2 = n13 / (n14 + 2);
            n = n2 >> 2;
            this.m_aheadCopDistanceMin = n2 - n;
            this.m_aheadCopDistanceMax = n2 + n;
            this.m_aheadCopSpawnDistance = this.setCopSpawnDistance(this.m_aheadCopDistanceMin, this.m_aheadCopDistanceMax);
            this.m_copTrapPatrolsRatioF = n14 > 0 ? appEngine.getCurrentEventCopTraps() * 65536 / n14 : 0;
        }
    }

    private final int setTrafficTimer(int n, int n2) {
        int n3 = this.m_engine.rand(n, n2);
        n3 = MathExt.mulF(n3, this.m_trafficDensityScaleInvF);
        return n3;
    }

    private final int setTrafficDistance(int n, int n2) {
        int n3 = this.m_engine.rand(n, n2);
        n3 = MathExt.mulF(n3, this.m_trafficDensityScaleInvF);
        return n3;
    }

    private int setCopSpawnDistance(int n, int n2) {
        return this.m_engine.rand(n, n2);
    }

    private final void updateTrackObjects(int n) {
        TrackObject trackObject = null;
        TrackObject trackObject2 = null;
        TrackObject trackObject3 = null;
        TrackObject trackObject4 = null;
        int n2 = Integer.MAX_VALUE;
        int n3 = Integer.MIN_VALUE;
        int n4 = Integer.MAX_VALUE;
        int n5 = Integer.MIN_VALUE;
        this.m_proxToAheadSpawn = false;
        this.m_proxToBehindSpawn = false;
        for (int i = 0; i < this.m_trackObjects.length; ++i) {
            int n6;
            int n7;
            TrackObject trackObject5 = this.m_trackObjects[i];
            if (!trackObject5.isInitialised()) continue;
            int n8 = trackObject5.getPrevEndPosF();
            if (this.m_playerCar.hasFinishedRace() && trackObject5 != this.m_playerCar && trackObject5.getDistanceFromPlayerF() < -52428) continue;
            trackObject5.update(n);
            if (!trackObject5.isInitialised()) continue;
            int n9 = trackObject5.getSplineDistance();
            if (this.m_flowManager.getCurrentState() == 50) {
                this.updateLaps(trackObject5, n8, n9);
            }
            if (trackObject5.isPlayerCar()) {
                if (this.m_speedCameraIndexes != null) {
                    this.m_speedCameraFlashTimer += n;
                    this.m_speedCameraFlashTimer = this.m_speedCameraFlashTimer > 200 ? -200 : this.m_speedCameraFlashTimer;
                    int[] nArray = this.m_speedCameraSpeeds;
                    for (n7 = 0; n7 < this.m_speedCameraIndexes.length; ++n7) {
                        int n10;
                        n6 = nArray[n7];
                        if (n6 > 0) continue;
                        int n11 = this.m_objectRefZs[this.m_speedCameraIndexes[n7]] - 0x140000;
                        if (n8 < n11 && n9 >= n11) {
                            this.setCustomMessageText(272, true);
                        }
                        if (n8 >= (n10 = this.m_objectRefZs[this.m_speedCameraIndexes[n7]] - 131072) || n9 < n10) continue;
                        this.triggerSpeedCamera(n7, trackObject5.getSpeedF());
                    }
                }
                this.updatePlayerCarRotationAndPosition(n);
                trackObject5.updateMiniMapNodes();
            } else {
                int n12 = trackObject5.getDistanceFromPlayerF();
                n7 = Math.abs(n12);
                n6 = Math.abs(trackObject5.getDistanceFromCameraF());
                if (!trackObject5.isFlashing()) {
                    trackObject5.setVisible(n6 < 655360);
                }
                if (trackObject5.getFlags(4)) {
                    if (n12 >= 0 && (n12 < n2 || trackObject == null)) {
                        trackObject = trackObject5;
                        n2 = n12;
                    } else if (n12 < 0 && (n12 > n3 || trackObject2 == null)) {
                        trackObject2 = trackObject5;
                        n3 = n12;
                    }
                }
                if (trackObject5.isRacer()) {
                    if (n12 >= 0 && (n12 < n4 || trackObject3 == null)) {
                        trackObject3 = trackObject5;
                        n4 = n12;
                    } else if (n12 < 0 && (n12 > n5 || trackObject4 == null)) {
                        trackObject4 = trackObject5;
                        n5 = n12;
                    }
                }
                if (trackObject5.getFlags(1)) {
                    if (n12 > 0) {
                        if (Math.abs(n12 - 655360) < 131072) {
                            this.m_proxToAheadSpawn = true;
                        }
                    } else if (Math.abs(458752 + n12) < 131072) {
                        this.m_proxToBehindSpawn = true;
                    }
                }
                if ((trackObject5.getFlags(Integer.MIN_VALUE) || trackObject5.getObjectType() == 4 && trackObject5.getState() == 1) && n12 < -1310720) {
                    if (this.m_lastBlockade == trackObject5) {
                        this.m_lastBlockade = null;
                    }
                    trackObject5.destroy();
                }
                if (!this.m_playerCar.isCrashing() && !this.m_engine.isPlayerCop() && trackObject5.getFlags(Integer.MIN_VALUE) && n12 < 0 && trackObject5.getNotFlags(0x20000000)) {
                    if (this.m_timeSinceLastCollision > 250) {
                        if (trackObject5.getObjectType() == 24) {
                            this.m_engine.updateTrophyData(0x2000000, 1);
                        } else if (trackObject5.getObjectType() == 23) {
                            this.m_engine.updateTrophyData(0x1000000, 1);
                        }
                    }
                    trackObject5.setFlags(0x20000000);
                }
            }
            trackObject5.setColliding(false);
        }
        if (this.m_flowManager.getCurrentState() == 50) {
            if (!this.m_engine.isPlayerCop()) {
                this.updatePlayerApprehension(n, trackObject2, trackObject, n3, n2);
            } else if (this.m_eventType == 5) {
                if (this.m_playerCar.getNotFlags(0x200000) && trackObject3 != null && this.m_racerAhead == null) {
                    this.startPlayerPursuit(trackObject3);
                }
                this.updateCriminalApprehension(n, trackObject4, trackObject3, n5, n4);
            } else if (this.m_eventType == 6 || this.m_eventType == 7) {
                if (this.m_playerCar.getNotFlags(0x200000)) {
                    if (trackObject3 != null && trackObject3.getNotFlags(32) && Math.abs(trackObject3.getDistanceFromPlayerF()) < 262144) {
                        this.startPlayerPursuit(trackObject3);
                    }
                } else if (this.m_stopPursuitTimer >= 0 && (this.m_stopPursuitTimer -= n) < 0) {
                    this.m_stopPursuitTimer = -1;
                    this.m_playerCar.unsetFlags(0x200000);
                    this.m_playerCar.disableCopLights();
                    if (this.m_coolWordingBoxTime > 0) {
                        this.m_pursuitLevelDelayTimer = this.m_coolWordingBoxTime;
                    }
                }
                this.updatePatrolModeCriminalApprehension(n, trackObject4, trackObject3, n5, n4);
            }
        }
        this.m_copAhead = trackObject;
        this.m_copBehind = trackObject2;
        this.m_racerAhead = trackObject3;
        this.m_racerBehind = trackObject4;
        this.m_playerLeadDistance = n5;
    }

    private void updateParticleSystem(int n) {
        for (int i = 0; i < this.m_trackObjects.length; ++i) {
            TrackObject trackObject = this.m_trackObjects[i];
            if (!trackObject.isInitialised() || !trackObject.getFlags(0x400000)) continue;
            trackObject.update(n);
        }
    }

    private void updatePlayerApprehension(int n, TrackObject trackObject, TrackObject trackObject2, int n2, int n3) {
        int n4;
        if (this.getPursuersCount() < 1) {
            return;
        }
        int n5 = this.m_engine.getEventPursuitRiseSpeedF(this.m_engine.getCurrentRaceEventIndex());
        n5 = n5 != 0 ? n5 : 393216;
        TrackObject trackObject3 = null;
        trackObject3 = trackObject != null && trackObject2 != null ? (Math.abs(trackObject.getDistanceFromPlayerF()) < Math.abs(trackObject2.getDistanceFromPlayerF()) ? trackObject : trackObject2) : (trackObject != null ? trackObject : trackObject2);
        if (trackObject3 == null) {
            return;
        }
        if (trackObject3 != null && this.checkPlayerApprehension(this.m_playerCar, trackObject3)) {
            this.increasePursuitLevel(n * n5 / 1000);
        } else if (this.m_eventType != 4) {
            int n6 = Math.max(trackObject2 != null ? n3 : 0, trackObject != null ? -n2 : 0);
            if (n6 < 524288) {
                this.decreasePursuitLevel(Math.min(n * 0 / 1000, this.m_pursuitLevel));
            } else {
                int n7 = MathExt.divF(n6 -= 524288, 262144);
                n7 = Math.min(65536, n7);
                n4 = 0 + MathExt.mulF(n7, 0x100000);
                this.decreasePursuitLevel(n * n4 / 1000);
            }
            if (this.m_pursuitLevel < -5898240 && n6 < 0x120000) {
                this.increasePursuitLevel(-5898240 - this.m_pursuitLevel);
            }
        }
        if (this.m_eventType == 7) {
            this.setPursuitLevel(Math.min(this.m_pursuitLevel, 0x5A0000));
            this.setPursuitLevel(Math.max(this.m_pursuitLevel, -5898240));
        }
        if (this.m_playerCar.getSpeedF() < 163840 && Math.abs(trackObject3.getDistanceFromPlayerF()) < 524288) {
            this.increasePursuitLevel(n * n5 / 500);
        }
        if (this.m_pursuitLevel >= 0x640000) {
            this.m_flowManager.transitionSwapTop(53);
        } else if (this.m_pursuitLevel <= -6553600) {
            this.stopPursuit();
        }
        if (this.getPursuersCount() < 2) {
            return;
        }
        TrackObject trackObject4 = null;
        for (n4 = 0; n4 < this.m_trackObjects.length; ++n4) {
            int n8;
            trackObject4 = this.m_trackObjects[n4];
            if (!trackObject4.isInitialised() || !trackObject4.getFlags(4) || (n8 = trackObject4.getDistanceFromPlayerF()) >= -1179648 || trackObject4 == trackObject && trackObject2 == null || this.m_eventType == 4) continue;
            this.stopPursuit(trackObject4);
            trackObject4.destroy();
        }
    }

    private void updateCriminalApprehension(int n, TrackObject trackObject, TrackObject trackObject2, int n2, int n3) {
        int n4 = this.m_engine.getEventPursuitRiseSpeedF(this.m_engine.getCurrentRaceEventIndex());
        int n5 = n4 = n4 != 0 ? n4 : 0x140000;
        if (trackObject != null && this.checkCriminalApprehension(this.m_playerCar, trackObject)) {
            this.increasePursuitLevel(n * n4 / 1000);
        } else if (trackObject2 != null && this.checkCriminalApprehension(this.m_playerCar, trackObject2)) {
            this.increasePursuitLevel(n * n4 / 1000);
        } else {
            int n6 = Math.max(trackObject2 != null ? n3 : 0, trackObject != null ? -n2 : 0);
            if (n6 < 262144) {
                this.decreasePursuitLevel(n * 6553 / 1000);
            } else {
                int n7 = MathExt.divF(n6 -= 262144, 393216);
                n7 = Math.min(65536, n7);
                int n8 = 6553 + MathExt.mulF(n7, 255591);
                this.decreasePursuitLevel(n * n8 / 1000);
            }
        }
        if (this.m_pursuitLevel >= 0x640000) {
            this.signalCriminalDied(trackObject2 != null ? trackObject2 : trackObject);
        } else if (this.m_pursuitLevel <= -6553600) {
            this.setCustomMessageText(258, true);
            this.m_flowManager.transitionSwapTop(52);
        }
    }

    private void updatePatrolModeCriminalApprehension(int n, TrackObject trackObject, TrackObject trackObject2, int n2, int n3) {
        boolean bl = false;
        if (this.m_playerCar.getFlags(0x200000)) {
            int n4 = this.m_engine.getEventPursuitRiseSpeedF(this.m_engine.getCurrentRaceEventIndex());
            int n5 = n4 = n4 != 0 ? n4 : 0x230000;
            if (trackObject != null && this.checkCriminalApprehension(this.m_playerCar, trackObject)) {
                this.increasePursuitLevel(n * n4 / 1000);
                bl = true;
            } else if (trackObject2 != null && this.checkCriminalApprehension(this.m_playerCar, trackObject2)) {
                this.increasePursuitLevel(n * n4 / 1000);
                bl = true;
            } else {
                int n6 = Math.max(trackObject2 != null ? n3 : 0, trackObject != null ? -n2 : 0);
                if (n6 < 655360) {
                    this.decreasePursuitLevel(n * 0 / 1000);
                } else {
                    int n7 = MathExt.divF(n6 -= 655360, 655360);
                    n7 = Math.min(65536, n7);
                    int n8 = 0 + MathExt.mulF(n7, 983040);
                    this.decreasePursuitLevel(n * n8 / 1000);
                }
            }
            if (this.m_eventType == 7) {
                if (this.m_tutorialState < 36) {
                    this.setPursuitLevel(Math.min(this.m_pursuitLevel, 0x5A0000));
                }
                this.setPursuitLevel(Math.max(this.m_pursuitLevel, -5898240));
            }
            if (this.m_pursuitLevel >= 0x640000) {
                TrackObject trackObject3;
                TrackObject trackObject4 = trackObject3 = trackObject2 != null ? trackObject2 : trackObject;
                if (trackObject3 != null && !trackObject3.isCrashing()) {
                    trackObject3.startDramaticCrash(this.m_engine.randPercent() < 50 ? 13 : 14);
                }
            } else if (this.m_pursuitLevel <= -6553600) {
                TrackObject trackObject5;
                this.m_stopPursuitTimer = 1;
                TrackObject trackObject6 = trackObject5 = trackObject2 != null ? trackObject2 : trackObject;
                if (trackObject5 != null) {
                    trackObject5.unsetFlags(32);
                    this.setCustomMessageText(257, true);
                    trackObject5.destroy();
                    this.m_nextRespawnTimer = this.m_engine.rand(1000, 5000);
                }
            }
        }
        if (this.m_flowManager.getCurrentState() == 50 && this.m_eventType != 7) {
            this.m_patrolTimeLeft -= n;
            if (this.m_patrolTimeLeft <= 0) {
                System.out.println("time up");
                this.m_patrolTimeLeft = 0;
                this.m_playerCar.unsetFlags(0x200000);
                this.m_playerCar.disableCopLights();
                this.m_flowManager.transitionSwapTop(51);
            }
        }
    }

    private final void updateLaps(TrackObject trackObject, int n, int n2) {
        if (this.m_raceMaxLaps > 0 && trackObject.isRacer() && !trackObject.hasFinishedRace() && ((this.m_trackFlags & 1) != 0 && trackObject.isInLap() && n > n2 || (this.m_trackFlags & 2) != 0 && n2 >= this.m_trackFinishLineDistF)) {
            this.trackObjectFinishedLap(trackObject);
        }
        if (n > n2 << 1 || (this.m_trackFlags & 2) != 0) {
            trackObject.crossedLine();
        }
        if (!trackObject.isInLap() && trackObject.isInRace() && trackObject.getSplineSection() > 2) {
            trackObject.setInLap(true);
        }
    }

    public final void incCivCount() {
        ++this.m_civilianCount;
    }

    public final void decCivCount() {
        --this.m_civilianCount;
    }

    public final void incLatCivCount() {
        ++this.m_latCivilianCount;
    }

    public final void decLatCivCount() {
        --this.m_latCivilianCount;
    }

    public final void incRacerCount() {
        ++this.m_racerCount;
    }

    public final void decRacerCount() {
        --this.m_racerCount;
    }

    private final void updateTrafficSpawners(int n) {
        boolean bl;
        int n2 = n << 6;
        AppEngine appEngine = this.m_engine;
        TrackObject trackObject = this.m_playerCar;
        boolean bl2 = (this.m_trafficFlagsCurr & 1) != 0;
        boolean bl3 = (this.m_trafficFlagsCurr & 2) != 0;
        int n3 = trackObject.getSplineDistance();
        int n4 = trackObject.getSpeedF();
        int n5 = MathExt.mulF(n4, n2);
        NonUniformSpline nonUniformSpline = trackObject.getSpline();
        int n6 = nonUniformSpline.normaliseDistance(n3 + 655360);
        int n7 = nonUniformSpline.normaliseDistance(n3 - 458752);
        int n8 = nonUniformSpline.normaliseDistance(n3 + 655360);
        int n9 = nonUniformSpline.getNodeFlags(nonUniformSpline.getNodeAtDistance(n6));
        boolean bl4 = !this.m_proxToAheadSpawn && (n9 & 2) == 0;
        int n10 = nonUniformSpline.getNodeFlags(nonUniformSpline.getNodeAtDistance(n7));
        boolean bl5 = !this.m_proxToBehindSpawn && (n10 & 2) == 0;
        int n11 = nonUniformSpline.getNodeFlags(nonUniformSpline.getNodeAtDistance(n8));
        boolean bl6 = bl = this.m_latCivilianCount < 1 && (n11 & 2) != 0;
        if (!bl2 && bl4) {
            int n12;
            if (n4 < 163840) {
                this.m_aheadLeftTrafficTimer -= n;
            } else {
                this.m_aheadLeftTrafficDistance -= n5;
            }
            if (this.m_aheadLeftTrafficTimer <= 0 || this.m_aheadLeftTrafficDistance <= 0) {
                n12 = -72089 + appEngine.rand(0, 52428);
                this.createObject(7, -1, n6, n12);
                this.m_aheadLeftTrafficTimer = this.setTrafficTimer(4000, 15000);
                this.m_aheadLeftTrafficDistance = this.setTrafficDistance(786432, 5324800);
            }
            if (n4 > 409600) {
                if (n4 < 163840) {
                    this.m_aheadRightTrafficTimer -= n;
                } else {
                    this.m_aheadRightTrafficDistance -= n5;
                }
                if (this.m_aheadRightTrafficTimer <= 0 || this.m_aheadRightTrafficDistance <= 0) {
                    n12 = 72089 - appEngine.rand(0, 52428);
                    this.createObject(6, -1, n6, n12);
                    this.m_aheadRightTrafficTimer = this.setTrafficTimer(4000, 15000);
                    this.m_aheadRightTrafficDistance = this.setTrafficDistance(786432, 5324800);
                }
            }
            this.sortCarsTrackOrder();
        }
    }

    private void updateCopSpawners(int n) {
        int n2 = n << 6;
        AppEngine appEngine = this.m_engine;
        TrackObject trackObject = this.m_playerCar;
        int n3 = trackObject.getSplineDistance();
        int n4 = trackObject.getSpeedF();
        int n5 = MathExt.mulF(n4, n2);
        NonUniformSpline nonUniformSpline = trackObject.getSpline();
        int n6 = nonUniformSpline.normaliseDistance(n3 + 655360);
        int n7 = nonUniformSpline.normaliseDistance(n3 - 458752);
        int n8 = nonUniformSpline.normaliseDistance(n3 + 655360);
        int n9 = nonUniformSpline.getNodeFlags(nonUniformSpline.getNodeAtDistance(n6));
        boolean bl = !this.m_proxToAheadSpawn && (n9 & 2) == 0;
        int n10 = nonUniformSpline.getNodeFlags(nonUniformSpline.getNodeAtDistance(n7));
        boolean bl2 = !this.m_proxToBehindSpawn && (n10 & 2) == 0;
        int n11 = nonUniformSpline.getNodeFlags(nonUniformSpline.getNodeAtDistance(n8));
        boolean bl3 = this.m_latCivilianCount < 1 && (n11 & 2) != 0;
        this.m_aheadCopSpawnDistance -= n5;
        if (bl && n4 > 409600 && !appEngine.isPlayerCop()) {
            int n12 = this.m_copPatrolsSpawned + this.m_copTrapsSpawned;
            int n13 = appEngine.getCurrentEventCopPatrols() + appEngine.getCurrentEventCopTraps();
            int n14 = n12 > 0 ? this.m_copPatrolsSpawned * 65536 / n12 : 0;
            boolean bl4 = false;
            if (this.m_aheadCopSpawnDistance <= 0) {
                if (n12 < n13 && this.getCopHeatLevel() > 0) {
                    if (appEngine.randPercent() < 60) {
                        this.setupCopTrap(n6);
                        bl4 = true;
                    } else if (this.m_copTrapsSpawned < appEngine.getCurrentEventCopTraps()) {
                        this.setupCopTrap(n6);
                        bl4 = true;
                    } else if (this.m_copPatrolsSpawned < appEngine.getCurrentEventCopPatrols()) {
                        this.setupCopPatrol(n6);
                        bl4 = true;
                    }
                } else if (this.m_copPatrolsSpawned < appEngine.getCurrentEventCopPatrols() && n14 <= 65536 - this.m_copTrapPatrolsRatioF) {
                    if (this.m_aheadRightTrafficTimer < 2000 || this.m_aheadRightTrafficDistance < 393216) {
                        this.setupCopPatrol(n6);
                        bl4 = true;
                    }
                } else if (this.m_copTrapsSpawned < appEngine.getCurrentEventCopTraps()) {
                    this.setupCopTrap(n6);
                    bl4 = true;
                }
                if (bl4) {
                    this.m_aheadRightTrafficTimer = this.setTrafficTimer(4000, 15000);
                    this.m_aheadRightTrafficDistance = this.setTrafficDistance(786432, 5324800);
                    this.m_aheadCopSpawnDistance = this.setCopSpawnDistance(this.m_aheadCopDistanceMin, this.m_aheadCopDistanceMax);
                    this.sortCarsTrackOrder();
                }
            }
        }
    }

    private void updatePatrolModeRacerSpawners(int n) {
        if (this.m_racerCount == 1) {
            if (this.m_nextRespawnTimer > 0) {
                this.m_nextRespawnTimer -= n;
                return;
            }
            int n2 = n << 6;
            AppEngine appEngine = this.m_engine;
            TrackObject trackObject = this.m_playerCar;
            int n3 = trackObject.getSplineDistance();
            int n4 = trackObject.getSpeedF();
            int n5 = MathExt.mulF(n4, n2);
            NonUniformSpline nonUniformSpline = trackObject.getSpline();
            int n6 = nonUniformSpline.normaliseDistance(n3 + this.m_engine.rand(655360, 0x280000));
            this.setupRacer(n6);
        }
    }

    private TrackObject setupRacer(int n) {
        int[] nArray = this.m_engine.getCurrentEventOpponents();
        int n2 = nArray.length;
        if (n2 > 0) {
            int n3 = nArray[0];
            if (n2 > 1) {
                int n4;
                while ((n3 = nArray[n4 = this.m_engine.rand(0, n2 - 1)]) == this.m_lasSpawnedRaceAppearane && this.m_lasSpawnedRaceAppearane != -1) {
                }
            }
            TrackObject trackObject = null;
            int n5 = this.m_engine.rand(0, 52428);
            trackObject = this.createObject(3, n3, n, n5);
            if (trackObject != null) {
                int n6 = this.m_engine.getCurrentEventDiffMin();
                int n7 = this.m_engine.getCurrentEventDiffMax();
                int n8 = this.m_engine.rand(n6, n7);
                trackObject.setDifficulty(n8);
                trackObject.incNumLapsCompleted();
                this.m_lasSpawnedRaceAppearane = n3;
            }
            return trackObject;
        }
        return null;
    }

    private TrackObject setupCopPatrol(int n) {
        int n2 = this.m_engine.rand(0, 52428);
        ++this.m_copPatrolsSpawned;
        return this.createObject(4, -1, n, n2);
    }

    TrackObject setupCopTrap(int n) {
        boolean bl = this.m_engine.rand(0, 1) == 1;
        int n2 = bl ? 72089 : -72089;
        TrackObject trackObject = this.createObject(5, -1, n, n2);
        AppEngine.ASSERT(trackObject != null, "Not enough memory to create new cop object");
        trackObject.stateTransition((short)1);
        ++this.m_copTrapsSpawned;
        return trackObject;
    }

    private void trackObjectFinishedLap(TrackObject trackObject) {
        int n;
        int n2;
        boolean bl;
        trackObject.incNumLapsCompleted();
        trackObject.setInLap(false);
        int n3 = this.m_eventType;
        int n4 = trackObject.getNumLapsCompleted();
        TrackObject trackObject2 = this.m_playerCar;
        boolean bl2 = bl = trackObject == trackObject2;
        if (n3 == 2 && (n2 = n4) > 0) {
            n = this.m_carsRaceOrder.length - n2;
            if (trackObject.getRacePos() == n - 1) {
                int n5 = n2 - 1;
                TrackObject trackObject3 = this.m_carsRaceOrder[n5];
                if (trackObject3.isPlayerCar()) {
                    this.endRace();
                } else {
                    trackObject3.destroy();
                    if (this.m_racerCount > 1) {
                        SDKString sDKString = this.m_textManager.clearStringBuffer();
                        int[] nArray = Cache.getInstance().acquireIntArray(1);
                        nArray[0] = this.m_racerCount;
                        SDKString sDKString2 = this.m_textManager.getString(261);
                        this.m_textManager.replace(sDKString, sDKString2, nArray);
                        Cache.getInstance().releaseIntArray(nArray);
                        this.setNotifyText(sDKString);
                    }
                }
            }
        }
        if ((n2 = n4 + 1) == 0) {
            n2 = 1;
        } else if (n2 > this.m_raceMaxLaps) {
            n2 = this.m_raceMaxLaps;
        }
        n = trackObject.getCurrentLapTime();
        if (n4 > 0) {
            trackObject.setCumulativeLapTimes(trackObject.getCumulativeLapTimes() + n);
            trackObject.setCurrentLapTime(0);
        }
        if (this.m_eventType != 6 && n4 >= this.m_raceMaxLaps) {
            trackObject.setFinishedRace(true);
        }
        if (bl && n4 != 0 && n3 != 5) {
            if (this.m_bestLapTime <= 0 || n < this.m_bestLapTime) {
                this.m_bestLapTime = n;
            }
            if (trackObject.hasFinishedRace()) {
                this.DEBUG_STATES("player finished");
                this.m_scoreState = 0;
                this.resetEffects();
                this.m_endRaceLeadDistance = this.getPlayerLeadDistance();
                this.endRace();
            }
            if (n3 == 1) {
                SDKString sDKString = this.m_textManager.clearStringBuffer();
                if (n4 == this.m_raceMaxLaps - 1) {
                    this.m_textManager.appendStringIdToBuffer(206);
                } else {
                    sDKString = this.getLapString();
                }
                if (!trackObject.hasFinishedRace()) {
                    this.setNotifyText(sDKString);
                }
            } else if (n3 == 3) {
                if (this.getProfileRank() == -1) {
                    this.m_flowManager.transitionSwapTop(52);
                } else {
                    this.m_flowManager.transitionSwapTop(51);
                }
            } else if (n3 == 4) {
                if (this.getProfileRank() == -1) {
                    this.setCustomMessageText(254, true);
                } else {
                    this.setCustomMessageText(257, true);
                }
            }
        }
        if (!bl && n3 == 5) {
            this.setPursuitLevel(-6553600);
            this.m_flowManager.transitionSwapTop(52);
        }
    }

    private void initStaticObjects() {
        int[][] nArray = this.m_staticTrackObjects;
        if (nArray == null) {
            this.m_staticTrackObjects = nArray = new int[100][10];
        }
        for (int i = 0; i < 100; ++i) {
            nArray[i][0] = -1;
            nArray[i][9] = -1;
        }
        this.m_currentStaticObjIndex = 0;
    }

    private void removeStaticObjectsForTrackSection(int n) {
        if (n >= 0) {
            int[][] nArray = this.m_staticTrackObjects;
            int n2 = this.m_currentStaticObjIndex;
            for (int i = 0; i < 100; ++i) {
                int[] nArray2 = nArray[i];
                if (nArray2[9] != n) continue;
                nArray2[0] = -1;
                nArray2[2] = 0;
                nArray2[9] = -1;
                --n2;
            }
            this.m_currentStaticObjIndex = n2;
        }
    }

    private void addStaticObjectsForTrackSection(int n) {
        int n2;
        int n3;
        NonUniformSpline nonUniformSpline = this.m_trackRailSpline;
        byte by = this.m_numTrackSections;
        short[] sArray = this.m_trackSectionScenery;
        int n4 = MathExt.mulF(91749, 91750);
        int n5 = -n4;
        int n6 = MathExt.mulF(91749, 131072);
        int n7 = -n6;
        boolean bl = 1 == this.m_engine.getEventTrackReversed(this.m_engine.getCurrentRaceEventIndex());
        int n8 = bl ? nonUniformSpline.getDistanceAtSection((n + by - 1) % by) : nonUniformSpline.getDistanceAtSection((n + 1) % by);
        int n9 = n8 - (n3 = nonUniformSpline.getDistanceAtSection(n));
        if (n9 < 0) {
            n9 = nonUniformSpline.getMaxDistance() - n3;
        }
        int n10 = n3 + (n9 >> 1);
        int n11 = n3 + (n9 >> 2);
        int n12 = n10 + (n9 >> 2);
        short s = sArray[n];
        if ((s & 1) != 0) {
            switch (this.m_engine.getTrackEnvironment()) {
                case 1: {
                    this.addStaticObject(230, true, n11, n7, n);
                    this.addStaticObject(230, true, n12, n6, n);
                    break;
                }
                case 2: {
                    n2 = 230;
                    int n13 = 231;
                    this.addStaticObject(n2, true, n3, n6, n);
                    this.addStaticObject(n13, true, n11, n7, n);
                    if ((n & 1) != 0) {
                        n2 = 232;
                        n13 = 230;
                    }
                    this.addStaticObject(n2, true, n10, n6, n);
                    this.addStaticObject(n13, true, n12, n7, n);
                    break;
                }
            }
        }
        if ((s & 2) != 0) {
            switch (this.m_engine.getTrackEnvironment()) {
                case 2: {
                    this.addManyObjects(233, true, 233, true, n11 - 78643, n10 - 78643, n12 - 78643, n5, n4, n);
                    break;
                }
                case 1: {
                    this.addManyObjects(243, true, 243, true, n11 - 78643, n10 - 78643, n12 - 78643, n5, n4, n);
                    break;
                }
                case 0: {
                    n2 = n5;
                    if ((n & 1) == 0) {
                        n2 = n4;
                    }
                    this.addStaticObject(243, true, n3, n2, n);
                    this.addStaticObject(243, true, n11, n2, n);
                    this.addStaticObject(243, true, n10, n2, n);
                    this.addStaticObject(243, true, n12, n2, n);
                }
            }
        }
        if ((s & 4) != 0 && ((n2 = (int)this.m_engine.getTrackEnvironment()) == 2 || n2 == 1)) {
            int n14 = n3;
            int n15 = 240;
            for (int i = 0; i < 6; ++i) {
                this.addStaticObject(n15, true, n14 += 65536, n5, n);
            }
        }
        if ((s & 8) != 0) {
            n2 = 229;
            switch (this.m_engine.getTrackEnvironment()) {
                case 1: {
                    n2 = 244;
                    break;
                }
                case 2: {
                    n2 = 234;
                    break;
                }
                case 0: {
                    n2 = 235;
                }
            }
            this.addStaticObject(n2, true, n3, n5, n);
            this.addStaticObject(n2, true, n10, n4, n);
            this.addStaticObject(n2, true, n11, n5, n);
            this.addStaticObject(n2, true, n12, n4, n);
        }
        if ((s & 0x10) != 0) {
            if (this.m_engine.getTrackEnvironment() == 0) {
                if ((n & 1) == 0) {
                    this.addStaticObject(237, true, n11, n5, n);
                    this.addStaticObject(238, true, n12, n4, n);
                } else {
                    this.addStaticObject(237, true, n11, n4, n);
                    this.addStaticObject(238, true, n12, n5, n);
                }
            } else if ((n & 1) == 0) {
                this.addStaticObject(241, true, n11, n5, n);
                this.addStaticObject(242, true, n12, n4, n);
            } else {
                this.addStaticObject(241, true, n11, n4, n);
                this.addStaticObject(242, true, n12, n5, n);
            }
        }
        if ((s & 0x20) != 0) {
            if ((n & 1) == 0) {
                this.addStaticObject(236, true, n11, n5, n);
                this.addStaticObject(236, true, n12, n4, n);
            } else {
                this.addStaticObject(236, true, n11, n4, n);
                this.addStaticObject(236, true, n12, n5, n);
            }
        }
        if ((s & 0x40) != 0) {
            this.addManyObjects(246, true, 246, true, n11 - 78643, n10 - 78643, n12 - 78643, n5, n4, n);
        }
    }

    private void sortStaticTrackObjects() {
        int[][] nArray = this.m_staticTrackObjects;
        boolean bl = false;
        while (!bl) {
            bl = true;
            for (int i = 0; i < 99; ++i) {
                int[] nArray2 = nArray[i];
                int[] nArray3 = nArray[i + 1];
                if (nArray2[2] <= nArray3[2]) continue;
                int[] nArray4 = nArray2;
                nArray[i] = nArray3;
                nArray[i + 1] = nArray4;
                bl = false;
            }
        }
    }

    private final void DEBUG_PRINT_STATIC_OBJECT_2D(int n) {
    }

    private void addManyObjects(int n, boolean bl, int n2, boolean bl2, int n3, int n4, int n5, int n6, int n7, int n8) {
        this.addStaticObject(n, bl, n3, n6, n8);
        this.addStaticObject(n2, bl2, n3, n7, n8);
        this.addStaticObject(n2, bl2, n5, n6, n8);
        this.addStaticObject(n, bl, n5, n7, n8);
    }

    private void addStaticObject(int n, boolean bl, int n2, int n3, int n4) {
        if (n != 245) {
            return;
        }
        if (this.m_currentStaticObjIndex >= 100) {
            return;
        }
        int n5 = 99 - this.m_currentStaticObjIndex;
        int[] nArray = this.m_staticTrackObjects[n5];
        nArray[0] = n;
        nArray[1] = bl ? 1 : 0;
        nArray[2] = n2;
        nArray[3] = n3;
        nArray[4] = 0;
        nArray[5] = 0;
        nArray[6] = 0;
        nArray[7] = 0;
        nArray[8] = 0;
        nArray[9] = n4;
        ++this.m_currentStaticObjIndex;
    }

    private void renderStaticObjs(int n, int n2, int n3, int n4, int n5, int n6, int n7, int[] nArray) {
        int n8;
        int n9 = n8 = this.m_currStaticObjRenderIndex;
        int[][] nArray2 = this.m_staticTrackObjects;
        int[] nArray3 = nArray2[n8];
        int n10 = TRACK1_WIDTHS[n] << 15;
        int n11 = nArray[n];
        int n12 = nArray3[2];
        int n13 = this.calcDistance(n7, n12);
        if (n13 < this.m_perspectiveRangesF[0]) {
            while (n13 > n4 && n13 <= n5) {
                int n14 = nArray3[3];
                int n15 = MathExt.mulF(n14, n10);
                n15 = MathExt.mulF(n15, 52428) >> 16;
                nArray3[7] = n3 + n15 + n11;
                nArray3[8] = n2;
                nArray3[6] = n13;
                nArray3[5] = n6;
                nArray3[4] = n;
                if (--n9 < 0) {
                    n9 += 100;
                }
                if (n8 == n9) break;
                nArray3 = nArray2[n9];
                n12 = nArray3[2];
                n13 = this.calcDistance(n7, n12);
            }
        }
        this.m_currStaticObjRenderIndex = n9;
    }

    private void renderStaticObj(Graphics graphics, int n) {
        int[] nArray = this.m_staticTrackObjects[n];
        int n2 = nArray[0];
        int n3 = nArray[1];
        int n4 = nArray[6];
        int n5 = nArray[4];
        int n6 = nArray[7];
        int n7 = nArray[8];
        int n8 = nArray[3];
        if (n2 >= 0) {
            if (n3 == 1) {
                int n9 = SCALE_HORIZON_F + MathExt.mulF(n5 << 16, SCALE_INV_ROAD_F);
                AnimationManager.drawScaledPrimitives(graphics, n2, 0, n6, n7, n9, n9, n8 > 0);
            } else {
                AnimationManager.drawAnimFrame(graphics, n2, this.getObjectFrameFromDistance(n4), n6, n7);
            }
        }
    }

    private int getFurthestVisibileStaticObjTrackOrder() {
        int n = this.m_viewPosF;
        int[][] nArray = this.m_staticTrackObjects;
        int n2 = -1;
        int n3 = -1;
        int n4 = this.m_perspectiveRangesF[0];
        for (int i = 0; i < 100; ++i) {
            int n5 = nArray[i][2];
            int n6 = this.calcDistance(n, n5);
            if (n6 > n4 || n6 < n2) continue;
            n2 = n6;
            n3 = i;
        }
        return n3;
    }

    private int getObjectFrameFromDistance(int n) {
        if (n > 537591) {
            return 0;
        }
        if (n > 458752) {
            return 1;
        }
        if (n > 393216) {
            return 2;
        }
        if (n > 327680) {
            return 3;
        }
        if (n > 262144) {
            return 4;
        }
        if (n > 196608) {
            return 5;
        }
        if (n > 65536) {
            return 6;
        }
        return 7;
    }

    private void initTrackObjectOrderArrays() {
        int n = 0;
        for (int i = 0; i < this.m_trackObjects.length; ++i) {
            TrackObject trackObject;
            this.m_carsTrackOrder[i] = trackObject = this.m_trackObjects[this.m_trackObjects.length - i - 1];
            if (this.m_carsRaceOrder == null || !trackObject.isRacer()) continue;
            this.m_carsRaceOrder[n] = trackObject;
            ++n;
        }
    }

    private void sortCarsTrackOrder() {
        TrackObject[] trackObjectArray = this.m_carsTrackOrder;
        int n = trackObjectArray.length;
        boolean bl = false;
        int n2 = n - 1;
        while (!bl) {
            bl = true;
            for (int i = 0; i < n2; ++i) {
                int n3 = trackObjectArray[i].getSplineDistance();
                int n4 = trackObjectArray[i + 1].getSplineDistance();
                if (n4 >= n3) continue;
                TrackObject trackObject = trackObjectArray[i];
                trackObjectArray[i] = trackObjectArray[i + 1];
                trackObjectArray[i + 1] = trackObject;
                bl = false;
            }
            --n2;
        }
    }

    private void sortCarsRaceOrder() {
        int n;
        int n2;
        TrackObject[] trackObjectArray = this.m_carsRaceOrder;
        int n3 = trackObjectArray.length;
        boolean bl = false;
        int n4 = n3 - 1;
        while (!bl) {
            bl = true;
            for (n2 = 0; n2 < n4; ++n2) {
                boolean bl2;
                n = trackObjectArray[n2].getSplineDistance();
                int n5 = trackObjectArray[n2 + 1].getSplineDistance();
                int n6 = trackObjectArray[n2].getNumLapsCompleted();
                int n7 = trackObjectArray[n2 + 1].getNumLapsCompleted();
                boolean bl3 = trackObjectArray[n2].isInRace();
                if (!this.carIsAhead(bl3, n6, n, bl2 = trackObjectArray[n2 + 1].isInRace(), n7, n5)) continue;
                TrackObject trackObject = trackObjectArray[n2];
                trackObjectArray[n2] = trackObjectArray[n2 + 1];
                trackObjectArray[n2 + 1] = trackObject;
                bl = false;
            }
            --n4;
        }
        n2 = this.m_playerCar.getRacePos();
        for (n = 0; n < n3; ++n) {
            trackObjectArray[n].setRacePos(n3 - n - 1);
        }
        if (n2 != this.m_playerCar.getRacePos()) {
            this.hudRedraw(this.m_hudText);
        }
    }

    private final boolean carIsAhead(boolean bl, int n, int n2, boolean bl2, int n3, int n4) {
        if (bl && !bl2) {
            return true;
        }
        if (!bl && bl2) {
            return false;
        }
        if ((this.m_trackFlags & 1) != 0) {
            if (n3 < n) {
                return true;
            }
            if (n == n3 && n4 < n2) {
                return true;
            }
        } else if (n4 < n2) {
            return true;
        }
        return false;
    }

    private void updateTrackVisibility() {
        NonUniformSpline nonUniformSpline = this.m_trackRailSpline;
        int n = this.m_playerCar.getSplineDistance();
        int n2 = nonUniformSpline.normaliseDistance(n - 52428);
        int n3 = nonUniformSpline.normaliseDistance(n - 52428 + 655360);
        int n4 = nonUniformSpline.getNodeAtDistance(n2);
        int n5 = nonUniformSpline.getNodeAtDistance(n3);
        int n6 = nonUniformSpline.getSectionAtNode(n4);
        int n7 = nonUniformSpline.getSectionAtNode(n5);
        boolean bl = false;
        if (n6 != this.m_prevStartSection) {
            this.hideTrackSection(this.m_prevStartSection);
            bl = true;
        }
        this.m_prevStartSection = n6;
        if (n7 != this.m_prevEndSection) {
            this.showTrackSection(n7);
            bl = true;
        }
        this.m_prevEndSection = n7;
        if (bl) {
            this.sortStaticTrackObjects();
        }
    }

    private void showTrackSection(int n) {
        int n2;
        AppEngine appEngine = this.m_engine;
        int n3 = this.m_objectRefXs.length;
        for (n2 = 0; n2 < n3; ++n2) {
            TrackObject trackObject;
            if (this.m_objectRefSections[n2] != n || (appEngine.getObjectFlags(this.m_objectRefTypes[n2]) & 0x10) != 0 || (this.m_objectRefTypes[n2] == 4 || this.m_objectRefTypes[n2] == 5) && this.m_objectRefSpawned[n2] || this.m_objectRefTypes[n2] == 11 || this.m_objectRefTypes[n2] == 12 || this.m_objectRefTypes[n2] == 13 || this.m_objectRefTypes[n2] == 14 || (trackObject = this.createObject(this.m_objectRefTypes[n2], -1, this.m_objectRefZs[n2], this.m_objectRefXs[n2])) == null) continue;
            trackObject.setObjectRefId((short)n2);
            this.m_objectRefSpawned[n2] = true;
        }
        if (this.m_carsTrackOrder != null && this.m_carsTrackOrder[0] != null) {
            this.sortCarsTrackOrder();
        }
        this.addStaticObjectsForTrackSection(n);
        if (this.m_eventType != 6) {
            n2 = -1;
            if (this.m_trackStartLineSection == n && (this.m_trackFlags & 2) == 0 && this.m_playerCar.isInLap()) {
                n2 = this.m_trackStartLineDistF;
            } else if (this.m_trackFinishLineSection == n && this.m_trackFinishLineDistF != this.m_trackRailSpline.getMaxDistance()) {
                n2 = this.m_trackFinishLineDistF;
            }
            if (n2 != -1) {
                this.addStaticObject(245, true, n2, 0, n);
            }
        }
    }

    private void hideTrackSection(int n) {
        TrackObject[] trackObjectArray = this.m_trackObjects;
        for (int i = 0; i < trackObjectArray.length; ++i) {
            TrackObject trackObject = trackObjectArray[i];
            short s = trackObject.getObjectRefId();
            if (!trackObject.isInitialised() || !trackObject.getFlags(16) || s < 0 || this.m_objectRefSections[s] != n) continue;
            trackObject.destroy();
        }
        this.removeStaticObjectsForTrackSection(n);
    }

    public void render(Graphics graphics) {
        int n = this.m_flowManager.getCurrentState();
        if (n == 49 || n == 46) {
            return;
        }
        this.renderFlowLayout(graphics);
        if (this.m_loadingProgress < 100) {
            this.m_layoutManager.drawLayout(graphics, 69, 0, 0, 176, 208, 0);
        }
    }

    private void renderFlowLayout(Graphics graphics) {
        this.m_flowManager.render(graphics, 0, 0, 176, 208);
    }

    private void renderViewport(Graphics graphics) {
        boolean bl;
        int n = this.m_flowManager.getCurrentState();
        boolean bl2 = bl = !this.m_flowManager.isStateInStack((short)50);
        if (this.m_flowManager.isInTransition() || this.m_refreshViewport || n != 60 && n != 62 && n != 61) {
            this.render2D(graphics);
            this.m_refreshViewport = false;
        }
        if (n == 48) {
            this.renderStartLights(graphics);
        }
        if (bl) {
            int n2 = this.m_layoutManager.getAnimationStopTime(25, 0);
            this.m_layoutManager.drawLayout(graphics, 25, 0, 0, 176, 208, n2);
        }
        this.renderScore(graphics);
        this.renderNotifyBox(graphics);
        this.renderCoolWordingBox(graphics);
    }

    public void processInput(int n, int[] nArray) {
        this.m_flowManager.processInput(n, nArray);
        switch (n) {
            case 0: {
                if (this.m_flowManager.isInTransition()) {
                    return;
                }
                int n2 = nArray[1];
                int n3 = nArray[0];
                switch (this.m_flowManager.getCurrentState()) {
                    case 45: 
                    case 46: {
                        break;
                    }
                    case 50: 
                    case 58: {
                        this.processKeysDriving(n2, n3);
                        if (this.m_eventType != 7) break;
                        this.processKeysTutorial(n2, n3);
                        break;
                    }
                    case 56: {
                        if (!this.checkKeys(n2, n3, 4128, 1)) break;
                        this.endState();
                    }
                }
                break;
            }
        }
    }

    private final boolean isRaceEvent() {
        switch (this.m_eventType) {
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                return false;
            }
        }
        return true;
    }

    private static boolean keyPressed(int n, int n2) {
        return (n & n2) != 0;
    }

    private boolean isBoostAvailable() {
        return this.m_eventType != 7 || this.m_tutorialState >= 11 && this.m_tutorialState < 24;
    }

    private void processKeysDriving(int n, int n2) {
        TrackObject trackObject = this.m_playerCar;
        if (trackObject.isCrashing()) {
            return;
        }
        trackObject.setAccelerating(true);
        trackObject.setBraking(false);
        this.m_steeringFlags = 0;
        if (SceneGame.keyPressed(32784, n)) {
            this.m_steeringFlags |= 1;
        }
        if (SceneGame.keyPressed(65600, n)) {
            this.m_steeringFlags |= 2;
        }
        if (this.checkKeys(n, n2, 8196, 0) && this.m_boostGaugeLevelF > 0x140000 && this.m_nitroLevel > 0 && (this.m_flowManager.getCurrentState() == 50 || this.m_flowManager.getCurrentState() == 58) && !trackObject.isBoosting() && this.isBoostAvailable()) {
            trackObject.setBoosting(true);
            this.m_driftBoosting = false;
            if (this.m_eventType == 7 && this.m_tutorialState == 11) {
                this.m_tutorialBoostUsed = true;
            }
        }
        if (SceneGame.keyPressed(16640, n)) {
            if (trackObject.getSpeedF() >> 12 > 0) {
                this.m_engine.playSound(7);
            }
            trackObject.setBraking(true);
        }
    }

    private final void DEBUG_COLLISIONS(String string) {
    }

    public final void DEBUG_CRASHES(String string) {
    }

    private void updateCollisionsAndProximity() {
        AppEngine appEngine = this.m_engine;
        TrackObject[] trackObjectArray = this.m_carsTrackOrder;
        int n = trackObjectArray.length;
        for (int i = 0; i < n; ++i) {
            int n2;
            int n3;
            TrackObject trackObject;
            int n4;
            TrackObject trackObject2 = trackObjectArray[i];
            if (!trackObject2.isInitialised()) continue;
            if (trackObject2.getFlags(16)) {
                trackObject2.updateMiniMapNodes();
                continue;
            }
            int n5 = 0;
            int n6 = 0;
            while (n6 < 3) {
                n4 = i + n5 + 1;
                if (n4 >= n) {
                    n4 -= n;
                }
                if (n4 == i) break;
                trackObject = trackObjectArray[n4];
                if (trackObject.isInitialised()) {
                    n3 = 1;
                    ++n6;
                    if (this.collisionCheck(trackObject2, trackObject)) {
                        if (trackObject2.isPlayerCar() || trackObject.isPlayerCar()) {
                            appEngine.vibrate(250);
                            this.m_nearMissTimer = 500;
                        }
                        if (trackObject.getFlags(16)) {
                            n2 = trackObject.getObjectType();
                            int n7 = n3 = trackObject2.isPlayerCar() || appEngine.isPlayerCop() || trackObject2.getFlags(1) && !trackObject2.isPlayerCar() && n2 != 24 && n2 != 23 ? 1 : 0;
                            if (n3 != 0) {
                                if (trackObject.getObjectType() == 24) {
                                    this.m_engine.playSound(11);
                                } else {
                                    this.m_engine.playSound(10);
                                }
                                this.collisionResponseCar2Obstacle(trackObject2, trackObject);
                            }
                        } else {
                            this.collisionResponseCar2Car(trackObject2, trackObject);
                            this.m_engine.playSound(8);
                        }
                        if (n3 != 0) {
                            trackObject2.onCollision(trackObject);
                            trackObject.onCollision(trackObject2);
                        }
                    } else if (this.m_nearMissTimer <= 0 && this.nearMissCheck(trackObject2, trackObject)) {
                        this.processTrackEvent(1);
                        this.m_nearMissTimer = 500;
                    }
                }
                ++n5;
            }
            n5 = 0;
            n6 = 0;
            if (trackObject2.getFlags(1) && trackObject2.distanceToPlayer() < 196608 && (trackObject2.getRacerProximity() == null || trackObject2.getCivilianProximity() == null) && trackObject2.getFlags(14)) {
                int n8;
                int n9;
                if (trackObject2.getDirection() == 0) {
                    n4 = 0;
                    while (!trackObject2.getFlags(2) || trackObject2.getRacerProximity() == null) {
                        n3 = i + n4 + 1;
                        if (n3 >= n) {
                            n3 -= n;
                        }
                        if (n3 == i) break;
                        trackObject = trackObjectArray[n3];
                        if (trackObject.getFlags(1)) {
                            n2 = trackObject2.getSplineDistanceTo(trackObject);
                            n9 = Math.abs(trackObject.latDistanceToOther(trackObject2));
                            if (n2 > -58982 && n2 < 419430 && n9 < 52428) {
                                if (trackObject2.getFlags(12)) {
                                    if (trackObject.getFlags(12) || trackObject.isPlayerCar()) {
                                        if (trackObject2.getRacerProximity() == null) {
                                            trackObject2.setRacerProximity(trackObject);
                                            n5 = n9;
                                        } else if (n9 < n5) {
                                            trackObject2.setRacerProximity(trackObject);
                                            n5 = n9;
                                        }
                                    } else if (trackObject.getFlags(2)) {
                                        n8 = Math.abs(trackObject2.latDistanceToOther(trackObject));
                                        if (trackObject2.getCivilianProximity() == null) {
                                            trackObject2.setCivilainProximity(trackObject);
                                            n6 = n8;
                                        } else if (n8 < n6) {
                                            trackObject2.setCivilainProximity(trackObject);
                                            n6 = n8;
                                        }
                                    }
                                } else if (trackObject2.getFlags(2)) {
                                    trackObject2.setRacerProximity(trackObject);
                                }
                            }
                        }
                        ++n4;
                    }
                } else {
                    n4 = 0;
                    n3 = 0;
                    while (n4 < 3) {
                        n2 = i - (n3 + 1);
                        if (n2 < 0) {
                            n2 += n;
                        }
                        if (n2 == i) break;
                        trackObject = trackObjectArray[n2];
                        if (trackObject.getFlags(1)) {
                            ++n4;
                            n9 = trackObject.getSplineDistanceTo(trackObject2);
                            n8 = Math.abs(trackObject.latDistanceToOther(trackObject2));
                            if (n9 > 0 && n9 < 419430 && n8 < 52428) {
                                trackObject2.setRacerProximity(trackObject);
                                break;
                            }
                        }
                        ++n3;
                    }
                }
            }
            trackObject2.updateMiniMapNodes();
        }
        if (!(this.m_eventType != 7 || this.m_tutorialState != 32 && this.m_tutorialState != 34 || this.m_tutorialKeyPressed || this.m_lastBlockade == null || this.m_tutorialCriminal.getSplineDistanceTo(this.m_lastBlockade) >= 0)) {
            this.collisionResponseCar2Obstacle(this.m_tutorialCriminal, this.m_lastBlockade);
            this.m_tutorialCriminal.onCollision(this.m_lastBlockade);
            this.m_lastBlockade.onCollision(this.m_tutorialCriminal);
        }
    }

    private boolean nearMissCheck(TrackObject trackObject, TrackObject trackObject2) {
        if (!trackObject.isPlayerCar()) {
            return false;
        }
        if (trackObject2.getNotFlags(1) || trackObject2.isHotAfterPlayerHit()) {
            return false;
        }
        if (trackObject.getSpeedF() < 393216) {
            return false;
        }
        if (this.closeCallCheck(trackObject, trackObject2)) {
            int n = 0;
            n = TrackObject.isOppositeDirection(trackObject, trackObject2) ? trackObject.getSpeedF() + trackObject2.getSpeedF() : Math.abs(trackObject.getSpeedF() - trackObject2.getSpeedF());
            return n > 393216;
        }
        return false;
    }

    private boolean collisionCheck(TrackObject trackObject, TrackObject trackObject2) {
        if (!trackObject.canCollide() || !trackObject2.canCollide()) {
            return false;
        }
        if (trackObject.distanceToPlayer() > 196608 || trackObject2.distanceToPlayer() > 196608) {
            return false;
        }
        int n = trackObject.getSplineDistanceTo(trackObject2);
        if (n > 58982 || n < 0) {
            return false;
        }
        int n2 = trackObject.latDistanceToOther(trackObject2);
        int n3 = Math.abs(n2);
        if (n3 > 58982) {
            return false;
        }
        this.calculateObjectCollisonBB(trackObject, this.m_carCollisionBB1);
        this.calculateObjectCollisonBB(trackObject2, this.m_carCollisionBB2);
        return this.testIntersection(this.m_carCollisionBB1, this.m_carCollisionBB2);
    }

    private boolean testIntersection(int[] nArray, int[] nArray2) {
        return nArray[1] <= nArray2[3] && nArray2[1] <= nArray[3] && nArray[0] <= nArray2[2] && nArray2[0] <= nArray[2];
    }

    private final void collisionResponseCar2Car(TrackObject trackObject, TrackObject trackObject2) {
        int n;
        this.DEBUG_COLLISIONS("Detected car collision");
        TrackObject trackObject3 = this.m_playerCar;
        int n2 = trackObject.getRotatedWidth();
        int n3 = trackObject.getRotatedLength();
        int n4 = trackObject.getLateralPosF();
        int n5 = trackObject2.getRotatedWidth();
        int n6 = trackObject2.getRotatedLength();
        int n7 = trackObject2.getLateralPosF();
        int n8 = this.m_trackRailSpline.getMaxDistance();
        int n9 = trackObject2.getPrevLateralPosF() - trackObject.getPrevLateralPosF();
        int n10 = trackObject2.getPrevPosF() - trackObject.getPrevPosF();
        if (Math.abs(n10) > n8 >> 1) {
            n10 = n10 > 0 ? (n10 -= n8) : (n10 += n8);
        }
        boolean bl = trackObject == trackObject3 || trackObject2 == trackObject3;
        trackObject.setColliding(true);
        trackObject2.setColliding(true);
        if ((trackObject.isPlayerCar() || trackObject2.isPlayerCar()) && !this.m_playerImpactSparkAnimPlayer.isAnimating()) {
            this.m_playerImpactSparkX = trackObject.getRenderPosX() + trackObject2.getRenderPosX() >> 1;
            if (trackObject.isPlayerCar()) {
                this.m_playerBumpedFront = true;
                this.m_playerImpactSparkY = trackObject2.getRenderPosY() + -12;
            } else if (trackObject2.isPlayerCar()) {
                this.m_playerBumpedFront = false;
                this.m_playerImpactSparkY = trackObject2.getRenderPosY() + -12;
            }
            this.m_playerImpactSparkAnimPlayer.startAnim(143, 16);
            this.m_playerImpactSparkAnimPlayer.setAnimating(true);
        }
        if (Math.abs(n9) < n2 + n5 >> 1 && Math.abs(n10) > n3 + n6 >> 1) {
            this.DEBUG_COLLISIONS("*** Head collision ***");
            n = this.determineHeadonVisuals(trackObject, trackObject2);
            this.resolveHeadonCollision(trackObject, trackObject2);
        } else {
            this.DEBUG_COLLISIONS("*** Side collision ***");
            n = this.determineSideVisuals(trackObject, trackObject2);
            this.resolveSideCollision(trackObject, n2, trackObject2, n5);
        }
        if (bl) {
            TrackObject trackObject4 = trackObject == trackObject3 ? trackObject2 : trackObject;
            this.setAggressionOpponent(trackObject4);
            if (!trackObject4.isHotAfterPlayerHit()) {
                if (trackObject4.isCivilian()) {
                    this.processTrackEvent(4, n);
                } else {
                    this.processTrackEvent(6, n);
                }
            }
            this.m_cleanRace = false;
            this.m_cleanOvertake = false;
        }
        if (bl) {
            boolean bl2 = false;
            boolean bl3 = false;
            if (this.m_engine.isPlayerCop()) {
                if (trackObject.isCriminal() || trackObject2.isCriminal()) {
                    bl2 = true;
                    if (this.m_timeSinceLastCollision >= 500) {
                        this.m_engine.updateTrophyData(512, 1);
                    }
                }
            } else {
                TrackObject trackObject5;
                TrackObject trackObject6 = trackObject.isCopCar() ? trackObject : (trackObject5 = trackObject2.isCopCar() ? trackObject2 : null);
                if (trackObject5 != null) {
                    bl3 = true;
                    bl2 = trackObject5.getFlags(0x1000000);
                }
            }
            if (bl2 && this.m_timeSinceLastCollision >= 500 && n != 7) {
                int n11 = this.m_engine.getEventPursuitHitRiseF(this.m_engine.getCurrentRaceEventIndex());
                if (n11 != 0) {
                    this.increasePursuitLevel(n11);
                } else if (this.m_eventType == 6) {
                    this.increasePursuitLevel(0x280000);
                } else {
                    this.increasePursuitLevel(0x120000);
                }
            }
            if (bl3) {
                this.m_timeSinceLastCollision = 0;
            }
        }
    }

    private final void postCollision(TrackObject trackObject, int n, int n2, TrackObject trackObject2, int n3, boolean bl) {
        int n4 = bl ? n + n2 + n3 : n - n2 - n3;
        int n5 = Math.abs(trackObject.getLateralSpeedF() - trackObject2.getLateralSpeedF());
        int n6 = Math.min(65536, MathExt.mulF(n5, 13429));
        int n7 = MathExt.mulF(655360, n6);
        if (bl) {
            trackObject.setRightWall(n);
            trackObject2.setLeftWall(n4);
            trackObject2.setLateralForceF(n7);
        } else {
            trackObject.setLeftWall(n);
            trackObject2.setRightWall(n4);
            trackObject2.setLateralForceF(-n7);
        }
        int n8 = trackObject.getSplineDistanceTo(trackObject2);
        int n9 = trackObject.getRotatedLength() + trackObject2.getRotatedLength() >> 2;
        if (n8 < n9) {
            int n10 = trackObject.getLateralPosF();
            int n11 = trackObject2.getPrevLateralPosF();
            int n12 = MathExt.mulF(n2, 98304);
            int n13 = MathExt.mulF(n3, 98304);
            if (bl && n10 + n12 > n11 - n13) {
                trackObject2.setLateralPosF(n10 + n12 + n13);
            } else if (!bl && n10 - n12 < n11 + n13) {
                trackObject2.setLateralPosF(n10 - n12 - n13);
            }
        }
    }

    private final void resolveHeadonCollision(TrackObject trackObject, TrackObject trackObject2) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5 = trackObject.getSpeedF();
        int n6 = trackObject2.getSpeedF();
        TrackObject trackObject3 = this.m_playerCar;
        if (trackObject == trackObject3) {
            if (this.causesFlip(trackObject2)) {
                this.startDramaticCrash();
            } else {
                n4 = TrackObject.isOppositeDirection(trackObject, trackObject2) ? n5 + n6 : n5 - n6;
                n3 = MathExt.mulF(n4, 8738);
                n3 = Math.min(65536, n3);
                this.startCollisionShake(n3);
            }
        }
        if (trackObject.getFlags(0x800000) || trackObject2.getFlags(0x800000)) {
            int n7;
            TrackObject trackObject4;
            TrackObject trackObject5;
            if (trackObject.getFlags(0x800000)) {
                trackObject5 = trackObject;
                trackObject4 = trackObject2;
                n7 = n6;
            } else {
                trackObject5 = trackObject2;
                trackObject4 = trackObject;
                n7 = n5;
            }
            int n8 = MathExt.mulF(n7, 52428);
            int n9 = MathExt.mulF(n7, 36044);
            n8 = TrackObject.isOppositeDirection(trackObject5, trackObject4) ? -n8 : (n8 += MathExt.mulF(n9, 19660));
            int n10 = trackObject5.getLateralPosF();
            int n11 = trackObject4.getLateralPosF();
            int n12 = MathExt.mulF(n7, 10485);
            int n13 = MathExt.mulF(144179, n12);
            if (n10 > n11) {
                trackObject5.setLateralForceF(n13);
            } else {
                trackObject5.setLateralForceF(-n13);
            }
            if (trackObject == trackObject5) {
                n2 = n8;
                n = n9;
            } else {
                n2 = n9;
                n = n8;
            }
        } else if (TrackObject.isOppositeDirection(trackObject, trackObject2)) {
            if (trackObject2 == this.m_playerCar) {
                return;
            }
            n2 = MathExt.mulF(n5, 19660);
            n = -MathExt.mulF(n5, 65536);
        } else {
            if (trackObject == trackObject3) {
                n4 = n5 - n6;
                n3 = MathExt.mulF(n4, 8738);
                n3 = Math.min(65536, n3);
                this.startCollisionShake(n3);
            }
            n2 = Math.max(0, MathExt.mulF(n6, 58982));
            n = n6 + Math.max(0, MathExt.mulF(n5, 3276));
            if (trackObject2 != trackObject3) {
                int n14 = trackObject.getLateralPosF();
                int n15 = trackObject2.getLateralPosF();
                int n16 = Math.min(MathExt.divF(Math.abs(n14 - n15), 19660), 65536);
                if (n14 > n15) {
                    trackObject2.setLateralForceF(-MathExt.mulF(216268, n16));
                } else {
                    trackObject2.setLateralForceF(MathExt.mulF(216268, n16));
                }
            }
        }
        trackObject.setSpeedF(n2);
        trackObject2.setSpeedF(n);
        int n17 = trackObject.getSplineDistance();
        trackObject2.setSplineDistance(n17 += trackObject.getLength() + 6553);
        trackObject2.updateWorldPos();
    }

    private final boolean causesFlip(TrackObject trackObject) {
        if (trackObject.getState() == 8 || trackObject.getState() == 9) {
            return false;
        }
        return trackObject.getDirection() == 1 && this.m_playerCar.getSpeedF() > 491520;
    }

    private final boolean causesFlip(TrackObject trackObject, TrackObject trackObject2) {
        if (trackObject2.getState() == 8 || trackObject2.getState() == 9) {
            return false;
        }
        return trackObject2.getDirection() == 1 && trackObject.getSpeedF() > 491520;
    }

    private final void resolveSideCollision(TrackObject trackObject, int n, TrackObject trackObject2, int n2) {
        int n3;
        int n4;
        int n5;
        boolean bl;
        int n6 = trackObject.getLateralPosF();
        int n7 = trackObject2.getLateralPosF();
        TrackObject trackObject3 = this.m_playerCar;
        TrackObject trackObject4 = trackObject == this.m_playerCar ? trackObject2 : trackObject;
        boolean bl2 = trackObject == this.m_playerCar || trackObject2 == this.m_playerCar;
        boolean bl3 = trackObject.isCopCar() || trackObject2.isCopCar();
        boolean bl4 = bl = trackObject4.isCopCar() && trackObject4.getFlags(0x1000000);
        if (bl2 && bl3) {
            int n8;
            n5 = trackObject3.getSpeedF();
            n4 = 98304;
            if (bl) {
                n4 = 117964;
            }
            n3 = trackObject == trackObject3 ? n6 : n7;
            int n9 = n8 = trackObject == trackObject3 ? n7 : n6;
            if (n5 > 122880) {
                this.m_collisionSteer = n3 > n8 ? n4 : -n4;
            }
        }
        n5 = n >> 1;
        n4 = n2 >> 1;
        if (n6 < n7) {
            if (trackObject == trackObject3) {
                if (!bl) {
                    this.postCollision(trackObject, n6, n5, trackObject2, n4, true);
                } else {
                    this.postCollision(trackObject2, n7, n4, trackObject, n5, false);
                }
            } else if (trackObject2 == trackObject3) {
                if (!bl) {
                    this.postCollision(trackObject2, n7, n4, trackObject, n5, false);
                } else {
                    this.postCollision(trackObject, n6, n5, trackObject2, n4, true);
                }
            } else {
                n3 = trackObject3.getLateralPosF();
                if (Math.abs(n3 - n6) < Math.abs(n3 - n7)) {
                    this.postCollision(trackObject, n6, n5, trackObject2, n4, true);
                } else {
                    this.postCollision(trackObject2, n7, n4, trackObject, n5, false);
                }
            }
        } else if (trackObject == trackObject3) {
            if (!bl) {
                this.postCollision(trackObject, n6, n5, trackObject2, n4, false);
            } else {
                this.postCollision(trackObject2, n7, n4, trackObject, n5, true);
            }
        } else if (trackObject2 == trackObject3) {
            if (!bl) {
                this.postCollision(trackObject2, n7, n4, trackObject, n5, true);
            } else {
                this.postCollision(trackObject, n6, n5, trackObject2, n4, false);
            }
        } else {
            n3 = trackObject3.getLateralPosF();
            if (Math.abs(n3 - n6) < Math.abs(n3 - n7)) {
                this.postCollision(trackObject, n6, n5, trackObject2, n4, false);
            } else {
                this.postCollision(trackObject2, n7, n4, trackObject, n5, true);
            }
        }
        trackObject.setLateralSpeedF(0);
        trackObject2.setLateralSpeedF(0);
    }

    private final boolean closeCallCheck(TrackObject trackObject, TrackObject trackObject2) {
        if (!trackObject.canCollide() || !trackObject2.canCollide()) {
            return false;
        }
        int n = trackObject.getSplineDistanceTo(trackObject2);
        int n2 = Math.abs(n);
        if (n2 > 19660) {
            return false;
        }
        int n3 = trackObject.latDistanceToOther(trackObject2);
        int n4 = Math.abs(n3);
        return n4 <= 45875;
    }

    private boolean checkPlayerApprehension(TrackObject trackObject, TrackObject trackObject2) {
        if (!trackObject.isPlayerCar() && !trackObject2.isPlayerCar()) {
            return false;
        }
        TrackObject trackObject3 = trackObject.isPlayerCar() ? trackObject : trackObject2;
        int n = Math.abs(trackObject.getSplineDistanceTo(trackObject2));
        if (n > 98304) {
            return false;
        }
        if (trackObject3.getFlags(2048)) {
            return true;
        }
        int n2 = Math.abs(trackObject.latDistanceToOther(trackObject2));
        return n2 <= 65536;
    }

    private boolean checkCriminalApprehension(TrackObject trackObject, TrackObject trackObject2) {
        if (!trackObject.isPlayerCar() && !trackObject2.isPlayerCar()) {
            return false;
        }
        int n = Math.abs(trackObject.getSplineDistanceTo(trackObject2));
        if (n > 78643) {
            return false;
        }
        int n2 = Math.abs(trackObject.latDistanceToOther(trackObject2));
        return n2 <= 45875;
    }

    private boolean checkMapBlink(TrackObject trackObject, TrackObject trackObject2) {
        if (trackObject == null || trackObject2 == null) {
            return false;
        }
        if (!trackObject.isPlayerCar() && !trackObject2.isPlayerCar()) {
            return false;
        }
        int n = Math.abs(trackObject.getSplineDistanceTo(trackObject2));
        if (n > 196608) {
            return false;
        }
        int n2 = Math.abs(trackObject.latDistanceToOther(trackObject2));
        return n2 <= 131072;
    }

    private final int determineHeadonVisuals(TrackObject trackObject, TrackObject trackObject2) {
        int n;
        int n2;
        int n3 = trackObject.getLateralPosF();
        int n4 = trackObject2.getLateralPosF();
        int n5 = -1;
        int n6 = -1;
        if (TrackObject.isOppositeDirection(trackObject, trackObject2)) {
            n5 = 6;
            n6 = this.m_engine.randPercent() < 40 ? 5 : 6;
            n = n2 = n4 > n3 ? 1 : 0;
            if (trackObject.getFlags(4) && this.causesFlip(trackObject, trackObject2)) {
                n5 = 11;
            }
        } else {
            n5 = 6;
            n6 = 7;
            n2 = n4 < n3 ? 1 : 0;
            int n7 = n = n2 == 0 ? 1 : 0;
        }
        if (trackObject.getFlags(0x800000) || trackObject2.getFlags(0x800000)) {
            if (trackObject.getFlags(0x800000)) {
                this.doRagdollVisuals(trackObject, trackObject2);
                n5 = -1;
            }
            if (trackObject2.getFlags(0x800000)) {
                this.doRagdollVisuals(trackObject2, trackObject);
                n6 = -1;
            }
        }
        if (n5 != -1) {
            trackObject.playBumpAnim(n5, n2);
        }
        if (n6 != -1) {
            trackObject2.playBumpAnim(n6, n);
        }
        if (trackObject == this.m_playerCar) {
            return n5;
        }
        return n6;
    }

    private final int determineSideVisuals(TrackObject trackObject, TrackObject trackObject2) {
        int n;
        int n2;
        int n3;
        TrackObject trackObject3;
        TrackObject trackObject4;
        int n4 = trackObject.getSplineCurvature();
        int n5 = trackObject.getLateralPosF();
        int n6 = trackObject2.getLateralPosF();
        int n7 = trackObject.getLateralSpeedF();
        int n8 = trackObject2.getLateralSpeedF();
        int n9 = Math.abs(n7);
        int n10 = Math.abs(n8);
        int n11 = Math.abs(n7 - n8);
        int n12 = -1;
        int n13 = -1;
        if (n5 > n6) {
            trackObject4 = trackObject2;
            trackObject3 = trackObject;
        } else {
            trackObject4 = trackObject;
            trackObject3 = trackObject2;
        }
        TrackObject trackObject5 = null;
        if (n4 > 0) {
            trackObject5 = trackObject4;
        } else if (n4 < 0) {
            trackObject5 = trackObject3;
        }
        int n14 = n11 < 65536 ? 0 : (n11 < 131072 ? 1 : (n11 < 319815 ? 2 : 2));
        n12 = n14;
        n13 = n14;
        if (n9 > n10) {
            --n12;
        } else if (n10 > n9) {
            --n13;
        }
        if (trackObject5 != null && (n3 = this.m_engine.randPercent()) < 40 && trackObject5.getSpeedF() > 327680 && n14 < 2) {
            if (trackObject == trackObject5) {
                n12 = 2;
            } else {
                n13 = 2;
            }
        }
        if (trackObject.getFlags(0x800000)) {
            this.doRagdollVisuals(trackObject, trackObject2);
            return n14;
        }
        if (trackObject2.getFlags(0x800000)) {
            this.doRagdollVisuals(trackObject2, trackObject);
            return n14;
        }
        if (trackObject == trackObject4) {
            n2 = 1;
            n = 0;
        } else {
            n2 = 0;
            n = 1;
        }
        if (n12 != -1) {
            trackObject.playBumpAnim(n12, n2);
        }
        if (n13 != -1) {
            trackObject2.playBumpAnim(n13, n);
        }
        return n14;
    }

    private final void doRagdollVisuals(TrackObject trackObject, TrackObject trackObject2) {
        int n = trackObject.getLateralPosF();
        int n2 = trackObject2.getLateralPosF();
        int n3 = trackObject2.getSpeedF();
        if (!TrackObject.isOppositeDirection(trackObject, trackObject2)) {
            n3 -= trackObject.getSpeedF();
        }
        n3 = Math.min(n3, 614400);
        int n4 = MathExt.divF(n3, 614400);
        int n5 = MathExt.mulF(229376, n4);
        if (n > n2) {
            trackObject.setYawTarget(-n5);
        } else if (n < n2) {
            trackObject.setYawTarget(n5);
        }
        int n6 = MathExt.normaliseAngleRadiansF(trackObject.getCollisionYawF());
        if (n6 < 0) {
            trackObject.playBumpAnim(0, 0);
        } else {
            trackObject.playBumpAnim(0, 0);
        }
    }

    private void collisionResponseCar2Obstacle(TrackObject trackObject, TrackObject trackObject2) {
        this.DEBUG_COLLISIONS("Detected obstacle collision");
        trackObject.setColliding(true);
        trackObject2.setColliding(true);
        int n = this.m_engine.getObjectWeight(trackObject2.getObjectType());
        int n2 = 65536 - n;
        int n3 = n > 0 ? 72089 : 0;
        TrackObject trackObject3 = this.m_playerCar;
        if (trackObject == trackObject3) {
            this.startCollisionShake(n);
            this.m_cleanRace = false;
        }
        int n4 = trackObject.getSpeedF();
        boolean bl = trackObject == trackObject3 && trackObject2.getNotFlags(Integer.MIN_VALUE);
        int n5 = bl ? n4 : Math.max(0, MathExt.mulF(n4, n2));
        int n6 = Math.max(0, MathExt.mulF(n5, n3));
        trackObject.setSpeedF(n5);
        trackObject2.setSpeedF(n6);
        if (n > 32768) {
            trackObject.playBumpAnim(6, 1);
        }
        if (n > 0) {
            trackObject2.hitObstacle(1);
        }
        int n7 = trackObject.getLateralPosF();
        int n8 = trackObject2.getLateralPosF();
        int n9 = n7 + n8 >> 1;
        int n10 = trackObject.getSpeedF();
        int n11 = trackObject.getSplineDistance() + trackObject2.getSplineDistance() >> 1;
        this.triggerSparks(n10, n11, n9);
    }

    public final void addBountyScore(int n) {
        if (n != 0) {
            this.addScore(n, 4);
            this.m_careerExtraBounty += n;
        }
    }

    private void triggerSparks(int n, int n2, int n3) {
    }

    public void initDisplayDimensionsAndOffsets() {
        VIEWPORT_LEFT = 0;
        VIEWPORT_TOP = 0;
        VIEWPORT_WIDTH = 176;
        VIEWPORT_HEIGHT = 208;
        VIEWPORT_CENTRE_X = VIEWPORT_LEFT + (VIEWPORT_WIDTH >> 1);
        this.initHUD();
        TRACK_VIEWPORT_HEIGHT = VIEWPORT_HEIGHT;
    }

    private final void DEBUG_HUD(String string) {
    }

    private final void initHUD() {
        AppEngine appEngine = this.m_engine;
        int[] nArray = this.m_hudSpeedoDim;
        nArray[2] = 176;
        nArray[3] = 0;
        nArray[0] = 176;
        nArray[1] = 208 - this.m_hudSpeedoDim[3];
        if (this.m_eventType != 7) {
            this.m_hudRightEdgeOffsetF = this.m_hudSpeedoDim[2] + nArray[2] << 16;
            this.m_hudLeftEdgeOffsetF = -2949120;
        }
        HUD_LAPS_X = 6;
        HUD_LAPS_Y = 208 - this.m_textManager.getLineHeight(3) - 2;
        HUD_MAP_LINE_POSITION_Y = VIEWPORT_HEIGHT - 5;
        HUD_UPPER_HORIZ_LINE_POSITION_Y = HUD_MAP_LINE_POSITION_Y - 5;
        HUD_MAP_LINE_LEFT_POSITION_X = 17;
        HUD_MAP_LINE_RIGHT_POSITION_X = VIEWPORT_WIDTH - 85 - 5;
    }

    private final void hudRedraw(int n) {
        if (n == -1) {
            n &= 0xFFDFFDFF | this.m_hudText;
        }
        this.m_hudRedrawFlags |= n;
    }

    private final void hudNoDraw(int n) {
        this.m_hudRedrawFlags &= ~n;
    }

    private final boolean hudNeedsDraw(int n) {
        return (this.m_hudRedrawFlags & n) != 0;
    }

    private final void updateHUD(int n) {
        switch (this.m_flowManager.getCurrentState()) {
            case 45: {
                this.m_hudRedrawFlags = 0;
                this.hudRedraw(262144);
                return;
            }
            case 48: {
                this.hudRedraw(131072);
                break;
            }
            case 51: {
                this.m_hudRedrawFlags = 0;
                this.hudRedraw(131072);
                return;
            }
            case 59: {
                this.m_hudRedrawFlags = 0;
                return;
            }
            case 47: {
                this.m_hudRedrawFlags = 0;
                this.hudRedraw(393216);
                return;
            }
        }
        this.hudRedraw(16);
        this.hudRedraw(1);
        if (!this.isPaused()) {
            this.m_hudLapTimer -= n;
            if (this.m_hudLapTimer < 0) {
                this.m_hudLapTimer += 4000;
            }
            if (this.m_scoreState != 0) {
                this.updateScore(n);
            }
        }
        switch (this.m_eventType) {
            case 7: {
                this.m_hudText = 0;
                if (this.m_tutorialState > 0) {
                    this.hudRedraw(524288);
                } else {
                    this.hudNoDraw(524288);
                }
                if (this.m_eventType != 7) break;
                this.hudNoDraw(0x100000);
                break;
            }
            default: {
                this.m_hudText = 512;
                this.hudRedraw(this.m_hudText);
            }
        }
        this.hudNoDraw(2);
        if (this.m_playerCar != null) {
            this.hudRedraw(4);
        }
    }

    private final void updateHUDRollin(int n) {
        if (this.isRaceEvent()) {
            if ((this.m_startLightsState == 0 || this.m_startLightsState == 1) && this.m_hudRightEdgeOffsetF > 0) {
                this.m_hudRightEdgeOffsetF -= MathExt.mulF(0x460000, n << 6);
                if (this.m_hudRightEdgeOffsetF < 0) {
                    this.m_hudRightEdgeOffsetF = 0;
                }
            }
            if (this.m_startLightsState == -1 && this.m_hudLeftEdgeOffsetF < 0) {
                this.m_hudLeftEdgeOffsetF += MathExt.mulF(0x1E0000, n << 6);
                if (this.m_hudLeftEdgeOffsetF > 0) {
                    this.m_hudLeftEdgeOffsetF = 0;
                }
            }
        } else if (this.m_flowManager.getCurrentState() == 50) {
            if (this.m_hudRightEdgeOffsetF > 0) {
                this.m_hudRightEdgeOffsetF -= MathExt.mulF(0xE60000, n << 6);
                if (this.m_hudRightEdgeOffsetF < 0) {
                    this.m_hudRightEdgeOffsetF = 0;
                }
                this.hudRedraw(131072);
            }
            if (this.m_hudLeftEdgeOffsetF < 0) {
                this.m_hudLeftEdgeOffsetF += MathExt.mulF(0x780000, n << 6);
                if (this.m_hudLeftEdgeOffsetF > 0) {
                    this.m_hudLeftEdgeOffsetF = 0;
                }
            }
        }
    }

    private final void preRenderHUD() {
        if (this.hudNeedsDraw(16)) {
            boolean bl;
            this.hudRedraw(262304);
            boolean bl2 = bl = this.m_nitroLevel > 0;
            if (bl) {
                this.hudRedraw(1024);
                if (this.m_boostGaugeLevelF > 0x140000) {
                    this.hudRedraw(8);
                }
            }
            this.hudRedraw(this.m_hudText);
        }
        if (this.hudNeedsDraw(32)) {
            this.hudRedraw(64);
        }
        this.hudRedraw(262144);
        if (this.hudNeedsDraw(this.m_hudText) || this.hudNeedsDraw(this.m_hudInd) || this.hudNeedsDraw(524288)) {
            this.hudRedraw(131072);
        }
        if (this.hudNeedsDraw(131072) && this.m_flowManager.getCurrentState() != 47) {
            this.hudRedraw(this.m_hudText);
            this.hudRedraw(this.m_hudInd);
        }
        this.hudNoDraw(43008);
        if (this.m_notifyBoxTime > 0 && this.m_lapDisplayTime <= 0) {
            this.hudRedraw(32768);
        }
    }

    private final void renderLapDisplay(Graphics graphics) {
        boolean bl;
        AppEngine appEngine = this.m_engine;
        TrackObject trackObject = this.m_playerCar;
        SDKString sDKString = this.m_textManager.clearStringBuffer();
        appEngine.timeToSDKString(this.m_lastLapTime, 1, sDKString);
        SDKString sDKString2 = this.m_textManager.clearStringBuffer();
        this.m_textManager.appendStringIdToBuffer(205);
        this.m_textManager.appendSDKStringToBuffer(sDKString);
        SDKString sDKString3 = this.m_textManager.clearStringBuffer();
        int n = trackObject.getNumLapsCompleted() + 1;
        boolean bl2 = bl = n == this.m_raceMaxLaps;
        if (bl) {
            this.m_textManager.appendStringIdToBuffer(206);
        } else {
            this.m_textManager.appendStringIdToBuffer(217);
            this.m_textManager.appendSDKStringToBuffer(SDK_SPACE);
            if (n < this.m_raceMaxLaps) {
                this.m_textManager.appendIntToBuffer(n);
            } else {
                this.m_textManager.appendStringIdToBuffer(216);
            }
        }
        int n2 = HUD_LAPTIME_POSITION_Y;
        int n3 = this.m_textManager.getBaselinePosition(2);
        int n4 = this.m_textManager.getStringWidth(sDKString3, 2);
        int n5 = this.m_textManager.getStringWidth(sDKString2, 2);
        int n6 = (n4 > n5 ? n4 : n5) + 12;
        int n7 = n3 + 2;
        int n8 = 80 > n6 ? 80 : n6;
        int n9 = n7 + 1 + n7;
        int n10 = 176 - n8 >> 1;
        int n11 = n2 - (n9 >> 1);
        AnimationManager.setColor(graphics, 0);
        graphics.fillRect(n10, n11, n8, n7);
        graphics.fillRect(n10, n11 + n7 + 1, n8, n7);
        AnimationManager.setColor(graphics, 0);
        graphics.fillRect(n10, n11 - 1, n8, 1);
        graphics.fillRect(n10, n11 + n7, n8, 1);
        graphics.fillRect(n10, n11 + n9, n8, 1);
        int n12 = n10 + (n8 - n4 >> 1);
        this.m_textManager.drawString(sDKString3, 2, n12, n11 + 1, 20);
        int n13 = n10 + (n8 - n5 >> 1);
        this.m_textManager.drawString(sDKString2, 2, n13, n11 + n9 - 1, 68);
    }

    private final void renderHUDSoftkeyBar(Graphics graphics) {
        AnimationManager.setColor(graphics, 0);
        graphics.fillRect(0, VIEWPORT_TOP + VIEWPORT_HEIGHT, 176, 16);
    }

    private final void renderHUDEmpty(Graphics graphics) {
        int n = HUD_UPPER_HORIZ_LINE_POSITION_Y;
        int n2 = 208 - n - 16;
        AnimationManager.setColor(graphics, 0);
        graphics.fillRect(0, n, 176, n2);
    }

    private SDKString getRacePosString() {
        TextManager textManager = this.m_textManager;
        SDKString sDKString = textManager.clearStringBuffer();
        int n = this.m_playerCar.getRacePos() + 1;
        int n2 = this.m_racerCount;
        n = Math.min(Math.max(n, 1), n2);
        int[] nArray = Cache.getInstance().acquireIntArray(2);
        nArray[0] = n;
        nArray[1] = n2;
        SDKString sDKString2 = textManager.getString(219);
        textManager.replace(sDKString, sDKString2, nArray);
        Cache.getInstance().releaseIntArray(nArray);
        return sDKString;
    }

    private SDKString getLapString() {
        TextManager textManager = this.m_textManager;
        SDKString sDKString = textManager.clearStringBuffer();
        int n = this.m_playerCar.getNumLapsCompleted() + 1;
        byte by = this.m_raceMaxLaps;
        n = Math.min(Math.max(n, 1), by);
        int[] nArray = Cache.getInstance().acquireIntArray(2);
        nArray[0] = n;
        nArray[1] = by;
        SDKString sDKString2 = textManager.getString(218);
        textManager.replace(sDKString, sDKString2, nArray);
        Cache.getInstance().releaseIntArray(nArray);
        return sDKString;
    }

    private SDKString getHUDStatsString(SDKString sDKString) {
        int[] nArray = this.m_engine.getEventParamsF(this.m_engine.getCurrentRaceEventIndex());
        TextManager textManager = this.m_textManager;
        switch (this.m_eventType) {
            case 0: {
                SDKString sDKString2 = this.m_textManager.clearStringBuffer();
                sDKString = textManager.clearStringBuffer();
                sDKString.append(this.m_textManager.getString(210));
                sDKString.append(" ");
                this.m_engine.timeToSDKString(this.getRaceDuration(), 0, sDKString2);
                sDKString.append(sDKString2);
                sDKString.append(" ");
                sDKString.append(this.getRacePosString());
                sDKString.append(" ");
                sDKString.append(this.m_textManager.getString(241));
                return sDKString;
            }
            case 1: 
            case 2: {
                SDKString sDKString3 = this.m_textManager.clearStringBuffer();
                sDKString = textManager.clearStringBuffer();
                sDKString.append(this.m_textManager.getString(210));
                sDKString.append(" ");
                this.m_engine.timeToSDKString(this.getRaceDuration(), 0, sDKString3);
                sDKString.append(sDKString3);
                sDKString.append(" ");
                sDKString.append(this.getRacePosString());
                sDKString.append(" ");
                sDKString.append(this.getLapString());
                return sDKString;
            }
            case 4: 
            case 5: {
                SDKString sDKString4 = this.m_textManager.clearStringBuffer();
                sDKString = textManager.clearStringBuffer();
                sDKString.append(this.m_textManager.getString(210));
                sDKString.append(" ");
                this.m_engine.timeToSDKString(this.getRaceDuration(), 0, sDKString4);
                sDKString.append(sDKString4);
                return sDKString;
            }
            case 3: {
                sDKString = textManager.clearStringBuffer();
                sDKString.append(this.m_textManager.getString(211));
                sDKString.append(" ");
                sDKString.append(this.m_engine.getValueInDistanceUnits(nArray[2]) >> 16);
                sDKString.append(" ");
                sDKString.append(this.m_textManager.getString(29));
                sDKString.append(" ");
                SDKString sDKString5 = this.m_textManager.clearStringBuffer();
                int n = this.getTotalCameraSpeed();
                n = this.m_engine.getValueInDistanceUnits(n);
                this.m_engine.intToSDKString(n, false, sDKString5);
                sDKString.append(sDKString5);
                return sDKString;
            }
            case 6: {
                SDKString sDKString6 = this.m_textManager.clearStringBuffer();
                sDKString = textManager.clearStringBuffer();
                sDKString.append(this.m_textManager.getString(210));
                sDKString.append(" ");
                this.m_engine.timeToSDKString(this.m_patrolTimeLeft, 0, sDKString6);
                sDKString.append(sDKString6);
                sDKString.append(" ");
                sDKString.append(this.m_textManager.getString(198));
                sDKString.append(" ");
                sDKString.append(this.m_patrolCriminalsCaught);
                sDKString.append(" ");
                return sDKString;
            }
            case 7: {
                if (this.m_tutorialStage > 0) {
                    int[] nArray2 = Cache.getInstance().acquireIntArray(2);
                    nArray2[0] = this.m_tutorialStage;
                    nArray2[1] = this.m_tutorialState > 23 ? 5 : 8;
                    SDKString sDKString7 = textManager.getString(243);
                    textManager.replace(sDKString, sDKString7, nArray2);
                    Cache.getInstance().releaseIntArray(nArray2);
                } else {
                    sDKString.append("");
                }
                return sDKString;
            }
        }
        return sDKString;
    }

    private int getPlayerLeadDistance() {
        if (this.m_carsRaceOrder != null && this.m_carsRaceOrder[this.m_racerCount - 1] == this.m_playerCar && this.m_playerLeadDistance != -2147483647) {
            return -this.m_playerLeadDistance >> 14;
        }
        return 0;
    }

    private int getDistanceBetweenF(int n, int n2) {
        int n3 = n2 - n;
        if (n3 < 0) {
            n3 += this.m_trackRailSpline.getMaxDistance();
        }
        return n3;
    }

    private final void renderHUDCopTimer(Graphics graphics) {
    }

    private boolean isPaused() {
        int n = this.m_flowManager.getCurrentState();
        switch (n) {
            case 54: 
            case 55: 
            case 56: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 65: {
                if (!this.m_hudPauseStopMusic) {
                    this.m_engine.stopMusic();
                    this.m_hudPauseStopMusic = true;
                }
                return true;
            }
            case 57: {
                return true;
            }
        }
        return false;
    }

    private void onResume() {
    }

    private final void renderSpeedometer(Graphics graphics, int n, int n2) {
    }

    private final void renderNitroIcon(Graphics graphics, int n, int n2) {
    }

    private final void renderNitroGauge(Graphics graphics, int n, int n2) {
        int n3;
        int n4;
        if (this.m_boostFlashTime > 0 && this.m_boostFlashTime / 200 % 2 == 0) {
            return;
        }
        if (this.m_nitroLevel > 0 && (n4 = MathExt.mulF(655360, n3 = MathExt.divF(this.m_boostGaugeLevelF, 0x640000)) >> 16) >= 0) {
            int n5;
            for (n5 = 0; n5 < n4; ++n5) {
                graphics.setColor(0xFF8844);
                graphics.fillRect(n + n5 * 6, n2, 5, 3);
            }
            for (n5 = n4; n5 < 10; ++n5) {
                graphics.setColor(0x444444);
                graphics.fillRect(n + n5 * 6, n2, 5, 3);
            }
        }
    }

    private final void renderHUDSpeedo(Graphics graphics) {
    }

    private void setNotifyText(SDKString sDKString) {
        this.setNotifyText(sDKString, false);
    }

    private void setNotifyText(SDKString sDKString, boolean bl) {
        if (this.m_coolWordingBoxTime <= 0) {
            this.m_stringBufferNotifyText.setLength(0);
            this.m_stringBufferNotifyText.append(sDKString);
            this.m_notifyBoxTime = bl ? 750 : 3000;
        }
    }

    private void setCoolWordingText(SDKString sDKString) {
        this.setCoolWordingText(sDKString, false);
    }

    private void setCoolWordingText(SDKString sDKString, boolean bl) {
        this.m_stringBufferCoolWordingText.setLength(0);
        this.m_stringBufferCoolWordingText.append(sDKString);
        this.m_coolWordingBoxTime = bl ? 750 : 3000;
        this.m_notifyBoxTime = 0;
    }

    private void clearCoolWording() {
        this.m_coolWordingBoxTime = 0;
    }

    public void setCopRewardText() {
        SDKString sDKString = this.m_textManager.clearStringBuffer();
        this.m_textManager.appendStringIdToBuffer(255);
        this.setNotifyText(sDKString);
    }

    private void setCriminalRewardText() {
        SDKString sDKString = this.m_textManager.clearStringBuffer();
        this.m_textManager.appendStringIdToBuffer(246);
        this.setNotifyText(sDKString);
    }

    public void setCustomMessageText(int n) {
        this.setCustomMessageText(n, false);
    }

    public void setCustomMessageText(int n, boolean bl) {
        this.setCustomMessageText(n, bl, false);
    }

    public void setCustomMessageText(int n, boolean bl, boolean bl2) {
        SDKString sDKString = this.m_textManager.clearStringBuffer();
        this.m_textManager.appendStringIdToBuffer(n);
        if (bl) {
            this.setCoolWordingText(sDKString, bl2);
        } else {
            this.setNotifyText(sDKString, bl2);
        }
    }

    private void setRaceFinishedText() {
        byte by = this.getProfileRank();
        switch (by) {
            case 3: {
                this.setCustomMessageText(262, true);
                break;
            }
            case 2: {
                this.setCustomMessageText(263, true);
                break;
            }
            case 1: {
                this.setCustomMessageText(264, true);
                break;
            }
            default: {
                this.setCustomMessageText(254, true);
            }
        }
    }

    private final int getTotalCameraSpeed() {
        int n = 0;
        for (int i = 0; i < this.m_speedCameraSpeeds.length; ++i) {
            n += this.m_speedCameraSpeeds[i] > 0 ? this.m_speedCameraSpeeds[i] : 0;
        }
        return n;
    }

    private final void renderHUDSpeedCamera(Graphics graphics, int n, int n2) {
        int n3;
        int n4 = this.m_speedCamerasPassed;
        if (n4 < this.m_speedCameraSpeeds.length && this.m_speedCameraFlashTimer > 0 && (n3 = this.getClosestSpeedCameraDistance()) > 131072 && n3 < 655360) {
            ++n4;
        }
        AnimationManager.drawAnimFrame(graphics, 254, n4, n, n2);
    }

    private final void renderHUDCarPos(Graphics graphics, int n, int n2) {
    }

    private final void renderMedal(Graphics graphics, int n, int n2) {
        if (this.m_hudMedalFlashTime > 0 && this.m_hudMedalFlashTime / 200 % 2 == 0) {
            return;
        }
        byte by = this.getProfileRank();
        switch (by) {
            case 3: {
                AnimationManager.drawAnimFrame(graphics, 252, 0, n, n2);
                break;
            }
            case 2: {
                AnimationManager.drawAnimFrame(graphics, 252, 1, n, n2);
                break;
            }
            case 1: {
                AnimationManager.drawAnimFrame(graphics, 252, 2, n, n2);
                break;
            }
        }
        if (this.m_lastRank != by) {
            this.flashHUDMedal();
            this.m_lastRank = by;
        }
    }

    private final void renderSpeedBox(Graphics graphics, int n, int n2, int n3) {
        AnimationManager.setColor(graphics, 126);
        graphics.fillRect(n, n2, 9, 9);
        AnimationManager.setColor(graphics, 127);
        graphics.fillRect(n + 1, n2 + 1, 7, 7);
        switch (n3) {
            case 0: {
                AnimationManager.setColor(graphics, 128);
                graphics.fillRect(n + 2, n2 + 2, 5, 5);
                AnimationManager.setColor(graphics, 129);
                graphics.fillRect(n + 3, n2 + 3, 3, 3);
                break;
            }
            case 1: {
                AnimationManager.setColor(graphics, 130);
                graphics.fillRect(n + 2, n2 + 2, 5, 5);
                break;
            }
            case 2: {
                AnimationManager.setColor(graphics, 131);
                graphics.fillRect(n + 2, n2 + 2, 5, 5);
            }
        }
    }

    private final int getClosestSpeedCameraDistance() {
        int n = Integer.MAX_VALUE;
        TrackObject[] trackObjectArray = this.m_trackObjects;
        for (int i = 0; i < trackObjectArray.length; ++i) {
            TrackObject trackObject = trackObjectArray[i];
            if (!trackObject.isInitialised() || trackObject.getObjectType() != 21) continue;
            int n2 = -trackObject.distanceToPlayer();
            if (i != 0 && Math.abs(n2) >= Math.abs(n)) continue;
            n = n2;
        }
        return n;
    }

    private void triggerSpeedCamera(int n, int n2) {
        int n3 = n2 >> 12;
        this.m_speedCameraSpeeds[n] = n3 = n3 > 0 ? n3 : 1;
        this.m_speedCameraSpeedsTrackOrder[this.m_speedCamerasPassed] = n3;
        ++this.m_speedCamerasPassed;
        SDKString sDKString = this.m_textManager.clearStringBuffer();
        this.m_textManager.appendIntToBuffer(this.m_engine.getValueInDistanceUnits(n3));
        this.m_textManager.appendSDKStringToBuffer(new SDKString(" "));
        if (this.m_engine.areSpeedunitsMPH()) {
            this.m_textManager.appendSDKStringToBuffer(this.m_textManager.getString(235));
        } else {
            this.m_textManager.appendSDKStringToBuffer(this.m_textManager.getString(236));
        }
        this.clearCoolWording();
        this.setNotifyText(sDKString);
        if (!this.m_engine.isTrophyReached(8) && n < this.m_speedCameraIndexes.length - 1 && this.getProfileRank() == 3) {
            this.m_engine.updateTrophyData(8);
        }
    }

    private void updateNotifyBox(int n) {
        this.m_notifyBoxTime -= n;
        if (this.m_notifyBoxTime < 0) {
            this.m_notifyBoxTime = 0;
        }
    }

    private void updateCoolWordingBox(int n) {
        this.m_coolWordingBoxTime -= n;
        if (this.m_coolWordingBoxTime < 0) {
            this.m_coolWordingBoxTime = 0;
        }
    }

    private void renderNotifyBox(Graphics graphics) {
        if (this.m_notifyBoxTime > 0) {
            this.m_layoutManager.drawLayout(graphics, 38, 0, 0, 176, 208, 0);
        }
    }

    private void renderCoolWordingBox(Graphics graphics) {
        if (this.m_coolWordingBoxTime > 0) {
            this.m_layoutManager.drawLayout(graphics, 90, 0, 0, 176, 208, 0);
        }
    }

    private final void addScore(int n, int n2) {
        if (n2 != this.m_scoreType || this.m_scoreState == 0) {
            this.setScore(n, n2);
        } else {
            this.setScore(this.m_scoreTotal + n, n2);
        }
    }

    private final void setScore(int n, int n2) {
        this.m_scoreTotal = n;
        this.m_scoreType = n2;
        this.m_scoreState = 2;
        this.m_scoreTime = 0;
    }

    private final void scoreSignalFailed() {
        if (this.m_scoreState != 0) {
            this.m_scoreState = 3;
        }
    }

    private final void updateScore(int n) {
        if (this.m_scoreState == 2) {
            int n2 = this.m_scoreTime;
            int n3 = this.m_layoutManager.getAnimationStopTime(39, n2);
            if (n3 <= n2 + n) {
                n2 = n3;
                this.m_scoreState = 0;
            } else {
                n2 += n;
            }
            this.m_scoreTime = n2;
        }
    }

    private final void renderScore(Graphics graphics) {
        AppEngine appEngine = this.m_engine;
        switch (this.m_scoreState) {
            case 1: 
            case 2: {
                this.m_layoutManager.drawLayout(graphics, 39, 0, 0, 176, 208, this.m_scoreTime);
            }
        }
    }

    private SDKString getScoreNumberString(SDKString sDKString) {
        return this.m_textManager.getString(222).replaceFirst(this.m_scoreTotal);
    }

    private SDKString getScoreDescriptionString(SDKString sDKString) {
        switch (this.m_scoreType) {
            case 3: 
            case 4: {
                return this.m_personalityMessage;
            }
        }
        return sDKString;
    }

    private void renderLineMiniMap(Graphics graphics) {
        int n;
        int n2;
        int n3;
        AppEngine appEngine = this.m_engine;
        byte by = this.m_raceMaxLaps;
        int n4 = HUD_MAP_LINE_RIGHT_POSITION_X - HUD_MAP_LINE_LEFT_POSITION_X;
        AnimationManager.setColor(graphics, 157);
        graphics.drawLine(HUD_MAP_LINE_LEFT_POSITION_X, HUD_MAP_LINE_POSITION_Y, HUD_MAP_LINE_LEFT_POSITION_X + n4, HUD_MAP_LINE_POSITION_Y);
        graphics.drawLine(HUD_MAP_LINE_LEFT_POSITION_X, HUD_MAP_LINE_POSITION_Y - 2, HUD_MAP_LINE_LEFT_POSITION_X, HUD_MAP_LINE_POSITION_Y + 2);
        graphics.drawLine(HUD_MAP_LINE_LEFT_POSITION_X + n4, HUD_MAP_LINE_POSITION_Y - 2, HUD_MAP_LINE_LEFT_POSITION_X + n4, HUD_MAP_LINE_POSITION_Y + 2);
        int n5 = 0;
        int n6 = n3 = by == 1 ? this.m_trackFinishLineDistF : this.m_trackRailSpline.getMaxDistance();
        if (by > 1) {
            n5 = (n4 + 1) / by;
            int n7 = HUD_MAP_LINE_LEFT_POSITION_X + n5;
            for (n2 = 0; n2 < by - 1; ++n2) {
                graphics.fillRect(n7, HUD_MAP_LINE_POSITION_Y, 1, 2);
                n7 += n5;
            }
            n6 *= by;
        }
        n2 = 0;
        int n8 = this.m_carsTrackOrder.length;
        for (n = 0; n < n8; ++n) {
            TrackObject trackObject = this.m_carsTrackOrder[n];
            if (!trackObject.isInitialised() || trackObject.hasFinishedRace() || !trackObject.getFlags(8) && !trackObject.isPlayerCar()) continue;
            int n9 = trackObject.getSplineDistance();
            if (by > 1) {
                n9 += MathExt.mulF(trackObject.getNumLapsCompleted() << 16, n3);
            }
            int n10 = MathExt.divF(n9, n6);
            int n11 = HUD_MAP_LINE_LEFT_POSITION_X + (trackObject.getFlags(0x8000000) ? MathExt.mulF(n4 << 16, n10) >> 16 : 0);
            if (trackObject.isPlayerCar()) {
                n2 = n11;
                continue;
            }
            AnimationManager.setColor(graphics, 92);
            graphics.fillRect(n11, HUD_MAP_LINE_POSITION_Y - 2, 1, 2);
        }
        if (this.m_playerCar.hasFinishedRace()) {
            return;
        }
        AnimationManager.setColor(graphics, 107);
        graphics.drawLine(n2, HUD_MAP_LINE_POSITION_Y - 5 - 1, n2, HUD_MAP_LINE_POSITION_Y - 1);
        for (n = 0; n < 4; ++n) {
            graphics.drawLine(n2 - n, HUD_MAP_LINE_POSITION_Y - 5 - 1 - n, n2 + n, HUD_MAP_LINE_POSITION_Y - 5 - 1 - n);
        }
    }

    private void renderRaceIndicators(Graphics graphics) {
        if (this.m_engine.areCarMarkersEnabled()) {
            if (this.m_racerAhead != null && Math.abs(this.m_racerAhead.getDistanceFromCameraF()) < 602932) {
                if (!this.m_engine.isPlayerCop()) {
                    this.renderPosIndicator(graphics, this.m_racerAhead);
                } else {
                    this.renderSpeedIndicator(graphics, this.m_racerAhead);
                }
            }
            if (this.m_racerBehind != null && Math.abs(this.m_racerBehind.getDistanceFromCameraF()) < 301466) {
                if (!this.m_engine.isPlayerCop()) {
                    this.renderPosIndicator(graphics, this.m_racerBehind);
                } else {
                    this.renderSpeedIndicator(graphics, this.m_racerBehind);
                }
            }
            if (this.m_copAhead != null && Math.abs(this.m_copAhead.getDistanceFromCameraF()) < 301466 && !this.m_engine.isPlayerCop()) {
                this.renderHealthMeter(graphics, this.m_copAhead);
            }
            if (this.m_copBehind != null && Math.abs(this.m_copBehind.getDistanceFromCameraF()) < 301466 && !this.m_engine.isPlayerCop()) {
                this.renderHealthMeter(graphics, this.m_copBehind);
            }
        }
    }

    private final void getMarkerPosition(int[] nArray, TrackObject trackObject) {
        nArray[0] = trackObject.getRenderPosX();
        int n = trackObject.getAppearance();
        short s = this.m_engine.getCpuCarAnimID(n);
        int n2 = this.getOpponentCarFrameFromDistance(trackObject.getRenderDistF());
        int n3 = AnimationManager.getAnimFrameHeight(s, n2) + 3;
        nArray[1] = trackObject.getRenderPosY() - n3;
    }

    private final void renderPosIndicator(Graphics graphics, TrackObject trackObject) {
        int[] nArray = s_tempInt4_1;
        if (trackObject == this.m_racerBehind) {
            this.getMarkerPositionRear(nArray, trackObject);
        } else {
            this.getMarkerPosition(nArray, trackObject);
        }
        int n = nArray[0];
        int n2 = nArray[1];
        AnimationManager.drawAnimFrame(graphics, 227, 0, n, n2);
        if (this.m_eventType != 7) {
            int n3 = trackObject.getRacePos() + 1;
            SDKString sDKString = this.m_textManager.clearStringBuffer();
            this.m_engine.intToSDKString(n3, false, sDKString);
            this.m_textManager.drawString(sDKString, 2, n, n2 + -2, 33);
        }
    }

    private void getMarkerPositionRear(int[] nArray, TrackObject trackObject) {
        int n = 208 - AnimationManager.getAnimFrameHeight(227, 0);
        int n2 = trackObject.getLateralPosF() - this.m_playerCar.getLateralPosF();
        int n3 = MathExt.mulF(TRACK1_WIDTHS[63] << 15, n2) + 32768 >> 16;
        int n4 = (VIEWPORT_WIDTH >> 1) + n3;
        if (n4 < VIEWPORT_LEFT) {
            n4 = VIEWPORT_LEFT;
        } else if (n4 >= VIEWPORT_LEFT + VIEWPORT_WIDTH) {
            n4 = VIEWPORT_LEFT + VIEWPORT_WIDTH - 1;
        }
        if (this.m_playerCar.getSplineDistance() - trackObject.getSplineDistance() < 52428) {
            this.getMarkerPosition(nArray, trackObject);
            return;
        }
        nArray[0] = n4;
        nArray[1] = n;
    }

    private void renderSpeedIndicator(Graphics graphics, TrackObject trackObject) {
        int[] nArray = s_tempInt4_1;
        if (trackObject == this.m_racerBehind) {
            this.getMarkerPositionRear(nArray, trackObject);
        } else {
            this.getMarkerPosition(nArray, trackObject);
        }
        int n = nArray[0];
        int n2 = nArray[1];
        AnimationManager.drawAnimFrame(graphics, 227, 0, n, n2);
        int n3 = trackObject.getSpeedInSpeedUnitsF() >> 12;
        SDKString sDKString = this.m_textManager.clearStringBuffer();
        this.m_engine.intToSDKString(n3, false, sDKString);
        sDKString.append(" ");
        sDKString.append(this.getLayoutString(134));
        this.m_textManager.drawString(sDKString, 2, n, n2 + -2, 33);
    }

    private void renderHealthMeter(Graphics graphics, TrackObject trackObject) {
        int[] nArray = s_tempInt2_1;
        if (trackObject == this.m_racerBehind || trackObject == this.m_copBehind) {
            this.getMarkerPositionRear(nArray, trackObject);
        } else {
            this.getMarkerPosition(nArray, trackObject);
        }
        int n = nArray[0];
        int n2 = nArray[1];
        if (this.m_policeMarkAnimPlayer.isAnimating()) {
            this.m_policeMarkAnimPlayer.drawAnim(graphics, n, n2);
        } else {
            this.m_policeMarkAnimPlayer.startAnim(247, 4);
        }
    }

    private byte determineObjectTrackSection(int n, int n2) {
        return this.determineObjectTrackSection(n, n2, -1);
    }

    private byte determineObjectTrackSection(int n, int n2, int n3) {
        if (n3 != -1 && this.getTrackSectionBoundingRect(n3).isPointWithin(n, n2)) {
            return (byte)n3;
        }
        for (byte by = 0; by < this.m_numTrackSections; by = (byte)(by + 1)) {
            if (!this.getTrackSectionBoundingRect(by).isPointWithin(n, n2)) continue;
            return by;
        }
        return -1;
    }

    private final int getSprintCompletionValue() {
        return this.m_playerCar == null ? 0 : (this.m_playerCar.hasFinishedRace() ? 65536 : MathExt.divF(this.m_playerCar.getSplineDistance(), this.m_playerCar.getSpline().getMaxDistance()));
    }

    private void toggleSpeedBraker() {
        if (!this.m_speedBreakActivated) {
            int n = this.m_playerCar.getSpeedF();
            if (n > 163840 && this.m_speedBreakLevelF > 0x190000) {
                this.startSpeedBreaker();
            }
        } else {
            this.endSpeedBreaker();
        }
        this.hudRedraw(this.m_hudInd);
    }

    private void startSpeedBreaker() {
        this.m_speedBreakActivated = true;
        this.m_speedBreakDisplayTime = 0;
    }

    private void endSpeedBreaker() {
        this.m_speedBreakActivated = false;
        this.m_speedBreakDisplayTime = 0;
        if (this.m_eventType == 7 && this.m_tutorialState == 9) {
            this.tutorialGoalReached();
        }
    }

    private void updateSpeedBreaker(int n) {
        if (this.m_speedBreakActivated) {
            this.m_speedBreakLevelF -= MathExt.mulF(1835, n << 16);
            if (this.m_speedBreakLevelF <= 0) {
                this.m_speedBreakLevelF = 0;
                this.endSpeedBreaker();
            }
        } else if (this.m_speedBreakDisplayTime >= 0) {
            this.m_speedBreakDisplayTime += n;
            if (this.m_speedBreakDisplayTime >= 1000) {
                this.m_speedBreakDisplayTime = -1;
            }
        } else {
            this.m_speedBreakLevelF += MathExt.mulF(3276, n << 16);
            if (this.m_speedBreakLevelF >= 0x640000) {
                this.m_speedBreakLevelF = 0x640000;
            }
        }
    }

    private void renderSpeedBrakeDisplay(Graphics graphics, int n, int n2) {
    }

    private void renderPursuitLevelDisplay(Graphics graphics, int n, int n2) {
        if ((this.m_engine.isPlayerCop() && this.m_playerCar.getFlags(0x200000) || this.getPursuersCount() > 0 || this.m_pursuitLevelDelayTimer > 0) && this.m_flowManager.getCurrentState() == 50) {
            this.renderPursuitBarPartLowBase(graphics, this.m_pursuitLevel, n, n2);
        }
    }

    private void renderPursuitBarPart(Graphics graphics, int n, int n2, int n3, int n4) {
        int n5 = AnimationManager.getAnimFrameCount(n);
        int n6 = this.calcPursuitLevelFrame(this.m_pursuitLevel, 3, n5);
        AnimationManager.drawAnimFrame(graphics, n, n6, n3, n4);
    }

    private void renderPursuitBarPartLowBase(Graphics graphics, int n, int n2, int n3) {
        int n4;
        n2 -= 40;
        int n5 = this.calcPursuitLevelFrame(this.m_pursuitLevel, 3, 21);
        for (n4 = 0; n4 < n5; ++n4) {
            graphics.setColor(0xFF0000);
            graphics.fillRect(n2 + n4 * 4, n3, 3, 3);
        }
        while (n4 < 20) {
            graphics.setColor(0x444444);
            graphics.fillRect(n2 + n4 * 4, n3, 3, 3);
            ++n4;
        }
    }

    int calcPursuitLevelFrame(int n, int n2, int n3) {
        int n4 = n2;
        AppEngine.ASSERT(n4 < n3, "Not enought frames to display pursuit level.");
        int n5 = n4;
        int n6 = n3 - n5 - 2;
        AppEngine.ASSERT(n6 > 0, "Not enought frames to display pursuit level.");
        int n7 = 0;
        n7 = n < 0 ? MathExt.divF(n, -6553600) : MathExt.divF(n, 0x640000);
        n7 = Math.min(n7, 65536);
        int n8 = 0;
        if (n < 0) {
            n8 = n4 - (n7 * n5 >> 16);
            AppEngine.ASSERT(n8 >= 0, "Frame index below allowed range.");
        } else {
            n8 = n4 + 1 + (n7 * n6 >> 16);
            AppEngine.ASSERT(n8 < n3, "Frame index above allowed range.");
        }
        if (n8 > 0 && n8 < n3 - 1 && this.m_pursuitLevelFlashTimer > 0) {
            ++n8;
        }
        return n8;
    }

    public TrackObject getPlayerCar() {
        return this.m_playerCar;
    }

    public TrackObject[] getAllCars() {
        return this.m_trackObjects;
    }

    public NonUniformSpline getTrackSpline() {
        return this.m_trackRailSpline;
    }

    public final void signalCopDied(TrackObject trackObject) {
        this.m_copCrashCounter = (short)(this.m_copCrashCounter + 1);
        this.processTrackEvent(5);
    }

    public void signalCriminalDied(TrackObject trackObject) {
        this.processTrackEvent(7);
        if (this.m_eventType == 6) {
            this.m_stopPursuitTimer = 1500;
            this.m_nextRespawnTimer = this.m_engine.rand(1000, 5000);
            ++this.m_patrolCriminalsCaught;
        } else if (this.m_eventType == 7) {
            this.tutorialGoalReached();
        } else {
            this.m_flowManager.transitionSwapTop(51);
        }
    }

    private final void DEBUG_STATES(String string) {
    }

    private final void preLoadSetup() {
        this.m_loadingState = -1;
        this.m_loadingProgress = 0;
        this.m_loadedAnimImages = 0;
        this.m_updateLoadingTime = 0;
        this.m_trackBendOffsets = null;
        this.m_slopeArrayDistanceF = null;
        this.m_slopeArraySlopeF = null;
        this.m_slopeDestYs = null;
        this.m_slopeSourceHeights = null;
        if (this.m_stringBufferCostToState != null) {
            this.m_stringBufferCostToState = null;
        }
        if (this.m_loadingStatValues != null) {
            for (int i = 0; i < this.m_loadingStatValues.length; ++i) {
                this.m_loadingStatValues[i] = null;
            }
        }
        this.m_engine.requestGC(true);
    }

    public void returnToMenu() {
        if (this.m_flowManager.isIdle()) {
            this.m_engine.stopMusic();
            this.m_flowManager.transitionScene(0, 6);
        }
    }

    public void proceedToCopTutorial() {
        this.m_engine.stopMusic();
        this.m_engine.setIsPlayerCop(true);
        this.m_engine.startRace(24);
    }

    private void endRace() {
        if (this.getEventSuccess()) {
            this.m_flowManager.transitionSwapTop(51);
        } else {
            this.m_flowManager.transitionSwapTop(52);
        }
        if (this.m_eventType != 7) {
            if (this.m_cleanRace) {
                this.m_engine.updateTrophyData(16384);
            }
            if (this.m_racerBehind != null && !this.m_engine.isTrophyReached(64) && this.getProfileRank() == 3) {
                int n = MathExt.divF(Math.abs(this.m_racerBehind.getDistanceFromPlayerF()), this.m_racerBehind.getSpeedF());
                if ((n >>= 6) > 0) {
                    this.m_engine.updateTrophyData(64, n);
                }
            }
            this.setRaceFinishedText();
        }
    }

    private final void endState() {
        switch (this.m_flowManager.getCurrentState()) {
            case 45: {
                this.m_flowManager.transition(49);
                this.m_eventTutorialShown = false;
                break;
            }
            case 47: {
                if (this.m_eventType != 7 && this.m_eventType != 5 && this.m_eventType != 4 && this.m_eventType != 6) {
                    this.m_flowManager.transitionSwapTop(48);
                    break;
                }
                if (this.m_eventType == 6) {
                    this.m_patrolTimeLeft = this.m_engine.getEventPatrolTime(this.m_engine.getCurrentRaceEventIndex()) * 1000;
                    if (this.m_patrolTimeLeft == 0) {
                        this.m_patrolTimeLeft = 240000;
                    }
                }
                this.m_flowManager.transitionSwapTop(50);
                break;
            }
            case 48: {
                this.m_flowManager.transitionSwapTop(50);
                break;
            }
            case 51: 
            case 52: 
            case 53: {
                if (this.m_eventType == 7) {
                    if (this.m_engine.isPlayerCop()) {
                        this.returnToMenu();
                        break;
                    }
                    this.proceedToCopTutorial();
                    break;
                }
                if (this.m_engine.isCurrentRaceCareer()) {
                    this.m_flowManager.transitionSwapTop(56);
                    break;
                }
                this.m_flowManager.transitionSwapTop(55);
                break;
            }
        }
    }

    private final void DEBUG_TUTORIAL(String string) {
    }

    public final void playerStoppedBoost() {
        if (this.m_eventType == 7 && this.m_tutorialState == 11 && this.m_tutorialBoostUsed) {
            this.tutorialGoalReached();
        }
    }

    public final boolean isCriminalCheating() {
        return this.m_eventType == 7 && this.m_tutorialState >= 31 && this.m_tutorialState < 35;
    }

    public final int getBlockadeLatPos() {
        if (this.m_lastBlockade != null) {
            return this.m_lastBlockade.getLateralPosF();
        }
        return Integer.MIN_VALUE;
    }

    public final boolean isTutorialRoadblockState() {
        return this.m_eventType == 7 && this.m_tutorialState == 32;
    }

    public final boolean isTutorialSpikesState() {
        return this.m_eventType == 7 && this.m_tutorialState == 34;
    }

    private final void updateTutorial(int n) {
        TrackObject trackObject = this.m_playerCar;
        if (this.m_tutorialStateTimer >= 0) {
            this.m_tutorialStateTimer -= n;
        }
        if (this.m_eventType == 7 && this.m_tutorialState == 0) {
            this.tutorialStateTransition(this.m_engine.isPlayerCop() ? 24 : 1);
        }
        switch (this.m_tutorialState) {
            case 1: {
                if (trackObject.getSpeedF() < 409600) break;
                this.tutorialStateTransition(3);
                break;
            }
            case 2: {
                if (this.m_tutorialStateTimer > 0) break;
                this.tutorialStateTransition(3);
                break;
            }
            case 3: {
                if (!trackObject.isBraking() || trackObject.getSpeedF() >= 245760) break;
                this.tutorialStateTransition(4);
                break;
            }
            case 4: {
                if (this.m_tutorialStateTimer > 0) break;
                this.tutorialStateTransition(5);
                break;
            }
            case 5: {
                if (!this.m_tutorialKeyPressed || this.m_tutorialStateTimer >= 0) break;
                this.tutorialStateTransition(6);
                break;
            }
            case 6: {
                if (this.m_tutorialStateTimer > 0) break;
                this.tutorialStateTransition(7);
                break;
            }
            case 7: {
                if (this.m_civilianCount != 0) break;
                this.tutorialStateTransition(8);
                break;
            }
            case 8: {
                if (this.m_tutorialStateTimer > 0) break;
                this.tutorialStateTransition(11);
                break;
            }
            case 9: {
                if (!this.m_tutorialKeyPressed || this.m_tutorialStateTimer >= 0) break;
                this.tutorialStateTransition(10);
                break;
            }
            case 10: {
                if (this.m_tutorialStateTimer > 0) break;
                this.tutorialStateTransition(11);
                break;
            }
            case 11: {
                if (!this.m_tutorialKeyPressed || this.m_tutorialStateTimer >= 0) break;
                this.tutorialStateTransition(12);
                break;
            }
            case 12: {
                if (this.m_tutorialStateTimer > 0) break;
                this.tutorialStateTransition(14);
                break;
            }
            case 13: {
                if (this.m_tutorialBoostToGain > 0 && this.m_boostGaugeLevelF != 0x640000) break;
                this.tutorialStateTransition(14);
                break;
            }
            case 14: {
                if (this.m_tutorialCop.getDistanceFromPlayerF() >= 589824) break;
                this.tutorialStateTransition(15);
                break;
            }
            case 15: {
                if (this.getPursuersCount() <= 0) break;
                this.tutorialStateTransition(16);
                break;
            }
            case 16: {
                if (this.m_tutorialStateTimer > 0) break;
                this.tutorialStateTransition(17);
                break;
            }
            case 17: {
                if (this.m_tutorialStateTimer >= 0) break;
                this.tutorialStateTransition(18);
                break;
            }
            case 18: {
                if (this.m_tutorialStateTimer > 0) break;
                this.tutorialStateTransition(19);
                break;
            }
            case 19: {
                if (this.m_tutorialStateTimer >= 0) break;
                this.tutorialStateTransition(20);
                break;
            }
            case 20: {
                if (this.m_tutorialStateTimer > 0) break;
                this.tutorialStateTransition(23);
                break;
            }
            case 21: {
                if (Math.abs(this.m_tutorialFinishPos - this.m_playerCar.getSplineDistance()) > 327680) break;
                this.tutorialStateTransition(22);
                break;
            }
            case 22: {
                if (this.m_tutorialStateTimer > 0) break;
                this.tutorialStateTransition(23);
                break;
            }
            case 23: {
                if (this.m_flowManager.getCurrentState() != 50 && this.m_flowManager.getCurrentState() != 58) break;
                this.endRace();
                break;
            }
            case 24: {
                if (this.m_tutorialStateTimer >= 0) break;
                this.tutorialStateTransition(25);
                break;
            }
            case 25: {
                if (this.m_tutorialStateTimer > 0) break;
                this.tutorialStateTransition(26);
                break;
            }
            case 26: {
                if (Math.abs(this.m_tutorialCriminal.getDistanceFromPlayerF()) >= 524288) break;
                this.tutorialStateTransition(28);
                break;
            }
            case 28: {
                if (Math.abs(this.m_tutorialCriminal.getDistanceFromPlayerF()) >= 87381) break;
                this.tutorialStateTransition(30);
                break;
            }
            case 30: {
                if (this.m_pursuitLevel <= 0x140000) break;
                this.tutorialStateTransition(31);
                break;
            }
            case 31: {
                if (this.m_tutorialCriminal.getDistanceFromPlayerF() < 131072) break;
                this.tutorialStateTransition(36);
                break;
            }
            case 32: {
                if (!this.m_tutorialKeyPressed || this.m_tutorialStateTimer >= 0) break;
                this.tutorialStateTransition(33);
                break;
            }
            case 33: {
                if (this.m_tutorialStateTimer > 0) break;
                this.tutorialStateTransition(34);
                break;
            }
            case 34: {
                if (!this.m_tutorialKeyPressed || this.m_tutorialStateTimer >= 0) break;
                this.tutorialStateTransition(35);
                break;
            }
            case 35: {
                if (this.m_tutorialStateTimer > 0) break;
                this.tutorialStateTransition(36);
                break;
            }
            case 36: {
                if (!this.m_tutorialKeyPressed || this.m_tutorialStateTimer >= 0) break;
                this.tutorialStateTransition(37);
                break;
            }
            case 37: {
                if (this.m_tutorialStateTimer > 0) break;
                this.tutorialStateTransition(38);
                break;
            }
            case 38: {
                if (this.m_flowManager.getCurrentState() != 50 && this.m_flowManager.getCurrentState() != 58) break;
                this.endRace();
                this.m_engine.setTutorialCompleted(true);
            }
        }
    }

    public final void tutorialGoalReached() {
        if (this.m_tutorialKeyPressed) {
            return;
        }
        switch (this.m_tutorialState) {
            case 5: 
            case 11: {
                this.m_tutorialStateTimer = 2000;
            }
        }
        this.m_tutorialKeyPressed = true;
        this.DEBUG_TUTORIAL("Reached goal!");
    }

    private final void processKeysTutorial(int n, int n2) {
        switch (this.m_tutorialState) {
            case 5: {
                if (!SceneGame.keyPressed(98640, n)) break;
                this.tutorialGoalReached();
            }
        }
    }

    private final void tutorialStateTransition(int n) {
        TrackObject trackObject = this.m_playerCar;
        FlowManager flowManager = this.m_flowManager;
        switch (n) {
            case 1: {
                this.DEBUG_TUTORIAL("TUTORIAL_STATE_ACCELERATION");
                this.m_tutorialStage = 1;
                flowManager.transitionPush(57);
                this.m_boostGaugeLevelF = 0x640000;
                break;
            }
            case 2: {
                this.m_tutorialStateTimer = 2000;
                break;
            }
            case 3: {
                this.DEBUG_TUTORIAL("TUTORIAL_STATE_BRAKE");
                flowManager.transitionPush(57);
                ++this.m_tutorialStage;
                break;
            }
            case 4: {
                this.m_tutorialStateTimer = 2000;
                break;
            }
            case 5: {
                this.DEBUG_TUTORIAL("TUTORIAL_STATE_STEERING");
                flowManager.transitionPush(57);
                ++this.m_tutorialStage;
                this.m_tutorialKeyPressed = false;
                break;
            }
            case 6: {
                this.m_tutorialStateTimer = 2000;
                break;
            }
            case 7: {
                this.DEBUG_TUTORIAL("TUTORIAL_STATE_TRAFFIC");
                flowManager.transitionPush(57);
                ++this.m_tutorialStage;
                this.m_tutorialKeyPressed = false;
                TrackObject trackObject2 = this.m_playerCar;
                int n2 = trackObject2.getSplineDistance();
                NonUniformSpline nonUniformSpline = trackObject2.getSpline();
                int n3 = nonUniformSpline.normaliseDistance(n2 + 655360);
                int n4 = -52428;
                int n5 = 3;
                while (--n5 >= 0) {
                    this.createObject(7, -1, n3, n4);
                    n3 -= 131072;
                }
                this.sortCarsTrackOrder();
                break;
            }
            case 8: {
                this.m_tutorialStateTimer = 2000;
                break;
            }
            case 9: {
                this.DEBUG_TUTORIAL("TUTORIAL_STATE_SPEEDBREAKER");
                flowManager.transitionPush(57);
                ++this.m_tutorialStage;
                this.m_tutorialKeyPressed = false;
                break;
            }
            case 10: {
                this.m_tutorialStateTimer = 2000;
                break;
            }
            case 11: {
                this.DEBUG_TUTORIAL("TUTORIAL_STATE_NITRO");
                flowManager.transitionPush(57);
                ++this.m_tutorialStage;
                this.m_tutorialKeyPressed = false;
                this.m_tutorialBoostUsed = false;
                this.m_boostGaugeLevelF = 0x640000;
                this.m_boostFlashTime = 1000;
                break;
            }
            case 12: {
                this.m_tutorialStateTimer = 2000;
                break;
            }
            case 13: {
                this.DEBUG_TUTORIAL("TUTORIAL_STATE_NITRO_GAIN");
                flowManager.transitionPush(57);
                ++this.m_tutorialStage;
                this.m_tutorialBoostToGain = 786432;
                break;
            }
            case 14: {
                this.m_tutorialStateTimer = 2000;
                TrackObject trackObject3 = this.m_playerCar;
                int n6 = trackObject3.getSplineDistance();
                NonUniformSpline nonUniformSpline = trackObject3.getSpline();
                int n7 = nonUniformSpline.normaliseDistance(n6 + 655360);
                this.m_tutorialCop = this.setupCopTrap(n7);
                break;
            }
            case 15: {
                this.DEBUG_TUTORIAL("TUTORIAL_STATE_PURSUIT");
                flowManager.transitionPush(57);
                ++this.m_tutorialStage;
                break;
            }
            case 16: {
                this.m_tutorialStateTimer = 4000;
                break;
            }
            case 17: {
                this.DEBUG_TUTORIAL("TUTORIAL_STATE_PURSUIT_LOSE");
                flowManager.transitionPush(57);
                ++this.m_tutorialStage;
                this.m_tutorialStateTimer = 5000;
                break;
            }
            case 18: {
                this.m_tutorialStateTimer = 2000;
                break;
            }
            case 19: {
                this.DEBUG_TUTORIAL("TUTORIAL_STATE_PURSUIT_LOSE");
                flowManager.transitionPush(57);
                ++this.m_tutorialStage;
                this.m_tutorialStateTimer = 5000;
                break;
            }
            case 20: {
                this.m_tutorialStateTimer = 2000;
                break;
            }
            case 23: {
                this.DEBUG_TUTORIAL("TUTORIAL_STATE_COP_TIME");
                flowManager.transitionPush(57);
                break;
            }
            case 24: {
                this.DEBUG_TUTORIAL("TUTORIAL_STATE_COP_INTRO");
                flowManager.transitionPush(57);
                this.m_tutorialStage = 1;
                this.m_tutorialStateTimer = 5000;
                this.m_boostGaugeLevelF = 0;
                TrackObject trackObject4 = this.m_playerCar;
                int n8 = trackObject4.getSplineDistance();
                NonUniformSpline nonUniformSpline = trackObject4.getSpline();
                int n9 = nonUniformSpline.normaliseDistance(n8 + 0x280000);
                this.m_tutorialCriminal = this.setupRacer(n9);
                this.m_lastBlockade = null;
                break;
            }
            case 25: {
                this.m_tutorialStateTimer = 2000;
                break;
            }
            case 26: {
                this.DEBUG_TUTORIAL("TUTORIAL_STATE_COP_SAFETY");
                flowManager.transitionPush(57);
                ++this.m_tutorialStage;
                break;
            }
            case 27: {
                this.m_tutorialStateTimer = 2000;
                break;
            }
            case 28: {
                this.DEBUG_TUTORIAL("TUTORIAL_STATE_COP_PURSUIT");
                flowManager.transitionPush(57);
                ++this.m_tutorialStage;
                break;
            }
            case 29: {
                this.m_tutorialStateTimer = 2000;
                break;
            }
            case 30: {
                this.DEBUG_TUTORIAL("TUTORIAL_STATE_COP_RAM");
                flowManager.transitionPush(57);
                ++this.m_tutorialStage;
                break;
            }
            case 31: {
                this.m_tutorialStateTimer = 2000;
                break;
            }
            case 32: {
                this.DEBUG_TUTORIAL("TUTORIAL_STATE_COP_ROADBLOCK");
                flowManager.transitionPush(57);
                ++this.m_tutorialStage;
                this.m_tutorialKeyPressed = false;
                break;
            }
            case 33: {
                this.m_tutorialStateTimer = 2000;
                this.m_lastBlockade = null;
                break;
            }
            case 34: {
                this.DEBUG_TUTORIAL("TUTORIAL_STATE_COP_SPIKES");
                flowManager.transitionPush(57);
                ++this.m_tutorialStage;
                this.m_tutorialKeyPressed = false;
                break;
            }
            case 35: {
                this.m_tutorialStateTimer = 2000;
                this.m_lastBlockade = null;
                break;
            }
            case 36: {
                this.DEBUG_TUTORIAL("TUTORIAL_STATE_COP_BUST");
                flowManager.transitionPush(57);
                ++this.m_tutorialStage;
                this.m_tutorialKeyPressed = false;
                break;
            }
            case 37: {
                this.m_tutorialStateTimer = 2000;
                break;
            }
            case 38: {
                this.DEBUG_TUTORIAL("TUTORIAL_STATE_COP_END");
                flowManager.transitionPush(57);
                this.m_tutorialStateTimer = 5000;
            }
        }
        this.m_tutorialState = n;
    }

    private final int getTutorialMessage() {
        if (this.m_eventType == 7) {
            int n = this.m_tutorialState;
            switch (n) {
                case 1: 
                case 2: {
                    return 95;
                }
                case 3: 
                case 4: {
                    return 96;
                }
                case 5: 
                case 6: {
                    return 97;
                }
                case 7: 
                case 8: {
                    return 98;
                }
                case 9: 
                case 10: {
                    return 99;
                }
                case 11: 
                case 12: {
                    return 100;
                }
                case 13: 
                case 14: {
                    return 101;
                }
                case 15: 
                case 16: {
                    return 102;
                }
                case 17: 
                case 18: {
                    return 103;
                }
                case 19: 
                case 20: {
                    return 104;
                }
                case 21: 
                case 22: {
                    return 105;
                }
                case 23: {
                    return 106;
                }
                case 24: 
                case 25: {
                    return 107;
                }
                case 26: 
                case 27: {
                    return 108;
                }
                case 28: 
                case 29: {
                    return 109;
                }
                case 30: 
                case 31: {
                    return 110;
                }
                case 32: 
                case 33: {
                    return 111;
                }
                case 34: 
                case 35: {
                    return 112;
                }
                case 36: 
                case 37: {
                    return 113;
                }
                case 38: {
                    return 114;
                }
            }
            return -1;
        }
        switch (this.m_eventType) {
            case 1: {
                return 118;
            }
            case 0: {
                return 117;
            }
            case 5: {
                return 119;
            }
            case 4: {
                return 120;
            }
            case 2: {
                return 122;
            }
            case 6: {
                return 121;
            }
            case 3: {
                return 123;
            }
        }
        return -1;
    }

    private byte getEventStars() {
        byte by = 0;
        switch (this.getProfileRank()) {
            case 3: {
                by = 7;
                break;
            }
            case 2: {
                by = 3;
                break;
            }
            case 1: {
                by = 1;
            }
        }
        return by;
    }

    private void flashHUDMedal() {
        this.m_hudMedalFlashTime = HUD_STYLE_STARS_DURATION;
    }

    private void updateHUDMedal(int n) {
        if (this.m_hudMedalFlashTime >= 0) {
            this.m_hudMedalFlashTime -= n;
        }
    }

    private void eventOver() {
        System.out.println("HERE EVENT IS OVERS.....................&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&");
        AppEngine appEngine = this.m_engine;
        this.m_engine.setTrophyNottificationEnabled(false);
        if (appEngine.isCurrentRaceCareer()) {
            byte by = appEngine.getCurrentRaceEventIndex();
            byte by2 = appEngine.rmsGetEventRank(by);
            int n = appEngine.getEventReward(by, by2);
            byte by3 = this.getProfileRank();
            this.m_careerBountyReward = Math.max(0, appEngine.getEventReward(by, by3) + this.m_careerExtraBounty);
            if (SceneMenu.bonus_mp) {
                this.m_careerBountyReward *= 2;
            }
            appEngine.increaseBounty(this.m_careerBountyReward);
            if (this.getEventSuccess()) {
                appEngine.completeEvent(this.m_engine.getCurrentRaceEventIndex());
            }
            appEngine.rmsAddDriverProfile(this.m_profileAggression, this.m_profilePrecision, by3);
            appEngine.rmsSetEventAwards(by, this.getEventStars());
            appEngine.submitEventRank(by3);
            appEngine.setRaceRank(by3);
            if (!this.isBusted) {
                appEngine.submitBestRaceTime(this.getRaceDuration());
                appEngine.submitBestLapTime(this.m_bestLapTime);
            }
            appEngine.setRaceTime(this.getRaceDuration());
            switch (this.m_eventType) {
                case 6: {
                    appEngine.submitTrackPatrolTicket(this.m_patrolCriminalsCaught);
                    break;
                }
                case 3: {
                    int n2 = this.getTotalCameraSpeed();
                    appEngine.submitTrackSpeedcameraTotal(n2);
                }
            }
        }
        appEngine.saveRMSGameData();
    }

    private boolean getEventSuccess() {
        if (this.m_engine.cheatUsed(5)) {
            return false;
        }
        if (this.m_engine.cheatUsed(4)) {
            return true;
        }
        return this.getProfileRank() != -1;
    }

    private byte getProfileRank() {
        int n = this.m_eventType;
        int n2 = this.m_playerCar.getRacePos();
        byte by = this.m_engine.getCurrentRaceEventIndex();
        boolean bl = this.m_engine.isCopModeEvent(by);
        int n3 = -1;
        if (bl && (this.m_pursuitLevel > -6553600 || n == 6) || !bl && this.m_pursuitLevel < 0x640000) {
            switch (n) {
                case 0: 
                case 1: 
                case 2: {
                    n3 = n2 == 0 ? 3 : (n2 == 1 ? 2 : (n2 == 2 ? 1 : -1));
                    break;
                }
                case 6: {
                    int[] nArray = this.m_engine.getEventParamsF(this.m_engine.getCurrentRaceEventIndex());
                    n3 = this.m_patrolCriminalsCaught >= nArray[2] >> 16 ? 3 : (this.m_patrolCriminalsCaught >= nArray[1] >> 16 ? 2 : (this.m_patrolCriminalsCaught >= nArray[0] >> 16 ? 1 : -1));
                    break;
                }
                case 4: 
                case 5: {
                    int n4 = this.getRaceDuration();
                    n4 = n4 / 1000 * 1000;
                    int[] nArray = this.m_engine.getEventParamsF(this.m_engine.getCurrentRaceEventIndex());
                    n3 = n4 <= (nArray[2] >> 16) * 1000 ? 3 : (n4 <= (nArray[1] >> 16) * 1000 ? 2 : (n4 <= (nArray[0] >> 16) * 1000 ? 1 : -1));
                    break;
                }
                case 3: {
                    int n5 = this.getTotalCameraSpeed();
                    int[] nArray = this.m_engine.getEventParamsF(this.m_engine.getCurrentRaceEventIndex());
                    n3 = n5 >= nArray[2] >> 16 ? 3 : (n5 >= nArray[1] >> 16 ? 2 : (n5 >= nArray[0] >> 16 ? 1 : -1));
                    break;
                }
            }
        }
        return (byte)n3;
    }

    public void processTrackEvent(int n) {
        this.processTrackEvent(n, 0);
    }

    public void processTrackEvent(int n, int n2) {
        int n3;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        boolean bl = false;
        switch (n) {
            case 4: {
                if (this.m_playerCar.isCrashing()) break;
                if (this.m_engine.isPlayerCop()) {
                    n4 -= 20;
                    n5 = 0;
                    n6 = 271;
                }
                this.m_engine.updateTrophyData(4, 1);
            }
            case 6: {
                if (this.m_engine.isPlayerCop()) break;
                switch (n2) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 6: {
                        n4 += 20;
                        break;
                    }
                    case 7: {
                        n4 = 0;
                    }
                }
                n6 = 267;
                bl = true;
                break;
            }
            case 1: {
                if (this.m_engine.isPlayerCop()) {
                    n5 = 0;
                    n4 -= 10;
                    n6 = 249;
                    break;
                }
                n5 = 655360;
                n4 += 10;
                n6 = 249;
                break;
            }
            case 2: {
                n3 = this.m_engine.getObjectCost(n2);
                if (this.m_engine.isPlayerCop()) {
                    n5 = 0;
                    n4 -= n3;
                    n6 = 268;
                } else {
                    n5 = 327680;
                    n4 += n3;
                    n6 = 269;
                }
                ++this.m_numObjectsDestroyed;
                this.m_engine.updateTrophyData(0x800000, 1);
                break;
            }
            case 3: {
                if (!this.m_engine.isPlayerCop()) {
                    n5 = 0x140000;
                    n4 += 50;
                    n6 = 253;
                    break;
                }
                n5 = 0;
                n4 -= 50;
                n6 = 271;
                break;
            }
            case 5: {
                if (!this.m_engine.isPlayerCop()) {
                    n5 = 0x320000;
                    n4 += 500;
                    n6 = 255;
                    break;
                }
                n5 = 0;
                n4 -= 500;
                n6 = 271;
                break;
            }
            case 7: {
                if (this.m_engine.isPlayerCop()) {
                    n4 = 0;
                    n5 += 0x640000;
                    n6 = 246;
                }
                this.m_engine.updateTrophyData(1024, 1);
            }
        }
        if (n5 != 0) {
            if (!this.isBoostAvailable()) {
                n5 = 0;
            }
            n3 = this.m_boostGaugeLevelF + n5;
            this.m_tutorialBoostToGain -= n5;
            if (n3 > 0x640000) {
                n3 = 0x640000;
            }
            if (n3 != this.m_boostGaugeLevelF) {
                this.m_boostFlashTime = 1000;
                this.m_boostGaugeLevelF = n3;
            }
            if (n4 == 0) {
                this.setCustomMessageText(n6, true);
            }
        }
        if (n4 != 0) {
            if (this.m_scoreState == 2 && bl) {
                this.addBountyScore(n4);
            } else {
                this.addBountyScore(n4);
                if (n6 != 0) {
                    this.m_personalityMessage = new SDKString("\\0");
                    this.m_personalityMessage = this.m_personalityMessage.replaceFirst(this.m_textManager.getString(n6));
                }
            }
        }
    }

    private void setAggressionOpponent(TrackObject trackObject) {
        if (trackObject != this.m_profileAggressionOpponent) {
            if (this.m_profileAggressionOpponent != null && this.m_profileAggressionMultiplier < 5) {
                this.m_profileAggressionMultiplier += 2;
            } else if (this.m_profileAggressionMultiplier == 5) {
                this.m_profileAggressionMultiplier = 1;
            }
            this.m_profileAggressionMultiplierTime = 5000;
            this.m_profileAggressionOpponent = trackObject;
        }
    }

    private void updateAggressionMultiplier(int n) {
        if (this.m_profileAggressionMultiplierTime > 0) {
            this.m_profileAggressionMultiplierTime -= n;
            if (this.m_profileAggressionMultiplierTime < 0) {
                this.m_profileAggressionOpponent = null;
                this.m_profileAggressionMultiplierTime = 0;
                this.m_profileAggressionMultiplier = 1;
            }
        }
    }

    private void updatePlayerRaceLineCheck(int n, boolean bl, boolean bl2, boolean bl3) {
        int n2 = this.m_racingLineState;
        if (n != this.m_racingLineCurvature) {
            this.m_racingLineCurvature = n;
            this.m_racingLineState = 0;
            this.m_racingLineTimeInside = 0;
            this.m_racingLineTimeOutside = 0;
        }
        if (n == 0) {
            return;
        }
        if (bl3 || bl2) {
            this.m_racingLineState = -1;
        }
        if (bl) {
            ++this.m_racingLineTimeInside;
        } else {
            ++this.m_racingLineTimeOutside;
        }
    }

    private final int getRaceDuration() {
        int n = this.m_eventType;
        TrackObject trackObject = this.m_playerCar;
        int n2 = 0;
        switch (n) {
            case 2: {
                if (trackObject.getNumLapsCompleted() == 0) {
                    n2 = trackObject.getCurrentLapTime();
                    break;
                }
                if (!trackObject.hasFinishedRace()) {
                    n2 = trackObject.getCumulativeLapTimes();
                    n2 += trackObject.getCurrentLapTime();
                    break;
                }
                n2 = trackObject.getCumulativeLapTimes();
                break;
            }
            default: {
                n2 = trackObject.getCumulativeLapTimes() + trackObject.getCurrentLapTime();
            }
        }
        return n2;
    }

    private void DEBUG_POSTRACE(String string) {
    }

    private void render2D(Graphics graphics) {
        AppEngine appEngine = this.m_engine;
        graphics.setClip(VIEWPORT_LEFT, VIEWPORT_TOP, VIEWPORT_WIDTH, TRACK_VIEWPORT_HEIGHT);
        this.adjustViewpoint();
        this.renderSky(graphics);
        AppEngine.timerBegin();
        this.renderTrack(graphics);
        AppEngine.timerEnd("renderTrack");
        AppEngine.timerBegin();
        this.renderDrawList(graphics);
        AppEngine.timerEnd("renderDrawList");
        if (this.m_flowManager.getCurrentState() == 50 || this.m_flowManager.getCurrentState() == 58) {
            this.renderRaceIndicators(graphics);
        }
        graphics.setClip(0, 0, 176, 208);
    }

    private void renderCurvedGradientBox(Graphics graphics, int[] nArray, int n, int n2, int n3, int n4) {
        int n5 = nArray.length;
        int n6 = 3;
        int n7 = n4 - n6;
        for (int i = 0; i < n5; ++i) {
            int n8 = (nArray[i] & 0xFF0000) >> 16;
            int n9 = (nArray[i] & 0xFF00) >> 8;
            int n10 = nArray[i] & 0xFF;
            graphics.setColor(n8, n9, n10);
            graphics.fillRect(n, n7, n3, n6);
            n7 -= (n6 <<= 1);
        }
        graphics.fillRect(n, n7, n3, n6);
    }

    private void renderSky(Graphics graphics) {
        int n;
        int n2;
        Image image = this.m_imgSkyline;
        int n3 = image.getWidth();
        int n4 = image.getHeight();
        int n5 = VIEWPORT_TOP + TRACK_VIEWPORT_HEIGHT - 64;
        n5 += MathExt.mulF(this.m_playerCarSlopeCurr - 65536, 0x200000) + 32768 >> 16;
        int n6 = 0;
        int[] nArray = this.m_slopeDestYs;
        for (n2 = 0; n2 < this.m_numSlopeSections; ++n2) {
            if (nArray[n2] <= n6) continue;
            n6 = nArray[n2];
        }
        if (n5 < TRACK_VIEWPORT_HEIGHT - n6) {
            n5 = TRACK_VIEWPORT_HEIGHT - n6;
        }
        if ((n2 = n5 - n4) > VIEWPORT_TOP) {
            n = this.m_engine.getTrackEnvironment();
            this.renderCurvedGradientBox(graphics, SKYGRADIENTS[n], 0, VIEWPORT_TOP, VIEWPORT_WIDTH, n2 - VIEWPORT_TOP);
        }
        for (n = (this.m_renderCityOffsetXF >> 16) - this.m_cameraShakeOffset[0]; n < 0; n += n3) {
        }
        while (n >= n3) {
            n -= n3;
        }
        int n7 = 0;
        do {
            graphics.drawRegion(image, n, 0, n3 - n, n4, 0, n7, n5, 36);
        } while ((n7 += n3 - (n = 0)) < VIEWPORT_WIDTH);
    }

    private void renderTrack(Graphics graphics) {
        int n;
        if (this.m_raceIntroTotalTime < this.m_introDurationF) {
            this.calcIntroSlopeHeights();
        } else {
            this.fillSlopeArray();
            this.calcSlopeHeights();
        }
        this.renderPrimitiveOffroad(graphics);
        this.m_currCarRenderIndex = this.m_firstCarRenderIndex = this.getFurthestVisibileCarTrackOrder();
        this.m_currStaticObjRenderIndex = this.m_firstStaticObjRenderIndex = this.getFurthestVisibileStaticObjTrackOrder();
        int n2 = MathExt.mulF(this.m_playerCar.getLateralPosF(), TRACK1_WIDTHS[32] << 15) + 32768;
        n2 = MathExt.mulF(n2, 52428) >> 16;
        int n3 = this.m_cameraShakeOffset[0] - n2;
        n3 += VIEWPORT_CENTRE_X;
        int n4 = n = 0;
        int[] nArray = this.m_perspectiveRangesF;
        int[] nArray2 = this.m_slopeDestYs;
        int[] nArray3 = this.m_slopeSourceHeights;
        int n5 = this.m_trackRailSpline.getMaxDistance();
        Image image = this.m_imgTrackPacked;
        int n6 = this.m_viewPosF;
        int n7 = MathExt.mulF(n6, 78643);
        int[] nArray4 = this.m_trackBendOffsets;
        for (int i = this.m_numSlopeSections - 1; i >= 0; --i) {
            int n8;
            int n9 = nArray3[i];
            if (n9 <= 0) continue;
            int n10 = nArray[n4];
            int n11 = 0;
            if (n4 < 63) {
                n11 = nArray[n4 + 1];
            }
            int n12 = nArray2[i];
            int n13 = 0;
            if (i > 0) {
                for (n8 = i - 1; n8 >= 0; --n8) {
                    if (nArray2[n8] <= nArray2[i]) continue;
                    n13 = nArray2[n8];
                }
            }
            n4 = n;
            n8 = 0;
            if (i > 0) {
                n8 = nArray2[i - 1];
            }
            int n14 = n12 - n8;
            int n15 = n9;
            int n16 = n9 << 1;
            int n17 = n14 << 1;
            int n18 = n12 + n14;
            int n19 = n12;
            if (n14 > 0) {
                if (n9 < n14) {
                    for (n12 = VIEWPORT_TOP + TRACK_VIEWPORT_HEIGHT - n12; n12 < n18; ++n12) {
                        this.renderTrackSliver(graphics, image, n4, n12, n11, n3, n5, n7, nArray4);
                        if ((n15 += n16) < n17) continue;
                        if (this.m_currCarRenderIndex >= 0) {
                            this.renderCars(n4, n12, n3, n11, n10, n13, n6, nArray4);
                        }
                        if (this.m_currStaticObjRenderIndex >= 0) {
                            this.renderStaticObjs(n4, n12, n3, n11, n10, n13, n6, nArray4);
                        }
                        n15 -= n17;
                        n10 = n11;
                        n11 = ++n4 < 63 ? nArray[n4 + 1] : 0;
                    }
                } else {
                    while (n12 < n18) {
                        if (n4 >= TRACK1_OFFSETS.length) {
                            n4 = TRACK1_OFFSETS.length - 1;
                        }
                        if ((n15 += n17) > n16) {
                            this.renderTrackSliver(graphics, image, n4, n12, n11, n3, n5, n7, nArray4);
                            ++n12;
                            n15 -= n16;
                        }
                        if (this.m_currCarRenderIndex >= 0) {
                            this.renderCars(n4, n12, n3, n11, n10, n13, n6, nArray4);
                        }
                        if (this.m_currStaticObjRenderIndex >= 0) {
                            this.renderStaticObjs(n4, n12, n3, n11, n10, n13, n6, nArray4);
                        }
                        n10 = n11;
                        if (++n4 < 63) {
                            n11 = nArray[n4 + 1];
                            continue;
                        }
                        n11 = 0;
                    }
                }
            } else if (n14 < 0) {
                n14 = -n14;
                n17 = n14 << 1;
                if (n9 < n14) {
                    while (n12 > n18) {
                        if ((n15 += n16) >= n17) {
                            if (this.m_currCarRenderIndex >= 0) {
                                this.renderCars(n4, n12, n3, n11, n10, n13, n6, nArray4);
                            }
                            if (this.m_currStaticObjRenderIndex >= 0) {
                                this.renderStaticObjs(n4, n12, n3, n11, n10, n13, n6, nArray4);
                            }
                            n15 -= n17;
                            n10 = n11;
                            n11 = ++n4 < 63 ? nArray[n4 + 1] : 0;
                        }
                        --n12;
                    }
                } else {
                    while (n12 > n18) {
                        if ((n15 += n17) > n16) {
                            if (this.m_currCarRenderIndex >= 0) {
                                this.renderCars(n4, n12, n3, n11, n10, n13, n6, nArray4);
                            }
                            if (this.m_currStaticObjRenderIndex >= 0) {
                                this.renderStaticObjs(n4, n12, n3, n11, n10, n13, n6, nArray4);
                            }
                            --n12;
                            n15 -= n16;
                        }
                        n10 = n11;
                        if (++n4 < 63) {
                            n11 = nArray[n4 + 1];
                            continue;
                        }
                        n11 = 0;
                    }
                }
            } else if (n14 == 0) {
                int n20 = n4 + n9;
                while (n4 < n20) {
                    n11 = 0;
                    if (n4 < 63) {
                        n11 = nArray[n4 + 1];
                    }
                    ++n4;
                }
                if (this.m_currCarRenderIndex >= 0) {
                    this.renderCars(n4, n12, n3, n11, n10, n13, n6, nArray4);
                }
                if (this.m_currStaticObjRenderIndex >= 0) {
                    this.renderStaticObjs(n4, n12, n3, n11, n10, n13, n6, nArray4);
                }
            }
            n += n9;
        }
    }

    private void renderTrackSliver(Graphics graphics, Image image, int n, int n2, int n3, int n4, int n5, int n6, int[] nArray) {
        int[] nArray2;
        short s;
        int n7;
        int n8 = n6 + n3;
        if (n8 > n5) {
            n8 -= n5;
        }
        int n9 = n4 + nArray[n];
        short s2 = 0;
        ++this.m_primitiveOffroadBlockHeight;
        int n10 = this.m_grassColourLast;
        if ((n8 >> 16 & 1) == 0) {
            n7 = this.m_grassColourLight;
            n9 -= TRACK1_OFFSETS[n];
            s = TRACK1_WIDTHS[n];
        } else {
            int n11 = 63 - n;
            n7 = this.m_grassColourDark;
            n9 -= TRACK2_OFFSETS[n];
            s2 = TRACK1_WIDTHS[n11];
            s = TRACK2_WIDTHS[n];
            n = n11;
        }
        if (s > 0) {
            graphics.drawRegion(image, (int)s2, n, (int)s, 1, 0, n9, n2, 20);
        }
        if ((nArray2 = this.m_primitiveOffroadBlocks)[1] == -1) {
            nArray2[1] = n2;
        } else if (n7 != n10) {
            int n12 = this.m_primitiveOffroadBlocksCount * 3;
            nArray2[n12 + 0] = n10;
            nArray2[n12 + 2] = this.m_primitiveOffroadBlockHeight;
            nArray2[n12 + 1 + 3] = n2;
            this.m_primitiveOffroadBlockHeight = 0;
            ++this.m_primitiveOffroadBlocksCount;
        }
        this.m_grassColourLast = n7;
    }

    private void renderPrimitiveOffroad(Graphics graphics) {
        int n = this.m_primitiveOffroadBlocksCount;
        int[] nArray = this.m_primitiveOffroadBlocks;
        for (int i = 0; i < n; ++i) {
            int n2 = i * 3;
            int n3 = nArray[n2 + 0];
            int n4 = nArray[n2 + 1];
            int n5 = i != n - 2 ? nArray[n2 + 2] : TRACK_VIEWPORT_HEIGHT - n4 - VIEWPORT_TOP;
            graphics.setColor(n3);
            graphics.fillRect(VIEWPORT_LEFT, n4, VIEWPORT_WIDTH, n5);
        }
        this.m_primitiveOffroadBlocksCount = 0;
        this.m_primitiveOffroadBlockHeight = 0;
        nArray[1] = -1;
    }

    private void renderCars(int n, int n2, int n3, int n4, int n5, int n6, int n7, int[] nArray) {
        int n8;
        int n9 = n8 = this.m_currCarRenderIndex;
        TrackObject[] trackObjectArray = this.m_carsTrackOrder;
        int n10 = TRACK1_WIDTHS[n] << 15;
        int n11 = nArray[n];
        int n12 = trackObjectArray[n9].getSplineDistance();
        int n13 = this.calcDistance(n7, n12);
        if (n13 < this.m_perspectiveRangesF[0]) {
            while (n13 > n4 && n13 <= n5) {
                TrackObject trackObject = trackObjectArray[n9];
                if (trackObject.isInitialised()) {
                    int n14 = MathExt.mulF(trackObject.getLateralPosF(), n10);
                    n14 = MathExt.mulF(n14, 52428) >> 16;
                    trackObject.setRenderPosX(n3 + n14 + n11);
                    trackObject.setRenderPosY(n2);
                    trackObject.setRenderDistF(n13);
                    trackObject.setRenderClipY(n6);
                }
                if (--n9 < 0) {
                    n9 += trackObjectArray.length;
                }
                if (n8 == n9) break;
                trackObject = trackObjectArray[n9];
                n12 = trackObject.getSplineDistance();
                n13 = this.calcDistance(n7, n12);
            }
        }
        this.m_currCarRenderIndex = n9;
    }

    private void renderPlayerCar(Graphics graphics, TrackObject trackObject) {
        int n = trackObject.getRenderPosX();
        int n2 = trackObject.getRenderPosY();
        if (this.m_playerCar.isCrashing()) {
            int n3 = this.m_playerCarAnimPlayer.getAnimID();
            if (n3 != 90 && n3 != 91) {
                if (n3 == this.m_crashLeftAnimID || n3 == this.m_crashRightAnimID) {
                    if (!this.m_playerCarAnimPlayer.isAnimating()) {
                        n3 = n3 == this.m_crashLeftAnimID ? 90 : 91;
                        this.m_playerCarAnimPlayer.startAnim(n3, 16);
                    }
                } else {
                    int n4 = MathExt.normaliseAngleRadiansF(this.m_playerCarMovementDirF - this.m_playerCarFacingDirF);
                    n3 = n4 < 0 ? (int)this.m_crashLeftAnimID : (int)this.m_crashRightAnimID;
                    this.m_playerCarAnimPlayer.startAnim(n3, 16);
                }
            }
            this.m_playerCarAnimPlayer.drawAnim(graphics, n, n2);
        } else {
            AnimPlayer animPlayer;
            short s;
            short s2;
            short s3;
            int n5 = this.m_playerCarAnimId;
            if (this.m_playerImpactSparkAnimPlayer.isAnimating() && this.m_playerBumpedFront && this.m_playerImpactSparkAnimPlayer.getCurrAnimFrame() < 3) {
                this.m_playerImpactSparkAnimPlayer.drawAnim(graphics, this.m_playerImpactSparkX, this.m_playerImpactSparkY);
            }
            this.m_playerCarAnimPlayer.startAnim(this.m_carAnimIDs[n5], 4);
            this.m_playerCarAnimPlayer.drawAnim(graphics, n, n2);
            if (n5 != 0 && n5 != 8) {
                this.m_brakeLightsAnimPlayer.startAnim(this.m_carBrakeLightsAnimIDs[n5], 4);
                if (this.m_playerCar.isBraking()) {
                    this.m_brakeLightsAnimPlayer.drawAnim(graphics, n, n2);
                }
            }
            if (this.m_speedLinesAnimPlayer.isAnimating()) {
                s3 = CAR_SPEEDLINES_ANIM_IDS[n5];
                if (s3 == -1) {
                    this.m_speedLinesAnimPlayer.setAnimating(false);
                } else {
                    this.m_speedLinesAnimPlayer.startAnim(s3, 4);
                    this.m_speedLinesAnimPlayer.drawAnim(graphics, n, n2);
                }
            }
            if (this.m_nitroAirburstAnimPlayer.isAnimating()) {
                this.m_nitroAirburstAnimPlayer.drawAnim(graphics, n, n2);
            }
            if (this.m_slipstreamAnimPlayer.isAnimating()) {
                s3 = CAR_SPEEDLINES_ANIM_IDS[n5];
                this.m_slipstreamAnimPlayer.startAnim(s3, 4);
                this.m_slipstreamAnimPlayer.drawAnim(graphics, n, n2);
            }
            if (this.m_boostAnimPlayer != null && this.m_boostAnimPlayer.isAnimating()) {
                short[] sArray = CAR_NITRO_ANIM_IDS;
                int n6 = this.m_engine.isPlayerCop() ? 3 : this.m_engine.getPlayerCarIndex();
                switch (n6) {
                    case 0: {
                        sArray = CAR_NITRO_PORSCHE_ANIM_IDS;
                        break;
                    }
                    case 2: {
                        sArray = CAR_NITRO_KOENIGSEGG_ANIM_IDS;
                        break;
                    }
                    case 1: {
                        sArray = CAR_NITRO_GALLARDO_ANIM_IDS;
                    }
                }
                this.m_boostAnimPlayer.startAnim(sArray[n5], 4);
                this.m_boostAnimPlayer.drawAnim(graphics, n, n2);
            }
            if (this.m_smokeAnimPlayer.isAnimating() && (s2 = CAR_SMOKE_ANIM_IDS[n5]) > -1) {
                this.m_smokeAnimPlayer.startAnim(s2, 4);
                this.m_smokeAnimPlayer.drawAnim(graphics, n, n2);
            }
            if (this.m_dustAnimPlayer.isAnimating() && (s = CAR_DUST_ANIM_IDS[n5]) > -1) {
                this.m_dustAnimPlayer.startAnim(s, 4);
                this.m_dustAnimPlayer.drawAnim(graphics, n, n2);
            }
            if (this.m_playerImpactSparkAnimPlayer.isAnimating() && !this.m_playerBumpedFront || this.m_playerImpactSparkAnimPlayer.getCurrAnimFrame() >= 3 && this.m_playerImpactSparkAnimPlayer.isAnimating()) {
                this.m_playerImpactSparkAnimPlayer.drawAnim(graphics, this.m_playerImpactSparkX, this.m_playerImpactSparkY);
            }
            if ((animPlayer = this.m_playerCar.getAnimPlayer()) != null && animPlayer.isAnimating() && AnimationManager.getAnimFrameFirePoint(this.m_tempFirepoint, this.m_playerCarAnimPlayer.getAnimID(), this.m_playerCarAnimPlayer.getCurrAnimFrame(), 0)) {
                animPlayer.drawAnim(graphics, this.m_playerCar.getRenderPosX() + this.m_tempFirepoint[0], this.m_playerCar.getRenderPosY() + this.m_tempFirepoint[1]);
            }
        }
    }

    private void renderCar(Graphics graphics, TrackObject trackObject) {
        AppEngine appEngine = this.m_engine;
        if (trackObject.getFlags(1)) {
            int n = trackObject.getAppearance();
            int n2 = this.getOpponentCarFrameFromDistance(trackObject.getRenderDistF());
            int n3 = -1;
            short s = trackObject.getObjectType() == 7 || trackObject.getObjectType() == 9 ? appEngine.getCpuCarOncomingAnimID(n) : appEngine.getCpuCarAnimID(n);
            AnimationManager.drawAnimFrame(graphics, s, n2, trackObject.getRenderPosX(), trackObject.getRenderPosY());
            AnimPlayer animPlayer = trackObject.getAnimPlayer();
            if (animPlayer != null) {
                int n4 = -1;
                if (n != 3) {
                    return;
                }
                n4 = COP_LIGHT_ANIM_IDS[n2];
                int n5 = trackObject.getState();
                if (n5 != 1 && n5 != 2) {
                    animPlayer.startAnim(n4, 4);
                    AnimationManager.getAnimFrameFirePoint(this.m_tempFirepoint, s, n2, 0);
                    animPlayer.drawAnim(graphics, trackObject.getRenderPosX() + this.m_tempFirepoint[0], trackObject.getRenderPosY() + this.m_tempFirepoint[1]);
                }
            }
        } else {
            boolean bl = trackObject.isAnimatingCollision();
            short s = appEngine.getObjectAnimID(trackObject.getObjectType(), bl);
            int n = this.getOpponentCarFrameFromDistance(trackObject.getRenderDistF());
            AnimationManager.drawAnimFrame(graphics, s, n, trackObject.getRenderPosX(), trackObject.getRenderPosY());
        }
    }

    private void renderDrawList(Graphics graphics) {
        int n = 0;
        int n2 = this.m_firstCarRenderIndex;
        int n3 = 0;
        int n4 = this.m_firstStaticObjRenderIndex;
        int n5 = 0;
        TrackObject[] trackObjectArray = this.m_carsTrackOrder;
        graphics.setClip(VIEWPORT_LEFT, VIEWPORT_TOP, VIEWPORT_WIDTH, TRACK_VIEWPORT_HEIGHT);
        if (this.m_firstCarRenderIndex >= 0 && (n = this.m_firstCarRenderIndex - this.m_currCarRenderIndex) <= 0) {
            n += trackObjectArray.length;
        }
        if (this.m_firstStaticObjRenderIndex >= 0 && (n3 = this.m_firstStaticObjRenderIndex - this.m_currStaticObjRenderIndex) <= 0) {
            n3 += 100;
        }
        while (n > 0 || n3 > 0) {
            TrackObject trackObject = null;
            int n6 = -1;
            boolean bl = true;
            if (n > 0 && n3 > 0) {
                int n7 = this.m_staticTrackObjects[n4][6];
                if (trackObjectArray[n2].getRenderDistF() <= n7) {
                    bl = false;
                }
            } else if (n3 > 0) {
                bl = false;
            }
            if (bl) {
                trackObject = trackObjectArray[n2];
                --n;
                if (--n2 < 0) {
                    n2 += trackObjectArray.length;
                }
            } else {
                n6 = n4--;
                --n3;
                if (n4 < 0) {
                    n4 += 100;
                }
            }
            if (trackObject != null) {
                if (n5 != trackObject.getRenderClipY()) {
                    n5 = trackObject.getRenderClipY();
                    graphics.setClip(VIEWPORT_LEFT, VIEWPORT_TOP, VIEWPORT_WIDTH, TRACK_VIEWPORT_HEIGHT - n5);
                }
                if (!bl || !trackObject.isInitialised() || !trackObject.isVisible()) continue;
                if (trackObject.getObjectType() == 0) {
                    this.renderPlayerCar(graphics, trackObject);
                    continue;
                }
                this.renderCar(graphics, trackObject);
                continue;
            }
            if (n6 == -1) continue;
            this.renderStaticObj(graphics, n6);
        }
    }

    private int getAnimIDIndexFromAngle(int n) {
        if (n < -this.m_carAngleLimit04F) {
            return 0;
        }
        if (n < -this.m_carAngleLimit03F) {
            return 1;
        }
        if (n < -this.m_carAngleLimit02F) {
            return 2;
        }
        if (n < -this.m_carAngleLimit01F) {
            return 3;
        }
        if (n <= this.m_carAngleLimit01F) {
            return 4;
        }
        if (n <= this.m_carAngleLimit02F) {
            return 5;
        }
        if (n <= this.m_carAngleLimit03F) {
            return 6;
        }
        if (n <= this.m_carAngleLimit04F) {
            return 7;
        }
        return 8;
    }

    private final void DEBUG_OPP_DIST_FRAME(int n, int n2, int n3) {
    }

    private int getOpponentCarFrameFromDistance(int n) {
        if (n > 394723) {
            this.DEBUG_OPP_DIST_FRAME(n, 394723, 0);
            return 0;
        }
        if (n > 274006) {
            this.DEBUG_OPP_DIST_FRAME(n, 274006, 1);
            return 1;
        }
        if (n > 202309) {
            this.DEBUG_OPP_DIST_FRAME(n, 202309, 2);
            return 2;
        }
        if (n > 153288) {
            this.DEBUG_OPP_DIST_FRAME(n, 153288, 3);
            return 3;
        }
        if (n > 116523) {
            this.DEBUG_OPP_DIST_FRAME(n, 116523, 4);
            return 4;
        }
        if (n > 86966) {
            this.DEBUG_OPP_DIST_FRAME(n, 86966, 5);
            return 5;
        }
        if (n > 61800) {
            this.DEBUG_OPP_DIST_FRAME(n, 61800, 6);
            return 6;
        }
        this.DEBUG_OPP_DIST_FRAME(n, -1, 7);
        return 7;
    }

    private int getCarSlope() {
        NonUniformSpline nonUniformSpline = this.m_trackRailSpline;
        int n = this.m_playerCar.getSplineDistance();
        int n2 = nonUniformSpline.getNodeAtDistance(n);
        int[] nArray = this.m_trackNodeSlope;
        int n3 = n2 + 1;
        int n4 = n3 == nonUniformSpline.getNodeCount() ? nonUniformSpline.getMaxDistance() : nonUniformSpline.getDistanceAtNode(n3);
        int n5 = n4 - n;
        if (n5 <= 327680) {
            int n6 = n2 == nonUniformSpline.getNodeCount() - 1 ? nArray[0] - nArray[n2] : nArray[n2 + 1] - nArray[n2];
            int n7 = MathExt.mulF(n6, MathExt.divF(327680 - n5, 327680));
            return nArray[n2] + n7;
        }
        return nArray[n2];
    }

    private int calcDistance(int n, int n2) {
        int n3 = n2 - n;
        if (n3 < 0) {
            n3 += this.m_trackRailSpline.getMaxDistance();
        }
        return n3;
    }

    private int getFurthestVisibileCarTrackOrder() {
        int n = this.m_viewPosF;
        TrackObject[] trackObjectArray = this.m_carsTrackOrder;
        NonUniformSpline nonUniformSpline = this.m_trackRailSpline;
        int n2 = -1;
        int n3 = -1;
        int n4 = this.m_perspectiveRangesF[0];
        for (int i = 0; i < 30; ++i) {
            int n5 = trackObjectArray[i].getSplineDistance();
            int n6 = this.calcDistance(n, n5);
            if (n6 > n4 || n6 < n2) continue;
            n2 = n6;
            n3 = i;
        }
        return n3;
    }

    private void showEventTutorial() {
        if (this.m_eventType != 7 && !this.m_engine.isEventTypeKnown(this.m_eventType) && !this.m_eventTutorialShown) {
            this.m_eventTutorialShown = true;
            this.m_flowManager.transitionPush(57);
        }
    }

    public void stateInit(int n) {
        AppEngine appEngine = this.m_engine;
        TextManager textManager = this.m_textManager;
        textManager.pagedReset();
        switch (n) {
            case 45: {
                this.preLoadSetup();
                appEngine.renderBloomNextFrame();
                break;
            }
            case 49: {
                this.m_engine.reduceBounty(this.m_engine.total_bonusDeductions);
                this.m_flowManager.transitionPush(46);
                this.startRace();
                if (!SceneMenu.bonus_speed_freak) break;
                System.out.println("-------------------------------------------------->1");
                this.getPlayerCar().setSpeedFreak();
                break;
            }
            case 46: {
                break;
            }
            case 47: {
                break;
            }
            case 48: {
                for (int i = this.m_trackObjects.length - 1; i >= 0; --i) {
                    this.m_trackObjects[i].setBoosting(false);
                }
                this.m_startLightsState = 0;
                this.m_startLightsTimer = 0;
                this.m_startLightsAnimPlayer.startAnim(226, 16);
                this.showEventTutorial();
                break;
            }
            case 50: {
                this.hudRedraw(131072);
                this.showEventTutorial();
                break;
            }
            case 51: {
                this.isBusted = false;
                this.onRaceOver();
                this.resetEffects();
                if (this.m_eventType != 6) break;
                this.setCustomMessageText(259, true);
                break;
            }
            case 52: {
                this.isBusted = false;
                this.onRaceOver();
                this.resetEffects();
                if (this.m_eventType == 5) {
                    this.setCustomMessageText(258, true);
                    break;
                }
                if (this.m_eventType != 2) break;
                this.setCustomMessageText(251, true);
                break;
            }
            case 53: {
                this.isBusted = true;
                this.onRaceOver();
                this.resetEffects();
                this.setCustomMessageText(246, true);
                this.m_engine.updateTrophyData(0x200000, 1);
                break;
            }
            case 54: 
            case 55: 
            case 56: {
                this.eventOver();
                break;
            }
        }
    }

    public void stateCleanup(int n) {
        this.flashMenuHighlight(this.m_flowManager.getStateStackSize() <= 1);
    }

    public void stateExpose(int n) {
        int n2 = this.m_flowManager.getStateLayout(n);
        switch (n2) {
            case 20: 
            case 25: 
            case 37: {
                this.m_flowManager.setCompositingEnabled(false);
                break;
            }
            default: {
                this.m_flowManager.setCompositingEnabled(true);
            }
        }
    }

    public void stateTransitionInFinished(int n) {
        if (this.m_flowManager.getStateMenu(n) != -1) {
            this.flashMenuHighlight(false);
        }
        if (n == 60) {
            this.m_refreshViewport = true;
        }
    }

    public void stateTransitionOutFinished(int n) {
    }

    public void stateAnimationFinished(int n) {
    }

    public int stateGetTransitionInAnimation(int n) {
        switch (n) {
            case 45: {
                return -4;
            }
            case 46: 
            case 48: 
            case 50: {
                return -1;
            }
            case 60: {
                if (!this.m_interrupted) break;
                return -1;
            }
        }
        return -2;
    }

    public int stateGetTransitionOutAnimation(int n) {
        if (this.m_flowManager.isChangingScene()) {
            return -5;
        }
        switch (n) {
            case 46: 
            case 48: 
            case 50: 
            case 63: 
            case 64: {
                return -1;
            }
        }
        return -3;
    }

    public boolean stateGetTransitionTriggered(int n) {
        return false;
    }

    public void stateEventTriggered(int n) {
    }

    public void stateMenuItemEventTriggered(int n) {
        this.flashMenuHighlight(true);
    }

    private SDKString getConfirmationText(SDKString sDKString) {
        TextManager textManager = this.m_textManager;
        int n = -1;
        switch (this.m_flowManager.getCurrentState()) {
            case 63: {
                n = 48;
                break;
            }
            case 64: {
                n = 213;
                break;
            }
            case 65: {
                n = 53;
            }
        }
        return textManager.getString(n);
    }

    private SDKString getConfirmationTitle(SDKString sDKString) {
        TextManager textManager = this.m_textManager;
        switch (this.m_flowManager.getCurrentState()) {
            case 63: 
            case 64: {
                return textManager.getString(220);
            }
            case 65: {
                return textManager.getString(49);
            }
        }
        return SDK_BAD_TEXT;
    }

    public SDKString getLayoutString(int n) {
        TextManager textManager = this.m_textManager;
        SDKString sDKString = textManager.clearStringBuffer();
        if (n == 102) {
            textManager.appendIntToBuffer(this.m_playerCar.getSpeedInSpeedUnitsF() >> 12);
            sDKString.append(" ");
            if (this.m_engine.areSpeedunitsMPH()) {
                textManager.appendSDKStringToBuffer(this.m_textManager.getString(235));
            } else {
                textManager.appendSDKStringToBuffer(this.m_textManager.getString(236));
            }
        } else {
            if (n == 104) {
                return this.getHUDStatsString(sDKString);
            }
            if (n == 170) {
                switch (this.m_eventType) {
                    case 0: {
                        sDKString.append(MathExt.mulF(this.getSprintCompletionValue(), 0x640000) >> 16);
                        sDKString.append("%");
                        return sDKString;
                    }
                }
                return sDKString.append("");
            }
            if (n == 155) {
                if (this.getProfileRank() != -1) {
                    sDKString = this.m_engine.getPreraceRankLegendString(this.getProfileRank(), sDKString);
                }
                return sDKString;
            }
            if (n == 105) {
                textManager.appendIntToBuffer(this.m_profileAggression + this.m_profilePrecision);
            } else {
                if (n == 107) {
                    return this.getScoreDescriptionString(sDKString);
                }
                if (n == 106) {
                    return sDKString;
                }
                if (n == 108) {
                    return this.m_stringBufferNotifyText;
                }
                if (n == 171) {
                    return this.m_stringBufferCoolWordingText;
                }
                if (n == 159) {
                    sDKString.append("");
                    return sDKString;
                }
                if (n == 160) {
                    sDKString.append("");
                    return sDKString;
                }
                if (n == 142) {
                    return sDKString.append(this.m_textManager.getString(210));
                }
                if (n == 149) {
                    this.m_engine.timeToSDKString(this.getRaceDuration(), 0, sDKString);
                    return sDKString;
                }
                if (n == 143) {
                    return sDKString.append(this.m_textManager.getString(209));
                }
                if (n == 150) {
                    byte by = this.getProfileRank();
                    if (by == 3) {
                        return this.m_textManager.getString(136);
                    }
                    if (by == 2) {
                        return this.m_textManager.getString(135);
                    }
                    if (by == 1) {
                        return this.m_textManager.getString(134);
                    }
                    return this.m_textManager.getString(6);
                }
                if (n == 144) {
                    switch (this.m_eventType) {
                        case 0: 
                        case 1: 
                        case 2: 
                        case 4: 
                        case 5: 
                        case 6: {
                            sDKString.append(this.m_textManager.getString(203));
                            break;
                        }
                        case 3: {
                            sDKString.append(this.m_textManager.getString(204));
                            break;
                        }
                    }
                    return sDKString;
                }
                if (n == 151) {
                    switch (this.m_eventType) {
                        case 0: 
                        case 1: 
                        case 2: 
                        case 4: 
                        case 5: 
                        case 6: {
                            textManager.appendIntToBuffer(this.m_engine.getValueInDistanceUnits(this.m_playerCar.getBestSpeedF() >> 12));
                            textManager.appendStringToBuffer(" ");
                            if (this.m_engine.areSpeedunitsMPH()) {
                                sDKString.append(this.m_textManager.getString(235));
                                break;
                            }
                            sDKString.append(this.m_textManager.getString(236));
                            break;
                        }
                        case 3: {
                            SDKString sDKString2 = this.m_textManager.clearStringBuffer();
                            int[] nArray = this.m_speedCameraSpeedsTrackOrder;
                            int n2 = this.getTotalCameraSpeed();
                            n2 = this.m_engine.getValueInDistanceUnits(n2);
                            this.m_engine.intToSDKString(n2, false, sDKString2);
                            sDKString.append(sDKString2);
                            sDKString.append(" ");
                            if (this.m_engine.areSpeedunitsMPH()) {
                                sDKString.append(this.m_textManager.getString(235));
                                break;
                            }
                            sDKString.append(this.m_textManager.getString(236));
                            break;
                        }
                    }
                    return sDKString;
                }
                if (n == 145) {
                    switch (this.m_eventType) {
                        case 1: 
                        case 2: {
                            sDKString.append(this.m_textManager.getString(192));
                            break;
                        }
                        default: {
                            sDKString.append("");
                        }
                    }
                    return sDKString;
                }
                if (n == 152) {
                    switch (this.m_eventType) {
                        case 1: 
                        case 2: {
                            this.m_engine.timeToSDKString(this.m_bestLapTime, 0, sDKString);
                            break;
                        }
                        default: {
                            sDKString.append("");
                        }
                    }
                    return sDKString;
                }
                if (n == 146) {
                    switch (this.m_eventType) {
                        case 0: 
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: {
                            sDKString.append(this.m_textManager.getString(201));
                            break;
                        }
                        case 5: 
                        case 6: {
                            sDKString.append(this.m_textManager.getString(202));
                            break;
                        }
                    }
                    return sDKString;
                }
                if (n == 153) {
                    switch (this.m_eventType) {
                        case 0: 
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: {
                            this.m_engine.moneyToSDKString(this.m_careerExtraBounty, sDKString);
                            break;
                        }
                    }
                    return sDKString;
                }
                if (n == 147) {
                    switch (this.m_eventType) {
                        case 0: 
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: {
                            sDKString.append(this.m_textManager.getString(200));
                            break;
                        }
                    }
                    return sDKString;
                }
                if (n == 154) {
                    switch (this.m_eventType) {
                        case 0: 
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: {
                            this.m_engine.moneyToSDKString(this.m_careerBountyReward, sDKString);
                            break;
                        }
                    }
                    return sDKString;
                }
                if (n == 148) {
                    if (this.isBusted) {
                        return sDKString.append("");
                    }
                    switch (this.m_eventType) {
                        case 0: 
                        case 1: 
                        case 2: 
                        case 3: 
                        case 5: {
                            if (this.m_engine.rmsGetEventRank(this.m_engine.getCurrentRaceEventIndex()) > this.m_engine.prevRank) {
                                return sDKString.append(this.m_textManager.getString(199));
                            }
                            if (this.m_engine.rmsGetTrackBestRaceTime(this.m_engine.getCurrentRaceEventIndex()) >= this.m_engine.prevBestRaceTime) break;
                            return sDKString.append(this.m_textManager.getString(199));
                        }
                        case 4: 
                        case 6: {
                            if (this.m_engine.rmsGetEventRank(this.m_engine.getCurrentRaceEventIndex()) <= this.m_engine.prevRank) break;
                            return sDKString.append(this.m_textManager.getString(199));
                        }
                    }
                    return sDKString.append("");
                }
                if (n == 161) {
                    if (this.getProfileRank() == -1) {
                        sDKString.append(this.m_textManager.getString(207));
                    } else {
                        sDKString.append(this.m_textManager.getString(208));
                    }
                    return sDKString;
                }
                return this.getLayoutStringUncommon(n, sDKString);
            }
        }
        return sDKString;
    }

    private SDKString getLayoutStringUncommon(int n, SDKString sDKString) {
        block0 : switch (n) {
            case 68: {
                return this.m_engine.getLoadingProgressString(this.m_loadingProgress, sDKString);
            }
            case 109: {
                if (this.m_eventType == 7) {
                    return this.m_textManager.getString(229);
                }
                return this.m_textManager.getString(49);
            }
            case 67: {
                return this.m_textManager.pagedGetPositionString(sDKString);
            }
            case 98: 
            case 110: {
                if (this.m_tutorialState == 0) break;
                this.m_textManager.appendStringIdToBuffer(93);
                break;
            }
            case 97: 
            case 111: {
                if (this.m_tutorialState == 0) break;
                this.m_textManager.appendStringIdToBuffer(this.getTutorialMessage());
                break;
            }
            case 113: {
                if (this.m_flowManager.getCurrentState() == 57) {
                    this.m_textManager.appendStringIdToBuffer(this.getTutorialMessage());
                    break;
                }
                if (this.m_flowManager.getCurrentState() != 63 && this.m_flowManager.getCurrentState() != 64 && this.m_flowManager.getCurrentState() != 65) break;
                return this.getConfirmationText(sDKString);
            }
            case 114: {
                if (this.m_flowManager.getCurrentState() == 57) {
                    this.m_textManager.appendStringIdToBuffer(93);
                    break;
                }
                return this.getConfirmationTitle(sDKString);
            }
            case 101: {
                AppEngine.starsRankToSDKString(this.getEventStars(), sDKString);
                break;
            }
            case 93: {
                this.m_textManager.appendIntToBuffer(this.m_biggestDriftScore);
                break;
            }
            case 87: {
                int n2 = this.m_playerCar.getRacePos();
                switch (n2) {
                    case 0: {
                        this.m_textManager.appendStringIdToBuffer(194);
                        break block0;
                    }
                    case 1: {
                        this.m_textManager.appendStringIdToBuffer(195);
                        break block0;
                    }
                    case 2: {
                        this.m_textManager.appendStringIdToBuffer(196);
                        break block0;
                    }
                }
                this.m_textManager.appendIntToBuffer(n2 + 1);
                break;
            }
            case 94: {
                this.m_engine.appendTimeToBuffer(this.m_bestLapTime, sDKString);
                break;
            }
            case 89: {
                return this.m_textManager.getString(210);
            }
            case 90: {
                if (!this.m_engine.isCurrentRaceCareer()) break;
                int n3 = this.m_careerBountyReward;
                this.m_engine.moneyToSDKString(n3, sDKString);
                break;
            }
            default: {
                return this.m_engine.getLayoutString(n, sDKString);
            }
        }
        return sDKString;
    }

    private void onRaceOver() {
        if (this.m_engine.isCurrentRaceCareer()) {
            this.m_engine.updateTrophyData(0x100000, this.m_engine.getPlayerCarIndex());
        }
        if (!this.m_engine.isCurrentRaceTutorial()) {
            this.m_engine.updateTrophyData(128, this.m_playerCar.getMilesDrivenF());
            this.m_engine.updateTrophyData(262144, this.m_playerCar.getMilesDrivenUpstreamF());
        }
    }

    private void flashMenuHighlight(boolean bl) {
        this.m_menuHighlightFlashTimeout = 600;
        this.m_menuHighlightActivatingSelection = bl;
    }

    public int getSubLayoutTime(int n) {
        int n2 = this.m_flowManager.getCurrentState();
        switch (n) {
            case 22: {
                if (!this.m_menuHighlightActivatingSelection) break;
                return -1;
            }
            case 21: {
                if (n2 == 50 || n2 == 48 || n2 == 58) break;
                return -1;
            }
            case 3: {
                if (!this.isMenuItemEnabled(24)) break;
                return -1;
            }
            case 25: {
                return -1;
            }
            case 26: {
                if (this.m_eventType != 7 && this.m_engine.isCurrentRaceCareer()) break;
                return -1;
            }
            case 18: {
                if (this.m_textManager.pagedCanMove(-1)) break;
                return -1;
            }
            case 19: {
                if (this.m_textManager.pagedCanMove(1)) break;
                return -1;
            }
        }
        return 0;
    }

    public void drawLayoutRect(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        switch (n) {
            case 2: {
                this.renderLineMiniMap(graphics);
                break;
            }
            case 6: {
                this.m_textManager.pagedDraw(n2, n3, n4, n5, 26);
            }
        }
    }

    public void drawLayoutPoint(Graphics graphics, int n, int n2, int n3) {
        block0 : switch (n) {
            case 1: {
                this.renderViewport(graphics);
                break;
            }
            case 23: {
                switch (this.m_eventType) {
                    case 0: {
                        AnimationManager.drawAnimFrame(graphics, 256, 0, n2, n3);
                    }
                }
                break;
            }
            case 3: {
                this.m_engine.renderBackgroundDim(graphics, true);
                break;
            }
            case 4: {
                this.renderSpeedometer(graphics, n2, n3);
                break;
            }
            case 8: {
                this.renderNitroIcon(graphics, n2, n3);
                break;
            }
            case 16: {
                if (this.m_eventType != 3) break;
                this.renderHUDSpeedCamera(graphics, n2, n3);
                break;
            }
            case 18: {
                this.renderMedal(graphics, n2, n3);
                break;
            }
            case 20: {
                break;
            }
            case 21: {
                break;
            }
            case 17: {
                switch (this.m_eventType) {
                    case 2: {
                        this.renderHUDCarPos(graphics, n2, n3);
                        break block0;
                    }
                }
                break;
            }
            case 7: {
                this.renderNitroGauge(graphics, n2, n3);
                break;
            }
            case 31: {
                this.renderPursuitLevelDisplay(graphics, n2, n3);
                break;
            }
            case 32: {
                this.renderSpeedBrakeDisplay(graphics, n2, n3);
            }
        }
    }

    public boolean isMenuItemEnabled(int n) {
        switch (n) {
            default: 
        }
        return true;
    }

    public void processAction(int n, short s) {
        AppEngine appEngine = this.m_engine;
        switch (n) {
            case 47: {
                this.m_engine.saveRMSGameData();
                this.returnToMenu();
                break;
            }
            case 14: {
                appEngine.switchSoundState(true);
                this.flashMenuHighlight(false);
                break;
            }
            case 15: {
                appEngine.switchSoundState(false);
                this.flashMenuHighlight(false);
                break;
            }
            case 16: {
                appEngine.setVibrationEnabled(!appEngine.isVibrationEnabled());
                this.flashMenuHighlight(false);
                break;
            }
            case 17: {
                appEngine.setCarMarkersEnabled(!appEngine.areCarMarkersEnabled());
                this.flashMenuHighlight(false);
                break;
            }
            case 46: {
                this.returnToMenu();
                break;
            }
            case 45: {
                this.restartRace();
                break;
            }
            case 8: {
                this.m_textManager.pagedMovedPage(-1);
                break;
            }
            case 7: {
                this.m_textManager.pagedMovedPage(1);
            }
        }
    }

    static {
        HUD_LAPTIME_POSITION_Y = 50;
        HUD_NEEDLE_LENGTH_F = 917504;
        HUD_NEEDLE_MIN_ANGLE_F = 77208;
        HUD_NEEDLE_TOTAL_ANGLE_F = 257359;
        HUD_NEEDLESPEED_LENGTH_F = 0x140000;
        HUD_NEEDLESPEED_MIN_ANGLE_F = 154416;
        HUD_NEEDLESPEED_TOTAL_ANGLE_F = 360303;
        HUD_PURSUIT_BAR_ANIM_FRAMES = 11;
        HUD_PURSUIT_LEVEL_ICON_WIDTH = 14;
        HUD_PURSUIT_LEVEL_ICON_MARGIN = 2;
        VIEW_DISTANCE_INVF = MathExt.divF(65536, 655360);
        CAMERA_PERSP_INVF = MathExt.divF(65536, MathExt.mulF(131, 0x400000));
        SCALE_ROAD_HEIGHT_F = MathExt.divF(0x400000, 655360);
        CAR_SPEEDLINES_ANIM_IDS = new short[]{221, 220, 219, 218, 216, 222, 223, 224, 225};
        CAR_NITRO_ANIM_IDS = new short[]{165, 158, 151, 144, 200, 172, 179, 186, 193};
        CAR_NITRO_ZONDA_ANIM_IDS = new short[]{171, 164, 157, 150, 206, 178, 185, 192, 199};
        CAR_NITRO_KOENIGSEGG_ANIM_IDS = new short[]{168, 161, 154, 147, 203, 175, 182, 189, 196};
        CAR_NITRO_PORSCHE_ANIM_IDS = new short[]{170, 163, 156, 149, 205, 177, 184, 191, 198};
        CAR_NITRO_AUDI_R8_ANIM_IDS = new short[]{166, 159, 152, 145, 201, 173, 180, 187, 194};
        CAR_NITRO_GALLARDO_ANIM_IDS = new short[]{167, 160, 153, 146, 202, 174, 181, 188, 195};
        CAR_NITRO_MERCEDES_ANIM_IDS = new short[]{169, 162, 155, 148, 204, 176, 183, 190, 197};
        CAR_SMOKE_ANIM_IDS = new short[]{137, 136, 135, 134, 142, 138, 139, 140, 141};
        CAR_DUST_ANIM_IDS = new short[]{210, 209, 208, 207, 215, 211, 212, 213, 214};
        COP_LIGHT_ANIM_IDS = new short[]{77, 76, 75, 74, 73, 72, 71, 70};
        SKYGRADIENTS = new int[][]{{7708660, 7052529, 6133742, 5870828, 5738467, 5474519}, {7183592, 6723040, 6656224, 5867226, 4815573, 3828937}, {15705993, 15048327, 14062983, 12880775, 11436680, 10518150}};
        s_tempInt4x4 = new int[4][4];
        BB_CONSTRUCTION_BARRIER = new int[]{-29491, -22937, 29491, 42598};
        BB_DUMPSTER = new int[]{-22937, -16384, 22937, 16384};
        CORNER_VALUES = new int[]{0, 65536, 78643, 91750};
        HUD_STYLE_STARS_DURATION = 1000;
        HUD_STYLE_STARS_PERIOD = 200;
        SDK_BAD_TEXT = new SDKString("XXX");
        SDK_SPACE = new SDKString(" ");
        SDK_SLASH = new SDKString("/");
    }
}

