/*
 * Decompiled with CFR 0.152.
 */
package game;

import com.ea.sdk.SDKString;
import constants.AnimConstants;
import constants.CarConstants;
import constants.ColourConstants;
import constants.EventConstants;
import constants.IStringConstants;
import constants.InputConstants;
import constants.Layout2Constants;
import constants.ObjectConstants;
import constants.ResourceConstants;
import constants.SoundEventConstants;
import constants.SplineConstants;
import constants.TrackConstants;
import constants.TrackImageConstants;
import constants.TrackSectionConstants;
import game.AppEngine;
import game.GlobalConstants;
import generic.FlowManager;
import generic.LayoutManager2;
import generic.TextManager;
import javax.microedition.lcdui.Graphics;

public abstract class Scene
implements AnimConstants,
Layout2Constants,
InputConstants,
ColourConstants,
IStringConstants,
ResourceConstants,
SoundEventConstants,
GlobalConstants,
CarConstants,
ObjectConstants,
TrackConstants,
TrackSectionConstants,
TrackImageConstants,
SplineConstants,
EventConstants {
    public static final byte SCENE_NONE = -1;
    public static final byte SCENE_MENU = 0;
    public static final byte SCENE_GAME = 1;
    public static final int KEY_0 = 1;
    public static final int KEY_1 = 2;
    public static final int KEY_2 = 4;
    public static final int KEY_3 = 8;
    public static final int KEY_4 = 16;
    public static final int KEY_5 = 32;
    public static final int KEY_6 = 64;
    public static final int KEY_7 = 128;
    public static final int KEY_8 = 256;
    public static final int KEY_9 = 512;
    public static final int KEY_POUND = 1024;
    public static final int KEY_STAR = 2048;
    public static final int KEY_DPAD_FIRE = 4096;
    public static final int KEY_DPAD_UP = 8192;
    public static final int KEY_DPAD_DOWN = 16384;
    public static final int KEY_DPAD_LEFT = 32768;
    public static final int KEY_DPAD_RIGHT = 65536;
    public static final int KEY_SOFTL = 131072;
    public static final int KEY_SOFTR = 262144;
    public static final int KEY_CLR = 524288;
    public static final int KEY_FIRE = 4128;
    public static final int KEY_UP = 8196;
    public static final int KEY_DOWN = 16640;
    public static final int KEY_LEFT = 32784;
    public static final int KEY_RIGHT = 65600;
    public static final int KEY_ARROW = 123220;
    public static final int KEY_NUMBER = 1023;
    public static final int KEY_ANY_UP = 8206;
    public static final int KEY_ANY_DOWN = 17280;
    public static final int KEY_ANY_LEFT = 32914;
    public static final int KEY_ANY_RIGHT = 66120;
    public static final int COMMAND_NONE = 0;
    public static final int COMMAND_CONFIRM = 1;
    public static final int COMMAND_CANCEL = 2;
    public static final int COMMAND_ENTER = 1;
    public static final int COMMAND_NEXT = 1;
    public static final int COMMAND_BACK = 2;
    public static final int COMMAND_OKAY = 1;
    public static final int COMMAND_SELECT = 1;
    public static final int COMMAND_EXIT = 2;
    public static final int COMMAND_YES = 1;
    public static final int COMMAND_NO = 2;
    public static final int COMMAND_LANG_SELECT = 1;
    public static final int COMMAND_LANG_BACK = 2;
    protected final AppEngine m_engine;
    protected final TextManager m_textManager;
    protected final FlowManager m_flowManager;
    protected final LayoutManager2 m_layoutManager;
    protected int m_loadingProgress;

    public static final int getCommandString(int n) {
        return -1;
    }

    public final boolean checkKeys(int n, int n2, int n3, int n4) {
        if ((n2 & n4) != 0 || (n & n3) != 0) {
            this.m_engine.clearCommandKeys();
            this.m_engine.clearKeyBit(n3);
            return true;
        }
        return false;
    }

    protected Scene(AppEngine appEngine, TextManager textManager, FlowManager flowManager, LayoutManager2 layoutManager2) {
        this.m_engine = appEngine;
        this.m_textManager = textManager;
        this.m_flowManager = flowManager;
        this.m_layoutManager = layoutManager2;
    }

    public abstract void start(int var1);

    public abstract void pause();

    public abstract void resume();

    public abstract void end();

    public abstract void render(Graphics var1);

    public abstract void processInput(int var1, int[] var2);

    public abstract void update(int var1);

    public abstract void stateInit(int var1);

    public abstract void stateCleanup(int var1);

    public abstract void stateExpose(int var1);

    public abstract void stateTransitionInFinished(int var1);

    public abstract void stateTransitionOutFinished(int var1);

    public abstract void stateAnimationFinished(int var1);

    public abstract int stateGetTransitionInAnimation(int var1);

    public abstract int stateGetTransitionOutAnimation(int var1);

    public abstract boolean stateGetTransitionTriggered(int var1);

    public abstract void stateEventTriggered(int var1);

    public abstract void stateMenuItemEventTriggered(int var1);

    public abstract void processAction(int var1, short var2);

    public abstract SDKString getLayoutString(int var1);

    public abstract int getSubLayoutTime(int var1);

    public abstract void drawLayoutRect(Graphics var1, int var2, int var3, int var4, int var5, int var6);

    public abstract void drawLayoutPoint(Graphics var1, int var2, int var3, int var4);

    public abstract boolean isMenuItemEnabled(int var1);
}

