/*
 * Decompiled with CFR 0.152.
 */
package game;

import generic.MathExt;

class TrackCollisionPolygon {
    public static final int INTERSECTTEST_NO = 0;
    public static final int INTERSECTTEST_PARALLEL = 1;
    public static final int INTERSECTTEST_YES = 2;
    private int[][] m_vertices;
    private static int[] s_temp2DVec1 = new int[2];
    private static int[] s_temp2DVec2 = new int[2];
    private static int[] s_temp3DVec1 = new int[3];
    private static int[] s_temp3DVec2 = new int[3];

    public TrackCollisionPolygon(int n) {
        this.m_vertices = new int[n][3];
    }

    public void set(int n, int n2, int n3) {
        this.set(n, n2, 0, n3);
    }

    public void set(int n, int n2, int n3, int n4) {
        this.m_vertices[n][0] = n2;
        this.m_vertices[n][1] = n3;
        this.m_vertices[n][2] = n4;
    }

    public void set(int n, int[] nArray) {
        this.set(n, nArray[0], nArray[1], nArray[2]);
    }

    public byte getVertexCount() {
        return (byte)this.m_vertices.length;
    }

    public void getVertex3D(int n, int[] nArray) {
        nArray[0] = this.m_vertices[n][0];
        nArray[1] = this.m_vertices[n][1];
        nArray[2] = this.m_vertices[n][2];
    }

    public void getVertex2D(int n, int[] nArray) {
        nArray[0] = this.m_vertices[n][0];
        nArray[1] = this.m_vertices[n][2];
    }

    public int getVertexX(int n) {
        return this.m_vertices[n][0];
    }

    public int getVertexY(int n) {
        return this.m_vertices[n][1];
    }

    public int getVertexZ(int n) {
        return this.m_vertices[n][2];
    }

    public int[][] getVertices() {
        return this.m_vertices;
    }

    public void getEdge2D(byte by, int[] nArray) {
        byte by2 = by;
        byte by3 = (byte)(by + 1);
        if (by3 >= this.m_vertices.length) {
            by3 = 0;
        }
        nArray[0] = this.m_vertices[by2][0];
        nArray[1] = this.m_vertices[by2][2];
        nArray[2] = this.m_vertices[by3][0];
        nArray[3] = this.m_vertices[by3][2];
    }

    public boolean sharesEdge2D(int[] nArray) {
        for (int i = 0; i < this.m_vertices.length; ++i) {
            byte by = (byte)(i + 1);
            if (by >= this.m_vertices.length) {
                by = 0;
            }
            if ((Math.abs(this.m_vertices[i][0] - nArray[0]) >= 10 || Math.abs(this.m_vertices[i][2] - nArray[1]) >= 10 || Math.abs(this.m_vertices[by][0] - nArray[2]) >= 10 || Math.abs(this.m_vertices[by][2] - nArray[3]) >= 10) && (Math.abs(this.m_vertices[by][0] - nArray[0]) >= 10 || Math.abs(this.m_vertices[by][2] - nArray[1]) >= 10 || Math.abs(this.m_vertices[i][0] - nArray[2]) >= 10 || Math.abs(this.m_vertices[i][2] - nArray[3]) >= 10)) continue;
            return true;
        }
        return false;
    }

    private static final void DEBUG_INTERSECT(String string) {
    }

    public static boolean testIntersection(TrackCollisionPolygon trackCollisionPolygon, TrackCollisionPolygon trackCollisionPolygon2) {
        return TrackCollisionPolygon.testIntersection(trackCollisionPolygon, trackCollisionPolygon2, null);
    }

    public static boolean testIntersection(TrackCollisionPolygon trackCollisionPolygon, TrackCollisionPolygon trackCollisionPolygon2, byte[] byArray) {
        int[] nArray;
        int[] nArray2;
        int[] nArray3 = s_temp2DVec1;
        int[] nArray4 = s_temp2DVec2;
        int[][] nArray5 = trackCollisionPolygon.m_vertices;
        int[][] nArray6 = trackCollisionPolygon2.m_vertices;
        int n = 0;
        int n2 = 0;
        n = 0;
        int n3 = nArray5.length - 1;
        while (n < nArray5.length) {
            nArray2 = nArray5[n];
            nArray = nArray5[n3];
            nArray3[0] = nArray2[0] - nArray[0];
            nArray3[1] = nArray2[2] - nArray[2];
            MathExt.getLineNormal2DCW(nArray3, nArray4);
            nArray3[0] = nArray2[0];
            nArray3[1] = nArray2[2];
            byte by = MathExt.classifyPointsWRTLine(nArray6, nArray4, nArray3);
            if (by == 1) {
                TrackCollisionPolygon.DEBUG_INTERSECT("polyB is entirely on the outside of this edge");
                return false;
            }
            if (by == 0) {
                TrackCollisionPolygon.DEBUG_INTERSECT("verts of polyB span this edge");
                if (byArray != null) {
                    byArray[n2++] = (byte)n3;
                    byArray[n2] = -1;
                }
            }
            n3 = n++;
        }
        n = 0;
        n3 = nArray6.length - 1;
        while (n < nArray6.length) {
            nArray2 = nArray6[n];
            nArray = nArray6[n3];
            nArray3[0] = nArray2[0] - nArray[0];
            nArray3[1] = nArray2[2] - nArray[2];
            MathExt.getLineNormal2DCW(nArray3, nArray4);
            nArray3[0] = nArray2[0];
            nArray3[1] = nArray2[2];
            if (MathExt.classifyPointsWRTLine(nArray5, nArray4, nArray3) == 1) {
                TrackCollisionPolygon.DEBUG_INTERSECT("polyA is entirely on the outside of this edge");
                return false;
            }
            n3 = n++;
        }
        return true;
    }

    public boolean isPointWithin(int n, int n2) {
        for (int i = 0; i < this.m_vertices.length; ++i) {
            int n3 = i + 1;
            if (n3 == this.m_vertices.length) {
                n3 = 0;
            }
            TrackCollisionPolygon.s_temp2DVec1[0] = this.m_vertices[i][0] - this.m_vertices[n3][0];
            TrackCollisionPolygon.s_temp2DVec1[1] = this.m_vertices[i][2] - this.m_vertices[n3][2];
            TrackCollisionPolygon.s_temp2DVec2[0] = this.m_vertices[n3][0];
            TrackCollisionPolygon.s_temp2DVec2[1] = this.m_vertices[n3][1];
            if (MathExt.classifyPointWRTLine(n, n2, s_temp2DVec1, s_temp2DVec2) != 1) continue;
            return false;
        }
        return true;
    }

    public void calcNormal(short[] sArray) {
        TrackCollisionPolygon.s_temp3DVec1[0] = this.m_vertices[2][0] - this.m_vertices[0][0];
        TrackCollisionPolygon.s_temp3DVec1[1] = this.m_vertices[2][1] - this.m_vertices[0][1];
        TrackCollisionPolygon.s_temp3DVec1[2] = this.m_vertices[2][2] - this.m_vertices[0][2];
        TrackCollisionPolygon.s_temp3DVec2[0] = this.m_vertices[1][0] - this.m_vertices[0][0];
        TrackCollisionPolygon.s_temp3DVec2[1] = this.m_vertices[1][1] - this.m_vertices[0][1];
        TrackCollisionPolygon.s_temp3DVec2[2] = this.m_vertices[1][2] - this.m_vertices[0][2];
        int[] nArray = new int[3];
        MathExt.cross3F(s_temp3DVec2, s_temp3DVec1, nArray);
        MathExt.normalise3(nArray);
        for (int i = 0; i < 3; ++i) {
            sArray[i] = MathExt.int16_16ToShort2_14(nArray[i]);
        }
    }

    public int calcPlaneD(short[] sArray) {
        return -MathExt.mulF(this.m_vertices[0][0], sArray[0]) - MathExt.mulF(this.m_vertices[0][1], sArray[1]) - MathExt.mulF(this.m_vertices[0][2], sArray[2]);
    }
}

