/*
 * Decompiled with CFR 0.152.
 */
package game;

import com.ea.sdk.SDKString;
import com.ea.sdk.SDKUtils;
import constants.FontConstants;
import constants.IStringConstants;
import constants.ResourceConstants;
import game.AppEngine;
import game.SceneMenu;
import generic.Cache;
import generic.ResourceManager;
import generic.TextManager;
import java.io.IOException;
import javax.microedition.lcdui.Image;

public class DummyTextManager
implements TextManager,
IStringConstants,
ResourceConstants {
    private int m_numLanguages;
    private Object[] m_fonts;
    private short[] m_wrapOffsets;
    private SDKString m_wrapString;
    private int m_getStringInstance;
    private SDKString[] m_sdkStringInstances;
    private SDKString m_tempStringBuffer;
    private SDKString[] m_tempStringBuffers;
    private int m_tempBufferIndex;
    public static Object moreGamesFont;
    private Image mgFontImage;
    private int m_pagedTextStringId = -1;
    private int m_pagedPages;
    private int m_pagedCurrentPage;
    private int[] m_pagedPageOffsets;
    private int[] m_pagedPageLines;
    private final int PAGED_FONT;

    public DummyTextManager() {
        int n;
        this.PAGED_FONT = 2;
        if (this.m_sdkStringInstances == null) {
            this.m_sdkStringInstances = new SDKString[10];
            for (n = 0; n < 10; ++n) {
                this.m_sdkStringInstances[n] = new SDKString();
            }
        }
        this.m_tempStringBuffers = new SDKString[25];
        for (n = 0; n < 25; ++n) {
            this.m_tempStringBuffers[n] = new SDKString(200, 0);
        }
    }

    public int getNumLanguages() {
        return this.m_numLanguages;
    }

    public void loadManualfont(ResourceManager resourceManager) {
        Object object;
        try {
            object = ResourceConstants.RESOURCE_FILENAMES_LIST[89];
            this.mgFontImage = Image.createImage((String)object);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        object = resourceManager.loadFileIntoByteArray(90);
        moreGamesFont = SDKUtils.loadFont(this.mgFontImage, (byte[])object);
    }

    public boolean loadStringsAndFonts() {
        AppEngine appEngine = AppEngine.getCanvas();
        ResourceManager resourceManager = appEngine.getResourceManager();
        this.loadManualfont(resourceManager);
        byte[] byArray = resourceManager.loadFileIntoByteArray(112);
        this.m_numLanguages = SDKUtils.loadTextHeader(byArray);
        boolean bl = false;
        int n = 0;
        int n2 = n += appEngine.rmsGetLanguage();
        n = SDKUtils.chooseLanguage(n);
        if (n < 0) {
            bl = true;
            n = 0;
        }
        int n3 = FontConstants.RFF_LOOKUPS.length;
        Object[] objectArray = new Object[n3];
        this.m_fonts = objectArray;
        for (int i = 0; i < n3; ++i) {
            Image image = resourceManager.loadImage(FontConstants.IMG_LOOKUPS[i]);
            byte[] byArray2 = resourceManager.loadFileIntoByteArray(FontConstants.RFF_LOOKUPS[i]);
            objectArray[i] = SDKUtils.loadFont(image, byArray2);
        }
        this.loadLanguageChunks(n);
        appEngine.rmsSetLanguage(n2);
        return bl;
    }

    public void loadLanguageChunks(int n) {
        AppEngine.getCanvas().rmsSetLanguage(n);
        SDKUtils.setCurrentLanguage(n);
        SDKUtils.loadStringsChunk(1);
        SDKUtils.loadStringsChunk(2);
        this.m_wrapString = null;
    }

    public void drawString(int n, int n2, int n3, int n4, int n5) {
        if (n != -1) {
            SDKString sDKString = this.getString(n);
            SDKUtils.setFont(this.m_fonts[n2]);
            this.drawString(sDKString, n2, n3, n4, n5);
        }
    }

    public void drawString(SDKString sDKString, int n, int n2, int n3, int n4) {
        if (sDKString != null) {
            SDKUtils.setFont(this.m_fonts[n]);
            if ((n4 & 2) != 0) {
                n3 -= SDKUtils.getLineSize() - SDKUtils.getLeadingSpacing() >> 1;
                n4 &= 0xFFFFFFFD;
            }
            SDKUtils.drawString(sDKString, n2, n3, n4);
        }
    }

    public int getSpaceWidth(int n) {
        SDKUtils.setFont(this.m_fonts[n]);
        return SDKUtils.getSpaceSpacing();
    }

    public int getLineHeight(int n) {
        SDKUtils.setFont(this.m_fonts[n]);
        return SDKUtils.getLineSize();
    }

    public int getBaselinePosition(int n) {
        SDKUtils.setFont(this.m_fonts[n]);
        return SDKUtils.getBaselinePosition();
    }

    public SDKString getString(int n) {
        if (n >= 0) {
            SDKString sDKString = this.m_sdkStringInstances[this.m_getStringInstance];
            this.m_getStringInstance = (this.m_getStringInstance + 1) % 10;
            if (n <= 1) {
                return SDKUtils.getHeaderString(SDKUtils.getCurrentLanguage(), n, sDKString);
            }
            return SDKUtils.getString(n, sDKString);
        }
        return new SDKString("");
    }

    public int getStringLength(int n) {
        SDKString sDKString = this.getString(n);
        return sDKString == null ? 0 : sDKString.length();
    }

    public int getStringWidth(int n, int n2) {
        SDKUtils.setFont(this.m_fonts[n2]);
        SDKString sDKString = this.getString(n);
        return SDKUtils.getStringSize(sDKString);
    }

    public int getStringWidth(SDKString sDKString, int n) {
        SDKUtils.setFont(this.m_fonts[n]);
        return SDKUtils.getStringSize(sDKString);
    }

    public int getFontLeading(int n) {
        SDKUtils.setFont(this.m_fonts[n]);
        return SDKUtils.getLeadingSpacing();
    }

    public SDKString stringToSDKString(String string) {
        return DummyTextManager.convert(string);
    }

    public SDKString clearStringBuffer() {
        int n = this.m_tempBufferIndex + 1;
        if (n >= 25) {
            n = 0;
        }
        this.m_tempStringBuffer = this.m_tempStringBuffers[n];
        AppEngine.ASSERT(n <= 25, "invalid buffer id");
        this.m_tempStringBuffer.setLength(0);
        this.m_tempBufferIndex = n;
        return this.m_tempStringBuffer;
    }

    public void appendStringIdToBuffer(int n) {
        this.m_tempStringBuffer.append(this.getString(n));
    }

    public void appendSDKStringToBuffer(SDKString sDKString) {
        this.m_tempStringBuffer.append(sDKString);
    }

    public void appendStringToBuffer(String string) {
        SDKString sDKString = this.m_tempStringBuffer;
        int n = string.length();
        int n2 = sDKString.length();
        sDKString.setLength(n2 + n);
        for (int i = 0; i != n; ++i) {
            sDKString.setCharAt(n2 + i, string.charAt(i));
        }
    }

    public void appendIntToBuffer(int n) {
        SDKString sDKString = this.m_tempStringBuffer;
        int n2 = sDKString.length();
        if (n == 0) {
            sDKString.setLength(n2 + 1);
            sDKString.setCharAt(n2, '0');
        } else {
            if (n < 0) {
                sDKString.setLength(n2 + 1);
                sDKString.setCharAt(n2++, '-');
                n = -n;
            }
            int n3 = -1;
            boolean bl = false;
            for (int i = 1000000000; i > 0; i /= 10) {
                n3 = n / i;
                if (n3 != 0 || bl) {
                    bl = true;
                    sDKString.setLength(n2 + 1);
                    sDKString.setCharAt(n2++, (char)(48 + n3));
                }
                n -= n3 * i;
            }
        }
    }

    public void appendIntToBufferWithLeadingZeros(int n, int n2) {
        SDKString sDKString = this.m_tempStringBuffer;
        int n3 = sDKString.length();
        int n4 = 0;
        if (n < 0) {
            sDKString.setLength(n3 + 1);
            sDKString.setCharAt(n3, '-');
            ++n4;
            n = -n;
        }
        int n5 = n3 + n4 - 1;
        sDKString.setLength(n3 + n2);
        for (int i = n3 + n2 - 1; i != n5; --i) {
            sDKString.setCharAt(i, (char)(48 + n % 10));
            n /= 10;
        }
    }

    public void initWraps() {
        this.m_wrapOffsets = new short[512];
        this.m_wrapOffsets[0] = 0;
    }

    public int getNumWrappedLines() {
        return this.m_wrapOffsets[0];
    }

    public int wrapString(SDKString sDKString, int n, int n2) {
        SDKUtils.setFont(this.m_fonts[n]);
        this.m_wrapString = sDKString.toSDKString();
        SDKUtils.wrapString(this.m_wrapString, this.m_wrapOffsets, n2, (short)124);
        return this.m_wrapOffsets[0];
    }

    public void drawWrappedString(int n, int n2, int n3, int n4) {
        SDKUtils.setFont(this.m_fonts[n]);
        SDKUtils.drawWrappedString(this.m_wrapString, this.m_wrapOffsets, 1, this.m_wrapOffsets[0], n2, n3, n4);
    }

    public void drawPartWrappedString(int n, int n2, int n3, int n4, int n5, int n6) {
        SDKUtils.setFont(this.m_fonts[n]);
        if ((n4 & 2) != 0) {
            int n7 = SDKUtils.getLineSize() + SDKUtils.getLeadingSpacing();
            int n8 = n6 * n7;
            int n9 = n8 >> 1;
            n3 -= n9;
            n4 ^= 2;
        }
        n6 = Math.min(this.m_wrapOffsets[0] - n5, n6);
        SDKUtils.drawWrappedString(this.m_wrapString, this.m_wrapOffsets, n5 + 1, n6, n2, n3, n4);
    }

    public Object[] getFonts() {
        return this.m_fonts;
    }

    public void appendIntToBuffer(SDKString sDKString, int n, boolean bl) {
        boolean bl2;
        SDKString sDKString2 = this.getString(3);
        boolean bl3 = bl2 = n < 0;
        if (bl2) {
            n = -n;
        }
        int n2 = sDKString.length();
        if (n == 0) {
            sDKString.setCharAt(n2++, '0');
        } else {
            int n3 = -1;
            boolean bl4 = false;
            for (int i = 1000000000; i > 0; i /= 10) {
                n3 = n / i;
                if (n3 != 0 || bl4) {
                    if (bl2 && !bl4) {
                        sDKString.setCharAt(n2, '-');
                    }
                    bl4 = true;
                    sDKString.setCharAt(n2++, (char)(48 + n3));
                    if (bl && (i == 1000000000 || i == 1000000 || i == 1000)) {
                        sDKString.setLength(n2);
                        sDKString.append(sDKString2);
                        n2 = sDKString.length();
                    }
                }
                n -= n3 * i;
            }
        }
        sDKString.setLength(n2);
    }

    public void replace(SDKString sDKString, SDKString sDKString2, int[] nArray) {
        int n = 0;
        int n2 = sDKString2.length();
        boolean bl = false;
        for (int i = 0; i < n2; ++i) {
            char c = sDKString2.charAt(i);
            if (bl) {
                if (c == '\\') {
                    sDKString.setCharAt(n++, c);
                } else {
                    int n3 = Character.digit(c, 36);
                    sDKString.setLength(n);
                    this.appendIntToBuffer(sDKString, nArray[n3], false);
                    n = sDKString.length();
                }
                bl = false;
                continue;
            }
            if (c == '\\') {
                bl = true;
                continue;
            }
            sDKString.setCharAt(n++, c);
        }
        sDKString.setLength(n);
    }

    public void pagedReset() {
        this.m_pagedTextStringId = -1;
    }

    public void pagedInit(int n, int n2, int n3) {
        SDKString sDKString = this.getString(n3);
        if (n3 == 23) {
            sDKString = sDKString.replaceFirst(AppEngine.getCanvas().getVersion());
        }
        if (n3 == 26) {
            // empty if block
        }
        if (n3 == 56 || n3 == 57) {
            sDKString = sDKString.replaceFirst(SceneMenu.getCurrentItemPrice());
        }
        System.out.println(sDKString);
        int n4 = 2;
        int n5 = this.wrapString(sDKString, n4, n);
        int n6 = n2 / this.getLineHeight(n4);
        this.m_pagedPageOffsets = new int[n5 / n6 + 1];
        this.m_pagedPageLines = new int[n5 / n6 + 1];
        int n7 = 0;
        int n8 = 0;
        for (int i = 1; i < n5 + 1; ++i) {
            if (n7 == 0) {
                if (this.m_wrapString.charAt(this.m_wrapOffsets[i]) == '|') continue;
                this.m_pagedPageOffsets[n8] = i - 1;
            }
            if (++n7 != n6) continue;
            this.m_pagedPageLines[n8] = n7;
            ++n8;
            n7 = 0;
        }
        if (n7 != 0) {
            this.m_pagedPageLines[n8] = n7 + 1;
            ++n8;
        }
        this.m_pagedPages = n8;
        this.m_pagedCurrentPage = 0;
        this.m_pagedTextStringId = n3;
    }

    public void pagedDraw(int n, int n2, int n3, int n4, int n5) {
        if (this.m_pagedTextStringId != n5) {
            this.pagedInit(n3 - n, n4 - n2, n5);
        } else {
            SDKString sDKString = this.getString(this.m_pagedTextStringId);
            if (this.m_pagedTextStringId == 23) {
                sDKString = sDKString.replaceFirst(AppEngine.getCanvas().getVersion());
            }
            if (this.m_pagedTextStringId == 26) {
                // empty if block
            }
            if (n5 == 56 || n5 == 57) {
                sDKString = sDKString.replaceFirst(SceneMenu.getCurrentItemPrice());
            }
            this.wrapString(sDKString, 2, n3 - n);
        }
        this.drawPartWrappedString(2, n, n2, 20, this.m_pagedPageOffsets[this.m_pagedCurrentPage], this.m_pagedPageLines[this.m_pagedCurrentPage]);
    }

    public static SDKString convert(String string) {
        char[] cArray = string.toCharArray();
        return new SDKString(cArray, 0, cArray.length);
    }

    public void pagedMovedPage(int n) {
        this.m_pagedCurrentPage += n;
        if (this.m_pagedCurrentPage < 0) {
            this.m_pagedCurrentPage = 0;
        }
        if (this.m_pagedCurrentPage >= this.m_pagedPages) {
            this.m_pagedCurrentPage = this.m_pagedPages - 1;
        }
    }

    public boolean pagedCanMove(int n) {
        int n2 = this.m_pagedCurrentPage + n;
        return this.m_pagedPages > 0 && n2 >= 0 && n2 < this.m_pagedPages;
    }

    public SDKString pagedGetPositionString(SDKString sDKString) {
        int[] nArray = Cache.getInstance().acquireIntArray(2);
        nArray[0] = this.m_pagedCurrentPage + 1;
        nArray[1] = this.m_pagedPages;
        SDKString sDKString2 = this.getString(7);
        this.replace(sDKString, sDKString2, nArray);
        Cache.getInstance().releaseIntArray(nArray);
        return sDKString;
    }
}

