/*
 * Decompiled with CFR 0.152.
 */
package generic;

import com.ea.sdk.ResourceLoader;
import constants.AnimConstants;
import constants.CarConstants;
import constants.ColourConstants;
import constants.EventConstants;
import constants.FlowConstants;
import constants.FontConstants;
import constants.IStringConstants;
import constants.Layout2Constants;
import constants.ObjectConstants;
import constants.ResourceConstants;
import constants.SoundEventConstants;
import constants.SplineConstants;
import constants.TrackConstants;
import constants.TrackSectionConstants;
import constants.TunerShopConstants;
import game.AppEngine;
import game.GlobalConstants;
import java.io.DataInputStream;
import java.io.InputStream;
import javax.microedition.lcdui.Image;

public class ResourceManager
implements AnimConstants,
ColourConstants,
FontConstants,
IStringConstants,
SoundEventConstants,
FlowConstants,
Layout2Constants,
ResourceConstants,
GlobalConstants,
CarConstants,
ObjectConstants,
TrackConstants,
TrackSectionConstants,
SplineConstants,
EventConstants,
TunerShopConstants,
ResourceLoader {
    public static final int NULL = -1;
    public static final int STRING_NULL = -1;
    public static final int OBJECT_INVALID = -1;

    public static final int getFileSize(int n) {
        return ResourceConstants.RESOURCE_FILESIZE_LIST[n];
    }

    public static final String getFileName(int n) {
        return ResourceConstants.RESOURCE_FILENAMES_LIST[n];
    }

    public Image loadImage(int n) {
        try {
            return Image.createImage((String)ResourceManager.getFileName(n));
        }
        catch (Throwable throwable) {
            AppEngine.debug("Exception in loadImage: ");
            throwable.printStackTrace();
            return null;
        }
    }

    public InputStream loadBinaryFile(int n) {
        return this.getClass().getResourceAsStream(ResourceManager.getFileName(n));
    }

    public byte[] loadResource(int n) {
        return this.loadFileIntoByteArray(SoundEventConstants.SOUND_DATA_SETS[n]);
    }

    public byte[] loadFileIntoByteArray(int n) {
        int n2 = ResourceConstants.RESOURCE_FILESIZE_LIST[n];
        byte[] byArray = new byte[n2];
        if (byArray == null) {
            AppEngine.debug("ResourceManager.loadResource(): unable to create byte array");
            return null;
        }
        try {
            DataInputStream dataInputStream = new DataInputStream(this.loadBinaryFile(n));
            if (dataInputStream == null) {
                AppEngine.debug("ResourceManager.loadResource(): null DataInputStream returned from loadBinaryFile()");
                return null;
            }
            dataInputStream.readFully(byArray);
            dataInputStream.close();
            dataInputStream = null;
        }
        catch (Exception exception) {
            AppEngine.debug("Error loading " + ResourceConstants.RESOURCE_FILENAMES_LIST[n]);
            exception.printStackTrace();
            return null;
        }
        return byArray;
    }
}

