/*
 * Decompiled with CFR 0.152.
 */
package generic;

public abstract class MathExt {
    private static final int M_PI_Q16 = 205887;
    private static final int M_2PI_Q16 = 411775;
    private static final int M_PI_Q16_INV = 20861;
    private static final int M_PI_Q16_180 = 1144;
    private static final int M_PI_Q16_180_INV = 3754936;
    public static final int M_ONE_FIXED = 65536;
    public static final int M_HALF_FIXED = 32768;
    public static final int M_2PI = 411775;
    public static final int M_PI = 205887;
    public static final int M_PI_2 = 102944;
    public static final int M_PI_3 = 68629;
    public static final int M_PI_4 = 51472;
    public static final int M_PI_6 = 34315;
    public static final int M_PI_8 = 25736;
    public static final int M_PI_16 = 12868;
    public static final int M_180_FIXED = 0xB40000;
    public static final int M_360_FIXED = 23592960;
    public static final short M_ONE_FIXED_2_14 = 16384;
    private static int[] s_temp2DVec1 = new int[2];
    public static final float FIXED_TO_FLOAT = 1.5258789E-5f;
    private static final int[] ACOS_NEG_PRECALC_F = new int[]{205525, 205375, 205260, 205163, 205077};
    private static final int[] ACOS_POS_PRECALC_F = new int[]{270, 512, 627, 724, 809};
    private static final int[] SQRT_SMALLEST_PRECALC_F = new int[]{0, 256, 362, 443, 512, 572, 627, 677, 724, 768, 810, 849, 887, 923, 958, 991, 1024, 1056, 1086, 1116, 1145, 1173, 1201, 1227, 1254, 1280, 1305, 1330, 1355, 1378, 1402, 1425, 1448, 1471, 1493, 1515, 1536, 1557, 1578, 1599, 1619, 1639, 1659, 1679, 1698, 1717, 1736, 1755};
    private static final int FSQRT_NUM_PRECALCED = SQRT_SMALLEST_PRECALC_F.length;
    private static final int FSQRT_LOWER_SCALE_LIMIT = SQRT_SMALLEST_PRECALC_F[FSQRT_NUM_PRECALCED - 1];
    private static final int FSQRT_UPPER_SCALE_LIMIT = 0x400000;
    public static final byte CLASSIFY_NEGATIVE_SIDE = -1;
    public static final byte CLASSIFY_INTERSECTION = 0;
    public static final byte CLASSIFY_POSITIVE_SIDE = 1;

    private MathExt() {
    }

    public static final int sign(int n) {
        return n > 0 ? 1 : (n < 0 ? -1 : 0);
    }

    public static final int power(int n, int n2) {
        int n3 = 1;
        for (int i = 1; i <= n2; ++i) {
            n3 *= n;
        }
        return n3;
    }

    public static final int powF(int n, int n2) {
        int n3 = 65536;
        for (int i = 1; i <= n2; ++i) {
            n3 = MathExt.mulF(n3, n);
        }
        return n3;
    }

    public static final int clip(int n, int n2, int n3) {
        return Math.max(n2, Math.min(n3, n));
    }

    public static int floatToFixed16(float f) {
        return (int)(f * 65536.0f);
    }

    public static float fixed16ToFloat(int n) {
        return (float)n * 1.5258789E-5f;
    }

    public static short int16_16ToShort2_14(int n) {
        return (short)(n >> 2);
    }

    public static int short2_14ToInt16_16(short s) {
        if (s == 16383) {
            return 65536;
        }
        if (s <= -16383) {
            return -65536;
        }
        return s << 2;
    }

    public static final int mulF(int n, int n2) {
        return (int)((long)n * (long)n2 >> 16);
    }

    public static final int mulLSL1F(int n, int n2) {
        return (int)((long)n * (long)n2 >> 15);
    }

    public static final int divF(int n, int n2) {
        return (int)(((long)n << 16) / (long)n2);
    }

    public static final int dot2F(int[] nArray, int[] nArray2) {
        return (int)((long)nArray[0] * (long)nArray2[0] + (long)nArray[1] * (long)nArray2[1] >> 16);
    }

    public static final int dot3F(int[] nArray, int[] nArray2) {
        return (int)((long)nArray[0] * (long)nArray2[0] + (long)nArray[1] * (long)nArray2[1] + (long)nArray[2] * (long)nArray2[2] >> 16);
    }

    public static final int dot4F(int[] nArray, int[] nArray2) {
        return (int)((long)nArray[0] * (long)nArray2[0] + (long)nArray[1] * (long)nArray2[1] + (long)nArray[2] * (long)nArray2[2] + (long)nArray[3] * (long)nArray2[3] >> 16);
    }

    public static final int dot4F(int[] nArray, int n, int[] nArray2) {
        return (int)((long)nArray[0 + n] * (long)nArray2[0] + (long)nArray[1 + n] * (long)nArray2[1] + (long)nArray[2 + n] * (long)nArray2[2] + (long)nArray[3 + n] * (long)nArray2[3] >> 16);
    }

    public static final int dot4F(int[] nArray, int[] nArray2, int n) {
        return (int)((long)nArray[0] * (long)nArray2[0 + n] + (long)nArray[1] * (long)nArray2[4 + n] + (long)nArray[2] * (long)nArray2[8 + n] + (long)nArray[3] * (long)nArray2[12 + n] >> 16);
    }

    public static final int dot4F(int[] nArray, int[] nArray2, int n, int n2) {
        return (int)((long)nArray[0] * (long)nArray2[0 * n2 + n] + (long)nArray[1] * (long)nArray2[1 * n2 + n] + (long)nArray[2] * (long)nArray2[2 * n2 + n] + (long)nArray[3] * (long)nArray2[3 * n2 + n] >> 16);
    }

    public static final int dot4F(int[] nArray, int n, int[] nArray2, int n2, int n3) {
        return (int)((long)nArray[0 + n] * (long)nArray2[0 * n3 + n2] + (long)nArray[1 + n] * (long)nArray2[1 * n3 + n2] + (long)nArray[2 + n] * (long)nArray2[2 * n3 + n2] + (long)nArray[3 + n] * (long)nArray2[3 * n3 + n2] >> 16);
    }

    public static final void cross3F(int[] nArray, int[] nArray2, int[] nArray3) {
        nArray3[0] = MathExt.mulF(nArray[1], nArray2[2]) - MathExt.mulF(nArray[2], nArray2[1]);
        nArray3[1] = -MathExt.mulF(nArray[0], nArray2[2]) + MathExt.mulF(nArray[2], nArray2[0]);
        nArray3[2] = MathExt.mulF(nArray[0], nArray2[1]) - MathExt.mulF(nArray[1], nArray2[0]);
    }

    public static final int mag2SqrF(int[] nArray) {
        return MathExt.dot2F(nArray, nArray);
    }

    public static final int mag2F(int[] nArray) {
        return MathExt.sqrtF(MathExt.dot2F(nArray, nArray));
    }

    public static final int mag2SqrF(int n, int n2) {
        return (int)((long)n * (long)n + (long)n2 * (long)n2 >> 16);
    }

    public static final int mag2F(int n, int n2) {
        long l = n;
        long l2 = n2;
        return MathExt.sqrtF((int)(l * l + l2 * l2 >> 16));
    }

    public static final int mag3F(int[] nArray) {
        return MathExt.sqrtF(MathExt.dot3F(nArray, nArray));
    }

    public static final int mag3SqrF(int[] nArray) {
        return MathExt.dot3F(nArray, nArray);
    }

    public static final int mag4SqrF(int[] nArray) {
        return MathExt.dot4F(nArray, nArray);
    }

    public static String floatToString3DP(float f) {
        f = (int)(f * 1000.0f);
        return "" + (f /= 1000.0f);
    }

    public static String floatToStringNDP(float f, int n) {
        float f2 = MathExt.power(10, n);
        f = (int)(f * f2);
        return "" + (f /= f2);
    }

    public static String fixedToString2DP(int n) {
        boolean bl = false;
        if (n < 0) {
            n = -n;
            bl = true;
        }
        int n2 = n >> 16;
        int n3 = n & 0xFFFF;
        int n4 = MathExt.mulF(n3, 0x640000);
        String string = new String();
        if (bl) {
            string = string + "-";
        }
        string = string + n2;
        string = string + ".";
        if ((n4 >>= 16) < 10) {
            string = string + "0";
        }
        string = string + n4;
        return string;
    }

    public static String fixedToString4DP(int n) {
        boolean bl = false;
        if (n < 0) {
            n = -n;
            bl = true;
        }
        int n2 = n >> 16;
        int n3 = n & 0xFFFF;
        int n4 = MathExt.mulF(n3, 655360000);
        String string = new String();
        if (bl) {
            string = string + "-";
        }
        string = string + n2;
        string = string + ".";
        if ((n4 >>= 16) < 10) {
            string = string + "000";
        } else if (n4 < 100) {
            string = string + "00";
        } else if (n4 < 1000) {
            string = string + "0";
        }
        string = string + n4;
        return string;
    }

    public static final int degreesToRadiansF(int n) {
        return MathExt.mulF(n, 1144);
    }

    public static float degreesToRadians(float f) {
        return 0.0174533f * f;
    }

    public static final int radiansToDegreesF(int n) {
        return MathExt.mulF(n, 3754936);
    }

    public static float radiansToDegrees(float f) {
        return 57.29578f * f;
    }

    public static final int normaliseAngleRadiansF(int n) {
        if (n > 205887) {
            n -= Math.max(1, n / 411775) * 411775;
        } else if (n < -205887) {
            n += Math.max(1, -n / 411775) * 411775;
        }
        return n;
    }

    public static final int normaliseAngleDegreesF(int n) {
        if (n > 0xB40000) {
            n -= Math.max(1, n / 23592960) * 23592960;
        } else if (n < -11796480) {
            n += Math.max(1, -n / 23592960) * 23592960;
        }
        return n;
    }

    public static final float normaliseAngleDegrees(float f) {
        if (f > 180.0f) {
            f -= (float)Math.max(1, (int)(f / 360.0f)) * 360.0f;
        } else if (f < -180.0f) {
            f += (float)Math.max(1, (int)(-f / 360.0f)) * 360.0f;
        }
        return f;
    }

    public static final float normaliseAngleRadians(float f) {
        if ((double)f > Math.PI) {
            f -= (float)Math.max(1, (int)(f / ((float)Math.PI * 2))) * ((float)Math.PI * 2);
        } else if ((double)f < -Math.PI) {
            f += (float)Math.max(1, (int)(-f / ((float)Math.PI * 2))) * ((float)Math.PI * 2);
        }
        return f;
    }

    public static int getDiffBetweenAnglesF(int n, int n2) {
        return MathExt.normaliseAngleRadiansF(n2 - n);
    }

    public static final int cosF(int n) {
        int n2 = n >= 0 ? 1 : -1;
        int n3 = MathExt.mulF(n2 * n << 1, 20861) & 0x3FFFF;
        int n4 = n3 >> 16 & 3;
        n3 &= 0xFFFF;
        n2 = 1;
        if ((n4 & 1) != 0) {
            n2 = -n2;
            n3 = 65536 - n3;
        }
        if ((n4 & 2) != 0) {
            n2 = -n2;
        }
        n3 = MathExt.mulF(n3, 205887) >> 1;
        int n5 = 262144;
        int n6 = MathExt.mulF(n3, n3);
        int n7 = n6 << 1;
        n5 -= n7;
        n7 = MathExt.mulF(MathExt.mulF(n6, n7), 5461);
        n5 += n7;
        n7 = MathExt.mulF(MathExt.mulF(n6, n7), 2185);
        n5 -= n7;
        n7 = MathExt.mulF(MathExt.mulF(n6, n7), 1170);
        return (n5 += n7) * n2 >> 2;
    }

    public static final int acosF(int n) {
        if (n <= -65536) {
            return 205887;
        }
        if (65535 + n < ACOS_NEG_PRECALC_F.length) {
            return ACOS_NEG_PRECALC_F[65535 + n];
        }
        if (n >= 65536) {
            return 0;
        }
        if (65535 - n < ACOS_POS_PRECALC_F.length) {
            return ACOS_POS_PRECALC_F[65535 - n];
        }
        long l = (long)n * (long)n;
        if (n > 46661) {
            return 102944 - MathExt.acosF(MathExt.sqrtF((int)(0x100000000L - l + 32768L >> 16)));
        }
        if (n < -46661) {
            return 102944 + MathExt.acosF(MathExt.sqrtF((int)(0x100000000L - l + 32768L >> 16)));
        }
        int n2 = (int)(l + 32768L >> 16);
        int n3 = n;
        int n4 = -n3;
        n3 = MathExt.mulF(n3, n2);
        n4 -= MathExt.mulF(10923, n3);
        n3 = MathExt.mulF(n3, n2);
        n4 -= MathExt.mulF(4915, n3);
        n3 = MathExt.mulF(n3, n2);
        return 102944 + (n4 -= MathExt.mulF(2926, n3));
    }

    public static final int sinF(int n) {
        return MathExt.cosF(n - 102944);
    }

    public static final int asinF(int n) {
        if (n <= -65536) {
            return -102944;
        }
        if (n >= 65536) {
            return 102944;
        }
        long l = (long)n * (long)n;
        if (n > 46720) {
            return MathExt.acosF(MathExt.sqrtF((int)(0x100000000L - l >> 16)));
        }
        if (n < -46720) {
            return -MathExt.acosF(MathExt.sqrtF((int)(0x100000000L - l >> 16)));
        }
        int n2 = (int)(l >> 16);
        int n3 = 0;
        int n4 = n;
        n3 += n4;
        n4 = MathExt.mulF(n4, n2);
        n3 += MathExt.mulF(10923, n4);
        n4 = MathExt.mulF(n4, n2);
        n3 += MathExt.mulF(4915, n4);
        n4 = MathExt.mulF(n4, n2);
        return n3 += MathExt.mulF(2926, n4);
    }

    public static final int atan2F(int n, int n2) {
        if (n == 0) {
            if (n2 < 0) {
                return 205887;
            }
            return 0;
        }
        if (n2 == 0) {
            if (n < 0) {
                return -102944;
            }
            return 102944;
        }
        int n3 = MathExt.mag2F(n, n2);
        int n4 = n2 < 0 ? -n2 : n2;
        int n5 = n3 > 0 ? MathExt.divF(n4, n3) : n4;
        int n6 = MathExt.acosF(n5);
        if (n < 0 && n2 < 0) {
            n6 -= 205887;
        } else if (n < 0 && n2 > 0) {
            n6 = -n6;
        } else if (n > 0 && n2 < 0) {
            n6 = 205887 - n6;
        }
        return n6;
    }

    public static final int sqrtF(int n) {
        int n2;
        if (n < 0) {
            return 0;
        }
        if (n < FSQRT_NUM_PRECALCED) {
            return SQRT_SMALLEST_PRECALC_F[n];
        }
        int n3 = n;
        if (n < FSQRT_LOWER_SCALE_LIMIT) {
            n3 <<= 2;
        } else if (n > 0x400000) {
            n3 >>= 2;
        }
        if (n3 > 65200 && n3 < 65800) {
            n2 = n3 + 65536 >> 1;
        } else {
            int n4 = (n3 >> 3) + 131072;
            if (n4 > 0x800000) {
                n4 = 0x800000;
            }
            int n5 = FSQRT_LOWER_SCALE_LIMIT;
            n2 = n4 + n5 >> 1;
            for (int i = 0; i < 13; ++i) {
                int n6 = MathExt.mulF(n2, n2);
                if (n6 > n3) {
                    n4 = n2;
                } else {
                    n5 = n2;
                }
                n2 = n4 + n5 >> 1;
            }
        }
        if (n < FSQRT_LOWER_SCALE_LIMIT) {
            n2 >>= 1;
        } else if (n > 0x400000) {
            n2 <<= 1;
        }
        return n2;
    }

    public static final void normalise2(int[] nArray) {
        int n = MathExt.mag2F(nArray);
        int n2 = 0;
        if (n > 0) {
            n2 = MathExt.divF(65536, n);
        }
        nArray[0] = MathExt.mulF(nArray[0], n2);
        nArray[1] = MathExt.mulF(nArray[1], n2);
        if (nArray[0] == 0 && Math.abs(nArray[1]) != 65536) {
            nArray[1] = nArray[1] < 0 ? -65536 : 65536;
        } else if (nArray[1] == 0 && Math.abs(nArray[0]) != 65536) {
            nArray[0] = nArray[0] < 0 ? -65536 : 65536;
        }
    }

    public static final void normalise3(int[] nArray) {
        int n = MathExt.mag3F(nArray);
        int n2 = 0;
        if (n > 0) {
            n2 = MathExt.divF(65536, n);
        }
        nArray[0] = MathExt.mulF(nArray[0], n2);
        nArray[1] = MathExt.mulF(nArray[1], n2);
        nArray[2] = MathExt.mulF(nArray[2], n2);
        if (nArray[0] == 0 && nArray[1] == 0 && Math.abs(nArray[2]) != 65536) {
            nArray[2] = nArray[2] < 0 ? -65536 : 65536;
        } else if (nArray[0] == 0 && nArray[2] == 0 && Math.abs(nArray[1]) != 65536) {
            nArray[1] = nArray[1] < 0 ? -65536 : 65536;
        } else if (nArray[1] == 0 && nArray[2] == 0 && Math.abs(nArray[0]) != 65536) {
            nArray[0] = nArray[0] < 0 ? -65536 : 65536;
        }
    }

    public static final void getUnitVec2D(int[] nArray, int[] nArray2) {
        int n = MathExt.mag2F(nArray);
        int n2 = 0;
        if (n > 0) {
            n2 = MathExt.divF(65536, n);
        }
        nArray2[0] = MathExt.mulF(nArray[0], n2);
        nArray2[1] = MathExt.mulF(nArray[1], n2);
    }

    public static final void getUnitVec2D(int[] nArray, int[] nArray2, int n) {
        int n2 = MathExt.divF(65536, n);
        nArray2[0] = MathExt.mulF(nArray[0], n2);
        nArray2[1] = MathExt.mulF(nArray[1], n2);
    }

    public static final void getUnitVec3D(int[] nArray, int[] nArray2) {
        int n = MathExt.mag3F(nArray);
        int n2 = 0;
        if (n > 0) {
            n2 = MathExt.divF(65536, n);
        }
        nArray2[0] = MathExt.mulF(nArray[0], n2);
        nArray2[1] = MathExt.mulF(nArray[1], n2);
        nArray2[2] = MathExt.mulF(nArray[2], n2);
    }

    public static final void getUnitVec3D(int[] nArray, int[] nArray2, int n) {
        int n2 = MathExt.divF(65536, n);
        nArray2[0] = MathExt.mulF(nArray[0], n2);
        nArray2[1] = MathExt.mulF(nArray[1], n2);
        nArray2[2] = MathExt.mulF(nArray[2], n2);
    }

    public static final int smoothstepF(int n, int n2, int n3) {
        if (n3 < n) {
            return 0;
        }
        if (n3 >= n2) {
            return 65536;
        }
        int n4 = n3 - n;
        int n5 = n2 - n;
        int n6 = MathExt.divF(n4, n5);
        int n7 = MathExt.mulF(n6, n6);
        return -2 * MathExt.mulF(n7, n6) + 3 * n7;
    }

    public static final int parabolicstepF(int n, int n2, int n3) {
        int n4 = n2 - n >> 1;
        int n5 = MathExt.divF(n3, n4) - 65536;
        int n6 = MathExt.mulF(n5, n5);
        return 65536 - n6;
    }

    public static final float smoothstep(float f, float f2, float f3) {
        if (f3 < f) {
            return 0.0f;
        }
        if (f3 >= f2) {
            return 1.0f;
        }
        float f4 = f3 - f;
        float f5 = f2 - f;
        float f6 = f4 / f5;
        float f7 = f6 * f6;
        return -2.0f * f7 * f6 + 3.0f * f7;
    }

    public static final float parabolicstep(float f) {
        float f2 = (f - 1.0f) * 0.5f;
        float f3 = f2 * f2;
        return 1.0f - f3;
    }

    public static final float parabolicstep(float f, float f2, float f3) {
        float f4 = f2 - f;
        float f5 = f3 / f4 - 1.0f;
        float f6 = f5 * f5;
        return 1.0f - f6;
    }

    public static int linearstepF(int n, int n2, int n3) {
        if (n3 < n) {
            return 0;
        }
        if (n3 >= n2) {
            return 65536;
        }
        int n4 = n3 - n;
        int n5 = n2 - n;
        return MathExt.divF(n4, n5);
    }

    public static float linearstep(float f, float f2, float f3) {
        if (f3 < f) {
            return 0.0f;
        }
        if (f3 >= f2) {
            return 1.0f;
        }
        float f4 = f3 - f;
        float f5 = f2 - f;
        return f4 / f5;
    }

    public static void lerpi(int[] nArray, int[] nArray2, int[] nArray3, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            nArray3[i] = MathExt.mulF(nArray[i], 65536 - n) + MathExt.mulF(nArray2[i], n);
        }
    }

    public static void lerpf(float[] fArray, float[] fArray2, float[] fArray3, float f, int n) {
        for (int i = 0; i < n; ++i) {
            fArray3[i] = fArray[i] * (1.0f - f) + fArray2[i] * f;
        }
    }

    public static void intToRGB(byte[] byArray, int n) {
        byArray[0] = (byte)((n & 0xFF0000) >> 16);
        byArray[1] = (byte)((n & 0xFF00) >> 8);
        byArray[2] = (byte)(n & 0xFF);
    }

    public static int rgbToInt(byte[] byArray) {
        return (byArray[0] << 16) + (byArray[1] << 8) + byArray[2];
    }

    public static final int getVectorYawRadF(int n, int n2, int n3) {
        return MathExt.atan2F(n, n3);
    }

    public static final int getVectorYawDegF(int n, int n2, int n3) {
        return MathExt.radiansToDegreesF(MathExt.atan2F(n, n3));
    }

    public static final int getVectorPitchRadF(int n, int n2, int n3) {
        return MathExt.atan2F(n2, MathExt.sqrtF(MathExt.mulF(n, n) + MathExt.mulF(n3, n3)));
    }

    public static final int getVectorPitchDegF(int n, int n2, int n3) {
        return MathExt.radiansToDegreesF(MathExt.atan2F(n2, MathExt.sqrtF(MathExt.mulF(n, n) + MathExt.mulF(n3, n3))));
    }

    public static void rotate2DVec(int[] nArray, int[] nArray2, int n) {
        nArray2[0] = MathExt.mulF(MathExt.cosF(n), nArray[0]) - MathExt.mulF(MathExt.sinF(n), nArray[1]);
        nArray2[1] = MathExt.mulF(MathExt.sinF(n), nArray[0]) + MathExt.mulF(MathExt.cosF(n), nArray[1]);
    }

    public static void rotate2DVec(int n, int n2, int[] nArray, int n3) {
        nArray[0] = MathExt.mulF(MathExt.cosF(n3), n) - MathExt.mulF(MathExt.sinF(n3), n2);
        nArray[1] = MathExt.mulF(MathExt.sinF(n3), n) + MathExt.mulF(MathExt.cosF(n3), n2);
    }

    public static int angleBetweenVectors2DF(int[] nArray, int[] nArray2) {
        return MathExt.atan2F(nArray2[1], nArray2[0]) - MathExt.atan2F(nArray[1], nArray[0]);
    }

    public static int angleBetweenVectors3DF(int[] nArray, int[] nArray2) {
        int n = MathExt.dot3F(nArray, nArray2);
        int n2 = MathExt.sqrtF(MathExt.mulF(MathExt.mag3SqrF(nArray), MathExt.mag3SqrF(nArray2)));
        if (n2 == 0) {
            n2 = 65536;
        }
        return MathExt.acosF(MathExt.divF(n, n2));
    }

    public static void getLineNormal2DCW(int[] nArray, int[] nArray2) {
        nArray2[0] = -nArray[1];
        nArray2[1] = nArray[0];
    }

    public static void getLineNormal2DCCW(int[] nArray, int[] nArray2) {
        nArray2[0] = nArray[1];
        nArray2[1] = -nArray[0];
    }

    public static int pointLineDistance2DF(int[] nArray, int[] nArray2) {
        int[] nArray3 = new int[]{nArray2[2] - nArray2[0], nArray2[3] - nArray2[1]};
        int[] nArray4 = new int[]{nArray[0] - nArray2[0], nArray[1] - nArray2[1]};
        int n = MathExt.angleBetweenVectors2DF(nArray4, nArray3);
        int n2 = MathExt.mag2F(nArray4);
        return MathExt.mulF(n2, MathExt.sinF(n));
    }

    public static float solveLineEqForZ(float f, float f2, float f3, float f4, float f5) {
        float f6 = f3 != f ? (f4 - f2) / (f3 - f) : 1.0f;
        return f6 * f5 + f2;
    }

    public static float solveLineEqForX(float f, float f2, float f3, float f4, float f5) {
        float f6 = f3 != f ? (f4 - f2) / (f3 - f) : 1.0f;
        return (f5 - f2) / f6;
    }

    public static byte classifyPointsWRTLine(int[][] nArray, int[] nArray2, int[] nArray3) {
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < nArray.length; ++i) {
            int n3 = MathExt.classifyPointWRTLine(nArray[i][0], nArray[i][2], nArray2, nArray3);
            if (n3 > 0) {
                ++n;
            } else if (n3 < 0) {
                ++n2;
            }
            if (n <= 0 || n2 <= 0) continue;
            return 0;
        }
        return n > 0 ? (byte)1 : -1;
    }

    public static int classifyPointWRTLine(int n, int n2, int[] nArray, int[] nArray2) {
        MathExt.s_temp2DVec1[0] = n - nArray2[0];
        MathExt.s_temp2DVec1[1] = n2 - nArray2[1];
        return MathExt.dot2F(nArray, s_temp2DVec1);
    }

    public static int minMaxFactorF(int n, int n2, int n3) {
        return n + MathExt.mulF(n2 - n, n3);
    }
}

