/*
 * Decompiled with CFR 0.152.
 */
package generic;

import generic.MathExt;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;

public class KeyframeManager {
    private static byte ANIMATION_PLAYBACK_TYPE = 0;
    private static byte ANIMATION_PAUSED = 1;
    private static byte ANIMATION_CURRENT_TIME = (byte)2;
    private static byte ANIMATION_DURATION = (byte)3;
    private static byte ANIMATION_MAX = (byte)4;
    private static byte KEYCHAIN_NAME = 0;
    private static byte KEYCHAIN_BLEND_TYPE = 1;
    private static byte KEYCHAIN_CURRENT_TIME = (byte)2;
    private static byte KEYCHAIN_CURRENT_FRAME = (byte)3;
    private static byte KEYCHAIN_CURRENT_VALUE = (byte)4;
    private static byte KEYCHAIN_DURATION = (byte)5;
    private static byte KEYCHAIN_FRAME_COUNT = (byte)6;
    private static byte KEYCHAIN_FRAME0 = (byte)7;
    private int[][] m_animationData = null;
    private int[][][] m_keychainData = null;

    public KeyframeManager(InputStream inputStream) {
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        try {
            int n = dataInputStream.readByte();
            this.m_animationData = new int[n][];
            this.m_keychainData = new int[n][][];
            for (int i = 0; i < n; ++i) {
                int n2 = dataInputStream.readInt();
                int n3 = dataInputStream.readByte();
                this.m_animationData[i] = new int[ANIMATION_MAX];
                this.m_animationData[i][KeyframeManager.ANIMATION_PLAYBACK_TYPE] = n2;
                this.m_animationData[i][KeyframeManager.ANIMATION_PAUSED] = 1;
                this.m_animationData[i][KeyframeManager.ANIMATION_CURRENT_TIME] = 0;
                this.m_animationData[i][KeyframeManager.ANIMATION_DURATION] = 0;
                this.m_keychainData[i] = new int[n3][];
                for (int j = 0; j < n3; ++j) {
                    int n4 = dataInputStream.readInt();
                    byte by = dataInputStream.readByte();
                    byte by2 = dataInputStream.readByte();
                    this.m_keychainData[i][j] = new int[KEYCHAIN_FRAME0 + by2 * 2];
                    this.m_keychainData[i][j][KeyframeManager.KEYCHAIN_NAME] = n4;
                    this.m_keychainData[i][j][KeyframeManager.KEYCHAIN_BLEND_TYPE] = by;
                    this.m_keychainData[i][j][KeyframeManager.KEYCHAIN_CURRENT_TIME] = 0;
                    this.m_keychainData[i][j][KeyframeManager.KEYCHAIN_CURRENT_FRAME] = 0;
                    this.m_keychainData[i][j][KeyframeManager.KEYCHAIN_DURATION] = 0;
                    this.m_keychainData[i][j][KeyframeManager.KEYCHAIN_FRAME_COUNT] = by2;
                    for (int k = KEYCHAIN_FRAME0; k < KEYCHAIN_FRAME0 + 2 * by2; k += 2) {
                        this.m_keychainData[i][j][k] = dataInputStream.readInt();
                        this.m_keychainData[i][j][k + 1] = dataInputStream.readInt();
                        int[] nArray = this.m_keychainData[i][j];
                        byte by3 = KEYCHAIN_DURATION;
                        nArray[by3] = nArray[by3] + this.m_keychainData[i][j][k];
                    }
                    if (this.m_keychainData[i][j][KEYCHAIN_DURATION] > this.m_animationData[i][ANIMATION_DURATION]) {
                        this.m_animationData[i][KeyframeManager.ANIMATION_DURATION] = this.m_keychainData[i][j][KEYCHAIN_DURATION];
                    }
                    this.m_keychainData[i][j][KeyframeManager.KEYCHAIN_CURRENT_VALUE] = by2 > 0 ? this.m_keychainData[i][j][KEYCHAIN_FRAME0 + 1] : 0;
                }
            }
            dataInputStream.close();
        }
        catch (IOException iOException) {
            this.m_animationData = null;
            this.m_keychainData = null;
        }
    }

    public int getKeychainValue(int n, int n2) {
        if (n2 < 0) {
            return 0;
        }
        return this.m_keychainData[n][n2][KEYCHAIN_CURRENT_VALUE];
    }

    public int getKeychainIndex(int n, int n2) {
        for (int i = 0; i < this.m_keychainData[n].length; ++i) {
            if (this.m_keychainData[n][i][KEYCHAIN_NAME] != n2) continue;
            return i;
        }
        return -1;
    }

    public void pause(int n) {
        this.m_animationData[n][KeyframeManager.ANIMATION_PAUSED] = 1;
    }

    public void resume(int n) {
        this.m_animationData[n][KeyframeManager.ANIMATION_PAUSED] = 0;
    }

    public void resetAnimation(int n, boolean bl) {
        this.m_animationData[n][KeyframeManager.ANIMATION_CURRENT_TIME] = 0;
        this.m_animationData[n][KeyframeManager.ANIMATION_PAUSED] = bl ? 0 : 1;
        for (int i = 0; i < this.m_keychainData[n].length; ++i) {
            this.m_keychainData[n][i][KeyframeManager.KEYCHAIN_CURRENT_TIME] = 0;
            this.m_keychainData[n][i][KeyframeManager.KEYCHAIN_CURRENT_FRAME] = 0;
        }
    }

    public void update(float f) {
        for (int i = 0; i < this.m_animationData.length; ++i) {
            int n;
            if (this.m_animationData[i][ANIMATION_PAUSED] == 1) continue;
            int n2 = this.m_animationData[i][ANIMATION_PLAYBACK_TYPE];
            int n3 = this.m_animationData[i][ANIMATION_CURRENT_TIME];
            int n4 = this.m_animationData[i][ANIMATION_DURATION];
            int n5 = n3;
            if ((n2 & 1) > 0) {
                if ((n5 = (int)((float)n5 + f)) > n4) {
                    n = n5 - n4;
                    if ((n2 & 8) > 0) {
                        n5 = n;
                    } else if ((n2 & 0x10) > 0) {
                        n5 = n4 - n;
                        this.m_animationData[i][KeyframeManager.ANIMATION_PLAYBACK_TYPE] = 18;
                    }
                }
            } else if ((n2 & 2) > 0 && (n5 = (int)((float)n5 - f)) < 0) {
                n = -n5;
                if ((n2 & 8) > 0) {
                    n5 = n4 + n;
                } else if ((n2 & 0x10) > 0) {
                    n5 = -n;
                    this.m_animationData[i][KeyframeManager.ANIMATION_PLAYBACK_TYPE] = 17;
                }
            }
            this.m_animationData[i][KeyframeManager.ANIMATION_CURRENT_TIME] = n5;
            for (n = 0; n < this.m_keychainData[i].length; ++n) {
                this.updateKeychain(this.m_keychainData[i][n], n5 - n3);
            }
            if (this.m_animationData[i][ANIMATION_CURRENT_TIME] < this.m_animationData[i][ANIMATION_DURATION] || (this.m_animationData[i][ANIMATION_PLAYBACK_TYPE] & 4) <= 0) continue;
            this.m_animationData[i][KeyframeManager.ANIMATION_PAUSED] = 1;
        }
    }

    private int linear_interpolation(int n, int n2, int n3) {
        return MathExt.mulF(n2 - n, n3) + n;
    }

    private void updateKeychain(int[] nArray, int n) {
        boolean bl;
        boolean bl2;
        int n2 = KEYCHAIN_FRAME0 + 2 * nArray[KEYCHAIN_CURRENT_FRAME];
        int n3 = nArray[KEYCHAIN_CURRENT_TIME] + n;
        while (true) {
            bl2 = n2 == KEYCHAIN_FRAME0;
            boolean bl3 = bl = n2 == KEYCHAIN_FRAME0 + 2 * nArray[KEYCHAIN_FRAME_COUNT] - 2;
            if (!bl2 && n3 < nArray[n2]) {
                n2 -= 2;
                continue;
            }
            if (bl || n3 <= nArray[n2 + 2]) break;
            n2 += 2;
        }
        bl2 = n2 == KEYCHAIN_FRAME0;
        bl = n2 == KEYCHAIN_FRAME0 + 2 * nArray[KEYCHAIN_FRAME_COUNT] - 2;
        int n4 = 0;
        switch (nArray[KEYCHAIN_BLEND_TYPE]) {
            case 0: {
                if (bl2) {
                    if (n3 < nArray[n2]) {
                        n4 = nArray[n2 + 1];
                        break;
                    }
                    int n5 = MathExt.divF(n3 - nArray[n2], nArray[n2 + 2] - nArray[n2]);
                    n4 = this.linear_interpolation(nArray[n2 + 1], nArray[n2 + 3], n5);
                    break;
                }
                if (bl) {
                    if (n3 > nArray[n2]) {
                        n4 = nArray[n2 + 1];
                        break;
                    }
                    int n6 = MathExt.divF(n3 - nArray[n2 - 2], nArray[n2] - nArray[n2 - 1]);
                    n4 = this.linear_interpolation(nArray[n2 - 1], nArray[n2 + 1], n6);
                    break;
                }
                int n7 = MathExt.divF(n3 - nArray[n2], nArray[n2 + 2] - nArray[n2]);
                n4 = this.linear_interpolation(nArray[n2 + 1], nArray[n2 + 3], n7);
            }
        }
        nArray[KeyframeManager.KEYCHAIN_CURRENT_FRAME] = (n2 - KEYCHAIN_FRAME0) / 2;
        nArray[KeyframeManager.KEYCHAIN_CURRENT_TIME] = n3;
        nArray[KeyframeManager.KEYCHAIN_CURRENT_VALUE] = n4;
    }
}

