/*
 * Decompiled with CFR 0.152.
 */
package generic;

import constants.AnimConstants;
import constants.ColourConstants;
import game.AppEngine;
import generic.AnimPlayer;
import generic.MathExt;
import generic.ResourceManager;
import java.io.DataInputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public final class AnimationManager
implements AnimConstants,
ColourConstants {
    private static final byte SUB_IMAGE_ID = 0;
    private static final byte SUB_IMAGE_X = 1;
    private static final byte SUB_IMAGE_Y = 2;
    private static final byte SUB_IMAGE_WIDTH = 3;
    private static final byte SUB_IMAGE_HEIGHT = 4;
    private static final byte NUM_SUB_IMAGE_FIELDS = 5;
    private static final byte PRIMITIVE_SPRITE_ENUM = 0;
    private static final byte PRIMITIVE_CLIP_ENUM = 1;
    private static final byte PRIMITIVE_COLL_BOX_ENUM = 2;
    private static final byte PRIMITIVE_HOLLOW_RECTANGLE_ENUM = 3;
    private static final byte PRIMITIVE_FILLED_RECTANGLE_ENUM = 4;
    private static final byte PRIMITIVE_HOLLOW_ELLIPSE_ENUM = 5;
    private static final byte PRIMITIVE_FILLED_ELLIPSE_ENUM = 6;
    private static final byte PRIMITIVE_FIRE_POINT_ENUM = 7;
    private static final byte PRIMITIVE_LINE_ENUM = 8;
    private static final byte PRIMITIVE_TEXT_ENUM = 9;
    private static final byte PRIMITIVE_COLOR_ENUM = 10;
    private static final byte PRIMITIVE_XFLIPPED_SPRITE_ENUM = 11;
    private static final byte PRIMITIVE_RIGHT_TRIANGLE_ENUM = 12;
    private static final byte PRIMITIVE_ATTRIB_TYPE = 0;
    private static final byte PRIMITIVE_ATTRIB_X = 1;
    private static final byte PRIMITIVE_ATTRIB_Y = 2;
    private static final byte PRIMITIVE_ATTRIB_X2 = 3;
    private static final byte PRIMITIVE_ATTRIB_Y2 = 4;
    private static final byte PRIMITIVE_ATTRIB_SUBIMAGE = 3;
    private static final byte PRIMITIVE_ATTRIB_WIDTH = 3;
    private static final byte PRIMITIVE_ATTRIB_HEIGHT = 4;
    private static final byte PRIMITIVE_ATTRIB_COLOUR_INDEX = 1;
    public static final short ANIMFLAG_XFLIPPED = 16384;
    public static final int NUM_BANKS = 1;
    private static byte[] s_colourData;
    private static short[][] s_subImages;
    private static int s_curBank;
    private static Image[][] s_animImageArray;
    private static short[][] s_frameDurations;
    private static short[][] s_frameOffsets;
    private static short[][] s_frameData;
    private static final int CEIL_ONE_F = 65535;

    private static final void ASSERT(boolean bl, String string) {
        AppEngine.ASSERT(bl, string);
    }

    private AnimationManager() {
    }

    public static final boolean loadColorsFile(ResourceManager resourceManager) {
        DataInputStream dataInputStream = new DataInputStream(resourceManager.loadBinaryFile(36));
        s_colourData = new byte[ResourceManager.getFileSize(36)];
        try {
            dataInputStream.read(s_colourData);
            dataInputStream.close();
        }
        catch (Throwable throwable) {
            System.out.println("exception reading colors data: " + throwable + " (" + throwable.getMessage() + ")");
            return false;
        }
        return true;
    }

    public static final void setColor(Graphics graphics, int n) {
        int n2 = n * 3;
        byte[] byArray = s_colourData;
        graphics.setColor(byArray[n2] & 0xFF, byArray[n2 + 1] & 0xFF, byArray[n2 + 2] & 0xFF);
    }

    public static final boolean loadSubimageFile(ResourceManager resourceManager) {
        try {
            short[][] sArray = new short[186][5];
            DataInputStream dataInputStream = new DataInputStream(resourceManager.loadBinaryFile(56));
            for (int i = 0; i < 186; ++i) {
                short[] sArray2 = sArray[i];
                sArray2[0] = (short)dataInputStream.readUnsignedByte();
                sArray2[1] = dataInputStream.readShort();
                sArray2[2] = dataInputStream.readShort();
                sArray2[3] = dataInputStream.readShort();
                sArray2[4] = dataInputStream.readShort();
            }
            s_subImages = sArray;
            dataInputStream.close();
        }
        catch (Throwable throwable) {
            System.out.println("exception reading sub images data: " + throwable + " (" + throwable.getMessage() + ")");
            return false;
        }
        return true;
    }

    private static final void DEBUG_LOADANIMS(String string) {
    }

    public static final boolean loadAnimFile(ResourceManager resourceManager) {
        AnimationManager.DEBUG_LOADANIMS("loadAnimFile");
        int n = 0;
        try {
            int n2;
            int n3;
            int n4;
            int n5;
            int n6;
            DataInputStream dataInputStream = new DataInputStream(resourceManager.loadBinaryFile(0));
            short[][] sArrayArray = new short[258][];
            short[][] sArrayArray2 = new short[258][];
            short[][] sArrayArray3 = new short[258][];
            for (n = 0; n != 258; ++n) {
                n6 = 0;
                int n7 = dataInputStream.readUnsignedByte();
                for (int i = 0; i < n7; ++i) {
                    dataInputStream.readShort();
                    int n8 = dataInputStream.readUnsignedByte();
                    for (n5 = 0; n5 < n8; ++n5) {
                        n4 = dataInputStream.readUnsignedByte();
                        n3 = AnimationManager.getPrimitiveBinaryDataCount(n4);
                        for (n2 = 0; n2 < n3; ++n2) {
                            dataInputStream.readByte();
                        }
                        n6 += AnimationManager.getPrimitiveDataCount(n4);
                    }
                }
                sArrayArray[n] = new short[n7];
                sArrayArray2[n] = new short[n7];
                sArrayArray3[n] = new short[n6];
            }
            s_frameDurations = sArrayArray;
            s_frameOffsets = sArrayArray2;
            s_frameData = sArrayArray3;
            dataInputStream.close();
            dataInputStream = new DataInputStream(resourceManager.loadBinaryFile(0));
            for (n = 0; n != 258; ++n) {
                n6 = 0;
                short[] sArray = sArrayArray3[n];
                short[] sArray2 = sArrayArray[n];
                short[] sArray3 = sArrayArray2[n];
                n5 = dataInputStream.readUnsignedByte();
                for (n4 = 0; n4 < n5; ++n4) {
                    sArray2[n4] = dataInputStream.readShort();
                    sArray3[n4] = (short)n6;
                    n3 = dataInputStream.readUnsignedByte();
                    for (n2 = 0; n2 < n3; ++n2) {
                        int n9 = dataInputStream.readUnsignedByte();
                        switch (n9) {
                            case 0: 
                            case 11: {
                                sArray[n6 + 3] = dataInputStream.readShort();
                                sArray[n6 + 1] = dataInputStream.readShort();
                                sArray[n6 + 2] = dataInputStream.readShort();
                                break;
                            }
                            case 1: 
                            case 2: 
                            case 3: 
                            case 4: 
                            case 5: 
                            case 6: 
                            case 8: 
                            case 12: {
                                sArray[n6 + 1] = dataInputStream.readShort();
                                sArray[n6 + 2] = dataInputStream.readShort();
                                sArray[n6 + 3] = dataInputStream.readShort();
                                sArray[n6 + 4] = dataInputStream.readShort();
                                break;
                            }
                            case 7: {
                                sArray[n6 + 1] = dataInputStream.readShort();
                                sArray[n6 + 2] = dataInputStream.readShort();
                                break;
                            }
                            case 10: {
                                sArray[n6 + 1] = (short)dataInputStream.readUnsignedByte();
                                break;
                            }
                        }
                        sArray[n6] = (short)n9;
                        n6 += AnimationManager.getPrimitiveDataCount(n9);
                    }
                }
            }
            dataInputStream.close();
        }
        catch (IOException iOException) {
            System.out.println("exception reading anim data: " + iOException + " (" + iOException.getMessage() + ")");
            System.out.println("animIndex: " + n);
            return false;
        }
        AnimationManager.DEBUG_LOADANIMS("finished, loadAnimFile");
        return true;
    }

    private static final int getPrimitiveBinaryDataCount(int n) {
        switch (n) {
            case 0: 
            case 11: {
                return 6;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 12: {
                return 8;
            }
            case 7: {
                return 4;
            }
            case 10: {
                return 1;
            }
        }
        return 0;
    }

    private static final int getPrimitiveDataCount(int n) {
        switch (n) {
            case 0: 
            case 11: {
                return 4;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 12: {
                return 5;
            }
            case 7: {
                return 3;
            }
            case 10: {
                return 2;
            }
        }
        return 0;
    }

    private static final int getFrameOffsetStart(int n, int n2) {
        return s_frameOffsets[n][n2];
    }

    private static final int getFrameOffsetEnd(int n, int n2) {
        short[] sArray = s_frameOffsets[n];
        if (n2 < sArray.length - 1) {
            return sArray[n2 + 1];
        }
        return s_frameData[n].length;
    }

    private static final void DEBUG_LOADIMAGE(String string) {
    }

    public static final boolean loadImage(ResourceManager resourceManager, int n) {
        int n2;
        for (n2 = 0; n2 < 34 && n != AnimConstants.IMAGE_RES_IDS[n2]; ++n2) {
        }
        AnimationManager.DEBUG_LOADIMAGE(ResourceManager.getFileName(n));
        if (34 == n2) {
            return false;
        }
        Image[] imageArray = s_animImageArray[0];
        if (imageArray[n2] == null) {
            Image image;
            imageArray[n2] = image = resourceManager.loadImage(n);
            if (image == null) {
                AnimationManager.DEBUG_LOADIMAGE("load fail");
                return false;
            }
        }
        if (imageArray[n2] == null) {
            AnimationManager.DEBUG_LOADIMAGE("load 'success', but image is null!");
        } else {
            AnimationManager.DEBUG_LOADIMAGE("load success");
        }
        return true;
    }

    private static final void DEBUG_UNLOADIMAGE(String string) {
    }

    public static final boolean unloadImage(int n, int n2) {
        int n3;
        AnimationManager.DEBUG_UNLOADIMAGE(ResourceManager.getFileName(n) + " resId=" + n);
        for (n3 = 0; n3 < 34 && n != AnimConstants.IMAGE_RES_IDS[n3]; ++n3) {
        }
        if (34 == n3) {
            AnimationManager.DEBUG_UNLOADIMAGE("unload aborted (resID not found)");
            return false;
        }
        if (s_animImageArray[n2][n3] == null) {
            return false;
        }
        AnimationManager.s_animImageArray[n2][n3] = null;
        return true;
    }

    public static final void drawAnimFrame(Graphics graphics, int n, int n2, int n3, int n4) {
        if (n < 0) {
            return;
        }
        if ((n & 0x4000) != 0) {
            AnimationManager.drawXFlippedAnimFrame(graphics, n &= 0xFFFFBFFF, n2, n3, n4);
        } else {
            AnimationManager.drawNormalAnimFrame(graphics, n, n2, n3, n4);
        }
    }

    private static final void drawNormalAnimFrame(Graphics graphics, int n, int n2, int n3, int n4) {
        short s;
        Image[] imageArray = s_animImageArray[s_curBank];
        short[][] sArray = s_subImages;
        short[] sArray2 = s_frameData[n];
        int n5 = AnimationManager.getFrameOffsetEnd(n, n2);
        for (int i = AnimationManager.getFrameOffsetStart(n, n2); i < n5; i += AnimationManager.getPrimitiveDataCount(s)) {
            s = sArray2[i + 0];
            if (s == 0 || s == 11) {
                short[] sArray3 = sArray[sArray2[i + 3]];
                int n6 = sArray3[0] & 0xFFFF;
                Image image = imageArray[n6];
                if (image == null) continue;
                int n7 = n3 + sArray2[i + 1];
                int n8 = n4 + sArray2[i + 2];
                int n9 = s == 0 ? 0 : 2;
                graphics.drawRegion(image, (int)sArray3[1], (int)sArray3[2], (int)sArray3[3], (int)sArray3[4], n9, n7, n8, 20);
                continue;
            }
            if (s == 2 || s == 7) continue;
            AnimationManager.drawPrimitive(graphics, n3, n4, sArray2, i);
        }
    }

    private static final void drawXFlippedAnimFrame(Graphics graphics, int n, int n2, int n3, int n4) {
        short s;
        Image[] imageArray = s_animImageArray[s_curBank];
        short[][] sArray = s_subImages;
        short[] sArray2 = s_frameData[n];
        int n5 = AnimationManager.getFrameOffsetEnd(n, n2);
        for (int i = AnimationManager.getFrameOffsetStart(n, n2); i < n5; i += AnimationManager.getPrimitiveDataCount(s)) {
            s = sArray2[i + 0];
            if (s == 0 || s == 11) {
                short[] sArray3 = sArray[sArray2[i + 3]];
                int n6 = sArray3[0] & 0xFFFF;
                Image image = imageArray[n6];
                if (image == null) continue;
                int n7 = n3 - sArray2[i + 1] - sArray3[3];
                int n8 = n4 + sArray2[i + 2];
                int n9 = s == 0 ? 2 : 0;
                graphics.drawRegion(image, (int)sArray3[1], (int)sArray3[2], (int)sArray3[3], (int)sArray3[4], n9, n7, n8, 20);
                continue;
            }
            if (s == 2 || s == 7) continue;
            AnimationManager.drawXFlippedPrimitive(graphics, n3, n4, sArray2, i);
        }
    }

    public static final boolean drawAnimFrameExt(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, int[] nArray) {
        if (n < 0) {
            return false;
        }
        if ((n & 0x4000) != 0) {
            return AnimationManager.drawXFlippedAnimFrameExt(graphics, n &= 0xFFFFBFFF, n2, n3, n4, n5, n6, nArray);
        }
        return AnimationManager.drawNormalAnimFrameExt(graphics, n, n2, n3, n4, n5, n6, nArray);
    }

    private static final boolean drawNormalAnimFrameExt(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, int[] nArray) {
        short s;
        short[] sArray;
        Image[] imageArray = s_animImageArray[s_curBank];
        short[][] sArray2 = s_subImages;
        boolean bl = false;
        short[] sArray3 = s_frameData[n];
        int n7 = AnimationManager.getFrameOffsetEnd(n, n2);
        short[] sArray4 = sArray = n5 >= 0 ? s_frameData[n5] : null;
        block0: for (int i = AnimationManager.getFrameOffsetStart(n, n2); i < n7; i += AnimationManager.getPrimitiveDataCount(s)) {
            s = sArray3[i + 0];
            if (s == 0 || s == 11) {
                int n8;
                short s2 = sArray3[i + 3];
                short[] sArray5 = sArray2[s2];
                int n9 = n3 + sArray3[i + 1];
                int n10 = n4 + sArray3[i + 2];
                int n11 = sArray5[0] & 0xFFFF;
                Image image = imageArray[n11];
                if (image != null) {
                    n8 = s == 0 ? 0 : 2;
                    graphics.drawRegion(image, (int)sArray5[1], (int)sArray5[2], (int)sArray5[3], (int)sArray5[4], n8, n9, n10, 20);
                }
                if (sArray == null) continue;
                n8 = AnimationManager.getAnimFrameCount(n5);
                for (int j = 0; j < n8; ++j) {
                    int n12;
                    int n13;
                    int n14 = AnimationManager.getFrameOffsetStart(n5, j);
                    AnimationManager.ASSERT(sArray[n14 + 0] == 0, "non-sprite in extras anim");
                    int n15 = sArray[n14 + 3] & 0xFFFF;
                    if (s2 != n15) continue;
                    int n16 = AnimationManager.getFrameOffsetEnd(n5, j);
                    short s3 = sArray[n14 + 1];
                    short s4 = sArray[n14 + 2];
                    int n17 = 0;
                    do {
                        if ((n14 += AnimationManager.getPrimitiveDataCount(sArray[n14 + 0])) >= n16 || sArray[n14 + 0] != 0) continue;
                        ++n17;
                    } while (n17 < n6 && n14 < n16);
                    if (nArray != null) {
                        bl = true;
                        n13 = n16 - AnimationManager.getPrimitiveDataCount(7);
                        AnimationManager.ASSERT(sArray[n13 + 0] == 7, "non-firepoint at end of lookup anim frame");
                        nArray[0] = n9 + sArray[n13 + 1] - s3;
                        nArray[1] = n10 + sArray[n13 + 2] - s4;
                    }
                    if (n14 >= n16) continue block0;
                    n13 = sArray[n14 + 1] - s3;
                    int n18 = sArray[n14 + 2] - s4;
                    short[] sArray6 = sArray2[sArray[n14 + 3]];
                    int n19 = sArray6[0] & 0xFFFF;
                    Image image2 = imageArray[n19];
                    if (image == null) continue block0;
                    if (s == 11) {
                        n12 = 2;
                        short s5 = sArray6[3];
                        short s6 = sArray5[3];
                        n13 = -n13 - (s5 - s6);
                    } else {
                        n12 = 0;
                    }
                    graphics.drawRegion(image2, (int)sArray6[1], (int)sArray6[2], (int)sArray6[3], (int)sArray6[4], n12, n13 += n9, n18 += n10, 20);
                    continue block0;
                }
                continue;
            }
            AnimationManager.drawPrimitive(graphics, n3, n4, sArray3, i);
        }
        return bl;
    }

    private static final boolean drawXFlippedAnimFrameExt(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, int[] nArray) {
        short s;
        short[] sArray;
        Image[] imageArray = s_animImageArray[s_curBank];
        short[][] sArray2 = s_subImages;
        boolean bl = false;
        short[] sArray3 = s_frameData[n];
        int n7 = AnimationManager.getFrameOffsetEnd(n, n2);
        short[] sArray4 = sArray = n5 >= 0 ? s_frameData[n5] : null;
        block0: for (int i = AnimationManager.getFrameOffsetStart(n, n2); i < n7; i += AnimationManager.getPrimitiveDataCount(s)) {
            s = sArray3[i + 0];
            if (s == 0 || s == 11) {
                int n8;
                short s2 = sArray3[i + 3];
                short[] sArray5 = sArray2[s2];
                int n9 = n3 - sArray3[i + 1] - sArray5[3];
                int n10 = n4 + sArray3[i + 2];
                int n11 = sArray5[0] & 0xFFFF;
                Image image = imageArray[n11];
                if (image != null) {
                    n8 = s == 0 ? 2 : 0;
                    graphics.drawRegion(image, (int)sArray5[1], (int)sArray5[2], (int)sArray5[3], (int)sArray5[4], n8, n9, n10, 20);
                }
                if (sArray == null) continue;
                n8 = AnimationManager.getAnimFrameCount(n5);
                for (int j = 0; j < n8; ++j) {
                    int n12;
                    int n13;
                    int n14 = AnimationManager.getFrameOffsetStart(n5, j);
                    AnimationManager.ASSERT(sArray[n14 + 0] == 0, "non-sprite in extras anim");
                    int n15 = sArray[n14 + 3] & 0xFFFF;
                    if (s2 != n15) continue;
                    int n16 = AnimationManager.getFrameOffsetEnd(n5, j);
                    short s3 = sArray[n14 + 1];
                    short s4 = sArray[n14 + 2];
                    int n17 = 0;
                    do {
                        if ((n14 += AnimationManager.getPrimitiveDataCount(sArray[n14 + 0])) >= n16 || sArray[n14 + 0] != 0) continue;
                        ++n17;
                    } while (n17 < n6 && n14 < n16);
                    if (nArray != null) {
                        bl = true;
                        n13 = n16 - AnimationManager.getPrimitiveDataCount(7);
                        AnimationManager.ASSERT(sArray[n13 + 0] == 7, "non-firepoint at end of lookup anim frame");
                        nArray[0] = n9 + sArray[n13 + 1] - s3;
                        nArray[1] = n10 + sArray[n13 + 2] - s4;
                    }
                    if (n14 >= n16) continue block0;
                    n13 = sArray[n14 + 1] - s3;
                    int n18 = sArray[n14 + 2] - s4;
                    short[] sArray6 = sArray2[sArray[n14 + 3]];
                    int n19 = sArray6[0] & 0xFFFF;
                    Image image2 = imageArray[n19];
                    if (image == null) continue block0;
                    if (s == 11) {
                        n12 = 0;
                    } else {
                        n12 = 2;
                        short s5 = sArray6[3];
                        short s6 = sArray5[3];
                        n13 = -n13 - (s5 - s6);
                    }
                    graphics.drawRegion(image2, (int)sArray6[1], (int)sArray6[2], (int)sArray6[3], (int)sArray6[4], n12, n13 += n9, n18 += n10, 20);
                    continue block0;
                }
                continue;
            }
            AnimationManager.drawXFlippedPrimitive(graphics, n3, n4, sArray3, i);
        }
        return bl;
    }

    private static final void drawPrimitive(Graphics graphics, int n, int n2, short[] sArray, int n3) {
        short s = sArray[n3 + 0];
        switch (s) {
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                int n4 = n + sArray[n3 + 1];
                int n5 = n2 + sArray[n3 + 2];
                short s2 = sArray[n3 + 3];
                short s3 = sArray[n3 + 4];
                switch (s) {
                    case 3: {
                        graphics.drawRect(n4, n5, s2 - 1, s3 - 1);
                        break;
                    }
                    case 4: {
                        graphics.fillRect(n4, n5, (int)s2, (int)s3);
                        break;
                    }
                    case 5: {
                        graphics.drawArc(n4, n5, s2 - 1, s3 - 1, 0, 360);
                        break;
                    }
                    case 6: {
                        graphics.fillArc(n4, n5, (int)s2, (int)s3, 0, 360);
                    }
                }
                break;
            }
            case 8: {
                int n6 = n + sArray[n3 + 1];
                int n7 = n2 + sArray[n3 + 2];
                int n8 = n + sArray[n3 + 3];
                int n9 = n2 + sArray[n3 + 4];
                graphics.drawLine(n6, n7, n8, n9);
                break;
            }
            case 10: {
                AnimationManager.setColor(graphics, sArray[n3 + 1]);
                break;
            }
        }
    }

    private static final void drawXFlippedPrimitive(Graphics graphics, int n, int n2, short[] sArray, int n3) {
        short s = sArray[n3 + 0];
        switch (s) {
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                short s2 = sArray[n3 + 3];
                short s3 = sArray[n3 + 4];
                int n4 = n - (sArray[n3 + 1] + s2);
                int n5 = n2 + sArray[n3 + 2];
                switch (s) {
                    case 3: {
                        graphics.drawRect(n4, n5, s2 - 1, s3 - 1);
                        break;
                    }
                    case 4: {
                        graphics.fillRect(n4, n5, (int)s2, (int)s3);
                        break;
                    }
                    case 5: {
                        graphics.drawArc(n4, n5, s2 - 1, s3 - 1, 0, 360);
                        break;
                    }
                    case 6: {
                        graphics.fillArc(n4, n5, (int)s2, (int)s3, 0, 360);
                    }
                }
                break;
            }
            case 8: {
                int n6 = n - sArray[n3 + 1];
                int n7 = n2 + sArray[n3 + 2];
                int n8 = n - sArray[n3 + 3];
                int n9 = n2 + sArray[n3 + 4];
                graphics.drawLine(n6, n7, n8, n9);
                break;
            }
            case 10: {
                AnimationManager.setColor(graphics, sArray[n3 + 1]);
                break;
            }
        }
    }

    public static final int getAnimFrameCount(int n) {
        return s_frameDurations[n &= 0xFFFFBFFF].length;
    }

    public static final short getAnimFrameDuration(int n, int n2) {
        return s_frameDurations[n &= 0xFFFFBFFF][n2];
    }

    private static final int getPrimitiveX(short[] sArray, int n) {
        switch (sArray[n + 0]) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 12: {
                return sArray[n + 1];
            }
            case 8: {
                short s = sArray[n + 1];
                short s2 = sArray[n + 3];
                return s < s2 ? s : s2;
            }
        }
        return 0;
    }

    private static final int getPrimitiveY(short[] sArray, int n) {
        switch (sArray[n + 0]) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 12: {
                return sArray[n + 2];
            }
            case 8: {
                short s = sArray[n + 2];
                short s2 = sArray[n + 4];
                return s < s2 ? s : s2;
            }
        }
        return 0;
    }

    private static final int getPrimitiveWidth(short[] sArray, int n) {
        switch (sArray[n + 0]) {
            case 0: 
            case 11: {
                int n2 = sArray[n + 3];
                return s_subImages[n2 &= 0xFFFF][3];
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                return sArray[n + 3];
            }
            case 8: {
                int n3 = sArray[n + 1] - sArray[n + 3];
                return Math.abs(n3);
            }
            case 12: {
                int n4 = sArray[n + 3] - sArray[n + 1];
                return n4;
            }
            case 9: {
                return 0;
            }
        }
        return 0;
    }

    private static final int getPrimitiveHeight(short[] sArray, int n) {
        switch (sArray[n + 0]) {
            case 0: 
            case 11: {
                int n2 = sArray[n + 3];
                return s_subImages[n2 &= 0xFFFF][4];
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                return sArray[n + 4];
            }
            case 8: {
                int n3 = sArray[n + 2] - sArray[n + 4];
                return Math.abs(n3);
            }
            case 12: {
                int n4 = sArray[n + 4] - sArray[n + 2];
                return n4;
            }
            case 9: {
                return 0;
            }
        }
        return 0;
    }

    public static final int getAnimFrameX(int n, int n2) {
        int n3;
        int n4 = Integer.MAX_VALUE;
        short[] sArray = s_frameData[n &= 0xFFFFBFFF];
        int n5 = AnimationManager.getFrameOffsetStart(n, n2);
        if (n5 == (n3 = AnimationManager.getFrameOffsetEnd(n, n2))) {
            return 0;
        }
        while (n5 < n3) {
            int n6;
            short s = sArray[n5 + 0];
            if (s != 10 && (n6 = AnimationManager.getPrimitiveX(sArray, n5)) < n4) {
                n4 = n6;
            }
            n5 += AnimationManager.getPrimitiveDataCount(s);
        }
        return n4;
    }

    public static final int getAnimFrameY(int n, int n2) {
        int n3;
        int n4 = Integer.MAX_VALUE;
        short[] sArray = s_frameData[n &= 0xFFFFBFFF];
        int n5 = AnimationManager.getFrameOffsetStart(n, n2);
        if (n5 == (n3 = AnimationManager.getFrameOffsetEnd(n, n2))) {
            return 0;
        }
        while (n5 < n3) {
            int n6;
            short s = sArray[n5 + 0];
            if (s != 10 && (n6 = AnimationManager.getPrimitiveY(sArray, n5)) < n4) {
                n4 = n6;
            }
            n5 += AnimationManager.getPrimitiveDataCount(s);
        }
        return n4;
    }

    public static final int getAnimFrameWidth(int n, int n2) {
        int n3;
        int n4 = Integer.MAX_VALUE;
        int n5 = Integer.MIN_VALUE;
        short[] sArray = s_frameData[n &= 0xFFFFBFFF];
        int n6 = AnimationManager.getFrameOffsetStart(n, n2);
        if (n6 == (n3 = AnimationManager.getFrameOffsetEnd(n, n2))) {
            return 0;
        }
        while (n6 < n3) {
            short s = sArray[n6 + 0];
            if (s != 10) {
                int n7 = AnimationManager.getPrimitiveX(sArray, n6);
                int n8 = n7 + AnimationManager.getPrimitiveWidth(sArray, n6);
                if (n7 < n4) {
                    n4 = n7;
                }
                if (n8 > n5) {
                    n5 = n8;
                }
            }
            n6 += AnimationManager.getPrimitiveDataCount(s);
        }
        return n5 - n4;
    }

    public static final int getAnimFrameHeight(int n, int n2) {
        int n3;
        int n4 = Integer.MAX_VALUE;
        int n5 = Integer.MIN_VALUE;
        short[] sArray = s_frameData[n &= 0xFFFFBFFF];
        int n6 = AnimationManager.getFrameOffsetStart(n, n2);
        if (n6 == (n3 = AnimationManager.getFrameOffsetEnd(n, n2))) {
            return 0;
        }
        while (n6 < n3) {
            short s = sArray[n6 + 0];
            if (s != 10) {
                int n7 = AnimationManager.getPrimitiveY(sArray, n6);
                int n8 = n7 + AnimationManager.getPrimitiveHeight(sArray, n6);
                if (n7 < n4) {
                    n4 = n7;
                }
                if (n8 > n5) {
                    n5 = n8;
                }
            }
            n6 += AnimationManager.getPrimitiveDataCount(s);
        }
        return n5 - n4;
    }

    public static final int getAnimFrameFirePointCount(int n, int n2) {
        short s;
        int n3 = 0;
        short[] sArray = s_frameData[n &= 0xFFFFBFFF];
        int n4 = AnimationManager.getFrameOffsetEnd(n, n2);
        for (int i = AnimationManager.getFrameOffsetStart(n, n2); i < n4; i += AnimationManager.getPrimitiveDataCount(s)) {
            s = sArray[i + 0];
            if (s != 7) continue;
            ++n3;
        }
        return n3;
    }

    public static final boolean getAnimFrameFirePoint(int[] nArray, int n, int n2, int n3) {
        short s;
        boolean bl = false;
        if ((n & 0x4000) != 0) {
            n &= 0xFFFFBFFF;
            bl = true;
        }
        int n4 = 0;
        short[] sArray = s_frameData[n];
        int n5 = AnimationManager.getFrameOffsetEnd(n, n2);
        for (int i = AnimationManager.getFrameOffsetStart(n, n2); i < n5; i += AnimationManager.getPrimitiveDataCount(s)) {
            s = sArray[i + 0];
            if (s != 7) continue;
            if (n4 == n3) {
                nArray[0] = sArray[i + 1];
                nArray[1] = sArray[i + 2];
                if (bl) {
                    nArray[0] = -nArray[0];
                }
                return true;
            }
            ++n4;
        }
        nArray[0] = 0;
        nArray[1] = 0;
        return false;
    }

    public static final Image getAnimFrameImage(int n, int n2, int n3) {
        short s;
        short[] sArray = s_frameData[n &= 0xFFFFBFFF];
        int n4 = AnimationManager.getFrameOffsetEnd(n, n2);
        for (int i = AnimationManager.getFrameOffsetStart(n, n2); i < n4; i += AnimationManager.getPrimitiveDataCount(s)) {
            s = sArray[i + 0];
            if (s != 0 && s != 11) continue;
            if (n3 == 0) {
                short s2 = sArray[i + 3];
                short s3 = s_subImages[s2][0];
                return s_animImageArray[s_curBank][s3];
            }
            --n3;
        }
        return null;
    }

    public static final boolean getAnimFrameCollisionBox(int[] nArray, int n, int n2, int n3) {
        short s;
        boolean bl = false;
        if ((n & 0x4000) != 0) {
            n &= 0xFFFFBFFF;
            bl = true;
        }
        int n4 = 0;
        short[] sArray = s_frameData[n];
        int n5 = AnimationManager.getFrameOffsetEnd(n, n2);
        for (int i = AnimationManager.getFrameOffsetStart(n, n2); i < n5; i += AnimationManager.getPrimitiveDataCount(s)) {
            s = sArray[i + 0];
            if (s != 2) continue;
            if (n4 == n3) {
                nArray[0] = sArray[i + 1];
                nArray[1] = sArray[i + 2];
                nArray[2] = sArray[i + 3];
                nArray[3] = sArray[i + 4];
                if (bl) {
                    // empty if block
                }
                return true;
            }
            ++n4;
        }
        nArray[0] = 0;
        nArray[1] = 0;
        nArray[2] = 0;
        nArray[3] = 0;
        return false;
    }

    public static final Image getImage(int n) {
        if (n < 0 || n >= 34) {
            return null;
        }
        return s_animImageArray[s_curBank][n];
    }

    public static final void drawAnim(Graphics graphics, AnimPlayer animPlayer, int n, int n2) {
        AnimationManager.drawAnimFrame(graphics, animPlayer.getAnimID(), animPlayer.getCurrAnimFrame(), n, n2);
    }

    public static final void setBank(int n) {
        AnimationManager.ASSERT(n >= 0 && n < 1, "invalid bank");
        s_curBank = n;
    }

    public static final void drawScaledPrimitives(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        short s;
        if (n < 0) {
            return;
        }
        int n7 = graphics.getClipX();
        int n8 = graphics.getClipY();
        int n9 = graphics.getClipWidth();
        int n10 = graphics.getClipHeight();
        short[] sArray = s_frameData[n];
        int n11 = AnimationManager.getFrameOffsetEnd(n, n2);
        block8: for (int i = AnimationManager.getFrameOffsetStart(n, n2); i < n11; i += AnimationManager.getPrimitiveDataCount(s)) {
            s = sArray[i + 0];
            if (s == 0 || s == 11) continue;
            if (s == 10) {
                AnimationManager.setColor(graphics, sArray[i + 1]);
                continue;
            }
            if (s == 2 || s == 7) continue;
            int n12 = MathExt.mulF(AnimationManager.getPrimitiveX(sArray, i) << 16, n5) + 65535 >> 16;
            int n13 = MathExt.mulF(AnimationManager.getPrimitiveY(sArray, i) << 16, n6) + 65535 >> 16;
            int n14 = MathExt.mulF(AnimationManager.getPrimitiveWidth(sArray, i) << 16, n5) + 65535 >> 16;
            int n15 = MathExt.mulF(AnimationManager.getPrimitiveHeight(sArray, i) << 16, n6) + 65535 >> 16;
            if (bl) {
                if (s == 8 || s == 12) {
                    n12 = -n12;
                    n14 = -n14;
                } else {
                    n12 = -n12 - n14;
                }
            }
            switch (s) {
                case 4: {
                    graphics.fillRect(n3 + n12, n4 + n13, n14, n15);
                    continue block8;
                }
                case 8: {
                    graphics.drawLine(n3 + n12, n4 + n13, n3 + n12 + n14, n4 + n13 + n15);
                    continue block8;
                }
                case 12: {
                    boolean bl2;
                    int n16 = n3 + n12;
                    int n17 = n3 + n12 + n14;
                    int n18 = n4 + n13;
                    int n19 = n4 + n13 + n15;
                    boolean bl3 = bl2 = n14 > 0 && n15 > 0 || n14 < 0 && n15 < 0;
                    if (bl) {
                        boolean bl4 = bl2 = !bl2;
                    }
                    if (bl2) {
                        graphics.fillTriangle(n16, n18, n17, n19, n16, n19);
                        continue block8;
                    }
                    graphics.fillTriangle(n16, n18, n17, n19, n17, n18);
                    continue block8;
                }
                case 3: {
                    graphics.drawRect(n3 + n12, n4 + n13, n14, n15);
                    continue block8;
                }
                case 6: {
                    graphics.fillArc(n3 + n12, n4 + n13, n14, n15, 0, 360);
                    continue block8;
                }
                case 5: {
                    graphics.drawArc(n3 + n12, n4 + n13, n14, n15, 0, 360);
                    continue block8;
                }
            }
        }
        graphics.setClip(n7, n8, n9, n10);
    }

    static {
        s_animImageArray = new Image[1][34];
    }
}

