/*
 * Decompiled with CFR 0.152.
 */
package generic.generic2d;

import generic.MathExt;

public final class Transform {
    private static final int[] g_identity = new int[]{65536, 0, 0, 0, 0, 65536, 0, 0, 0, 0, 65536, 0, 0, 0, 0, 65536};
    private static final int[] g_temp_vec4_0 = new int[4];
    private static final int[] g_temp_vec4_1 = new int[4];
    private static final Transform g_temp_trans = new Transform();
    private final int[] m_matrix = new int[16];

    public Transform() {
        this.setIdentity();
    }

    public Transform(Transform transform) {
        this.set(transform);
    }

    public void setIdentity() {
        System.arraycopy(g_identity, 0, this.m_matrix, 0, 16);
    }

    public void set(Transform transform) {
        System.arraycopy(transform.m_matrix, 0, this.m_matrix, 0, 16);
    }

    public void setx(int[] nArray) {
        System.arraycopy(nArray, 0, this.m_matrix, 0, 16);
    }

    protected void getx(int[] nArray) {
        System.arraycopy(this.m_matrix, 0, nArray, 0, 16);
    }

    public void postTranslatex(int n, int n2, int n3) {
        int[] nArray = g_temp_vec4_0;
        nArray[0] = n;
        nArray[1] = n2;
        nArray[2] = n3;
        int[] nArray2 = g_temp_vec4_1;
        int[] nArray3 = this.m_matrix;
        System.arraycopy(nArray3, 0, nArray2, 0, 3);
        nArray3[3] = nArray3[3] + MathExt.dot3F(nArray2, nArray);
        System.arraycopy(nArray3, 4, nArray2, 0, 3);
        nArray3[7] = nArray3[7] + MathExt.dot3F(nArray2, nArray);
        System.arraycopy(nArray3, 8, nArray2, 0, 3);
        nArray3[11] = nArray3[11] + MathExt.dot3F(nArray2, nArray);
        System.arraycopy(nArray3, 12, nArray2, 0, 3);
        nArray3[15] = nArray3[15] + MathExt.dot3F(nArray2, nArray);
    }

    public void postScalex(int n, int n2, int n3) {
        int[] nArray = this.m_matrix;
        nArray[0] = MathExt.mulF(nArray[0], n);
        nArray[1] = MathExt.mulF(nArray[1], n2);
        nArray[2] = MathExt.mulF(nArray[2], n3);
        nArray[4] = MathExt.mulF(nArray[4], n);
        nArray[5] = MathExt.mulF(nArray[5], n2);
        nArray[6] = MathExt.mulF(nArray[6], n3);
        nArray[8] = MathExt.mulF(nArray[8], n);
        nArray[9] = MathExt.mulF(nArray[9], n2);
        nArray[10] = MathExt.mulF(nArray[10], n3);
        nArray[12] = MathExt.mulF(nArray[12], n);
        nArray[13] = MathExt.mulF(nArray[13], n2);
        nArray[14] = MathExt.mulF(nArray[14], n3);
    }

    public void postRotatex(int n, int n2, int n3, int n4) {
        if (n == 0) {
            return;
        }
        int n5 = MathExt.degreesToRadiansF(n);
        int n6 = MathExt.sinF(n5 >> 1);
        int n7 = MathExt.cosF(n5 >> 1);
        this.postRotateQuatx(MathExt.mulF(n6, n2), MathExt.mulF(n6, n3), MathExt.mulF(n6, n4), n7);
    }

    public void postRotateQuatx(int n, int n2, int n3, int n4) {
        int[] nArray = g_temp_vec4_0;
        nArray[0] = n;
        nArray[1] = n2;
        nArray[2] = n3;
        nArray[3] = n4;
        Transform transform = g_temp_trans;
        transform.setIdentity();
        int n5 = MathExt.sqrtF(MathExt.mag4SqrF(nArray));
        int n6 = MathExt.divF(65536, n5);
        nArray[0] = MathExt.mulF(n, n6);
        nArray[1] = MathExt.mulF(n2, n6);
        nArray[2] = MathExt.mulF(n3, n6);
        nArray[3] = MathExt.mulF(n4, n6);
        int n7 = MathExt.mulLSL1F(nArray[0], nArray[0]);
        int n8 = MathExt.mulLSL1F(nArray[0], nArray[1]);
        int n9 = MathExt.mulLSL1F(nArray[0], nArray[2]);
        int n10 = MathExt.mulLSL1F(nArray[0], nArray[3]);
        int n11 = MathExt.mulLSL1F(nArray[1], nArray[1]);
        int n12 = MathExt.mulLSL1F(nArray[1], nArray[2]);
        int n13 = MathExt.mulLSL1F(nArray[1], nArray[3]);
        int n14 = MathExt.mulLSL1F(nArray[2], nArray[2]);
        int n15 = MathExt.mulLSL1F(nArray[2], nArray[3]);
        int[] nArray2 = transform.m_matrix;
        nArray2[0] = 65536 - (n11 + n14);
        nArray2[1] = n8 - n15;
        nArray2[2] = n9 + n13;
        nArray2[4] = n8 + n15;
        nArray2[5] = 65536 - (n7 + n14);
        nArray2[6] = n12 - n10;
        nArray2[8] = n9 - n13;
        nArray2[9] = n12 + n10;
        nArray2[10] = 65536 - (n7 + n11);
        this.postMultiply_34(transform);
    }

    private static final void __transformx4(int[] nArray, int[] nArray2) {
        long l = nArray2[0];
        long l2 = nArray2[1];
        long l3 = nArray2[2];
        long l4 = nArray2[3];
        long l5 = nArray[0];
        long l6 = nArray[1];
        long l7 = nArray[2];
        long l8 = nArray[3];
        nArray2[0] = (int)(l5 * l + l6 * l2 + l7 * l3 + l8 * l4 >> 16);
        l5 = nArray[4];
        l6 = nArray[5];
        l7 = nArray[6];
        l8 = nArray[7];
        nArray2[1] = (int)(l5 * l + l6 * l2 + l7 * l3 + l8 * l4 >> 16);
        l5 = nArray[8];
        l6 = nArray[9];
        l7 = nArray[10];
        l8 = nArray[11];
        nArray2[2] = (int)(l5 * l + l6 * l2 + l7 * l3 + l8 * l4 >> 16);
        l5 = nArray[12];
        l6 = nArray[13];
        l7 = nArray[14];
        l8 = nArray[15];
        nArray2[3] = (int)(l5 * l + l6 * l2 + l7 * l3 + l8 * l4 >> 16);
    }

    private static final void __transformxNormal(int[] nArray, int[] nArray2) {
        long l = nArray2[0];
        long l2 = nArray2[1];
        long l3 = nArray2[2];
        long l4 = nArray[0];
        long l5 = nArray[1];
        long l6 = nArray[2];
        long l7 = nArray[3];
        nArray2[0] = (int)(l4 * l + l5 * l2 + l6 * l3 + l7 * 0L >> 16);
        l4 = nArray[4];
        l5 = nArray[5];
        l6 = nArray[6];
        l7 = nArray[7];
        nArray2[1] = (int)(l4 * l + l5 * l2 + l6 * l3 + l7 * 0L >> 16);
        l4 = nArray[8];
        l5 = nArray[9];
        l6 = nArray[10];
        l7 = nArray[11];
        nArray2[2] = (int)(l4 * l + l5 * l2 + l6 * l3 + l7 * 0L >> 16);
        l4 = nArray[12];
        l5 = nArray[13];
        l6 = nArray[14];
        l7 = nArray[15];
        nArray2[3] = (int)(l4 * l + l5 * l2 + l6 * l3 + l7 * 0L >> 16);
    }

    private static final void __transformxPosition(int[] nArray, int[] nArray2) {
        long l = nArray2[0];
        long l2 = nArray2[1];
        long l3 = nArray2[2];
        long l4 = nArray[0];
        long l5 = nArray[1];
        long l6 = nArray[2];
        long l7 = nArray[3];
        nArray2[0] = (int)(l4 * l + l5 * l2 + l6 * l3 + l7 * 65536L >> 16);
        l4 = nArray[4];
        l5 = nArray[5];
        l6 = nArray[6];
        l7 = nArray[7];
        nArray2[1] = (int)(l4 * l + l5 * l2 + l6 * l3 + l7 * 65536L >> 16);
        l4 = nArray[8];
        l5 = nArray[9];
        l6 = nArray[10];
        l7 = nArray[11];
        nArray2[2] = (int)(l4 * l + l5 * l2 + l6 * l3 + l7 * 65536L >> 16);
        l4 = nArray[12];
        l5 = nArray[13];
        l6 = nArray[14];
        l7 = nArray[15];
        nArray2[3] = (int)(l4 * l + l5 * l2 + l6 * l3 + l7 * 65536L >> 16);
    }

    public void transformx(int[] nArray) {
        int[] nArray2 = this.m_matrix;
        int n = nArray[3];
        if (n == 0) {
            Transform.__transformxNormal(nArray2, nArray);
        } else if (n == 65536) {
            Transform.__transformxPosition(nArray2, nArray);
        } else {
            Transform.__transformx4(nArray2, nArray);
        }
    }

    public void postMultiply(Transform transform) {
        int[] nArray = transform.m_matrix;
        long l = nArray[0];
        long l2 = nArray[1];
        long l3 = nArray[2];
        long l4 = nArray[3];
        long l5 = nArray[4];
        long l6 = nArray[5];
        long l7 = nArray[6];
        long l8 = nArray[7];
        long l9 = nArray[8];
        long l10 = nArray[9];
        long l11 = nArray[10];
        long l12 = nArray[11];
        long l13 = nArray[12];
        long l14 = nArray[13];
        long l15 = nArray[14];
        long l16 = nArray[15];
        int[] nArray2 = this.m_matrix;
        long l17 = nArray2[0];
        long l18 = nArray2[1];
        long l19 = nArray2[2];
        long l20 = nArray2[3];
        nArray2[0] = (int)(l17 * l + l18 * l5 + l19 * l9 + l20 * l13 >> 16);
        nArray2[1] = (int)(l17 * l2 + l18 * l6 + l19 * l10 + l20 * l14 >> 16);
        nArray2[2] = (int)(l17 * l3 + l18 * l7 + l19 * l11 + l20 * l15 >> 16);
        nArray2[3] = (int)(l17 * l4 + l18 * l8 + l19 * l12 + l20 * l16 >> 16);
        l17 = nArray2[4];
        l18 = nArray2[5];
        l19 = nArray2[6];
        l20 = nArray2[7];
        nArray2[4] = (int)(l17 * l + l18 * l5 + l19 * l9 + l20 * l13 >> 16);
        nArray2[5] = (int)(l17 * l2 + l18 * l6 + l19 * l10 + l20 * l14 >> 16);
        nArray2[6] = (int)(l17 * l3 + l18 * l7 + l19 * l11 + l20 * l15 >> 16);
        nArray2[7] = (int)(l17 * l4 + l18 * l8 + l19 * l12 + l20 * l16 >> 16);
        l17 = nArray2[8];
        l18 = nArray2[9];
        l19 = nArray2[10];
        l20 = nArray2[11];
        nArray2[8] = (int)(l17 * l + l18 * l5 + l19 * l9 + l20 * l13 >> 16);
        nArray2[9] = (int)(l17 * l2 + l18 * l6 + l19 * l10 + l20 * l14 >> 16);
        nArray2[10] = (int)(l17 * l3 + l18 * l7 + l19 * l11 + l20 * l15 >> 16);
        nArray2[11] = (int)(l17 * l4 + l18 * l8 + l19 * l12 + l20 * l16 >> 16);
        l17 = nArray2[12];
        l18 = nArray2[13];
        l19 = nArray2[14];
        l20 = nArray2[15];
        nArray2[12] = (int)(l17 * l + l18 * l5 + l19 * l9 + l20 * l13 >> 16);
        nArray2[13] = (int)(l17 * l2 + l18 * l6 + l19 * l10 + l20 * l14 >> 16);
        nArray2[14] = (int)(l17 * l3 + l18 * l7 + l19 * l11 + l20 * l15 >> 16);
        nArray2[15] = (int)(l17 * l4 + l18 * l8 + l19 * l12 + l20 * l16 >> 16);
    }

    public void postMultiply_34(Transform transform) {
        int[] nArray = transform.m_matrix;
        long l = nArray[0];
        long l2 = nArray[1];
        long l3 = nArray[2];
        long l4 = nArray[3];
        long l5 = nArray[4];
        long l6 = nArray[5];
        long l7 = nArray[6];
        long l8 = nArray[7];
        long l9 = nArray[8];
        long l10 = nArray[9];
        long l11 = nArray[10];
        long l12 = nArray[11];
        int[] nArray2 = this.m_matrix;
        long l13 = nArray2[0];
        long l14 = nArray2[1];
        long l15 = nArray2[2];
        long l16 = nArray2[3];
        nArray2[0] = (int)(l13 * l + l14 * l5 + l15 * l9 >> 16);
        nArray2[1] = (int)(l13 * l2 + l14 * l6 + l15 * l10 >> 16);
        nArray2[2] = (int)(l13 * l3 + l14 * l7 + l15 * l11 >> 16);
        nArray2[3] = (int)(l13 * l4 + l14 * l8 + l15 * l12 + l16 * 65536L >> 16);
        l13 = nArray2[4];
        l14 = nArray2[5];
        l15 = nArray2[6];
        l16 = nArray2[7];
        nArray2[4] = (int)(l13 * l + l14 * l5 + l15 * l9 >> 16);
        nArray2[5] = (int)(l13 * l2 + l14 * l6 + l15 * l10 >> 16);
        nArray2[6] = (int)(l13 * l3 + l14 * l7 + l15 * l11 >> 16);
        nArray2[7] = (int)(l13 * l4 + l14 * l8 + l15 * l12 + l16 * 65536L >> 16);
        l13 = nArray2[8];
        l14 = nArray2[9];
        l15 = nArray2[10];
        l16 = nArray2[11];
        nArray2[8] = (int)(l13 * l + l14 * l5 + l15 * l9 >> 16);
        nArray2[9] = (int)(l13 * l2 + l14 * l6 + l15 * l10 >> 16);
        nArray2[10] = (int)(l13 * l3 + l14 * l7 + l15 * l11 >> 16);
        nArray2[11] = (int)(l13 * l4 + l14 * l8 + l15 * l12 + l16 * 65536L >> 16);
    }

    public void invert() {
        int[] nArray = this.m_matrix;
        int n = -nArray[3];
        int n2 = -nArray[7];
        int n3 = -nArray[11];
        nArray[3] = 0;
        nArray[7] = 0;
        nArray[11] = 0;
        nArray[15] = 65536;
        this.invert3x3();
        this.postTranslatex(n, n2, n3);
    }

    private void invert3x3() {
        int[] nArray = Transform.g_temp_trans.m_matrix;
        int[] nArray2 = this.m_matrix;
        int n = this.det3x3();
        int n2 = MathExt.divF(65536, n);
        System.arraycopy(nArray2, 0, nArray, 0, 16);
        nArray2[0] = MathExt.mulF(n2, Transform.mul(1, 1, 2, 2, nArray) - Transform.mul(1, 2, 2, 1, nArray));
        nArray2[1] = MathExt.mulF(n2, Transform.mul(0, 2, 2, 1, nArray) - Transform.mul(0, 1, 2, 2, nArray));
        nArray2[2] = MathExt.mulF(n2, Transform.mul(0, 1, 1, 2, nArray) - Transform.mul(0, 2, 1, 1, nArray));
        nArray2[4] = MathExt.mulF(n2, Transform.mul(1, 2, 2, 0, nArray) - Transform.mul(1, 0, 2, 2, nArray));
        nArray2[5] = MathExt.mulF(n2, Transform.mul(0, 0, 2, 2, nArray) - Transform.mul(0, 2, 2, 0, nArray));
        nArray2[6] = MathExt.mulF(n2, Transform.mul(0, 2, 1, 0, nArray) - Transform.mul(0, 0, 1, 2, nArray));
        nArray2[8] = MathExt.mulF(n2, Transform.mul(1, 0, 2, 1, nArray) - Transform.mul(1, 1, 2, 0, nArray));
        nArray2[9] = MathExt.mulF(n2, Transform.mul(0, 1, 2, 0, nArray) - Transform.mul(0, 0, 2, 1, nArray));
        nArray2[10] = MathExt.mulF(n2, Transform.mul(0, 0, 1, 1, nArray) - Transform.mul(0, 1, 1, 0, nArray));
    }

    private int det3x3() {
        int[] nArray = this.m_matrix;
        return MathExt.mulF(nArray[0], Transform.mul(1, 1, 2, 2, nArray) - Transform.mul(1, 2, 2, 1, nArray)) - MathExt.mulF(nArray[1], Transform.mul(1, 0, 2, 2, nArray) - Transform.mul(1, 2, 2, 0, nArray)) + MathExt.mulF(nArray[2], Transform.mul(1, 0, 2, 1, nArray) - Transform.mul(1, 1, 2, 0, nArray));
    }

    private static int mul(int n, int n2, int n3, int n4, int[] nArray) {
        return MathExt.mulF(nArray[n * 4 + n2], nArray[n3 * 4 + n4]);
    }

    public void mascotTransposeInvert() {
        int[] nArray = this.m_matrix;
        nArray[4] = -nArray[4];
        nArray[5] = -nArray[5];
        nArray[6] = -nArray[6];
        nArray[8] = -nArray[8];
        nArray[9] = -nArray[9];
        nArray[10] = -nArray[10];
        nArray[3] = nArray[3];
        nArray[7] = -nArray[7];
        nArray[11] = -nArray[11];
    }
}

