/*
 * Decompiled with CFR 0.152.
 */
package generic.engine2d;

import generic.MathExt;

public final class Transform2D {
    private static final int F1_0 = 65536;
    private static final int[] IDENTITY_ELEMENTS = new int[]{65536, 0, 0, 0, 65536, 0, 0, 0, 65536};
    private int[] m_matrix = new int[9];

    public Transform2D() {
        this.setIdentity();
    }

    public void setIdentity() {
        System.arraycopy(IDENTITY_ELEMENTS, 0, this.m_matrix, 0, 9);
    }

    public boolean isIdentity() {
        System.out.println("not implemented");
        return false;
    }

    public void set(Transform2D transform2D) {
        System.arraycopy(transform2D.m_matrix, 0, this.m_matrix, 0, 9);
    }

    public void setx(int[] nArray) {
        System.arraycopy(nArray, 0, this.m_matrix, 0, 9);
    }

    public void getx(int[] nArray) {
        System.arraycopy(this.m_matrix, 0, nArray, 0, 9);
    }

    public void setTranslatex(int n, int n2) {
        int[] nArray = this.m_matrix;
        nArray[0] = 65536;
        nArray[1] = 0;
        nArray[2] = n;
        nArray[3] = 0;
        nArray[4] = 65536;
        nArray[5] = n2;
        nArray[6] = 0;
        nArray[7] = 0;
        nArray[8] = 65536;
    }

    public void postTranslatex(int n, int n2) {
        int[] nArray = this.m_matrix;
        nArray[2] = (int)((long)nArray[0] * (long)n + (long)nArray[1] * (long)n2 >> 16) + nArray[2];
        nArray[5] = (int)((long)nArray[3] * (long)n + (long)nArray[4] * (long)n2 >> 16) + nArray[5];
        nArray[8] = (int)((long)nArray[6] * (long)n + (long)nArray[7] * (long)n2 >> 16) + nArray[8];
    }

    public void setScalex(int n, int n2) {
        int[] nArray = this.m_matrix;
        nArray[0] = n;
        nArray[1] = 0;
        nArray[2] = 0;
        nArray[3] = 0;
        nArray[4] = n2;
        nArray[5] = 0;
        nArray[6] = 0;
        nArray[7] = 0;
        nArray[8] = 65536;
    }

    public void postScalex(int n, int n2) {
        int[] nArray = this.m_matrix;
        nArray[0] = (int)((long)nArray[0] * (long)n >> 16);
        nArray[1] = (int)((long)nArray[1] * (long)n2 >> 16);
        nArray[3] = (int)((long)nArray[3] * (long)n >> 16);
        nArray[4] = (int)((long)nArray[4] * (long)n2 >> 16);
        nArray[6] = (int)((long)nArray[6] * (long)n >> 16);
        nArray[7] = (int)((long)nArray[7] * (long)n2 >> 16);
    }

    public void setRotatex(int n) {
        if (n == 0) {
            this.setIdentity();
            return;
        }
        int n2 = MathExt.degreesToRadiansF(n);
        int n3 = MathExt.sinF(n2);
        int n4 = MathExt.cosF(n2);
        int[] nArray = this.m_matrix;
        nArray[0] = n4;
        nArray[1] = -n3;
        nArray[2] = 0;
        nArray[3] = n3;
        nArray[4] = n4;
        nArray[5] = 0;
        nArray[6] = 0;
        nArray[7] = 0;
        nArray[8] = 65536;
    }

    public void postRotatex(int n) {
        if (n == 0) {
            return;
        }
        int n2 = MathExt.sinF(n);
        int n3 = MathExt.cosF(n);
        int[] nArray = this.m_matrix;
        long l = nArray[0];
        long l2 = nArray[1];
        nArray[0] = (int)(l * (long)n3 + l2 * (long)n2 >> 16);
        nArray[1] = (int)(l * (long)(-n2) + l2 * (long)n3 >> 16);
        l = nArray[3];
        l2 = nArray[4];
        nArray[3] = (int)(l * (long)n3 + l2 * (long)n2 >> 16);
        nArray[4] = (int)(l * (long)(-n2) + l2 * (long)n3 >> 16);
        l = nArray[6];
        l2 = nArray[7];
        nArray[6] = (int)(l * (long)n3 + l2 * (long)n2 >> 16);
        nArray[7] = (int)(l * (long)(-n2) + l2 * (long)n3 >> 16);
    }

    public void postMultiply(Transform2D transform2D) {
        int[] nArray = this.m_matrix;
        int[] nArray2 = transform2D.m_matrix;
        long l = nArray[0];
        long l2 = nArray[1];
        long l3 = nArray[2];
        long l4 = nArray[3];
        long l5 = nArray[4];
        long l6 = nArray[5];
        long l7 = nArray[6];
        long l8 = nArray[7];
        long l9 = nArray[8];
        int n = nArray2[0];
        int n2 = nArray2[1];
        int n3 = nArray2[2];
        int n4 = nArray2[3];
        int n5 = nArray2[4];
        int n6 = nArray2[5];
        int n7 = nArray2[6];
        int n8 = nArray2[7];
        int n9 = nArray2[8];
        nArray[0] = (int)(l * (long)n + l2 * (long)n4 + l3 * (long)n7 >> 16);
        nArray[1] = (int)(l * (long)n2 + l2 * (long)n5 + l3 * (long)n8 >> 16);
        nArray[2] = (int)(l * (long)n3 + l2 * (long)n6 + l3 * (long)n9 >> 16);
        nArray[3] = (int)(l4 * (long)n + l5 * (long)n4 + l6 * (long)n7 >> 16);
        nArray[4] = (int)(l4 * (long)n2 + l5 * (long)n5 + l6 * (long)n8 >> 16);
        nArray[5] = (int)(l4 * (long)n3 + l5 * (long)n6 + l6 * (long)n9 >> 16);
        nArray[6] = (int)(l7 * (long)n + l8 * (long)n4 + l9 * (long)n7 >> 16);
        nArray[7] = (int)(l7 * (long)n2 + l8 * (long)n5 + l9 * (long)n8 >> 16);
        nArray[8] = (int)(l7 * (long)n3 + l8 * (long)n6 + l9 * (long)n9 >> 16);
    }

    public void transformx(short[] sArray, int n) {
        int[] nArray = this.m_matrix;
        long l = nArray[0];
        long l2 = nArray[1];
        int n2 = nArray[2];
        long l3 = nArray[3];
        long l4 = nArray[4];
        int n3 = nArray[5];
        int n4 = 0;
        for (int i = 0; i < n; ++i) {
            int n5 = sArray[n4 + 0] << 16;
            int n6 = sArray[n4 + 1] << 16;
            sArray[n4 + 0] = (short)((int)(l * (long)n5 + l2 * (long)n6 >> 16) + n2 >> 16);
            sArray[n4 + 1] = (short)((int)(l3 * (long)n5 + l4 * (long)n6 >> 16) + n3 >> 16);
            n4 += 2;
        }
    }
}

