/*
 * Decompiled with CFR 0.152.
 */
package generic;

import constants.FlowConstants;
import constants.Layout2Constants;
import game.AppEngine;
import game.Scene;
import generic.LayoutManager2;
import generic.TextManager;
import java.io.DataInputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;

public class FlowManager
implements FlowConstants,
Layout2Constants {
    private static final int STATE_EVENT_COUNT = 6;
    private static final int STATE_DATA_LAYOUT = 0;
    private static final int STATE_DATA_MENU = 1;
    private static final int STATE_DATA_LAYOUT_TIME = 2;
    private static final int STATE_DATA_PLAYSTATE = 3;
    private static final int STATE_DATA_ANIMATION = 4;
    private static final int STATE_DATA_EVENT_0 = 5;
    private static final int STATE_DATA_COUNT = 11;
    private static final int MENU_DATA_ITEM_COUNT = 0;
    private static final int MENU_DATA_SELECTION = 1;
    private static final int MENU_DATA_ORIENTATION = 2;
    private static final int MENU_DATA_WRAP = 3;
    private static final int MENU_DATA_ITEM0 = 4;
    private static final int ITEM_EVENT_COUNT = 3;
    private static final int ITEM_DATA_ID = 0;
    private static final int ITEM_DATA_EVENT_0 = 1;
    private static final int ITEM_DATA_COUNT = 4;
    private static final int PLAYSTATE_NONE = 0;
    private static final int PLAYSTATE_TRANSITION_IN = 1;
    private static final int PLAYSTATE_TRANSITION_OUT = 2;
    private static final int PLAYSTATE_ANIMATION = 3;
    private static final int PLAYSTATE_WAIT_FOR_TRIGGER = 4;
    public static final int ANIMATION_NONE = -1;
    public static final int ANIMATION_DEFAULT = -2;
    public static final int ANIMATION_REVERSE_DEFAULT = -3;
    public static final int ANIMATION_FADE_IN = -4;
    public static final int ANIMATION_FADE_OUT = -5;
    private static final int STATE_CHANGE_NONE = 0;
    private static final int STATE_CHANGE_TRANSITION = 1;
    private static final int STATE_CHANGE_PUSH = 2;
    private static final int STATE_CHANGE_POP = 3;
    private static final int STATE_CHANGE_SWAPTOP = 4;
    private static final int STATE_CHANGE_SCENE = 5;
    private int[] m_stateData = null;
    private int[][] m_menuData = null;
    private Scene m_scene = null;
    private LayoutManager2 m_layoutManager2 = null;
    private static final int STATE_STACK_SIZE = 8;
    private short m_stateStackCurrentSize = 0;
    private short[] m_stateStack = new short[8];
    private int m_nextStateChange;
    private int m_nextState = -1;
    private int m_nextScene = -1;
    private static final int FADE_DURATION = 500;
    private int m_fadeTime;
    private int m_fadeModulation;
    private int m_currentState = 0;

    public FlowManager(DataInputStream dataInputStream, LayoutManager2 layoutManager2, TextManager textManager, short s) {
        this.m_layoutManager2 = layoutManager2;
        this.m_currentState = s;
        this.m_stateStack[0] = s;
        this.m_stateStackCurrentSize = 1;
        this.m_nextStateChange = 0;
        this.loadData(dataInputStream);
    }

    public LayoutManager2 getLayoutManager() {
        return this.m_layoutManager2;
    }

    public void setScene(Scene scene, int n) {
        this.m_scene = scene;
        this.m_stateStackCurrentSize = 0;
        this.pushState(n);
        this.beginTransitionIn(n);
    }

    public void clearScene() {
        this.clearStateStack();
        this.m_scene = null;
    }

    public void setCompositingEnabled(boolean bl) {
    }

    public int getStateStackSize() {
        return this.m_stateStackCurrentSize;
    }

    private void pushState(int n) {
        AppEngine.ASSERT(this.m_stateStackCurrentSize < 8);
        short s = this.m_stateStackCurrentSize;
        this.m_stateStackCurrentSize = (short)(s + 1);
        this.m_stateStack[s] = (short)n;
        this.m_currentState = n;
        this.m_scene.stateExpose(n);
    }

    private void popState() {
        this.m_scene.stateCleanup(this.getCurrentState());
        this.m_stateStackCurrentSize = (short)(this.m_stateStackCurrentSize - 1);
        if (this.m_stateStackCurrentSize > 0) {
            this.m_currentState = this.m_stateStack[this.m_stateStackCurrentSize - 1];
            this.m_scene.stateExpose(this.m_currentState);
        } else {
            this.m_currentState = -1;
        }
    }

    private void setState(int n) {
        this.clearStateStack();
        this.pushState(n);
        this.m_currentState = n;
        this.m_layoutManager2.resetScrollOffset();
        this.m_layoutManager2.resetAnims();
    }

    private void clearStateStack() {
        while (this.m_stateStackCurrentSize > 0) {
            this.popState();
        }
    }

    private void performStateChange() {
        int n = this.m_nextState;
        int n2 = this.m_nextStateChange;
        this.m_nextStateChange = 0;
        switch (n2) {
            case 4: {
                this.popState();
                this.pushState(n);
                this.m_scene.stateInit(n);
                this.beginTransitionIn(n);
                break;
            }
            case 2: {
                this.pushState(n);
                this.m_scene.stateInit(n);
                this.beginTransitionIn(n);
                break;
            }
            case 3: {
                this.popState();
                break;
            }
            case 1: {
                this.setState(n);
                this.m_scene.stateInit(n);
                this.beginTransitionIn(n);
                break;
            }
            case 5: {
                AppEngine.getCanvas().changeScene(this.m_nextScene, n);
            }
        }
    }

    public void update(int n) {
        this.m_layoutManager2.updateScrollOffset(n);
        this.m_layoutManager2.updateAnims(n);
        int n2 = this.getCurrentState();
        int n3 = this.getStatePlayState(n2);
        if (n3 == 0) {
            if (this.m_nextStateChange != 0) {
                boolean bl = this.m_scene.stateGetTransitionTriggered(n2);
                if (bl) {
                    this.setStatePlayState(n2, 4);
                } else if (this.m_nextStateChange == 2) {
                    this.stateTransitionOutFinished(n2);
                } else {
                    this.beginTransitionOut(n2);
                }
            }
        } else if (n3 != 4) {
            int n4 = this.getStateAnimation(n2);
            int n5 = this.getStateLayout(n2);
            AppEngine.ASSERT(n5 != -1, "State is in PLAYSTATE_TRANSITION but there is no layout");
            int n6 = this.getStateLayoutTime(n2);
            switch (n4) {
                case -1: {
                    this.setStatePlayState(n2, 0);
                    break;
                }
                case -3: {
                    if ((n6 -= n * 2) <= 0) {
                        this.setStateLayoutTime(n2, 0);
                        this.animationFinished();
                        break;
                    }
                    this.setStateLayoutTime(n2, n6);
                    break;
                }
                case -4: {
                    this.m_fadeTime -= n;
                    if (this.m_fadeTime < 0) {
                        this.m_fadeModulation = 255;
                        this.animationFinished();
                        break;
                    }
                    this.m_fadeModulation = 255 - 255 * this.m_fadeTime / 500;
                    break;
                }
                case -5: {
                    this.m_fadeTime -= n;
                    if (this.m_fadeTime < 0) {
                        this.m_fadeModulation = 0;
                        this.animationFinished();
                        break;
                    }
                    this.m_fadeModulation = 255 * this.m_fadeTime / 500;
                    break;
                }
                default: {
                    int n7 = this.m_layoutManager2.getAnimationStopTime(n5, n6);
                    AppEngine.ASSERT(n7 != -1, "State is playing animation but there is no animation in the layout");
                    if (n6 + n >= n7) {
                        this.setStateLayoutTime(n2, n7);
                        this.animationFinished();
                        break;
                    }
                    this.setStateLayoutTime(n2, n6 + n);
                }
            }
        }
    }

    private void beginTransitionIn(int n) {
        int n2 = this.getStateLayout(n);
        int n3 = this.m_scene.stateGetTransitionInAnimation(n);
        int n4 = -1;
        if (n2 != -1) {
            n4 = this.m_layoutManager2.getAnimationStopTime(n2, 0);
        }
        if (n2 == -1) {
            this.stateTransitionInFinished(n);
        } else if (n3 == -1 || n4 == -1) {
            if (n4 == -1) {
                this.setStateLayoutTime(n, 0);
                n3 = -1;
            } else {
                this.setStateLayoutTime(n, n4);
            }
            this.stateTransitionInFinished(n);
        } else {
            this.setStatePlayState(n, 1);
        }
        this.setStateAnimation(n, n3);
    }

    private void beginTransitionOut(int n) {
        int n2 = this.getStateLayout(n);
        int n3 = this.m_scene.stateGetTransitionOutAnimation(n);
        if (n3 != -4 && n3 != -5 && (n2 == -1 || this.m_layoutManager2.getAnimationStopTime(n2, 0) == -1)) {
            n3 = -1;
        }
        if (n3 == -1) {
            this.stateTransitionOutFinished(n);
        } else {
            this.setStatePlayState(n, 2);
            this.setStateAnimation(n, n3);
        }
    }

    public void playAnimation(int n) {
        int n2 = this.getCurrentState();
        int n3 = this.getStateLayout(n2);
        int n4 = 0;
        if (n >= 0) {
            n4 = this.m_layoutManager2.getAnimationTime(n3, n);
        }
        if (n4 == -1) {
            AppEngine.debug("Animation does not exist in layout.");
            n = -1;
        }
        this.setStateAnimation(n2, n);
        if (n != -1) {
            this.setStatePlayState(n2, 3);
            this.setStateLayoutTime(n2, n4);
        }
    }

    private void animationFinished() {
        this.trigger(8);
        int n = this.getCurrentState();
        switch (this.getStatePlayState(n)) {
            case 1: {
                this.stateTransitionInFinished(n);
                break;
            }
            case 2: {
                this.stateTransitionOutFinished(n);
                break;
            }
            case 3: {
                this.stateAnimationFinished(n);
            }
        }
    }

    private void stateTransitionInFinished(int n) {
        this.setStatePlayState(n, 0);
        this.m_scene.stateTransitionInFinished(n);
        this.setCurrentMenu();
    }

    private void stateTransitionOutFinished(int n) {
        this.m_scene.stateTransitionOutFinished(n);
        this.performStateChange();
    }

    private void stateAnimationFinished(int n) {
        this.setStatePlayState(n, 0);
        this.setCurrentMenu();
        this.m_scene.stateAnimationFinished(n);
    }

    public void triggerStateTransition() {
        int n = this.getCurrentState();
        this.setStatePlayState(n, 0);
    }

    private void renderState(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        int n6 = this.getStateLayout(n);
        int n7 = this.getStateLayoutTime(n);
        if (n6 != -1) {
            this.m_layoutManager2.drawLayout(graphics, n6, n2, n3, n4, n5, n7);
        }
    }

    public void render(Graphics graphics, int n, int n2, int n3, int n4) {
        graphics.setColor(0);
        AppEngine appEngine = AppEngine.getCanvas();
        graphics.setClip(0, 0, appEngine.getWidth(), appEngine.getHeight());
        graphics.fillRect(0, 0, appEngine.getWidth(), appEngine.getHeight());
        int n5 = this.m_stateStackCurrentSize;
        short[] sArray = this.m_stateStack;
        for (int i = 0; i < n5; ++i) {
            this.renderState(graphics, sArray[i], n, n2, n3, n4);
        }
        if (this.m_fadeModulation < 255) {
            AppEngine appEngine2 = AppEngine.getCanvas();
            appEngine2.renderFade(graphics, this.m_fadeModulation);
        }
    }

    public void processInput(int n, int[] nArray) {
        if (this.isInTransition()) {
            return;
        }
        AppEngine appEngine = AppEngine.getCanvas();
        Scene scene = appEngine.getScene();
        int[] nArray2 = this.m_stateData;
        switch (n) {
            case 0: {
                int n2;
                int n3;
                int n4 = nArray[1];
                int n5 = nArray[0];
                int n6 = this.getCurrentMenu();
                if (n6 != -1) {
                    for (n3 = 0; n3 < 3; ++n3) {
                        n2 = this.getSelectionItemInfo((short)(1 + n3));
                        if (!this.isKeyEventTriggered(scene, n2, n4, n5)) continue;
                        this.m_scene.stateMenuItemEventTriggered(n2);
                        this.triggerEvent(n2);
                        return;
                    }
                }
                for (n3 = 0; n3 < 6; ++n3) {
                    n2 = nArray2[this.getCurrentState() * 11 + 5 + n3];
                    if (!this.isKeyEventTriggered(scene, n2, n4, n5)) continue;
                    this.m_scene.stateEventTriggered(n2);
                    this.triggerEvent(n2);
                    return;
                }
                if (n6 == -1) break;
                n3 = 0;
                n2 = 65600;
                int n7 = 32784;
                if (this.m_menuData[n6][2] == 2) {
                    n2 = 16640;
                    n7 = 8196;
                }
                if (scene.checkKeys(n4, n5, n2, 0)) {
                    n3 = 1;
                } else if (scene.checkKeys(n4, n5, n7, 0)) {
                    n3 = -1;
                }
                if (n3 == 0) break;
                AppEngine.getCanvas().playSound(6);
                boolean bl = this.getMenuInfo(n6, 3) == 1;
                this.selectionMove(n3, bl);
                break;
            }
        }
    }

    public final boolean isInTransition() {
        return this.getStatePlayState(this.getCurrentState()) != 0;
    }

    public final boolean isChangingScene() {
        return this.m_nextStateChange == 5;
    }

    public final boolean isIdle() {
        return this.getStatePlayState(this.getCurrentState()) == 0 && this.m_nextStateChange == 0;
    }

    public final boolean isStateInStack(short s) {
        short[] sArray = this.m_stateStack;
        for (int i = 0; i < this.m_stateStackCurrentSize; ++i) {
            if (sArray[i] != s) continue;
            return true;
        }
        return false;
    }

    public final void transition(int n) {
        if (this.m_nextStateChange != 0) {
            this.performStateChange();
        }
        this.m_nextState = n;
        this.m_nextStateChange = 1;
    }

    public final void transitionPush(int n) {
        AppEngine.ASSERT(this.m_stateStackCurrentSize < 8, "Flow state stack full");
        if (this.m_nextStateChange != 0) {
            this.performStateChange();
        }
        this.m_nextState = n;
        this.m_nextStateChange = 2;
    }

    public final void transitionSwapTop(int n) {
        if (this.m_nextStateChange != 0) {
            this.performStateChange();
        }
        this.m_nextState = n;
        this.m_nextStateChange = 4;
    }

    public final void transitionPop() {
        AppEngine.ASSERT(this.m_stateStackCurrentSize >= 2, "Not enough states to pop");
        this.m_nextStateChange = 3;
    }

    public final void transitionScene(int n, int n2) {
        if (this.m_nextStateChange != 0) {
            this.performStateChange();
        }
        this.m_nextStateChange = 5;
        this.m_nextScene = n;
        this.m_nextState = n2;
    }

    public final int getCurrentState() {
        return this.m_currentState;
    }

    public int getStateLayout(int n) {
        int n2 = n * 11 + 0;
        if (n2 >= 0 && n2 < this.m_stateData.length) {
            return this.m_stateData[n2];
        }
        return -1;
    }

    public int getStateMenu(int n) {
        int n2 = n * 11 + 1;
        if (n2 >= 0 && n2 < this.m_stateData.length) {
            return this.m_stateData[n2];
        }
        return -1;
    }

    private int getStateLayoutTime(int n) {
        int n2 = n * 11 + 2;
        if (n2 >= 0 && n2 < this.m_stateData.length) {
            return this.m_stateData[n2];
        }
        return -1;
    }

    private void setStateLayoutTime(int n, int n2) {
        int n3 = n * 11 + 2;
        if (n3 >= 0 && n3 < this.m_stateData.length) {
            this.m_stateData[n * 11 + 2] = n2;
        }
    }

    private int getStatePlayState(int n) {
        int n2 = n * 11 + 3;
        if (n2 >= 0 && n2 < this.m_stateData.length) {
            return this.m_stateData[n2];
        }
        return -1;
    }

    private void setStatePlayState(int n, int n2) {
        int n3 = n * 11 + 3;
        if (n3 >= 0 && n3 < this.m_stateData.length) {
            this.m_stateData[n3] = n2;
        }
    }

    private int getStateAnimation(int n) {
        int n2 = n * 11 + 4;
        if (n2 >= 0 && n2 < this.m_stateData.length) {
            return this.m_stateData[n2];
        }
        return -1;
    }

    private void setStateAnimation(int n, int n2) {
        this.m_stateData[n * 11 + 4] = n2;
        this.m_fadeModulation = 255;
        int n3 = this.getStateLayout(n);
        switch (n2) {
            case -1: {
                break;
            }
            case -2: {
                this.setStateLayoutTime(n, 0);
                break;
            }
            case -3: {
                int n4 = this.m_layoutManager2.getAnimationStopTime(n3, 0);
                AppEngine.ASSERT(n4 != -1, "No default animation to play.");
                this.setStateLayoutTime(n, n4);
                break;
            }
            case -4: {
                this.m_fadeTime = 500;
                this.m_fadeModulation = 0;
                break;
            }
            case -5: {
                this.m_fadeTime = 500;
                break;
            }
        }
    }

    public int getMenuInfo(int n, int n2) {
        return this.m_menuData[n][n2];
    }

    public int getSelectionItemInfo(int n) {
        return this.getSelectionItemInfo(this.getCurrentMenu(), n);
    }

    public int getItemInfo(int n, int n2, int n3) {
        return this.m_menuData[n][4 + n2 * 4 + n3];
    }

    public int getSelectionItemInfo(int n, int n2) {
        int n3 = 4 + this.m_menuData[n][1] * 4;
        return this.m_menuData[n][n3 + n2];
    }

    public int getMenuSelection(int n) {
        int n2 = this.m_menuData[n][1];
        return this.getItemInfo(n, n2, 0);
    }

    public int getCurrentMenu() {
        return this.getStateMenu(this.getCurrentState());
    }

    public int getCurrentMenuSelection() {
        return this.m_menuData[this.getCurrentMenu()][1];
    }

    public void setMenuSelection(int n, int n2) {
        this.m_menuData[n][1] = n2;
    }

    public void setMenuWrapping(int n, boolean bl) {
        this.m_menuData[n][3] = bl ? 1 : 0;
    }

    private final void setCurrentMenu() {
        int n = this.getCurrentState();
        int n2 = this.getStateMenu(n);
        if (n2 != -1) {
            this.selectionMove(-1, true);
            this.selectionMove(1, true);
            this.triggerMenuItem(7);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void selectionMove(int n, boolean bl) {
        int[] nArray = this.m_menuData[this.getCurrentMenu()];
        int n2 = nArray[0];
        int n3 = nArray[1];
        boolean bl2 = false;
        while (!bl2) {
            if ((n3 += n) >= n2) {
                if (n <= 0 || !bl) return;
                n3 = 0;
            } else if (n3 < 0) {
                if (n >= 0 || !bl) return;
                n3 = n2 - 1;
            }
            bl2 = true;
            if (this.m_scene.isMenuItemEnabled(nArray[n3 * 4 + 4 + 0])) continue;
            bl2 = false;
        }
        if (!bl2) return;
        this.setMenuSelection(n3);
    }

    public void setMenuSelection(int n) {
        this.m_menuData[this.getCurrentMenu()][1] = (short)n;
        int n2 = this.getCurrentState();
        int n3 = this.getStateLayout(n2);
        AppEngine.ASSERT(n3 != -1, "State has menu but no layout");
        this.setStateLayoutTime(n2, this.m_layoutManager2.getMenuItemTime(n3, n));
        this.triggerMenuItem(7);
    }

    public void loadData(DataInputStream dataInputStream) {
        AppEngine.timerBegin();
        try {
            int n;
            byte by;
            int n2;
            int n3;
            int[] nArray = new int[11 * dataInputStream.readByte()];
            for (int i = 0; i < nArray.length; i += 11) {
                nArray[i + 0] = this.readSymbol(dataInputStream);
                nArray[i + 1] = this.readSymbol(dataInputStream);
                n3 = dataInputStream.readByte();
                AppEngine.ASSERT(n3 <= 6, "Too many events in flow data -- adjust FLOW_EVENT_COUNT");
                for (n2 = 0; n2 < n3; ++n2) {
                    by = dataInputStream.readByte();
                    byte by2 = dataInputStream.readByte();
                    n = this.readSymbol(dataInputStream);
                    nArray[i + n2 + 5] = this.packEvent(by, by2, (short)n);
                }
                for (n2 = n3; n2 < 6; ++n2) {
                    nArray[i + n2 + 5] = this.packEvent((byte)0, (byte)0, (short)0);
                }
            }
            this.m_stateData = nArray;
            int[][] nArrayArray = new int[dataInputStream.readByte()][];
            for (n3 = 0; n3 < nArrayArray.length; ++n3) {
                n2 = dataInputStream.readByte();
                by = dataInputStream.readByte();
                int[] nArray2 = new int[by * 4 + 4];
                nArray2[0] = by;
                nArray2[1] = 0;
                nArray2[2] = n2;
                nArray2[3] = 1;
                for (n = 4; n < nArray2.length; n += 4) {
                    int n4;
                    nArray2[n + 0] = this.readSymbol(dataInputStream);
                    int n5 = dataInputStream.readByte();
                    AppEngine.ASSERT(n5 <= 3, "Too many events in menu item -- increase ITEM_EVENT_COUNT");
                    for (n4 = 0; n4 < n5; ++n4) {
                        byte by3 = dataInputStream.readByte();
                        byte by4 = dataInputStream.readByte();
                        short s = this.readSymbol(dataInputStream);
                        nArray2[n + 1 + n4] = this.packEvent(by3, by4, s);
                    }
                    for (n4 = n5; n4 < 3; ++n4) {
                        nArray2[n + 1 + n4] = this.packEvent((byte)0, (byte)0, (short)0);
                    }
                }
                nArrayArray[n3] = nArray2;
            }
            this.m_menuData = nArrayArray;
        }
        catch (IOException iOException) {
            this.m_stateData = null;
            this.m_menuData = null;
            AppEngine.ASSERT(false, "failed to load flow.bin");
        }
        AppEngine.timerEnd("Flow load time");
    }

    private final short readSymbol(DataInputStream dataInputStream) {
        try {
            return dataInputStream.readShort();
        }
        catch (IOException iOException) {
            return -1;
        }
    }

    private int packEvent(byte by, byte by2, short s) {
        return by & 0xFF | by2 << 8 | s << 16;
    }

    private byte getEventTrigger(int n) {
        return (byte)(n & 0xFF);
    }

    private byte getEventAction(int n) {
        return (byte)(n >> 8);
    }

    private short getEventValue(int n) {
        return (short)(n >> 16);
    }

    private void trigger(int n) {
        int[] nArray = this.m_stateData;
        for (int i = 0; i < 6; ++i) {
            int n2 = nArray[this.getCurrentState() * 11 + 5 + i];
            if (this.getEventTrigger(n2) != n) continue;
            this.triggerEvent(n2);
        }
    }

    private void triggerMenuItem(int n) {
        for (int i = 0; i < 3; ++i) {
            int n2 = this.getSelectionItemInfo((short)(1 + i));
            if (this.getEventTrigger(n2) != n) continue;
            this.triggerEvent(n2);
        }
    }

    private void triggerEvent(int n) {
        byte by = this.getEventTrigger(n);
        byte by2 = this.getEventAction(n);
        short s = this.getEventValue(n);
        if (by == 5) {
            if (by2 != 5 && by2 != 14) {
                AppEngine.getCanvas().playSound(4);
            }
        } else if (by == 6) {
            AppEngine.getCanvas().playSound(5);
        } else if ((by == 2 || by == 1) && by2 == 1 || by2 == 6) {
            AppEngine.getCanvas().playSound(6);
        }
        switch (by2) {
            case 1: {
                this.transition(s);
                break;
            }
            case 2: {
                this.transitionPush(s);
                break;
            }
            case 3: {
                this.transitionPop();
                break;
            }
            case 4: {
                this.transitionSwapTop(s);
                break;
            }
            default: {
                this.m_scene.processAction(by2, s);
            }
        }
    }

    private boolean isKeyEventTriggered(Scene scene, int n, int n2, int n3) {
        AppEngine appEngine = AppEngine.getCanvas();
        switch (this.getEventTrigger(n)) {
            case 1: {
                return scene.checkKeys(n2, n3, 32784, 0);
            }
            case 2: {
                return scene.checkKeys(n2, n3, 65600, 0);
            }
            case 3: {
                return scene.checkKeys(n2, n3, 8196, 0);
            }
            case 4: {
                return scene.checkKeys(n2, n3, 16640, 0);
            }
            case 5: {
                return scene.checkKeys(n2, n3, 4128, 1);
            }
            case 6: {
                return scene.checkKeys(n2, n3, 524288, 2);
            }
        }
        return false;
    }
}

