/*
 * Decompiled with CFR 0.152.
 */
package game;

import com.ea.sdk.SDKString;
import com.ea.sdk.SDKUtils;
import constants.FlowConstants;
import constants.TunerShopConstants;
import game.AppEngine;
import game.Scene;
import generic.AnimationManager;
import generic.FlowManager;
import generic.LayoutManager2;
import generic.MathExt;
import generic.ResourceManager;
import generic.TextManager;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import javax.microedition.io.Connector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.midlet.MIDlet;
import javax.wireless.messaging.MessageConnection;
import javax.wireless.messaging.TextMessage;

final class SceneMenu
extends Scene
implements FlowConstants,
TunerShopConstants {
    private int m_raceEventId = 0;
    private Image m_mapImage;
    private Image m_targetImage;
    private Image m_envPicture01;
    private Image m_envPicture02;
    private Image m_envPicture03;
    private int m_imageIndexCounter;
    private int m_loadedMenuImages;
    private int m_loadingProgress;
    private int m_numImagesToLoad;
    private int m_updateLoadingTime = 0;
    private static final int MAX_UPDATE_LOADING_TIME = 0;
    private byte m_selectedCar = (byte)-1;
    private byte m_selectedUpgrade = (byte)-1;
    private boolean m_carLoaded = false;
    private int m_raceMenuState = -1;
    private int m_carSelectCurrAnim = -1;
    private int afterSuccessStep;
    private int afterFailStep;
    public static boolean bonusEditionScrollChecker;
    private int lastState = -1;
    private final int SCREEN_WIDTH;
    private final int SCREEN_HEIGHT;
    private static final int MAP_MOVE_ANIMATION_DURATION = 400;
    private static final int MAP_BLINK_ANIMATION_DURATION = 800;
    private static final int MAP_ANIMATION_BLINK_TIME = 200;
    private int m_mapPosX;
    private int m_mapPosY;
    private int m_mapDuration;
    private int m_mapStartX;
    private int m_mapStartY;
    private int m_mapDestX;
    private int m_mapDestY;
    private int m_mapTime;
    private boolean m_mapIsAnimating;
    private boolean m_mapEventBlinking;
    private int m_animationIndex = 0;
    private int[] m_animationNodes;
    private int musicID = -1;
    private static final int TUNERSHOP_ANIM_INIT = 4;
    private static final int[][] CARCAMERA_ANIMS;
    private static final int CARCAM_SHIFT = 3;
    private boolean m_loadCarNext = false;
    private int m_tunerShopFocusTime;
    private static final int TUNER_SHOP_FOCUS_TIME = 400;
    private static final int[] s_tempInt2;
    int m_selectedTrophy = 0;
    private boolean m_noMoreCarsToPurchase = false;
    private SDKString m_notificationText = new SDKString(256, 0);
    private boolean m_notificationShowing;
    public static int bonus_item_descText;
    public static int SPEEDFREAK_COST;
    public static int MULTIPLIER_COST;
    public static int SELECTED_BONUSITEM_COST;
    private int m_menuHighlightFlashTimeout;
    private boolean m_menuHighlightActivatingSelection;
    private static final int MENU_HIGHLIGHT_FLASH_PERIOD = 100;
    private static final int MENU_HIGHLIGHT_FLASH_DURATION = 600;
    public static boolean inQuickRace;
    private int m_nextSelectedCar = -1;
    private int m_nextSelectedCarDirection = 0;
    public static boolean bonus_speed_freak;
    public static boolean bonus_mp;
    public boolean is_cop_in_careerMode = false;
    private static final int MODE_NONE = -1;
    private static final int MODE_PROCESSING = 1;
    private static final int MODE_COMPLETTE = 2;
    private static final int MODE_ERROR = 100;
    private static int billingMode;
    public static int purchaseIdx;
    public static final int ITEM_STAGE = 0;
    public static final int ITEM_CAR_1 = 1;
    public static final int ITEM_CAR_2 = 2;
    private static String[] shortcode;
    private static String[] keyword;
    private static String[] license;
    private static String[] price;
    private static String appKey;
    private static String txID;
    private static boolean billingConfigOk;
    private static boolean propertyValueOk;
    private static String BILLING_SECRET;
    private int confirmationTextIdx;
    public static int[] crcTable;
    public static final int PLATFORM_MOTOROLA = 0;
    public static final int PLATFORM_NOKIA = 1;
    public static final int PLATFORM_SONY_ERICSSON = 2;
    public static final int PLATFORM_SIEMENS = 3;
    public static final int PLATFORM_SAMSUNG = 4;
    public static final int PLATFORM_LG = 5;
    public static final int PLATFORM_NOT_DEFINED = 6;
    private static final String SOFT_WORD = "SOFT";
    private static final int SOFT_KEY_LEFT_MOTOROLA = -21;
    private static final int SOFT_KEY_LEFT_MOTOROLA2 = -20;
    private static final int SOFT_KEY_LEFT_MOTOROLA1 = 21;

    public SceneMenu(AppEngine appEngine, TextManager textManager, FlowManager flowManager, LayoutManager2 layoutManager2) {
        super(appEngine, textManager, flowManager, layoutManager2);
        this.SCREEN_WIDTH = 176;
        this.SCREEN_HEIGHT = 208;
        if (!this.m_engine.isTrophyAvailable(this.m_selectedTrophy)) {
            this.m_selectedTrophy = this.getNextAviableTrophy(0, 1);
        }
    }

    public void start(int n) {
        this.m_loadingProgress = 0;
    }

    private final void loadSounds() {
        AppEngine appEngine = this.m_engine;
        appEngine.loadSound(4);
        appEngine.loadSound(5);
        appEngine.loadSound(6);
        appEngine.loadSound(1);
    }

    private final void unloadSounds() {
        AppEngine appEngine = this.m_engine;
        appEngine.unloadSound(4);
        appEngine.unloadSound(5);
        appEngine.unloadSound(6);
        appEngine.unloadSound(1);
    }

    public void updateLoading(int n) {
        AppEngine appEngine = this.m_engine;
        ResourceManager resourceManager = appEngine.getResourceManager();
        try {
            Thread.sleep(10L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Thread.yield();
        if (this.m_loadingProgress < 10) {
            int n2;
            appEngine.loadLayoutImages(2);
            this.initValues();
            this.loadMap();
            this.loadEnvPictures();
            this.m_loadedMenuImages = 0;
            this.m_numImagesToLoad = 0;
            this.m_imageIndexCounter = 0;
            for (n2 = 0; n2 < appEngine.IMAGE_COUNT; ++n2) {
                int n3 = n2 << 1;
                long l = AppEngine.IMAGE_IDS[n3 + 1];
                if ((l & 2L) == 0L) continue;
                ++this.m_numImagesToLoad;
            }
            n2 = 0;
            this.m_loadingProgress = 10;
        } else if (this.m_loadingProgress < 60) {
            if (this.m_updateLoadingTime > 0) {
                this.m_updateLoadingTime -= n;
            } else {
                int n4 = 0;
                while (n4 < 1 && this.m_imageIndexCounter < appEngine.IMAGE_COUNT) {
                    int n5 = this.m_imageIndexCounter << 1;
                    int n6 = (int)AppEngine.IMAGE_IDS[n5 + 0];
                    long l = AppEngine.IMAGE_IDS[n5 + 1];
                    boolean bl = false;
                    if ((l & 2L) != 0L) {
                        if (AnimationManager.loadImage(resourceManager, n6)) {
                            ++n4;
                            ++this.m_loadedMenuImages;
                        } else {
                            bl = true;
                        }
                    }
                    if (bl) continue;
                    ++this.m_imageIndexCounter;
                    this.m_updateLoadingTime = 0;
                }
                this.m_loadingProgress = this.m_numImagesToLoad > 0 ? 10 + 50 * this.m_loadedMenuImages / this.m_numImagesToLoad : 60;
            }
        } else if (this.m_loadingProgress < 80) {
            this.m_loadingProgress = 80;
        } else if (this.m_loadingProgress < 100) {
            this.loadSounds();
            this.m_loadingProgress = 100;
        } else if (this.m_loadingProgress >= 100) {
            this.m_flowManager.setMenuWrapping(this.m_flowManager.getStateMenu(9), false);
            if (appEngine.isCurrentRaceCareer() || appEngine.isCurrentRaceTutorial()) {
                int n7 = this.m_engine.getRaceMenuState();
                this.m_flowManager.transition(n7 != -1 ? n7 : 35);
            } else if (this.m_engine.getShowIntroductionFlow()) {
                this.m_flowManager.transition(5);
            } else {
                this.m_flowManager.transition(this.getMainMenuState());
            }
        }
    }

    public void pause() {
        this.m_engine.stopMusic();
    }

    public void resume() {
        int n = this.m_flowManager.getCurrentState();
        switch (n) {
            case 4: 
            case 6: {
                this.m_loadingProgress = 0;
            }
        }
        try {
            Thread.sleep(500L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.m_engine.startMusic(this.musicID);
    }

    public void end() {
        AppEngine appEngine = this.m_engine;
        if (this.m_selectedCar != -1) {
            AnimationManager.unloadImage(appEngine.getCarSelectImageID(this.m_selectedCar), 0);
        }
        appEngine.unloadImages(2L, 0);
        this.unloadMap();
        this.unloadEnvPictures();
        this.unloadSounds();
        appEngine.requestGC(false);
    }

    public void update(int n) {
        AppEngine appEngine = this.m_engine;
        this.m_flowManager.update(n);
        int n2 = this.m_flowManager.getCurrentState();
        switch (n2) {
            case 4: 
            case 6: {
                this.updateLoading(n);
                break;
            }
            case 33: {
                appEngine.endGame();
                break;
            }
            case 10: 
            case 36: {
                this.m_layoutManager.setAcceptButtonVisible(true);
                break;
            }
            case 44: {
                this.m_layoutManager.setAcceptButtonVisible(this.m_engine.careerCarOwned(this.m_selectedCar));
                break;
            }
            case 37: {
                this.updateMap(n);
                this.m_layoutManager.setAcceptButtonVisible(true);
                break;
            }
            case 19: {
                this.updateBilling();
                break;
            }
            default: {
                this.m_layoutManager.setAcceptButtonVisible(true);
            }
        }
        this.lastState = n2;
    }

    public void render(Graphics graphics) {
        this.m_flowManager.render(graphics, 0, 0, 176, 208);
    }

    private void initMap() {
        this.m_raceEventId = this.m_engine.selectedEvent;
        this.m_mapDestX = this.m_engine.getEventMapPosX(this.m_raceEventId);
        this.m_mapDestY = this.m_engine.getEventMapPosY(this.m_raceEventId);
        this.m_mapStartX = this.m_mapDestX;
        this.m_mapStartY = this.m_mapDestY;
        this.m_mapDuration = 400;
        this.m_mapTime = 400;
        this.m_mapIsAnimating = false;
        this.m_mapEventBlinking = false;
    }

    private void gotoMapPosition(int n) {
        this.m_mapStartX = this.m_mapPosX;
        this.m_mapStartY = this.m_mapPosY;
        this.m_mapDestX = this.m_engine.getEventMapPosX(n);
        this.m_mapDestY = this.m_engine.getEventMapPosY(n);
        this.m_mapDuration = 400;
        this.m_mapTime = 0;
    }

    private void startMapAnimation(int[] nArray) {
        this.m_mapIsAnimating = true;
        this.m_animationIndex = 0;
        this.m_animationNodes = nArray;
        this.gotoMapPosition(nArray[0]);
    }

    public void proceedMapAnimation() {
        if (this.m_mapEventBlinking) {
            this.m_mapEventBlinking = false;
            ++this.m_animationIndex;
            if (this.m_animationIndex == this.m_animationNodes.length) {
                this.m_mapIsAnimating = false;
                this.gotoMapPosition(this.m_raceEventId);
            } else {
                this.gotoMapPosition(this.m_animationNodes[this.m_animationIndex]);
            }
        } else {
            this.m_mapEventBlinking = true;
            this.m_mapStartX = this.m_mapDestX;
            this.m_mapStartY = this.m_mapDestY;
            this.m_mapDuration = 800;
            this.m_mapTime = 0;
        }
    }

    private void updateMap(int n) {
        this.m_mapTime += n;
        int n2 = MathExt.smoothstepF(0, this.m_mapDuration, this.m_mapTime);
        this.m_mapPosX = this.m_mapStartX + MathExt.mulF(n2, this.m_mapDestX - this.m_mapStartX);
        this.m_mapPosY = this.m_mapStartY + MathExt.mulF(n2, this.m_mapDestY - this.m_mapStartY);
        if (this.m_mapTime > this.m_mapDuration) {
            this.m_mapTime = this.m_mapDuration;
            if (this.m_mapIsAnimating) {
                this.proceedMapAnimation();
            }
        }
    }

    private boolean isMapEventGrayed(int n) {
        if (!this.m_engine.isEventUnlocked(n)) {
            return true;
        }
        if (this.m_mapIsAnimating) {
            for (int i = this.m_animationIndex + 1; i < this.m_animationNodes.length; ++i) {
                if (this.m_animationNodes[i] != n) continue;
                return true;
            }
            if (this.m_animationNodes[this.m_animationIndex] == n) {
                return !this.m_mapEventBlinking || this.m_mapTime / 200 % 2 != 0;
            }
        } else if (this.m_animationIndex == 0) {
            int[] nArray = this.m_engine.getUnlockAnimationNodes();
            for (int i = 0; nArray != null && i < nArray.length; ++i) {
                if (nArray[i] != n) continue;
                return true;
            }
        }
        return false;
    }

    private int getEventRectColor(int n) {
        if (this.isMapEventGrayed(n)) {
            return 0x848484;
        }
        if (this.m_engine.isCopModeEvent(n)) {
            return 1128703;
        }
        return 65280;
    }

    private void drawMap(Graphics graphics, int n, int n2, int n3, int n4) {
        int n5 = (n3 - n >> 1) + n - this.m_mapPosX;
        int n6 = (n4 - n2 >> 1) + n2 - this.m_mapPosY;
        graphics.setClip(n, n2, n3 - n, n4 - n2);
        graphics.drawImage(this.m_mapImage, n5, n6, 20);
        for (int i = 0; i < 24; ++i) {
            int n7 = n5 + this.m_engine.getEventMapPosX(i) - 4;
            int n8 = n6 + this.m_engine.getEventMapPosY(i) - 4;
            graphics.setColor(this.getEventRectColor(i));
            graphics.drawLine(n7 + 1, n8, n7 + 6, n8);
            graphics.drawLine(n7 + 1, n8 + 7, n7 + 6, n8 + 7);
            graphics.drawLine(n7, n8 + 1, n7, n8 + 6);
            graphics.drawLine(n7 + 7, n8 + 1, n7 + 7, n8 + 6);
            if (this.m_engine.isEventComplete(i)) {
                graphics.fillRect(n7 + 2, n8 + 2, 4, 4);
                graphics.setColor(0);
                graphics.drawRect(n7 + 1, n8 + 1, 5, 5);
                continue;
            }
            graphics.setColor(0);
            graphics.fillRect(n7 + 1, n8 + 1, 6, 6);
        }
        graphics.setClip(0, 0, 176, 208);
    }

    private void renderCarWindow(Graphics graphics) {
        this.renderCarSelect2DBackground(graphics);
    }

    public void stateInit(int n) {
        AppEngine appEngine = this.m_engine;
        this.m_textManager.pagedReset();
        switch (n) {
            case 4: {
                appEngine.unloadLayoutImages(8);
                break;
            }
            case 6: {
                appEngine.renderBloomNextFrame();
                break;
            }
            case 7: 
            case 8: {
                this.musicID = 1;
                this.m_engine.startMusic(this.musicID);
                break;
            }
            case 10: {
                if (appEngine.getPlayerCarIndex() != -1) {
                    this.setSelectedCar(appEngine.getPlayerCarIndex());
                } else if (appEngine.rmsGameExists()) {
                    this.setSelectedCar(appEngine.rmsGetCareerActiveCar());
                } else {
                    this.setSelectedCar(0);
                }
                this.setCarCameraAnim(4, true);
                break;
            }
            case 20: {
                break;
            }
            case 36: {
                this.setSelectedCar(appEngine.rmsGetCareerActiveCar());
                this.setCarCameraAnim(4, true);
                this.m_selectedUpgrade = (byte)-1;
                break;
            }
            case 44: {
                this.setSelectedCar(appEngine.rmsGetCareerActiveCar());
                break;
            }
            case 37: {
                this.musicID = 1;
                this.m_engine.startMusic(this.musicID);
                this.m_raceEventId = this.m_engine.getCurrentRaceEventIndex();
                if (this.m_raceEventId == 24) {
                    this.m_raceEventId = 0;
                    this.m_engine.setRaceParameters(3, 0);
                }
                this.initMap();
                this.m_engine.setTrophyNottificationEnabled(true);
                break;
            }
            case 13: {
                this.confirmationTextIdx = 57;
                this.m_textManager.pagedReset();
                break;
            }
            case 14: {
                System.out.println("HERE IT IS ASKING FOR UNLOCK OF ALL EVENTS");
                this.confirmationTextIdx = 56;
                this.m_textManager.pagedReset();
            }
        }
    }

    public void stateCleanup(int n) {
        this.flashMenuHighlight(this.m_flowManager.getStateStackSize() <= 1);
    }

    public void stateExpose(int n) {
    }

    public void stateTransitionInFinished(int n) {
        switch (this.m_flowManager.getCurrentState()) {
            case 32: {
                this.m_flowManager.transition(this.getMainMenuState());
                this.m_engine.setMoreGamesActive(true);
            }
        }
        switch (this.m_flowManager.getCurrentState()) {
            case 35: {
                this.showWelcome(3);
                break;
            }
            case 39: {
                this.showWelcome(6);
                break;
            }
            case 37: {
                this.showWelcome(4);
            }
        }
        if (this.m_flowManager.getStateMenu(n) != -1) {
            this.flashMenuHighlight(false);
        }
    }

    public void stateTransitionOutFinished(int n) {
    }

    public void stateAnimationFinished(int n) {
        if (this.m_nextSelectedCar != -1) {
            this.performSelectNextCar();
        }
    }

    public int stateGetTransitionInAnimation(int n) {
        if (this.isHeavyTransitionState(n)) {
            return -1;
        }
        return -2;
    }

    public int stateGetTransitionOutAnimation(int n) {
        if (this.m_flowManager.isChangingScene()) {
            return -5;
        }
        if (this.isHeavyTransitionState(n)) {
            return -1;
        }
        switch (n) {
            case 2: 
            case 3: 
            case 5: 
            case 63: 
            case 64: {
                return -1;
            }
        }
        return -3;
    }

    public boolean stateGetTransitionTriggered(int n) {
        return false;
    }

    public void stateEventTriggered(int n) {
    }

    public void stateMenuItemEventTriggered(int n) {
        this.flashMenuHighlight(true);
    }

    private boolean isHeavyTransitionState(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 24: 
            case 25: 
            case 29: 
            case 30: 
            case 31: 
            case 37: 
            case 42: 
            case 43: 
            case 44: {
                return true;
            }
        }
        return false;
    }

    private void initValues() {
        AppEngine appEngine = this.m_engine;
        int n = appEngine.getNumCarsBuyable();
        int[][] nArray = appEngine.getCareerTunerAccessoryPrices();
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = Integer.MAX_VALUE;
        int n6 = Integer.MAX_VALUE;
        int n7 = Integer.MAX_VALUE;
        for (int i = 0; i < n; ++i) {
            int n8;
            int n9;
            byte by = (byte)(appEngine.getCarNumGears(i) - 1);
            int n10 = appEngine.getCarGearMaxSpeed(i, by);
            if (n5 > n10) {
                n5 = n10;
            }
            if (n2 < n10) {
                n2 = n10;
            }
            if (n6 > (n9 = appEngine.getCarGearAccel(i, (byte)0))) {
                n6 = n9;
            }
            if (n3 < n9) {
                n3 = n9;
            }
            if (n7 > (n8 = appEngine.getCarParamTyres(i))) {
                n7 = n8;
            }
            if (n4 >= n8) continue;
            n4 = n8;
        }
    }

    public final void loadMap() {
        AppEngine appEngine = this.m_engine;
        ResourceManager resourceManager = appEngine.getResourceManager();
        this.m_mapImage = resourceManager.loadImage(61);
        this.m_targetImage = resourceManager.loadImage(77);
    }

    public final void unloadMap() {
        this.m_mapImage = null;
        this.m_targetImage = null;
    }

    public final void unloadEnvPictures() {
        this.m_envPicture01 = null;
        this.m_envPicture02 = null;
        this.m_envPicture03 = null;
    }

    public final void loadEnvPictures() {
    }

    private void resetCarCameraAnim() {
    }

    private void setCarCameraAnim(int n, boolean bl) {
    }

    public void initializeCarSelect() {
    }

    private void loadCarSelect(int n) {
        AppEngine appEngine = this.m_engine;
        ResourceManager resourceManager = appEngine.getResourceManager();
        if (n == -1) {
            n = appEngine.rmsGetCareerActiveCar();
        }
        this.setSelectedCar(n);
    }

    private void updateCarSelect(int n) {
    }

    private void renderCarSelect2DBackground(Graphics graphics) {
        this.m_flowManager.getLayoutManager().drawLayout(graphics, 40, 0, 0, 176, 208, 0);
    }

    private void renderCarSelect2D(Graphics graphics, int n, int n2) {
        if (this.m_engine.careerCarOwned(this.m_selectedCar)) {
            AnimationManager.drawAnimFrame(graphics, this.m_carSelectCurrAnim, 0, n, n2);
        }
    }

    private void setSelectedCar(int n) {
        boolean bl = false;
        if (n != this.m_selectedCar || bl) {
            this.m_layoutManager.resetScrollOffset();
            AppEngine appEngine = this.m_engine;
            if (this.m_selectedCar != -1) {
                AnimationManager.unloadImage(appEngine.getCarSelectImageID(this.m_selectedCar), 0);
            }
            for (int i = 0; i < 8 && !AnimationManager.loadImage(appEngine.getResourceManager(), appEngine.getCarSelectImageID(n)); ++i) {
                AppEngine.doGC();
            }
            this.m_carSelectCurrAnim = appEngine.getCarSelectAnimID(n);
            this.m_selectedCar = (byte)n;
        }
    }

    private void renderSelectcarHandling(Graphics graphics, int n, int n2) {
        if (this.m_engine.careerCarOwned(this.m_selectedCar)) {
            int n3 = this.m_engine.getCarParamTyres(this.m_selectedCar);
            graphics.setColor(0);
            graphics.fillRect(n - 1, n2 - 1, 25, 5);
            graphics.setColor(5089957);
            graphics.fillRect(n, n2, 5, 3);
            for (int i = 1; i < 4; ++i) {
                switch (i) {
                    case 1: {
                        if (n3 > 98304) {
                            graphics.setColor(5089957);
                            break;
                        }
                        graphics.setColor(5006701);
                        break;
                    }
                    case 2: {
                        if (n3 > 131072) {
                            graphics.setColor(5089957);
                            break;
                        }
                        graphics.setColor(5006701);
                        break;
                    }
                    case 3: {
                        if (n3 > 163840) {
                            graphics.setColor(5089957);
                            break;
                        }
                        graphics.setColor(5006701);
                        break;
                    }
                    case 4: {
                        if (n3 >= 196608) {
                            graphics.setColor(5089957);
                            break;
                        }
                        graphics.setColor(5006701);
                    }
                }
                graphics.fillRect(n + i * 6, n2, 5, 3);
            }
        }
    }

    private void setNextRace(int n, int n2) {
        AppEngine appEngine = this.m_engine;
        this.m_raceEventId = n;
        appEngine.setRaceParameters(n2, this.m_raceEventId);
    }

    private void startRace() {
        this.m_engine.startRace(this.m_raceEventId);
    }

    private void startNewCareer() {
        AppEngine appEngine = this.m_engine;
        appEngine.resetRMSGameDataExceptCars();
        appEngine.rmsSetGameExists(true);
        appEngine.setPlayerCarIndex(appEngine.getNthOwnedCar((byte)0));
        appEngine.saveRMSGameData();
        this.m_noMoreCarsToPurchase = false;
    }

    private boolean showNextUnlockNotification() {
        SDKString sDKString = this.m_engine.getNextUnlockNotification();
        if (sDKString != null) {
            if (this.m_notificationShowing) {
                this.m_flowManager.transitionSwapTop(42);
            } else {
                this.m_flowManager.transitionPush(42);
            }
            this.m_notificationText.setLength(0);
            this.m_notificationText.append(sDKString);
            this.m_notificationShowing = true;
            return true;
        }
        int[] nArray = this.m_engine.getUnlockAnimationNodes();
        if (nArray != null) {
            this.startMapAnimation(nArray);
        }
        this.m_engine.clearUnlockAnimationNodes();
        return false;
    }

    private void dismissUnlockNotification() {
        if (!this.showNextUnlockNotification()) {
            this.m_flowManager.transitionPop();
            this.m_notificationShowing = false;
        }
    }

    private void dismissCongratulations() {
        this.m_flowManager.transition(37);
    }

    private void showWelcome(int n) {
        if (this.showNextUnlockNotification()) {
            return;
        }
    }

    public void processInput(int n, int[] nArray) {
        if (this.m_flowManager.isInTransition()) {
            return;
        }
        this.m_flowManager.processInput(n, nArray);
        switch (n) {
            case 0: {
                int n2 = nArray[1];
                int n3 = nArray[0];
                this.processKeyInput(n2, n3);
                break;
            }
        }
    }

    private void processKeyInput(int n, int n2) {
    }

    private SDKString getEventDisplayName(int n) {
        AppEngine appEngine = this.m_engine;
        if (appEngine.isEventUnlocked(n)) {
            return this.m_textManager.getString(appEngine.getEventTypeNameId(appEngine.getEventType(n)));
        }
        return this.m_textManager.getString(132);
    }

    int getNextAviableTrophy(int n, int n2) {
        int n3 = MathExt.sign(n2);
        int n4 = n;
        for (int i = Math.abs(n2); i > 0; --i) {
            do {
                if ((n4 = (n4 + n3) % 23) >= 0) continue;
                n4 = 22;
            } while (n != n4 && !this.m_engine.isTrophyAvailable(1 << n4));
            if (n == n4) break;
        }
        return n4;
    }

    public SDKString getLayoutString(int n) {
        SDKString sDKString = this.m_textManager.clearStringBuffer();
        if (n == 4) {
            this.m_engine.moneyToSDKString(this.m_engine.getBounty(), sDKString);
            return sDKString;
        }
        if (n == 5) {
            this.m_engine.moneyToSDKString(this.m_engine.getdummyBounty(), sDKString);
            return sDKString;
        }
        if (n >= 35 && n <= 58) {
            int n2 = n - 35;
            return this.getEventStarsString(n2, sDKString);
        }
        if (n >= 11 && n <= 34) {
            int n3 = n - 11;
            return this.getEventDisplayName(n3);
        }
        return this.getLayoutStringUncommon(n, sDKString);
    }

    private SDKString getLayoutStringUncommon(int n, SDKString sDKString) {
        switch (n) {
            case 68: {
                return this.m_engine.getLoadingProgressString(this.m_loadingProgress, sDKString);
            }
            case 118: {
                return SDKUtils.getHeaderString(0, 0, null);
            }
            case 119: {
                return SDKUtils.getHeaderString(1, 0, null);
            }
            case 120: {
                return SDKUtils.getHeaderString(2, 0, null);
            }
            case 121: {
                return SDKUtils.getHeaderString(3, 0, null);
            }
            case 122: {
                return SDKUtils.getHeaderString(4, 0, null);
            }
            case 123: {
                return SDKUtils.getHeaderString(5, 0, null);
            }
            case 99: 
            case 100: {
                return this.m_notificationText;
            }
            case 64: 
            case 97: {
                return this.m_engine.getConfirmationText(this.m_flowManager.getCurrentState());
            }
            case 66: 
            case 67: {
                if (this.m_flowManager.getCurrentState() == 13 || this.m_flowManager.getCurrentState() == 14) {
                    if (!this.m_textManager.pagedCanMove(-1) && !this.m_textManager.pagedCanMove(1)) {
                        return sDKString;
                    }
                    return this.m_textManager.pagedGetPositionString(sDKString);
                }
                return this.m_textManager.pagedGetPositionString(sDKString);
            }
            case 115: {
                if (this.m_engine.careerCarOwned(this.m_selectedCar)) {
                    return this.m_textManager.getString(this.m_engine.getCarDescriptionStringID(this.m_selectedCar));
                }
                sDKString.append(this.m_textManager.getString(132));
                sDKString.append(" ");
                sDKString.append(this.m_selectedCar + 1);
                sDKString.append("/");
                sDKString.append(this.m_engine.getNumCarsBuyable());
                return sDKString;
            }
            case 96: {
                this.m_engine.moneyToSDKString(this.m_engine.getCarTradeValue(this.m_selectedCar), sDKString);
                return sDKString;
            }
            case 6: {
                this.m_engine.moneyToSDKString(this.m_engine.getCarPrice(this.m_selectedCar), sDKString);
                return sDKString;
            }
            case 84: {
                byte by = this.m_engine.getCarAccessoryLevel(this.m_selectedCar, this.m_selectedUpgrade);
                if (by < 4) {
                    this.m_engine.moneyToSDKString(this.m_engine.getUpgradePrice(this.m_selectedCar, this.m_selectedUpgrade, by + 1), sDKString);
                } else if (by >= 4) {
                    return this.m_textManager.getString(6);
                }
                return sDKString;
            }
            case 80: {
                byte by = this.m_engine.getCarAccessoryLevel(this.m_selectedCar, 0);
                this.m_engine.upgradeProgressToSDKString(by, 4, this.m_selectedUpgrade == 0, sDKString);
                return sDKString;
            }
            case 82: {
                byte by = this.m_engine.getCarAccessoryLevel(this.m_selectedCar, 2);
                this.m_engine.upgradeProgressToSDKString(by, 4, this.m_selectedUpgrade == 2, sDKString);
                return sDKString;
            }
            case 81: {
                byte by = this.m_engine.getCarAccessoryLevel(this.m_selectedCar, 1);
                this.m_engine.upgradeProgressToSDKString(by, 4, this.m_selectedUpgrade == 1, sDKString);
                return sDKString;
            }
            case 83: {
                byte by = this.m_engine.getCarAccessoryLevel(this.m_selectedCar, 3);
                this.m_engine.upgradeProgressToSDKString(by, 4, this.m_selectedUpgrade == 3, sDKString);
                return sDKString;
            }
            case 9: {
                this.m_engine.intToSDKString(this.m_engine.getDriverProfileDriverLevel(), true, sDKString);
                return sDKString;
            }
            case 59: {
                this.m_engine.intToSDKString(this.m_engine.rmsGetBiggestDriftScore(), true, sDKString);
                return sDKString;
            }
            case 4: {
                this.m_engine.moneyToSDKString(this.m_engine.rmsGetCareerMoney(), sDKString);
                return sDKString;
            }
            case 172: {
                if (this.m_engine.careerCarOwned(this.m_selectedCar)) {
                    return sDKString.append("");
                }
                return this.m_textManager.getString(132);
            }
            case 131: {
                return sDKString;
            }
            case 165: {
                return this.m_engine.getTrophyName(this.getNextAviableTrophy(this.m_selectedTrophy, -2));
            }
            case 166: {
                return this.m_engine.getTrophyName(this.getNextAviableTrophy(this.m_selectedTrophy, -1));
            }
            case 167: {
                return this.m_engine.getTrophyName(this.m_selectedTrophy);
            }
            case 168: {
                return this.m_engine.getTrophyName(this.getNextAviableTrophy(this.m_selectedTrophy, 1));
            }
            case 169: {
                return this.m_engine.getTrophyName(this.getNextAviableTrophy(this.m_selectedTrophy, 2));
            }
            case 162: {
                return this.m_engine.getTrophyName(this.m_selectedTrophy);
            }
            case 163: {
                if (this.m_engine.areSpeedunitsMPH()) {
                    return this.m_engine.getTrophyDescription(this.m_selectedTrophy);
                }
                switch (this.m_selectedTrophy) {
                    case 7: {
                        return this.m_textManager.getString(151);
                    }
                    case 15: {
                        return this.m_textManager.getString(168);
                    }
                    case 18: {
                        return this.m_textManager.getString(175);
                    }
                }
                return this.m_engine.getTrophyDescription(this.m_selectedTrophy);
            }
            case 183: {
                if (this.m_engine.careerCarOwned(this.m_selectedCar)) {
                    sDKString.append(this.m_textManager.getString(203));
                    sDKString.append(" :");
                    return sDKString;
                }
                return sDKString.append("");
            }
            case 184: {
                if (this.m_engine.careerCarOwned(this.m_selectedCar)) {
                    sDKString.append(this.m_engine.getValueInDistanceUnits(this.m_engine.getCarGearMaxSpeed(this.m_selectedCar, (byte)(this.m_engine.getCarNumGears(this.m_selectedCar) - 1)) >> 12));
                    sDKString.append(" ");
                    if (this.m_engine.areSpeedunitsMPH()) {
                        this.m_textManager.appendSDKStringToBuffer(this.m_textManager.getString(235));
                    } else {
                        this.m_textManager.appendSDKStringToBuffer(this.m_textManager.getString(236));
                    }
                    return sDKString;
                }
                return sDKString.append("");
            }
            case 185: {
                if (this.m_engine.careerCarOwned(this.m_selectedCar)) {
                    sDKString.append(this.m_textManager.getString(92));
                    sDKString.append(" :");
                    return sDKString;
                }
                return sDKString.append("");
            }
            case 188: {
                sDKString.append(this.m_textManager.getString(64));
                switch ((int)((System.currentTimeMillis() & Integer.MAX_VALUE) / 500L % 4L)) {
                    case 0: {
                        sDKString.append(this.m_textManager.getString(65));
                        break;
                    }
                    case 1: {
                        sDKString.append(this.m_textManager.getString(66));
                        break;
                    }
                    case 2: {
                        sDKString.append(this.m_textManager.getString(67));
                    }
                }
                return sDKString;
            }
            case 189: {
                if (!this.m_engine.isEventUnlocked(this.m_engine.getCurrentRaceEventIndex())) {
                    this.m_engine.moneyToSDKString(this.m_engine.getEventPrice(this.m_engine.getCurrentRaceEventIndex()), sDKString);
                    sDKString = this.m_textManager.getString(133).replaceFirst(sDKString);
                }
                return sDKString;
            }
            case 192: {
                if (!this.m_engine.careerCarOwned(this.m_selectedCar)) {
                    this.m_engine.moneyToSDKString(this.m_engine.getCarPrice(this.m_selectedCar), sDKString);
                    sDKString = this.m_textManager.getString(133).replaceFirst(sDKString);
                }
                return sDKString;
            }
            case 193: {
                this.m_engine.moneyToSDKString(SELECTED_BONUSITEM_COST, sDKString);
                return sDKString;
            }
            case 191: {
                return this.m_textManager.getString(bonus_item_descText);
            }
        }
        return this.m_engine.getLayoutString(n, sDKString);
    }

    private SDKString getEventStarsString(int n, SDKString sDKString) {
        AppEngine.starsToSDKString(this.m_engine.rmsGetEventAwards(n), sDKString);
        return sDKString;
    }

    private void flashMenuHighlight(boolean bl) {
        this.m_menuHighlightFlashTimeout = 600;
        this.m_menuHighlightActivatingSelection = bl;
    }

    public int getSubLayoutTime(int n) {
        int n2 = 0;
        switch (n) {
            case 1: {
                if (!this.isMenuItemEnabled(6)) break;
                return -1;
            }
            case 2: {
                if (!this.isMenuItemEnabled(8)) break;
                return -1;
            }
            case 3: {
                if (!this.isMenuItemEnabled(24)) break;
                return -1;
            }
            case 23: 
            case 24: {
                if (this.getCanSelectNextCar()) break;
                return -1;
            }
            case 22: {
                if (!this.m_menuHighlightActivatingSelection) break;
                return -1;
            }
            case 18: {
                if (this.m_textManager.pagedCanMove(-1)) break;
                return -1;
            }
            case 19: {
                if (this.m_textManager.pagedCanMove(1)) break;
                return -1;
            }
        }
        return n2;
    }

    public void drawLayoutRect(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        switch (n) {
            case 3: {
                this.drawMap(graphics, n2, n3, n4, n5);
                break;
            }
            case 4: {
                if (this.m_engine.getEventEnvironment(this.m_engine.getCurrentRaceEventIndex()) == 39) {
                    graphics.drawImage(this.m_envPicture01, n2, n3, 20);
                    break;
                }
                if (this.m_engine.getEventEnvironment(this.m_engine.getCurrentRaceEventIndex()) == 40) {
                    graphics.drawImage(this.m_envPicture02, n2, n3, 20);
                    break;
                }
                graphics.drawImage(this.m_envPicture03, n2, n3, 20);
                break;
            }
            case 1: {
                this.m_engine.renderDriverProfileDiamond(graphics, n2, n3, n4, n5);
                break;
            }
            case 5: {
                this.m_textManager.pagedDraw(n2, n3, n4, n5, 23);
                break;
            }
            case 6: {
                this.m_textManager.pagedDraw(n2, n3, n4, n5, 26);
                break;
            }
            case 7: {
                this.m_textManager.pagedDraw(n2, n3, n4, n5, this.confirmationTextIdx);
            }
        }
    }

    public void drawLayoutPoint(Graphics graphics, int n, int n2, int n3) {
        AppEngine appEngine = this.m_engine;
        switch (n) {
            case 22: {
                break;
            }
            case 24: {
                int n4 = this.m_selectedTrophy - 2;
                if (n4 < 0) {
                    n4 = 23 + n4;
                }
                if (this.m_engine.isTrophyReached(1 << n4)) {
                    if ((0x480600 & 1 << n4) == 0) {
                        AnimationManager.drawAnimFrame(graphics, 248, 1, n2, n3);
                        break;
                    }
                    AnimationManager.drawAnimFrame(graphics, 248, 2, n2, n3);
                    break;
                }
                AnimationManager.drawAnimFrame(graphics, 248, 0, n2, n3);
                break;
            }
            case 25: {
                int n5 = this.m_selectedTrophy - 1;
                if (n5 < 0) {
                    n5 = 23 + n5;
                }
                if (this.m_engine.isTrophyReached(1 << n5)) {
                    if ((0x480600 & 1 << n5) == 0) {
                        AnimationManager.drawAnimFrame(graphics, 248, 1, n2, n3);
                        break;
                    }
                    AnimationManager.drawAnimFrame(graphics, 248, 2, n2, n3);
                    break;
                }
                AnimationManager.drawAnimFrame(graphics, 248, 0, n2, n3);
                break;
            }
            case 26: {
                if (this.m_engine.isTrophyReached(1 << this.m_selectedTrophy)) {
                    if ((0x480600 & 1 << this.m_selectedTrophy) == 0) {
                        AnimationManager.drawAnimFrame(graphics, 248, 1, n2, n3);
                        break;
                    }
                    AnimationManager.drawAnimFrame(graphics, 248, 2, n2, n3);
                    break;
                }
                AnimationManager.drawAnimFrame(graphics, 248, 0, n2, n3);
                break;
            }
            case 27: {
                int n6 = this.m_selectedTrophy + 1;
                if (n6 >= 23) {
                    n6 -= 23;
                }
                if (this.m_engine.isTrophyReached(1 << n6)) {
                    if ((0x480600 & 1 << n6) == 0) {
                        AnimationManager.drawAnimFrame(graphics, 248, 1, n2, n3);
                        break;
                    }
                    AnimationManager.drawAnimFrame(graphics, 248, 2, n2, n3);
                    break;
                }
                AnimationManager.drawAnimFrame(graphics, 248, 0, n2, n3);
                break;
            }
            case 28: {
                int n7 = this.m_selectedTrophy + 2;
                if (n7 >= 23) {
                    n7 -= 23;
                }
                if (this.m_engine.isTrophyReached(1 << n7)) {
                    if ((0x480600 & 1 << n7) == 0) {
                        AnimationManager.drawAnimFrame(graphics, 248, 1, n2, n3);
                        break;
                    }
                    AnimationManager.drawAnimFrame(graphics, 248, 2, n2, n3);
                    break;
                }
                AnimationManager.drawAnimFrame(graphics, 248, 0, n2, n3);
                break;
            }
            case 3: {
                appEngine.renderBackgroundDim(graphics, true);
                break;
            }
            case 29: {
                if (this.m_engine.careerCarOwned(this.m_selectedCar)) {
                    return;
                }
                AnimationManager.drawAnimFrame(graphics, 228, 0, n2, n3);
                break;
            }
            case 19: {
                if (this.m_engine.isEventUnlocked(this.m_engine.getCurrentRaceEventIndex())) {
                    return;
                }
                AnimationManager.drawAnimFrame(graphics, 228, 0, n2, n3);
                break;
            }
            case 10: {
                break;
            }
            case 11: {
                break;
            }
            case 15: {
                break;
            }
            case 2: {
                this.renderCarWindow(graphics);
                break;
            }
            case 6: {
                this.renderCarSelect2D(graphics, n2, n3);
                break;
            }
            case 30: {
                this.renderSelectcarHandling(graphics, n2, n3);
            }
        }
    }

    public boolean isMenuItemEnabled(int n) {
        AppEngine appEngine = this.m_engine;
        switch (n) {
            case 8: {
                return appEngine.isMoreGamesAvailable();
            }
        }
        return true;
    }

    private boolean getCanSelectNextCar() {
        AppEngine appEngine = this.m_engine;
        int n = 0;
        n = appEngine.getAllCars().length;
        return n > 1;
    }

    private void selectNextCar(int n) {
        AppEngine appEngine = this.m_engine;
        byte[] byArray = appEngine.getAllCars();
        this.selectNextCar(byArray, appEngine.getNumCarsBuyable(), n);
        this.m_engine.playSound(6);
    }

    private void selectNextCar(byte[] byArray, int n, int n2) {
        int n3;
        for (n3 = 0; n3 < n; ++n3) {
            AppEngine.ASSERT(n3 < n, "Currently selected car is not in cars array.");
            if (byArray[n3] == this.m_selectedCar) break;
        }
        if ((n3 += n2) < 0) {
            n3 = n - 1;
        } else if (n3 >= n) {
            n3 = 0;
        }
        if (this.getCanSelectNextCar()) {
            if (this.m_selectedCar != -1) {
                this.m_carSelectCurrAnim = -1;
                AnimationManager.unloadImage(this.m_engine.getCarSelectImageID(this.m_selectedCar), 0);
            }
            this.m_nextSelectedCar = byArray[n3];
            this.m_nextSelectedCarDirection = n2;
            if (n2 > 0) {
                this.m_flowManager.playAnimation(9);
            } else {
                this.m_flowManager.playAnimation(11);
            }
        }
    }

    private void performSelectNextCar() {
        if (this.m_nextSelectedCar != -1) {
            this.setSelectedCar(this.m_nextSelectedCar);
            if (this.m_nextSelectedCarDirection > 0) {
                this.m_flowManager.playAnimation(10);
            } else {
                this.m_flowManager.playAnimation(8);
            }
            this.m_nextSelectedCar = -1;
        }
    }

    private void purchaseSelectedUpgrade() {
        AppEngine appEngine = this.m_engine;
        appEngine.purchaseCareerTunerAccessory(this.m_selectedCar, this.m_selectedUpgrade);
    }

    private boolean isStateEnabled(int n) {
        return true;
    }

    private short getMainMenuState() {
        if (this.m_engine.isMoreGamesAvailable()) {
            return 7;
        }
        return 8;
    }

    public void processAction(int n, short s) {
        AppEngine appEngine = this.m_engine;
        FlowManager flowManager = this.m_flowManager;
        switch (n) {
            case 9: {
                this.m_flowManager.transition(this.getMainMenuState());
                break;
            }
            case 6: {
                if (!this.isStateEnabled(s)) break;
                this.m_flowManager.transition(s);
                break;
            }
            case 36: {
                this.m_engine.setIsPlayerCop(true);
                this.processAction(35, (short)-1);
                break;
            }
            case 37: {
                this.m_engine.setIsPlayerCop(false);
                if (!this.isStateEnabled(s)) break;
                appEngine.setPlayerCarIndex(appEngine.rmsGetCareerActiveCar());
                this.m_flowManager.transition(s);
                break;
            }
            case 7: {
                this.m_textManager.pagedMovedPage(1);
                this.m_engine.playSound(6);
                break;
            }
            case 8: {
                this.m_textManager.pagedMovedPage(-1);
                this.m_engine.playSound(6);
                break;
            }
            case 19: {
                SDKUtils.setCurrentLanguage(s);
                this.m_engine.rmsSetLanguage(s);
                this.m_engine.saveRMSAppSettings();
                if (flowManager.getCurrentState() == 0) {
                    flowManager.transition(1);
                    break;
                }
                flowManager.transition(20);
                break;
            }
            case 34: {
                appEngine.setPlayerCarIndex(0);
                appEngine.setIsPlayerCop(false);
                this.setNextRace(24, 1);
                if (this.m_flowManager.isStateInStack((short)20)) {
                    this.m_engine.setRaceMenuState(20);
                } else if (this.m_flowManager.isStateInStack((short)26)) {
                    this.m_engine.setRaceMenuState(28);
                } else if (this.m_flowManager.isStateInStack((short)25)) {
                    this.m_engine.setRaceMenuState(27);
                } else {
                    this.m_engine.setRaceMenuState(35);
                }
                this.startRace();
                break;
            }
            case 10: {
                if (appEngine.rmsGameExists()) {
                    flowManager.transitionPush(24);
                    break;
                }
                this.processAction(11, (short)0);
                break;
            }
            case 11: {
                this.startNewCareer();
                if (flowManager.getCurrentState() == 24) {
                    flowManager.transitionSwapTop(25);
                    break;
                }
                flowManager.transitionPush(25);
                break;
            }
            case 32: {
                System.out.println("::::::::::::::::::::::::::::::::::::::::::CHECK::::::::::::::::::::::::::::::::::::::::::::::");
                AppEngine.dummyBounty = appEngine.getBounty();
                if (!appEngine.getTutorialCompleted()) {
                    flowManager.transitionPush(26);
                    this.m_engine.setTutorialCompleted(true);
                    break;
                }
                AppEngine.dummyBounty = appEngine.getBounty();
                System.out.println("BOUNTY ISSSSSSSSSSSSSSSSSSSSSSSSSSSS::::::" + AppEngine.dummyBounty);
                flowManager.transition(9);
                break;
            }
            case 33: {
                if (!appEngine.getTutorialCompleted()) {
                    flowManager.transitionPush(25);
                    this.m_engine.setTutorialCompleted(true);
                    break;
                }
                flowManager.transition(37);
                break;
            }
            case 12: {
                System.out.println("here it is resetting the data.....................here................................................");
                appEngine.resetRMSGameData();
                this.setNextRace(0, 3);
                appEngine.saveRMSGameData();
                this.m_flowManager.transition(this.getMainMenuState());
                break;
            }
            case 13: {
                appEngine.endGame();
                break;
            }
            case 14: {
                appEngine.switchSoundState(true);
                this.flashMenuHighlight(false);
                break;
            }
            case 15: {
                appEngine.switchSoundState(false);
                this.flashMenuHighlight(false);
                break;
            }
            case 16: {
                appEngine.setVibrationEnabled(!appEngine.isVibrationEnabled());
                this.flashMenuHighlight(false);
                break;
            }
            case 17: {
                appEngine.setCarMarkersEnabled(!appEngine.areCarMarkersEnabled());
                this.flashMenuHighlight(false);
                break;
            }
            case 18: {
                appEngine.setSpeedunitsMPH(!appEngine.areSpeedunitsMPH());
                this.flashMenuHighlight(false);
                break;
            }
            case 42: {
                this.setNextRace(s, 3);
                break;
            }
            case 44: {
                flowManager.transition(appEngine.getRaceMenuState());
                break;
            }
            case 43: {
                appEngine.setPlayerCarIndex(appEngine.rmsGetCareerActiveCar());
                this.setNextRace(this.m_raceEventId, 3);
                this.startRace();
                break;
            }
            case 20: {
                this.selectNextCar(1);
                break;
            }
            case 21: {
                this.selectNextCar(-1);
                break;
            }
            case 67: {
                AppEngine.dummyBounty = appEngine.getBounty();
                if (inQuickRace) {
                    if (appEngine.isPlayerCop()) {
                        flowManager.transition(9);
                        break;
                    }
                    this.m_flowManager.transition(10);
                    break;
                }
                System.out.println("here it is checking..........................................??????is_cop_in_careerMode" + this.is_cop_in_careerMode);
                if (appEngine.isPlayerCop()) {
                    this.m_flowManager.transition(37);
                    break;
                }
                this.m_flowManager.transition(36);
                break;
            }
            case 71: {
                if (!bonus_speed_freak) {
                    if (inQuickRace) {
                        bonus_speed_freak = true;
                        break;
                    }
                    if (appEngine.getdummyBounty() >= 15000) {
                        if (!inQuickRace) {
                            appEngine.reducedummyBounty(15000);
                        }
                        bonus_speed_freak = true;
                        break;
                    }
                    this.m_flowManager.transition(18);
                    break;
                }
                bonus_speed_freak = false;
                if (inQuickRace) break;
                appEngine.increasedummyBounty(15000);
                break;
            }
            case 72: {
                if (!bonus_mp) {
                    System.out.println("here it came:::::::::::::::::::::::::::::::::::::::::::::::::::true");
                    if (inQuickRace) {
                        bonus_mp = true;
                        break;
                    }
                    if (appEngine.getdummyBounty() >= 20000) {
                        if (!inQuickRace) {
                            appEngine.reducedummyBounty(20000);
                        }
                        bonus_mp = true;
                        break;
                    }
                    this.m_flowManager.transition(18);
                    break;
                }
                System.out.println("here it came:::::::::::::::::::::::::::::::::::::::::::::::::::false");
                bonus_mp = false;
                if (inQuickRace) break;
                appEngine.increasedummyBounty(20000);
                break;
            }
            case 73: {
                bonus_item_descText = 277;
                SELECTED_BONUSITEM_COST = SPEEDFREAK_COST;
                break;
            }
            case 74: {
                bonus_item_descText = 278;
                SELECTED_BONUSITEM_COST = MULTIPLIER_COST;
                break;
            }
            case 61: {
                this.m_flowManager.transition(36);
                break;
            }
            case 68: {
                if (inQuickRace) {
                    appEngine.setPlayerCarIndex(appEngine.isPlayerCop() ? (byte)0 : this.m_selectedCar);
                    this.setNextRace(appEngine.getQuickrace(), 2);
                    appEngine.setRaceMenuState(this.getMainMenuState());
                    inQuickRace = false;
                    this.startRace();
                    break;
                }
                if (this.is_cop_in_careerMode) {
                    this.startRace();
                    break;
                }
                appEngine.rmsSetCareerActiveCar(this.m_selectedCar);
                appEngine.saveRMSGameData();
                appEngine.setPlayerCarIndex(appEngine.rmsGetCareerActiveCar());
                this.setNextRace(this.m_raceEventId, 3);
                if (appEngine.getBounty() >= 0) {
                    this.startRace();
                    break;
                }
                return;
            }
            case 62: {
                appEngine.rmsSetCareerActiveCar(this.m_selectedCar);
                appEngine.saveRMSGameData();
                appEngine.setPlayerCarIndex(appEngine.rmsGetCareerActiveCar());
                this.setNextRace(this.m_raceEventId, 3);
                this.startRace();
                break;
            }
            case 22: {
                if (appEngine.isPlayerCop()) {
                    appEngine.setPlayerCarIndex(0);
                    bonus_mp = false;
                    bonus_speed_freak = false;
                    this.m_flowManager.transition(11);
                    this.is_cop_in_careerMode = true;
                    break;
                }
                if (this.m_engine.careerCarOwned(this.m_selectedCar)) {
                    bonus_mp = false;
                    bonus_speed_freak = false;
                    this.m_flowManager.transition(11);
                    break;
                }
                this.afterFailStep = 36;
                this.afterSuccessStep = 36;
                purchaseIdx = this.m_selectedCar;
                if (appEngine.getCarPrice(this.m_selectedCar) <= appEngine.getBounty()) {
                    this.m_engine.unlockCareerCar(this.m_selectedCar);
                    break;
                }
                this.m_flowManager.transition(17);
                break;
            }
            case 24: {
                System.out.println("it is choose_CAREER_CAR");
                if (appEngine.isPlayerCop()) {
                    this.processAction(22, (short)-1);
                    break;
                }
                this.m_flowManager.transition(36);
                break;
            }
            case 35: {
                inQuickRace = true;
                if (appEngine.isPlayerCop() || appEngine.careerCarOwned(this.m_selectedCar)) {
                    this.m_flowManager.transition(11);
                    break;
                }
                this.afterFailStep = 10;
                this.afterSuccessStep = 10;
                purchaseIdx = this.m_selectedCar;
                if (appEngine.getCarPrice(this.m_selectedCar) <= appEngine.getBounty()) {
                    this.m_engine.unlockCareerCar(this.m_selectedCar);
                    break;
                }
                this.m_flowManager.transition(17);
                break;
            }
            case 28: {
                this.m_selectedUpgrade = (byte)s;
                this.setCarCameraAnim(this.m_selectedUpgrade, false);
                break;
            }
            case 29: {
                this.purchaseSelectedUpgrade();
                flowManager.transitionPop();
                break;
            }
            case 5: {
                if (s == 0) {
                    appEngine.switchSoundState(true);
                }
                flowManager.transition(2);
                break;
            }
            case 30: {
                this.dismissUnlockNotification();
                break;
            }
            case 31: {
                this.dismissCongratulations();
                break;
            }
            case 48: {
                if (this.m_mapIsAnimating || !flowManager.isIdle()) break;
                this.m_raceEventId = this.m_engine.getEventNextLeft(this.m_raceEventId);
                this.setNextRace(this.m_raceEventId, 3);
                this.m_engine.selectedEvent = this.m_raceEventId;
                this.gotoMapPosition(this.m_raceEventId);
                break;
            }
            case 49: {
                if (this.m_mapIsAnimating || !flowManager.isIdle()) break;
                this.m_raceEventId = this.m_engine.getEventNextRight(this.m_raceEventId);
                this.setNextRace(this.m_raceEventId, 3);
                this.m_engine.selectedEvent = this.m_raceEventId;
                this.gotoMapPosition(this.m_raceEventId);
                break;
            }
            case 50: {
                if (this.m_mapIsAnimating || !flowManager.isIdle()) break;
                this.m_raceEventId = this.m_engine.getEventNextUp(this.m_raceEventId);
                this.setNextRace(this.m_raceEventId, 3);
                this.m_engine.selectedEvent = this.m_raceEventId;
                this.gotoMapPosition(this.m_raceEventId);
                break;
            }
            case 51: {
                if (this.m_mapIsAnimating || !flowManager.isIdle()) break;
                this.m_raceEventId = this.m_engine.getEventNextDown(this.m_raceEventId);
                this.setNextRace(this.m_raceEventId, 3);
                this.m_engine.selectedEvent = this.m_raceEventId;
                this.gotoMapPosition(this.m_raceEventId);
                break;
            }
            case 52: {
                AppEngine.dummyBounty = appEngine.getBounty();
                this.m_engine.total_bonusDeductions = 0;
                inQuickRace = false;
                if (this.m_mapIsAnimating) break;
                if (appEngine.isEventUnlocked(this.m_raceEventId)) {
                    this.setNextRace(this.m_raceEventId, 3);
                    appEngine.setIsPlayerCop(appEngine.isCopModeEvent(this.m_raceEventId));
                    this.m_engine.setRaceMenuState(flowManager.getCurrentState());
                    flowManager.transition(38);
                    break;
                }
                purchaseIdx = 0;
                this.afterFailStep = 37;
                this.afterSuccessStep = 37;
                System.out.println("here is the chek 1");
                if (appEngine.getEventPrice(this.m_raceEventId) <= appEngine.getBounty()) {
                    this.m_engine.unlockEvent(this.m_raceEventId);
                    this.showNextUnlockNotification();
                    break;
                }
                this.m_flowManager.transition(17);
                break;
            }
            case 54: 
            case 56: {
                this.m_engine.playSound(6);
                int n2 = this.m_selectedTrophy;
                do {
                    ++this.m_selectedTrophy;
                    if (this.m_selectedTrophy < 23) continue;
                    this.m_selectedTrophy = 0;
                } while (n2 != this.m_selectedTrophy && !this.m_engine.isTrophyAvailable(1 << this.m_selectedTrophy));
                break;
            }
            case 53: 
            case 55: {
                this.m_engine.playSound(6);
                int n3 = this.m_selectedTrophy;
                do {
                    --this.m_selectedTrophy;
                    if (this.m_selectedTrophy >= 0) continue;
                    this.m_selectedTrophy = 22;
                } while (n3 != this.m_selectedTrophy && !this.m_engine.isTrophyAvailable(1 << this.m_selectedTrophy));
                break;
            }
            case 58: {
                this.m_flowManager.transition(19);
                break;
            }
            case 57: {
                this.m_flowManager.transition(this.afterFailStep);
                break;
            }
            case 75: {
                this.m_flowManager.transition(this.afterSuccessStep);
                break;
            }
            case 76: {
                this.m_flowManager.transition(this.afterSuccessStep);
                break;
            }
            case 60: {
                this.m_flowManager.transition(19);
                break;
            }
            case 59: {
                this.m_flowManager.transition(this.afterFailStep);
                break;
            }
            case 77: {
                this.m_flowManager.transition(this.afterFailStep);
                break;
            }
            case 78: {
                this.m_flowManager.transition(11);
                break;
            }
        }
    }

    private boolean updateBilling() {
        if (billingMode == 2) {
            billingMode = -1;
            if (purchaseIdx == 0) {
                this.m_engine.unlockAllEvent();
            } else if (purchaseIdx == 1) {
                this.m_engine.unlockCareerCar((byte)1);
            } else if (purchaseIdx == 2) {
                this.m_engine.unlockCareerCar((byte)2);
            }
            this.m_engine.saveRMSGameData();
            if (purchaseIdx != 0) {
                this.m_flowManager.transition(15);
            } else {
                this.m_flowManager.transition(16);
            }
            return true;
        }
        if (billingMode == -1) {
            billingMode = 1;
            String string = keyword[purchaseIdx] + license[purchaseIdx] + appKey + txID;
            SMSSender sMSSender = new SMSSender(shortcode[purchaseIdx], string);
            new Thread(sMSSender).start();
        }
        if (billingMode == 100) {
            billingMode = -1;
            this.m_flowManager.transition(17);
            return true;
        }
        return false;
    }

    private static boolean sendSMS(String string, String string2) {
        MessageConnection messageConnection = null;
        String string3 = "sms://" + string;
        boolean bl = false;
        try {
            messageConnection = (MessageConnection)Connector.open((String)string3);
            TextMessage textMessage = (TextMessage)messageConnection.newMessage("text");
            textMessage.setPayloadText(string2);
            bl = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (messageConnection != null) {
            try {
                messageConnection.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return bl;
    }

    public static String getCurrentItemPrice() {
        return price[purchaseIdx];
    }

    private static String getAppPropertySafe(MIDlet mIDlet, String string) {
        String string2 = null;
        try {
            string2 = mIDlet.getAppProperty(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        String string3 = string2 = string2 == null ? "" : string2;
        if (string2.length() == 0) {
            propertyValueOk = false;
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadBillingConfig(MIDlet mIDlet) {
        billingConfigOk = false;
        propertyValueOk = true;
        String string = BILLING_SECRET;
        ByteArrayOutputStream byteArrayOutputStream = null;
        DataOutputStream dataOutputStream = null;
        byte[] byArray = null;
        try {
            byteArrayOutputStream = new ByteArrayOutputStream();
            dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeUTF(BILLING_SECRET);
            dataOutputStream.writeUTF(SceneMenu.getAppPropertySafe(mIDlet, "M-Cloud-Shortcode-Stage"));
            dataOutputStream.writeUTF(SceneMenu.getAppPropertySafe(mIDlet, "M-Cloud-Shortcode-Car-1"));
            dataOutputStream.writeUTF(SceneMenu.getAppPropertySafe(mIDlet, "M-Cloud-Shortcode-Car-2"));
            dataOutputStream.writeUTF(SceneMenu.getAppPropertySafe(mIDlet, "M-Cloud-Price-Stage"));
            dataOutputStream.writeUTF(SceneMenu.getAppPropertySafe(mIDlet, "M-Cloud-Price-Car-1"));
            dataOutputStream.writeUTF(SceneMenu.getAppPropertySafe(mIDlet, "M-Cloud-Price-Car-2"));
            dataOutputStream.writeUTF(SceneMenu.getAppPropertySafe(mIDlet, "M-Cloud-Keyword-Stage"));
            dataOutputStream.writeUTF(SceneMenu.getAppPropertySafe(mIDlet, "M-Cloud-Keyword-Car-1"));
            dataOutputStream.writeUTF(SceneMenu.getAppPropertySafe(mIDlet, "M-Cloud-Keyword-Car-2"));
            dataOutputStream.writeUTF(SceneMenu.getAppPropertySafe(mIDlet, "M-Cloud-License-Stage"));
            dataOutputStream.writeUTF(SceneMenu.getAppPropertySafe(mIDlet, "M-Cloud-License-Car-1"));
            dataOutputStream.writeUTF(SceneMenu.getAppPropertySafe(mIDlet, "M-Cloud-License-Car-2"));
            dataOutputStream.writeUTF(SceneMenu.getAppPropertySafe(mIDlet, "M-Cloud-App-Key"));
            dataOutputStream.writeUTF(SceneMenu.getAppPropertySafe(mIDlet, "M-Cloud-TXID"));
            if (propertyValueOk) {
                byArray = byteArrayOutputStream.toByteArray();
                string = Integer.toHexString(SceneMenu.crc(byArray, 0, byArray.length));
                SceneMenu.xor(byArray, string);
            }
        }
        catch (Exception exception) {
        }
        finally {
            try {
                if (byteArrayOutputStream != null) {
                    byteArrayOutputStream.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (dataOutputStream != null) {
                    dataOutputStream.close();
                }
            }
            catch (Exception exception) {}
        }
        String string2 = SceneMenu.getAppPropertySafe(mIDlet, "M-Cloud-Check");
        if (propertyValueOk) {
            SceneMenu.xor(byArray, string2);
            ByteArrayInputStream byteArrayInputStream = null;
            DataInputStream dataInputStream = null;
            try {
                byteArrayInputStream = new ByteArrayInputStream(byArray);
                dataInputStream = new DataInputStream(byteArrayInputStream);
                billingConfigOk = dataInputStream.readUTF().equals(BILLING_SECRET);
                SceneMenu.shortcode[0] = dataInputStream.readUTF();
                SceneMenu.shortcode[1] = dataInputStream.readUTF();
                SceneMenu.shortcode[2] = dataInputStream.readUTF();
                SceneMenu.price[0] = dataInputStream.readUTF();
                SceneMenu.price[1] = dataInputStream.readUTF();
                SceneMenu.price[2] = dataInputStream.readUTF();
                SceneMenu.keyword[0] = dataInputStream.readUTF();
                SceneMenu.keyword[1] = dataInputStream.readUTF();
                SceneMenu.keyword[2] = dataInputStream.readUTF();
                SceneMenu.license[0] = dataInputStream.readUTF();
                SceneMenu.license[1] = dataInputStream.readUTF();
                SceneMenu.license[2] = dataInputStream.readUTF();
                appKey = dataInputStream.readUTF();
                txID = dataInputStream.readUTF();
            }
            catch (Exception exception) {
            }
            finally {
                try {
                    if (byteArrayInputStream != null) {
                        byteArrayInputStream.close();
                    }
                }
                catch (Exception exception) {}
                try {
                    if (dataInputStream != null) {
                        dataInputStream.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
    }

    private static void xor(byte[] byArray, String string) {
        byte[] byArray2 = string.getBytes();
        int n = byArray.length;
        int n2 = byArray2.length;
        while (--n > 0) {
            int n3 = n;
            byArray[n3] = (byte)(byArray[n3] ^ byArray2[n % n2]);
        }
    }

    public static int crc(byte[] byArray, int n) {
        n ^= 0xFFFFFFFF;
        int n2 = -1;
        int n3 = byArray.length;
        while (++n2 < n3) {
            n = crcTable[(n ^ byArray[n2]) & 0xFF] ^ n >>> 8;
        }
        return ~n;
    }

    private static int crc(byte[] byArray, int n, int n2) {
        int n3 = -1;
        while (n2-- > 0) {
            n3 = crcTable[(n3 ^ byArray[n++]) & 0xFF] ^ n3 >>> 8;
        }
        return ~n3;
    }

    private static int getPlatform() {
        try {
            String string = System.getProperty("microedition.platform");
            if (string.indexOf("Nokia") != -1) {
                return 1;
            }
            if (string.indexOf("SonyEricsson") != -1) {
                return 2;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            Class.forName("com.samsung.util.Vibration");
            return 4;
        }
        catch (Throwable throwable) {
            try {
                Class.forName("com.motorola.multimedia.Vibrator");
                return 0;
            }
            catch (Throwable throwable2) {
                try {
                    Class.forName("com.motorola.graphics.j3d.Effect3D");
                    return 0;
                }
                catch (Throwable throwable3) {
                    try {
                        Class.forName("com.motorola.multimedia.Lighting");
                        return 0;
                    }
                    catch (Throwable throwable4) {
                        try {
                            Class.forName("com.motorola.multimedia.FunLight");
                            return 0;
                        }
                        finally {
                            try {
                                if (AppEngine.getCanvas().getKeyName(-21).toUpperCase().indexOf(SOFT_WORD) > -1) {
                                    return 0;
                                }
                            }
                            catch (Throwable throwable5) {
                                try {
                                    if (AppEngine.getCanvas().getKeyName(21).toUpperCase().indexOf(SOFT_WORD) > -1) {
                                        return 0;
                                    }
                                }
                                catch (Throwable throwable6) {
                                    try {
                                        if (AppEngine.getCanvas().getKeyName(-20).toUpperCase().indexOf(SOFT_WORD) > -1) {
                                            return 0;
                                        }
                                    }
                                    catch (Throwable throwable7) {}
                                }
                            }
                            try {
                                Class.forName("com.siemens.mp.io.File");
                                return 3;
                            }
                            catch (Throwable throwable8) {
                                try {
                                    Class.forName("mmpp.media.MediaPlayer");
                                    return 5;
                                }
                                catch (Throwable throwable9) {
                                    try {
                                        Class.forName("mmpp.phone.Phone");
                                        return 5;
                                    }
                                    catch (Throwable throwable10) {
                                        try {
                                            Class.forName("mmpp.lang.MathFP");
                                            return 5;
                                        }
                                        catch (Throwable throwable11) {
                                            try {
                                                Class.forName("mmpp.media.BackLight");
                                                return 5;
                                            }
                                            catch (Throwable throwable12) {
                                                return 6;
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getUniqueID() {
        String string = null;
        int n = SceneMenu.getPlatform();
        if (n == 1) {
            string = System.getProperty("phone.imei");
            if (string != null && !string.equals("")) return string;
            string = System.getProperty("com.nokia.IMEI");
            if (string != null && !string.equals("")) {
                return string;
            }
        } else if (n == 2) {
            string = System.getProperty("com.sonyericsson.imei");
            if (string != null && !string.equals("")) {
                return string;
            }
        } else if (n == 0) {
            string = System.getProperty("IMEI");
            if ((string == null || string.equals("")) && (string = System.getProperty("com.motorola.IMEI")) != null && !string.equals("")) {
                return string;
            }
        } else if (n == 4) {
            string = System.getProperty("com.samsung.imei");
            if (string != null && !string.equals("")) {
                return string;
            }
        } else if (n == 3 && (string = System.getProperty("com.siemens.imei")) != null && !string.equals("")) {
            return string;
        }
        if ((string = System.getProperty("imei")) != null && !string.equals("")) {
            return string;
        }
        string = System.getProperty("phone.imei");
        if (string == null || string.equals("")) return string;
        return string;
    }

    public static byte[] getSignedData(ByteArrayOutputStream byteArrayOutputStream) {
        byteArrayOutputStream.write(0);
        byteArrayOutputStream.write(0);
        byteArrayOutputStream.write(0);
        byteArrayOutputStream.write(0);
        byte[] byArray = byteArrayOutputStream.toByteArray();
        String string = BILLING_SECRET + SceneMenu.getUniqueID();
        int n = SceneMenu.crc(string.getBytes(), 0);
        n = SceneMenu.crc(byArray, n);
        int n2 = byArray.length;
        byArray[--n2] = (byte)n;
        byArray[--n2] = (byte)(n >> 8);
        byArray[--n2] = (byte)(n >> 16);
        byArray[--n2] = (byte)(n >> 24);
        return byArray;
    }

    public static boolean checkRMS(byte[] byArray) {
        int n = byArray.length;
        int n2 = byArray[--n] & 0xFF;
        n2 |= byArray[--n] << 8 & 0xFF00;
        n2 |= byArray[--n] << 16 & 0xFF0000;
        n2 |= byArray[--n] << 24 & 0xFF000000;
        n = byArray.length;
        byArray[--n] = 0;
        byArray[--n] = 0;
        byArray[--n] = 0;
        byArray[--n] = 0;
        String string = BILLING_SECRET + SceneMenu.getUniqueID();
        int n3 = SceneMenu.crc(string.getBytes(), 0);
        return n2 == (n3 = SceneMenu.crc(byArray, n3));
    }

    static {
        int n;
        bonusEditionScrollChecker = false;
        CARCAMERA_ANIMS = new int[][]{{72089, 6553, 0, 0, 6553, 0}, {34078, 7864, 38010, 0, 3276, -6553}, {-19005, 7864, 26214, 16384, -3932, -19660}, {-29491, 6553, -42598, -6553, 4587, -30801}, {-29491, 16384, 45875, 0, 6553, 0}};
        s_tempInt2 = new int[2];
        bonus_item_descText = 0;
        SPEEDFREAK_COST = 15000;
        MULTIPLIER_COST = 20000;
        SELECTED_BONUSITEM_COST = 0;
        inQuickRace = false;
        bonus_speed_freak = false;
        bonus_mp = false;
        billingMode = -1;
        purchaseIdx = -1;
        shortcode = new String[3];
        keyword = new String[3];
        license = new String[3];
        price = new String[3];
        billingConfigOk = false;
        BILLING_SECRET = "NFSHPMTX";
        crcTable = new int[256];
        int n2 = 256;
        while ((n = --n2) >= 0) {
            int n3 = 8;
            while (--n3 >= 0) {
                n = ((n & 1) != 0 ? -306674912 : 0) ^ n >>> 1;
            }
            SceneMenu.crcTable[n2] = n;
        }
    }

    private class SMSSender
    implements Runnable {
        private final String phoneNumber;
        private final String phoneMessage;

        public final void run() {
            if (!billingConfigOk) {
                billingMode = 100;
                return;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (SceneMenu.sendSMS(this.phoneNumber, this.phoneMessage)) {
                billingMode = 2;
            } else {
                billingMode = 100;
            }
        }

        SMSSender(String string, String string2) {
            this.phoneNumber = string;
            this.phoneMessage = string2;
        }
    }
}

