/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Map {
    public static final int obj_none = 0;
    public static final int obj_unit = 1;
    public static final int obj_tower = 2;
    public static final int obj_capital = 3;
    public static final int obj_gold = 4;
    public static final int obj_tree = 5;
    public static int hex_half_widht_global = 0;
    public static int hex_half_height_global = 0;
    public static int hex_half_widht_local = 0;
    public static int hex_half_height_local = 0;
    public static int local_map_width = 4;
    public static int local_map_height = 0;
    public static int global_DX = 0;
    public static int global_DY = 0;
    public static int[][] race;
    public static int[][] territory;
    public static int[][] obj_type;
    public static int[][] obj_number;
    public static int activeHexX;
    public static int activeHexY;
    public static boolean global;
    public static Image[] hexIm;
    public static Image waterIm;
    public static Image waterLeft;
    public static Image waterRight;
    public static Image waterDownLeft;
    public static Image waterDownRight;
    public static Image hexFrameIm;

    public static void loadImages() {
        hexIm = new Image[5];
        try {
            Map.hexIm[0] = Image.createImage((String)"/h_hex.png");
            Map.hexIm[1] = Image.createImage((String)"/o_hex.png");
            Map.hexIm[2] = Image.createImage((String)"/e_hex.png");
            Map.hexIm[3] = Image.createImage((String)"/u_hex.png");
            Map.hexIm[4] = Image.createImage((String)"/n_hex.png");
            waterIm = Image.createImage((String)"/t_water.png");
            waterLeft = Image.createImage((String)"/wat_left.png");
            waterRight = Image.createImage((String)"/wat_right.png");
            waterDownLeft = Image.createImage((String)"/wat_down_left.png");
            waterDownRight = Image.createImage((String)"/wat_down_right.png");
            hexFrameIm = Image.createImage((String)"/obvodka_hexa.png");
            return;
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
            return;
        }
    }

    public static void loadMap() {
        int n;
        Players.num_of_players = 0;
        for (n = 0; n < Players.race_active.length; ++n) {
            Players.race_active[n] = false;
        }
        global = false;
        hex_half_widht_global = (Game.W - 10 - 10) / (MapsInit.race[Game.LEV][0].length + 1 << 1);
        hex_half_height_global = hex_half_widht_global * 1000 / 866 / 2;
        if (Game.H - 120 < hex_half_height_global * 3 * MapsInit.race[Game.LEV].length) {
            hex_half_height_global = (Game.H - 120) / MapsInit.race[Game.LEV].length / 3;
            hex_half_widht_global = (hex_half_height_global * 866 << 1) / 1000;
        }
        hex_half_widht_local = Game.W / 2 / local_map_width;
        hex_half_height_local = hex_half_widht_local * 1000 / 866 / 2;
        race = null;
        territory = null;
        obj_number = null;
        obj_type = null;
        System.gc();
        race = new int[MapsInit.race[Game.LEV].length][MapsInit.race[Game.LEV][0].length];
        territory = new int[MapsInit.race[Game.LEV].length][MapsInit.race[Game.LEV][0].length];
        obj_type = new int[MapsInit.race[Game.LEV].length][MapsInit.race[Game.LEV][0].length];
        obj_number = new int[MapsInit.race[Game.LEV].length][MapsInit.race[Game.LEV][0].length];
        for (n = 0; n < MapsInit.race[Game.LEV].length; ++n) {
            for (int i = 0; i < MapsInit.race[Game.LEV][0].length; ++i) {
                Map.race[n][i] = MapsInit.race[Game.LEV][n][i];
                Map.territory[n][i] = 10;
                if (race[n][i] == 100 || race[n][i] == 4 || Players.race_active[race[n][i]]) continue;
                ++Players.num_of_players;
                Players.race_active[Map.race[n][i]] = true;
            }
        }
        activeHexX = race[0].length / 2;
        activeHexY = race.length / 2;
        if (Game.LEV < 6) {
            if (Game.LEV == 4) {
                global_DX = (Game.W - 30 - hex_half_widht_global * ((race[0].length << 1) + 1)) / 2;
                global_DY = (Game.H - 70 - hex_half_height_global * (race.length * 3 + 1)) / 2;
            } else if (Game.LEV == 5) {
                global_DX = (Game.W - 70 - hex_half_widht_global * ((race[0].length << 1) + 1)) / 2;
                global_DY = (Game.H - 120 - hex_half_height_global * (race.length * 3 + 1)) / 2;
            } else {
                global_DX = (Game.W - 70 - hex_half_widht_global * ((race[0].length << 1) + 1)) / 2;
                global_DY = (Game.H - 75 - hex_half_height_global * (race.length * 3 + 1)) / 2;
            }
        } else {
            global_DX = (Game.W - 90 - hex_half_widht_global * ((race[0].length << 1) + 1)) / 2;
            global_DY = (Game.H - 190 - hex_half_height_global * (race.length * 3 + 1)) / 2;
        }
        Gold.init();
        Tree.init();
        Unit.init();
        Tower.init();
        Players.initPlayers();
        Players.step = 0;
        TurnCounter.newTurn();
        for (n = 0; n < Players.num_of_players; ++n) {
            Players.players[n].recountBalance();
        }
        System.out.println("active" + Players.num_of_players);
    }

    public static void drawGlobalMap(Graphics graphics) {
        graphics.setClip(0, 0, Game.W, Game.H);
        graphics.setColor(0);
        graphics.fillRect(0, 0, Game.W, Game.H);
        Map.drawWater(graphics);
        for (int i = 0; i < race.length; ++i) {
            for (int j = 0; j < race[0].length; ++j) {
                if (race[i][j] == 100) continue;
                Map.drawGlobalHex(graphics, i, j);
            }
        }
        Map.drawFrames(graphics);
        Hud.draw(graphics);
    }

    public static void drawWater(Graphics graphics) {
        for (int i = 0; i < Game.H / waterIm.getHeight() + 1; ++i) {
            for (int j = 0; j < Game.W / waterIm.getWidth() + 1; ++j) {
                graphics.drawImage(waterIm, j * waterIm.getWidth(), i * waterIm.getHeight(), 20);
            }
        }
    }

    public static void drawLocalMap(Graphics graphics) {
        int n;
        int n2;
        Map.drawWater(graphics);
        local_map_width = Game.W / hexIm[0].getWidth() + 2;
        hex_half_widht_local = hexIm[0].getWidth() / 2;
        hex_half_height_local = hexIm[0].getHeight() / 4;
        local_map_height = Game.H / hex_half_height_local / 3 + 2;
        for (n2 = activeHexY - local_map_height / 2; n2 <= activeHexY + local_map_height / 2; n2 += 2) {
            for (n = activeHexX - local_map_width / 2; n <= activeHexX + local_map_width / 2; ++n) {
                if (n < 0 || n >= race[0].length || n2 < 0 || n2 >= race.length || race[n2][n] == 100) continue;
                Map.drawLocalHex(graphics, n2, n);
            }
        }
        for (n2 = activeHexY - local_map_height / 2 + 1; n2 <= activeHexY + local_map_height / 2 - 1; n2 += 2) {
            for (n = activeHexY % 2 == 0 ? activeHexX - local_map_width / 2 - 1 : activeHexX - local_map_width / 2; n <= (activeHexY % 2 == 0 ? activeHexX + local_map_width / 2 : activeHexX + local_map_width / 2 + 1 + 2); ++n) {
                if (n < 0 || n >= race[0].length || n2 < 0 || n2 >= race.length || race[n2][n] == 100) continue;
                Map.drawLocalHex(graphics, n2, n);
            }
        }
        graphics.drawImage(hexFrameIm, Game.W / 2, Game.H / 2, 3);
        Map.drawObjects(graphics);
        Hud.draw(graphics);
    }

    public static void drawObjects(Graphics graphics) {
        for (int i = 0; i < race.length; ++i) {
            for (int j = 0; j < race[0].length; ++j) {
                if (race[i][j] == 100) continue;
                try {
                    switch (obj_type[i][j]) {
                        case 1: {
                            Unit.drawOne(graphics, obj_number[i][j]);
                            break;
                        }
                        case 3: {
                            Capital.drawOne(graphics, obj_number[i][j]);
                            break;
                        }
                        case 4: {
                            Gold.drawOne(graphics, obj_number[i][j]);
                            break;
                        }
                        case 5: {
                            Tree.drawOne(graphics, obj_number[i][j]);
                            break;
                        }
                        case 2: {
                            Tower.drawOne(graphics, obj_number[i][j]);
                        }
                    }
                    continue;
                }
                catch (Exception exception) {
                    Exception exception2 = exception;
                    exception.printStackTrace();
                    if (j <= activeHexX + local_map_width / 2 && j >= activeHexX - local_map_width / 2 && i <= activeHexY + local_map_height / 2 && i >= activeHexY - local_map_height / 2) continue;
                    return;
                }
            }
        }
    }

    public static void drawLocalHex(Graphics graphics, int n, int n2) {
        int n3 = hex_half_widht_local;
        int n4 = hex_half_height_local;
        int n5 = Game.W / 2 + n3 * 2 * (n2 - activeHexX);
        if ((n - activeHexY >= 0 ? n - activeHexY : activeHexY - n) % 2 == 1) {
            n5 = n % 2 == 0 ? (n5 -= n3) : (n5 += n3);
        }
        int n6 = Game.H / 2 + n4 * 3 * (n - activeHexY);
        try {
            graphics.drawImage(hexIm[race[n][n2]], n5, n6, 3);
        }
        catch (Exception exception) {
            System.out.println(race[n][n2]);
            exception.printStackTrace();
        }
        if (n2 == 0 || race[n][n2 - 1] == 100) {
            graphics.drawImage(waterLeft, n5 - n3, n6 - n4, 24);
        }
        if (n2 == race[0].length - 1 || race[n][n2 + 1] == 100) {
            graphics.drawImage(waterRight, n5 + n3, n6 - n4, 20);
        }
        if (n == race.length - 1) {
            graphics.drawImage(waterDownLeft, n5, n6 + n4 - 2, 24);
        } else if (n2 == 0) {
            if (n % 2 == 0) {
                graphics.drawImage(waterDownLeft, n5, n6 + n4 - 2, 24);
            }
        } else if (race[n + 1][n % 2 == 0 ? n2 - 1 : n2] == 100) {
            graphics.drawImage(waterDownLeft, n5, n6 + n4 - 2, 24);
        }
        if (n == race.length - 1) {
            graphics.drawImage(waterDownRight, n5, n6 + n4 - 1, 20);
            return;
        }
        if (n2 == race[0].length - 1) {
            if (n % 2 == 1) {
                graphics.drawImage(waterDownRight, n5, n6 + n4 - 1, 20);
                return;
            }
        } else if (race[n + 1][n % 2 == 0 ? n2 : n2 + 1] == 100) {
            graphics.drawImage(waterDownRight, n5, n6 + n4 - 1, 20);
        }
    }

    public static void drawGlobalHex(Graphics graphics, int n, int n2) {
        int n3;
        int n4;
        if (Game.LEV != 9) {
            n4 = hex_half_widht_global + 2;
            n3 = hex_half_height_global + 2;
        } else {
            n4 = hex_half_widht_global + 1;
            n3 = hex_half_height_global + 1;
        }
        int n5 = n % 2 == 0 ? n4 * (1 + (n2 << 1)) : n4 * (2 + (n2 << 1));
        int n6 = n3 * (2 + n * 3);
        graphics.setColor(Data.RACECOLOR[race[n][n2]]);
        graphics.fillTriangle(n5 += 10 + global_DX, n6 += 40 + global_DY, n5 - n4, n6 - n3, n5, n6 - n3 * 2);
        graphics.fillTriangle(n5, n6, n5, n6 - n3 * 2, n5 + n4, n6 - n3);
        graphics.fillTriangle(n5, n6, n5 + n4, n6 - n3, n5 + n4, n6 + n3);
        graphics.fillTriangle(n5, n6, n5 + n4, n6 + n3, n5, n6 + n3 * 2);
        graphics.fillTriangle(n5, n6, n5, n6 + n3 * 2, n5 - n4, n6 + n3);
        graphics.fillTriangle(n5, n6, n5 - n4, n6 + n3, n5 - n4, n6 - n3);
        graphics.setColor(65280);
        if (race[n][n2] == Players.players[Players.turns].race && obj_type[n][n2] == 1 && Unit.is_active[obj_number[n][n2]]) {
            graphics.fillArc(n5, n6, 0, 0, 0, 360);
        }
    }

    public static void drawFrames(Graphics graphics) {
        int n;
        int n2;
        if (Game.LEV != 9) {
            n2 = hex_half_widht_global + 2;
            n = hex_half_height_global + 2;
        } else {
            n2 = hex_half_widht_global + 1;
            n = hex_half_height_global + 1;
        }
        int n3 = activeHexY % 2 == 0 ? n2 * (1 + (activeHexX << 1)) : n2 * (2 + (activeHexX << 1));
        int n4 = n * (2 + activeHexY * 3);
        graphics.setColor(0xFFFF00);
        graphics.drawLine((n3 += 10 + global_DX) - n2, (n4 += 40 + global_DY) - n, n3, n4 - n * 2);
        graphics.drawLine(n3, n4 - n * 2, n3 + n2, n4 - n);
        graphics.drawLine(n3 + n2, n4 - n, n3 + n2, n4 + n);
        graphics.drawLine(n3 + n2, n4 + n, n3, n4 + n * 2);
        graphics.drawLine(n3, n4 + n * 2, n3 - n2, n4 + n);
        graphics.drawLine(n3 - n2, n4 + n, n3 - n2, n4 - n);
        graphics.drawLine(n3 - n2 - 1, n4 - n, n3, n4 - n * 2 - 1);
        graphics.drawLine(n3, n4 - n * 2 - 1, n3 + n2 + 1, n4 - n);
        graphics.drawLine(n3 + n2 + 1, n4 - n, n3 + n2 + 1, n4 + n);
        graphics.drawLine(n3 + n2 + 1, n4 + n, n3, n4 + n * 2 + 1);
        graphics.drawLine(n3, n4 + n * 2 + 1, n3 - n2 - 1, n4 + n);
        graphics.drawLine(n3 - n2 - 1, n4 + n, n3 - n2 - 1, n4 - n);
        n2 = (n2 << 1) * local_map_width;
        n = n2 * Game.H / Game.W;
        graphics.drawLine(n3 - n2 / 2, n4 - n / 2, n3 + n2 / 2, n4 - n / 2);
        graphics.drawLine(n3 - n2 / 2, n4 + n / 2, n3 + n2 / 2, n4 + n / 2);
        graphics.drawLine(n3 - n2 / 2, n4 - n / 2, n3 - n2 / 2, n4 + n / 2);
        graphics.drawLine(n3 + n2 / 2, n4 - n / 2, n3 + n2 / 2, n4 + n / 2);
    }

    public static void jumpLeft() {
        if (activeHexX == 0) {
            return;
        }
        int n = activeHexX;
        do {
            if (race[activeHexY][--n] == 100) continue;
            activeHexX = n;
            return;
        } while (race[activeHexY][n] == 100 && n > 0);
    }

    public static void jumpRight() {
        if (activeHexX == race[0].length - 1) {
            return;
        }
        int n = activeHexX;
        do {
            if (race[activeHexY][++n] == 100) continue;
            activeHexX = n;
            return;
        } while (race[activeHexY][n] == 100 && n < race[0].length - 1);
    }

    public static void jumpUp() {
        if (activeHexY == 0) {
            return;
        }
        int n = activeHexY;
        do {
            if (race[--n][activeHexX] == 100) continue;
            activeHexY = n;
            return;
        } while (race[n][activeHexX] == 100 && n > 0);
    }

    public static void jumpDown() {
        if (activeHexY == race.length - 1) {
            return;
        }
        int n = activeHexY;
        do {
            if (race[++n][activeHexX] == 100) continue;
            activeHexY = n;
            return;
        } while (race[n][activeHexX] == 100 && n < race.length - 1);
    }

    public static void jumpLeftUp() {
        if (activeHexY == 0 || activeHexY % 2 == 0 && activeHexX == 0) {
            return;
        }
        int n = activeHexX;
        int n2 = activeHexY;
        do {
            if (n2 % 2 == 0) {
                --n;
            }
            if (race[--n2][n] == 100) continue;
            activeHexX = n;
            activeHexY = n2;
            return;
        } while (race[n2][n] == 100 && n2 > 0 && (n > 0 || n2 % 2 == 1));
    }

    public static void jumpRightUp() {
        if (activeHexY == 0 || activeHexY % 2 == 1 && activeHexX == race[0].length - 1) {
            return;
        }
        int n = activeHexX;
        int n2 = activeHexY;
        do {
            if (n2 % 2 == 1) {
                ++n;
            }
            if (race[--n2][n] == 100) continue;
            activeHexX = n;
            activeHexY = n2;
            return;
        } while (race[n2][n] == 100 && n2 > 0 && (n < race[0].length - 1 || n2 % 2 == 0));
    }

    public static void jumpLeftDown() {
        if (activeHexY == race.length - 1 || activeHexY % 2 == 0 && activeHexX == 0) {
            return;
        }
        int n = activeHexX;
        int n2 = activeHexY;
        do {
            if (n2 % 2 == 0) {
                --n;
            }
            if (race[++n2][n] == 100) continue;
            activeHexX = n;
            activeHexY = n2;
            return;
        } while (race[n2][n] == 100 && n2 < race.length - 1 && (n > 0 || n2 % 2 == 1));
    }

    public static void jumpRightDown() {
        if (activeHexY == race.length - 1 || activeHexY % 2 == 1 && activeHexX == race[0].length - 1) {
            return;
        }
        int n = activeHexX;
        int n2 = activeHexY;
        do {
            if (n2 % 2 == 1) {
                ++n;
            }
            if (race[++n2][n] == 100) continue;
            activeHexX = n;
            activeHexY = n2;
            return;
        } while (race[n2][n] == 100 && n2 < race.length - 1 && (n < race[0].length - 1 || n2 % 2 == 0));
    }

    static {
        activeHexX = 0;
        activeHexY = 0;
    }
}

