/*
 * Decompiled with CFR 0.152.
 */
package com.JavArt.custom.media.MMAPI;

import JAbrick.JAgamecanvas;
import com.JavArt.tools.Utils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Vector;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerListener;

public class gamesounds
implements Runnable,
PlayerListener {
    Thread thethread;
    boolean noThread = false;
    long mediaPosition = -1L;
    JAgamecanvas canvas = null;
    private static boolean themeStarted = false;
    public static boolean playingTheme = false;
    public static boolean musicstate = false;
    public static boolean soundstate = false;
    public static boolean midsupport = false;
    public static boolean amrsupport = false;
    public static boolean mmfsupport = false;
    public static boolean wavsupport = false;
    private static Player currentPlayer = null;
    private static String soundPath;
    private static final String SOUNDPAK = "SND.PAK";
    private static int themeIndex;
    private static final String[] Themes;
    private static final String[] FXfile;
    private static Vector FXbuff;
    String FXType = "amr";
    String FXMime = "amr";
    boolean started = false;
    boolean forcedestroy = false;
    int newTune = -1;
    public static boolean sound_exception;

    public gamesounds(String Path, JAgamecanvas c) {
        this.canvas = c;
        soundPath = Path;
        soundstate = true;
        musicstate = true;
        String[] sup = Manager.getSupportedContentTypes(null);
        for (int i = 0; i < sup.length; ++i) {
            if (sup[i].indexOf("mid") != -1) {
                midsupport = true;
            }
            if (sup[i].compareTo("audio/amr") == 0) {
                amrsupport = true;
            }
            if (sup[i].compareTo("audio/mmf") == 0) {
                mmfsupport = true;
            }
            if (sup[i].indexOf("wav") == -1) continue;
            wavsupport = true;
        }
        if (!amrsupport) {
            if (wavsupport) {
                this.FXType = "wav";
                this.FXMime = "x-wav";
            } else if (mmfsupport) {
                this.FXType = "mmf";
                this.FXMime = "mmf";
            }
        }
        playingTheme = false;
        themeStarted = false;
        if (!(amrsupport || wavsupport || mmfsupport)) {
            soundstate = false;
        }
        if (!midsupport) {
            musicstate = false;
        }
        this.preload();
        if (sound_exception) {
            return;
        }
        if (this.thethread == null && !this.noThread) {
            this.thethread = new Thread(this);
            this.thethread.start();
        }
    }

    public void playSoundFX(int nT) {
        if (!soundstate) {
            return;
        }
        this.newTune = nT;
        if (this.noThread) {
            this.stopCurrentSoundFX();
            this.createPlayer(0, this.newTune, this.FXType, this.FXMime);
            try {
                currentPlayer.start();
            }
            catch (Throwable ex) {
                this.stopCurrentSoundFX();
            }
        } else {
            this.started = true;
        }
    }

    public void stopCurrentSoundFX() {
        if (currentPlayer != null) {
            try {
                if (currentPlayer.getState() == 400) {
                    currentPlayer.stop();
                }
                currentPlayer.deallocate();
                currentPlayer.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            currentPlayer = null;
        }
    }

    public void pushMediaTime() {
        if (playingTheme && musicstate && currentPlayer != null) {
            this.mediaPosition = currentPlayer.getMediaTime();
            this.destroyTheme();
        }
    }

    public void popMediaTime() {
        try {
            if (this.mediaPosition != -1L && musicstate) {
                this.playTheme();
                currentPlayer.setMediaTime(this.mediaPosition);
                Thread.sleep(250L);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.mediaPosition = -1L;
    }

    public void playTheme(int index) {
        if (index <= 2 && soundstate || !musicstate && !soundstate) {
            return;
        }
        this.newTune = -1;
        themeIndex = index + FXfile.length;
        playingTheme = true;
        themeStarted = false;
        if (this.noThread) {
            this.playTheme();
        }
    }

    public void playTheme() {
        if (currentPlayer != null) {
            this.stopCurrentSoundFX();
        }
        this.createPlayer(0, themeIndex, "mid", "midi");
        try {
            if (themeIndex <= FXfile.length + 2) {
                currentPlayer.addPlayerListener((PlayerListener)this);
            }
            currentPlayer.start();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void destroyTheme() {
        playingTheme = false;
        themeStarted = true;
        if (this.noThread) {
            this.stopCurrentSoundFX();
        }
    }

    public boolean getThemeState() {
        return musicstate;
    }

    public boolean getSoundState() {
        return soundstate;
    }

    public static void setSoundState(boolean soundsstate) {
    }

    public void ballimpact() {
        this.playSoundFX(0);
    }

    public void bonus() {
        this.playSoundFX(1);
    }

    public void brickexp() {
        this.playSoundFX(2);
    }

    public void demonexp() {
        this.playSoundFX(3);
    }

    public void monsterexp() {
        this.playSoundFX(4);
    }

    public void death() {
        this.playSoundFX(5);
    }

    public static void managesounds(boolean aMusicstate, boolean aSoundsstate) {
        musicstate = aMusicstate;
        soundstate = aSoundsstate;
    }

    public void preload() {
        byte[] t;
        int c;
        JAgamecanvas.loadbar = 0;
        this.canvas.flushGraphics();
        try {
            if (!Utils.copySoundPack2RAM(soundPath + SOUNDPAK)) {
                musicstate = false;
                soundstate = false;
                sound_exception = true;
                return;
            }
        }
        catch (Exception _E) {
            return;
        }
        FXbuff.setSize(FXfile.length + Themes.length);
        int step = 100 / FXbuff.size();
        for (c = 0; c < FXfile.length; ++c) {
            t = Utils.LoadSound(soundPath + FXfile[c] + "." + this.FXType, soundPath);
            FXbuff.setElementAt(t, c);
            JAgamecanvas.loadbar += step;
            this.canvas.flushGraphics();
        }
        themeIndex = FXfile.length;
        for (c = 0; c < Themes.length; ++c) {
            t = Utils.LoadSound(soundPath + Themes[c], soundPath);
            FXbuff.setElementAt(t, FXfile.length + c);
            JAgamecanvas.loadbar += step;
            this.canvas.flushGraphics();
        }
        JAgamecanvas.loadbar = 100;
        this.canvas.flushGraphics();
        Utils.destroySoundPak();
    }

    public boolean createPlayer(int i, int ttp, String type, String mime) {
        InputStream bis = null;
        try {
            if (FXbuff.size() > 0 && FXbuff.elementAt(ttp) != null) {
                bis = new ByteArrayInputStream((byte[])FXbuff.elementAt(ttp));
            }
            if (bis == null) {
                bis = this.getClass().getResourceAsStream(soundPath + FXfile[ttp] + "." + type);
            }
            currentPlayer = Manager.createPlayer(bis, (String)("audio/" + mime));
            currentPlayer.setLoopCount(1);
        }
        catch (Exception _E) {
            this.stopCurrentSoundFX();
            return false;
        }
        try {
            currentPlayer.realize();
        }
        catch (Exception _E) {
            this.stopCurrentSoundFX();
            return false;
        }
        return true;
    }

    public void run() {
        int loopDelay = 50;
        while (true) {
            long loopStartTime = System.currentTimeMillis();
            if (playingTheme) {
                if (!themeStarted) {
                    this.playTheme();
                    themeStarted = true;
                }
            } else if (themeStarted) {
                this.stopCurrentSoundFX();
                themeStarted = false;
            }
            if (this.started) {
                this.started = false;
                this.stopCurrentSoundFX();
                this.createPlayer(0, this.newTune, this.FXType, this.FXMime);
                try {
                    currentPlayer.start();
                }
                catch (Exception ex) {
                    this.stopCurrentSoundFX();
                }
            }
            long loopTime = System.currentTimeMillis() - loopStartTime;
            if (System.currentTimeMillis() - loopStartTime >= (long)loopDelay) continue;
            try {
                Thread.sleep((long)loopDelay - loopTime);
            }
            catch (Exception _e) {
            }
        }
    }

    public void playerUpdate(Player player, String event, Object eventData) {
        if (!playingTheme) {
            return;
        }
        if (event == "endOfMedia" || event == "stopped") {
            try {
                currentPlayer.start();
                currentPlayer.setMediaTime(0L);
                Thread.sleep(250L);
            }
            catch (Exception _E) {
                // empty catch block
            }
        }
    }

    static {
        themeIndex = -1;
        Themes = new String[]{"theme.mid"};
        FXfile = new String[]{"touch", "bonus", "brickexp", "demonexp", "monsterexp", "death"};
        FXbuff = new Vector();
        sound_exception = false;
    }
}

