/*
 * Decompiled with CFR 0.152.
 */
package com.JavArt.gui;

import JAbrick.JAgamecanvas;
import com.JavArt.gui.JAFont;
import com.JavArt.tools.Utils;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class messagebox {
    private String talkName = null;
    private Image talkIcon = null;
    private int talkFrames = 0;
    private int talkFrame = 0;
    public int boxLeft;
    public int boxTop;
    public int boxW;
    public int boxH;
    private int borderH;
    private int borderU;
    private int borderD;
    private int numWords;
    private int numLines;
    private int maxlines;
    private int numpages;
    private int curPage;
    private int curDotNum = 0;
    private boolean hide;
    private int arcW;
    private int arcH;
    private int style;
    private boolean textshadow;
    private boolean boxshadow;
    private boolean boxrounded;
    private int boxshadow_dist = 4;
    private int textshadow_dist = 2;
    private Vector rows = new Vector();
    private Vector words = new Vector();
    private static long startTime;
    private static long timer;
    private static boolean sys_nobox;
    private static boolean sys_noscroll;
    public static final int MB_TEXT_SHADOWED = 8192;
    public static final int MB_BOX_ROUNDED = 4096;
    public static final int MB_BOX_SHADOWED = 256;
    public static final int MB_INPUT_NOSCROLL = 512;
    public static final int MB_SYSTEM_NOBOX = 2048;
    JAFont fonts = JAgamecanvas.smallfonts;

    public messagebox(String Text, int left, int top, int boxw, int boxh, int bordH, int bordU, int bordD, int style) {
        this(Text, left, top, boxw, boxh, bordH, bordU, bordD, style, null, 0, 0, null);
    }

    public messagebox(String Text, int left, int top, int boxw, int boxh, int bordH, int bordU, int bordD, int style, String ti, int tf, int nf, String tn) {
        this.boxLeft = left;
        this.boxTop = top;
        this.boxW = boxw;
        this.boxH = boxh;
        this.borderH = bordH + 3;
        this.borderU = bordU + 3;
        this.borderD = bordD + 3;
        this.curPage = 0;
        this.arcW = 14;
        this.arcH = 10;
        sys_nobox = false;
        sys_noscroll = false;
        this.textshadow = false;
        this.boxshadow = false;
        this.boxrounded = false;
        this.style = style;
        if ((style & 0x2000) > 0) {
            this.textshadow = true;
        }
        if ((style & 0x1000) > 0) {
            this.boxrounded = true;
        }
        if ((style & 0x100) > 0) {
            this.boxshadow = true;
        }
        if ((style & 0x200) > 0) {
            sys_noscroll = true;
        }
        if ((style & 0x800) > 0) {
            sys_nobox = true;
        }
        this.maxlines = (this.boxH - (this.borderU + this.borderD)) / this.fonts.getHeight();
        if (this.maxlines == 0) {
            ++this.maxlines;
        }
        this.rows.setSize(0);
        this.compose(Text);
        if (sys_noscroll) {
            this.numpages = this.numLines / this.maxlines;
            if (this.numLines % this.maxlines > 0) {
                ++this.numpages;
            }
        } else {
            this.numpages = this.numLines + 1 - this.maxlines;
            if (this.numpages <= 0) {
                this.numpages = 1;
            }
        }
        this.hide = false;
        timer = 0L;
        startTime = 0L;
        if (ti != null && ti != "") {
            this.talkIcon = Utils.createImage(ti);
            this.talkFrame = tf;
            this.talkFrames = nf;
            this.talkName = tn;
        }
    }

    public void nextPage() {
        ++this.curPage;
        if (this.curPage >= this.numpages) {
            this.curPage = this.numpages - 1;
            if (sys_noscroll) {
                this.Close();
            }
        }
    }

    public void prevPage() {
        --this.curPage;
        if (this.curPage <= 0) {
            this.curPage = 0;
        }
    }

    private String clearString(String s) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) == '|') continue;
            sb.append(s.charAt(i));
        }
        return sb.toString();
    }

    private void compose(String Text) {
        this.words.setSize(0);
        int o = 0;
        int index = 0;
        while (o != -1) {
            o = Text.indexOf(" ", index);
            String a = o != -1 ? Text.substring(index, o + 1) : Text.substring(index);
            int off = 0;
            int ind = 0;
            while (off != -1) {
                off = a.indexOf("|", ind);
                if (off != -1) {
                    this.words.addElement(a.substring(ind, off + 1));
                } else {
                    this.words.addElement(a.substring(ind));
                }
                ind = off + 1;
            }
            index = o + 1;
        }
        this.numWords = this.words.size();
        StringBuffer sb = new StringBuffer();
        StringBuffer esb = new StringBuffer();
        int boundH = this.boxW - this.borderH * 2;
        for (int i = 0; i < this.words.size(); ++i) {
            String a = (String)this.words.elementAt(i);
            String ex = this.clearString(a);
            int k = 0;
            int j = 0;
            if (sb.toString().length() > 0) {
                k = this.fonts.stringWidth(sb.toString());
            }
            if (ex.length() > 0) {
                j = this.fonts.stringWidth(ex);
            }
            if (k + j >= boundH) {
                this.rows.addElement(sb.toString().trim());
                sb.setLength(0);
            }
            sb.append(ex);
            if (a.indexOf("|", 0) == -1) continue;
            this.rows.addElement(sb.toString().trim());
            sb.setLength(0);
        }
        if (sb.length() > 0) {
            this.rows.addElement(sb.toString().trim());
        }
        this.numLines = this.rows.size();
    }

    public void setTimeout(int seconds) {
        timer = seconds * 1000;
        startTime = System.currentTimeMillis();
    }

    private void handleTimer() {
        if (timer <= 0L) {
            return;
        }
        if (System.currentTimeMillis() - startTime >= timer) {
            timer = 0L;
            this.Close();
        }
    }

    public boolean paint(Graphics g) {
        int howlines;
        if (this.hide) {
            return true;
        }
        this.handleTimer();
        int cW = this.boxW;
        int cH = this.boxH;
        int box_backcolor = 0x9B0000;
        int box_shadowcolor = 0x440000;
        int box_bordercolor = 0xFFCC00;
        if (!sys_nobox) {
            if (this.boxshadow) {
                g.setColor(box_shadowcolor);
                if (this.boxrounded) {
                    g.fillRoundRect(this.boxLeft + this.boxshadow_dist, this.boxTop + this.boxshadow_dist, cW, cH, this.arcW, this.arcH);
                } else {
                    g.fillRect(this.boxLeft + this.boxshadow_dist, this.boxTop + this.boxshadow_dist, cW, cH);
                }
            }
            g.setColor(box_backcolor);
            if (this.boxrounded) {
                g.fillRoundRect(this.boxLeft, this.boxTop, cW, cH, this.arcW, this.arcH);
            } else {
                g.fillRect(this.boxLeft, this.boxTop, cW, cH);
            }
            g.setColor(box_bordercolor);
            if (this.boxrounded) {
                g.drawRoundRect(this.boxLeft, this.boxTop, cW - 1, cH - 1, this.arcW, this.arcH);
            } else {
                g.drawRect(this.boxLeft, this.boxTop, cW - 1, cH - 1);
            }
        }
        if ((howlines = this.numLines) > this.maxlines) {
            howlines = this.maxlines;
        }
        int fh = this.fonts.getHeight();
        int startpage = 0;
        startpage = sys_noscroll ? this.curPage * this.maxlines : this.curPage;
        int rowsize = this.rows.size();
        int lastIndex = 0;
        int lastStringSize = 0;
        for (int i = 0; i < howlines && startpage + i < rowsize; ++i) {
            lastIndex = i;
            this.fonts.drawString(g, (String)this.rows.elementAt(startpage + i), this.boxLeft + this.borderH, this.boxTop + this.borderU + fh * i);
            lastStringSize = this.fonts.stringWidth((String)this.rows.elementAt(startpage + i));
        }
        if (this.numpages > 1) {
            if (!sys_noscroll) {
                g.setColor(153);
                g.fillRect(this.boxLeft + this.boxW - this.borderH, this.boxTop + this.borderU, this.borderH / 2, this.boxH - (this.borderU + this.borderD));
                g.setColor(0);
                g.drawRect(this.boxLeft + this.boxW - this.borderH, this.boxTop + this.borderU, this.borderH / 2 - 1, this.boxH - (this.borderU + this.borderD) - 1);
                int dim = (this.boxH - (this.borderU + this.borderD) << 10) / this.numpages;
                g.setColor(0xFFFFFF);
                g.fillRect(this.boxLeft + this.boxW - this.borderH, this.boxTop + this.borderU + (this.curPage * dim >> 10), this.borderH / 2, dim >> 10);
            } else if (startpage + howlines < this.numLines) {
                int cs = this.fonts.stringWidth(".");
                for (int i = 0; i < this.curDotNum; ++i) {
                    this.fonts.drawString(g, ".", this.boxLeft + this.borderH + lastStringSize + i * (cs + 1) + 1, this.boxTop + this.borderU + fh * lastIndex);
                }
                ++this.curDotNum;
                if (this.curDotNum > 3) {
                    this.curDotNum = 0;
                }
            }
        }
        if (this.talkIcon != null) {
            int tW = this.talkIcon.getWidth() / this.talkFrames;
            int tH = this.talkIcon.getHeight();
            int tX = this.boxLeft;
            int tY = this.boxTop + this.boxH - this.borderD;
            g.setColor(0x9B0000);
            g.fillRoundRect(tX, tY + tH / 2, this.boxW, tH + 1, this.arcW, this.arcH);
            g.setColor(0xFFCC00);
            g.drawRoundRect(tX, tY + tH / 2, this.boxW - 1, tH + 1 - 1, this.arcW, this.arcH);
            if (this.talkName != null) {
                this.fonts.drawString(g, this.talkName, tX + tW + tW / 2, (tH - this.fonts.getHeight()) / 2 + tY + tH / 2 + 1);
            }
            g.setClip(tX + this.borderH, tY + tH / 2 - 2, tW, tH);
            g.drawImage(this.talkIcon, tX - tW * this.talkFrame + this.borderH, tY + tH / 2 - 2, 20);
        }
        return false;
    }

    public void userinput(int kB) {
        if (timer > 0L) {
            return;
        }
        if ((kB & 0x100) != 0 || (kB & 0x200) != 0) {
            if (sys_noscroll) {
                this.nextPage();
            } else {
                this.Close();
            }
        } else if (!sys_noscroll) {
            if ((kB & 2) != 0) {
                this.prevPage();
            } else if ((kB & 0x40) != 0) {
                this.nextPage();
            }
        }
    }

    public void Close() {
        this.hide = true;
    }
}

