/*
 * Decompiled with CFR 0.152.
 */
package com.JavArt.gui;

import com.JavArt.tools.Utils;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class JAFont {
    private static final int[] crcTable = new int[]{0, 498536548, 997073096, 651767980, 1994146192, 1802195444, 1303535960, 1342533948, -306674912, -267414716, -690576408, -882789492, -1687895376, -2032938284, -1609899400, -1111625188};
    private static final short FONT_INDEX_BASELINE = 0;
    private static final short FONT_INDEX_SPACE_WIDTH = 1;
    private static final short FONT_INDEX_DEFAULT_CHAR = 2;
    private static final short FONT_INDEX_DEFAULT_KERNING = 3;
    private static final short FONT_INDEX_FONT_RESOURCE_SIZE = 4;
    private static final short FONT_INDEX_BORDER_RESOURCE_SIZE = 5;
    private static final short FONT_INDEX_BORDER_LEFT = 6;
    private static final short FONT_INDEX_BORDER_RIGHT = 7;
    private static final short FONT_INDEX_BORDER_TOP = 8;
    private static final short FONT_INDEX_BORDER_BOTTOM = 9;
    private static short[][] FONT_COLORS = new short[][]{null, null, null, null};
    private static final byte[] PALETTE_Signature = new byte[]{80, 76, 84, 69};
    private static final byte[][][] FONT_KERNINGS = new byte[][][]{(byte[][])null, (byte[][])null};
    private static final byte[][] FONT_WIDTHS = new byte[][]{{8, 8, 8, 8, 8, 6, 9, 8, 5, 5, 9, 5, 12, 9, 8, 8, 8, 8, 8, 6, 8, 9, 13, 8, 9, 9, 10, 9, 9, 10, 8, 8, 10, 9, 4, 8, 11, 9, 13, 10, 10, 9, 12, 10, 10, 10, 10, 10, 16, 10, 10, 11, 8, 8, 8, 5, 8, 8, 9, 7, 9, 9, 10, 9, 9, 9, 9, 9, 4, 4, 4, 4, 4, 8, 7, 12, 9, 9, 6, 6, 9, 4, 10, 9, 8, 11, 6, 6, 15, 6, 6, 10, 10, 10, 10, 10, 8, 8, 8, 9, 8, 8, 8, 8, 6, 6, 10, 10, 10, 10, 8, 8, 8, 10, 10, 8, 8, 8, 8, 8, 6, 6, 6, 6, 10, 10, 8, 10, 9, 13, 14, 13, 12, 10, 9, 10, 8, 10, 8, 12, 4, 8}, {7, 8, 7, 8, 8, 6, 8, 8, 5, 5, 8, 5, 10, 8, 8, 8, 8, 6, 6, 6, 8, 7, 11, 9, 4, 9, 7, 9, 8, 8, 9, 7, 7, 9, 9, 4, 7, 9, 8, 11, 9, 9, 8, 11, 9, 7, 8, 9, 9, 13, 9, 10, 9, 7, 8, 8, 5, 8, 8, 8, 6, 7, 8, 8, 7, 8, 8, 8, 8, 4, 4, 4, 4, 4, 6, 5, 10, 9, 7, 5, 5, 7, 3, 7, 5, 7, 6, 7, 7, 9, 6, 6, 8, 9, 9, 9, 9, 7, 7, 7, 8, 7, 7, 7, 8, 4, 5, 9, 9, 9, 9, 8, 8, 8, 9, 9, 8, 8, 7, 7, 6, 8, 5, 6, 5, 6, 9, 9, 8, 10, 9, 11, 12, 11, 12, 9, 8, 9, 7, 9, 8, 10}};
    private static final String[] FONT_CHARSETS = new String[]{"abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ\u00e0\u00e8\u00e9\u00ec\u00f2\u00f90123456789.,:;!?\"%&/()='+-*\\<>@[]$\u00c0\u00c1\u00c2\u00c3\u00e1\u00e2\u00e3\u00c7\u00e7\u00c9\u00ca\u00ea\u00cd\u00ed\u00d2\u00d3\u00d4\u00d5\u00f3\u00f4\u00f5\u00da\u00dc\u00fa\u00fc\u00c8\u00cb\u00eb\u00ce\u00cf\u00ee\u00ef\u00db\u00d9\u00fb\u0178\u00ff\u00c6\u0152\u00e6\u0153\u00d1\u00f1\u00c4\u00e4\u00d6\u00f6\u00df\u00a1\u00bf", "abcdefghijklmnopqrstuvwx\u00a1yzABCDEFGHIJKLMNOPQRSTUVWXYZ\u00e0\u00e8\u00e9\u00ec\u00f2\u00f90123456789.,:;!?\"%&/()='+-*\\<>@[]$\u00c0\u00c1\u00c2\u00c3\u00e1\u00e2\u00e3\u00c7\u00e7\u00c9\u00ca\u00ea\u00cd\u00ed\u00d2\u00d3\u00d4\u00d5\u00f3\u00f4\u00f5\u00da\u00dc\u00fa\u00fc\u00c8\u00cb\u00bf\u00eb\u00ce\u00cf\u00ee\u00ef\u00db\u00d9\u00fb\u0178\u00ff\u00c6\u0152\u00e6\u0153\u00d1\u00f1\u00c4\u00e4\u00d6\u00f6\u00df"};
    private static short[][] FONT_DATA = new short[][]{{17, 8, 73, 0, -1, -1, 1, 1, 1, 1}, {14, 6, 73, 0, -1, -1, 1, 1, 1, 1}};
    private static final String[] FONT_RESOURCES = new String[]{"fonts.png", null, "smallfonts.png", null};
    private char[] charset;
    private long lastCoreColor = -1L;
    private long lastBorderColor = -1L;
    private short fontIndex;
    private short fontHeight;
    private short[] offsets;
    private short[][] coreFontOffsets;
    private short[][] borderFontOffsets;
    private boolean drawBorder = false;
    private Image coreFont = null;
    private Image borderFont = null;
    public static String FONT_PATH = null;

    private static int CRC32(int crc, byte[] d, int o, int n) {
        while (n-- > 0) {
            byte b = (byte)crc;
            b = (byte)(b ^ d[o]);
            crc >>= 4;
            crc &= 0xFFFFFFF;
            crc ^= crcTable[b & 0xF];
            b = (byte)crc;
            b = (byte)(b ^ d[o++] >> 4);
            crc >>= 4;
            crc &= 0xFFFFFFF;
            crc ^= crcTable[b & 0xF];
        }
        return crc;
    }

    private static long RGB2HSV(int r, int g, int b) {
        int m;
        int M = m = r;
        if (g < m) {
            m = g;
        }
        if (g > M) {
            M = g;
        }
        if (b < m) {
            m = b;
        }
        if (b > M) {
            M = b;
        }
        int h = 6 * (M - m);
        if (m == M) {
            h = 0;
        } else if (M == r) {
            h = 65536 * (g - b) / h;
            if (g < b) {
                h += 65536;
            }
        } else if (M == g) {
            h = 65536 * (b - r) / h;
            h += 21845;
        } else {
            h = 65536 * (r - g) / h;
            h += 43690;
        }
        h += 128;
        int s = M == 0 ? 0 : 256 - 256 * m / M;
        int v = M;
        long rv = (h >>= 8) & 0xFFFF;
        rv <<= 16;
        rv |= (long)(s & 0xFFFF);
        rv <<= 16;
        return rv |= (long)(v & 0xFFFF);
    }

    private static int HSV2RGB(int h, int s, int v) {
        int b;
        int g;
        int r;
        int hi = h * 6 >> 8;
        int f = h * 6 & 0xFF;
        int p = v * (256 - s) / 256;
        int q = v * (256 - f * s / 256) / 256;
        int t = v * (256 - (256 - f) * s / 256) / 256;
        switch (hi) {
            case 0: {
                r = v;
                g = t;
                b = p;
                break;
            }
            case 1: {
                r = q;
                g = v;
                b = p;
                break;
            }
            case 2: {
                r = p;
                g = v;
                b = t;
                break;
            }
            case 3: {
                r = p;
                g = q;
                b = v;
                break;
            }
            case 4: {
                r = t;
                g = p;
                b = v;
                break;
            }
            default: {
                r = v;
                g = p;
                b = q;
            }
        }
        if (r > 255) {
            r = 255;
        }
        if (g > 255) {
            g = 255;
        }
        if (b > 255) {
            b = 255;
        }
        int rv = (r & 0xFF) << 16;
        rv |= (g & 0xFF) << 8;
        return rv |= b & 0xFF;
    }

    private static int getResourceSize(String fn) {
        int rv = 0;
        InputStream is = Thread.currentThread().getClass().getResourceAsStream(fn);
        if (is == null) {
            return -1;
        }
        try {
            while (is.read() >= 0) {
                ++rv;
            }
            is.close();
        }
        catch (IOException e) {
            rv = -1;
        }
        return rv;
    }

    private static Image setImageColor(String fn, short rs, int h, int s, int v, short[] c) {
        return Utils.createImage(fn);
    }

    private void swap(int a, int b) {
        if (a == b) {
            return;
        }
        short ti = this.offsets[a];
        char tc = this.charset[a];
        this.offsets[a] = this.offsets[b];
        this.charset[a] = this.charset[b];
        this.offsets[b] = ti;
        this.charset[b] = tc;
    }

    private void quickSort(int a, int b) {
        if (a >= b) {
            return;
        }
        int l = a;
        int r = b;
        char p = this.charset[(a + b) / 2];
        while (l <= r) {
            while (this.charset[l] < p) {
                ++l;
            }
            while (this.charset[r] > p) {
                --r;
            }
            if (l > r) break;
            this.swap(l++, r--);
        }
        this.quickSort(a, r);
        this.quickSort(l, b);
    }

    private int getKerning(short a, short b) {
        int j;
        int k;
        int i;
        int rv = FONT_DATA[this.fontIndex][3];
        byte[][] kd = FONT_KERNINGS[this.fontIndex];
        byte[] kkd = null;
        int l = kd == null ? 0 : kd.length;
        for (i = 0; i < l; ++i) {
            kkd = kd[i];
            k = kkd.length;
            for (j = 1; j < k && kkd[j] != b; ++j) {
            }
            if (j < k) break;
            i += rv - kkd[0];
        }
        if (i < l) {
            block2: for (j = kkd[0]; j < rv; ++j) {
                if ((kkd = kd[++i]) == null) continue;
                l = kkd.length;
                for (k = 0; k < l; ++k) {
                    int t2 = kkd[k];
                    int t1 = t2;
                    if (t1 < 0) {
                        t1 = -t1 - 1;
                        t2 = kkd[++k];
                    }
                    if (a < t1 || a > t2) continue;
                    rv = j;
                    continue block2;
                }
            }
        }
        return rv;
    }

    private int getOffset(char c) {
        try {
            int a = 0;
            int b = this.charset.length;
            while (a < b) {
                int m = (a + b) / 2;
                if (this.charset[m] < c) {
                    a = m + 1;
                    continue;
                }
                b = m;
            }
            if (this.charset[a] != c) {
                a = -1;
            }
            return a;
        }
        catch (Exception _E) {
            return -1;
        }
    }

    public JAFont(int fn) {
        int i;
        int j;
        int fh;
        int fw;
        this.fontIndex = (short)fn;
        byte[] fws = FONT_WIDTHS[fn];
        this.setColor(0, 256, 256);
        int bfw = fw = this.coreFont.getWidth();
        int bfh = fh = this.coreFont.getHeight();
        this.coreFontOffsets = new short[2][];
        this.coreFontOffsets[0] = new short[fws.length];
        this.coreFontOffsets[1] = new short[fws.length];
        this.setBorderColor(0, 256, 256);
        if (this.borderFont != null) {
            bfw = this.borderFont.getWidth();
            bfh = this.borderFont.getHeight();
            this.borderFontOffsets = new short[2][];
            this.borderFontOffsets[0] = new short[fws.length];
            this.borderFontOffsets[1] = new short[fws.length];
            j = FONT_DATA[fn][6] + FONT_DATA[fn][7];
        } else {
            j = 0;
        }
        int bm = 0;
        int bl = 0;
        int m = 0;
        int l = 0;
        for (i = 0; i < fws.length; ++i) {
            if (l + fws[i] > fw) {
                l = 0;
                m = (short)(m + 1);
            }
            this.coreFontOffsets[0][i] = l;
            this.coreFontOffsets[1][i] = m;
            l = (short)(l + fws[i]);
            if (this.borderFont == null) continue;
            if (bl + fws[i] + j > bfw) {
                bl = 0;
                bm = (short)(bm + 1);
            }
            this.borderFontOffsets[0][i] = bl;
            this.borderFontOffsets[1][i] = bm;
            bl = (short)(bl + (fws[i] + j));
        }
        m = (short)(m + 1);
        this.fontHeight = (short)(fh /= m);
        if (this.borderFont != null) {
            bm = (short)(bm + 1);
            bfh /= bm;
        }
        for (i = 0; i < fws.length; ++i) {
            short[] sArray = this.coreFontOffsets[1];
            int n = i;
            sArray[n] = (short)(sArray[n] * fh);
            if (this.borderFont == null) continue;
            short[] sArray2 = this.borderFontOffsets[1];
            int n2 = i;
            sArray2[n2] = (short)(sArray2[n2] * bfh);
        }
        fw = FONT_CHARSETS[fn].length();
        this.charset = new char[fw];
        this.offsets = new short[fw];
        for (i = 0; i < fw; ++i) {
            this.charset[i] = FONT_CHARSETS[fn].charAt(i);
            this.offsets[i] = (short)i;
        }
        this.quickSort(0, fw - 1);
    }

    public boolean hasBorder() {
        return this.drawBorder;
    }

    public void enableBorder(boolean e) {
        if (FONT_RESOURCES[2 * this.fontIndex + 1] != null) {
            this.drawBorder = e;
        }
    }

    public int getTopBorder() {
        return this.drawBorder ? FONT_DATA[this.fontIndex][8] : 0;
    }

    public int getBottomBorder() {
        return this.drawBorder ? FONT_DATA[this.fontIndex][9] : 0;
    }

    public int getLeftBorder() {
        return this.drawBorder ? FONT_DATA[this.fontIndex][6] : 0;
    }

    public int getRightBorder() {
        return this.drawBorder ? FONT_DATA[this.fontIndex][7] : 0;
    }

    public int getBaselinePosition() {
        return FONT_DATA[this.fontIndex][0];
    }

    public int getHeight() {
        return this.fontHeight - 2;
    }

    public void setColor(long hsv) {
        this.setColor((int)(hsv >> 32) & 0xFFFF, (int)(hsv >> 16) & 0xFFFF, (int)hsv & 0xFFFF);
    }

    public void setColor(int h, int s, int v) {
        if ((h %= 256) < 0) {
            h += 256;
        }
        long lc = h &= 0xFFFF;
        lc <<= 16;
        lc |= (long)(s &= 0xFFFF);
        lc <<= 16;
        if ((lc |= (long)(v &= 0xFFFF)) == this.lastCoreColor) {
            return;
        }
        this.lastCoreColor = lc;
        String fn = FONT_PATH + FONT_RESOURCES[2 * this.fontIndex];
        if (FONT_DATA[this.fontIndex][4] < 0) {
            JAFont.FONT_DATA[this.fontIndex][4] = (short)JAFont.getResourceSize(fn);
        }
        this.coreFont = JAFont.setImageColor(fn, FONT_DATA[this.fontIndex][4], h, s, v, FONT_COLORS[2 * this.fontIndex]);
    }

    public void setBorderColor(long hsv) {
        this.setBorderColor((int)(hsv >> 32) & 0xFFFF, (int)(hsv >> 16) & 0xFFFF, (int)hsv & 0xFFFF);
    }

    public void setBorderColor(int h, int s, int v) {
        if (FONT_RESOURCES[2 * this.fontIndex + 1] == null) {
            return;
        }
        if ((h %= 256) < 0) {
            h += 256;
        }
        long lc = h &= 0xFFFF;
        lc <<= 16;
        lc |= (long)(s &= 0xFFFF);
        lc <<= 16;
        if ((lc |= (long)(v &= 0xFFFF)) == this.lastBorderColor) {
            return;
        }
        this.lastBorderColor = lc;
        String fn = FONT_PATH + FONT_RESOURCES[2 * this.fontIndex + 1];
        if (FONT_DATA[this.fontIndex][5] < 0) {
            JAFont.FONT_DATA[this.fontIndex][5] = (short)JAFont.getResourceSize(fn);
        }
        this.borderFont = JAFont.setImageColor(fn, FONT_DATA[this.fontIndex][5], h, s, v, FONT_COLORS[2 * this.fontIndex + 1]);
    }

    public int stringWidth(String s) {
        int l = s.length();
        short k = -1;
        int rv = 0;
        for (int i = 0; i < l; ++i) {
            char c = s.charAt(i);
            if (c == ' ') {
                rv += FONT_DATA[this.fontIndex][1];
                continue;
            }
            int t = this.getOffset(c);
            short j = t < 0 ? FONT_DATA[this.fontIndex][2] : this.offsets[t];
            if (k >= 0) {
                rv += this.getKerning(k, j);
            }
            rv += FONT_WIDTHS[this.fontIndex][j];
            k = j;
        }
        return rv;
    }

    public void drawString(Graphics g, String s, int x, int y) {
        short j;
        int t;
        char c;
        int i;
        short k;
        short[] fd = FONT_DATA[this.fontIndex];
        int cx = g.getClipX();
        int cy = g.getClipY();
        int cw = g.getClipWidth();
        int ch = g.getClipHeight();
        int l = s.length();
        if (this.drawBorder) {
            k = -1;
            int tx = x - fd[6];
            y -= fd[8];
            int w = fd[6] + fd[7];
            int h = fd[8] + fd[9];
            for (i = 0; i < l; ++i) {
                c = s.charAt(i);
                if (c == ' ') {
                    tx += fd[1];
                    k = -1;
                    continue;
                }
                t = this.getOffset(c);
                j = t < 0 ? fd[2] : this.offsets[t];
                if (k >= 0) {
                    tx += this.getKerning(k, j);
                }
                g.setClip(cx, cy, cw, ch);
                g.clipRect(tx, y, w + FONT_WIDTHS[this.fontIndex][j], h + this.fontHeight);
                g.drawImage(this.borderFont, tx - this.borderFontOffsets[0][j], y - this.borderFontOffsets[1][j], 20);
                tx += FONT_WIDTHS[this.fontIndex][j];
                k = j;
            }
            y += fd[8];
        }
        k = -1;
        for (i = 0; i < l; ++i) {
            c = s.charAt(i);
            if (c == ' ') {
                x += fd[1];
                k = -1;
                continue;
            }
            t = this.getOffset(c);
            j = t < 0 ? fd[2] : this.offsets[t];
            if (k >= 0) {
                x += this.getKerning(k, j);
            }
            g.setClip(cx, cy, cw, ch);
            g.clipRect(x, y, (int)FONT_WIDTHS[this.fontIndex][j], (int)this.fontHeight);
            g.drawImage(this.coreFont, x - this.coreFontOffsets[0][j], y - this.coreFontOffsets[1][j], 20);
            x += FONT_WIDTHS[this.fontIndex][j];
            k = j;
        }
        g.setClip(cx, cy, cw, ch);
    }
}

