/*
 * Decompiled with CFR 0.152.
 */
package com.JavArt.tools;

import com.JavArt.gui.JAFont;
import com.JavArt.tools.BTconnectL2C;
import com.JavArt.tools.Utils;
import java.util.Vector;
import javax.bluetooth.BluetoothStateException;
import javax.bluetooth.DeviceClass;
import javax.bluetooth.DiscoveryListener;
import javax.bluetooth.LocalDevice;
import javax.bluetooth.RemoteDevice;
import javax.bluetooth.ServiceRecord;
import javax.bluetooth.UUID;
import javax.microedition.lcdui.Graphics;

public class BTconnection
implements Runnable,
DiscoveryListener {
    public static final UUID uuidSet = new UUID("e89787d0b06211dbabbd0800200c9a66", false);
    public static final boolean NETMODE_SERVER = true;
    public static final boolean NETMODE_CLIENT = false;
    private static final int DISCOVERSERVICE = 0;
    private static final int WAITCONNECTION = 1;
    private static final int CONNECTINGTOCLIENT = 2;
    private static final int CONNECTED = 3;
    private static final int CLIENTNOTFOUND = 4;
    private static final int SERVICENOTFOUND = 5;
    private static final int SERVERREADY = 6;
    private static final int MAX_DISPLAYABLE_NAMES = 5;
    private static final int MAX_SERVICE_CONNECTIONS = 1;
    private static final int tClientsList = 78;
    private static final int tConnect = 79;
    private static final int tTotal = 80;
    private static final int tTotalLeft = 81;
    private static final int tDiscoveringService = 82;
    private static final int tWaitingConnection = 83;
    private static final int tConnecting = 84;
    private static final int tConnected = 85;
    private static final int tNoClientsFound = 86;
    private static final int tNoGameFound = 87;
    private static final int tServerReady = 88;
    private int dsInd;
    private int dsPos;
    private BTconnectL2C connection = null;
    private ServiceRecord[] services = null;
    private String[] device_names = null;
    private boolean[] device_select = null;
    private boolean server;
    private boolean connected;
    private boolean connection_lost;
    private boolean discover_service;
    private boolean client_wait_connection;
    private boolean connect_to_client;
    private boolean client_not_found;
    private boolean service_not_found;
    private boolean server_ready;
    private Vector rD = new Vector();
    private ServiceRecord[] theRecord = null;
    private int transactionID = -1;
    private boolean search_done = false;
    private boolean intermit = false;

    public BTconnection() {
        this.initialize();
    }

    public void initialize() {
        this.server = false;
        this.discover_service = false;
        this.client_wait_connection = false;
        this.connect_to_client = false;
        this.client_not_found = false;
        this.server_ready = false;
        this.service_not_found = false;
        this.connected = false;
        this.connection_lost = false;
        this.connection = null;
        this.services = null;
        this.device_names = null;
        this.device_select = null;
        this.dsPos = 0;
        this.dsInd = 0;
    }

    public byte[] getMessage() {
        return this.connection.getMessage();
    }

    public void sendMessage(byte[] data) {
        this.connection.queueMessage(data);
    }

    public void closeAllConnections() {
        this.connection.closeAllConnections();
        this.initialize();
    }

    public boolean connectionIsLost() {
        return this.connection_lost;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public void setConnected(boolean val) {
        if (this.connected && !val) {
            this.connection_lost = true;
        }
        if (!this.server) {
            this.client_wait_connection = false;
        }
        this.connected = val;
    }

    public String[] getFriendlyNames() {
        if (this.services != null && this.services.length > 0) {
            this.device_names = new String[this.services.length];
            this.device_select = new boolean[this.services.length];
            this.device_select[0] = true;
            for (int i = 0; i < this.services.length; ++i) {
                try {
                    this.device_names[i] = this.services[i].getHostDevice().getFriendlyName(true);
                    continue;
                }
                catch (Exception _E) {
                    _E.printStackTrace();
                }
            }
        }
        return this.device_names;
    }

    public void createConnection(boolean TYPE) {
        this.server = TYPE;
        if (this.server) {
            this.discover_service = true;
        } else {
            this.client_wait_connection = true;
        }
        new Thread(this).start();
    }

    public int getStatusID() {
        if (this.discover_service) {
            return 0;
        }
        if (this.client_wait_connection) {
            return 1;
        }
        if (this.connect_to_client) {
            return 2;
        }
        if (this.connected) {
            return 3;
        }
        if (this.client_not_found) {
            return 4;
        }
        if (this.service_not_found) {
            return 5;
        }
        if (this.server_ready) {
            return 6;
        }
        return -1;
    }

    public String getStatusDesc() {
        if (this.discover_service) {
            return Utils.getStringFromVect(82);
        }
        if (this.client_wait_connection) {
            return Utils.getStringFromVect(83);
        }
        if (this.connect_to_client) {
            return Utils.getStringFromVect(84);
        }
        if (this.connected) {
            return Utils.getStringFromVect(85);
        }
        if (this.client_not_found) {
            return Utils.getStringFromVect(86);
        }
        if (this.service_not_found) {
            return Utils.getStringFromVect(87);
        }
        if (this.server_ready) {
            return Utils.getStringFromVect(88);
        }
        return "";
    }

    public boolean isServer() {
        return this.server;
    }

    public boolean isClient() {
        return !this.isServer();
    }

    public int UserInput(int keyStatus, int keyBuffer) {
        if (this.server_ready && (keyStatus & 0x400) != 0) {
            this.connect_to_client = true;
            long start = System.currentTimeMillis();
            new Thread(this).start();
        } else if (this.client_wait_connection && (keyStatus & 0x100) != 0) {
            this.connection.cancelAAO();
        } else if ((keyStatus & 0x100) != 0) {
            if (this.server && (this.client_not_found || this.service_not_found)) {
                this.services = null;
                this.client_not_found = false;
                this.service_not_found = false;
            } else if (this.server_ready) {
                // empty if block
            }
        } else if (this.device_select != null) {
            if ((keyStatus & 2) != 0) {
                this.dsPos = Math.max(0, --this.dsPos);
                if (this.dsPos < this.dsInd) {
                    --this.dsInd;
                }
                this.selectDevice();
            }
            if ((keyStatus & 0x40) != 0) {
                this.dsPos = Math.min(++this.dsPos, this.device_select.length - 1);
                if (this.dsPos >= this.dsInd + 5) {
                    ++this.dsInd;
                }
                this.selectDevice();
            }
        }
        return -1;
    }

    private int freeConnectionSlot() {
        int c = 0;
        for (int i = 0; i < this.device_select.length; ++i) {
            if (!this.device_select[i]) continue;
            ++c;
        }
        if (c == 1) {
            return 0;
        }
        return 1 - c;
    }

    private void selectDevice() {
        for (int i = 0; i < this.device_select.length; ++i) {
            this.device_select[i] = i == this.dsPos;
        }
    }

    private void drawCheckRadius(Graphics g, int x, int y, int dia, boolean select) {
        g.setColor(0xAAAAAA);
        g.fillArc(x, y, dia, dia, 0, 360);
        if (!select) {
            g.setColor(0x888888);
        } else {
            g.setColor(-1);
        }
        g.fillArc(x + 2, y + 2, dia - 4, dia - 4, 0, 360);
    }

    private void drawCheckBox(Graphics g, int x, int y, int dia, boolean select) {
        g.setColor(0xAAAAAA);
        g.fillRect(x, y, dia, dia);
        if (!select) {
            g.setColor(0x888888);
        } else {
            g.setColor(-1);
        }
        g.fillRect(x + 2, y + 2, dia - 4, dia - 4);
    }

    public void UI(Graphics g, JAFont fonts) {
        int width = g.getClipWidth();
        int height = g.getClipHeight();
        if (this.getStatusID() == 0 || this.getStatusID() == 1 || this.getStatusID() == 4 || this.getStatusID() == 5 || this.getStatusID() == 2 || this.getStatusID() == 3) {
            fonts.drawString(g, this.getStatusDesc(), (width - fonts.stringWidth(this.getStatusDesc())) / 2, (height - fonts.getHeight()) / 2);
            if (this.getStatusID() == 1) {
                fonts.drawString(g, "stop", (width - fonts.stringWidth("stop")) / 2, height - fonts.getHeight());
            }
        } else if (this.server_ready) {
            int fh = fonts.getHeight() + 5;
            int borderX = 4;
            int aY = 1;
            fonts.drawString(g, Utils.getStringFromVect(78), (width - fonts.stringWidth(Utils.getStringFromVect(78))) / 2, aY);
            g.setColor(102);
            g.fillRoundRect(0, (aY += fh * 2) - 4, width, 5 * fh + 8, 10, 10);
            g.setColor(-1);
            g.drawRoundRect(0, aY - 4, width - 1, 5 * fh + 7, 10, 10);
            for (int i = this.dsInd; i < this.dsInd + 5 && i < this.device_names.length; ++i) {
                int ind = i - this.dsInd;
                fonts.drawString(g, this.device_names[i], borderX, aY + fh * ind);
                this.drawCheckRadius(g, width - borderX - fh, aY + fh * ind + 2, fh - 4, this.device_select[i]);
                if (this.dsPos != i || !this.intermit) continue;
                g.setColor(-1);
                g.drawLine(borderX, aY + fh * ind + fh, width - borderX - 4, aY + fh * ind + fh);
            }
            String t1 = Utils.getStringFromVect(80) + String.valueOf(this.device_names.length);
            String t2 = Utils.getStringFromVect(81) + String.valueOf(this.freeConnectionSlot());
            fonts.drawString(g, t1, borderX, aY += fh * 6);
            fonts.drawString(g, t2, borderX, aY + fh);
            fonts.drawString(g, Utils.getStringFromVect(79), width - fonts.stringWidth(Utils.getStringFromVect(79)), height - fonts.getHeight());
        }
        this.intermit = !this.intermit;
    }

    public void run() {
        if (this.discover_service) {
            this.inquireDevices();
            if (this.getDevicesNumber() > 0) {
                this.services = this.searchService();
                if (this.services != null && this.services.length > 0) {
                    this.getFriendlyNames();
                    this.server_ready = true;
                } else {
                    this.service_not_found = true;
                }
            } else {
                this.client_not_found = true;
            }
            this.discover_service = false;
        } else if (this.client_wait_connection) {
            this.connection = new BTconnectL2C(this, null, null);
            this.connection.WaitConnection();
            this.connected = true;
        } else if (this.connect_to_client) {
            this.connection = new BTconnectL2C(this, this.services, this.device_select);
            this.connect_to_client = false;
            this.server_ready = false;
            this.connected = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void inquireDevices() {
        try {
            LocalDevice.getLocalDevice().setDiscoverable(0);
            BTconnection bTconnection = this;
            synchronized (bTconnection) {
                this.search_done = false;
                LocalDevice.getLocalDevice().getDiscoveryAgent().startInquiry(10390323, (DiscoveryListener)this);
                while (!this.search_done) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException _IE) {
                        _IE.printStackTrace();
                    }
                }
            }
        }
        catch (BluetoothStateException _BSE) {
            _BSE.printStackTrace();
        }
    }

    public void deviceDiscovered(RemoteDevice dev, DeviceClass cod) {
        if (cod.getMajorDeviceClass() == 512 || cod.getMajorDeviceClass() == 4) {
            this.rD.addElement(dev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void inquiryCompleted(int discType) {
        this.search_done = true;
        BTconnection bTconnection = this;
        synchronized (bTconnection) {
            this.notifyAll();
        }
    }

    public int getDevicesNumber() {
        if (this.rD != null) {
            return this.rD.size();
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceRecord[] searchService() {
        int[] attrSet = null;
        try {
            LocalDevice.getLocalDevice().setDiscoverable(0);
            for (int i = 0; i < this.rD.size(); ++i) {
                BTconnection bTconnection = this;
                synchronized (bTconnection) {
                    this.search_done = false;
                    this.transactionID = LocalDevice.getLocalDevice().getDiscoveryAgent().searchServices(attrSet, new UUID[]{uuidSet}, (RemoteDevice)this.rD.elementAt(i), (DiscoveryListener)this);
                    while (!this.search_done) {
                        try {
                            this.wait();
                        }
                        catch (Exception _E) {
                            _E.printStackTrace();
                        }
                    }
                    continue;
                }
            }
        }
        catch (Exception _E) {
            _E.printStackTrace();
        }
        return this.theRecord;
    }

    public void servicesDiscovered(int id, ServiceRecord[] serviceRecord) {
        this.theRecord = serviceRecord;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serviceSearchCompleted(int id, int rC) {
        this.transactionID = -1;
        this.search_done = true;
        BTconnection bTconnection = this;
        synchronized (bTconnection) {
            this.notifyAll();
        }
    }
}

