/*
 * Decompiled with CFR 0.152.
 */
package pagenetsoft.game;

import java.util.Vector;
import pagenetsoft.game.PNFixed;

class Block {
    public boolean movement;
    public static int BLOCK_SIZE;
    public static int BOTTOM_Y;
    private static final int[] speedX;
    private static final int[] speedY;
    public byte row;
    public byte col;
    public byte color;
    private byte destRow = (byte)-1;
    private byte destCol = (byte)-1;
    public int x;
    public int y;
    private static final int ACSEL;
    private int vX;
    private int vY;
    private int fx;
    private int fy;
    private int aX = ACSEL;
    private int aY = ACSEL;
    private static Vector listFree;
    private static int cntNEW;

    public static Block newBlock(byte by, byte by2, byte by3) {
        if (listFree == null) {
            listFree = new Vector();
        }
        if (listFree.isEmpty()) {
            return new Block(by, by2, by3);
        }
        Block block = (Block)listFree.elementAt(listFree.size() - 1);
        listFree.removeElementAt(listFree.size() - 1);
        return block.reset(by, by2, by3);
    }

    public void delBlock() {
        listFree.addElement(this);
    }

    private Block reset(byte by, byte by2, byte by3) {
        this.color = by3;
        this.row = by;
        this.col = by2;
        this.x = by2 * BLOCK_SIZE;
        this.y = BOTTOM_Y - by * BLOCK_SIZE;
        this.vY = 0;
        this.vX = 0;
        this.destCol = (byte)-1;
        this.destRow = (byte)-1;
        return this;
    }

    private Block(byte by, byte by2, byte by3) {
        this.color = by3;
        this.row = by;
        this.col = by2;
        this.x = by2 * BLOCK_SIZE;
        this.y = BOTTOM_Y - by * BLOCK_SIZE;
        this.vY = 0;
        this.vX = 0;
    }

    boolean eguals(int n, int n2) {
        return this.row == n && this.col == n2;
    }

    public void update(int n) {
        if (!this.movement) {
            return;
        }
        int n2 = this.vX;
        int n3 = this.vY;
        int n4 = PNFixed.Div(PNFixed.getFixed(n), PNFixed.getFixed(250));
        this.vX += PNFixed.Mul(this.aX, n4);
        this.fx += PNFixed.Mul(n2 + this.vX, n4) >> 1;
        this.vY += PNFixed.Mul(this.aY, n4);
        this.fy += PNFixed.Mul(n3 + this.vY, n4) >> 1;
        this.x = PNFixed.getInt(this.fx);
        this.y = PNFixed.getInt(this.fy);
        if (this.destCol >= 0 && (this.destCol < this.col && this.x < this.destCol * BLOCK_SIZE || this.destCol > this.col && this.x > this.destCol * BLOCK_SIZE)) {
            this.col = this.destCol;
            this.x = this.col * BLOCK_SIZE;
            this.movement = false;
        } else if (this.y > BOTTOM_Y - this.destRow * BLOCK_SIZE) {
            this.row = this.destRow;
            this.y = BOTTOM_Y - this.destRow * BLOCK_SIZE;
            this.movement = false;
        }
    }

    public void startFall(int n) {
        this.vX = PNFixed.getFixed(speedX[n % speedX.length]);
        this.vY = PNFixed.getFixed(speedY[n % speedY.length]);
        this.aX = 0;
        this.aY = ACSEL;
        this.destRow = (byte)-1;
        this.destCol = (byte)-1;
        this.fx = PNFixed.getFixed(this.x);
        this.fy = PNFixed.getFixed(this.y);
        this.movement = true;
    }

    public void startDown(byte by) {
        this.vX = 0;
        this.vY = PNFixed.getFixed(-this.row);
        this.aX = 0;
        this.aY = ACSEL;
        this.destRow = (byte)(this.row + by);
        this.destCol = (byte)-1;
        this.fx = PNFixed.getFixed(this.x);
        this.fy = PNFixed.getFixed(this.y);
        this.movement = true;
    }

    public void startFlip(byte by) {
        this.vX = PNFixed.getFixed(by);
        this.vY = 0;
        this.aX = by < 0 ? -ACSEL : ACSEL;
        this.aY = 0;
        this.destRow = (byte)-1;
        this.destCol = (byte)(this.col + by);
        this.fx = PNFixed.getFixed(this.x);
        this.fy = PNFixed.getFixed(this.y);
        this.movement = true;
    }

    static {
        speedX = new int[]{3, -3, 5, 0, -2, 5, -5};
        speedY = new int[]{-50, -30, 10, -40, -20, -25, -10};
        ACSEL = PNFixed.getFixed(64);
        listFree = null;
        cntNEW = 0;
    }
}

