/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic.spf;

import java.util.Vector;
import simple.core.Application;
import simple.input.Key;
import simple.input.Keys;
import simple.video.Graphics;
import simple.video.Image;
import sk.inlogic.spf.Common;
import sk.inlogic.spf.FootbalPlayer;
import sk.inlogic.spf.FootbalTeam;
import sk.inlogic.spf.FootballTeamAI;
import sk.inlogic.spf.Globals;
import sk.inlogic.spf.IScreen;
import sk.inlogic.spf.MyApplication;
import sk.inlogic.spf.Pitch;
import sk.inlogic.spf.Resources;
import sk.inlogic.spf.ScreenMenu;
import sk.inlogic.spf.Sounds;
import sk.inlogic.spf.Texts;

public class ScreenGame
implements IScreen {
    static final int MODE_VOID = 0;
    static final int MODE_LOADINGRES = 1;
    static final int MODE_PLAY = 2;
    static final int MODE_PAUSE = 3;
    static final int MODE_GAMEOVER = 4;
    static final int MODE_RESTART = 5;
    static final int MODE_NEXTLEVEL = 6;
    static final int MODE_CORNER = 8;
    static final int MODE_OUT = 9;
    static final int MODE_MESSAGE = 10;
    static final int MODE_FOUL = 11;
    static final int MODE_KICK_OFF = 12;
    static final int MODE_GAME_OVER = 13;
    static final int MODE_LOS = 14;
    static final int MODE_CUP_INFO = 15;
    static final int MODE_FORMATIONS = 16;
    static final int MODE_ATTRIBUTES = 17;
    static final int MODE_INSTRUCTION = 18;
    static final int MODE_QUESTION = 19;
    static final int MODE_RESULT = 20;
    static final int MODE_CUP_TEXTS = 21;
    static final int MODE_FREE_VIEW = 22;
    static final int MODE_AFTERMATCH = 23;
    final int DIRRECT_KICK;
    final int INDIRRECT_KICK;
    static int iFoulType;
    final int MI_RESUME;
    final int MI_RESTART;
    final int MI_MENU;
    final int MI_GO_RETRY;
    final int MI_GO_MENU;
    int POSX_TIMER;
    int POSY_TIMER;
    static final int WIDTH;
    static final int HEIGHT;
    int iColLayerBottom;
    int FP_OffsetLayerBack;
    int FP_SpeedLayerBack;
    public int iOffsetLayerBack;
    int iOffsetLayerBottom;
    public int iLayerBottomPosY;
    int iLayerBottomWidth;
    int FP_OffsetLayerBottom;
    int FP_LayerBottomWidth;
    public int FP_SpeedLayerBottom;
    int iOffsetLayerMiddle;
    int iLayerMiddlePosY;
    int iLayerMiddleWidth;
    int FP_OffsetLayerMiddle;
    int FP_LayerMiddleWidth;
    int FP_SpeedLayerMiddle;
    public static int iWaterSurface;
    static int iMode;
    static int iModeOld;
    int iCurrentLevel;
    long lTimer;
    public long lTimerUmbrella;
    public long lTimerHintControls;
    public long lTimerEarthquake;
    public int iEarthQuakeDspX;
    public int iEarthQuakeDspY;
    MyApplication pMyApplication;
    static boolean bCanStartGame;
    private static Pitch pitch;
    static final int MESSAGE_CORNER = 0;
    static final int MESSAGE_OUT = 1;
    static final int MESSAGE_FOUL = 2;
    static final int MESSAGE_GOAL = 3;
    static final int MESSAGE_HALF = 4;
    static final int MESSAGE_ADD = 5;
    static int iAddPoint;
    private static int iMessageType;
    private static int iCornerCounter;
    private static int iCornerType;
    public static boolean bHasBeenReleased;
    public static boolean bGameIsReady;
    StringBuffer sbTime = new StringBuffer();
    long iOldTime = System.currentTimeMillis() / 1000L;
    long iNewTime;
    int iSec;
    int iMin;
    int iHalftime = 2;
    public static String str;
    public static String str2;
    public static boolean bStop;
    private static boolean bCup;
    private static int iRound;
    private static int iSelected;
    private static int iPauseIdx;
    private static int iBlick;
    private static int iFormation;
    private String[] strTexts = new String[5];
    private int[] iTextsPosX = new int[5];
    private boolean bContinueCup = false;
    private int iControlerSprite1 = 0;
    private int iControlerSprite2 = 0;
    static final int QUAD_1 = 1;
    static final int QUAD_2 = 2;
    static final int QUAD_3 = 3;
    public static int iGKAttackQuad;
    private static boolean bLooser;
    private int iInstructionArowsX;
    private int iInstructionArowsY;
    boolean bTesting = false;
    Vector vecText = new Vector();
    int[] iHeaderPosX = new int[5];
    static int iTimerPosY;
    static int iTextsPosY;
    public static final int SPEED_NORMAL = 10;
    public static final int SPEED_WITH_BALL = 8;
    public static final int SPEED_SPRINT = 2;
    public static final int SPEED_TARGETING = 25;
    public static final int SPEED_TACKLING = 40;
    public static int iEffectivityEnemy;
    public static int iEffectivityYou;
    public static int iSpeedWithBall;
    public static int iSpeedWithBallE;
    public static boolean bSuddenDeath;
    FootbalPlayer fbForCornerKick;
    int iActionCounter = 0;
    private static int[] cornerCoordUp;
    private static int[] cornerCoordDn;
    private static FootbalPlayer fbForKickOff;
    private static FootbalPlayer fbForCatch;
    private boolean bCoinFlip = false;
    FootbalTeam otherTeam;
    FootbalTeam teamForAction;
    static final int POS_U_L = 0;
    static final int POS_U_M = 1;
    static final int POS_U_R = 2;
    static final int POS_D_L = 3;
    static final int POS_D_M = 4;
    static final int POS_D_R = 5;
    static final int CORNER = 0;
    static final int CORNER_GK = 1;
    int iGkPosY;
    public static int iScrollX;
    public static int iScrollY;
    public static int iSpeedX;
    public static int iSpeedY;
    public static int iPlayerFrame;
    public static int iHeading;
    public static boolean bMove;
    public static int iScreenScrollX;
    public static int iScreenScrollY;
    public static int iScreenAddX;
    public static int iScreenAddY;
    public int iCounter = 0;
    public int iActivePlayer = 0;
    public static boolean bNextCupStage;
    boolean bAddPoint;
    boolean bPlayerIsWinner = false;
    public static boolean bScrollLeft;
    public static boolean bScrollRight;
    public static boolean bScrollUp;
    public static boolean bScrollDown;
    boolean bIsWinner = false;
    static int iPosX;
    static int iPosY;
    private int[] iVec = new int[2];
    boolean bSimpleGround = false;
    static int iSX;
    static int iSY;
    static int iOldRotAngle;
    static int iNewRotAngle;
    static int iRadius;
    static int iRotationCounter;
    static int[] iOpisanyObdlznik;
    static int PLAY_GROUND_W;
    static int PLAY_GROUND_H;
    public static int iPlayerPosX;
    public static int iPlayerPosY;
    public static int iTmpPlayerPosX;
    public static int iTmpPlayerPosY;
    public static int iPlayerSpd;
    int iDirrAngle = 0;
    int iDirrX = 0;
    int iDirrY = 0;
    static int iLosWinner;
    static String[] strEndTexts;
    static String[][] strValues;
    static int iTextPosY;
    static int iTextPosX;
    static int iLineWidth;
    static int iActualYPos;
    static int iPointerMenuY;
    static String strHeader;
    static String strWinner;
    static int iFrame;
    static int iSelectedTeam;
    public static int iCupInfoPosY;
    private static int iAfterMAtch;
    int iBallPosX = 0;
    int iInc = 0;
    private int iSmalSqW;
    private int iSmalSqH;
    private int iDiffY;
    private int iItemWidth;
    private int iItemHeight;
    private int iSpaceItems;
    private int iTextDifY;
    private int iSelectedAtt;
    private int iSelectorPosX;
    private int iDiff;
    StringBuffer sb = new StringBuffer();
    static int iScorePosX;
    static int iPointerX;
    static int iPointerY;
    static boolean bShowGrid;
    int iOldItem = -1;
    int iTouchY;
    private static int iFreezTime;
    private static int iNexAction;

    public void setTestTime() {
        if (this.bTesting) {
            this.iSec = 5;
            this.iMin = 0;
        }
    }

    public ScreenGame(int iLosWiner, boolean bcup, boolean bContinue) {
        this.DIRRECT_KICK = 0;
        this.INDIRRECT_KICK = 1;
        this.MI_RESUME = 0;
        this.MI_RESTART = 1;
        this.MI_MENU = 2;
        this.MI_GO_RETRY = 0;
        this.MI_GO_MENU = 1;
        this.pMyApplication = MyApplication.getInstance();
        this.pMyApplication.callLoading();
        this.bContinueCup = bContinue;
        bCup = bcup;
        this.sbTime.setLength(0);
        this.sbTime.append(this.iMin).append(":").append("00");
        iLosWinner = iLosWiner;
        iRound = 0;
        bStop = false;
        str2 = null;
        if (!bCup) {
            this.iSec = Globals.iHalfTimeSec;
            this.iMin = Globals.iHalfTimeMin;
        } else {
            this.iSec = Globals.iCupHalfTimeSec;
            this.iMin = Globals.iCupHalfTimeMin;
        }
        this.setTestTime();
        this.prepareTexts();
        iMode = 1;
    }

    public void setSuddenDeath() {
        bSuddenDeath = true;
        this.iSec = 0;
        this.iMin = 2;
        this.prepareKickOff();
    }

    public void setDifficulty(int index) {
        if (index == 0) {
            iGKAttackQuad = 1;
            iSpeedWithBall = 10;
            iSpeedWithBallE = 8;
            iEffectivityEnemy = 25;
            iEffectivityYou = 75;
        } else if (index == 1) {
            iGKAttackQuad = 2;
            iEffectivityEnemy = 60;
            iEffectivityYou = 65;
            iSpeedWithBall = 8;
            iSpeedWithBallE = 8;
        } else if (index == 2) {
            iGKAttackQuad = 3;
            iSpeedWithBall = 8;
            iSpeedWithBallE = 8;
            iEffectivityEnemy = 95;
            iEffectivityYou = 50;
        }
    }

    public void setupGame() {
        if (pitch == null) {
            pitch = new Pitch();
            pitch.getBall().addBallToPlayer(pitch.getTeam1().getPlayer(9));
        }
        this.setDifficulty(Globals.iSelectedDiff);
    }

    public void callNextMode() {
        if (bCup) {
            if (this.bContinueCup) {
                this.prepareCupInfo();
            } else {
                this.prepareFormationScreen(true);
            }
        } else {
            this.prepareFormationScreen(true);
        }
        ScreenGame.getPitch().setScrollToBall();
        Resources.updateStadiumShadows(Pitch.iScreenScrollX, Pitch.iScreenScrollY);
        ScreenGame.getPitch().updateGrassTile(Pitch.iScreenScrollX, Pitch.iScreenScrollY);
        ScreenGame.getPitch().updateAdds(Pitch.iScreenScrollX, Pitch.iScreenScrollY);
    }

    public static Pitch getPitch() {
        return pitch;
    }

    public void callPlayMode() {
        iMode = 2;
    }

    public void update(long tick) {
        switch (iMode) {
            case 1: {
                Resources.loadGround();
                this.setupGame();
                this.prepareForamtionsScreen();
                this.prepareScore();
                FootballTeamAI.prepareGKs();
                Sounds.playGameMusic(0L);
                iTimerPosY = Resources.STATUS_BAR_H - Resources.iImgTimeH >> 1;
                iTextsPosY = Resources.STATUS_BAR_H - Texts.getFontHeight() >> 1;
                this.updateStatusBar();
                this.callNextMode();
                this.pMyApplication.stopLoading();
                break;
            }
            case 17: {
                this.pMyApplication.repaintScreen();
                break;
            }
            case 20: {
                this.pMyApplication.repaintScreen();
                break;
            }
            case 16: {
                this.pMyApplication.repaintScreen();
                break;
            }
            case 14: {
                if (Math.abs(this.iBallPosX) >= Resources.BALL_POS_X) {
                    return;
                }
                this.iBallPosX += this.iInc;
                this.pMyApplication.repaintScreen();
                break;
            }
            case 6: {
                this.pMyApplication.repaintScreen();
                break;
            }
            case 10: {
                break;
            }
            case 13: {
                this.pMyApplication.repaintScreen();
                break;
            }
            case 23: {
                this.pMyApplication.repaintScreen();
                break;
            }
            case 15: {
                this.pMyApplication.repaintScreen();
                break;
            }
            case 21: {
                this.pMyApplication.repaintScreen();
                break;
            }
            case 12: {
                if (ScreenGame.getPitch().getBall().getOwner() != null && ScreenGame.getPitch().getBall().getOwner() == fbForCatch) {
                    this.callPlayMode();
                }
                ScreenGame.getPitch().getBall().update();
                this.pMyApplication.repaintScreen();
                break;
            }
            case 11: {
                if (!bGameIsReady) {
                    ScreenGame.getPitch().getTeam1().update(true, false);
                    ScreenGame.getPitch().getTeam2().update(true, false);
                    if (ScreenGame.getPitch().getTeam1().isTeamOnPosition() && ScreenGame.getPitch().getTeam2().isTeamOnPosition()) {
                        bGameIsReady = true;
                    }
                } else {
                    fbForKickOff.updateHeaing(ScreenGame.getPitch().getBall().getBallX(), ScreenGame.getPitch().getBall().getBallY());
                    ScreenGame.getPitch().getBall().update();
                    if (ScreenGame.getPitch().getBall().getOwner() != null) {
                        ScreenGame.getPitch().getBall().getOwner().stopActivePlayer();
                    }
                    if (fbForKickOff == ScreenGame.getPitch().getBall().getOwner()) {
                        fbForKickOff = null;
                        ScreenGame.getPitch().setFoul(false, null, null);
                        this.callPlayMode();
                    }
                }
                this.pMyApplication.repaintScreen();
                break;
            }
            case 8: {
                if (ScreenGame.getPitch().getBall().getCurrentSpeed() == 0 && ScreenGame.getPitch().getBall().getOwner() == null) {
                    if (ScreenGame.getPitch().getBall().getBallY() < 0 || ScreenGame.getPitch().getBall().getBallY() > 1320) {
                        ScreenGame.getPitch().getBall().addBallToPlayer(this.teamForAction.getPlayer(9));
                        return;
                    }
                    if (ScreenGame.getPitch().getBall().getBallX() < 0 || ScreenGame.getPitch().getBall().getBallX() > 900) {
                        ScreenGame.getPitch().getBall().addBallToPlayer(this.teamForAction.getPlayer(9));
                        return;
                    }
                }
                if (iCornerType == 1) {
                    if (!this.teamForAction.getPlayer(10).hasBall()) {
                        this.teamForAction.getPlayer(10).setTarget(ScreenGame.getPitch().getBall().getBallX(), ScreenGame.getPitch().getBall().getBallY(), false);
                        ScreenGame.getPitch().update();
                    } else {
                        this.callPlayMode();
                    }
                    ScreenGame.getPitch().getBall().update();
                } else {
                    ScreenGame.getPitch().getBall().update();
                    if (this.teamForAction == ScreenGame.getPitch().getTeam2()) {
                        this.fbForCornerKick = ScreenGame.getPitch().getTeam2().getPlayer(Common.getRandomUInt(9));
                        this.fbForCornerKick.setIsPassingTarget(true);
                        ScreenGame.getPitch().getBall().setPassTarget(this.fbForCornerKick);
                        if (Resources.WIDTH >= 360) {
                            ScreenGame.getPitch().getBall().kickToPlayerCorner(this.fbForCornerKick, 150);
                        } else {
                            ScreenGame.getPitch().getBall().kickToPlayerCorner(this.fbForCornerKick, 200);
                        }
                        bCanStartGame = true;
                    } else {
                        if (ScreenGame.getPitch().getActivePlayer() != null) {
                            ScreenGame.getPitch().getActivePlayer().disableMove();
                        }
                        ScreenGame.getPitch().getTeam1().update(false, true);
                        ScreenGame.getPitch().getTeam2().update(false, true);
                    }
                    if (!ScreenGame.getPitch().getBall().checkCorner() && bCanStartGame && !ScreenGame.getPitch().getBall().checkOut()) {
                        ScreenGame.getPitch().getActivePlayer().enableMove();
                        this.callPlayMode();
                    }
                }
                this.pMyApplication.repaintScreen();
                break;
            }
            case 9: {
                if (ScreenGame.getPitch().getBall().getCurrentSpeed() == 0 && ScreenGame.getPitch().getBall().getOwner() == null) {
                    if (ScreenGame.getPitch().getBall().getBallY() < 0 || ScreenGame.getPitch().getBall().getBallY() > 1320) {
                        ScreenGame.getPitch().getBall().addBallToPlayer(this.fbForCornerKick);
                        return;
                    }
                    if (ScreenGame.getPitch().getBall().getBallX() < 0 || ScreenGame.getPitch().getBall().getBallX() > 900) {
                        ScreenGame.getPitch().getBall().addBallToPlayer(this.fbForCornerKick);
                        return;
                    }
                }
                ScreenGame.getPitch().getTeam1().update(true, false);
                ScreenGame.getPitch().getTeam2().update(true, false);
                if (ScreenGame.getPitch().getTeam1().isTeamOnPosition() && ScreenGame.getPitch().getTeam2().isTeamOnPosition()) {
                    bCanStartGame = true;
                }
                if (bCanStartGame && ScreenGame.getPitch().getBall().hasOwner() && ScreenGame.getPitch().getBall().getOwner().getTeam() == ScreenGame.getPitch().getTeam2()) {
                    FootbalPlayer fbtmp = ScreenGame.getPitch().getTeam2().getPlayer(Common.getRandomUInt(10));
                    fbtmp.setIsPassingTarget(true);
                    ScreenGame.getPitch().getBall().setPassTarget(fbtmp);
                    ScreenGame.getPitch().getBall().kickToPlayerCorner(fbtmp, 45);
                }
                ScreenGame.getPitch().getBall().update();
                if (!ScreenGame.getPitch().getBall().checkCorner() && bCanStartGame && !ScreenGame.getPitch().getBall().checkOut()) {
                    this.callPlayMode();
                    this.fbForCornerKick.isPlaying();
                }
                if (ScreenGame.getPitch().getBall().hasOwner() && ScreenGame.getPitch().getBall().getOwner().getTeam() == ScreenGame.getPitch().getTeam1()) {
                    ScreenGame.getPitch().getBall().getOwner().stopActivePlayer();
                }
                this.pMyApplication.repaintScreen();
                break;
            }
            case 2: {
                this.updateModeGame();
                if (ScreenGame.getPitch().isGoal()) {
                    this.prepareScore();
                    if (!this.bIsSuddenDeath()) {
                        this.callMessage(3);
                    }
                }
                if (ScreenGame.getPitch().isCorrner()) {
                    this.callModeFreeView(0);
                }
                if (ScreenGame.getPitch().isOut()) {
                    ScreenGame.getPitch().setOut(false);
                    this.callModeFreeView(1);
                }
                if (ScreenGame.getPitch().isFoul()) {
                    this.callMessage(2);
                }
                this.updateTime();
                this.pMyApplication.repaintScreen();
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                this.pMyApplication.repaintScreen();
                break;
            }
            case 18: {
                this.pMyApplication.repaintScreen();
                break;
            }
            case 19: {
                break;
            }
            case 22: {
                iFreezTime = (int)((long)iFreezTime + tick);
                if (iFreezTime >= 600) {
                    if (iNexAction == 0) {
                        ScreenGame.getPitch().setCorner(false);
                        this.determineCornerType();
                    }
                    this.callMessage(iNexAction);
                } else {
                    ScreenGame.getPitch().getBall().update();
                }
                this.pMyApplication.repaintScreen();
            }
        }
    }

    private boolean bIsSuddenDeath() {
        if (!bSuddenDeath) {
            return false;
        }
        bSuddenDeath = false;
        this.prepareEndTable();
        return true;
    }

    private void callMessage(int iType) {
        Resources.updateStadiumShadows(Pitch.iScreenScrollX, Pitch.iScreenScrollY);
        ScreenGame.getPitch().updateGrassTile(Pitch.iScreenScrollX, Pitch.iScreenScrollY);
        ScreenGame.getPitch().updateAdds(Pitch.iScreenScrollX, Pitch.iScreenScrollY);
        iMessageType = iType;
        iMode = 10;
        this.pMyApplication.repaintScreen();
    }

    private void updateControlerIcon() {
        if (ScreenGame.getPitch().getActivePlayer() == null) {
            return;
        }
        if (ScreenGame.getPitch().getActivePlayer().hasBall()) {
            this.iControlerSprite1 = 3;
            this.iControlerSprite2 = 1;
        } else {
            this.iControlerSprite1 = 0;
            this.iControlerSprite2 = 2;
        }
    }

    public static FootbalPlayer getFbForKickOff() {
        return fbForKickOff;
    }

    void prepareFormationScreen(boolean bFlip) {
        this.bCoinFlip = bFlip;
        pitch.sortPlayers();
        this.strTexts[0] = MyApplication.resTxt.getString("FORMATION");
        this.iTextsPosX[0] = Resources.WIDTH - Texts.getTextWidth(this.strTexts[0]) >> 1;
        ScreenGame.getPitch().setScrollToMiddle();
        iMode = 16;
    }

    void prepareKickOff() {
        int i;
        ScreenGame.getPitch().getBall().lostBall();
        ScreenGame.getPitch().getBall().setBallPos(450, 660);
        Resources.updateStadiumShadows(Pitch.iScreenScrollX, Pitch.iScreenScrollY);
        ScreenGame.getPitch().updateGrassTile(Pitch.iScreenScrollX, Pitch.iScreenScrollY);
        ScreenGame.getPitch().updateAdds(Pitch.iScreenScrollX, Pitch.iScreenScrollY);
        ScreenGame.getPitch().getTeam1().getPlayer(10).resetJump();
        ScreenGame.getPitch().getTeam2().getPlayer(10).resetJump();
        this.otherTeam = ScreenGame.getPitch().getScoreTeam() == ScreenGame.getPitch().getTeam1() ? ScreenGame.getPitch().getTeam2() : ScreenGame.getPitch().getTeam1();
        int iPlayerForKickIdx = -1;
        int iPlayerForCatchIdx = -1;
        int iDistance = -1;
        int iMinDistance = 15;
        for (i = 0; i < 10; ++i) {
            iDistance = Common.getManhattanDis(this.otherTeam.getPlayer(i).getActualGridX(), this.otherTeam.getPlayer(i).getActualGridY(), ScreenGame.getPitch().getBall().getBallQuadX(), ScreenGame.getPitch().getBall().getBallQuadY());
            if (iDistance >= iMinDistance) continue;
            iMinDistance = iDistance;
            iPlayerForKickIdx = i;
        }
        iDistance = -1;
        iMinDistance = 15;
        for (i = 0; i < 10; ++i) {
            iDistance = Common.getManhattanDis(this.otherTeam.getPlayer(i).getActualGridX(), this.otherTeam.getPlayer(i).getActualGridY(), ScreenGame.getPitch().getBall().getBallQuadX(), ScreenGame.getPitch().getBall().getBallQuadY());
            if (i == iPlayerForKickIdx || iDistance >= iMinDistance) continue;
            iMinDistance = iDistance;
            iPlayerForCatchIdx = i;
        }
        for (i = 0; i < 10; ++i) {
            ScreenGame.getPitch().getTeam1().getPlayer(i).prepareKickOffPos();
            ScreenGame.getPitch().getTeam2().getPlayer(i).prepareKickOffPos();
        }
        fbForKickOff = this.otherTeam.getPlayer(iPlayerForKickIdx);
        fbForCatch = this.otherTeam.getPlayer(iPlayerForCatchIdx);
        fbForKickOff.setPosition(450, 660);
        fbForCatch.setPosition(330 + Resources.pSprPlayerW, 660);
        ScreenGame.getPitch().getBall().addBallToPlayer(fbForKickOff);
        fbForKickOff.updateHeaing(fbForCatch.getPosX(), fbForCatch.getPosY());
        fbForCatch.updateHeaing(fbForKickOff.getPosX(), fbForKickOff.getPosY());
        fbForKickOff.update();
        fbForKickOff.printHeading();
        pitch.updateMap();
        ScreenGame.getPitch().setScrollToMiddle();
        if (this.otherTeam.getTeamSide() == 1 && ScreenGame.getPitch().getActivePlayer() == null) {
            this.setRandomActive();
        }
        Resources.updateStadiumShadows(Pitch.iScreenScrollX, Pitch.iScreenScrollY);
        iMode = 12;
    }

    void prepareFoul() {
        ScreenGame.getPitch().getBall().lostBall();
        if (ScreenGame.getPitch().getActivePlayer() != null) {
            ScreenGame.getPitch().getTeam1().setPassivePlayer(ScreenGame.getPitch().getActivePlayer().getPosInArray());
            ScreenGame.getPitch().deselectPlayer();
        }
        iFoulType = ScreenGame.getPitch().getFouledTeam().getSideOfTeam() == 4 ? (ScreenGame.getPitch().getFaulPosY() < 440 ? 0 : 1) : (ScreenGame.getPitch().getFaulPosY() > 880 ? 0 : 1);
        fbForKickOff = null;
        for (int i = 0; i < 10; ++i) {
            int x = Pitch.getIdxXByQuad(ScreenGame.getPitch().getFouledTeam().getPlayer(i).getOffensePosQuad()) * 60;
            int y = Pitch.getIdxYByQuad(ScreenGame.getPitch().getFouledTeam().getPlayer(i).getOffensePosQuad()) * 88;
            ScreenGame.getPitch().getFouledTeam().getPlayer(i).setPosition(x, y);
            ScreenGame.getPitch().getFouledTeam().getPlayer(i).setTarget(x, y, false);
            x = Pitch.getIdxXByQuad(ScreenGame.getPitch().getOtherTeam().getPlayer(i).getDefensePosQuad()) * 60;
            y = Pitch.getIdxYByQuad(ScreenGame.getPitch().getOtherTeam().getPlayer(i).getDefensePosQuad()) * 88;
            ScreenGame.getPitch().getOtherTeam().getPlayer(i).setPosition(x, y);
            ScreenGame.getPitch().getOtherTeam().getPlayer(i).setTarget(x, y, false);
        }
        ScreenGame.getPitch().getBall().setBallPos(ScreenGame.getPitch().getFaulPosX(), ScreenGame.getPitch().getFaulPosY());
        ScreenGame.getPitch().getFouledPlayer().setTarget(ScreenGame.getPitch().getBall().getBallX(), ScreenGame.getPitch().getBall().getBallY(), false);
        ScreenGame.getPitch().getFouledPlayer().setPosition(ScreenGame.getPitch().getBall().getBallX(), ScreenGame.getPitch().getBall().getBallY());
        int iFouledGridX = ScreenGame.getPitch().getFouledPlayer().getActualGridX();
        int iFouledGridY = ScreenGame.getPitch().getFouledPlayer().getActualGridY();
        int iPlayerForCatchIdx = -1;
        int iDistance = -1;
        int iMinDistance = 15;
        for (int i = 0; i < 10; ++i) {
            if (ScreenGame.getPitch().getFouledTeam().getPlayer(i) == ScreenGame.getPitch().getFouledPlayer() || (iDistance = Common.getManhattanDis(iFouledGridX, iFouledGridY, ScreenGame.getPitch().getFouledTeam().getPlayer(i).getActualGridX(), ScreenGame.getPitch().getFouledTeam().getPlayer(i).getActualGridY())) >= iMinDistance) continue;
            iMinDistance = iDistance;
            iPlayerForCatchIdx = i;
        }
        fbForKickOff = ScreenGame.getPitch().getFouledTeam().getPlayer(iPlayerForCatchIdx);
        int iMultiplicator = ScreenGame.getPitch().getBall().getBallX() <= 450 ? 1 : -1;
        fbForKickOff.setTarget(ScreenGame.getPitch().getBall().getBallX() + iMultiplicator * 120, ScreenGame.getPitch().getBall().getBallY(), false);
        ScreenGame.getPitch().getFouledPlayer().getTeam().incFoul();
        bHasBeenReleased = false;
        bGameIsReady = false;
        iMode = 11;
    }

    void prepareOut() {
        ScreenGame.getPitch().getTeam1().getPlayer(10).resetJump();
        ScreenGame.getPitch().getTeam2().getPlayer(10).resetJump();
        FootbalTeam fbTeamKickingCorner = ScreenGame.getPitch().getBall().getTeamOwner() == ScreenGame.getPitch().getTeam1() ? ScreenGame.getPitch().getTeam2() : ScreenGame.getPitch().getTeam1();
        bCanStartGame = false;
        ScreenGame.getPitch().getBall().lostBall();
        if (ScreenGame.getPitch().getActivePlayer() != null) {
            ScreenGame.getPitch().getTeam1().setPassivePlayer(ScreenGame.getPitch().getActivePlayer().getPosInArray());
            ScreenGame.getPitch().deselectPlayer();
        }
        int x = 0;
        int y = 0;
        for (int i = 0; i < 10; ++i) {
            x = Pitch.getIdxXByQuad(fbTeamKickingCorner.getPlayer(i).getOffensePosQuad()) * 60;
            y = Pitch.getIdxYByQuad(fbTeamKickingCorner.getPlayer(i).getOffensePosQuad()) * 88;
            fbTeamKickingCorner.getPlayer(i).setPosition(x, y);
            fbTeamKickingCorner.getPlayer(i).setTarget(x, y, false);
            x = Pitch.getIdxXByQuad(ScreenGame.getPitch().getBall().getTeamOwner().getPlayer(i).getDefensePosQuad()) * 60;
            y = Pitch.getIdxYByQuad(ScreenGame.getPitch().getBall().getTeamOwner().getPlayer(i).getDefensePosQuad()) * 88;
            ScreenGame.getPitch().getBall().getTeamOwner().getPlayer(i).setPosition(x, y);
            ScreenGame.getPitch().getBall().getTeamOwner().getPlayer(i).setTarget(x, y, false);
        }
        this.fbForCornerKick = fbTeamKickingCorner.getPlayer(9);
        this.fbForCornerKick.setPosition(ScreenGame.getPitch().getBall().getBallX() < 450 ? -20 : 920, ScreenGame.getPitch().getBall().getBallY());
        this.fbForCornerKick.setTarget(ScreenGame.getPitch().getBall().getBallX() < 450 ? -20 : 920, ScreenGame.getPitch().getBall().getBallY(), false);
        this.fbForCornerKick.updateHeaing(450, 660);
        ScreenGame.getPitch().getBall().addBallToPlayer(this.fbForCornerKick);
        this.fbForCornerKick.isThrowing();
        if (ScreenGame.getPitch().getBall().getBallX() < 450) {
            ScreenGame.getPitch().setScrollToBallRight();
        } else {
            ScreenGame.getPitch().setScrollToBallLeft();
        }
        Resources.updateStadiumShadows(Pitch.iScreenScrollX, Pitch.iScreenScrollY);
        ScreenGame.getPitch().updateGrassTile(Pitch.iScreenScrollX, Pitch.iScreenScrollY);
        ScreenGame.getPitch().updateAdds(Pitch.iScreenScrollX, Pitch.iScreenScrollY);
        if (ScreenGame.getPitch().getActivePlayer() == null && fbTeamKickingCorner == ScreenGame.getPitch().getTeam2()) {
            ScreenGame.getPitch().swapPlayers();
        }
        bHasBeenReleased = false;
        iMode = 9;
    }

    void setBallPos(int iPosition) {
        ScreenGame.getPitch().getBall().lostBall();
        switch (iPosition) {
            case 0: {
                ScreenGame.getPitch().getBall().setBallPos(0, 0);
                ScreenGame.getPitch().setScrollToBallUpLeft();
                break;
            }
            case 1: {
                ScreenGame.getPitch().getBall().setBallPos(450, 88);
                ScreenGame.getPitch().setScrollToBall();
                break;
            }
            case 2: {
                ScreenGame.getPitch().getBall().setBallPos(900, 0);
                ScreenGame.getPitch().setScrollToBallUpRight();
                break;
            }
            case 3: {
                ScreenGame.getPitch().getBall().setBallPos(0, 1320);
                ScreenGame.getPitch().setScrollToBallDownLeft();
                break;
            }
            case 4: {
                ScreenGame.getPitch().getBall().setBallPos(450, 1232);
                ScreenGame.getPitch().setScrollToBall();
                break;
            }
            case 5: {
                ScreenGame.getPitch().getBall().setBallPos(900, 1320);
                ScreenGame.getPitch().setScrollToBallDownRight();
            }
        }
    }

    void switchSides() {
        pitch.getTeam1().switchSide();
        pitch.getTeam2().switchSide();
        pitch.setScoreTeam(pitch.getTeam1() == pitch.getBall().getTeamOwner() ? pitch.getTeam2() : pitch.getTeam1());
        ScreenGame.getPitch().deselectPlayer();
        this.prepareKickOff();
    }

    void determineCornerType() {
        int iBallX = pitch.getBall().getBallX();
        int iBallY = pitch.getBall().getBallY();
        this.iGkPosY = 0;
        if (ScreenGame.getPitch().getBall().getTeamOwner().getSideOfTeam() == 2) {
            if (iBallY < 660) {
                this.setBallPos(iBallX < 450 ? 0 : 2);
                iCornerType = 0;
            } else {
                this.setBallPos(4);
                iCornerType = 1;
                this.iGkPosY = 15;
            }
        }
        if (ScreenGame.getPitch().getBall().getTeamOwner().getSideOfTeam() == 4) {
            if (iBallY < 1320 >> 1) {
                this.setBallPos(1);
                iCornerType = 1;
                this.iGkPosY = -15;
            } else {
                this.setBallPos(iBallX < 900 >> 1 ? 3 : 5);
                iCornerType = 0;
            }
        }
    }

    void prepareCorner() {
        iCornerCounter = 0;
        bCanStartGame = false;
        this.teamForAction = ScreenGame.getPitch().getBall().getTeamOwner() == ScreenGame.getPitch().getTeam1() ? ScreenGame.getPitch().getTeam2() : ScreenGame.getPitch().getTeam1();
        this.otherTeam = this.teamForAction == ScreenGame.getPitch().getTeam1() ? ScreenGame.getPitch().getTeam2() : ScreenGame.getPitch().getTeam1();
        bCanStartGame = false;
        this.teamForAction.updateCorner();
        if (ScreenGame.getPitch().getActivePlayer() != null) {
            ScreenGame.getPitch().getTeam1().setPassivePlayer(ScreenGame.getPitch().getActivePlayer().getPosInArray());
            ScreenGame.getPitch().deselectPlayer();
        }
        this.determineCornerType();
        int x = 0;
        int y = 0;
        if (iCornerType == 1) {
            this.teamForAction.getPlayer(10).setPosition(450, this.teamForAction.getPlayer(10).getPosY() + this.iGkPosY);
            this.teamForAction.getPlayer(10).setTarget(450, this.teamForAction.getPlayer(10).getPosY(), false);
            ScreenGame.getPitch().getBall().resetJump(0);
            ScreenGame.getPitch().setScrollToBall();
            for (int i = 0; i < 10; ++i) {
                x = Pitch.getIdxXByQuad(this.teamForAction.getPlayer(i).getOffensePosQuad()) * 60;
                y = Pitch.getIdxYByQuad(this.teamForAction.getPlayer(i).getOffensePosQuad()) * 88;
                this.teamForAction.getPlayer(i).setTarget(x, y, false);
                this.teamForAction.getPlayer(i).setPosition(x, y);
                x = Pitch.getIdxXByQuad(this.otherTeam.getPlayer(i).getDefensePosQuad()) * 60;
                y = Pitch.getIdxYByQuad(this.otherTeam.getPlayer(i).getDefensePosQuad()) * 88;
                this.otherTeam.getPlayer(i).setTarget(x, y, false);
                this.otherTeam.getPlayer(i).setPosition(x, y);
            }
        } else if (iCornerType == 0) {
            for (int i = 0; i < 10; ++i) {
                if (ScreenGame.getPitch().getBall().getTeamOwner().getSideOfTeam() == 2) {
                    if (ScreenGame.getPitch().getBall().getBallY() < Resources.HEIGHT >> 1) {
                        x = Pitch.getIdxXByQuad(cornerCoordUp[i]) * 60;
                        y = Pitch.getIdxYByQuad(cornerCoordUp[i]) * 88;
                    }
                } else if (ScreenGame.getPitch().getBall().getBallY() > Resources.HEIGHT >> 1) {
                    x = Pitch.getIdxXByQuad(cornerCoordDn[i]) * 60;
                    y = Pitch.getIdxYByQuad(cornerCoordDn[i]) * 88;
                }
                this.teamForAction.getPlayer(i).setPosition(x, y);
                this.teamForAction.getPlayer(i).setTarget(x, y, false);
                this.teamForAction.getPlayer(i).updateHeaing(ScreenGame.getPitch().getBall().getBallX(), ScreenGame.getPitch().getBall().getBallY());
                this.otherTeam.getPlayer(i).setPosition(x + 20, y);
                this.otherTeam.getPlayer(i).setTarget(x + 20, y, false);
                this.otherTeam.getPlayer(i).updateHeaing(ScreenGame.getPitch().getBall().getBallX(), ScreenGame.getPitch().getBall().getBallY());
            }
            this.teamForAction.getPlayer(9).setPosition(ScreenGame.getPitch().getBall().getBallX(), ScreenGame.getPitch().getBall().getBallY());
            this.teamForAction.getPlayer(9).setTarget(ScreenGame.getPitch().getBall().getBallX(), ScreenGame.getPitch().getBall().getBallY(), false);
        }
        Resources.updateStadiumShadows(Pitch.iScreenScrollX, Pitch.iScreenScrollY);
        ScreenGame.getPitch().updateGrassTile(Pitch.iScreenScrollX, Pitch.iScreenScrollY);
        ScreenGame.getPitch().updateAdds(Pitch.iScreenScrollX, Pitch.iScreenScrollY);
        this.setRandomActive();
        iMode = 8;
        this.pMyApplication.repaintScreen();
    }

    void setRandomActive() {
        if (ScreenGame.getPitch().getActivePlayer() != null) {
            return;
        }
        ScreenGame.getPitch().swapPlayers();
    }

    void paintInGameWindow(Graphics g) {
        g.setClipRegion(0, 0, Resources.WIDTH, Resources.HEIGHT);
        int iWindowW = Resources.WIDTH - 20;
        int iWindowH = Resources.HEIGHT - 60;
        int iX = Resources.WIDTH - iWindowW >> 1;
        int iY = Resources.HEIGHT - iWindowH >> 1;
        g.setColor(0xFFFF00);
        g.fillRect(iX, iY, iWindowW, iWindowH);
    }

    void paintMatchOver(Graphics g) {
        Resources.paintIngaemWindow(g, 11, 12);
        iActualYPos = iTextPosY;
        Texts.drawTextAtPos(g, iTextPosX, iActualYPos, strHeader);
        g.setColor(0);
        g.drawLine(iTextPosX - 10, iActualYPos += Texts.getFontHeight(), iTextPosX - 10 + iLineWidth, iActualYPos);
        Texts.drawTextAtPos(g, Resources.WIDTH - Texts.getTextWidth(strWinner) >> 1, iActualYPos += 2, strWinner);
        iActualYPos += Texts.getFontHeight() * 3;
        for (int i = 0; i < strEndTexts.length; ++i) {
            Texts.drawTextAtPos(g, Resources.WIDTH - Texts.getTextWidth(strEndTexts[i]) >> 1, iActualYPos, strEndTexts[i]);
            Texts.drawTextAtPos(g, Resources.TEXTS_IN_TABLE, iActualYPos, strValues[i][0]);
            Texts.drawTextAtPos(g, Resources.WIDTH - Resources.TEXTS_IN_TABLE - Texts.getTextWidth(strValues[i][1]), iActualYPos, strValues[i][1]);
            iActualYPos += Texts.getFontHeight();
        }
    }

    public void prepareEndTable() {
        ScreenGame.strValues[0][0] = Globals.strNations[Globals.iMyTeamIdx];
        ScreenGame.strValues[0][1] = Globals.strNations[Globals.iEnemyTeamIdx];
        ScreenGame.strValues[1][0] = "" + pitch.getTeam1().getScore();
        ScreenGame.strValues[1][1] = "" + pitch.getTeam2().getScore();
        int iHlp = pitch.getTeam1().getHoldingCnt() + pitch.getTeam2().getHoldingCnt();
        ScreenGame.strValues[2][0] = "" + pitch.getTeam1().getHoldingCnt() * 100 / iHlp;
        ScreenGame.strValues[2][1] = "" + (100 - pitch.getTeam1().getHoldingCnt() * 100 / iHlp);
        ScreenGame.strValues[3][0] = "" + (pitch.getTeam1().getScore() + pitch.getTeam2().getCorner());
        ScreenGame.strValues[3][1] = "" + (pitch.getTeam2().getScore() + pitch.getTeam1().getCorner());
        strHeader = MyApplication.resTxt.getString("36");
        iLineWidth = Texts.getTextWidth(strHeader) + 20;
        iTextPosX = Resources.WIDTH - Texts.getTextWidth(strHeader) >> 1;
        iTextPosY = Resources.HEIGHT - Texts.getFontHeight() * (strValues.length + 5) + 2 >> 1;
        strWinner = pitch.getTeam1().getScore() == pitch.getTeam2().getScore() ? MyApplication.resTxt.getString("65") : (pitch.getTeam1().getScore() > pitch.getTeam2().getScore() ? MyApplication.resTxt.getString("63") : MyApplication.resTxt.getString("64"));
        iMode = 13;
    }

    void paintCupTxt(Graphics g) {
        pitch.paint(g);
        this.paintStatusBar(g);
        g.setClipRegion(0, 0, Resources.WIDTH, Resources.HEIGHT);
        Resources.paintIngaemWindow(g, 11, 13);
        Resources.paintLeftButton(g, 2);
        str = "GAME OVER";
        Texts.drawTextAtPos(g, Resources.WIDTH - Texts.getTextWidth(str) >> 1, (Resources.HEIGHT >> 1) - 10, str);
    }

    void paintAfterMatch(Graphics g) {
        pitch.paint(g);
        this.paintStatusBar(g);
        g.setClipRegion(0, 0, Resources.WIDTH, Resources.HEIGHT);
        Resources.paintIngaemWindow(g, 11, 14);
        if (iAfterMAtch == 0) {
            MyApplication.cup.paintCupInfo(g, 0, Resources.getWindowPosY(), Resources.iMenuW, false);
        } else if (iAfterMAtch == 1) {
            MyApplication.cup.paintCupInfo(g, 0, Resources.getWindowPosY(), Resources.iMenuW, true);
        } else if (iAfterMAtch == 2) {
            str = "GAME OVER";
            Texts.drawTextAtPos(g, Resources.WIDTH - Texts.getTextWidth(str) >> 1, (Resources.HEIGHT >> 1) - 10, str);
        }
        Resources.paintLeftButton(g, 2);
    }

    void afterMatchActions() {
        if (iAfterMAtch == 0) {
            if (MyApplication.cup.getCurrentCupPhase() >= 3) {
                MyApplication.cup.incrementPhase();
                MyApplication.cup.prepareHeader();
            }
            if (!MyApplication.cup.isPlayerInCup()) {
                iAfterMAtch = 2;
            }
            if (MyApplication.cup.isPlayerInCup()) {
                iAfterMAtch = 1;
            }
        } else if (iAfterMAtch == 1) {
            Globals.iEnemyTeamIdx = MyApplication.cup.getOponentTeamNation();
            Resources.loadTeams(Globals.iMyTeamIdx + 1, Globals.iEnemyTeamIdx + 1);
            this.startGame();
        } else if (iAfterMAtch == 2) {
            Globals.deletCup();
            MyApplication.cup.resetCup();
            this.callMenu();
        }
    }

    void paintCupInfo(Graphics g) {
        pitch.paint(g);
        this.paintStatusBar(g);
        g.setClipRegion(0, 0, Resources.WIDTH, Resources.HEIGHT);
        Resources.paintIngaemWindow(g, 11, 14);
        Resources.paintLeftButton(g, 2);
    }

    void paintMessage(Graphics g) {
        pitch.paint(g);
        this.paintStatusBar(g);
        g.setClipRegion(0, 0, Resources.WIDTH, Resources.HEIGHT);
        g.setColor(16448769);
        g.fillRect(0, (Resources.HEIGHT >> 1) - 20, Resources.WIDTH, 40);
        g.setColor(197123);
        g.drawRect(-1, (Resources.HEIGHT >> 1) - 20, Resources.WIDTH + 2, 40);
        str = "";
        if (iMessageType == 0) {
            str = iCornerType == 1 ? MyApplication.resTxt.getString("INGAME_6") : MyApplication.resTxt.getString("INGAME_5");
        } else if (iMessageType == 1) {
            str = MyApplication.resTxt.getString("INGAME_4");
        } else if (iMessageType == 2) {
            str = MyApplication.resTxt.getString("INGAME_1");
        } else if (iMessageType == 3) {
            str = MyApplication.resTxt.getString("INGAME_2");
        } else if (iMessageType == 4) {
            str = MyApplication.resTxt.getString("INGAME_3");
        } else if (iMessageType == 5) {
            str = MyApplication.resTxt.getString("67");
        }
        Texts.drawTextAtPos(g, Resources.WIDTH - Texts.getTextWidth(str) >> 1, (Resources.HEIGHT >> 1) - 10, str);
        this.paintPauseButton(g);
        Resources.paintLeftButton(g, 2);
    }

    void paintModeResult(Graphics g) {
        pitch.paint(g);
        this.paintStatusBar(g);
        g.setClipRegion(0, 0, Resources.WIDTH, Resources.HEIGHT);
        Resources.paintIngaemWindow(g, 10, 10);
        Resources.paintLeftButton(g, 2);
        if (Resources.imgPlayerWin == null) {
            Resources.drawMultilineTextCenter(g);
        } else {
            Resources.imgPlayerWin.drawAtPoint(g, Resources.WIDTH - Resources.imgPlayerWin.getWidth() >> 1, Resources.HEIGHT - Resources.imgPlayerWin.getHeight() >> 1);
            Resources.drawMultilineText(g, 0, (Resources.HEIGHT - Resources.imgPlayerWin.getHeight() >> 1) + Resources.imgPlayerWin.getHeight());
        }
    }

    void updateModeGame() {
        pitch.update();
    }

    public void callPauseWithoutReturn() {
        iMode = 3;
    }

    public void callPause() {
        iModeOld = iMode;
        iMode = 3;
    }

    public void unPause() {
        iMode = iModeOld;
        this.pMyApplication.repaintScreen();
    }

    void evaluateGameOver() {
        if (bCup) {
            this.bPlayerIsWinner = false;
            if (pitch.getTeam1().getScore() == pitch.getTeam2().getScore()) {
                MyApplication.cup.setPoints(MyApplication.cup.getPlayerIdx(), 3, 1);
                MyApplication.cup.setPoints(MyApplication.cup.getOponentTeamIdx(), 3, 1);
            } else if (pitch.getTeam1().getScore() < pitch.getTeam2().getScore()) {
                MyApplication.cup.setPoints(MyApplication.cup.getPlayerIdx(), 2, 1);
                MyApplication.cup.setPoints(MyApplication.cup.getOponentTeamIdx(), 1, 1);
            } else if (pitch.getTeam1().getScore() > pitch.getTeam2().getScore()) {
                this.bPlayerIsWinner = true;
                MyApplication.cup.setPoints(MyApplication.cup.getPlayerIdx(), 1, 1);
                MyApplication.cup.setPoints(MyApplication.cup.getOponentTeamIdx(), 2, 1);
                this.bAddPoint = true;
            }
            MyApplication.cup.setPoints(MyApplication.cup.getPlayerIdx(), 5, pitch.getTeam1().getScore());
            MyApplication.cup.evaluate();
            if (MyApplication.cup.getCurrentCupPhase() < 3) {
                MyApplication.cup.incrementPhase();
                MyApplication.cup.prepareHeader();
            }
            MyApplication.cup.scoreTeams(32);
            this.prepareCupInfo();
            pitch.getTeam1().resetScore();
            pitch.getTeam2().resetScore();
            return;
        }
        pitch.getTeam1().resetScore();
        pitch.getTeam2().resetScore();
        this.callMenu();
    }

    void updateKeysUp() {
        if (--iSelected <= 0) {
            iSelected = 0;
        }
    }

    void updateKeysDn() {
        if (++iSelected >= 1) {
            iSelected = 1;
        }
    }

    void callMenu() {
        if (Globals.bMusic) {
            Sounds.playMenuMusic();
        } else {
            Sounds.stopMusic();
        }
        MyApplication.pScrMenu = new ScreenMenu();
        MyApplication.pActiveScreen = MyApplication.pScrMenu;
        MyApplication.pScrGame = null;
        pitch = null;
        iMode = 0;
    }

    void executeSelected() {
        if (iSelected == 1) {
            this.callMenu();
        }
        Globals.saveCup();
    }

    public void prepareResult() {
        Resources.imgPlayerWin = null;
        this.iItemWidth = Resources.WIDTH - 50;
        Resources.prepareText("64", this.iItemWidth, this.iItemWidth);
        iMode = 20;
        this.pMyApplication.repaintScreen();
    }

    public void callResultWinTheCup() {
        Resources.imgPlayerWin = new Image("/win.png");
        Resources.prepareText("62", 9 * Resources.iTableW, 9 * Resources.iTableW);
        this.bIsWinner = true;
        iMode = 20;
        this.pMyApplication.repaintScreen();
    }

    public void startGame() {
        if (!bCup) {
            this.iSec = Globals.iHalfTimeSec;
            this.iMin = Globals.iHalfTimeMin;
        } else {
            this.iSec = Globals.iCupHalfTimeSec;
            this.iMin = Globals.iCupHalfTimeMin;
        }
        this.setTestTime();
        this.iHalftime = 2;
        this.sbTime.setLength(0);
        this.sbTime.append(this.iMin).append(":").append("00");
        this.prepareScore();
        this.prepareFormationScreen(true);
        this.updateStatusBar();
    }

    public void prepareLos() {
        bStop = false;
        this.bCoinFlip = false;
        this.iBallPosX = 0;
        this.iInc = 0;
        pitch.updateMap();
        pitch.sortPlayers();
        pitch.setScrollToMiddle();
        this.strTexts[0] = null;
        this.strTexts[1] = null;
        this.strTexts[2] = null;
        this.strTexts[3] = null;
        Resources.vecMultipleLines = Texts.separateText(MyApplication.resTxt.getString("TOSS"), 11 * Resources.iTableW);
        if (Resources.vecMultipleLines.size() != 1) {
            this.strTexts[0] = Resources.vecMultipleLines.elementAt(0).toString();
            this.strTexts[1] = Resources.vecMultipleLines.elementAt(1).toString();
        } else {
            this.strTexts[0] = Resources.vecMultipleLines.elementAt(0).toString();
        }
        if (!bCup) {
            this.iSec = Globals.iHalfTimeSec;
            this.iMin = Globals.iHalfTimeMin;
        } else {
            this.iSec = Globals.iCupHalfTimeSec;
            this.iMin = Globals.iCupHalfTimeMin;
        }
        this.setTestTime();
        this.sbTime.setLength(0);
        this.sbTime.append(this.iMin).append(":").append(this.iSec);
        this.updateStatusBar();
        iMode = 14;
    }

    private void keyPressedModePlay(Key pKey) {
    }

    private void keyPressedModePause(Key pKey) {
    }

    private void keyPressedModeGameOver(Key pKey) {
    }

    public void activateMenuItem(int iSelectedMenuItem) {
        switch (iMode) {
            case 3: {
                break;
            }
        }
    }

    private void restartGame() {
    }

    private void keyPressedModeRestart(Key pKey) {
    }

    public void keyPressed(Key pKey) {
        if (!MyApplication.isMusicPlaying()) {
            MyApplication.setMusicIsResumed(true);
            Sounds.setVolume(100);
            Sounds.setMusicVol(100);
            if (Globals.bMusic && !Sounds.musicPlaying()) {
                Sounds.playGameMusic(0L);
            }
        }
        switch (iMode) {
            case 14: {
                if (pKey.iValue == Keys.KEY_FNLEFT || pKey.iGameAction == Keys.KEY_FNLEFT) {
                    if (bStop) {
                        str2 = null;
                        pitch.setScoreTeam(iSelectedTeam == 0 ? pitch.getTeam1() : pitch.getTeam2());
                        this.prepareKickOff();
                        return;
                    }
                    bStop = true;
                    iSelectedTeam = Common.getRandomUInt(2);
                    this.iInc = iSelectedTeam == 1 ? -5 : 5;
                    str2 = iSelectedTeam == 1 ? MyApplication.resTxt.getString("TOSS_WIN") : MyApplication.resTxt.getString("TOSS_LOST");
                    System.out.println("str2: " + str2);
                    Resources.vecMultipleLines = Texts.separateText(str2, 11 * Resources.iTableW);
                    this.strTexts[2] = Resources.vecMultipleLines.elementAt(0).toString();
                    if (Resources.vecMultipleLines.size() != 1) {
                        this.strTexts[3] = Resources.vecMultipleLines.elementAt(1).toString();
                    }
                    return;
                }
                if (pKey.iValue != Keys.KEY_FNRIGHT && pKey.iGameAction != Keys.KEY_FNRIGHT) break;
                this.callPause();
                break;
            }
            case 12: {
                break;
            }
            case 2: 
            case 8: 
            case 9: {
                if (pKey.iValue == 49) {
                    pitch.getActivePlayer().pressButton1();
                } else if (pKey.iValue == 55) {
                    pitch.getActivePlayer().pressButton2();
                }
                if ((pKey.iValue == 53 || pKey.iGameAction == 8) && pitch.getActivePlayer() != null) {
                    pitch.getActivePlayer().pressButton2();
                }
                if (this.bTesting) {
                    if (pKey.iValue == 57) {
                        pitch.getTeam1().setScore(1);
                        this.prepareScore();
                    }
                    if (pKey.iValue == 51) {
                        pitch.getTeam2().setScore(1);
                        this.prepareScore();
                    }
                }
                this.keyPressedModePlay(pKey);
                break;
            }
            case 17: {
                if (pKey.iValue == 50 || pKey.iGameAction == 1) {
                    if (--this.iSelectedAtt <= 0) {
                        this.iSelectedAtt = 0;
                    }
                } else if (pKey.iValue == 56 || pKey.iGameAction == 6) {
                    if (++this.iSelectedAtt >= 4) {
                        this.iSelectedAtt = 4;
                    }
                } else if (pKey.iValue == Keys.KEY_FNLEFT || pKey.iGameAction == Keys.KEY_FNLEFT) {
                    ScreenGame.getPitch().getTeam1().changeFormation(Globals.iFormation);
                    this.prepareCupInfo();
                    iSelected = 0;
                } else if ((pKey.iValue == 53 || pKey.iGameAction == 8) && Globals.iPlayerTeamProperties[this.iSelectedAtt] < 5 && iAddPoint > 0) {
                    int n = this.iSelectedAtt;
                    Globals.iPlayerTeamProperties[n] = Globals.iPlayerTeamProperties[n] + 1;
                    --iAddPoint;
                }
                this.prepareTexts(this.iSelectedAtt);
                break;
            }
            case 16: {
                if (pKey.iValue == 52 || pKey.iGameAction == 2) {
                    if (--iFormation <= 0) {
                        iFormation = 0;
                    }
                    Globals.changeFormation(iFormation);
                } else if (pKey.iValue == 54 || pKey.iGameAction == 5) {
                    if (++iFormation > Globals.iFormations - 1) {
                        iFormation = Globals.iFormations - 1;
                    }
                    Globals.changeFormation(iFormation);
                }
                if (pKey.iValue == Keys.KEY_FNLEFT || pKey.iGameAction == Keys.KEY_FNLEFT) {
                    ScreenGame.getPitch().getTeam1().changeFormation(Globals.iFormation);
                    if (this.bCoinFlip) {
                        this.prepareLos();
                    } else {
                        this.switchSides();
                    }
                }
                this.pMyApplication.repaintScreen();
                break;
            }
            case 13: {
                if (pKey.iValue == Keys.KEY_FNRIGHT) {
                    this.callPause();
                    break;
                }
                if (pKey.iValue != Keys.KEY_FNLEFT) break;
                this.evaluateGameOver();
                break;
            }
            case 23: {
                if (pKey.iValue != Keys.KEY_FNLEFT) break;
                this.afterMatchActions();
                break;
            }
            case 21: {
                if (pKey.iValue != Keys.KEY_FNLEFT) break;
                MyApplication.cup.resetCup();
                this.callMenu();
                break;
            }
            case 15: {
                if (pKey.iValue != Keys.KEY_FNLEFT) break;
                Globals.iEnemyTeamIdx = MyApplication.cup.getOponentTeamNation();
                Resources.loadTeams(Globals.iMyTeamIdx + 1, Globals.iEnemyTeamIdx + 1);
                this.startGame();
                break;
            }
            case 20: {
                if (pKey.iValue != Keys.KEY_FNLEFT && pKey.iGameAction != Keys.KEY_FNLEFT || !this.bIsWinner) break;
                this.bIsWinner = false;
                Globals.deletCup();
                this.callMenu();
                return;
            }
            case 19: {
                if (pKey.iValue == Keys.KEY_FNLEFT || pKey.iGameAction == Keys.KEY_FNLEFT) {
                    this.callMenu();
                    break;
                }
                if (pKey.iValue != Keys.KEY_FNRIGHT && pKey.iGameAction != Keys.KEY_FNRIGHT) break;
                iMode = 3;
                break;
            }
            case 3: {
                if (pKey.iValue == 53 || pKey.iGameAction == 8) {
                    this.executeActionSubmenu();
                    break;
                }
                if (pKey.iValue == 50 || pKey.iGameAction == 1) {
                    if (--iPauseIdx >= 0) break;
                    iPauseIdx = 0;
                    break;
                }
                if (pKey.iValue != 56 && pKey.iGameAction != 6 || ++iPauseIdx <= 3) break;
                iPauseIdx = 3;
                break;
            }
            case 4: {
                this.keyPressedModeGameOver(pKey);
                break;
            }
            case 5: {
                this.keyPressedModeRestart(pKey);
                break;
            }
            case 11: {
                break;
            }
            case 18: {
                if (pKey.iValue == Keys.KEY_FNLEFT || pKey.iGameAction == Keys.KEY_FNLEFT) {
                    iMode = 3;
                    break;
                }
                if (pKey.iValue == 50 || pKey.iGameAction == 1) {
                    Resources.scrollDown();
                    break;
                }
                if (pKey.iValue != 56 && pKey.iGameAction != 6) break;
                Resources.scrollUp();
                break;
            }
            case 10: {
                if (pKey.iValue == Keys.KEY_FNLEFT || pKey.iGameAction == Keys.KEY_FNLEFT) {
                    if (iMessageType == 0) {
                        this.prepareCorner();
                        break;
                    }
                    if (iMessageType == 1) {
                        this.prepareOut();
                        break;
                    }
                    if (iMessageType == 2) {
                        this.prepareFoul();
                        break;
                    }
                    if (iMessageType == 3) {
                        this.prepareKickOff();
                        break;
                    }
                    if (iMessageType == 4) {
                        this.prepareFormationScreen(false);
                        break;
                    }
                    if (iMessageType != 5) break;
                    this.setSuddenDeath();
                    break;
                }
                if (pKey.iValue != Keys.KEY_FNRIGHT && pKey.iGameAction != Keys.KEY_FNRIGHT) break;
                this.callPause();
            }
        }
        if (pKey.iValue == 48) {
            this.releasePlayer();
            ScreenGame.getPitch().unPauseGame();
        }
    }

    public void executeActionSubmenu() {
        if (iPauseIdx == 0) {
            this.unPause();
        } else if (iPauseIdx == 1) {
            this.strTexts[0] = MyApplication.resTxt.getString("QUESTION");
            this.iTextsPosX[0] = Resources.WIDTH - Texts.getTextWidth(this.strTexts[0]) >> 1;
            iMode = 19;
            this.pMyApplication.repaintScreen();
        } else if (iPauseIdx == 2) {
            boolean bl = Globals.bMusic = !Globals.bMusic;
            if (Globals.bMusic) {
                Sounds.playGameMusic(0L);
            } else {
                Sounds.stopMusic();
            }
            Globals.save();
        } else if (iPauseIdx == 3) {
            iTextPosY = Resources.HEIGHT - 11 * Resources.iTableH >> 1;
            ScreenMenu.prepareInstructionText(9 * Resources.iTableW, 11 * Resources.iTableH);
            this.iInstructionArowsX = (Resources.WIDTH - 9 * Resources.iTableW >> 1) + 9 * Resources.iTableW - Resources.iMenuArrSmallW;
            this.iInstructionArowsY = Resources.HEIGHT - 11 * Resources.iTableH >> 1;
            iMode = 18;
        }
    }

    public void keyReleased(Key pKey) {
        switch (iMode) {
            case 16: {
                break;
            }
            case 17: {
                break;
            }
            case 2: 
            case 8: 
            case 9: {
                if (pKey.iValue == 55 || pKey.iValue == 49) {
                    bHasBeenReleased = true;
                }
                if (pKey.iValue == 53 || pKey.iGameAction == 8) {
                    bHasBeenReleased = true;
                    break;
                }
                if (pKey.iValue != Keys.KEY_FNRIGHT && pKey.iGameAction != Keys.KEY_FNRIGHT) break;
                this.callPause();
                break;
            }
            case 11: {
                if (!bGameIsReady) break;
                Common.getNormVector(this.iVec, ScreenGame.getPitch().getBall().getBallX(), ScreenGame.getPitch().getBall().getBallY(), fbForKickOff.getPosX(), fbForKickOff.getPosY());
                ScreenGame.getPitch().getBall().kick(this.iVec[0], this.iVec[1], 80);
                break;
            }
            case 12: {
                if (fbForCatch != null) {
                    if (ScreenGame.getPitch().getBall().getOwner() != null && ScreenGame.getPitch().getBall().getOwner() == fbForCatch) {
                        return;
                    }
                    Common.getNormVector(this.iVec, ScreenGame.getPitch().getBall().getBallX(), ScreenGame.getPitch().getBall().getBallY(), fbForCatch.getPosX(), fbForCatch.getPosY());
                    ScreenGame.getPitch().getBall().kick(this.iVec[0], this.iVec[1], 30);
                }
                bHasBeenReleased = false;
            }
        }
    }

    public void updatePlayer() {
        this.iDirrX = iPlayerPosX + (Common.COS(this.iDirrAngle) << 3 >> 8);
        this.iDirrY = iPlayerPosY + (Common.SIN(this.iDirrAngle) << 3 >> 8);
        Common.getNormVector(this.iVec, iPlayerPosX, iPlayerPosY, this.iDirrX, this.iDirrY);
    }

    private void prepareTexts() {
        ScreenGame.strEndTexts[0] = MyApplication.resTxt.getString("COUNTRY");
        ScreenGame.strEndTexts[1] = MyApplication.resTxt.getString("OVER_1");
        ScreenGame.strEndTexts[2] = MyApplication.resTxt.getString("OVER_2");
        ScreenGame.strEndTexts[3] = MyApplication.resTxt.getString("OVER_4");
    }

    private void prepareCupInfo() {
        iCupInfoPosY = (Resources.HEIGHT - 13 * Resources.iTableH >> 1) + 10;
        Globals.saveCup();
        if (MyApplication.cup.getCurrentCupPhase() == 7) {
            if (this.bPlayerIsWinner) {
                this.callResultWinTheCup();
            }
            if (!this.bPlayerIsWinner) {
                iAfterMAtch = 2;
                iMode = 23;
            }
        } else {
            iAfterMAtch = 0;
            iMode = 23;
        }
    }

    public void paintScreen(Graphics g) {
        switch (iMode) {
            case 14: {
                this.paintLosScreen(g);
                break;
            }
            case 13: {
                this.paintGame(g);
                this.paintMatchOver(g);
                this.paintPauseButton(g);
                Resources.paintLeftButton(g, 2);
                break;
            }
            case 23: {
                this.paintAfterMatch(g);
                break;
            }
            case 21: {
                this.paintCupTxt(g);
                break;
            }
            case 15: {
                this.paintCupInfo(g);
                break;
            }
            case 2: {
                this.paintGame(g);
                break;
            }
            case 16: {
                this.paintFormations(g);
                break;
            }
            case 17: {
                this.paintModeAttributes(g);
                break;
            }
            case 20: {
                this.paintModeResult(g);
                break;
            }
            case 10: {
                this.paintMessage(g);
                break;
            }
            case 12: {
                g.setColor(0xFFFFFF);
                g.fillRect(0, 0, Resources.WIDTH, Resources.HEIGHT);
                pitch.paint(g);
                this.paintStatusBar(g);
                this.paintPauseButton(g);
                break;
            }
            case 11: {
                g.setColor(0xFFFFFF);
                g.fillRect(0, 0, Resources.WIDTH, Resources.HEIGHT);
                pitch.paint(g);
                this.paintStatusBar(g);
                break;
            }
            case 8: {
                g.setColor(0xFFFFFF);
                g.fillRect(0, 0, Resources.WIDTH, Resources.HEIGHT);
                pitch.paint(g);
                this.paintStatusBar(g);
                Resources.paintControlers(g, this.iControlerSprite1, this.iControlerSprite2);
                break;
            }
            case 9: {
                g.setColor(0xFFFFFF);
                g.fillRect(0, 0, Resources.WIDTH, Resources.HEIGHT);
                pitch.paint(g);
                this.paintStatusBar(g);
                Resources.paintControlers(g, this.iControlerSprite1, this.iControlerSprite2);
                if (Resources.bEnableTouch) break;
                this.paintPauseButton(g);
                break;
            }
            case 19: {
                g.setClipRegion(0, 0, Resources.WIDTH, Resources.HEIGHT);
                Resources.paintTutorialWin(g);
                Resources.paintLeftButton(g, 2);
                Resources.paintRightButton(g, 3);
                Texts.drawTextAtPos(g, this.iTextsPosX[0], Resources.HEIGHT - Texts.getFontHeight() >> 1, this.strTexts[0]);
                break;
            }
            case 3: {
                int iAllSpace = 3 * Resources.SPACE_IN_PAUSE_MENU;
                pitch.paint(g);
                this.paintStatusBar(g);
                g.setClipRegion(0, 0, Resources.WIDTH, Resources.HEIGHT);
                Resources.paintIngaemWindow(g, 10, 10);
                if (++iBlick > 200) {
                    iBlick = 0;
                }
                for (int i = 0; i < 4; ++i) {
                    Resources.pSprIngame.setFrame(i);
                    Resources.pSprIngame.setPosition(Resources.WIDTH - Resources.iIngameMenuW >> 1, (Resources.HEIGHT - 4 * Resources.iIngameMenuH - iAllSpace >> 1) + i * (Resources.iIngameMenuH + Resources.SPACE_IN_PAUSE_MENU));
                    Resources.pSprOnOff.setFrame(Globals.bMusic ? 0 : 1);
                    Resources.pSprOnOff.setPosition((Resources.WIDTH - Resources.iIngameMenuW >> 1) + Resources.iOnOffPosX, (Resources.HEIGHT - 4 * Resources.iIngameMenuH - iAllSpace >> 1) + 2 * (Resources.iIngameMenuH + Resources.SPACE_IN_PAUSE_MENU) + Resources.iOnOffPosY);
                    if (iPauseIdx != i) {
                        Resources.pSprIngame.paint(g);
                        if (i != 2) continue;
                        Resources.pSprOnOff.paint(g);
                        continue;
                    }
                    if (iBlick % 20 > 10) continue;
                    Resources.pSprIngame.paint(g);
                    Resources.pSprOnOff.paint(g);
                }
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                break;
            }
            case 18: {
                Resources.paintIngaemWindow(g, 10, 12);
                Resources.paintLeftButton(g, 2);
                Resources.drawMultilineText(g, 0, iTextPosY);
                if (Resources.iStartLine != 0) {
                    Resources.pSprMenuArrSmall.setFrame(2);
                    Resources.pSprMenuArrSmall.setPosition(this.iInstructionArowsX, this.iInstructionArowsY);
                    Resources.pSprMenuArrSmall.paint(g);
                }
                if (Resources.iStartLine == Resources.iEndScroll) break;
                Resources.pSprMenuArrSmall.setFrame(3);
                Resources.pSprMenuArrSmall.setPosition(this.iInstructionArowsX, this.iInstructionArowsY + 10 * Resources.iTableW + 10);
                Resources.pSprMenuArrSmall.paint(g);
                break;
            }
            case 22: {
                this.paintGame(g);
            }
        }
    }

    private void paintLosScreen(Graphics g) {
        pitch.paint(g);
        this.paintStatusBar(g);
        Resources.paintIngaemWindow(g, 12, 10);
        int x = Resources.WIDTH - Resources.iCoinW >> 1;
        int y = Resources.HEIGHT - Resources.iCoinH >> 1;
        if (!bStop) {
            if (++iFrame > 6) {
                iFrame = 2;
            }
        } else {
            iFrame = iSelectedTeam;
        }
        Resources.pSprCoin.setFrame(iFrame);
        Resources.pSprCoin.setPosition(x, y);
        Resources.pSprCoin.paint(g);
        Resources.paintLeftButton(g, 2);
        if (this.strTexts[0] != null) {
            Texts.drawTextAtPos(g, Resources.WIDTH - Texts.getTextWidth(this.strTexts[0]) >> 1, y - Texts.getFontHeight() * 2, this.strTexts[0]);
        }
        if (this.strTexts[1] != null) {
            Texts.drawTextAtPos(g, Resources.WIDTH - Texts.getTextWidth(this.strTexts[1]) >> 1, y - Texts.getFontHeight(), this.strTexts[1]);
        }
        Resources.pSprFootBall.setFrame(0);
        Resources.pSprFootBall.setPosition((Resources.WIDTH - Resources.iBallW >> 1) + this.iBallPosX, y += Resources.iCoinH);
        Resources.pSprFootBall.paint(g);
        Texts.drawTextAtPos(g, Resources.TEXTS_IN_TABLE, y, Globals.strNations[Globals.iMyTeamIdx]);
        Texts.drawTextAtPos(g, Resources.WIDTH - Texts.getTextWidth(Globals.strNations[Globals.iEnemyTeamIdx]) - Resources.TEXTS_IN_TABLE, y, Globals.strNations[Globals.iEnemyTeamIdx]);
        y += Texts.getFontHeight() << 1;
        if (str2 != null) {
            if (this.strTexts[3] == null) {
                if (this.strTexts[2] != null) {
                    Texts.drawTextAtPos(g, Resources.WIDTH - Texts.getTextWidth(this.strTexts[2]) >> 1, y, this.strTexts[2]);
                }
            } else {
                if (this.strTexts[2] != null) {
                    Texts.drawTextAtPos(g, Resources.WIDTH - Texts.getTextWidth(this.strTexts[2]) >> 1, y - Texts.getFontHeight(), this.strTexts[2]);
                }
                if (this.strTexts[3] != null) {
                    Texts.drawTextAtPos(g, Resources.WIDTH - Texts.getTextWidth(this.strTexts[3]) >> 1, y, this.strTexts[3]);
                }
            }
        }
        this.paintPauseButton(g);
    }

    public void prepareForamtionsScreen() {
        this.iSmalSqW = Resources.iFormationW * 2 / 15;
        this.iSmalSqH = Resources.iFormationH / 15;
    }

    public void paintFormations(Graphics g) {
        ScreenGame.getPitch().paintGrass(g, 0, 0);
        Resources.paintIngaemWindow(g, 10, 12);
        int iPosX = Resources.WIDTH - (Resources.iFormationW << 1) >> 1;
        int iPosY = Resources.HEIGHT - Resources.iFormationH >> 1;
        int iArrowPosY = Resources.HEIGHT - Resources.iMenuArrSmallH >> 1;
        Texts.drawTextAtPos(g, this.iTextsPosX[0], iPosY - Texts.getFontHeight() * 2, this.strTexts[0]);
        Resources.pSprFormations.setHorizontalFlip(false);
        Resources.pSprFormations.setFrame(0);
        Resources.pSprFormations.setPosition(iPosX, iPosY);
        Resources.pSprFormations.paint(g);
        Resources.pSprFormations.setHorizontalFlip(true);
        Resources.pSprFormations.setFrame(0);
        Resources.pSprFormations.setPosition(iPosX + Resources.iFormationW, iPosY);
        Resources.pSprFormations.paint(g);
        iTextPosX = Resources.WIDTH - Texts.getTextWidth(Globals.strFormations[iFormation]) >> 1;
        iTextPosY = iPosY + Resources.iFormationH + Texts.getFontHeight();
        Texts.drawTextAtPos(g, iTextPosX, iTextPosY, Globals.strFormations[iFormation]);
        if (iFormation != 0) {
            Resources.pSprMenuArrSmall.setFrame(0);
            Resources.pSprMenuArrSmall.setPosition(iPosX - Resources.iMenuArrSmallW - 2, iArrowPosY);
            Resources.pSprMenuArrSmall.paint(g);
        }
        if (iFormation != Globals.iFormations - 1) {
            Resources.pSprMenuArrSmall.setFrame(1);
            Resources.pSprMenuArrSmall.setPosition(iPosX + (Resources.iFormationW << 1) + 2, iArrowPosY);
            Resources.pSprMenuArrSmall.paint(g);
        }
        g.setColor(0);
        for (int i = 0; i < 10; ++i) {
            int iPlayerX = Pitch.getIdxXByQuad(224 - Pitch.getAttQuadByPos(Globals.iFormation[i]));
            int iPlayerY = Pitch.getIdxYByQuad(224 - Pitch.getAttQuadByPos(Globals.iFormation[i]));
            g.fillRect(iPosX + iPlayerX * this.iSmalSqW, iPosY + 20 + iPlayerY * this.iSmalSqH, 5, 5);
        }
        g.fillRect((Resources.WIDTH >> 1) - 2, iPosY + Resources.iFormationH - 15, 5, 5);
        Resources.paintLeftButton(g, 2);
    }

    public void prepareAttributes() {
        this.iItemWidth = Resources.WIDTH - 50;
        this.iItemHeight = Resources.iOptIconH - 20;
        this.iSpaceItems = 10;
        this.iTextDifY = this.iItemHeight - Texts.getFontHeight() >> 1;
        this.iSelectorPosX = Resources.WIDTH - this.iItemWidth >> 1;
        ++iAddPoint;
        this.iSelectedAtt = 0;
        this.iDiff = (Resources.HEIGHT - 14 * Resources.iTableH >> 1) + Texts.getFontHeight();
        this.vecText.setSize(0);
        this.vecText = Texts.separateText(MyApplication.resTxt.getString("ATT_HEADER"), this.iItemWidth);
        for (int i = 0; i < this.vecText.size(); ++i) {
            this.iHeaderPosX[i] = Resources.WIDTH - Texts.getTextWidth(this.vecText.elementAt(i).toString()) >> 1;
        }
        this.iOldItem = -1;
        this.prepareTexts(this.iSelectedAtt);
        iMode = 17;
    }

    public void prepareTexts(int idx) {
        if (idx == 0) {
            Resources.prepareText("ATT_DES_1", this.iItemWidth, this.iItemWidth);
        } else if (idx == 1) {
            Resources.prepareText("ATT_DES_2", this.iItemWidth, this.iItemWidth);
        } else if (idx == 2) {
            Resources.prepareText("ATT_DES_3", this.iItemWidth, this.iItemWidth);
        } else if (idx == 3) {
            Resources.prepareText("ATT_DES_4", this.iItemWidth, this.iItemWidth);
        } else if (idx == 4) {
            Resources.prepareText("ATT_DES_5", this.iItemWidth, this.iItemWidth);
        }
    }

    public void paintModeAttributes(Graphics g) {
        pitch.paint(g);
        g.setClipRegion(0, 0, Resources.WIDTH, Resources.HEIGHT);
        Resources.paintIngaemWindow(g, 11, 14);
        this.iDiffY = this.iDiff;
        for (int j = 0; j < this.vecText.size(); ++j) {
            Texts.drawTextAtPos(g, this.iHeaderPosX[j], this.iDiffY, this.vecText.elementAt(j).toString());
            this.iDiffY += Texts.getFontHeight();
        }
        this.iDiffY += 5;
        for (int i = 0; i < 5; ++i) {
            if (i == this.iSelectedAtt) {
                g.setColor(0xCCE000);
            } else {
                g.setColor(14479872);
            }
            g.fillRect(this.iSelectorPosX, this.iDiffY, this.iItemWidth, this.iItemHeight);
            Texts.drawTextAtPos(g, this.iSelectorPosX + 5, this.iDiffY + this.iTextDifY, Globals.strAttributes[i]);
            Texts.drawTextAtPos(g, this.iSelectorPosX + this.iItemWidth - Texts.getTextWidth(Globals.iPlayerTeamProperties[i] + "/5 "), this.iDiffY + this.iTextDifY, Globals.iPlayerTeamProperties[i] + "/5 ");
            this.iDiffY += this.iItemHeight + this.iSpaceItems;
        }
        Resources.drawMultilineText(g, 0, this.iDiffY);
        Resources.paintLeftButton(g, 2);
    }

    public void paintGame(Graphics g) {
        pitch.paint(g);
        this.paintStatusBar(g);
        this.paintPauseButton(g);
        if (iMode != 13) {
            Resources.paintControlers(g, this.iControlerSprite1, this.iControlerSprite2);
        }
    }

    public void prepareScore() {
        this.sb.setLength(0);
        this.sb.append(Globals.strNations[Globals.iMyTeamIdx]).append(" ").append(pitch.getTeam1().getScore()).append(" - ").append(pitch.getTeam2().getScore()).append(" ").append(Globals.strNations[Globals.iEnemyTeamIdx]);
        iScorePosX = Resources.WIDTH - Texts.getTextWidth(this.sb.toString()) >> 1;
        this.updateStatusBar();
    }

    public void paintStatusBar(Graphics g) {
        g.setClipRegion(0, 0, Resources.WIDTH, Resources.HEIGHT);
        Resources.pImgStatusBaBuff.drawAtPoint(g, 0, 0);
    }

    public void updateStatusBar() {
        if (iMode == 1) {
            return;
        }
        Resources.pBackBufferG.setColor(197123);
        Resources.pBackBufferG.fillRect(0, 0, WIDTH, Resources.STATUS_BAR_H);
        Resources.pBackBufferG.setColor(16448769);
        Resources.pBackBufferG.fillRect(0, 0, WIDTH, Resources.STATUS_BAR_H - 1);
        Resources.pImgTime.drawAtPoint(Resources.pBackBufferG, 2, iTimerPosY);
        Texts.drawTextAtPos(Resources.pBackBufferG, iScorePosX, iTextsPosY, this.sb.toString());
        Texts.drawTextAtPos(Resources.pBackBufferG, Resources.iImgTimeW + 5, iTextsPosY, this.sbTime.toString());
    }

    public void paintPauseButton(Graphics g) {
        g.setClipRegion(0, 0, Resources.WIDTH, Resources.HEIGHT);
        Resources.pImgPause.drawAtPoint(g, Resources.WIDTH - Resources.iPauseW - 5 - Resources.iButtonPosXBB, Resources.HEIGHT - Resources.iPauseH - 5);
    }

    public void updateTime() {
        this.iNewTime = System.currentTimeMillis() / 1000L;
        if (this.iOldTime != this.iNewTime) {
            this.iOldTime = this.iNewTime;
            if (--this.iSec < 0) {
                this.iSec = 59;
                --this.iMin;
            }
            if (this.iMin == 0 && this.iSec == 0) {
                --this.iHalftime;
                if (this.iHalftime == 1) {
                    if (!bCup) {
                        this.iSec = Globals.iHalfTimeSec;
                        this.iMin = Globals.iHalfTimeMin;
                    } else {
                        this.iSec = Globals.iCupHalfTimeSec;
                        this.iMin = Globals.iCupHalfTimeMin;
                    }
                    this.setTestTime();
                    this.callMessage(4);
                }
                if (this.iHalftime <= 0) {
                    if (bCup && MyApplication.cup.iCurrentPhaseOfChampionship > 2 && pitch.getTeam1().getScore() == pitch.getTeam2().getScore()) {
                        this.callMessage(5);
                        return;
                    }
                    this.prepareEndTable();
                }
            }
            this.sbTime.setLength(0);
            this.sbTime.append(this.iMin);
            this.sbTime.append(":");
            if (this.iSec < 10) {
                this.sbTime.append("0").append(this.iSec);
            } else {
                this.sbTime.append(this.iSec);
            }
            this.updateStatusBar();
        }
    }

    public void pointerDragged(int x, int y) {
        switch (iMode) {
            case 18: {
                if (!Resources.dragText(y)) break;
                Application.getSingleton().repaintScreen();
            }
        }
    }

    public void pointerPressed(int x, int y) {
        switch (iMode) {
            case 14: {
                if (Resources.pressedLeftButton(x, y)) {
                    if (bStop) {
                        pitch.setScoreTeam(iSelectedTeam == 0 ? pitch.getTeam1() : pitch.getTeam2());
                        this.prepareKickOff();
                        str2 = null;
                    }
                    bStop = true;
                    iSelectedTeam = Common.getRandomUInt(100) < 50 ? 1 : 0;
                    this.iInc = iSelectedTeam == 1 ? -5 : 5;
                    str2 = iSelectedTeam == 1 ? MyApplication.resTxt.getString("TOSS_WIN") : MyApplication.resTxt.getString("TOSS_LOST");
                    System.out.println("str2: " + str2);
                    Resources.vecMultipleLines = Texts.separateText(str2, 11 * Resources.iTableW);
                    System.out.println("vytvorilo pekne: " + Resources.vecMultipleLines.size());
                    System.out.println("1 " + Resources.vecMultipleLines.elementAt(0).toString());
                    this.strTexts[2] = Resources.vecMultipleLines.elementAt(0).toString();
                    if (Resources.vecMultipleLines.size() != 1) {
                        this.strTexts[3] = Resources.vecMultipleLines.elementAt(1).toString();
                    }
                    return;
                }
                if (!Resources.isPause(x, y)) break;
                this.callPause();
                return;
            }
            case 12: {
                if (Resources.isPause(x, y)) {
                    this.callPause();
                    return;
                }
                Common.getNormVector(this.iVec, ScreenGame.getPitch().getBall().getBallX(), ScreenGame.getPitch().getBall().getBallY(), fbForCatch.getPosX(), fbForCatch.getPosY());
                ScreenGame.getPitch().getBall().kick(this.iVec[0], this.iVec[1], 30);
                break;
            }
            case 20: {
                if (!Resources.pressedLeftButton(x, y) || !this.bIsWinner) break;
                this.bIsWinner = false;
                Globals.deletCup();
                this.callMenu();
                return;
            }
            case 3: {
                int iMenuPosY = Resources.HEIGHT - 4 * Resources.iIngameMenuH - 30 >> 1;
                int iMenuPosY2 = iMenuPosY + 4 * Resources.iIngameMenuH + 30;
                int iMenuPosX = Resources.WIDTH - Resources.iIngameMenuW >> 1;
                if (x <= iMenuPosX || x >= iMenuPosX + Resources.iIngameMenuW || y <= iMenuPosY || y >= iMenuPosY2) break;
                iPauseIdx = (y - iMenuPosY) / (Resources.iIngameMenuH + 10);
                this.executeActionSubmenu();
                this.pMyApplication.repaintScreen();
                break;
            }
            case 4: {
                break;
            }
            case 21: {
                if (!Resources.pressedLeftButton(x, y)) break;
                MyApplication.cup.resetCup();
                this.callMenu();
                break;
            }
            case 5: {
                if (Resources.pressedRightButton(x, y)) {
                    this.callPause();
                    return;
                }
                if (!Resources.pressedLeftButton(x, y)) break;
                this.restartGame();
                this.callPlayMode();
                return;
            }
            case 2: 
            case 8: 
            case 9: {
                if (Resources.isButton1(x, y)) {
                    pitch.getActivePlayer().pressButton1();
                }
                if (Resources.isButton2(x, y)) {
                    pitch.getActivePlayer().pressButton2();
                }
                if (Resources.isPause(x, y)) {
                    this.callPause();
                }
                if (!Resources.isInDirectionButton(x, y)) break;
                Resources.returnAction(x, y);
                break;
            }
            case 16: {
                if (Resources.pressedLeftButton(x, y)) {
                    ScreenGame.getPitch().getTeam1().changeFormation(Globals.iFormation);
                    if (this.bCoinFlip) {
                        this.prepareLos();
                        break;
                    }
                    this.switchSides();
                    break;
                }
                if (x < Resources.WIDTH >> 1) {
                    if (--iFormation <= 0) {
                        iFormation = 0;
                    }
                    Globals.changeFormation(iFormation);
                    break;
                }
                if (++iFormation > Globals.iFormations - 1) {
                    iFormation = Globals.iFormations - 1;
                }
                Globals.changeFormation(iFormation);
                break;
            }
            case 17: {
                if (Resources.pressedLeftButton(x, y)) {
                    ScreenGame.getPitch().getTeam1().changeFormation(Globals.iFormation);
                    this.prepareCupInfo();
                    iSelected = 0;
                    return;
                }
                this.iTouchY = this.iDiff + this.vecText.size() * Texts.getFontHeight() + 5;
                if (y <= this.iTouchY || y >= this.iTouchY + 5 * (this.iItemHeight + this.iSpaceItems)) break;
                this.iSelectedAtt = (y - this.iTouchY) / (this.iItemHeight + this.iSpaceItems);
                if (this.iSelectedAtt == this.iOldItem) {
                    if (Globals.iPlayerTeamProperties[this.iSelectedAtt] < 5 && iAddPoint > 0) {
                        int n = this.iSelectedAtt;
                        Globals.iPlayerTeamProperties[n] = Globals.iPlayerTeamProperties[n] + 1;
                        --iAddPoint;
                    }
                } else {
                    this.iOldItem = this.iSelectedAtt;
                }
                Application.getSingleton().repaintScreen();
                break;
            }
            case 15: {
                if (!Resources.pressedLeftButton(x, y)) break;
                Globals.iEnemyTeamIdx = MyApplication.cup.getOponentTeamNation();
                Resources.loadTeams(Globals.iMyTeamIdx + 1, Globals.iEnemyTeamIdx + 1);
                this.startGame();
                break;
            }
            case 13: {
                if (Resources.pressedLeftButton(x, y)) {
                    this.evaluateGameOver();
                    break;
                }
                if (!Resources.pressedRightButton(x, y)) break;
                this.callPause();
                break;
            }
            case 23: {
                if (!Resources.pressedLeftButton(x, y)) break;
                this.afterMatchActions();
                break;
            }
            case 10: {
                if (Resources.pressedLeftButton(x, y)) {
                    if (iMessageType == 0) {
                        this.prepareCorner();
                    }
                    if (iMessageType == 1) {
                        this.prepareOut();
                    }
                    if (iMessageType == 2) {
                        this.prepareFoul();
                    }
                    if (iMessageType == 3) {
                        this.prepareKickOff();
                    }
                    if (iMessageType == 4) {
                        this.prepareFormationScreen(false);
                    }
                    if (iMessageType != 5) break;
                    this.setSuddenDeath();
                    break;
                }
                if (!Resources.pressedRightButton(x, y)) break;
                this.callPause();
                break;
            }
            case 19: {
                if (Resources.pressedLeftButton(x, y)) {
                    this.callMenu();
                    break;
                }
                if (!Resources.pressedRightButton(x, y)) break;
                this.callPauseWithoutReturn();
                break;
            }
            case 18: {
                if (Resources.pressedLeftButton(x, y)) {
                    this.callPauseWithoutReturn();
                    break;
                }
                Resources.iPickPointY = y;
            }
        }
    }

    public void pointerReleased(int x, int y) {
        bHasBeenReleased = true;
        Resources.releaseControls();
        Resources.hasBeenReleased();
    }

    public void releasePlayer() {
        ScreenGame.getPitch().getTeam1().deselectAll();
        ScreenGame.getPitch().getTeam2().deselectAll();
        bShowGrid = false;
    }

    public void pause() {
    }

    public void onPause() {
        Sounds.setVolume(0);
        Sounds.setMusicVol(0);
        if (iMode != 3) {
            this.callPause();
        } else {
            this.callPauseWithoutReturn();
        }
    }

    public void onResume() {
    }

    public void sizeChanged() {
    }

    public void callModeFreeView(int nxtAct) {
        iFreezTime = 0;
        iNexAction = nxtAct;
        iMode = 22;
    }

    static {
        WIDTH = Application.getSingleton().getDevice().getScreen().getWidth();
        HEIGHT = Application.getSingleton().getDevice().getScreen().getHeight();
        bCanStartGame = false;
        iAddPoint = 1;
        iMessageType = 0;
        iCornerCounter = 0;
        iCornerType = 0;
        bHasBeenReleased = false;
        bGameIsReady = false;
        str2 = null;
        bStop = false;
        bCup = false;
        iRound = 1;
        iSelected = 0;
        iPauseIdx = 0;
        iBlick = 0;
        iGKAttackQuad = 1;
        bLooser = false;
        iEffectivityEnemy = 0;
        iEffectivityYou = 0;
        bSuddenDeath = false;
        cornerCoordUp = new int[]{94, 100, 50, 54, 20, 24, 33, 41, 37, 40};
        cornerCoordDn = new int[]{124, 130, 170, 174, 200, 204, 183, 191, 187, 184};
        iScrollX = 0;
        iScrollY = 0;
        iSpeedX = 6;
        iSpeedY = 4;
        iPlayerFrame = 0;
        iHeading = 12;
        bMove = false;
        iScreenScrollX = 0;
        iScreenScrollY = 0;
        iScreenAddX = iScreenScrollX << 8;
        iScreenAddY = iScreenScrollY << 8;
        bNextCupStage = false;
        bScrollLeft = false;
        bScrollRight = false;
        bScrollUp = false;
        bScrollDown = false;
        iSX = 0;
        iSY = 0;
        iOldRotAngle = 0;
        iNewRotAngle = 0;
        iRadius = 0;
        iRotationCounter = 0;
        iPlayerPosX = 20;
        iPlayerPosY = 20;
        iTmpPlayerPosX = iPlayerPosX << 8;
        iTmpPlayerPosY = iPlayerPosY << 8;
        iPlayerSpd = 3;
        iLosWinner = 0;
        strEndTexts = new String[]{MyApplication.resTxt.getString("COUNTRY"), MyApplication.resTxt.getString("OVER_1"), MyApplication.resTxt.getString("OVER_2"), MyApplication.resTxt.getString("OVER_4")};
        strValues = new String[strEndTexts.length][2];
        iPointerX = 0;
        iPointerY = 0;
        bShowGrid = false;
        iFreezTime = 0;
        iNexAction = 0;
    }
}

