/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic.spf;

import simple.video.Graphics;
import sk.inlogic.spf.FootbalPlayer;
import sk.inlogic.spf.FootballTeamAI;
import sk.inlogic.spf.Pitch;
import sk.inlogic.spf.ScreenGame;

public class FootbalTeam {
    public static final int TEAM_PLAYERS_COUNT = 11;
    public static final int PLAYERS_FOR_CYCLE = 10;
    public static final int TEAM_SIDE_UP = 2;
    public static final int TEAM_SIDE_DN = 4;
    private int iSideOfGoal = 2;
    private FootbalPlayer[] team = new FootbalPlayer[11];
    private int iTeamSide = 0;
    private Pitch pitch;
    private int iLastPlayer;
    private int iActualPlayerRun = 0;
    private int iScore = 0;
    private int iHolding = 0;
    private int iFouls = 0;
    private int iCorners = 0;
    private int[] iFormation;

    public Pitch getPitch() {
        return this.pitch;
    }

    public FootbalTeam(int side, int iSide, Pitch pitch, int[] iForm) {
        this.iTeamSide = side;
        this.pitch = pitch;
        this.iSideOfGoal = iSide;
        this.iFormation = iForm;
        this.team[0] = new FootbalPlayer(0, 2, this.iFormation[0], this);
        this.team[1] = new FootbalPlayer(1, 3, this.iFormation[1], this);
        this.team[2] = new FootbalPlayer(2, 4, this.iFormation[2], this);
        this.team[3] = new FootbalPlayer(3, 5, this.iFormation[3], this);
        this.team[4] = new FootbalPlayer(4, 6, this.iFormation[4], this);
        this.team[5] = new FootbalPlayer(5, 7, this.iFormation[5], this);
        this.team[6] = new FootbalPlayer(6, 8, this.iFormation[6], this);
        this.team[7] = new FootbalPlayer(7, 9, this.iFormation[7], this);
        this.team[8] = new FootbalPlayer(8, 10, this.iFormation[8], this);
        this.team[9] = new FootbalPlayer(9, 11, this.iFormation[9], this);
        this.team[10] = new FootbalPlayer(10, 1, 1, this);
        for (int i = 0; i < 11; ++i) {
            this.team[i].getVectorByAngle(this.team[i].getAngle());
        }
        this.resetHolding();
    }

    public void resetCatchingState() {
        for (int i = 0; i < 11; ++i) {
            this.team[i].disableIsTargetForPassing();
            this.team[i].setIsPassingTarget(false);
        }
    }

    public void changeFormation(int[] iForm) {
        this.iFormation = iForm;
        for (int i = 0; i < 10; ++i) {
            this.team[i].setVarsByRole(iForm[i]);
        }
    }

    public void switchSide() {
        this.iSideOfGoal = this.iSideOfGoal == 2 ? 4 : 2;
        this.updatePlayers();
    }

    public void updatePlayers() {
        this.team[0] = new FootbalPlayer(0, 2, this.iFormation[0], this);
        this.team[1] = new FootbalPlayer(1, 3, this.iFormation[1], this);
        this.team[2] = new FootbalPlayer(2, 4, this.iFormation[2], this);
        this.team[3] = new FootbalPlayer(3, 5, this.iFormation[3], this);
        this.team[4] = new FootbalPlayer(4, 6, this.iFormation[4], this);
        this.team[5] = new FootbalPlayer(5, 7, this.iFormation[5], this);
        this.team[6] = new FootbalPlayer(6, 8, this.iFormation[6], this);
        this.team[7] = new FootbalPlayer(7, 9, this.iFormation[7], this);
        this.team[8] = new FootbalPlayer(8, 10, this.iFormation[8], this);
        this.team[9] = new FootbalPlayer(9, 11, this.iFormation[9], this);
        this.team[10] = new FootbalPlayer(10, 1, 1, this);
    }

    public static int getOtherSideByte(int side) {
        return side == 2 ? 4 : 2;
    }

    public boolean hasBall() {
        return ScreenGame.getPitch().getBall().getTeamOwner() == this;
    }

    public int getTeamSide() {
        return this.iTeamSide;
    }

    public void update(boolean bAnotherActivity, boolean bIgnoreBall) {
        if (this.iSideOfGoal == 2) {
            this.iLastPlayer = 15;
        }
        if (this.iSideOfGoal == 4) {
            this.iLastPlayer = -1;
        }
        if (!bAnotherActivity) {
            if (++this.iActualPlayerRun > 10) {
                this.iActualPlayerRun = 0;
            }
            this.team[this.iActualPlayerRun].updateState(bIgnoreBall);
        }
        if (ScreenGame.iMode == 2) {
            if (this.iTeamSide == 1 && this.iActualPlayerRun == 10) {
                if (FootballTeamAI.isResetNeeded()) {
                    FootballTeamAI.reset();
                }
                FootballTeamAI.closestPlayerToBall();
            }
            FootballTeamAI.updateGKs(this.iTeamSide);
        }
        for (int i = 0; i < 11; ++i) {
            this.team[i].update();
            if (this.team[i].isGK()) continue;
            if (this.iSideOfGoal == 2 && this.iLastPlayer > this.team[i].getActualGridY()) {
                this.iLastPlayer = this.team[i].getActualGridY();
            }
            if (this.iSideOfGoal != 4 || this.iLastPlayer >= this.team[i].getActualGridY()) continue;
            this.iLastPlayer = this.team[i].getActualGridY();
        }
    }

    public int getScore() {
        return this.iScore;
    }

    public void setScore(int iVal) {
        this.iScore += iVal;
    }

    public void resetScore() {
        this.iScore = 0;
    }

    public int getLastPlayerY() {
        return this.iLastPlayer;
    }

    public void paint(Graphics g, int iScrollX, int iScrollY) {
        for (int i = 0; i < 11; ++i) {
            this.team[i].paint(g, iScrollX, iScrollY);
        }
    }

    public FootbalPlayer getPlayer(int iPlayerNumber) {
        return this.team[iPlayerNumber];
    }

    public void setActivePlayer(int iPlayerNumber) {
        this.team[iPlayerNumber].setActive();
    }

    public void setPassivePlayer(int iPlayerNumber) {
        this.team[iPlayerNumber].setPassive();
    }

    public int getSideOfTeam() {
        return this.iSideOfGoal;
    }

    public boolean isTeamOnBaseQuad() {
        for (int i = 0; i < 11; ++i) {
            if (this.getPlayer(i).isOnBaseQuad()) continue;
            return false;
        }
        return true;
    }

    public boolean isGoalQuad(int quad) {
        return this.getSideOfTeam() == 2 ? quad > 5 && quad < 9 : quad > 215 && quad < 219;
    }

    public FootbalPlayer returnSelected(int x, int y) {
        for (int i = 0; i < 11; ++i) {
            if (!this.getPlayer(i).isTouched(x, y)) continue;
            return this.getPlayer(i);
        }
        return null;
    }

    public void deselectAll() {
        for (int i = 0; i < 11; ++i) {
            this.getPlayer(i).deselect();
        }
    }

    public boolean isTeamOnPosition() {
        for (int i = 0; i < 11; ++i) {
            if (this.getPlayer(i).isOnTarget()) continue;
            return false;
        }
        return true;
    }

    public void incFoul() {
        ++this.iFouls;
    }

    public int getFoulCnt() {
        return this.iFouls;
    }

    public void resetFouls() {
        this.iFouls = 0;
    }

    public void incHoldingState() {
        ++this.iHolding;
    }

    public int getHoldingCnt() {
        return this.iHolding;
    }

    public void resetHolding() {
        this.iHolding = 0;
    }

    public void updateCorner() {
        ++this.iCorners;
    }

    public void resetCorner() {
        this.iCorners = 0;
    }

    public int getCorner() {
        return this.iCorners;
    }

    public void resetBallFolowing() {
        for (int i = 10; i >= 0; --i) {
            this.team[i].disableFolowingStat();
        }
    }
}

