/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic.spf;

import simple.video.Graphics;
import sk.inlogic.spf.Common;
import sk.inlogic.spf.MyApplication;
import sk.inlogic.spf.Resources;
import sk.inlogic.spf.Texts;

public class Cup {
    int INT_NULL = -999;
    private String[] group = new String[]{"A", "B", "C", "D", "E", "F", "G", "H"};
    String[] nationCode = new String[]{"BRA", "CRO", "MEX", "CMR", "ESP", "NED", "CHI", "AUS", "COL", "GRE", "CIV", "JPN", "URU", "CRC", "ENG", "ITA", "SUI", "ECU", "FRA", "HON", "ARG", "BIH", "IRN", "NIG", "GER", "POR", "GHA", "USA", "BEL", "ALG", "RUS", "KOR"};
    int iCurrentPhaseOfChampionship = 0;
    int iPlayerIndex = 0;
    int iFrame = 0;
    public static int[] iBaseFight = new int[]{0, 1, 2, 3, 0, 2, 3, 1, 0, 3, 1, 2};
    public static int[] iEightFinal = new int[]{0, 5, 8, 13, 4, 1, 12, 9, 16, 21, 24, 29, 20, 17, 28, 25};
    public static int[] iQuartFinal = new int[]{0, 2, 4, 6, 8, 10, 12, 14};
    public static int[] iSemiFinal = new int[]{0, 2, 4, 6};
    public static int[] iFinal = new int[]{0, 2};
    int[][] iCupTeams;
    int[][] iCupTeamBackup;
    int iStepX = 0;
    int iStartScoreX = 0;
    int iNumberX;
    int iCurrentGroup;
    int iGroupSize = 4;
    String strHeader;
    String strEnder;
    String strEnder2;
    int iHeaderPoX;
    int iTablePosY = 0;

    String getPlayerGroup(int idx) {
        return this.group[idx >> 2];
    }

    void createCup(int playerIdx) {
        this.iPlayerIndex = playerIdx;
        System.out.println("vytvarame cup noo teda to hej : " + this.iPlayerIndex);
        this.resetCup();
        this.setPlayerTeam(this.iPlayerIndex);
    }

    int getCurrentCupPhase() {
        return this.iCurrentPhaseOfChampionship;
    }

    void resetCup() {
        this.iCurrentPhaseOfChampionship = 0;
        this.iGroupSize = 4;
        this.iCupTeams = new int[this.nationCode.length][7];
        this.iCupTeamBackup = new int[this.nationCode.length][7];
        for (int i = 0; i < this.nationCode.length; ++i) {
            this.iCupTeams[i][0] = i;
            this.iCupTeams[i][1] = 0;
            this.iCupTeams[i][2] = 0;
            this.iCupTeams[i][3] = 0;
            this.iCupTeams[i][4] = 0;
            this.iCupTeams[i][5] = 0;
            this.iCupTeams[i][6] = 0;
        }
    }

    void releaseArray() {
        for (int i = 0; i < this.nationCode.length; ++i) {
            this.iCupTeams[i][0] = i;
            this.iCupTeams[i][1] = 0;
            this.iCupTeams[i][2] = 0;
            this.iCupTeams[i][3] = 0;
            this.iCupTeams[i][4] = 0;
            this.iCupTeams[i][5] = 0;
            this.iCupTeams[i][6] = 0;
        }
    }

    public void bubblesort(int[][] arr, int iGrpSize, int actualGroup) {
        boolean bSort = true;
        int iFrom = actualGroup * iGrpSize;
        int iTo = iFrom + iGrpSize - 1;
        while (bSort) {
            bSort = false;
            for (int i = iFrom; i < iTo; ++i) {
                if (arr[i][4] < arr[i + 1][4]) {
                    this.swapItems(i, i + 1, arr);
                    bSort = true;
                    continue;
                }
                if (arr[i][4] != arr[i + 1][4]) continue;
                if (arr[i][1] < arr[i + 1][1]) {
                    this.swapItems(i, i + 1, arr);
                    bSort = true;
                    continue;
                }
                if (arr[i][1] != arr[i + 1][1] || arr[i][5] >= arr[i + 1][5]) continue;
                this.swapItems(i, i + 1, arr);
                bSort = true;
            }
        }
    }

    public void swapItems(int idx1, int idx2, int[][] arr) {
        int[] backup = new int[]{arr[idx1][0], arr[idx1][1], arr[idx1][2], arr[idx1][3], arr[idx1][4], arr[idx1][5], arr[idx1][6]};
        arr[idx1][0] = arr[idx2][0];
        arr[idx1][1] = arr[idx2][1];
        arr[idx1][2] = arr[idx2][2];
        arr[idx1][3] = arr[idx2][3];
        arr[idx1][4] = arr[idx2][4];
        arr[idx1][5] = arr[idx2][5];
        arr[idx1][6] = arr[idx2][6];
        arr[idx2][0] = backup[0];
        arr[idx2][1] = backup[1];
        arr[idx2][2] = backup[2];
        arr[idx2][3] = backup[3];
        arr[idx2][4] = backup[4];
        arr[idx2][5] = backup[5];
        arr[idx2][6] = backup[6];
    }

    void incrementPhase() {
        ++this.iCurrentPhaseOfChampionship;
        if (this.iCurrentPhaseOfChampionship == 4) {
            this.scoreTeams(32);
            this.sortChampionship(this.iCupTeams, 8, 4);
            this.eightFinall();
            this.iGroupSize = 16;
        }
        if (this.iCurrentPhaseOfChampionship == 5) {
            this.scoreTeams(16);
            this.sortChampionship(this.iCupTeams, 8, 2);
            this.quarterFinall();
            this.iGroupSize = 8;
        }
        if (this.iCurrentPhaseOfChampionship == 6) {
            this.scoreTeams(8);
            this.sortChampionship(this.iCupTeams, 4, 2);
            this.semiFinall();
            this.iGroupSize = 4;
        }
        if (this.iCurrentPhaseOfChampionship == 7) {
            this.scoreTeams(4);
            this.sortChampionship(this.iCupTeams, 2, 2);
            this.finalMatch();
            this.iGroupSize = 2;
        }
    }

    void evaluate() {
        if (this.iCurrentPhaseOfChampionship == 0) {
            for (int i = 0; i < 32; i += 4) {
                this.evaluateMatch(i, i + 1, true);
                this.evaluateMatch(i + 2, i + 3, true);
            }
            this.iGroupSize = 4;
        } else if (this.iCurrentPhaseOfChampionship == 1) {
            for (int i = 0; i < 32; i += 4) {
                this.evaluateMatch(i, i + 2, true);
                this.evaluateMatch(i + 1, i + 3, true);
            }
            this.iGroupSize = 4;
        } else if (this.iCurrentPhaseOfChampionship == 2) {
            for (int i = 0; i < 32; i += 4) {
                this.evaluateMatch(i, i + 3, true);
                this.evaluateMatch(i + 1, i + 2, true);
            }
            this.iGroupSize = 4;
        } else if (this.iCurrentPhaseOfChampionship == 3) {
            for (int i = 0; i < 16; i += 2) {
                this.evaluateMatch(i, i + 1, false);
            }
            this.iGroupSize = 16;
        } else if (this.iCurrentPhaseOfChampionship == 4) {
            for (int i = 0; i < 16; i += 2) {
                this.evaluateMatch(i, i + 1, false);
            }
            this.iGroupSize = 16;
        } else if (this.iCurrentPhaseOfChampionship == 5) {
            for (int i = 0; i < 8; i += 2) {
                this.evaluateMatch(i, i + 1, false);
            }
            this.iGroupSize = 8;
        } else if (this.iCurrentPhaseOfChampionship == 6) {
            for (int i = 0; i < 4; i += 2) {
                this.evaluateMatch(i, i + 1, false);
            }
            this.scoreTeams(2);
            this.sortChampionship(this.iCupTeams, 1, 2);
        }
    }

    void evaluateMatch(int t1, int t2, boolean bDraw) {
        if (this.iCupTeams[t1][6] != 0 || this.iCupTeams[t2][6] != 0) {
            return;
        }
        int iStatus = Common.getRandomUInt(bDraw ? 3 : 2);
        int iGoals = Common.getRandomUInt(5);
        if (iStatus == 0) {
            int[] nArray = this.iCupTeams[t1];
            nArray[1] = nArray[1] + 1;
            int[] nArray2 = this.iCupTeams[t2];
            nArray2[2] = nArray2[2] + 1;
            int[] nArray3 = this.iCupTeams[t1];
            nArray3[5] = nArray3[5] + (iGoals == 0 ? 1 : iGoals);
        } else if (iStatus == 1) {
            int[] nArray = this.iCupTeams[t1];
            nArray[2] = nArray[2] + 1;
            int[] nArray4 = this.iCupTeams[t2];
            nArray4[1] = nArray4[1] + 1;
            int[] nArray5 = this.iCupTeams[t2];
            nArray5[5] = nArray5[5] + (iGoals == 0 ? 1 : iGoals);
        } else if (iStatus == 2) {
            int[] nArray = this.iCupTeams[t1];
            nArray[3] = nArray[3] + 1;
            int[] nArray6 = this.iCupTeams[t2];
            nArray6[3] = nArray6[3] + 1;
            int[] nArray7 = this.iCupTeams[t1];
            nArray7[5] = nArray7[5] + iGoals;
            int[] nArray8 = this.iCupTeams[t2];
            nArray8[5] = nArray8[5] + iGoals;
        }
    }

    public void eightFinall() {
        int i;
        for (i = 0; i < iEightFinal.length; i += 2) {
            this.saveArr(this.iCupTeams, this.iCupTeamBackup, iEightFinal[i], i);
            this.saveArr(this.iCupTeams, this.iCupTeamBackup, iEightFinal[i + 1], i + 1);
        }
        this.releaseArray();
        for (i = 0; i < iEightFinal.length; ++i) {
            this.saveArr(this.iCupTeamBackup, this.iCupTeams, i, i);
        }
    }

    public void quarterFinall() {
        int i;
        for (i = 0; i < iQuartFinal.length; ++i) {
            this.saveArr(this.iCupTeams, this.iCupTeamBackup, iQuartFinal[i], i);
        }
        this.releaseArray();
        for (i = 0; i < iQuartFinal.length; ++i) {
            this.saveArr(this.iCupTeamBackup, this.iCupTeams, i, i);
        }
    }

    public void semiFinall() {
        int i;
        for (i = 0; i < iSemiFinal.length; ++i) {
            this.saveArr(this.iCupTeams, this.iCupTeamBackup, iSemiFinal[i], i);
        }
        this.releaseArray();
        for (i = 0; i < iSemiFinal.length; ++i) {
            this.saveArr(this.iCupTeamBackup, this.iCupTeams, i, i);
        }
    }

    public void finalMatch() {
        int i;
        for (i = 0; i < iFinal.length; ++i) {
            this.saveArr(this.iCupTeams, this.iCupTeamBackup, iFinal[i], i);
        }
        this.releaseArray();
        for (i = 0; i < iFinal.length; ++i) {
            this.saveArr(this.iCupTeamBackup, this.iCupTeams, i, i);
        }
    }

    public void sortChampionship(int[][] arr, int nbofgroup, int groupsize) {
        for (int i = 0; i < nbofgroup; ++i) {
            this.bubblesort(arr, groupsize, i);
        }
    }

    public void saveArr(int[][] iFromArr, int[][] toArr, int from, int to) {
        toArr[to][0] = iFromArr[from][0];
        toArr[to][6] = iFromArr[from][6];
    }

    void resetScore() {
        for (int i = 0; i < 32; ++i) {
            if (this.iCupTeams[i][0] == this.INT_NULL) continue;
            this.iCupTeams[i][4] = 0;
        }
    }

    void scoreTeams(int iChampionatSize) {
        for (int i = 0; i < iChampionatSize; ++i) {
            if (this.iCupTeams[i][0] == this.INT_NULL) continue;
            this.iCupTeams[i][4] = this.iCupTeams[i][1] * 2 + this.iCupTeams[i][2] * 0 + this.iCupTeams[i][3] * 1;
        }
    }

    final void setPlayerTeam(int idx) {
        this.iCupTeams[idx][6] = 1;
    }

    final void prepareHeader() {
        if (this.iCurrentPhaseOfChampionship < 4) {
            this.strHeader = MyApplication.resTxt.getHashedString("GROUP") + " " + this.group[this.getPlayerIdx() >> 2];
        }
        if (this.iCurrentPhaseOfChampionship == 4) {
            this.strHeader = MyApplication.resTxt.getHashedString("WIN4");
        }
        if (this.iCurrentPhaseOfChampionship == 5) {
            this.strHeader = MyApplication.resTxt.getHashedString("WIN1");
        }
        if (this.iCurrentPhaseOfChampionship == 6) {
            this.strHeader = MyApplication.resTxt.getHashedString("WIN2");
        }
        if (this.iCurrentPhaseOfChampionship >= 7) {
            this.strHeader = MyApplication.resTxt.getHashedString("WIN3");
        }
        this.iHeaderPoX = Resources.WIDTH - Texts.getTextWidth(this.strHeader) >> 1;
    }

    final void paintCupInfo(Graphics g, int iScrollX, int iPosY, int iMaxH, boolean b) {
        int iTableSize = 50;
        this.iTablePosY = iMaxH - (this.iGroupSize + 2) * Texts.getFontHeight() >> 1;
        int iTextPosY = iPosY + this.iTablePosY;
        this.iStartScoreX = Texts.getTextWidth(this.nationCode[0] + " ");
        this.iNumberX = Texts.getTextWidth("0");
        this.iStepX = (Resources.WIDTH - iTableSize * 2 - Texts.getTextWidth(this.nationCode[0] + " ")) / 5;
        if (this.strHeader != null) {
            Texts.drawTextAtPos(g, this.iHeaderPoX + iScrollX, iTextPosY, this.strHeader);
        }
        Texts.drawTextAtPos(g, this.iStartScoreX + iScrollX + this.iStepX * 1 + iTableSize - this.iNumberX, iTextPosY += Texts.getFontHeight(), "W");
        Texts.drawTextAtPos(g, this.iStartScoreX + iScrollX + this.iStepX * 2 + iTableSize - this.iNumberX, iTextPosY, "L");
        Texts.drawTextAtPos(g, this.iStartScoreX + iScrollX + this.iStepX * 3 + iTableSize - this.iNumberX, iTextPosY, "D");
        Texts.drawTextAtPos(g, this.iStartScoreX + iScrollX + this.iStepX * 4 + iTableSize - this.iNumberX, iTextPosY, "G");
        Texts.drawTextAtPos(g, this.iStartScoreX + iScrollX + this.iStepX * 5 + iTableSize - this.iNumberX, iTextPosY, "P");
        iTextPosY += Texts.getFontHeight();
        g.setColor(0);
        for (int i = 0; i < this.iGroupSize; ++i) {
            this.iCurrentGroup = this.iCurrentPhaseOfChampionship < 3 ? (this.getPlayerIdx() >> 2) * 4 + i : i;
            Texts.drawTextAtPos(g, iScrollX + iTableSize, iTextPosY, this.nationCode[this.iCupTeams[this.iCurrentGroup][0]]);
            Texts.drawTextAtPos(g, this.iStartScoreX + iScrollX + this.iStepX * 1 + iTableSize - this.iNumberX, iTextPosY, String.valueOf(this.iCupTeams[this.iCurrentGroup][1]));
            Texts.drawTextAtPos(g, this.iStartScoreX + iScrollX + this.iStepX * 2 + iTableSize - this.iNumberX, iTextPosY, String.valueOf(this.iCupTeams[this.iCurrentGroup][2]));
            Texts.drawTextAtPos(g, this.iStartScoreX + iScrollX + this.iStepX * 3 + iTableSize - this.iNumberX, iTextPosY, String.valueOf(this.iCupTeams[this.iCurrentGroup][3]));
            Texts.drawTextAtPos(g, this.iStartScoreX + iScrollX + this.iStepX * 4 + iTableSize - this.iNumberX, iTextPosY, String.valueOf(this.iCupTeams[this.iCurrentGroup][5]));
            Texts.drawTextAtPos(g, this.iStartScoreX + iScrollX + this.iStepX * 5 + iTableSize - this.iNumberX, iTextPosY, String.valueOf(this.iCupTeams[this.iCurrentGroup][4]));
            if (b) {
                if (this.iCupTeams[this.iCurrentGroup][6] != 0) {
                    this.paintBallIndicator(this.iStartScoreX + iScrollX, iTextPosY, g);
                }
                if (this.iGroupSize == 4) {
                    if (i == this.getOponentTeamIdx() % 4) {
                        this.paintBallIndicator(this.iStartScoreX + iScrollX, iTextPosY, g);
                    }
                } else if (i == this.getOponentTeamIdx()) {
                    this.paintBallIndicator(this.iStartScoreX + iScrollX, iTextPosY, g);
                }
            }
            iTextPosY += Texts.getFontHeight();
        }
    }

    void paintBallIndicator(int x, int y, Graphics g) {
        if (++this.iFrame > 9) {
            this.iFrame = 0;
        }
        int iBallDiffX = 0;
        int iBallDiffY = 0;
        Resources.pSprFootBall.setFrame(this.iFrame >> 1);
        Resources.pSprFootBall.setPosition(x - iBallDiffX, y - iBallDiffY);
        Resources.pSprFootBall.paint(g);
    }

    int getPlayerIdx() {
        for (int i = 0; i < 32; ++i) {
            if (this.iCupTeams[i][6] == 0) continue;
            return i;
        }
        return 0;
    }

    int getPlayerCountryIdx() {
        for (int i = 0; i < 32; ++i) {
            if (this.iCupTeams[i][6] == 0) continue;
            return this.iCupTeams[i][0];
        }
        return 0;
    }

    int getOponentTeamIdx() {
        return this.get2Idx(this.iCurrentPhaseOfChampionship, this.getPlayerIdx());
    }

    int getOponentTeamNation() {
        return this.iCupTeams[this.get2Idx(this.iCurrentPhaseOfChampionship, this.getPlayerIdx())][0];
    }

    int get1Idx(int phase, int player) {
        return player;
    }

    int get2Idx(int phase, int player) {
        if (phase < 3) {
            int iPos = player / 4;
            int iVal = player % 4;
            int index = 0;
            for (int i = 0; i < 4; ++i) {
                if (iVal != iBaseFight[(phase << 2) + i]) continue;
                index = (phase << 2) + i;
            }
            if (index % 2 == 0) {
                return (iPos << 2) + iBaseFight[index + 1];
            }
            return (iPos << 2) + iBaseFight[index - 1];
        }
        return player % 2 == 0 ? player + 1 : player - 1;
    }

    final boolean isPlayerInCup() {
        for (int i = 0; i < 32; ++i) {
            if (this.iCupTeams[i][6] == 0) continue;
            return true;
        }
        return false;
    }

    void printArr(String str, int length, int grpSize) {
        System.out.println(str);
        for (int i = 0; i < length; ++i) {
            if (i % grpSize == 0) {
                System.out.println("------------");
            }
            System.out.println("team: " + this.nationCode[this.iCupTeams[i][0]] + " skupina: " + this.group[this.iCupTeams[i][0] >> 2] + " | W: " + this.iCupTeams[i][1] + " L: " + this.iCupTeams[i][2] + "  D: " + this.iCupTeams[i][3] + " B: " + this.iCupTeams[i][4] + " Goals: " + this.iCupTeams[i][5] + " index: " + (i < 10 ? " " : "") + i + " position: " + (i % grpSize + 1));
        }
    }

    final void setPoints(int idx, int idx2, int val) {
        System.out.println("----------------------");
        System.out.println("pridava na idx: " + idx);
        System.out.println("v poli je to: " + idx2);
        System.out.println("hodnota je");
        int[] nArray = this.iCupTeams[idx];
        int n = idx2;
        nArray[n] = nArray[n] + val;
    }
}

