/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic.spf;

import simple.video.Graphics;
import sk.inlogic.spf.Common;
import sk.inlogic.spf.FootbalPlayer;
import sk.inlogic.spf.FootbalTeam;
import sk.inlogic.spf.FootballTeamAI;
import sk.inlogic.spf.Pitch;
import sk.inlogic.spf.Resources;
import sk.inlogic.spf.ScreenGame;
import sk.inlogic.spf.ScreenTutorial;

public class Ball {
    public static final int BALL_SPEED = 96;
    public static final int BALL_ACC_STEP = 16;
    private static int mass;
    private static int velocity;
    private static int acceleration;
    private static FootbalPlayer owner;
    private static FootbalPlayer passTarget;
    private static FootbalTeam ownerTeam;
    private static Pitch pitch;
    private static int iBallX;
    private static int iBallY;
    private static int iBallZ;
    int iHlpX = 15;
    int iHlpY = 20;
    private static int iVecX;
    private static int iVecY;
    private static int iTmpPosX;
    private static int iTmpPosY;
    private static int iBallSpd;
    private static int iBallSpdAcc;
    private static int iBallAccInc;
    private static int iBallIncStep;
    private static int iFrame;
    private static int currentQuad;
    private static byte[][] iBallCrossQuad;
    private static int iLastOwnersTeam;
    private static int iTargetQuadX;
    private static int iTargetQuadY;
    private static int iTargetX;
    private static int iTargetY;
    private static int iPredictX;
    private static int iPredictY;
    int[] iPredictedPoint = new int[2];
    private static int[] accTab;
    private static int iActualAcc;
    private static int iTabSize;
    private static int[] powerTab;
    static final int MIN_SIZE = 0;
    static final int MAX_SIZE = 1500;
    static final int MAX_STEPS = 10;
    public int iZMax;
    public int iZInc = this.iZMax = 1500;
    public int iZVal = -50;
    public int iSign = 1;
    int[] iVec = new int[2];
    int iTargetPosX;
    int iTargetPosY;
    int iKickPower;
    int iMaxHeight;
    int iNewPower;
    int[] lastPos = new int[2];

    Ball(int iBX, int iBY, Pitch p) {
        iBallX = iBX;
        iBallY = iBY;
        iTmpPosX = iBallX << 8;
        iTmpPosY = iBallY << 8;
        pitch = p;
        this.setTargetXY(-1, -1);
        this.recalculateVariables();
    }

    private void recalculateVariables() {
        int iInc;
        iBallIncStep = Resources.WIDTH * 16 / 240;
        int iStep = iInc = iBallIncStep >> 3;
        Ball.powerTab[0] = 0;
        for (int i = 1; i < 100; ++i) {
            Ball.powerTab[i] = powerTab[i - 1] + iStep;
            iStep += iInc;
        }
    }

    public int getPowerToPoint(int vecX, int vecY, int endPtX, int endPtY) {
        int iTmpVal1 = 0;
        int iTmpVal2 = 0;
        int iDiffX = Math.abs(this.getBallX() - endPtX);
        int iDiffY = Math.abs(this.getBallY() - endPtY);
        int iAnswer = 0;
        if (iDiffX > iDiffY) {
            iTmpVal1 = iDiffX << 12;
            iTmpVal2 = Math.abs(iTmpVal1 / vecX);
        } else {
            iTmpVal1 = iDiffY << 12;
            iTmpVal2 = Math.abs(iTmpVal1 / vecY);
        }
        for (int i = 0; i < 99; ++i) {
            if (iTmpVal2 < powerTab[i] || iTmpVal2 > powerTab[i + 1]) continue;
            iAnswer = i + 5;
            break;
        }
        return iAnswer;
    }

    public void setBallPos(int x, int y) {
        iBallX = x;
        iBallY = y;
        iTmpPosX = iBallX << 12;
        iTmpPosY = iBallY << 12;
        iVecX = 0;
        iVecY = 0;
    }

    public void paint(int iScrollX, int iScrollY, Graphics g) {
        Resources.pSprFootBall.setFrame(iFrame >> 1);
        Resources.pSprFootBall.setPosition(iScrollX + iBallX - 4, iScrollY + iBallY - 4 - iBallZ);
        Resources.pSprFootBall.paint(g);
    }

    public int getRealPosY() {
        return iBallY - 4 - iBallZ;
    }

    public int getPosZ() {
        return iBallZ;
    }

    public void updateJump() {
        iBallZ += this.iSign * (this.iZInc >> 7);
        this.iZInc += this.iZVal;
        if (this.iZInc <= 0) {
            this.iZInc = 0;
            this.iZVal *= -1;
            this.iSign *= -1;
        }
        if (this.iZInc > this.iZMax) {
            this.iSign *= -1;
            this.iZVal *= -1;
            this.iZMax >>= 1;
            this.iZInc = this.iZMax;
            iBallZ = 0;
        }
    }

    public void resetJump(int highOfJump) {
        iBallZ = 0;
        this.iZInc = highOfJump;
        this.iZMax = highOfJump;
        this.iZVal = -(this.iZMax / 10);
        this.iSign = 1;
    }

    public boolean rebound(FootbalPlayer fb) {
        if (owner != null) {
            return false;
        }
        if (this.getCurrentSpeed() == 0) {
            return false;
        }
        if (this.getPosZ() < Resources.pSprPlayerH3) {
            return false;
        }
        fb.setCanCatch(false);
        iVecX *= -1;
        iVecY *= -1;
        iTmpPosX = iBallX << 12;
        iTmpPosY = iBallY << 12;
        this.prepareBallVars(this.getCurrentSpeed() >> 1);
        return true;
    }

    public void update() {
        if (this.hasOwner()) {
            if (this.getOwner().isMoving() && ++iFrame > 9) {
                iFrame = 0;
            }
        } else if (this.getCurrentSpeed() != 0) {
            if (++iFrame > 9) {
                iFrame = 0;
            }
            this.updateAcc();
        }
        this.checkBallOutsidePitch();
        if (owner == null) {
            if (ScreenGame.getPitch() != null) {
                if (iBallX < -60) {
                    this.prepareBallVars(0);
                }
                if (iBallX > Pitch.PLAY_GROUND_W + 60) {
                    this.prepareBallVars(0);
                }
                if (iBallY < -44) {
                    this.prepareBallVars(0);
                }
                if (iBallY > Pitch.PLAY_GROUND_H + 44 - Resources.pSprFootBall.getHeight()) {
                    this.prepareBallVars(0);
                }
            } else {
                if (iBallX < this.iHlpX) {
                    this.prepareBallVars(0);
                }
                if (iBallX > Resources.WIDTH - this.iHlpX) {
                    this.prepareBallVars(0);
                }
                if (iBallY < this.iHlpY) {
                    this.prepareBallVars(0);
                }
                if (iBallY > Resources.HEIGHT - this.iHlpY) {
                    this.prepareBallVars(0);
                }
            }
            iBallX = (iTmpPosX += iVecX * this.getCurrentSpeed()) >> 12;
            iBallY = (iTmpPosY += iVecY * this.getCurrentSpeed()) >> 12;
            currentQuad = Pitch.getQuadByXY(iBallX, iBallY);
            if (ScreenGame.getPitch() != null) {
                this.catchBall(0);
                this.catchBall(1);
            } else if (ScreenGame.getPitch() == null) {
                this.catchBallTutorial();
            }
            this.updateJump();
        } else {
            iBallZ = 0;
            this.iZInc = 2;
            iBallX = owner.getiPosX(0, 14);
            iBallY = owner.getiPosY(-15, 8);
            if (ScreenGame.getPitch() != null && ScreenGame.iMode == 9) {
                iBallY -= Resources.pSprPlayerH2;
            }
        }
    }

    public void checkBallOutsidePitch() {
        if (this.getBallX() > 0 && this.getBallX() < 900 && this.getBallY() > 0 && this.getBallY() < 1320) {
            return;
        }
    }

    public void lostBall() {
        iVecX = 0;
        iVecY = 0;
        if (owner != null) {
            owner.setHasBall(false);
            owner = null;
        }
        iBallSpdAcc = 0;
        iBallSpd = 0;
        iTmpPosX = iBallX << 12;
        iTmpPosY = iBallY << 12;
    }

    public void bounceX() {
        iVecX *= -1;
    }

    public void bounceY() {
        iVecY *= -1;
    }

    public boolean checkCorner() {
        if (this.hasOwner()) {
            if (iBallY < 0) {
                return true;
            }
            if (iBallY > Pitch.PLAY_GROUND_H) {
                return true;
            }
        } else {
            if (iBallY < 0 && iVecY < 0) {
                return true;
            }
            if (iBallY > Pitch.PLAY_GROUND_H && iVecY > 0) {
                return true;
            }
        }
        return false;
    }

    public boolean checkOut() {
        if (iBallX < 0) {
            return true;
        }
        return iBallX > Pitch.PLAY_GROUND_W;
    }

    public int getLastOwnerTeam() {
        return iLastOwnersTeam;
    }

    public void addBallToPlayer(FootbalPlayer fbp) {
        iVecX = 0;
        iVecY = 0;
        owner = fbp;
        owner.setHasBall(true);
        owner.resetPower();
        this.setTeamOwner(owner.getTeam());
        iBallX = owner.getiPosX(0, 7);
        iBallY = owner.getiPosY(0, 5);
        if (this.getPassTarget() != null) {
            this.getPassTarget().setIsPassingTarget(false);
            this.setPassTarget(null);
        }
        if (ScreenGame.getPitch() != null && fbp.getTeam().getTeamSide() == 0) {
            ScreenGame.getPitch().setActivePlayer(0, fbp.getPosInArray());
            if (ScreenGame.getPitch().getActivePlayer().getTeam().getSideOfTeam() == 4) {
                ScreenGame.getPitch().getActivePlayer().updateHeaing(450, 0);
            } else {
                ScreenGame.getPitch().getActivePlayer().updateHeaing(450, 1320);
            }
        }
        if (ScreenGame.getPitch() != null) {
            owner.getTeam().resetBallFolowing();
        }
    }

    public void catchBallTutorial() {
        if (this.hasOwner()) {
            return;
        }
        if (this.getPosZ() > Resources.pSprPlayerH) {
            return;
        }
        if (ScreenTutorial.fbPl.bCanCatchBall() && Math.abs(ScreenTutorial.fbPl.getPosX() - iBallX) < Resources.pSprPlayerW >> 1 && Math.abs(ScreenTutorial.fbPl.getPosY() - iBallY) < Resources.pSprPlayerW >> 1) {
            if (this.rebound(ScreenTutorial.fbPl)) {
                return;
            }
            this.addBallToPlayer(ScreenTutorial.fbPl);
            return;
        }
    }

    public void catchBall(int iTeamSide) {
        if (this.hasOwner()) {
            return;
        }
        if (this.getPosZ() > Resources.pSprPlayerH) {
            return;
        }
        FootbalTeam fbt = iTeamSide == 0 ? pitch.getTeam1() : pitch.getTeam2();
        for (int i = 0; i < 11; ++i) {
            if (!fbt.getPlayer(i).bCanCatchBall() || Math.abs(fbt.getPlayer(i).getPosX() - iBallX) >= Resources.pSprPlayerW >> 1 || Math.abs(fbt.getPlayer(i).getPosY() - iBallY) >= Resources.pSprPlayerW >> 1) continue;
            if (this.rebound(fbt.getPlayer(i))) {
                return;
            }
            this.addBallToPlayer(fbt.getPlayer(i));
            return;
        }
    }

    public void catchBallTutorial(FootbalPlayer fb) {
        if (this.hasOwner()) {
            return;
        }
        if (this.getPosZ() > Resources.pSprPlayerH) {
            return;
        }
        if (Math.abs(fb.getPosX() - iBallX) < Resources.pSprPlayerW >> 1 && Math.abs(fb.getPosY() - iBallY) < Resources.pSprPlayerW >> 1) {
            if (this.rebound(fb)) {
                return;
            }
            this.addBallToPlayer(fb);
            return;
        }
    }

    public void kickToPlayerCorner(FootbalPlayer toPlayer, int speed) {
        if (this.getOwner() == null) {
            return;
        }
        int iDx = toPlayer.getActualGridX();
        int iDy = toPlayer.getActualGridY();
        this.setTargetPoint(iDx, iDy);
        this.setTargetXY(iDx * 60 + 30, iDy * 88 + 44);
        Common.getNormVector(this.iVec, this.getOwner().getPosX(), this.getOwner().getPosY(), this.getTargetX(), this.getTargetY());
        this.kick(this.iVec[0], this.iVec[1], speed);
    }

    public void kickToPlayer(FootbalPlayer toPlayer, int speed) {
        if (this.getOwner() == null) {
            return;
        }
        int iDx = toPlayer.getActualGridX();
        int iDy = toPlayer.getActualGridY();
        this.setTargetXY(-1, -1);
        int iDistance = Common.getManhattanDis(this.getOwner().getActualGridX(), this.getOwner().getActualGridY(), iDx, iDy);
        FootbalTeam theirTeam = toPlayer.getTeam() == pitch.getTeam1() ? pitch.getTeam2() : pitch.getTeam1();
        FootbalPlayer p = FootballTeamAI.getEnemyPlayerOnQuad(Pitch.getQuadByIdXY(iDx, iDy), theirTeam);
        if ((p != null || iDistance > 3) && (p = FootballTeamAI.getEnemyPlayerOnQuad(Pitch.getQuadByIdXY(iDx, iDy = toPlayer.getTeam().getSideOfTeam() == 2 ? Math.min(toPlayer.getActualGridY() + 1, 14) : Math.max(toPlayer.getActualGridY() - 1, 0)), theirTeam)) != null) {
            if (this.getOwner().getActualGridX() < toPlayer.getActualGridX() || this.getOwner().getActualGridX() == toPlayer.getActualGridX() && this.getOwner().getActualGridX() == 14) {
                --iDx;
            } else if (this.getOwner().getActualGridX() > toPlayer.getActualGridX() || this.getOwner().getActualGridX() == toPlayer.getActualGridX() && this.getOwner().getActualGridX() == 0) {
                ++iDx;
            }
        }
        this.iTargetPosX = iDx * 60 + 30;
        this.iTargetPosY = iDy * 88 + 44;
        this.setTargetPoint(iDx, iDy);
        this.setTargetXY(this.iTargetPosX, this.iTargetPosY);
        Common.getNormVector(this.iVec, this.getOwner().getPosX(), this.getOwner().getPosY(), this.getTargetX(), this.getTargetY());
        if (speed < 0) {
            this.kick(this.iVec[0], this.iVec[1], this.getPowerToPoint(this.iVec[0], this.iVec[1], this.iTargetPosX, this.iTargetPosY));
        } else {
            this.kick(this.iVec[0], this.iVec[1], speed);
        }
    }

    public void kick(int vecX, int vecY, int pwr) {
        if (pwr > 100) {
            pwr = 100;
        }
        if (!ScreenGame.bCanStartGame) {
            ScreenGame.bCanStartGame = false;
        }
        if (owner == null) {
            return;
        }
        owner.setCanCatch(false);
        owner.setHasBall(false);
        iVecX = vecX;
        iVecY = vecY;
        iTmpPosX = iBallX << 12;
        iTmpPosY = iBallY << 12;
        this.iKickPower = 3 * pwr;
        this.iMaxHeight = pwr > 55 ? pwr * Resources.pSprPlayerH * 20 / 100 : (pwr > 33 ? pwr * Resources.pSprPlayerH * 50 / 100 : 0);
        if (Resources.WIDTH == 128) {
            this.iNewPower = Resources.WIDTH * this.iKickPower / 240;
        }
        if (Resources.WIDTH == 176) {
            this.iNewPower = Resources.WIDTH * this.iKickPower / 240;
        }
        if (Resources.WIDTH == 240) {
            this.iNewPower = Resources.WIDTH * this.iKickPower / 240;
        }
        if (Resources.WIDTH == 320) {
            this.iNewPower = Resources.WIDTH * this.iKickPower / 240;
        }
        if (Resources.WIDTH == 360) {
            this.iNewPower = Resources.WIDTH * this.iKickPower / 240;
        }
        if (Resources.WIDTH == 480) {
            this.iNewPower = Resources.WIDTH * this.iKickPower / 360;
        }
        if (Resources.WIDTH == 540) {
            this.iNewPower = Resources.WIDTH * this.iKickPower / 360;
        }
        this.prepareBallVars(this.iNewPower);
        this.resetJump(this.iMaxHeight);
        iLastOwnersTeam = owner.getTeam().getTeamSide();
        if (ScreenGame.getPitch() != null) {
            ScreenGame.getPitch().getTeam1().getPlayer(10).ballWasKicked();
            ScreenGame.getPitch().getTeam2().getPlayer(10).ballWasKicked();
        }
        owner = null;
        this.getLastPos();
    }

    public void setTargetPoint(int x, int y) {
        iTargetQuadX = x;
        iTargetQuadY = y;
    }

    public int getTargetQuadX() {
        return iTargetQuadX;
    }

    public int getTargetQuadY() {
        return iTargetQuadY;
    }

    public int getTargetX() {
        return iTargetX;
    }

    public int getTargetY() {
        return iTargetY;
    }

    public void setTargetXY(int x, int y) {
        iTargetX = x;
        iTargetY = y;
    }

    public byte[][] getBallArr() {
        return iBallCrossQuad;
    }

    public void getLastPos() {
        int iAcc = 0;
        int iAccInc = 0;
        int iHlpX = iTmpPosX;
        int iHlpY = iTmpPosY;
        iBallCrossQuad = new byte[15][15];
        while (iAcc != iBallSpd) {
            iAcc = (iAccInc += iBallIncStep) >> 3;
            if (iBallSpd <= iAcc) {
                iAcc = iBallSpd;
            }
            int iCurrentSpeed = iBallSpd - iAcc;
            int iX = ((iHlpX += iVecX * iCurrentSpeed) >> 12) / 60;
            int iY = ((iHlpY += iVecY * iCurrentSpeed) >> 12) / 88;
            if (iX < 0 || iX >= 15 || iY < 0 || iY >= 15) continue;
            Ball.iBallCrossQuad[iY][iX] = 1;
        }
        iPredictX = iHlpX >> 12;
        iPredictY = iHlpY >> 12;
        iTargetQuadX = iPredictX / 60;
        iTargetQuadY = iPredictY / 88;
    }

    public int getPredictedX() {
        if (iPredictX < 30) {
            return 30;
        }
        if (iPredictX > 870) {
            return 870;
        }
        return iPredictX;
    }

    public int getPredictedY() {
        if (iPredictY < 88) {
            return 88;
        }
        if (iPredictY > 1232) {
            return 1232;
        }
        return iPredictY;
    }

    public void prepareBallVars(int speed) {
        iBallSpd = speed;
        iBallSpdAcc = 0;
        iBallAccInc = 0;
    }

    public void updateAcc() {
        iBallSpdAcc = (iBallAccInc += iBallIncStep) >> 3;
        if (iBallSpdAcc >= iBallSpd) {
            iBallSpdAcc = iBallSpd;
        }
    }

    public int getAccPercentage() {
        float perc = iBallSpd / 100;
        float percAcc = (float)iBallSpdAcc / perc;
        return (int)percAcc;
    }

    public int getCurrentSpeed() {
        return iBallSpd - iBallSpdAcc;
    }

    public int getCurrentAcceleration() {
        return iBallSpdAcc;
    }

    public int[] getPredictedNextPoint() {
        int iTmpX = iBallX << 12;
        int iTmpY = iBallY << 12;
        this.iPredictedPoint[0] = (iTmpX += iVecX * this.getCurrentSpeed()) >> 12;
        this.iPredictedPoint[1] = (iTmpY += iVecY * this.getCurrentSpeed()) >> 12;
        return this.iPredictedPoint;
    }

    public void stopBall() {
        iBallSpd = 0;
        iBallSpdAcc = 0;
    }

    public int getCurrneQuad() {
        return currentQuad;
    }

    public FootbalTeam getTeamOwner() {
        return ownerTeam;
    }

    public FootbalTeam getTeamWithNoBall() {
        return ownerTeam == ScreenGame.getPitch().getTeam1() ? ScreenGame.getPitch().getTeam2() : ScreenGame.getPitch().getTeam1();
    }

    public void setTeamOwner(FootbalTeam t) {
        ownerTeam = t;
        ownerTeam.incHoldingState();
    }

    public FootbalPlayer getOwner() {
        return owner;
    }

    public boolean hasOwner() {
        return owner != null;
    }

    public int getBallX() {
        return iBallX;
    }

    public int getBallY() {
        return iBallY;
    }

    public int getBallZ() {
        return iBallZ;
    }

    public void setPassTarget(FootbalPlayer p) {
        passTarget = p;
    }

    public FootbalPlayer getPassTarget() {
        return passTarget;
    }

    public int getVecX() {
        return iVecX;
    }

    public int getVecY() {
        return iVecY;
    }

    public int getBallQuadX() {
        return iBallX / 60;
    }

    public int getBallQuadY() {
        return iBallY / 88;
    }

    static {
        iBallX = 0;
        iBallY = 0;
        iBallZ = 0;
        iTmpPosX = 0;
        iTmpPosY = 0;
        iBallSpd = 96;
        iBallSpdAcc = 0;
        iBallAccInc = 0;
        iFrame = 0;
        iBallCrossQuad = new byte[15][15];
        iLastOwnersTeam = 0;
        iTabSize = 0;
        powerTab = new int[100];
    }
}

