/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic.spf;

import simple.input.Key;
import simple.input.Keys;
import simple.video.Graphics;
import sk.inlogic.spf.Globals;
import sk.inlogic.spf.IScreen;
import sk.inlogic.spf.MyApplication;
import sk.inlogic.spf.ResTexts;
import sk.inlogic.spf.Resources;
import sk.inlogic.spf.ScreenMenu;
import sk.inlogic.spf.Sounds;
import sk.inlogic.spf.Texts;

public class ScreenSplash
implements IScreen {
    final int MODE_VOID;
    final int MODE_LOADINGRES;
    final int MODE_LANGUAGES;
    final int MODE_SOUNDS;
    final int MODE_TITLE;
    final int TIME_DELAY;
    int iMode = 1;
    int iModeDelay;
    MyApplication pMyApplication = MyApplication.getInstance();
    int iLangX = 0;
    int iLangY = 0;
    int iActualSelected = 0;
    int iFlagX = 0;
    int iFlagY = 0;
    String strTxt;
    int selectedIdx;
    int iCenterFlagX;
    int iFlagsX;
    int iFlagsY;
    int iFlagW;
    int iFlagH;
    int iActualPosX;
    int iActualPosY;

    public ScreenSplash() {
        this.MODE_VOID = 0;
        this.MODE_LOADINGRES = 1;
        this.MODE_LANGUAGES = 2;
        this.MODE_SOUNDS = 3;
        this.MODE_TITLE = 4;
        this.TIME_DELAY = 2000;
    }

    public void action() {
        System.out.println("akciaaaa");
    }

    public void update(long lTick) {
        if (this.iMode == 1) {
            Resources.loadInitialRes();
            Resources.loadLangRes();
            this.prepareFlags();
            return;
        }
        if (this.iMode > 3 && this.iModeDelay > 0) {
            this.iModeDelay = (int)((long)this.iModeDelay - lTick);
            if (this.iModeDelay <= 0) {
                this.nextMode();
            }
        }
        this.pMyApplication.repaintScreen();
    }

    public void paintScreen(Graphics g) {
        switch (this.iMode) {
            case 2: {
                this.paintModeLanguage(g);
                break;
            }
            case 3: {
                this.paintModeSounds(g);
                break;
            }
            case 4: {
                this.paintModeTitle(g);
            }
        }
    }

    private void prepareFlags() {
        this.iFlagsX = Resources.WIDTH - Resources.iLangW * 2 - Resources.FLAG_SPACE_W >> 1;
        this.iFlagsY = Resources.HEIGHT - Resources.iLangH * 3 - 2 * Resources.FLAG_SPACE_H >> 1;
        this.iFlagH = Resources.iLangH + Resources.FLAG_SPACE_H;
        this.iFlagW = Resources.iLangW + Resources.FLAG_SPACE_W;
        this.iCenterFlagX = Resources.WIDTH - Resources.iLangW >> 1;
        this.iMode = 2;
        this.pMyApplication.repaintScreen();
    }

    private void paintModeLanguage(Graphics g) {
        Resources.drawBackground(g);
        Resources.paintWindow(g, 0);
        this.iActualPosX = this.iFlagsX;
        this.iActualPosY = this.iFlagsY;
        g.setColor(0xFFFF00);
        for (int i = 0; i < 5; ++i) {
            Resources.pSprLang.setFrame(i);
            if (i == this.iActualSelected) {
                Resources.pSprLangSel.setFrame(1);
            } else {
                Resources.pSprLangSel.setFrame(0);
            }
            if (i == 0 || i == 3) {
                Resources.pSprLangSel.setPosition(this.iActualPosX, this.iActualPosY);
                Resources.pSprLang.setPosition(this.iActualPosX, this.iActualPosY);
            }
            if (i == 1 || i == 4) {
                Resources.pSprLangSel.setPosition(this.iActualPosX + this.iFlagW, this.iActualPosY);
                Resources.pSprLang.setPosition(this.iActualPosX + this.iFlagW, this.iActualPosY);
            }
            if (i == 2) {
                Resources.pSprLangSel.setPosition(this.iCenterFlagX, this.iActualPosY);
                Resources.pSprLang.setPosition(this.iCenterFlagX, this.iActualPosY);
            }
            if (i == 1 || i == 2) {
                this.iActualPosY += this.iFlagH;
            }
            Resources.pSprLangSel.paint(g);
            Resources.pSprLang.paint(g);
        }
        Resources.paintBottomGrass(g);
    }

    private void paintModeSounds(Graphics g) {
        Resources.drawBackground(g);
        Resources.paintWindow(g, 0);
        Resources.pImgSnd.drawAtPoint(g, Resources.WIDTH - Resources.pImgSnd.getWidth() >> 1, Resources.HEIGHT - Resources.pImgSnd.getHeight() >> 1);
        Resources.paintBottomGrass(g);
        Resources.paintLeftButton(g, 2);
        Resources.paintRightButton(g, 3);
        Texts.drawTextAtPos(g, Resources.WIDTH - Texts.getTextWidth(this.strTxt) >> 1, (Resources.HEIGHT - Resources.pImgSnd.getHeight() >> 1) + Resources.pImgSnd.getHeight(), this.strTxt);
    }

    private void paintModeTitle(Graphics g) {
        g.setColor(15269632);
        g.fillRect(0, 0, Resources.WIDTH, Resources.HEIGHT);
        Resources.pImgLogo.drawAtPoint(g, Resources.WIDTH - Resources.pImgLogo.getWidth() >> 1, Resources.HEIGHT - Resources.pImgLogo.getHeight() >> 1);
    }

    void enableSound() {
        Globals.bMusic = true;
        Sounds.playMenuMusic();
    }

    void disableSound() {
        Globals.bMusic = false;
        Sounds.stopMusic();
    }

    public void keyPressed(Key pKey) {
        switch (this.iMode) {
            case 2: {
                this.keyPressedModeLanguages(pKey);
                break;
            }
            case 3: {
                this.keyPressedModeSounds(pKey);
                break;
            }
            case 4: {
                this.keyPressedModeSplash(pKey);
            }
        }
    }

    private void keyPressedModeLanguages(Key pKey) {
        if ((pKey.iValue == 52 || pKey.iGameAction == 2) && --this.iFlagX < 0) {
            this.iFlagX = 0;
        }
        if ((pKey.iValue == 54 || pKey.iGameAction == 5) && ++this.iFlagX > 1) {
            this.iFlagX = 1;
        }
        if ((pKey.iValue == 50 || pKey.iGameAction == 1) && --this.iFlagY < 0) {
            this.iFlagY = 0;
        }
        if ((pKey.iValue == 56 || pKey.iGameAction == 6) && ++this.iFlagY > 2) {
            this.iFlagY = 2;
        }
        if (this.iFlagY == 0) {
            int n = this.iActualSelected = this.iFlagX == 0 ? 0 : 1;
        }
        if (this.iFlagY == 1) {
            this.iActualSelected = 2;
        }
        if (this.iFlagY == 2) {
            int n = this.iActualSelected = this.iFlagX == 0 ? 3 : 4;
        }
        if (pKey.iGameAction == 8 || pKey.iValue == 53) {
            this.nextMode();
        }
    }

    void keyPressedModeSounds(Key pKey) {
        if (pKey.iValue == Keys.KEY_FNLEFT) {
            this.enableSound();
            this.nextMode();
            return;
        }
        if (pKey.iValue == Keys.KEY_FNRIGHT) {
            this.disableSound();
            this.nextMode();
        }
    }

    void keyPressedModeSplash(Key pKey) {
        if (pKey.iGameAction == 8 || pKey.iValue == 53 || pKey.iValue == 100) {
            this.nextMode();
        }
    }

    void nextMode() {
        this.iModeDelay = 2000;
        switch (this.iMode) {
            case 2: {
                Globals.iSelectedLang = this.iActualSelected;
                Globals.strLang = Globals.strLanguage[Globals.iSelectedLang];
                ResTexts.setPath();
                this.strTxt = MyApplication.resTxt.getHashedString("ENABLE_MUSIC");
                Resources.releaseLangRes();
                Resources.loadLogo();
                Globals.prepareTexts();
                this.iMode = 4;
                break;
            }
            case 4: {
                Resources.loadSndRes();
                this.iMode = 3;
                break;
            }
            case 3: {
                Resources.releaseSndRes();
                Globals.save();
                MyApplication.pScrMenu = new ScreenMenu();
                MyApplication.pActiveScreen = MyApplication.pScrMenu;
                MyApplication.pScrSplash = null;
                System.gc();
                this.iMode = 0;
            }
        }
    }

    public void keyReleased(Key pKey) {
    }

    public void pointerDragged(int x, int y) {
    }

    public void pointerPressed(int x, int y) {
        if (this.iMode == 2) {
            this.iFlagsX = Resources.WIDTH - Resources.iLangW * 2 - Resources.FLAG_SPACE_W >> 1;
            this.iFlagsY = Resources.HEIGHT - Resources.iLangH * 3 - 2 * Resources.FLAG_SPACE_H >> 1;
            this.iFlagH = Resources.iLangH + Resources.FLAG_SPACE_H;
            this.iFlagW = Resources.iLangW + Resources.FLAG_SPACE_W;
            if (x > this.iFlagsX && x < this.iFlagsX + this.iFlagW * 2 - Resources.FLAG_SPACE_W && y > this.iFlagsY && y < this.iFlagsY + this.iFlagH * 3 - Resources.FLAG_SPACE_H) {
                this.iFlagX = (x - this.iFlagsX) / this.iFlagW;
                this.iFlagY = (y - this.iFlagsY) / this.iFlagH;
                if (this.iFlagY == 0) {
                    int n = this.iActualSelected = this.iFlagX == 0 ? 0 : 1;
                }
                if (this.iFlagY == 1) {
                    this.iActualSelected = 2;
                }
                if (this.iFlagY == 2) {
                    this.iActualSelected = this.iFlagX == 0 ? 3 : 4;
                }
                this.nextMode();
            }
        }
        if (this.iMode == 3) {
            if (Resources.pressedLeftButton(x, y)) {
                this.enableSound();
                this.nextMode();
                return;
            }
            if (Resources.pressedRightButton(x, y)) {
                this.disableSound();
                this.nextMode();
                return;
            }
        }
    }

    public void pointerReleased(int x, int y) {
    }

    public void onPause() {
    }

    public void onResume() {
    }

    public void sizeChanged() {
    }
}

