/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic.spf;

import java.util.Vector;
import simple.core.Application;
import simple.input.Key;
import simple.input.Keys;
import simple.scene.Sprite;
import simple.video.Graphics;
import simple.video.Image;
import sk.inlogic.spf.Globals;
import sk.inlogic.spf.IScreen;
import sk.inlogic.spf.MyApplication;
import sk.inlogic.spf.ResTexts;
import sk.inlogic.spf.Resources;
import sk.inlogic.spf.ScreenGame;
import sk.inlogic.spf.ScreenTutorial;
import sk.inlogic.spf.Sounds;
import sk.inlogic.spf.Texts;

public class ScreenMenu
implements IScreen {
    final int MAX_TIME;
    final int INMENU_MODE_INSTRUCTIONS;
    final int INMENU_MODE_ABOUT;
    final int INMENU_MODE_OPTIONS;
    final int INMENU_MODE_NEW_GAME;
    final int INMENU_MODE_QUIT;
    final int MODE_VOID;
    final int MODE_LOADINGRES;
    final int MODE_MENU;
    final int MODE_OPTIONS;
    final int MODE_CREATING_TEAM;
    final int MODE_ABOUT;
    final int MODE_QUIT;
    final int MODE_GAME_SELECTION;
    final int MODE_LOS;
    final int MODE_INSTRUCTIONS;
    final int MODE_SELECT_TEAMS;
    final int MODE_ERASE_CUP;
    static final int MODE_CREATE_CUP = 21;
    static final int MODE_CUP_INFO = 22;
    final int MI_MUSIC;
    final int MI_VIBRATIONS;
    final int MI_BACK;
    private MyApplication pMyApplication = null;
    private int iMode;
    private int iSelectedMenuItem = 3;
    private int iMenuSelector = 0;
    public static boolean bFirstTime = true;
    private int iAnimationStep = 0;
    private boolean bAnimateToNextMode = false;
    private boolean bAnimationLock = false;
    private boolean bScrollLeft = false;
    private boolean bScrollRight = false;
    private int iNewMode;
    private int iOldMode;
    private String strText;
    private int iWindowPosX;
    private int iWindowPosY;
    private int iTitlePosX;
    private int iTitlePosY;
    private static int iBlickTime;
    private static int iBlickFrame;
    private int iFlagTile;
    private int iFlagFrame;
    private int iSmallArrY;
    private boolean bCup = false;
    private int iFriendlyMatchMyTeam = 0;
    private int iCreatingMatchSel = 0;
    private int iEnemyCountry = 0;
    private int iItemsCount;
    private int iSpacesCount;
    private int iItemPosX;
    private int iItemPosY;
    private int iCreatingTeamPosY = 0;
    private int iItmDiffX;
    private int iOptionSelector = 0;
    private int iTextInItemDiffY;
    private int iTimeWidth;
    private int iItemH;
    private static StringBuffer sbTime;
    private static StringBuffer sb;
    String[] otherTexts = new String[5];
    int[] iTextOtherposX = new int[5];
    String[] strTexts = new String[5];
    int[] iTextposX = new int[5];
    private boolean bContinue = false;
    private boolean bDisableLeftKey = true;
    private static int iCreatingCupSelectedItem;
    private int iChoice = 0;
    String[] submenuTxt = new String[4];
    String[] optionsTxt = new String[4];
    String[] optionsVar = new String[4];
    String[] strOnOff = new String[2];
    static int iFrame;
    static int iSelectedTeam;
    static boolean bStop;
    static int iLosScreenY;
    int iActualPosY;
    private int iStep;
    private int iDiffY;
    private int iDiffX;
    private int iArrowY;
    private int iTextDiffY;
    private int iDiffTimeX;
    private int iOldFlagSet;
    private int iFlagPosY;
    private String strVersus = "VS.";
    public static int iDressCnt;
    int iActualTeamFlag;
    int iOldSelectorPos;

    public ScreenMenu() {
        this.MAX_TIME = 45;
        this.INMENU_MODE_INSTRUCTIONS = 0;
        this.INMENU_MODE_ABOUT = 1;
        this.INMENU_MODE_OPTIONS = 2;
        this.INMENU_MODE_NEW_GAME = 3;
        this.INMENU_MODE_QUIT = 4;
        this.MODE_VOID = 0;
        this.MODE_LOADINGRES = 1;
        this.MODE_MENU = 2;
        this.MODE_OPTIONS = 3;
        this.MODE_CREATING_TEAM = 4;
        this.MODE_ABOUT = 5;
        this.MODE_QUIT = 6;
        this.MODE_GAME_SELECTION = 7;
        this.MODE_LOS = 8;
        this.MODE_INSTRUCTIONS = 9;
        this.MODE_SELECT_TEAMS = 10;
        this.MODE_ERASE_CUP = 11;
        this.MI_MUSIC = 0;
        this.MI_VIBRATIONS = 1;
        this.MI_BACK = 2;
        this.pMyApplication = MyApplication.getInstance();
        this.pMyApplication.callLoading();
        this.iMode = 1;
    }

    public void reloadOptions() {
        ResTexts.setPath();
        Globals.prepareOptionTexts();
        this.optionsTxt[0] = MyApplication.resTxt.getString("OPTIONS_1");
        this.optionsTxt[1] = MyApplication.resTxt.getString("12");
        this.optionsTxt[2] = MyApplication.resTxt.getString("OPTIONS_3");
        this.optionsTxt[3] = MyApplication.resTxt.getString("OPTIONS_4");
        this.strOnOff[0] = MyApplication.resTxt.getString("10");
        this.strOnOff[1] = MyApplication.resTxt.getString("11");
        this.optionsVar[0] = Globals.strLanguage[Globals.iSelectedLang];
        this.optionsVar[1] = Globals.bMusic ? this.strOnOff[0] : this.strOnOff[1];
        this.optionsVar[2] = "00:00";
        this.optionsVar[3] = Globals.strDiff[Globals.iSelectedDiff];
        this.prepareMenuItms(4);
    }

    public void prepareMenuItms(int iCnt) {
        this.iMenuSelector = 0;
        this.iItemsCount = iCnt;
        this.iSpacesCount = this.iItemsCount - 1;
        this.iItemH = Resources.MENU_ITM_HEIGHT + Resources.MENU_ITM_SPC_H;
        this.iSmallArrY = (Resources.MENU_ITM_HEIGHT - Resources.iMenuArrSmallH >> 1) - 1;
        this.iTimeWidth = Texts.getTextWidth("00:00");
        this.iItemPosX = Resources.WIDTH - Resources.MENU_ITM_WIDTH >> 1;
        this.iItemPosY = Resources.HEIGHT - this.iItemsCount * Resources.MENU_ITM_HEIGHT - this.iSpacesCount * Resources.MENU_ITM_SPC_H >> 1;
        this.iItmDiffX = (Resources.iOptIconW >> 3) + 5;
        this.iTextInItemDiffY = Resources.MENU_ITM_HEIGHT - Texts.getFontHeight() >> 1;
    }

    public void reloadTexts() {
        ResTexts.setPath();
        this.submenuTxt[0] = MyApplication.resTxt.getString("SUB_1");
        this.submenuTxt[1] = MyApplication.resTxt.getString("SUB_2");
        this.submenuTxt[2] = MyApplication.resTxt.getString("SUB_3");
        this.submenuTxt[3] = MyApplication.resTxt.getString("SUB_4");
    }

    public void update(long tick) {
        switch (this.iMode) {
            case 1: {
                this.updateModeLoadingRes();
                this.reloadTexts();
                Globals.load();
                break;
            }
            case 2: {
                if (this.bAnimationLock) break;
                Application.getSingleton().repaintScreen();
                break;
            }
            case 22: {
                if (this.bAnimationLock) break;
                Application.getSingleton().repaintScreen();
                break;
            }
            case 21: {
                if (this.bAnimationLock) break;
                Application.getSingleton().repaintScreen();
                break;
            }
        }
        this.animateToNextMode();
    }

    private void updateModeLoadingRes() {
        boolean bl = MyApplication.bLoading = !bFirstTime;
        if (MyApplication.bLoading) {
            Application.getSingleton().repaintScreen();
        }
        bFirstTime = false;
        Resources.loadMenuResources();
        this.iItemsCount = 3;
        this.iSpacesCount = this.iItemsCount - 1;
        this.iItemH = Resources.MENU_ITM_HEIGHT + Resources.MENU_ITM_SPC_H;
        this.iSmallArrY = (Resources.MENU_ITM_HEIGHT - Resources.iMenuArrSmallH >> 1) - 1;
        this.iTimeWidth = Texts.getTextWidth("00:00");
        this.iItemPosX = Resources.WIDTH - Resources.MENU_ITM_WIDTH >> 1;
        this.iItemPosY = Resources.HEIGHT - this.iItemsCount * Resources.MENU_ITM_HEIGHT - this.iSpacesCount * Resources.MENU_ITM_SPC_H >> 1;
        this.iItmDiffX = (Resources.iOptIconW >> 3) + 5;
        this.iTextInItemDiffY = Resources.MENU_ITM_HEIGHT - Texts.getFontHeight() >> 1;
        MyApplication.bLoading = false;
        if (!Sounds.musicPlaying()) {
            Sounds.playMenuMusic();
        }
        this.prepareWindow();
        this.prepareCreationScreen();
        this.prepareSelectionScreen();
        this.pMyApplication.repaintScreen();
        this.iMode = 2;
    }

    private void prepareWindow() {
        this.iWindowPosX = Resources.WIDTH - Resources.iMenuW >> 1;
        this.iWindowPosY = Resources.HEIGHT - Resources.iMenuW >> 1;
        this.iTitlePosX = Resources.WIDTH - Resources.pImgGameTitle.getWidth() >> 1;
        this.iTitlePosY = Resources.pImgGameTitle.getHeight() >> 1;
    }

    private void prepareCreationScreen() {
    }

    public void paintScreen(Graphics g) {
        Resources.drawBackground(g);
        if (this.iAnimationStep != 0) {
            if (this.bScrollLeft) {
                this.paintOldScreen(g, -this.iAnimationStep);
                this.paintNewScreen(g, Resources.WIDTH - this.iAnimationStep);
            } else {
                this.paintOldScreen(g, this.iAnimationStep);
                this.paintNewScreen(g, this.iAnimationStep - Resources.WIDTH);
            }
        }
        switch (this.iMode) {
            case 2: {
                if (!this.bAnimationLock) {
                    this.paintModeMenu(g, 0);
                }
                if (!this.bDisableLeftKey) {
                    Resources.paintLeftButton(g, 2);
                }
                Resources.paintRightButton(g, 1);
                break;
            }
            case 9: {
                if (!this.bAnimationLock) {
                    this.paintModeInstructions(g, 0);
                }
                Resources.paintRightButton(g, 4);
                break;
            }
            case 7: {
                if (!this.bAnimationLock) {
                    this.paintModeGameSelection(g, 0);
                }
                if (!this.bDisableLeftKey) {
                    Resources.paintLeftButton(g, 2);
                }
                Resources.paintRightButton(g, 4);
                break;
            }
            case 3: {
                if (!this.bAnimationLock) {
                    this.paintModeOptions(g, 0);
                }
                Resources.paintLeftButton(g, 2);
                break;
            }
            case 11: {
                if (!this.bAnimationLock) {
                    this.paintModeErase(g, 0);
                }
                Resources.paintRightButton(g, 4);
                break;
            }
            case 4: {
                if (!this.bAnimationLock) {
                    this.paintModeCreatingTeam(g, 0);
                }
                Resources.paintRightButton(g, 4);
                Resources.paintLeftButton(g, 2);
                break;
            }
            case 5: {
                if (!this.bAnimationLock) {
                    this.paintModeAbout(g, 0);
                }
                Resources.paintRightButton(g, 4);
                break;
            }
            case 6: {
                if (!this.bAnimationLock) {
                    this.paintModeQuit(g, 0);
                }
                Resources.paintRightButton(g, 3);
                Resources.paintLeftButton(g, 2);
                break;
            }
            case 22: {
                if (!this.bAnimationLock) {
                    this.paintCupInfo(g, 0);
                }
                Resources.paintLeftButton(g, 2);
                Resources.paintRightButton(g, 4);
                break;
            }
            case 21: {
                if (!this.bAnimationLock) {
                    this.paintModeCreateCup(g, 0);
                }
                Resources.paintLeftButton(g, 2);
                Resources.paintRightButton(g, 4);
                break;
            }
            case 10: {
                if (!this.bAnimationLock) {
                    this.paintModeCreateMatch(g, 0);
                }
                Resources.paintRightButton(g, 4);
                Resources.paintLeftButton(g, 2);
            }
        }
    }

    void paintOldScreen(Graphics g, int iScrollX) {
        switch (this.iOldMode) {
            case 2: {
                this.paintModeMenu(g, iScrollX);
                break;
            }
            case 4: {
                this.paintModeCreatingTeam(g, iScrollX);
                break;
            }
            case 5: {
                this.paintModeAbout(g, iScrollX);
                break;
            }
            case 6: {
                this.paintModeQuit(g, iScrollX);
                break;
            }
            case 3: {
                this.paintModeOptions(g, iScrollX);
                break;
            }
            case 7: {
                this.paintModeGameSelection(g, iScrollX);
                break;
            }
            case 22: {
                this.paintCupInfo(g, iScrollX);
                break;
            }
            case 21: {
                this.paintModeCreateCup(g, iScrollX);
                break;
            }
            case 9: {
                this.paintModeInstructions(g, iScrollX);
                break;
            }
            case 10: {
                this.paintModeCreateMatch(g, iScrollX);
                break;
            }
            case 11: {
                this.paintModeErase(g, iScrollX);
            }
        }
    }

    void paintNewScreen(Graphics g, int iScrollX) {
        switch (this.iNewMode) {
            case 2: {
                this.paintModeMenu(g, iScrollX);
                break;
            }
            case 4: {
                this.paintModeCreatingTeam(g, iScrollX);
                break;
            }
            case 5: {
                this.paintModeAbout(g, iScrollX);
                break;
            }
            case 6: {
                this.paintModeQuit(g, iScrollX);
                break;
            }
            case 3: {
                this.paintModeOptions(g, iScrollX);
                break;
            }
            case 7: {
                this.paintModeGameSelection(g, iScrollX);
                break;
            }
            case 22: {
                this.paintCupInfo(g, iScrollX);
                break;
            }
            case 21: {
                this.paintModeCreateCup(g, iScrollX);
                break;
            }
            case 9: {
                this.paintModeInstructions(g, iScrollX);
                break;
            }
            case 10: {
                this.paintModeCreateMatch(g, iScrollX);
                break;
            }
            case 11: {
                this.paintModeErase(g, iScrollX);
            }
        }
    }

    private void paintModeQuit(Graphics g, int iScrollX) {
        Resources.paintWindow(g, iScrollX);
        Resources.paintBottomGrass(g);
        this.strText = MyApplication.resTxt.getString("QUESTION_QUIT");
        Texts.drawTextAtPos(g, iScrollX + (Resources.WIDTH - Texts.getTextWidth(this.strText) >> 1), Resources.HEIGHT >> 1, this.strText);
    }

    private void paintModeMenu(Graphics g, int iScrollX) {
        Resources.paintWindow(g, iScrollX);
        int iIconX = Resources.iMenuBallW - Resources.iMenuIconsW >> 1;
        int iIconY = Resources.iMenuBallH - Resources.iMenuIconsH >> 1;
        if (++iBlickTime > 5) {
            iBlickTime = 0;
        }
        for (int i = 0; i < 4; ++i) {
            if (i != 3) {
                Resources.pSprMenuBalls.setFrame(1);
                Resources.pSprMenuBalls.setPosition(Resources.iMenuIconsX[i] + iScrollX, Resources.iMenuIconsY[i]);
                Resources.pSprMenuBalls.paint(g);
            } else {
                Resources.pSprMenuBalls.setFrame(0);
                Resources.pSprMenuBalls.setPosition(Resources.iMenuIconsX[i] + iScrollX, Resources.iMenuIconsY[i]);
                Resources.pSprMenuBalls.paint(g);
            }
            if (i == this.iSelectedMenuItem) {
                if (iBlickTime == 0) {
                    iBlickFrame = iBlickFrame == 0 ? 4 : 0;
                }
                Resources.pSprMenuIcons.setFrame(i + iBlickFrame);
                Resources.pSprMenuIcons.setPosition(Resources.iMenuIconsX[i] + iIconX + iScrollX, Resources.iMenuIconsY[i] + iIconY);
                Resources.pSprMenuIcons.paint(g);
                continue;
            }
            Resources.pSprMenuIcons.setFrame(i + 4);
            Resources.pSprMenuIcons.setPosition(Resources.iMenuIconsX[i] + iIconX + iScrollX, Resources.iMenuIconsY[i] + iIconY);
            Resources.pSprMenuIcons.paint(g);
        }
        Resources.paintBottomGrass(g);
    }

    void paintCupInfo(Graphics g, int iScrollX) {
        Resources.paintWindow(g, iScrollX);
        Resources.paintBottomGrass(g);
        MyApplication.cup.paintCupInfo(g, iScrollX, Resources.getWindowPosY(), Resources.iMenuW, true);
    }

    void paintModeCreateCup(Graphics g, int iScrollX) {
        Resources.paintWindow(g, iScrollX);
        Resources.paintBottomGrass(g);
        iLosScreenY = Resources.iTitlePosY + Resources.iTitleH + 5;
        if (this.strTexts[0] != null) {
            Texts.drawTextAtPos(g, this.iTextposX[0] + iScrollX, iLosScreenY, this.strTexts[0]);
            iLosScreenY += Texts.getFontHeight() * 2;
        } else {
            Resources.drawMultilineText(g, iScrollX, iLosScreenY);
            iLosScreenY += Resources.getTextHeight() + Texts.getFontHeight();
        }
        for (int i = 0; i < 2; ++i) {
            if (i == iCreatingCupSelectedItem) {
                g.setColor(0xCCE000);
                g.fillRect(this.iItemPosX + iScrollX, iLosScreenY, Resources.MENU_ITM_WIDTH, Resources.MENU_ITM_HEIGHT);
                g.setColor(5398016);
                g.drawRect(this.iItemPosX + iScrollX, iLosScreenY, Resources.MENU_ITM_WIDTH, Resources.MENU_ITM_HEIGHT);
            } else {
                g.setColor(14479872);
                g.fillRect(this.iItemPosX + iScrollX, iLosScreenY, Resources.MENU_ITM_WIDTH, Resources.MENU_ITM_HEIGHT);
            }
            if (i == 1) {
                Texts.drawTextAtPos(g, this.iItemPosX + iScrollX + Resources.iMenuArrSmallW + 2, iLosScreenY + this.iTextDiffY, Globals.strNations[iDressCnt]);
                Resources.pImgStateSel.drawAtPoint(g, iScrollX + this.iDiffX, iLosScreenY + this.iFlagPosY);
                Resources.pSprFlags.setFrame(this.iFlagFrame);
                Resources.pSprFlags.setPosition(iScrollX + this.iDiffX, iLosScreenY + this.iFlagPosY);
                Resources.pSprFlags.paint(g);
            }
            if (i == 0) {
                Resources.pSprOptionsIcons.setFrame(2);
                Resources.pSprOptionsIcons.setPosition(this.iItemPosX + iScrollX + this.iItmDiffX, iLosScreenY + this.iDiffY - 10);
                Resources.pSprOptionsIcons.paint(g);
                Texts.drawTextAtPos(g, this.iItemPosX + iScrollX + Resources.MENU_ITM_WIDTH - Texts.getTextWidth(sbTime.toString()) - Resources.iMenuArrSmallW - 2, iLosScreenY + this.iDiffY + this.iTextInItemDiffY, sbTime.toString());
            }
            if (i == iCreatingCupSelectedItem) {
                if (i == 1 || Globals.iCupTimeMin != 3 || Globals.iCupTimeSec != 0) {
                    Resources.pSprMenuArrSmall.setFrame(0);
                    Resources.pSprMenuArrSmall.setPosition(this.iItemPosX + iScrollX, iLosScreenY + this.iDiffY + this.iArrowY);
                    Resources.pSprMenuArrSmall.paint(g);
                }
                if (i == 1 || Globals.iCupTimeMin != 45 || Globals.iCupTimeSec != 0) {
                    Resources.pSprMenuArrSmall.setFrame(1);
                    Resources.pSprMenuArrSmall.setPosition(this.iItemPosX + Resources.MENU_ITM_WIDTH - Resources.iMenuArrSmallW + iScrollX, iLosScreenY + this.iDiffY + this.iArrowY);
                    Resources.pSprMenuArrSmall.paint(g);
                }
            }
            iLosScreenY += Resources.MENU_ITM_HEIGHT + 10;
        }
        int iDiffX = Resources.iPlayerSelW - Resources.iDressW >> 1;
        int x = this.iItemPosX + Resources.MENU_ITM_WIDTH - Resources.iPlayerSelW + iDiffX;
        Resources.pImgDress.drawAtPoint(g, x + iScrollX, iLosScreenY + Resources.iPlayerSelH - Resources.iDressH);
        x = this.iItemPosX + Resources.MENU_ITM_WIDTH - Resources.iPlayerSelW;
        Resources.pImgPlayerColorSel.drawAtPoint(g, x + iScrollX, iLosScreenY);
        Texts.drawTextAtPos(g, this.iTextposX[3] + iScrollX, iLosScreenY, this.strTexts[3]);
        Texts.drawTextAtPos(g, this.iTextposX[4] + iScrollX, iLosScreenY += Texts.getFontHeight(), this.strTexts[4]);
        iLosScreenY += Texts.getFontHeight();
    }

    void paintModeInstructions(Graphics g, int iScrollX) {
        Resources.paintWindow(g, iScrollX);
        Resources.paintBottomGrass(g);
        Resources.drawMultilineText(g, iScrollX, Resources.iTitlePosY + Resources.iTitleH);
        int iArrPosX = (Resources.WIDTH - Resources.iMenuW >> 1) + Resources.iMenuW - Resources.iMenuArrSmallW * 2;
        int iArrPosY = Resources.HEIGHT - Resources.iMenuW >> 1;
        if (Resources.iStartLine != 0) {
            Resources.pSprMenuArrSmall.setFrame(2);
            Resources.pSprMenuArrSmall.setPosition(iArrPosX + iScrollX, iArrPosY);
            Resources.pSprMenuArrSmall.paint(g);
        }
        if (Resources.iStartLine != Resources.iEndScroll) {
            Resources.pSprMenuArrSmall.setFrame(3);
            Resources.pSprMenuArrSmall.setPosition(iArrPosX + iScrollX, iArrPosY + Resources.iMenuW - Resources.iMenuArrSmallH);
            Resources.pSprMenuArrSmall.paint(g);
        }
    }

    void paintModeGameSelection(Graphics g, int iScrollX) {
        Resources.paintWindow(g, iScrollX);
        Resources.paintBottomGrass(g);
        this.paintMenu(g, Resources.pSprIcons2, this.iMenuSelector, iScrollX, this.submenuTxt, null);
    }

    void paintModeOptions(Graphics g, int iScrollX) {
        Resources.paintWindow(g, iScrollX);
        Resources.paintBottomGrass(g);
        this.paintMenu(g, Resources.pSprOptionsIcons, this.iOptionSelector, iScrollX, this.optionsTxt, this.optionsVar);
    }

    void paintModeErase(Graphics g, int iScrollX) {
        Resources.paintWindow(g, iScrollX);
        Resources.paintBottomGrass(g);
        this.iActualPosY = Resources.HEIGHT - (this.iItemH << 1) + Resources.MENU_ITM_SPC_H >> 1;
        for (int i = 0; i < 2; ++i) {
            if (i == this.iChoice) {
                g.setColor(0xCCE000);
            } else {
                g.setColor(14479872);
            }
            g.fillRect(this.iItemPosX + iScrollX, this.iActualPosY, Resources.MENU_ITM_WIDTH, Resources.MENU_ITM_HEIGHT);
            if (i == this.iChoice) {
                g.setColor(5398016);
                g.drawRect(this.iItemPosX + iScrollX, this.iActualPosY, Resources.MENU_ITM_WIDTH, Resources.MENU_ITM_HEIGHT);
            }
            Texts.drawTextAtPos(g, this.iTextOtherposX[i] + iScrollX, this.iActualPosY + this.iTextInItemDiffY, this.otherTexts[i]);
            this.iActualPosY += this.iItemH;
        }
    }

    void paintMenu(Graphics g, Sprite spr, int iSelectorY, int iScrlX, String[] txt, String[] val) {
        this.iActualPosY = this.iItemPosY;
        for (int i = 0; i < this.iItemsCount; ++i) {
            if (i == iSelectorY) {
                g.setColor(0xCCE000);
            } else {
                g.setColor(14479872);
            }
            g.fillRect(this.iItemPosX + iScrlX, this.iActualPosY, Resources.MENU_ITM_WIDTH, Resources.MENU_ITM_HEIGHT);
            if (i == iSelectorY) {
                g.setColor(5398016);
                g.drawRect(this.iItemPosX + iScrlX, this.iActualPosY, Resources.MENU_ITM_WIDTH, Resources.MENU_ITM_HEIGHT);
            }
            spr.setFrame(i);
            spr.setPosition(this.iItemPosX + iScrlX + this.iItmDiffX, this.iActualPosY - Resources.MENU_ITM_DIFF_Y);
            spr.paint(g);
            if (txt[i] != null) {
                Texts.drawTextAtPos(g, this.iItemPosX + iScrlX + this.iItmDiffX + Resources.MENU_ITM_TXT_X, this.iActualPosY + this.iTextInItemDiffY, txt[i]);
            }
            if (val != null) {
                Texts.drawTextAtPos(g, this.iItemPosX + iScrlX + Resources.MENU_ITM_WIDTH - Texts.getTextWidth(val[i]) - Resources.iMenuArrSmallW - 2, this.iActualPosY + this.iTextInItemDiffY, val[i]);
            }
            if (val != null) {
                Resources.pSprMenuArrSmall.setFrame(0);
                Resources.pSprMenuArrSmall.setPosition(this.iItemPosX + iScrlX, this.iActualPosY + this.iSmallArrY);
                if (i != 2) {
                    Resources.pSprMenuArrSmall.paint(g);
                } else if (Globals.iTimeMin != 3 || Globals.iTimeSec != 0) {
                    Resources.pSprMenuArrSmall.paint(g);
                }
                Resources.pSprMenuArrSmall.setFrame(1);
                Resources.pSprMenuArrSmall.setPosition(this.iItemPosX + iScrlX + Resources.MENU_ITM_WIDTH - Resources.iMenuArrSmallW, this.iActualPosY + this.iSmallArrY);
                if (i != 2) {
                    Resources.pSprMenuArrSmall.paint(g);
                } else if (Globals.iTimeMin != 45 || Globals.iTimeSec != 0) {
                    Resources.pSprMenuArrSmall.paint(g);
                }
            }
            this.iActualPosY += this.iItemH;
        }
    }

    void paintModeAbout(Graphics g, int iScrollX) {
        Resources.paintWindow(g, iScrollX);
        Resources.paintBottomGrass(g);
        int iLogoX = Resources.WIDTH - Resources.pImgLogo.getWidth() >> 1;
        int iLogoY = Resources.iTitlePosY + Resources.iTitleH;
        Resources.pImgLogo.drawAtPoint(g, iLogoX + iScrollX, iLogoY);
        Vector vecTexts = Texts.separateText("SUPER POCKET FOOTBALL 2014\n INLOGIC S.R.O. \n V " + Application.getSingleton().getAppProperty("MIDlet-Version"), Resources.iMenuW - 10);
        for (int i = 0; i < vecTexts.size(); ++i) {
            int iTextPosX = Resources.WIDTH - Texts.getTextWidth(vecTexts.elementAt(i).toString()) >> 1;
            Texts.drawTextAtPos(g, iTextPosX + iScrollX, Resources.pImgLogo.getHeight() + iLogoY + i * Texts.getFontHeight(), vecTexts.elementAt(i).toString());
        }
    }

    void prepareSelectionScreen() {
        this.iStep = Resources.MENU_ITM_HEIGHT + Resources.MENU_ITM_SPC_H;
        this.iArrowY = Resources.MENU_ITM_HEIGHT - Resources.iMenuArrSmallH >> 1;
        this.iDiffX = Resources.MENU_ITM_WIDTH - 40;
        this.iTextDiffY = Resources.MENU_ITM_HEIGHT - Texts.getFontHeight() >> 1;
        this.iItemPosX = Resources.WIDTH - Resources.MENU_ITM_WIDTH >> 1;
        this.iDiffTimeX = (Resources.iOptIconW >> 2) + (Resources.WIDTH - Resources.MENU_ITM_WIDTH >> 1);
        this.iFlagPosY = Resources.MENU_ITM_HEIGHT - Resources.iFlagH >> 1;
    }

    void loadFlag() {
        if (Globals.iMyTeamFlagSet == 0) {
            Resources.pSprFlags = new Sprite(new Image("/StatesI.png"), 8, 1);
        } else if (Globals.iMyTeamFlagSet == 1) {
            Resources.pSprFlags = new Sprite(new Image("/StatesII.png"), 8, 1);
        } else if (Globals.iMyTeamFlagSet == 2) {
            Resources.pSprFlags = new Sprite(new Image("/StatesIII.png"), 8, 1);
        } else if (Globals.iMyTeamFlagSet == 3) {
            Resources.pSprFlags = new Sprite(new Image("/StatesIV.png"), 8, 1);
        }
    }

    void prepareFlagSetEnemy() {
        if (this.iEnemyCountry / 8 == 0 && this.iOldFlagSet != 0) {
            Resources.pSprFlags2 = new Sprite(new Image("/StatesI.png"), 8, 1);
            this.iOldFlagSet = 0;
            System.gc();
        } else if (this.iEnemyCountry / 8 == 1 && this.iOldFlagSet != 1) {
            Resources.pSprFlags2 = new Sprite(new Image("/StatesII.png"), 8, 1);
            this.iOldFlagSet = 1;
            System.gc();
        } else if (this.iEnemyCountry / 8 == 2 && this.iOldFlagSet != 2) {
            Resources.pSprFlags2 = new Sprite(new Image("/StatesIII.png"), 8, 1);
            this.iOldFlagSet = 2;
            System.gc();
        } else if (this.iEnemyCountry / 8 == 3 && this.iOldFlagSet != 3) {
            Resources.pSprFlags2 = new Sprite(new Image("/StatesIV.png"), 8, 1);
            this.iOldFlagSet = 3;
            System.gc();
        }
    }

    void paintModeCreateMatch(Graphics g, int iScrollX) {
        Resources.paintWindow(g, iScrollX);
        Resources.paintBottomGrass(g);
        this.iDiffY = 0;
        for (int i = 0; i < 4; ++i) {
            if (i == this.iCreatingMatchSel) {
                g.setColor(0xCCE000);
                g.fillRect(this.iItemPosX + iScrollX, this.iCreatingTeamPosY + this.iDiffY, Resources.MENU_ITM_WIDTH, Resources.MENU_ITM_HEIGHT);
                g.setColor(5398016);
                g.drawRect(this.iItemPosX + iScrollX, this.iCreatingTeamPosY + this.iDiffY, Resources.MENU_ITM_WIDTH, Resources.MENU_ITM_HEIGHT);
            } else {
                g.setColor(14479872);
                g.fillRect(this.iItemPosX + iScrollX, this.iCreatingTeamPosY + this.iDiffY, Resources.MENU_ITM_WIDTH, Resources.MENU_ITM_HEIGHT);
            }
            if (i == 0) {
                Texts.drawTextAtPos(g, this.iItemPosX + iScrollX + Resources.iMenuArrSmallW + 2, this.iCreatingTeamPosY + this.iDiffY + this.iTextDiffY, Globals.strNations[this.iFriendlyMatchMyTeam]);
                Resources.pImgStateSel.drawAtPoint(g, iScrollX + this.iDiffX, this.iCreatingTeamPosY + this.iDiffY + this.iFlagPosY);
                Resources.pSprFlags.setFrame(this.iFlagFrame);
                Resources.pSprFlags.setPosition(iScrollX + this.iDiffX, this.iCreatingTeamPosY + this.iDiffY + this.iFlagPosY);
                Resources.pSprFlags.paint(g);
            }
            if (i == 1) {
                Texts.drawTextAtPos(g, (Resources.WIDTH - Texts.getTextWidth(this.strVersus) >> 1) + iScrollX, this.iCreatingTeamPosY + this.iDiffY + this.iTextDiffY, this.strVersus);
            }
            if (i == 2) {
                Texts.drawTextAtPos(g, this.iItemPosX + iScrollX + Resources.iMenuArrSmallW + 2, this.iCreatingTeamPosY + this.iDiffY + this.iTextDiffY, Globals.strNations[this.iEnemyCountry]);
                Resources.pImgStateSel.drawAtPoint(g, iScrollX + this.iDiffX, this.iCreatingTeamPosY + this.iDiffY + this.iFlagPosY);
                Resources.pSprFlags2.setFrame(this.iEnemyCountry);
                Resources.pSprFlags2.setPosition(iScrollX + this.iDiffX, this.iCreatingTeamPosY + this.iDiffY + this.iFlagPosY);
                Resources.pSprFlags2.paint(g);
            }
            if (i == this.iCreatingMatchSel) {
                if (Globals.iTimeMin != 3 || Globals.iTimeSec != 0 || i == 2 || i == 0) {
                    Resources.pSprMenuArrSmall.setFrame(0);
                    Resources.pSprMenuArrSmall.setPosition(this.iItemPosX + iScrollX, this.iCreatingTeamPosY + this.iDiffY + this.iArrowY);
                    Resources.pSprMenuArrSmall.paint(g);
                }
                if (Globals.iTimeMin != 45 || Globals.iTimeSec != 0 || i == 2 || i == 0) {
                    Resources.pSprMenuArrSmall.setFrame(1);
                    Resources.pSprMenuArrSmall.setPosition(this.iItemPosX + Resources.MENU_ITM_WIDTH - Resources.iMenuArrSmallW + iScrollX, this.iCreatingTeamPosY + this.iDiffY + this.iArrowY);
                    Resources.pSprMenuArrSmall.paint(g);
                }
            }
            if (i == 3) {
                Resources.pSprOptionsIcons.setFrame(2);
                Resources.pSprOptionsIcons.setPosition(iScrollX + this.iDiffTimeX, this.iCreatingTeamPosY + this.iDiffY - Resources.MENU_ITM_DIFF_Y);
                Resources.pSprOptionsIcons.paint(g);
                Texts.drawTextAtPos(g, this.iItemPosX + Resources.MENU_ITM_WIDTH + iScrollX - this.iTimeWidth - Resources.iMenuArrSmallW, this.iCreatingTeamPosY + this.iDiffY + this.iTextDiffY, sb.toString());
            }
            this.iDiffY += this.iStep;
        }
    }

    void paintModeCreatingTeam(Graphics g, int iScrollX) {
        Resources.paintWindow(g, iScrollX);
        Resources.paintBottomGrass(g);
        int x = Resources.WIDTH - Resources.iFlagW >> 1;
        int y = Resources.iTitlePosY + Resources.iTitleH;
        Resources.drawMultilineText(g, iScrollX, y);
        Texts.drawTextAtPos(g, (Resources.WIDTH - Texts.getTextWidth(sb.toString()) >> 1) + iScrollX, y += Resources.getTextHeight() + Texts.getFontHeight(), sb.toString());
        Resources.pImgStateSel.drawAtPoint(g, x + iScrollX, y += Texts.getFontHeight());
        Resources.pSprFlags.setFrame(this.iFlagFrame);
        Resources.pSprFlags.setPosition(iScrollX + x, y);
        Resources.pSprFlags.paint(g);
        Resources.pSprMenuArrSmall.setFrame(0);
        Resources.pSprMenuArrSmall.setPosition(x - Resources.iMenuArrSmallW + iScrollX, y + this.iSmallArrY);
        Resources.pSprMenuArrSmall.paint(g);
        Resources.pSprMenuArrSmall.setFrame(1);
        Resources.pSprMenuArrSmall.setPosition(x + Resources.iFlagW + iScrollX, y + this.iSmallArrY);
        Resources.pSprMenuArrSmall.paint(g);
        x = Resources.WIDTH - Resources.iDressW >> 1;
        Resources.pImgDress.drawAtPoint(g, x + iScrollX, (y += Resources.iFlagH) + Resources.iPlayerSelH - Resources.iDressH);
        x = Resources.WIDTH - Resources.iPlayerSelW >> 1;
        Resources.pImgPlayerColorSel.drawAtPoint(g, x + iScrollX, y);
    }

    private void animateToNextMode() {
        if (!this.bAnimateToNextMode) {
            return;
        }
        this.iAnimationStep += 20;
        if (this.iAnimationStep >= Resources.WIDTH) {
            this.iAnimationStep = 0;
            this.bAnimateToNextMode = false;
            this.bAnimationLock = false;
        }
        this.pMyApplication.repaintScreen();
    }

    private void callAnimationToMode(int newMode, boolean bLeftScrl, boolean bRightScrl) {
        this.bAnimationLock = true;
        this.bAnimateToNextMode = true;
        this.bScrollLeft = bLeftScrl;
        this.bScrollRight = bRightScrl;
        bStop = false;
        this.iOldMode = this.iMode;
        this.iNewMode = newMode;
        this.iMode = newMode;
    }

    private void startGame() {
        Resources.releaseMenuResources();
        Globals.load();
        Globals.recalculateTimeCup();
        Globals.recalculateTime();
        MyApplication.pScrGame = new ScreenGame(iSelectedTeam, this.bCup, this.bContinue);
        MyApplication.pActiveScreen = MyApplication.pScrGame;
        MyApplication.pScrMenu = null;
        this.iMode = 0;
    }

    public void callMode(int idx) {
        switch (idx) {
            case 3: {
                this.reloadTexts();
                this.prepareMenuItms(3);
                this.callAnimationToMode(7, true, false);
                break;
            }
            case 1: {
                this.callAnimationToMode(5, true, false);
                break;
            }
            case 4: {
                this.callAnimationToMode(6, true, false);
                break;
            }
            case 2: {
                this.reloadOptions();
                this.prepareTime(false);
                this.callAnimationToMode(3, true, false);
                break;
            }
            case 0: {
                ScreenMenu.prepareInstructionText(Resources.iMenuW - 10, Resources.TEXT_WIN_H);
                this.callAnimationToMode(9, true, false);
            }
        }
    }

    public static void prepareInstructionText(int width, int height) {
        sb.setLength(0);
        sb.append(MyApplication.resTxt.getString("INSTRUCTIONS_GOAL")).append("\n \n");
        sb.append(MyApplication.resTxt.getString("INSTRUCTIONS_CONTROLS")).append("\n \n");
        sb.append(MyApplication.resTxt.getString("INSTRUCTIONS_CONTROLS_KEY")).append("\n \n");
        sb.append(MyApplication.resTxt.getString("INSTRUCTIONS_CUP"));
        Resources.prepTxt(sb.toString(), width, height);
    }

    public void changeDressLeft() {
        if (--iDressCnt < 0) {
            iDressCnt = 31;
        }
        if (--this.iFlagFrame < 0) {
            this.iFlagFrame = 7;
            if (--this.iFlagTile < 0) {
                this.iFlagTile = 3;
            }
            if (this.iFlagTile == 0) {
                Resources.pSprFlags = new Sprite(new Image("/StatesI.png"), 8, 1);
            } else if (this.iFlagTile == 1) {
                Resources.pSprFlags = new Sprite(new Image("/StatesII.png"), 8, 1);
            } else if (this.iFlagTile == 2) {
                Resources.pSprFlags = new Sprite(new Image("/StatesIII.png"), 8, 1);
            } else if (this.iFlagTile == 3) {
                Resources.pSprFlags = new Sprite(new Image("/StatesIV.png"), 8, 1);
            }
        }
        sb.setLength(0);
        sb.append(Globals.strNations[iDressCnt]);
        Resources.pImgDress = MyApplication.loadPalImage(iDressCnt + 1 + ".pal", "/dress.p");
        Globals.iMyTeamIdx = iDressCnt;
        Globals.iMyTeamFlagSet = this.iFlagTile;
        Globals.iMyTeamFlagIdx = this.iFlagFrame;
        this.pMyApplication.repaintScreen();
    }

    public void changeDressRight() {
        if (++iDressCnt > 31) {
            iDressCnt = 0;
        }
        if (++this.iFlagFrame > 7) {
            this.iFlagFrame = 0;
            if (++this.iFlagTile > 3) {
                this.iFlagTile = 0;
            }
            if (this.iFlagTile == 0) {
                Resources.pSprFlags = new Sprite(new Image("/StatesI.png"), 8, 1);
            } else if (this.iFlagTile == 1) {
                Resources.pSprFlags = new Sprite(new Image("/StatesII.png"), 8, 1);
            } else if (this.iFlagTile == 2) {
                Resources.pSprFlags = new Sprite(new Image("/StatesIII.png"), 8, 1);
            } else if (this.iFlagTile == 3) {
                Resources.pSprFlags = new Sprite(new Image("/StatesIV.png"), 8, 1);
            }
        }
        sb.setLength(0);
        sb.append(Globals.strNations[iDressCnt]);
        Resources.pImgDress = MyApplication.loadPalImage(iDressCnt + 1 + ".pal", "/dress.p");
        Globals.iMyTeamIdx = iDressCnt;
        Globals.iMyTeamFlagSet = this.iFlagTile;
        Globals.iMyTeamFlagIdx = this.iFlagFrame;
        this.pMyApplication.repaintScreen();
    }

    public void keyPressed(Key pKey) {
        if (!MyApplication.isMusicPlaying()) {
            MyApplication.setMusicIsResumed(true);
            Sounds.setVolume(100);
            Sounds.setMusicVol(100);
            if (Globals.bMusic && !Sounds.musicPlaying()) {
                Sounds.playMenuMusic();
            }
        }
        if (this.bAnimationLock) {
            return;
        }
        if (this.iMode == 2) {
            if (pKey.iGameAction == 2 || pKey.iGameAction == 52 || pKey.iValue == 52) {
                if (this.iSelectedMenuItem == 2) {
                    this.iSelectedMenuItem = 3;
                } else if (this.iSelectedMenuItem == 1) {
                    this.iSelectedMenuItem = 0;
                }
            } else if (pKey.iGameAction == 5 || pKey.iGameAction == 54 || pKey.iValue == 54) {
                if (this.iSelectedMenuItem == 3) {
                    this.iSelectedMenuItem = 2;
                } else if (this.iSelectedMenuItem == 0) {
                    this.iSelectedMenuItem = 1;
                } else if (this.iSelectedMenuItem == 1) {
                    this.iSelectedMenuItem = 2;
                }
            } else if (pKey.iGameAction == 6 || pKey.iGameAction == 56 || pKey.iValue == 56) {
                if (this.iSelectedMenuItem == 1) {
                    this.iSelectedMenuItem = 2;
                } else if (this.iSelectedMenuItem == 0) {
                    this.iSelectedMenuItem = 3;
                }
            } else if (pKey.iGameAction == 1 || pKey.iGameAction == 50 || pKey.iValue == 50) {
                if (this.iSelectedMenuItem == 3) {
                    this.iSelectedMenuItem = 0;
                } else if (this.iSelectedMenuItem == 2) {
                    this.iSelectedMenuItem = 1;
                }
            } else if (pKey.iValue == Keys.KEY_FNRIGHT || pKey.iGameAction == Keys.KEY_FNRIGHT) {
                this.callMode(4);
            } else if (pKey.iValue == 53 || pKey.iGameAction == 8) {
                this.callMode(this.iSelectedMenuItem);
            } else if (!this.bDisableLeftKey && pKey.iValue == Keys.KEY_FNLEFT || pKey.iGameAction == Keys.KEY_FNLEFT) {
                this.callMode(this.iSelectedMenuItem);
            }
        } else if (this.iMode == 11) {
            if (pKey.iGameAction == 1 || pKey.iGameAction == 50) {
                if (--this.iChoice < 0) {
                    this.iChoice = 0;
                }
                this.pMyApplication.repaintScreen();
            } else if (pKey.iGameAction == 6 || pKey.iGameAction == 56) {
                if (++this.iChoice > 1) {
                    this.iChoice = 1;
                }
                this.pMyApplication.repaintScreen();
            } else if (pKey.iValue == 53 || pKey.iGameAction == 8) {
                this.executeErase(this.iChoice);
            } else if (pKey.iValue == Keys.KEY_FNRIGHT || pKey.iGameAction == Keys.KEY_FNRIGHT) {
                this.callAnimationToMode(7, false, true);
            }
        } else if (this.iMode == 9) {
            if (pKey.iValue == Keys.KEY_FNRIGHT || pKey.iGameAction == Keys.KEY_FNRIGHT) {
                this.callAnimationToMode(2, false, true);
            } else if (pKey.iValue == 50 || pKey.iGameAction == 1) {
                Resources.scrollDown();
                this.pMyApplication.repaintScreen();
            } else if (pKey.iValue == 56 || pKey.iGameAction == 6) {
                Resources.scrollUp();
                this.pMyApplication.repaintScreen();
            }
        } else if (this.iMode == 4) {
            if (pKey.iValue == Keys.KEY_FNRIGHT || pKey.iGameAction == Keys.KEY_FNRIGHT) {
                this.callAnimationToMode(7, false, true);
            } else if (pKey.iValue == Keys.KEY_FNLEFT || pKey.iGameAction == Keys.KEY_FNLEFT) {
                if (iDressCnt != Globals.iMyTeamIdx) {
                    Globals.deletCup();
                    Globals.restartStats();
                }
                Globals.iMyTeamIdx = iDressCnt;
                Globals.iMyTeamFlagSet = this.iFlagTile;
                Globals.iMyTeamFlagIdx = this.iFlagFrame;
                this.callAnimationToMode(7, false, true);
            } else if (pKey.iGameAction == 5) {
                this.changeDressRight();
            } else if (pKey.iGameAction == 2) {
                this.changeDressLeft();
            }
        } else if (this.iMode == 5) {
            if (pKey.iValue == Keys.KEY_FNRIGHT || pKey.iGameAction == Keys.KEY_FNRIGHT) {
                this.callAnimationToMode(2, false, true);
                return;
            }
        } else if (this.iMode == 3) {
            if (pKey.iValue == 50 || pKey.iGameAction == 1) {
                if (--this.iOptionSelector < 0) {
                    this.iOptionSelector = 0;
                }
                this.pMyApplication.repaintScreen();
                return;
            }
            if (pKey.iValue == 56 || pKey.iGameAction == 6) {
                if (++this.iOptionSelector > 3) {
                    this.iOptionSelector = 3;
                }
                this.pMyApplication.repaintScreen();
                return;
            }
            if (pKey.iValue == 54 || pKey.iGameAction == 5) {
                if (this.iOptionSelector == 0) {
                    this.updateLanguagesInc();
                } else if (this.iOptionSelector == 1) {
                    this.updateSound();
                } else if (this.iOptionSelector == 2) {
                    this.setTimeInc();
                } else if (this.iOptionSelector == 3) {
                    this.updateDifficultyRight();
                }
            } else if (pKey.iValue == 52 || pKey.iGameAction == 2) {
                if (this.iOptionSelector == 0) {
                    this.updateLanguagesDec();
                } else if (this.iOptionSelector == 1) {
                    this.updateSound();
                } else if (this.iOptionSelector == 2) {
                    this.setTimeDec();
                } else if (this.iOptionSelector == 3) {
                    this.updateDifficultyLeft();
                }
            }
            this.pMyApplication.repaintScreen();
            if (pKey.iValue == Keys.KEY_FNLEFT || pKey.iGameAction == Keys.KEY_FNLEFT) {
                Globals.save();
                Globals.strLang = Globals.strLanguage[Globals.iSelectedLang];
                ResTexts.setPath();
                this.callAnimationToMode(2, false, true);
            }
        } else if (this.iMode == 6) {
            if (pKey.iValue == Keys.KEY_FNRIGHT || pKey.iGameAction == Keys.KEY_FNRIGHT) {
                this.callAnimationToMode(2, false, true);
            } else if (pKey.iValue == Keys.KEY_FNLEFT || pKey.iGameAction == Keys.KEY_FNLEFT) {
                Sounds.stopMusic();
                Application.getSingleton().stop();
            }
        } else if (this.iMode == 7) {
            if (pKey.iValue == 53 || pKey.iGameAction == 8) {
                this.executeAction();
            } else if (!this.bDisableLeftKey && pKey.iValue == Keys.KEY_FNLEFT || pKey.iGameAction == Keys.KEY_FNLEFT) {
                this.executeAction();
            } else if (pKey.iValue == Keys.KEY_FNRIGHT || pKey.iGameAction == Keys.KEY_FNRIGHT) {
                this.callAnimationToMode(2, false, true);
            } else if (pKey.iValue == 50 || pKey.iGameAction == 1) {
                if (--this.iMenuSelector < 0) {
                    this.iMenuSelector = 0;
                }
                this.pMyApplication.repaintScreen();
            } else if (pKey.iValue == 56 || pKey.iGameAction == 6) {
                if (++this.iMenuSelector > this.iItemsCount - 1) {
                    this.iMenuSelector = this.iItemsCount - 1;
                }
                this.pMyApplication.repaintScreen();
            }
        } else if (this.iMode == 22) {
            if (pKey.iValue == Keys.KEY_FNRIGHT || pKey.iGameAction == Keys.KEY_FNRIGHT) {
                this.callAnimationToMode(21, false, true);
            } else if (pKey.iValue == Keys.KEY_FNLEFT || pKey.iGameAction == Keys.KEY_FNLEFT) {
                Globals.iEnemyTeamIdx = MyApplication.cup.getOponentTeamNation();
                this.startCup();
            }
        } else if (this.iMode == 21) {
            if (pKey.iGameAction == 1 || pKey.iGameAction == 50 || pKey.iValue == 50) {
                if (--iCreatingCupSelectedItem < 0) {
                    iCreatingCupSelectedItem = 0;
                }
            } else if ((pKey.iGameAction == 6 || pKey.iGameAction == 56 || pKey.iValue == 56) && ++iCreatingCupSelectedItem > 1) {
                iCreatingCupSelectedItem = 1;
            }
            if (pKey.iValue == Keys.KEY_FNRIGHT || pKey.iGameAction == Keys.KEY_FNRIGHT) {
                this.callAnimationToMode(7, false, true);
            } else if (pKey.iValue == Keys.KEY_FNLEFT || pKey.iGameAction == Keys.KEY_FNLEFT) {
                this.createCupInfo();
            } else if (pKey.iGameAction == 5 || pKey.iGameAction == 54 || pKey.iValue == 54) {
                if (iCreatingCupSelectedItem == 1) {
                    this.changeDressRight();
                }
                if (iCreatingCupSelectedItem == 0) {
                    this.setCupTimeInc();
                }
            } else if (pKey.iGameAction == 2 || pKey.iGameAction == 52 || pKey.iValue == 52) {
                if (iCreatingCupSelectedItem == 1) {
                    this.changeDressLeft();
                }
                if (iCreatingCupSelectedItem == 0) {
                    this.setCupTimeDec();
                }
            }
            Globals.iMyTeamIdx = iDressCnt;
            this.strTexts[4] = MyApplication.cup.getPlayerGroup(Globals.iMyTeamIdx);
        } else if (this.iMode == 10) {
            if (pKey.iValue == 52 || pKey.iGameAction == 2) {
                if (this.iCreatingMatchSel == 0) {
                    this.scrollFlagLeftPlayer();
                } else if (this.iCreatingMatchSel == 2) {
                    this.scrollFlagLeft();
                } else if (this.iCreatingMatchSel == 3) {
                    this.setTimeDec();
                }
                this.pMyApplication.repaintScreen();
                return;
            }
            if (pKey.iValue == 54 || pKey.iGameAction == 5) {
                if (this.iCreatingMatchSel == 0) {
                    this.scrollFlagRightPlayer();
                } else if (this.iCreatingMatchSel == 2) {
                    this.scrollFlagRight();
                } else if (this.iCreatingMatchSel == 3) {
                    this.setTimeInc();
                }
                this.pMyApplication.repaintScreen();
                return;
            }
            if (pKey.iValue == 50 || pKey.iGameAction == 1) {
                this.scrollUp();
                this.pMyApplication.repaintScreen();
                return;
            }
            if (pKey.iValue == 56 || pKey.iGameAction == 6) {
                this.scrollDown();
                this.pMyApplication.repaintScreen();
                return;
            }
            if (pKey.iValue == Keys.KEY_FNRIGHT || pKey.iGameAction == Keys.KEY_FNRIGHT) {
                this.callAnimationToMode(7, false, true);
                return;
            }
            if (pKey.iValue == Keys.KEY_FNLEFT || pKey.iGameAction == Keys.KEY_FNLEFT) {
                this.startFriendly();
                return;
            }
        }
    }

    public void scrollDown() {
        if (this.iCreatingMatchSel == 0) {
            this.iCreatingMatchSel = 2;
        } else if (this.iCreatingMatchSel == 2) {
            this.iCreatingMatchSel = 3;
        } else if (this.iCreatingMatchSel == 3) {
            this.iCreatingMatchSel = 0;
        }
    }

    public void scrollUp() {
        if (this.iCreatingMatchSel == 0) {
            this.iCreatingMatchSel = 3;
        } else if (this.iCreatingMatchSel == 2) {
            this.iCreatingMatchSel = 0;
        } else if (this.iCreatingMatchSel == 3) {
            this.iCreatingMatchSel = 2;
        }
    }

    public void createCupInfo() {
        Globals.iMyTeamIdx = iDressCnt;
        Globals.iMyTeamFlagSet = this.iFlagTile;
        Globals.iMyTeamFlagIdx = this.iFlagFrame;
        MyApplication.cup.createCup(Globals.iMyTeamIdx);
        MyApplication.cup.prepareHeader();
        this.callAnimationToMode(22, true, false);
    }

    public void executeErase(int idx) {
        if (idx == 0) {
            System.out.println("cup 1");
            Globals.loadCup();
            System.out.println("cup 2");
            Globals.deletCup();
            System.out.println("cup 3");
            this.bContinue = true;
            System.out.println("cup 4");
            this.startCup();
            System.out.println("cup 5");
        } else {
            Globals.deletCup();
            Globals.restartStats();
            MyApplication.cup.resetCup();
            this.bCup = true;
            this.bContinue = false;
            this.prepareCupScreen();
        }
    }

    public void prepareCupScreen() {
        this.iDiffY = 0;
        this.resetTeamFlags();
        Resources.prepareText("START_CUP", Resources.iMenuW - 4, Texts.getFontHeight() << 1);
        this.strTexts[0] = null;
        this.iTextposX[0] = 0;
        this.strTexts[1] = MyApplication.resTxt.getHashedString("COUNTRY");
        this.iTextposX[1] = Resources.WIDTH - Texts.getTextWidth(this.strTexts[1]) >> 1;
        this.strTexts[2] = Globals.strNations[Globals.iMyTeamIdx];
        this.iTextposX[2] = Resources.WIDTH - Texts.getTextWidth(this.strTexts[2]) >> 1;
        this.strTexts[3] = MyApplication.resTxt.getHashedString("GROUP");
        this.iTextposX[3] = Resources.WIDTH - Texts.getTextWidth(this.strTexts[3]) >> 1;
        this.strTexts[4] = MyApplication.cup.getPlayerGroup(Globals.iMyTeamIdx);
        this.iTextposX[4] = Resources.WIDTH - Texts.getTextWidth(this.strTexts[4]) >> 1;
        this.prepareTime(true);
        int hlp = Globals.iMyTeamIdx / 8;
        this.iActualTeamFlag = Globals.iMyTeamIdx % 8;
        if (hlp == 0) {
            Resources.pSprFlags = new Sprite(new Image("/StatesI.png"), 8, 1);
        }
        if (hlp == 1) {
            Resources.pSprFlags = new Sprite(new Image("/StatesII.png"), 8, 1);
        }
        if (hlp == 2) {
            Resources.pSprFlags = new Sprite(new Image("/StatesIII.png"), 8, 1);
        }
        if (hlp == 3) {
            Resources.pSprFlags = new Sprite(new Image("/StatesIV.png"), 8, 1);
        }
        this.callAnimationToMode(21, true, false);
        Resources.pImgDress = MyApplication.loadPalImage(iDressCnt + 1 + ".pal", "/dress.p");
        Resources.iDressW = Resources.pImgDress.getWidth();
        Resources.iDressH = Resources.pImgDress.getHeight();
    }

    public void updateTimeTouch(int x) {
        int iTouchL = Resources.WIDTH >> 2;
        int iTouchR = 3 * (Resources.WIDTH >> 2);
        if (x < iTouchL) {
            this.setTimeDec();
        } else if (x > iTouchR) {
            this.setTimeInc();
        }
        this.prepareTime(false);
    }

    public void updateSound() {
        Globals.bMusic = !Globals.bMusic;
        String string = this.optionsVar[1] = Globals.bMusic ? this.strOnOff[0] : this.strOnOff[1];
        if (Globals.bMusic) {
            Sounds.playMenuMusic();
        } else {
            Sounds.stopMusic();
        }
    }

    public void updateSoundsTouch(int x) {
        int iTouchL = Resources.WIDTH >> 2;
        int iTouchR = 3 * (Resources.WIDTH >> 2);
        if (x < iTouchL) {
            this.updateSound();
        } else if (x > iTouchR) {
            this.updateSound();
        }
    }

    public void updateLanguageTouch(int x) {
        int iTouchL = Resources.WIDTH >> 2;
        int iTouchR = 3 * (Resources.WIDTH >> 2);
        if (x < iTouchL) {
            this.updateLanguagesDec();
        } else if (x > iTouchR) {
            this.updateLanguagesInc();
        }
    }

    public void updateDifficultyTouch(int x) {
        int iTouchL = Resources.WIDTH >> 2;
        int iTouchR = 3 * (Resources.WIDTH >> 2);
        if (x < iTouchL) {
            this.updateDifficultyLeft();
        } else if (x > iTouchR) {
            this.updateDifficultyRight();
        }
    }

    public void updateLanguagesInc() {
        if (++Globals.iSelectedLang > 4) {
            Globals.iSelectedLang = 0;
        }
        this.optionsVar[0] = Globals.strLanguage[Globals.iSelectedLang];
    }

    public void updateLanguagesDec() {
        if (--Globals.iSelectedLang < 0) {
            Globals.iSelectedLang = 4;
        }
        this.optionsVar[0] = Globals.strLanguage[Globals.iSelectedLang];
    }

    public void updateDifficultyLeft() {
        if (--Globals.iSelectedDiff < 0) {
            Globals.iSelectedDiff = 2;
        }
        this.optionsVar[3] = Globals.strDiff[Globals.iSelectedDiff];
    }

    public void updateDifficultyRight() {
        if (++Globals.iSelectedDiff > 2) {
            Globals.iSelectedDiff = 0;
        }
        this.optionsVar[3] = Globals.strDiff[Globals.iSelectedDiff];
    }

    public void scrollFlagLeft() {
        if (--this.iEnemyCountry < 0) {
            this.iEnemyCountry = 31;
        }
        this.checkFlag(false);
        this.prepareFlagSetEnemy();
    }

    public void scrollFlagRight() {
        if (++this.iEnemyCountry > 31) {
            this.iEnemyCountry = 0;
        }
        this.checkFlag(true);
        this.prepareFlagSetEnemy();
    }

    public void scrollFlagLeftPlayer() {
        if (--this.iFriendlyMatchMyTeam < 0) {
            this.iFriendlyMatchMyTeam = 31;
        }
        this.iFlagFrame = this.iFriendlyMatchMyTeam % 8;
        Globals.iMyTeamIdx = this.iFriendlyMatchMyTeam;
        Globals.iMyTeamFlagSet = this.iFriendlyMatchMyTeam >> 3;
        Globals.iMyTeamFlagIdx = this.iFlagFrame;
        this.checkFlag(true);
        this.loadFlag();
    }

    public void scrollFlagRightPlayer() {
        if (++this.iFriendlyMatchMyTeam > 31) {
            this.iFriendlyMatchMyTeam = 0;
        }
        this.iFlagFrame = this.iFriendlyMatchMyTeam % 8;
        Globals.iMyTeamIdx = this.iFriendlyMatchMyTeam;
        Globals.iMyTeamFlagSet = this.iFriendlyMatchMyTeam >> 3;
        Globals.iMyTeamFlagIdx = this.iFlagFrame;
        this.checkFlag(false);
        this.loadFlag();
    }

    public void resetTeamFlags() {
        Globals.iMyTeamIdx = 0;
        Globals.iMyTeamFlagSet = 0;
        Globals.iMyTeamFlagIdx = 0;
        this.iFriendlyMatchMyTeam = 0;
        this.iFlagFrame = 0;
        iDressCnt = 0;
    }

    public void executeAction() {
        if (this.iMenuSelector == 0) {
            this.resetTeamFlags();
            this.iOldFlagSet = 4;
            this.checkFlag(true);
            this.loadFlag();
            this.prepareFlagSetEnemy();
            this.prepareTime(false);
            this.iCreatingTeamPosY = Resources.HEIGHT - 4 * Resources.MENU_ITM_HEIGHT - 3 * Resources.MENU_ITM_SPC_H >> 1;
            this.iCreatingMatchSel = 0;
            this.callAnimationToMode(10, true, false);
        } else if (this.iMenuSelector == 1) {
            this.bCup = true;
            this.bContinue = false;
            if (Globals.existCupSave()) {
                System.out.println("cup existuje a ideme pokracovat");
            } else {
                System.out.println("cup neexistuje a teda je problme");
            }
            if (!Globals.existCupSave()) {
                this.prepareCupScreen();
                return;
            }
            this.otherTexts[0] = MyApplication.resTxt.getString("CONTINUE");
            this.iTextOtherposX[0] = Resources.WIDTH - Texts.getTextWidth(this.otherTexts[0]) >> 1;
            this.otherTexts[1] = MyApplication.resTxt.getString("NEW_CUP");
            this.iTextOtherposX[1] = Resources.WIDTH - Texts.getTextWidth(this.otherTexts[1]) >> 1;
            this.callAnimationToMode(11, true, false);
        } else if (this.iMenuSelector == 2) {
            Resources.releaseMenuResources();
            MyApplication.pScrTutorial = new ScreenTutorial(0);
            MyApplication.pActiveScreen = MyApplication.pScrTutorial;
            MyApplication.pScrMenu = null;
            return;
        }
    }

    public void checkFlag(boolean bInc) {
        if (this.iEnemyCountry == Globals.iMyTeamIdx) {
            if (bInc) {
                ++this.iEnemyCountry;
                if (this.iEnemyCountry > 29) {
                    this.iEnemyCountry = 0;
                }
            } else {
                --this.iEnemyCountry;
                if (this.iEnemyCountry < 0) {
                    this.iEnemyCountry = 29;
                }
            }
        }
    }

    public void keyReleased(Key pKey) {
    }

    public void pointerDragged(int x, int y) {
        switch (this.iMode) {
            case 9: {
                if (!Resources.dragText(y)) break;
                Application.getSingleton().repaintScreen();
                System.gc();
            }
        }
    }

    public void pointerPressed(int x, int y) {
        switch (this.iMode) {
            case 2: {
                if (Resources.pressedRightButton(x, y)) {
                    this.callMode(4);
                    return;
                }
                int iIconX = Resources.iMenuBallW - Resources.iMenuIconsW >> 1;
                int iIconY = Resources.iMenuBallH - Resources.iMenuIconsH >> 1;
                for (int i = 0; i < 4; ++i) {
                    if (x <= Resources.iMenuIconsX[i] + iIconX || x >= Resources.iMenuIconsX[i] + iIconX + Resources.iMenuIconsW || y <= Resources.iMenuIconsY[i] + iIconY || y >= Resources.iMenuIconsY[i] + iIconY + Resources.iMenuIconsH) continue;
                    this.iSelectedMenuItem = i;
                    this.callMode(this.iSelectedMenuItem);
                }
                break;
            }
            case 3: {
                if (Resources.pressedLeftButton(x, y)) {
                    Globals.save();
                    Globals.strLang = Globals.strLanguage[Globals.iSelectedLang];
                    ResTexts.setPath();
                    this.callAnimationToMode(2, false, true);
                    break;
                }
                int iItemH = Resources.MENU_ITM_HEIGHT + Resources.MENU_ITM_SPC_H;
                if (x < this.iItemPosX || x > this.iItemPosX + Resources.MENU_ITM_WIDTH) break;
                if (y > this.iItemPosY && y < this.iItemPosY + (iItemH << 2)) {
                    this.iOptionSelector = (y - this.iItemPosY) / iItemH;
                    if (this.iOptionSelector == 0) {
                        this.updateLanguageTouch(x);
                    }
                    if (this.iOptionSelector == 1) {
                        this.updateSoundsTouch(x);
                    }
                    if (this.iOptionSelector == 2) {
                        this.updateTimeTouch(x);
                    }
                    if (this.iOptionSelector == 3) {
                        this.updateDifficultyTouch(x);
                    }
                }
                Application.getSingleton().repaintScreen();
                break;
            }
            case 9: {
                if (Resources.pressedRightButton(x, y)) {
                    this.callAnimationToMode(2, false, true);
                    return;
                }
                Resources.iPickPointY = y;
                break;
            }
            case 5: {
                if (!Resources.pressedRightButton(x, y)) break;
                this.callAnimationToMode(2, false, true);
                return;
            }
            case 6: {
                if (Resources.pressedLeftButton(x, y)) {
                    Application.getSingleton().stop();
                    return;
                }
                if (!Resources.pressedRightButton(x, y)) break;
                this.callAnimationToMode(2, false, true);
                return;
            }
            case 7: {
                if (Resources.pressedRightButton(x, y)) {
                    this.callAnimationToMode(2, false, true);
                    return;
                }
                int iItemH = Resources.MENU_ITM_HEIGHT + Resources.MENU_ITM_SPC_H;
                if (y <= this.iItemPosY || y >= this.iItemPosY + iItemH * this.iItemsCount) break;
                this.iMenuSelector = (y - this.iItemPosY) / iItemH;
                this.executeAction();
                Application.getSingleton().repaintScreen();
                break;
            }
            case 10: {
                if (Resources.pressedRightButton(x, y)) {
                    this.callAnimationToMode(7, false, true);
                    break;
                }
                if (Resources.pressedLeftButton(x, y)) {
                    this.startFriendly();
                    break;
                }
                int iItemHH = Resources.MENU_ITM_HEIGHT + Resources.MENU_ITM_SPC_H;
                int iHlpY1 = this.iCreatingTeamPosY;
                if (y <= iHlpY1 || y >= iHlpY1 + Resources.MENU_ITM_HEIGHT * 4 + Resources.MENU_ITM_SPC_H * 3) break;
                int pointerY = (y - iHlpY1) / iItemHH;
                if (pointerY < 4) {
                    this.iCreatingMatchSel = pointerY;
                    if (pointerY != 1) {
                        Application.getSingleton().repaintScreen();
                    }
                }
                if (this.iOldSelectorPos == this.iCreatingMatchSel) {
                    if (x < Resources.WIDTH >> 1) {
                        if (this.iCreatingMatchSel == 0) {
                            this.scrollFlagLeftPlayer();
                        } else if (this.iCreatingMatchSel == 2) {
                            this.scrollFlagLeft();
                        } else if (this.iCreatingMatchSel == 3) {
                            this.setTimeDec();
                        }
                    } else if (this.iCreatingMatchSel == 0) {
                        this.scrollFlagRightPlayer();
                    } else if (this.iCreatingMatchSel == 2) {
                        this.scrollFlagRight();
                    } else if (this.iCreatingMatchSel == 3) {
                        this.setTimeInc();
                    }
                    if (pointerY == 1) break;
                    Application.getSingleton().repaintScreen();
                    break;
                }
                this.iOldSelectorPos = this.iCreatingMatchSel;
                break;
            }
            case 22: {
                if (Resources.pressedRightButton(x, y)) {
                    this.callAnimationToMode(21, false, true);
                    break;
                }
                if (!Resources.pressedLeftButton(x, y)) break;
                Globals.iEnemyTeamIdx = MyApplication.cup.getOponentTeamNation();
                this.startCup();
                break;
            }
            case 21: {
                if (Resources.pressedRightButton(x, y)) {
                    this.callAnimationToMode(7, false, true);
                    break;
                }
                if (Resources.pressedLeftButton(x, y)) {
                    this.createCupInfo();
                    break;
                }
                int iStartPosY = Resources.iTitlePosY + Resources.iTitleH + 5 + Texts.getFontHeight() * 2;
                int iEndPosY = iStartPosY + Resources.MENU_ITM_HEIGHT * 2 + 10;
                if (y < iStartPosY || y > iEndPosY || x < this.iItemPosX || x > this.iItemPosX + Resources.MENU_ITM_WIDTH) break;
                iCreatingCupSelectedItem = (y - iStartPosY) / (Resources.MENU_ITM_HEIGHT + 10);
                if (x < Resources.WIDTH >> 1) {
                    if (iCreatingCupSelectedItem == 0) {
                        this.setCupTimeDec();
                    }
                    if (iCreatingCupSelectedItem != 1) break;
                    this.changeDressLeft();
                    break;
                }
                if (iCreatingCupSelectedItem == 0) {
                    this.setCupTimeInc();
                }
                if (iCreatingCupSelectedItem != 1) break;
                this.changeDressRight();
                break;
            }
            case 4: {
                if (Resources.pressedRightButton(x, y)) {
                    this.callAnimationToMode(7, false, true);
                    return;
                }
                if (Resources.pressedLeftButton(x, y)) {
                    Globals.iMyTeamIdx = iDressCnt;
                    Globals.iMyTeamFlagSet = this.iFlagTile;
                    Globals.iMyTeamFlagIdx = this.iFlagFrame;
                    this.callAnimationToMode(7, false, true);
                    return;
                }
                if (x < Resources.WIDTH >> 1) {
                    this.changeDressLeft();
                } else {
                    this.changeDressRight();
                }
                return;
            }
            case 11: {
                int iItemH;
                int iPointerY;
                if (Resources.pressedRightButton(x, y)) {
                    this.callAnimationToMode(7, false, true);
                }
                if (y <= (iPointerY = Resources.HEIGHT - ((iItemH = Resources.MENU_ITM_HEIGHT + Resources.MENU_ITM_SPC_H) << 1) + Resources.MENU_ITM_SPC_H >> 1) || y >= iPointerY + (iItemH << 1)) break;
                this.iChoice = (y - iPointerY) / iItemH;
                this.executeErase(this.iChoice);
                Application.getSingleton().repaintScreen();
            }
        }
    }

    public void pointerReleased(int x, int y) {
        Keys.getSingleton().releaseKey(52);
        Keys.getSingleton().releaseKey(54);
    }

    public void startCup() {
        Globals.recalculateTimeCup();
        this.bCup = true;
        Globals.saveCup();
        this.startGame();
    }

    public void startFriendly() {
        Globals.recalculateTime();
        this.bCup = false;
        Globals.iEnemyTeamIdx = this.iEnemyCountry;
        this.startGame();
    }

    public void setTimeInc() {
        if ((Globals.iTimeSec += 30) >= 60) {
            Globals.iTimeSec = 0;
            if (++Globals.iTimeMin > 45) {
                Globals.iTimeMin = 45;
                Globals.iTimeSec = 0;
            }
        }
        if (Globals.iTimeMin == 45) {
            Globals.iTimeSec = 0;
        }
        this.prepareTime(false);
    }

    public void setTimeDec() {
        if ((Globals.iTimeSec -= 30) < 0) {
            Globals.iTimeSec = 30;
            if (--Globals.iTimeMin < 3) {
                Globals.iTimeMin = 3;
                Globals.iTimeSec = 0;
            }
        }
        this.prepareTime(false);
    }

    public void setCupTimeDec() {
        if ((Globals.iCupTimeSec -= 30) < 0) {
            Globals.iCupTimeSec = 30;
            if (--Globals.iCupTimeMin < 3) {
                Globals.iCupTimeMin = 3;
                Globals.iCupTimeSec = 0;
            }
        }
        this.prepareTime(true);
    }

    public void setCupTimeInc() {
        if ((Globals.iCupTimeSec += 30) >= 60) {
            Globals.iCupTimeSec = 0;
            if (++Globals.iCupTimeMin > 45) {
                Globals.iCupTimeMin = 45;
                Globals.iCupTimeSec = 0;
            }
        }
        if (Globals.iCupTimeMin == 45) {
            Globals.iCupTimeSec = 0;
        }
        this.prepareTime(true);
    }

    public void prepareTime(boolean bcup) {
        sb.setLength(0);
        if (bcup) {
            sb.append(Globals.iCupTimeMin).append(":");
            if (Globals.iCupTimeSec == 0) {
                sb.append("00");
            } else {
                sb.append(Globals.iCupTimeSec);
            }
        } else {
            sb.append(Globals.iTimeMin).append(":");
            if (Globals.iTimeSec == 0) {
                sb.append("00");
            } else {
                sb.append(Globals.iTimeSec);
            }
            this.optionsVar[2] = sb.toString();
        }
        sbTime.setLength(0);
        sbTime.append((Object)sb);
    }

    public void onPause() {
        Sounds.setVolume(0);
        Sounds.setMusicVol(0);
    }

    public void onResume() {
    }

    public void sizeChanged() {
    }

    static {
        sbTime = new StringBuffer();
        sb = new StringBuffer();
        iCreatingCupSelectedItem = 0;
        iFrame = 2;
        iSelectedTeam = 0;
        bStop = false;
        iDressCnt = 0;
    }
}

