/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic.spf;

import java.io.DataInputStream;
import java.io.InputStream;
import simple.video.Image;

class Packs {
    int[] crc_table;
    int dataptr;
    int crcfrom;
    int pngsize;
    byte[] data;
    byte[] PNG_header = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10, 0, 0, 0, 13, 73, 72, 68, 82, 0, 0, 0, 0, 0, 0, 0, 0, 8, 3, 0, 0, 0};
    byte[] PNG_End = new byte[]{0, 0, 0, 0, 73, 69, 78, 68, -82, 66, 96, -126};
    int iDiv;

    public Packs() {
        this.crc_table = new int[256];
        for (int n = 0; n < 256; ++n) {
            int c = n;
            int k = 8;
            while (--k >= 0) {
                if ((c & 1) != 0) {
                    c = 0xEDB88320 ^ c >>> 1;
                    continue;
                }
                c >>>= 1;
            }
            this.crc_table[n] = c;
        }
    }

    public final Image pngcreate(int width, int height, int palette, byte[] idata, byte[] pal, int trans, int flips, int imgStart, int palStart) {
        int i;
        if (flips > 3) {
            int t = width;
            width = height;
            height = t;
        }
        this.pngsize = palette * 3 + (width + 1) * height + 80;
        if (trans > -1) {
            this.pngsize += 13 + trans;
        }
        this.data = new byte[this.pngsize];
        for (i = 0; i < this.PNG_header.length; ++i) {
            this.data[i] = this.PNG_header[i];
        }
        this.data[19] = (byte)width;
        this.data[23] = (byte)height;
        this.dataptr = 29;
        this.writeInt(this.calc_crc(this.data, 12, 17));
        this.writeInt(palette * 3);
        this.crcfrom = this.dataptr;
        this.writeInt(1347179589L);
        for (i = 0; i < palette * 3; ++i) {
            this.data[this.dataptr++] = pal[i + palStart * 3];
        }
        this.writeInt(this.calc_crc(this.data, this.crcfrom, this.dataptr - this.crcfrom));
        if (trans > -1) {
            this.writeInt(trans + 1);
            this.crcfrom = this.dataptr;
            this.writeInt(1951551059L);
            for (i = 0; i < trans; ++i) {
                this.data[this.dataptr++] = -1;
            }
            this.data[this.dataptr++] = 0;
            this.writeInt(this.calc_crc(this.data, this.crcfrom, this.dataptr - this.crcfrom));
        }
        int compsize = (width + 1) * height;
        this.writeInt(compsize + 11);
        this.crcfrom = this.dataptr;
        this.writeInt(1229209940L);
        this.data[this.dataptr++] = 120;
        this.data[this.dataptr++] = -38;
        this.data[this.dataptr++] = 1;
        this.data[this.dataptr++] = (byte)(compsize & 0xFF);
        this.data[this.dataptr++] = (byte)(compsize >>> 8 & 0xFF);
        this.data[this.dataptr] = ~this.data[this.dataptr - 2];
        ++this.dataptr;
        this.data[this.dataptr] = ~this.data[this.dataptr - 2];
        ++this.dataptr;
        int adlerstart = this.dataptr;
        switch (flips) {
            case 0: {
                int x;
                int y;
                i = imgStart;
                for (y = height - 1; y >= 0; --y) {
                    this.data[this.dataptr++] = 0;
                    for (x = width - 1; x >= 0; --x) {
                        this.data[this.dataptr++] = idata[i++];
                    }
                }
                break;
            }
            case 1: {
                int x;
                int y;
                for (y = 0; y < height; ++y) {
                    i = (y + 1) * width - 1 + imgStart;
                    this.data[this.dataptr++] = 0;
                    for (x = 0; x < width; ++x) {
                        this.data[this.dataptr++] = idata[i--];
                    }
                }
                break;
            }
            case 2: {
                int x;
                int y;
                for (y = 0; y < height; ++y) {
                    i = (height - y - 1) * width + imgStart;
                    this.data[this.dataptr++] = 0;
                    for (x = 0; x < width; ++x) {
                        this.data[this.dataptr++] = idata[i++];
                    }
                }
                break;
            }
            case 3: {
                int x;
                int y;
                for (y = 0; y < height; ++y) {
                    i = (height - y) * width - 1 + imgStart;
                    this.data[this.dataptr++] = 0;
                    for (x = 0; x < width; ++x) {
                        this.data[this.dataptr++] = idata[i--];
                    }
                }
                break;
            }
            case 4: {
                int x;
                int y;
                int j = (width - 1) * height + imgStart;
                for (y = 0; y < height; ++y) {
                    i = j + y;
                    this.data[this.dataptr++] = 0;
                    for (x = 0; x < width; ++x) {
                        this.data[this.dataptr++] = idata[i];
                        i -= height;
                    }
                }
                break;
            }
            case 5: {
                int x;
                int y;
                int j = height + imgStart - 1;
                for (y = 0; y < height; ++y) {
                    i = j - y;
                    this.data[this.dataptr++] = 0;
                    for (x = 0; x < width; ++x) {
                        this.data[this.dataptr++] = idata[i];
                        i += height;
                    }
                }
                break;
            }
        }
        int adler1 = 1;
        int adler2 = 0;
        for (i = 0; i < compsize; ++i) {
            adler2 = (adler1 += this.data[adlerstart + i] & 0xFF) + adler2;
            adler1 %= 65521;
            adler2 %= 65521;
        }
        this.writeInt(adler2 << 16 | adler1);
        this.writeInt(this.calc_crc(this.data, this.crcfrom, this.dataptr - this.crcfrom));
        for (i = 0; i < this.PNG_End.length; ++i) {
            this.data[this.dataptr++] = this.PNG_End[i];
        }
        Image temp = new Image(this.data, 0, this.dataptr);
        return temp;
    }

    public final void writeInt(long crc) {
        this.data[this.dataptr++] = (byte)(crc >>> 24 & 0xFFL);
        this.data[this.dataptr++] = (byte)(crc >>> 16 & 0xFFL);
        this.data[this.dataptr++] = (byte)(crc >>> 8 & 0xFFL);
        this.data[this.dataptr++] = (byte)(crc & 0xFFL);
    }

    public final long calc_crc(byte[] buf, int off, int len) {
        int c = -1;
        while (--len >= 0) {
            c = this.crc_table[(c ^ buf[off++]) & 0xFF] ^ c >>> 8;
        }
        return (long)(~c) & 0xFFFFFFFFL;
    }

    public byte[] readFile(String binfile, int pos, int len) {
        byte[] buffer2;
        System.out.println("readFile(" + binfile + "," + pos + ") - in");
        try {
            InputStream is = this.getClass().getResourceAsStream("/" + binfile);
            is.skip(pos);
            if (len == 0) {
                len = (is.read() & 0xFF) << 24;
                len |= (is.read() & 0xFF) << 16;
                len |= (is.read() & 0xFF) << 8;
                len |= is.read() & 0xFF;
            }
            buffer2 = new byte[len];
            boolean offset = false;
            boolean bytes = false;
            is.read(buffer2, 0, buffer2.length);
            is.close();
            is = null;
            System.gc();
        }
        catch (Throwable e) {
            Object buffer2 = null;
            e.printStackTrace();
            System.gc();
            return null;
        }
        System.out.println("readFile - out");
        return buffer2;
    }

    public byte[] readPal(String binfile, int len) {
        byte[] buffer2;
        try {
            InputStream is = this.getClass().getResourceAsStream("/" + binfile);
            int dlzka = is.available();
            buffer2 = new byte[len];
            int offset = 0;
            int bytes = 0;
            this.iDiv = len / 3;
            while ((bytes = is.read(buffer2, offset, buffer2.length - offset)) != -1 && (offset += bytes) < buffer2.length) {
            }
            is.close();
            is = null;
            System.gc();
        }
        catch (Throwable e) {
            Object buffer2 = null;
            e.printStackTrace();
            System.gc();
            return null;
        }
        return buffer2;
    }

    public final Image[] loadTilesFromBin(String name, byte[] pallete) {
        Image[] result = null;
        try {
            DataInputStream is = new DataInputStream(this.getClass().getResourceAsStream(name));
            int count = is.readUnsignedByte();
            byte[] buffer = new byte[65535];
            int imgArraySize = count;
            result = new Image[imgArraySize];
            for (int i = 0; i < count; ++i) {
                char width = (char)is.readUnsignedByte();
                char height = (char)is.readUnsignedByte();
                int len = width * height;
                is.read(buffer, 0, len);
                Image img1 = null;
                try {
                    img1 = this.pngcreate(width, height, this.iDiv, buffer, pallete, 0, 0, 0, 0);
                }
                catch (Throwable e) {
                    System.out.println(e.toString());
                }
                result[i] = img1;
            }
            this.data = null;
            buffer = null;
            System.gc();
            is.close();
        }
        catch (Throwable e) {
            System.out.println(e.toString());
            return null;
        }
        return result;
    }
}

