/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic.spf;

import simple.core.Application;
import simple.debug.DebugOutput;
import simple.events.Event;
import simple.input.Key;
import simple.input.Keys;
import simple.input.Pointer;
import simple.input.Pointers;
import simple.video.Graphics;
import simple.video.Image;
import simple.video.Screen;
import sk.inlogic.spf.Cup;
import sk.inlogic.spf.IScreen;
import sk.inlogic.spf.Packs;
import sk.inlogic.spf.ResTexts;
import sk.inlogic.spf.Resources;
import sk.inlogic.spf.ScreenGame;
import sk.inlogic.spf.ScreenMenu;
import sk.inlogic.spf.ScreenSplash;
import sk.inlogic.spf.ScreenTutorial;
import sk.inlogic.spf.Texts;

public class MyApplication
extends Application {
    static MyApplication pInstance;
    public static IScreen pActiveScreen;
    public static ScreenSplash pScrSplash;
    public static ScreenMenu pScrMenu;
    public static ScreenGame pScrGame;
    public static ScreenTutorial pScrTutorial;
    public static boolean bTouchScreen;
    public static boolean bLoading;
    static Packs pPackageManager;
    public static byte[] pal;
    public static ResTexts resTxt;
    public static Cup cup;
    public static boolean bMusicIsResumed;
    public static boolean bChangeSize;
    String strLoading;
    int iLoadingX;
    int iLoadingY;

    static final boolean isMusicPlaying() {
        return bMusicIsResumed;
    }

    static final void setMusicIsResumed(boolean b) {
        bMusicIsResumed = b;
    }

    static final Image loadPalImage(String strPal, String strImg) {
        Image pTmpImg = null;
        pal = pPackageManager.readPal(strPal, 33);
        Image[] binImgs = pPackageManager.loadTilesFromBin(strImg, pal);
        if (binImgs != null) {
            pTmpImg = binImgs[0];
        }
        return pTmpImg;
    }

    public MyApplication() {
        DebugOutput.setDebugLevel(100);
        pPackageManager = new Packs();
        resTxt = new ResTexts();
        pInstance = this;
    }

    public static MyApplication getInstance() {
        return pInstance;
    }

    public void update() {
        if (pActiveScreen == null) {
            pScrSplash = new ScreenSplash();
            pActiveScreen = pScrSplash;
        }
        if (pActiveScreen != null) {
            pActiveScreen.update(50L);
        }
    }

    public void onEventFired(Event event) {
        if (event.getMethodName().startsWith("sizeChanged")) {
            if (pActiveScreen != null) {
                MyApplication.sizeChanged();
            }
            return;
        }
        if (Pointers.isEventSender(event)) {
            Pointer pointer = (Pointer)event.getData();
            switch (pointer.iAction) {
                case 2: {
                    this.pointerPressed(pointer.iPositionX, pointer.iPositionY);
                    break;
                }
                case 3: {
                    this.pointerReleased(pointer.iPositionX, pointer.iPositionY);
                    break;
                }
                case 4: {
                    this.pointerDragged(pointer.iPositionX, pointer.iPositionY);
                }
            }
        }
        if (Keys.isEventSender(event)) {
            Key pKey = (Key)event.getData();
            switch (pKey.iAction) {
                case 1: {
                    this.keyPressed(pKey);
                    break;
                }
                case 2: {
                    this.keyReleased(pKey);
                }
            }
        }
    }

    public static void sizeChanged() {
        bChangeSize = !bChangeSize;
        Resources.loadRotationIcon();
        pActiveScreen.onResume();
    }

    private void pointerPressed(int iX, int iY) {
        bTouchScreen = true;
        if (pActiveScreen != null) {
            pActiveScreen.pointerPressed(iX, iY);
        }
    }

    private void pointerReleased(int iX, int iY) {
        if (pActiveScreen != null) {
            pActiveScreen.pointerReleased(iX, iY);
        }
    }

    private void pointerDragged(int iX, int iY) {
        if (pActiveScreen != null) {
            pActiveScreen.pointerDragged(iX, iY);
        }
    }

    private void keyPressed(Key pKey) {
        if (pActiveScreen != null) {
            pActiveScreen.keyPressed(pKey);
        }
    }

    private void keyReleased(Key pKey) {
        if (pActiveScreen != null) {
            pActiveScreen.keyReleased(pKey);
        }
    }

    public void callLoading() {
        bLoading = true;
        this.strLoading = "";
        this.strLoading = resTxt.getString("LOADING");
        this.iLoadingX = Resources.WIDTH - Texts.getTextWidth(this.strLoading) >> 1;
        this.iLoadingY = Resources.HEIGHT - Texts.getFontHeight() >> 1;
        this.repaintScreen();
    }

    public void stopLoading() {
        bLoading = false;
    }

    private void paintLoading(Graphics g) {
        Resources.drawBackground(g);
        Resources.paintIngaemWindow(g, 10, 10);
        Texts.drawTextAtPos(g, this.iLoadingX, this.iLoadingY, this.strLoading);
    }

    public void paintScreen(Screen pScreen) {
        Graphics g = pScreen.getGraphics();
        if (bChangeSize) {
            g.setColor(0);
            g.fillRect(0, 0, g.getWidth(), g.getHeight());
            if (Resources.pImgRot != null) {
                Resources.pImgRot.drawAtPoint(g, g.getWidth() - Resources.iRotW >> 1, g.getHeight() - Resources.iRotH >> 1);
            }
            return;
        }
        if (bLoading) {
            this.paintLoading(g);
            return;
        }
        if (pActiveScreen != null) {
            pActiveScreen.paintScreen(g);
        }
    }

    public void pause() {
        if (pActiveScreen != null) {
            pActiveScreen.onPause();
        }
        MyApplication.setMusicIsResumed(false);
    }

    public void resume() {
        if (pActiveScreen != null) {
            pActiveScreen.onResume();
        }
    }

    public void onPause() {
        if (pActiveScreen != null) {
            pActiveScreen.onPause();
        }
        MyApplication.setMusicIsResumed(false);
    }

    public void onResume() {
        if (pActiveScreen != null) {
            pActiveScreen.onResume();
        }
    }

    static {
        pActiveScreen = null;
        pScrSplash = null;
        pScrMenu = null;
        pScrGame = null;
        pScrTutorial = null;
        bTouchScreen = false;
        bLoading = false;
        cup = new Cup();
        bMusicIsResumed = true;
        bChangeSize = false;
    }
}

