/*
 * Decompiled with CFR 0.152.
 */
package simple.core;

import java.util.Hashtable;
import simple.audio.AudioSystem;
import simple.core.Application;
import simple.core.DeviceProperty;
import simple.events.Event;
import simple.input.Keys;
import simple.input.Pointers;
import simple.output.FileSystem;
import simple.video.Screen;

public class Device {
    private static Device singleton = null;
    private Application application = null;
    private static Hashtable mapDeviceProperties = new Hashtable();
    private Keys pKeys = null;
    private Pointers pPointers = null;
    private AudioSystem pAudioSystem = null;
    private FileSystem pFileSystem = null;
    private Screen pScreen = null;

    public Device(Application application) {
        this.application = application;
        this.pKeys = new Keys(this);
        this.pPointers = new Pointers(this);
        this.pFileSystem = new FileSystem(this);
        this.pAudioSystem = new AudioSystem(this);
        this.pScreen = new Screen(this);
        singleton = this;
    }

    protected void finalize() throws Throwable {
        this.pKeys = null;
        this.pPointers = null;
        this.pFileSystem = null;
        this.pScreen = null;
        this.pAudioSystem = null;
        System.gc();
    }

    public static Device getSingleton() {
        return singleton;
    }

    void update() {
        this.pKeys.update();
        this.pPointers.update();
    }

    void stopApplication() {
        this.application.stop();
    }

    public static void setPropertyAsString(String strPropertyName, String strPropertyValue) {
        DeviceProperty property = null;
        if (mapDeviceProperties.containsKey(strPropertyName)) {
            property = (DeviceProperty)mapDeviceProperties.get(strPropertyName);
        } else {
            property = new DeviceProperty();
            mapDeviceProperties.put(strPropertyName, property);
        }
        property.strValue = strPropertyValue;
    }

    public static String getPropertyAsString(String strPropertyName) {
        if (mapDeviceProperties.containsKey(strPropertyName)) {
            return ((DeviceProperty)Device.mapDeviceProperties.get((Object)strPropertyName)).strValue;
        }
        return null;
    }

    public static void setPropertyAsLong(String strPropertyName, long lPropertyValue) {
        DeviceProperty property = null;
        if (mapDeviceProperties.containsKey(strPropertyName)) {
            property = (DeviceProperty)mapDeviceProperties.get(strPropertyName);
        } else {
            property = new DeviceProperty();
            mapDeviceProperties.put(strPropertyName, property);
        }
        property.lValue = lPropertyValue;
    }

    public static long getPropertyAsLong(String strPropertyName) {
        if (mapDeviceProperties.containsKey(strPropertyName)) {
            return ((DeviceProperty)Device.mapDeviceProperties.get((Object)strPropertyName)).lValue;
        }
        return 0L;
    }

    public static void setPropertyAsData(String strPropertyName, Object pPropertyValue) {
        DeviceProperty property = null;
        if (mapDeviceProperties.containsKey(strPropertyName)) {
            property = (DeviceProperty)mapDeviceProperties.get(strPropertyName);
        } else {
            property = new DeviceProperty();
            mapDeviceProperties.put(strPropertyName, property);
        }
        property.pData = pPropertyValue;
    }

    public static Object getPropertyAsData(String strPropertyName) {
        if (mapDeviceProperties.containsKey(strPropertyName)) {
            return ((DeviceProperty)Device.mapDeviceProperties.get((Object)strPropertyName)).pData;
        }
        return null;
    }

    public Screen getScreen() {
        return this.pScreen;
    }

    public Keys getKeys() {
        return this.pKeys;
    }

    public Pointers getPointers() {
        return this.pPointers;
    }

    public AudioSystem getAudioSystem() {
        return this.pAudioSystem;
    }

    public FileSystem getFileSystem() {
        return this.pFileSystem;
    }

    public void fireEvent(Event event) {
        this.application.onEventFired(event);
    }

    public long getTicks() {
        return System.currentTimeMillis();
    }

    public void sleep(long lMilliseconds) {
        try {
            Thread.sleep(lMilliseconds);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}

