/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic.spf;

import java.util.Vector;
import simple.debug.DebugOutput;
import simple.video.BitmapFont;
import simple.video.Graphics;
import simple.video.Image;
import sk.inlogic.spf.FontDef;
import sk.inlogic.spf.Resources;

public class Texts {
    public static int iLanguage = 0;
    public static final int LANG_ENGLISH = 0;
    public static final int LANG_FRANCAIS = 1;
    public static final int LANG_DEUTSCH = 2;
    public static final int LANG_ITALIANO = 3;
    public static final int LANG_ESPANOL = 4;
    public static final int LANG_PORTUGUES = 5;
    public static final int ID_LOADING = 0;
    public static final int ID_SELECT = 1;
    public static final int ID_YES = 2;
    public static final int ID_NO = 3;
    public static final int ID_ON = 4;
    public static final int ID_OFF = 5;
    public static final int ID_ENABLE_SOUNDS = 6;
    public static final int ID_PLAY = 7;
    public static final int ID_FREETRIAL = 8;
    public static final int ID_GETTHEGAME = 9;
    public static final int ID_MOREGAMES = 10;
    public static final int ID_INSTRUCTIONS = 11;
    public static final int ID_TOPSCORE = 12;
    public static final int ID_OPTIONS = 13;
    public static final int ID_QUIT = 14;
    public static final int ID_BACK = 15;
    public static final int ID_MUSIC = 16;
    public static final int ID_VIBRATIONS = 17;
    public static final int ID_CONFIRMATION = 18;
    public static final int ID_RESUME = 19;
    public static final int ID_RESTART = 20;
    public static final int ID_RETRY = 21;
    public static final int ID_MENU = 22;
    public static final int ID_CONTINUE = 23;
    public static BitmapFont pBitmapFont = null;

    public static final int getTextWidth(String sText) {
        return pBitmapFont.getTextWidth(sText);
    }

    public static final int getCharsWidth(char[] acText, int iOffset, int iLength) {
        return pBitmapFont.getCharsWidth(acText, iOffset, iLength);
    }

    public static final int getFontHeight() {
        return pBitmapFont.getHeight();
    }

    public static void drawTextAtPos(Graphics pGraphics, int iPosX, int iPosY, String sText) {
        pBitmapFont.drawTextAtPos(pGraphics, iPosX, iPosY, sText);
    }

    public static final Vector separateText(String strText, int iWidth) {
        char[] acText = strText.toCharArray();
        Vector<String> vecResult = new Vector<String>();
        int iLen = acText.length;
        int iStartIndex = 0;
        int iLastOkIndex = 0;
        for (int i = 0; i < iLen; ++i) {
            if (acText[i] != ' ' && acText[i] != '\n') continue;
            if (Texts.getCharsWidth(acText, iStartIndex, i - iStartIndex) < iWidth) {
                if (acText[i] == '\n') {
                    vecResult.addElement(new String(acText, iStartIndex, i - iStartIndex));
                    iLastOkIndex = iStartIndex = i + 1;
                    continue;
                }
                iLastOkIndex = i;
                continue;
            }
            if (iLastOkIndex != 0) {
                vecResult.addElement(new String(acText, iStartIndex, iLastOkIndex - iStartIndex));
                if (acText[i] == '\n') {
                    --i;
                }
                iStartIndex = iLastOkIndex;
                iLastOkIndex = i + 1;
                continue;
            }
            vecResult.addElement(new String(acText, iStartIndex, i - iStartIndex));
            iLastOkIndex = iStartIndex = i + 1;
        }
        if (iStartIndex < iLen) {
            if (Texts.getCharsWidth(acText, iStartIndex, acText.length - iStartIndex) < iWidth) {
                vecResult.addElement(new String(acText, iStartIndex, iLen - iStartIndex));
            } else {
                vecResult.addElement(new String(acText, iStartIndex, iLastOkIndex - iStartIndex));
                vecResult.addElement(new String(acText, iLastOkIndex + 1, acText.length - iLastOkIndex - 1));
            }
        }
        acText = null;
        System.gc();
        return vecResult;
    }

    public static Image createHintImage(String strHint) {
        DebugOutput.traceIn(100, "Resources", "createHintImage()");
        int iW = Resources.iScreenW - Resources.iScreenW / 10;
        Vector vecHintLines = Texts.separateText(strHint, iW);
        int iH = vecHintLines.size() * Texts.getFontHeight();
        Image pTmpImage = new Image(iW, iH);
        Graphics pGraphics = pTmpImage.getGraphics();
        pGraphics.setColor(0x88DDFF);
        pGraphics.fillRect(0, 0, iW, iH);
        int iMaxW = 0;
        int iMaxH = 0;
        for (int i = 0; i < vecHintLines.size(); ++i) {
            String strLine = (String)vecHintLines.elementAt(i);
            int iCurrW = Texts.getTextWidth(strLine);
            if (iCurrW > iMaxW) {
                iMaxW = iCurrW;
            }
            Texts.drawTextAtPos(pGraphics, (iW - iCurrW) / 2, iMaxH, strLine);
            iMaxH += Texts.getFontHeight();
        }
        int iTranspColor = pTmpImage.getPixelColor(0, 0);
        for (int y = 0; y < iH; ++y) {
            for (int x = 0; x < iW; ++x) {
                int pixel = pTmpImage.getPixelColor(x, y);
                int r = (pixel & 0xFF0000) >> 16;
                int g = (pixel & 0xFF00) >> 8;
                int b = (pixel & 0xFF) >> 0;
                boolean bTransparent = pixel == iTranspColor;
                int iOpacity = bTransparent ? 0 : 255;
                pTmpImage.setPixelColor(x, y, (iOpacity << 24) + (r << 16) + (g << 8) + b);
            }
        }
        DebugOutput.traceOut(100, "Resources", "createHintImage()");
        return pTmpImage;
    }

    static {
        pBitmapFont = new BitmapFont(new Image("/fnt.png"), FontDef.caFontChar, FontDef.iaFontCharWidth, FontDef.iCharGap);
    }
}

