/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic.spf;

import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerListener;
import javax.microedition.media.control.VolumeControl;
import simple.debug.DebugOutput;
import sk.inlogic.spf.Globals;

public class Sounds
implements PlayerListener {
    private static Sounds pSounds = null;
    private static Player pPlayer = null;
    private static int iMusicLoop;
    private static int iGlobalVolume;

    private static void playMusic(String strResName, int iLoopCnt, long lPosition) {
        if (!Globals.bMusic) {
            return;
        }
        Sounds.stopMusic();
        try {
            pPlayer = Manager.createPlayer((InputStream)pSounds.getClass().getResourceAsStream(strResName), (String)"audio/midi");
            pPlayer.realize();
            pPlayer.prefetch();
            Sounds.setMusicVol(iGlobalVolume);
            iMusicLoop = iLoopCnt;
            pPlayer.start();
        }
        catch (Throwable t) {
            // empty catch block
        }
    }

    public static void setVolume(int iVol) {
        if (iVol > 100) {
            iVol = 100;
        }
        iGlobalVolume = iVol;
    }

    public static void playMenuMusic() {
        Sounds.playMusic("/menu.mid", -1, 0L);
    }

    public static void playGameMusic(long lPosition) {
        Sounds.playMusic("/game.mid", -1, lPosition);
    }

    public static void pauseSound() {
    }

    public static void setMusicVol(int vol) {
        if (pPlayer != null) {
            ((VolumeControl)pPlayer.getControl("VolumeControl")).setLevel(vol);
        }
    }

    public static boolean musicPlaying() {
        if (pPlayer == null) {
            return false;
        }
        return (pPlayer.getState() & 0x190) == 400;
    }

    static final void stopMusic() {
        DebugOutput.traceIn(100, "SIMPLE", "stopMusic()");
        try {
            if (pPlayer != null) {
                pPlayer.stop();
                pPlayer.close();
                pPlayer.deallocate();
                pPlayer = null;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        DebugOutput.traceOut(100, "SIMPLE", "stopMusic()");
    }

    public void playerUpdate(Player pPlayer, String event, Object eventData) {
        DebugOutput.traceIn(100, "SIMPLE", "playerUpdate()");
        if (pPlayer == Sounds.pPlayer) {
            if (event.compareTo("endOfMedia") == 0) {
                DebugOutput.trace(100, "SIMPLE", "PlayerListener.END_OF_MEDIA");
                if (iMusicLoop == -1) {
                    try {
                        System.out.println("pustam hudbu znova: " + iGlobalVolume);
                        pPlayer.setMediaTime(0L);
                        Sounds.setMusicVol(iGlobalVolume);
                        pPlayer.start();
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    return;
                }
                pPlayer.close();
            } else if (event.compareTo("stopped") == 0) {
                DebugOutput.trace(100, "SIMPLE", "PlayerListener.STOPPED");
                pPlayer.close();
            } else if (event.compareTo("closed") == 0) {
                DebugOutput.trace(100, "SIMPLE", "PlayerListener.CLOSED");
                Sounds.pPlayer.deallocate();
                Sounds.pPlayer = null;
            }
        }
        DebugOutput.traceOut(100, "SIMPLE", "playerUpdate()");
    }

    public static void vibrate(int delay) {
    }

    static {
        iGlobalVolume = 100;
        pSounds = new Sounds();
    }
}

