/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic.spf;

import simple.input.Key;
import simple.input.Keys;
import simple.video.Graphics;
import sk.inlogic.spf.Ball;
import sk.inlogic.spf.FootbalPlayer;
import sk.inlogic.spf.FootbalTeam;
import sk.inlogic.spf.Globals;
import sk.inlogic.spf.Goal;
import sk.inlogic.spf.IScreen;
import sk.inlogic.spf.MyApplication;
import sk.inlogic.spf.Pitch;
import sk.inlogic.spf.Resources;
import sk.inlogic.spf.ScreenMenu;
import sk.inlogic.spf.Sounds;
import sk.inlogic.spf.Texts;

public class ScreenTutorial
implements IScreen {
    MyApplication pMyApplication;
    final int MODE_VOID;
    final int MODE_LOADINGRES;
    final int MODE_TUTORIAL;
    final int MODE_INSTRUCTION;
    final int TUTORIAL_MOVEMENT;
    final int TUTORIAL_CATCHING;
    final int TUTORIAL_KICKING;
    final int TUTORIAL_SCORING;
    final int TUTORIAL_TACKLING;
    final int TUTORIAL_TACKLING2;
    final int TUTORIAL_PASSING;
    final int TUTORIAL_SWITCHING;
    int iTutorialType;
    int iTutorialPhase = 0;
    int iMode = 1;
    static FootbalPlayer activePlayer;
    static FootbalPlayer passingPlayer;
    static FootbalPlayer fbPl;
    static FootbalPlayer fbPl2;
    static FootbalPlayer fbP3;
    static FootbalPlayer fbP4;
    static Ball ball;
    FootbalTeam fbT1;
    FootbalTeam fbT2;
    Goal goalUp;
    private int iSectorW = Resources.TUTORIAL_SECTOR_H;
    private int iSectorPosY = 0;
    private int iBlick = 0;
    private int iCircleW = 20;
    private int iCircleW2 = this.iCircleW / 2;
    static boolean bHasBeenReleased;
    int[] iInitAngle = new int[]{-30, 0, 30};
    int[] iTriangleX = new int[3];
    int[] iTriangleY = new int[3];
    int iDirrectionAngle = 0;
    int iR = 10;
    int iStredX = Resources.WIDTH >> 1;
    int iStredY = Resources.HEIGHT >> 1;
    static int GOAL_W;
    private static boolean[] bCross;
    private static int[] crossPosX;
    private static int[] crossPosY;
    private int iControlerSprite1 = 0;
    private int iControlerSprite2 = 2;
    private int iScrollingArrowX;
    private int iScrollingArrowY1;
    private int iScrollingArrowY2;
    private String strHeader;
    private int iHeaderPosX;
    String strHead;
    int iArrowX;
    int iHeaderPosY;
    static final int POS_SQR = 10;
    public static int iQuadIdx;
    int iSqPosX;
    int iSqPosY;
    int iFontPosX;
    int iFontPosY;
    int iQuadX;
    int iQuadY;
    int iCrossFrame = 0;
    int iBallPosX;
    int iBallPosY;
    int iDiffX;

    public ScreenTutorial(int type) {
        this.MODE_VOID = 0;
        this.MODE_LOADINGRES = 1;
        this.MODE_TUTORIAL = 2;
        this.MODE_INSTRUCTION = 3;
        this.TUTORIAL_MOVEMENT = 0;
        this.TUTORIAL_CATCHING = 1;
        this.TUTORIAL_KICKING = 2;
        this.TUTORIAL_SCORING = 3;
        this.TUTORIAL_TACKLING = 4;
        this.TUTORIAL_TACKLING2 = 5;
        this.TUTORIAL_PASSING = 6;
        this.TUTORIAL_SWITCHING = 7;
        this.pMyApplication = MyApplication.getInstance();
        bHasBeenReleased = false;
    }

    public void paintStatus(Graphics g) {
        g.setClipRegion(0, 0, Resources.WIDTH, Resources.STATUS_BAR_H);
        g.setColor(197123);
        g.fillRect(0, 0, Resources.WIDTH, Resources.STATUS_BAR_H);
        g.setColor(16448769);
        g.fillRect(0, 0, Resources.WIDTH, Resources.STATUS_BAR_H - 1);
        int iPosY = Resources.STATUS_BAR_H - Texts.getFontHeight() >> 1;
        Texts.drawTextAtPos(g, this.iHeaderPosX, iPosY, this.strHeader);
    }

    public void update(long lTick) {
        if (this.iMode == 1) {
            Resources.loadTutorial();
            this.fbT1 = new FootbalTeam(0, 4, null, Globals.iFormation);
            this.fbT2 = new FootbalTeam(1, 2, null, Globals.iFormation);
            ball = new Ball(Resources.WIDTH >> 1, 90, null);
            fbPl = new FootbalPlayer(0, 2, 2, this.fbT1);
            fbPl2 = new FootbalPlayer(1, 4, 2, this.fbT2);
            fbP3 = new FootbalPlayer(1, 2, 2, this.fbT1);
            fbP4 = new FootbalPlayer(2, 2, 2, this.fbT1);
            this.goalUp = new Goal(0, 0, true);
            this.goalUp.setIsTutorial();
            this.prepareTutorialText();
            this.iMode = 3;
            this.pMyApplication.repaintScreen();
        } else if (this.iMode == 2) {
            fbPl.update();
            fbPl2.update();
            if (this.iTutorialType == 0) {
                this.updateMovement();
            } else if (this.iTutorialType == 1) {
                this.updateCatching();
            } else if (this.iTutorialType == 2) {
                this.updateKicking();
            } else if (this.iTutorialType == 4) {
                this.updateTackling();
            } else if (this.iTutorialType == 3) {
                this.updateScoring();
            } else if (this.iTutorialType == 5) {
                this.updateTackling2();
            } else if (this.iTutorialType == 6) {
                this.updatePassing();
            } else if (this.iTutorialType == 7) {
                this.updateSwitching();
            }
            this.iControlerSprite1 = 0;
            this.iControlerSprite2 = 2;
            if (activePlayer.hasBall()) {
                this.iControlerSprite1 = 3;
                this.iControlerSprite2 = 1;
            }
            this.pMyApplication.repaintScreen();
        }
    }

    public void updateMovement() {
        this.updateQuad();
    }

    public void updateCatching() {
        ball.update();
        if (ball.hasOwner()) {
            this.updateQuad();
        }
    }

    public void updateKicking() {
        ball.update();
        if (ball.getCurrentSpeed() == 0 && !ball.hasOwner() && ball.getBallZ() == 0) {
            this.updateSectors();
            ball.addBallToPlayer(fbPl);
        }
    }

    public void updateTackling() {
        ball.update();
        this.tackle();
        if (++this.iBlick > 10) {
            this.iBlick = 0;
        }
        if (++this.iCrossFrame > 9) {
            this.iCrossFrame = 0;
        }
        if (fbPl.hasBall() && fbPl.getPosY() > Resources.HEIGHT - Resources.iCrossH * 2) {
            this.prepareTutorialText();
            this.iMode = 3;
        }
    }

    public void updateTackling2() {
        if (++this.iBlick > 10) {
            this.iBlick = 0;
        }
        if (++this.iCrossFrame > 9) {
            this.iCrossFrame = 0;
        }
        ball.update();
        this.tackle();
        if (!fbPl.hasBall()) {
            return;
        }
        if (fbPl.getPosY() < Resources.HEIGHT - Resources.iCrossH * 2) {
            return;
        }
        this.prepareTutorialText();
        this.iMode = 3;
    }

    public void updateScoring() {
        if (++this.iCrossFrame > 9) {
            this.iCrossFrame = 0;
        }
        ball.update();
        this.updateScoreCross();
        if (ball.getCurrentSpeed() == 0 && !ball.hasOwner() && ball.getBallZ() == 0) {
            ball.addBallToPlayer(fbPl);
        }
        if (this.goalUp.isInGoalTutorial(ball.getBallX(), ball.getBallY(), ball.getBallZ()) && ball.getCurrentSpeed() == 0) {
            this.updateScoreCross();
        }
        for (int i = 0; i < 3; ++i) {
            if (!bCross[i]) continue;
            return;
        }
        this.prepareTutorialText();
        this.iMode = 3;
    }

    public void updatePassing() {
        if (ball.getCurrentSpeed() == 0 && !ball.hasOwner() && ball.getBallZ() == 0) {
            ball.addBallToPlayer(activePlayer);
        }
        if (activePlayer != fbP3) {
            ball.catchBallTutorial(fbP3);
        }
        if (activePlayer != fbP4) {
            ball.catchBallTutorial(fbP4);
        }
        passingPlayer = null;
        if (activePlayer.hasBall()) {
            if (activePlayer.isPlayerForPass(fbP3)) {
                passingPlayer = fbP3;
            }
            if (activePlayer.isPlayerForPass(fbP4)) {
                passingPlayer = fbP4;
            }
            if (activePlayer.isPlayerForPass(fbPl)) {
                passingPlayer = fbPl;
            }
        }
        ball.update();
        fbP3.update();
        fbP4.update();
        if (ball.hasOwner() && ball.getOwner() != fbPl) {
            this.iTutorialPhase = 7;
            this.iMode = 3;
            this.prepareTutorialText();
        }
    }

    public void updateSwitching() {
        if (ball.getCurrentSpeed() == 0 && !ball.hasOwner() && ball.getBallZ() == 0) {
            ball.addBallToPlayer(activePlayer);
        }
        if (activePlayer != fbP3) {
            ball.catchBallTutorial(fbP3);
        }
        if (activePlayer != fbP4) {
            ball.catchBallTutorial(fbP4);
        }
        passingPlayer = null;
        if (activePlayer.hasBall()) {
            if (activePlayer.isPlayerForPass(fbP3)) {
                passingPlayer = fbP3;
            }
            if (activePlayer.isPlayerForPass(fbP4)) {
                passingPlayer = fbP4;
            }
            if (activePlayer.isPlayerForPass(fbPl)) {
                passingPlayer = fbPl;
            }
        }
        ball.update();
        fbP3.update();
        fbP4.update();
        if (ball.hasOwner() && ball.getOwner() == fbPl) {
            this.iTutorialPhase = 8;
            this.iMode = 3;
            this.prepareTutorialText();
        }
    }

    public void paintScreen(Graphics g) {
        if (this.iMode == 3) {
            this.paintGround(g);
            Resources.paintIngaemWindow(g, 11, 12);
            Resources.paintLeftButton(g, 2);
            Resources.paintRightButton(g, 4);
            if (this.iTutorialPhase == 8) {
                Resources.drawMultilineText(g, 0, Resources.getCenterPosY());
                return;
            }
            if (this.iTutorialPhase < 7) {
                this.iArrowX = Resources.WIDTH >> 1;
                Resources.pSprMenuArrSmall.setFrame(0);
                Resources.pSprMenuArrSmall.setPosition(this.iArrowX - 10 - Resources.iMenuArrSmallW, this.iHeaderPosY);
                Resources.pSprMenuArrSmall.paint(g);
                Resources.pSprMenuArrSmall.setFrame(1);
                Resources.pSprMenuArrSmall.setPosition(this.iArrowX + 10, this.iHeaderPosY);
                Resources.pSprMenuArrSmall.paint(g);
                this.strHead = this.iTutorialPhase + 1 + "";
                int iTxtPosX = Texts.getTextWidth(this.strHead) >> 1;
                int iTxtPosY = Resources.iMenuArrSmallH - Texts.getFontHeight() >> 1;
                Texts.drawTextAtPos(g, this.iArrowX - iTxtPosX, this.iHeaderPosY + iTxtPosY, this.strHead);
            }
            if (Resources.getCenterPosY() > this.iHeaderPosY) {
                Resources.drawMultilineText(g, 0, Resources.getCenterPosY());
            } else {
                Resources.drawMultilineText(g, 0, this.iHeaderPosY + Texts.getFontHeight());
            }
            if (Resources.bArrUp()) {
                Resources.pSprMenuArrSmall.setFrame(2);
                Resources.pSprMenuArrSmall.setPosition(this.iScrollingArrowX, this.iScrollingArrowY1);
                Resources.pSprMenuArrSmall.paint(g);
            }
            if (Resources.bArrDown()) {
                Resources.pSprMenuArrSmall.setFrame(3);
                Resources.pSprMenuArrSmall.setPosition(this.iScrollingArrowX, this.iScrollingArrowY2);
                Resources.pSprMenuArrSmall.paint(g);
            }
        }
        if (this.iMode == 2) {
            this.paintGround(g);
            this.paintTutorial(g);
            Resources.paintControlers(g, this.iControlerSprite1, this.iControlerSprite2);
            this.paintStatus(g);
            Resources.paintRightButton(g, 4);
        }
    }

    public void paintPauseButton(Graphics g) {
        g.setClipRegion(0, 0, Resources.WIDTH, Resources.HEIGHT);
        Resources.pImgPause.drawAtPoint(g, Resources.WIDTH - Resources.iPauseW - 5, Resources.HEIGHT - Resources.iPauseH - 5);
    }

    public void paintSelectorForPass(Graphics g) {
        if (passingPlayer == null) {
            return;
        }
        Pitch.paintSelector(passingPlayer, 0, 0, 1, g);
    }

    private void paintGround(Graphics g) {
        g.setClipRegion(0, 0, Resources.WIDTH, Resources.HEIGHT);
        g.setColor(13885538);
        g.fillRect(0, 0, Resources.WIDTH, Resources.HEIGHT);
        for (int i = 0; i < 5; ++i) {
            Resources.pImgGrass.drawAtPoint(g, 0, 0 + i * Resources.iGrassH);
        }
    }

    private void updateScoreCross() {
        this.iBallPosX = ball.getBallX();
        this.iBallPosY = ball.getBallY();
        for (int i = 0; i < 3; ++i) {
            if (this.iBallPosX <= crossPosX[i] || this.iBallPosX >= crossPosX[i] + Resources.iCrossW || this.iBallPosY <= crossPosY[i] || this.iBallPosY >= crossPosY[i] + Resources.iCrossH) continue;
            ScreenTutorial.bCross[i] = false;
        }
    }

    private void updateQuad() {
        if (++this.iCrossFrame > 9) {
            this.iCrossFrame = 0;
        }
        if (iQuadIdx == 0) {
            int iDiffX = Math.abs(this.iSqPosX + (Resources.pSprPlayerH >> 1) - fbPl.getPosX());
            int iDiffY = Math.abs(10 + (Resources.pSprPlayerH >> 1) - fbPl.getPosY());
            if (iDiffX < Resources.pSprPlayerH >> 1 && iDiffY < Resources.pSprPlayerH >> 1) {
                ++iQuadIdx;
            }
        } else if (iQuadIdx == 1) {
            int iDiffX = Math.abs(10 + (Resources.pSprPlayerH >> 1) - fbPl.getPosX());
            int iDiffY = Math.abs(this.iSqPosY + (Resources.pSprPlayerH >> 1) - fbPl.getPosY());
            if (iDiffX < Resources.pSprPlayerH >> 1 && iDiffY < Resources.pSprPlayerH >> 1) {
                ++iQuadIdx;
            }
        } else if (iQuadIdx == 2) {
            int iDiffX = Math.abs(Resources.WIDTH - (Resources.pSprPlayerH >> 1) - 10 - fbPl.getPosX());
            int iDiffY = Math.abs(this.iSqPosY + (Resources.pSprPlayerH >> 1) - fbPl.getPosY());
            if (iDiffX < Resources.pSprPlayerH >> 1 && iDiffY < Resources.pSprPlayerH >> 1) {
                this.prepareTutorialText();
                this.iMode = 3;
            }
        }
    }

    private void paintQuads(Graphics g) {
        if (iQuadIdx == 0) {
            this.iQuadX = this.iSqPosX;
            this.iQuadY = 10;
        } else if (iQuadIdx == 1) {
            this.iQuadX = 10;
            this.iQuadY = this.iSqPosY;
        } else if (iQuadIdx == 2) {
            this.iQuadX = Resources.WIDTH - Resources.pSprPlayerH - 10;
            this.iQuadY = this.iSqPosY;
        }
        Resources.pSprCorss.setFrame(this.iCrossFrame / 5);
        Resources.pSprCorss.setPosition(this.iQuadX + this.iFontPosX, this.iQuadY + this.iFontPosY);
        Resources.pSprCorss.paint(g);
    }

    private void updateSectors() {
        if (ball.getBallY() > this.iSectorPosY && ball.getBallY() <= this.iSectorPosY + Resources.TUTORIAL_SECTOR_H) {
            ++iQuadIdx;
            this.iSectorPosY -= Resources.TUTORIAL_SECTOR_H >> 1;
        }
        if (iQuadIdx >= 4) {
            this.iMode = 3;
            this.prepareTutorialText();
        }
    }

    private void paintTutorial(Graphics g) {
        if (this.iTutorialType == 0) {
            this.paintSelector(g, 0, 0);
            this.paintQuads(g);
            fbPl.paint(g, 0, 0);
        } else if (this.iTutorialType == 1) {
            this.paintSelector(g, 0, 0);
            this.paintQuads(g);
            ball.paint(0, 0, g);
            fbPl.paint(g, 0, 0);
        } else if (this.iTutorialType == 2) {
            this.paintSelector(g, 0, 0);
            this.paintSectors(g);
            ball.paint(0, 0, g);
            fbPl.paint(g, 0, 0);
            fbPl.paintIndicator(g, 0, 0);
        } else if (this.iTutorialType == 3) {
            this.goalUp.paintGoalDnPart(g, 0, 0);
            if (ball.getPosZ() <= Resources.pSprPlayerH) {
                ball.paint(0, 0, g);
            }
            fbPl.paint(g, 0, 0);
            fbPl.paintIndicator(g, 0, 0);
            this.goalUp.paintGoalUpPart(g, 0, 0);
            if (ball.getPosZ() > Resources.pSprPlayerH) {
                ball.paint(0, 0, g);
            }
            this.paintScoreCross(g);
        } else if (this.iTutorialType == 4) {
            this.paintCyrcle(g);
            this.paintCross(g);
            this.paintSelector(g, 0, 0);
            ball.paint(0, 0, g);
            fbPl2.paint(g, 0, 0);
            fbPl.paint(g, 0, 0);
        } else if (this.iTutorialType == 5) {
            this.paintCyrcle(g);
            this.paintCross(g);
            this.paintSelector(g, 0, 0);
            ball.paint(0, 0, g);
            fbPl2.paint(g, 0, 0);
            fbPl.paint(g, 0, 0);
        } else if (this.iTutorialType == 6) {
            this.paintSelector(g, 0, 0);
            this.paintSelectorForPass(g);
            ball.paint(0, 0, g);
            fbPl.paint(g, 0, 0);
            fbP3.paint(g, 0, 0);
            fbP4.paint(g, 0, 0);
            activePlayer.paintIndicator(g, 0, 0);
        } else if (this.iTutorialType == 7) {
            this.paintSelector(g, 0, 0);
            this.paintSelectorForPass(g);
            ball.paint(0, 0, g);
            fbPl.paint(g, 0, 0);
            fbP3.paint(g, 0, 0);
            fbP4.paint(g, 0, 0);
            activePlayer.paintIndicator(g, 0, 0);
        }
        Resources.paintJoystick(g);
    }

    private void paintScoreCross(Graphics g) {
        for (int i = 0; i < 3; ++i) {
            if (!bCross[i]) continue;
            Resources.pSprCorss.setFrame(this.iCrossFrame / 5);
            Resources.pSprCorss.setPosition(crossPosX[i], crossPosY[i]);
            Resources.pSprCorss.paint(g);
        }
    }

    private void paintSectors(Graphics g) {
        g.setColor(0xFFFFFF);
        g.drawLine(0, this.iSectorPosY + this.iSectorW, Resources.WIDTH, this.iSectorPosY + this.iSectorW);
        g.drawLine(0, this.iSectorPosY, Resources.WIDTH, this.iSectorPosY);
        Resources.pImgKuzel.drawAtPoint(g, 0, this.iSectorPosY + this.iSectorW - (Resources.iKuzelkaH >> 1) - 3);
        Resources.pImgKuzel.drawAtPoint(g, Resources.WIDTH - Resources.iKuzelkaW, this.iSectorPosY + this.iSectorW - (Resources.iKuzelkaH >> 1) - 3);
    }

    public void paintSelector(Graphics g, int iScrollX, int iScrollY) {
        Pitch.paintSelector(g, activePlayer, 0, 0);
    }

    public void paintCyrcle(Graphics g) {
        if (ball.hasOwner() && ball.getOwner() == fbPl2) {
            if (this.iBlick < 5) {
                g.setColor(0xFFFF00);
            } else {
                g.setColor(0xFF0000);
            }
            g.drawArc(ball.getBallX() - this.iCircleW2, ball.getBallY() - this.iCircleW2, this.iCircleW, this.iCircleW, 0, 360);
        }
    }

    public void tackle() {
        if (fbPl.hasBall()) {
            return;
        }
        if (ball.getOwner() != null) {
            int iTackleBallX = ball.getBallQuadX();
            int iTackleBallY = ball.getBallQuadY();
            if (fbPl.isActive() && fbPl.getActualGridX() == iTackleBallX && fbPl.getActualGridY() == iTackleBallY && Math.abs(fbPl.getPosX() - ball.getBallX()) < 10 && Math.abs(fbPl.getPosY() - ball.getBallY()) < 10) {
                ball.getOwner().setHasBall(false);
                ball.addBallToPlayer(fbPl);
            }
        }
    }

    public void paintCross(Graphics g) {
        if (!fbPl.hasBall()) {
            return;
        }
        Resources.pSprCorss.setFrame(this.iCrossFrame / 5);
        Resources.pSprCorss.setPosition(Resources.WIDTH - Resources.iCrossW >> 1, Resources.HEIGHT - Resources.iCrossH * 2);
        Resources.pSprCorss.paint(g);
    }

    public void prepareTutorialText() {
        this.iDiffX = 0;
        this.iHeaderPosY = (Resources.HEIGHT - 12 * Resources.iTableH >> 1) + 5;
        this.iScrollingArrowX = (Resources.WIDTH - 11 * Resources.iTableW) / 2 + 11 * Resources.iTableW - Resources.iMenuArrSmallW - 2;
        this.iScrollingArrowY1 = (Resources.HEIGHT - 12 * Resources.iTableH) / 2 + 2;
        this.iScrollingArrowY2 = this.iScrollingArrowY1 + 12 * Resources.iTableH - Resources.iMenuArrSmallH - 4;
        if (this.iTutorialPhase == 0) {
            Resources.prepareText("TUTORIAL_1", Resources.iTableW * 10 - this.iDiffX, Resources.iTableH * 10);
        } else if (this.iTutorialPhase == 1) {
            Resources.prepareText("TUTORIAL_2", Resources.iTableW * 10 - this.iDiffX, Resources.iTableH * 10);
        } else if (this.iTutorialPhase == 2) {
            Resources.prepareText("TUTORIAL_3", Resources.iTableW * 10 - this.iDiffX, Resources.iTableH * 10);
        } else if (this.iTutorialPhase == 3) {
            Resources.prepareText("TUTORIAL_4", Resources.iTableW * 10 - this.iDiffX, Resources.iTableH * 10);
        } else if (this.iTutorialPhase == 4) {
            Resources.prepareText("TUTORIAL_5", Resources.iTableW * 10 - this.iDiffX, Resources.iTableH * 10);
        } else if (this.iTutorialPhase == 5) {
            Resources.prepareText("TUTORIAL_6", Resources.iTableW * 10 - this.iDiffX, Resources.iTableH * 10);
        } else if (this.iTutorialPhase == 6) {
            Resources.prepareText("TUTORIAL_7", Resources.iTableW * 10 - this.iDiffX, Resources.iTableH * 10);
        } else if (this.iTutorialPhase == 7) {
            Resources.prepareText("TUTORIAL_8", Resources.iTableW * 10 - this.iDiffX, Resources.iTableH * 10);
        } else if (this.iTutorialPhase == 8) {
            Resources.prepareText("TUTORIAL_OVER", Resources.iTableW * 10 - this.iDiffX, Resources.iTableH * 10);
        }
    }

    public void prepareTutorial(int idx) {
        this.iFontPosX = Resources.pSprPlayerH - Resources.iCrossW >> 1;
        this.iFontPosY = Resources.pSprPlayerH - Resources.iCrossH >> 1;
        this.iSqPosX = Resources.WIDTH - Resources.pSprPlayerH >> 1;
        this.strHeader = (this.iTutorialPhase + 1 > 7 ? 7 : this.iTutorialPhase + 1) + " / 7";
        this.iHeaderPosX = Resources.WIDTH - Texts.getTextWidth(this.strHeader) >> 1;
        this.iSqPosY = Resources.HEIGHT - Resources.iCrossH * 3;
        activePlayer = fbPl;
        if (idx == 0) {
            fbPl.setActive();
            fbPl.setPosition(Resources.WIDTH >> 1, Resources.HEIGHT >> 1);
            fbPl.stopActivePlayer();
            fbPl.enableMove();
            iQuadIdx = 0;
            this.iTutorialType = 0;
        } else if (idx == 1) {
            fbPl.setActive();
            fbPl.setPosition(Resources.WIDTH >> 1, Resources.HEIGHT - Resources.pSprPlayerH - 10);
            ball.lostBall();
            ball.setBallPos(Resources.WIDTH >> 1, Resources.HEIGHT >> 1);
            ball.resetJump(0);
            fbPl.stopActivePlayer();
            iQuadIdx = 0;
            this.iTutorialType = 1;
        } else if (idx == 2) {
            fbPl.disableMove();
            fbPl.setPosition(Resources.WIDTH >> 1, Resources.HEIGHT - Resources.pSprPlayerH + 10);
            ball.setBallPos(Resources.WIDTH >> 1, 50);
            ball.resetJump(0);
            fbPl.setActive();
            ball.addBallToPlayer(fbPl);
            this.iSectorPosY = fbPl.getPosY() - 3 * Resources.TUTORIAL_SECTOR_H;
            iQuadIdx = 0;
            this.iTutorialType = 2;
        } else if (idx == 4) {
            ball.lostBall();
            fbPl.setActive();
            fbPl.setPosition(Resources.WIDTH >> 1, Resources.HEIGHT - Resources.pSprPlayerH - 10);
            fbPl.stopActivePlayer();
            fbPl.updateHeaing(fbPl.getPosX(), 0);
            ball.addBallToPlayer(fbPl2);
            fbPl2.setPosition(50, 100);
            fbPl2.updateHeaing(200, fbPl2.getPosY());
            fbPl.enableMove();
            iQuadIdx = 2;
            this.iTutorialType = 4;
        } else if (idx == 3) {
            ScreenTutorial.bCross[0] = true;
            ScreenTutorial.bCross[1] = true;
            ScreenTutorial.bCross[2] = true;
            ScreenTutorial.crossPosX[0] = GOAL_W = this.goalUp.getGoalXL();
            ScreenTutorial.crossPosY[0] = Resources.iCrossH * 3;
            ScreenTutorial.crossPosX[1] = Resources.WIDTH - Resources.iCrossW >> 1;
            ScreenTutorial.crossPosY[1] = Resources.iCrossH * 3;
            ScreenTutorial.crossPosX[2] = Resources.WIDTH - Resources.iCrossW - GOAL_W;
            ScreenTutorial.crossPosY[2] = Resources.iCrossH * 3;
            fbPl.disableMove();
            fbPl.setPosition(Resources.WIDTH >> 1, (Resources.HEIGHT >> 1) + Resources.pSprPlayerH);
            ball.setBallPos(Resources.WIDTH >> 1, 50);
            ball.resetJump(0);
            fbPl.setActive();
            ball.addBallToPlayer(fbPl);
            this.iCircleW = 20;
            this.iCircleW2 = this.iCircleW / 2;
            iQuadIdx = 0;
            this.iTutorialType = 3;
        } else if (idx == 5) {
            ball.lostBall();
            fbPl.setActive();
            fbPl.setPosition(Resources.WIDTH >> 1, Resources.HEIGHT - Resources.pSprPlayerH - 10);
            fbPl.stopActivePlayer();
            fbPl.updateHeaing(fbPl.getPosX(), 0);
            ball.addBallToPlayer(fbPl2);
            fbPl2.setPosition(100, 100);
            fbPl2.updateHeaing(200, fbPl2.getPosY());
            fbPl.enableMove();
            this.iCircleW = 150;
            this.iCircleW2 = this.iCircleW / 2;
            iQuadIdx = 2;
            this.iTutorialType = 5;
        } else if (idx == 7) {
            fbP3.setPosition(40, 80);
            fbP4.setPosition(Resources.WIDTH - 40, 80);
            fbPl.setActive();
            fbPl.setPosition(Resources.WIDTH >> 1, Resources.HEIGHT - Resources.pSprPlayerH - 10);
            fbPl.stopActivePlayer();
            fbPl.updateHeaing(fbPl.getPosX(), 0);
            fbPl.disableMove();
            activePlayer = fbPl;
            this.iTutorialType = 7;
        } else if (idx == 6) {
            ball.lostBall();
            fbP3.setPosition(40, 80);
            fbP4.setPosition(Resources.WIDTH - 40, 80);
            fbPl.setActive();
            fbPl.setPosition(Resources.WIDTH >> 1, Resources.HEIGHT - Resources.pSprPlayerH - 10);
            fbPl.stopActivePlayer();
            fbPl.updateHeaing(fbPl.getPosX(), 0);
            ball.addBallToPlayer(fbPl);
            fbPl.disableMove();
            activePlayer = fbPl;
            this.iTutorialType = 6;
        }
        this.iMode = 2;
    }

    public void releaseTutorial() {
        this.fbT1 = null;
        this.fbT2 = null;
        ball = null;
        fbPl = null;
        fbPl2 = null;
        fbP3 = null;
        fbP4 = null;
        this.goalUp = null;
        System.gc();
        Resources.releaseTutorialRes();
    }

    public void callMenu() {
        this.releaseTutorial();
        MyApplication.pScrMenu = new ScreenMenu();
        MyApplication.pActiveScreen = MyApplication.pScrMenu;
        MyApplication.pScrGame = null;
    }

    public void callNextTutorial() {
        this.iMode = 3;
        this.prepareTutorialText();
        this.pMyApplication.repaintScreen();
    }

    public void keyPressed(Key pKey) {
        if (this.iMode == 3) {
            if (this.iTutorialPhase < 7) {
                if (pKey.iGameAction == 5) {
                    if (this.iTutorialPhase == 8) {
                        return;
                    }
                    if (++this.iTutorialPhase > 6) {
                        this.iTutorialPhase = 6;
                    }
                    this.prepareTutorialText();
                    this.pMyApplication.repaintScreen();
                    return;
                }
                if (pKey.iGameAction == 2) {
                    if (this.iTutorialPhase == 8) {
                        return;
                    }
                    if (--this.iTutorialPhase < 0) {
                        this.iTutorialPhase = 0;
                    }
                    this.prepareTutorialText();
                    this.pMyApplication.repaintScreen();
                    return;
                }
            }
            if (pKey.iValue == Keys.KEY_FNLEFT || pKey.iGameAction == Keys.KEY_FNLEFT) {
                if (this.iTutorialPhase == 8) {
                    this.callMenu();
                    return;
                }
                this.prepareTutorial(this.iTutorialPhase);
                if (++this.iTutorialPhase > 7) {
                    this.iTutorialPhase = 7;
                }
                return;
            }
            if (pKey.iValue == 56 || pKey.iGameAction == 6) {
                Resources.scrollUp();
                this.pMyApplication.repaintScreen();
            } else if (pKey.iValue == 50 || pKey.iGameAction == 1) {
                Resources.scrollDown();
                this.pMyApplication.repaintScreen();
            } else if (pKey.iValue == Keys.KEY_FNRIGHT || pKey.iGameAction == Keys.KEY_FNRIGHT) {
                this.callMenu();
            }
        } else if (this.iMode == 2) {
            if (pKey.iValue == Keys.KEY_FNRIGHT || pKey.iGameAction == Keys.KEY_FNRIGHT) {
                this.callNextTutorial();
            } else if (pKey.iValue == 53 || pKey.iGameAction == 8) {
                activePlayer.pressButton2();
            } else if (pKey.iValue == 49) {
                if (this.iTutorialType == 7 && !activePlayer.hasBall()) {
                    ScreenTutorial.swapPlayer();
                }
            } else if (pKey.iValue == 49) {
                activePlayer.pressButton2();
            }
        }
    }

    public void keyReleased(Key pKey) {
        if (this.iMode == 2) {
            if (pKey.iValue == 53 || pKey.iGameAction == 8) {
                bHasBeenReleased = true;
            }
            if (pKey.iValue == 49) {
                bHasBeenReleased = true;
            }
            if (pKey.iValue == 55) {
                bHasBeenReleased = true;
            }
        }
    }

    public static void swapPlayer() {
        if (activePlayer == fbPl) {
            fbPl.setPassive();
            activePlayer = fbP3;
            fbP3.setActive();
            fbP3.disableMove();
        } else if (activePlayer == fbP3) {
            fbP3.setPassive();
            activePlayer = fbP4;
            fbP4.setActive();
            fbP4.disableMove();
        } else if (activePlayer == fbP4) {
            fbP4.setPassive();
            activePlayer = fbPl;
            fbPl.setActive();
            fbPl.disableMove();
        }
    }

    public void pointerDragged(int x, int y) {
        Resources.joyStickDrag(x, y);
    }

    public void pointerPressed(int x, int y) {
        Resources.pressJoysitck();
        if (this.iMode == 3) {
            if (Resources.pressedLeftButton(x, y)) {
                if (this.iTutorialPhase == 8) {
                    this.callMenu();
                    return;
                }
                this.prepareTutorial(this.iTutorialPhase);
                if (++this.iTutorialPhase > 6) {
                    this.iTutorialPhase = 6;
                }
            } else {
                if (Resources.pressedRightButton(x, y)) {
                    this.callMenu();
                    return;
                }
                if (this.iTutorialPhase < 7) {
                    if (x < Resources.WIDTH >> 1) {
                        if (this.iTutorialPhase == 8) {
                            return;
                        }
                        if (--this.iTutorialPhase < 0) {
                            this.iTutorialPhase = 0;
                        }
                        this.prepareTutorialText();
                        this.pMyApplication.repaintScreen();
                    } else {
                        if (this.iTutorialPhase == 8) {
                            return;
                        }
                        if (++this.iTutorialPhase > 6) {
                            this.iTutorialPhase = 6;
                        }
                        this.prepareTutorialText();
                        this.pMyApplication.repaintScreen();
                    }
                }
            }
        } else {
            if (Resources.isPause(x, y)) {
                this.callNextTutorial();
            }
            if (Resources.isInDirectionButton(x, y)) {
                Resources.returnAction(x, y);
            }
            if (activePlayer != null) {
                if (Resources.isButton1(x, y) && this.iTutorialType == 7 && !activePlayer.hasBall()) {
                    ScreenTutorial.swapPlayer();
                }
                if (Resources.isButton2(x, y)) {
                    activePlayer.pressButton2();
                }
            }
        }
    }

    public void pointerReleased(int x, int y) {
        Resources.releaseJoysitck();
        Resources.releaseControls();
        bHasBeenReleased = true;
    }

    public void onPause() {
        Sounds.setVolume(0);
        Sounds.setMusicVol(0);
        this.callNextTutorial();
    }

    public void onResume() {
        Sounds.setVolume(180);
        Sounds.setMusicVol(180);
        if (!Sounds.musicPlaying()) {
            Sounds.playMenuMusic();
        }
    }

    public void sizeChanged() {
    }

    static {
        bHasBeenReleased = false;
        GOAL_W = 25;
        bCross = new boolean[]{true, true, true};
        crossPosX = new int[3];
        crossPosY = new int[3];
        iQuadIdx = 0;
    }
}

