/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic.spf;

import simple.core.Application;
import simple.video.Graphics;
import sk.inlogic.spf.Ball;
import sk.inlogic.spf.Common;
import sk.inlogic.spf.FootbalPlayer;
import sk.inlogic.spf.FootbalTeam;
import sk.inlogic.spf.FootballTeamAI;
import sk.inlogic.spf.Globals;
import sk.inlogic.spf.Goal;
import sk.inlogic.spf.Resources;
import sk.inlogic.spf.ScreenGame;

public class Pitch {
    public static final int WIDTH = Application.getSingleton().getDevice().getScreen().getWidth();
    public static final int HEIGHT = Application.getSingleton().getDevice().getScreen().getHeight();
    public static final int PITCH_W = 900;
    public static final int PITCH_H = 1320;
    public static final int PITCH_H2 = 660;
    public static final int PITCH_H3 = 440;
    public static final int PITCH_H4 = 330;
    public static final int PITCH_H5 = 264;
    public static final int QUAD_W = 60;
    public static final int QUAD_H = 88;
    public static final int QUAD_W2 = 30;
    public static final int QUAD_H2 = 44;
    public static final int QUAD_KICK_OFF_W = 60;
    public static final int QUAD_KICK_OFF_H = 44;
    public static final int numQ = 15;
    public static final int numQQ = 225;
    public static int[] iScrollVector = new int[2];
    public static int iScrollSpeed = 0;
    public static int iScreenScrollX = 0;
    public static int iScreenScrollY = 0;
    public static int iTmpScrollX = 0;
    public static int iTmpScrollY = 0;
    private static final int iSX = 0;
    private static final int iSY = 0;
    public static final int START_POS_X = 0;
    public static final int START_POS_Y = 0;
    private static final int iRotationAngle = 0;
    private static int iGroundMiddleX = 450;
    private static int iGroundMiddleY = 660;
    public static int PLAY_GROUND_W;
    public static int PLAY_GROUND_H;
    private static int iActualPos;
    private int[] iPlayersPosY = new int[22];
    private int[] iPlayersIdx = new int[22];
    private static boolean bGoal;
    private static boolean bOut;
    private static boolean bCorrner;
    private int[][] iLines = new int[][]{{0, 0, 900, 0}, {900, 0, 900, 1320}, {900, 1320, 0, 1320}, {0, 1320, 0, 0}, {0, 660, 900, 660}};
    private FootbalTeam team1;
    private FootbalTeam team2;
    private Goal goalUp;
    private Goal goalDn;
    private static Ball ball;
    private int iOldActivePlayer = -1;
    private FootbalPlayer activePlayer;
    private static int iClosestPlayerIdx;
    private int[] iClosestPlayersIdx = new int[11];
    private int[] iClosestPlayersDist = new int[11];
    private byte[] ads = new byte[Resources.iNumbX];
    private static int[] xPoint;
    private static int[] yPoint;
    private int[] xPoints = new int[3];
    private int[] yPoints = new int[3];
    private int iArrPosDiffY = 0;
    private int iArrInc = 1;
    private int iTackleBallX;
    private int iTackleBallY;
    private int iTeam;
    private int iTackleCnt;
    private int[] tmpFirstThreePlayers = new int[3];
    private boolean sorted = false;
    private boolean bFoul = false;
    private boolean bPause = false;
    private int iGrasPosX;
    private int iGrasPosY;
    private FootbalTeam scoreTeam;
    private FootbalTeam scoringTeam;
    int iEffectivity = 0;
    public static int TACKLING_DISTANCE;
    FootbalPlayer fbFouledPlayer;
    FootbalTeam otherTeam;
    FootbalTeam fouledTeam;
    public static int iFaulX;
    public static int iFaulY;
    public int hlpX;
    public int hlpY;
    private int iActualGrassY;
    private int iGrassNb = 0;
    private static byte[][] iTeam1Arr;
    private static byte[][] iTeam2Arr;
    private static int iMapPointX;
    private static int iMapPointY;
    private static int iBallPosX;
    private static int iBallPosY;
    private static int iActivePlayerX;
    private static int iActivePlayerY;
    int iAdsX;
    public static int iAdPosY;
    public static final int ADD_POS_X = 40;
    public static int iAddPosX;
    private static boolean bLeftAdd;
    private static boolean bRightAdd;
    private int iLAddX = 0;
    private int iRAddX = 0;
    static int[] iInitAngle;
    static int[] iTriangleX;
    static int[] iTriangleY;
    static int iDirrectionAngle;
    static int iR;
    int iStredX = Resources.WIDTH >> 1;
    int iStredY = Resources.HEIGHT >> 1;
    static int iSelectorPosY;
    public static final int POSITION_GK = 1;
    public static final int POSITION_DL = 2;
    public static final int POSITION_DCL = 3;
    public static final int POSITION_DC = 4;
    public static final int POSITION_DCR = 5;
    public static final int POSITION_DR = 6;
    public static final int POSITION_WBL = 7;
    public static final int POSITION_DML = 8;
    public static final int POSITION_DMC = 9;
    public static final int POSITION_DMR = 10;
    public static final int POSITION_WBR = 11;
    public static final int POSITION_ML = 12;
    public static final int POSITION_MCL = 13;
    public static final int POSITION_MC = 14;
    public static final int POSITION_MCR = 15;
    public static final int POSITION_MR = 16;
    public static final int POSITION_AML = 17;
    public static final int POSITION_AMCL = 18;
    public static final int POSITION_AMC = 19;
    public static final int POSITION_AMCR = 20;
    public static final int POSITION_AMR = 21;
    public static final int POSITION_FL = 22;
    public static final int POSITION_FCL = 23;
    public static final int POSITION_FC = 24;
    public static final int POSITION_FCR = 25;
    public static final int POSITION_FR = 26;

    public void pauseGame() {
        this.bPause = true;
    }

    public void unPauseGame() {
        this.bPause = false;
    }

    public Pitch() {
        this.setup();
        this.team1 = new FootbalTeam(0, 4, this, Globals.iFormation);
        this.team2 = new FootbalTeam(1, 2, this, Globals.iFormation1);
        this.goalUp = new Goal(0 + (900 - 7 * Resources.iGoalW >> 1), 0, true);
        this.goalDn = new Goal(0 + (900 - 7 * Resources.iGoalW >> 1), 1232, false);
        ball = new Ball(PLAY_GROUND_W >> 1, PLAY_GROUND_H >> 1, this);
        this.prepareGrass();
    }

    public Goal getGoalUp() {
        return this.goalUp;
    }

    public Goal getGoalDn() {
        return this.goalDn;
    }

    public void update() {
        if (this.bPause) {
            return;
        }
        this.team1.update(false, false);
        this.team2.update(false, false);
        ball.update();
        this.checkGoal();
        this.checkOutAndCorner();
        this.tackle();
        this.updateScroll();
        this.sortPlayers();
        Resources.updateStadiumShadows(iScreenScrollX, iScreenScrollY);
        this.updateGrassTile(iScreenScrollX, iScreenScrollY);
        this.updateAdds(iScreenScrollX, iScreenScrollY);
        this.updateMap();
    }

    public FootbalTeam getScoreTeam() {
        return this.scoreTeam;
    }

    public void setScoreTeam(FootbalTeam fbt) {
        this.scoreTeam = fbt;
    }

    public void checkGoal() {
        bGoal = false;
        if (this.goalUp.isInGoal(ball.getBallX(), ball.getBallY() + 10, ball.getBallZ(), Resources.iBallW2)) {
            this.scoringTeam = this.getTeam1().getSideOfTeam() == 2 ? this.getTeam2() : this.getTeam1();
            this.scoreTeam = this.getTeam1().getSideOfTeam() == 2 ? this.getTeam2() : this.getTeam1();
            this.scoringTeam.setScore(1);
            this.goal();
        }
        if (this.goalDn.isInGoal(ball.getBallX(), ball.getBallY() + 10, ball.getBallZ(), Resources.iBallW2)) {
            this.scoringTeam = this.getTeam1().getSideOfTeam() == 4 ? this.getTeam2() : this.getTeam1();
            this.scoreTeam = this.getTeam1().getSideOfTeam() == 4 ? this.getTeam2() : this.getTeam1();
            this.scoringTeam.setScore(1);
            this.goal();
        }
    }

    public void checkOutAndCorner() {
        bOut = false;
        bCorrner = false;
        if (ball.getBallX() < this.goalUp.getGoalXL() || ball.getBallX() > this.goalUp.getGoalXR()) {
            if (ball.checkCorner() && !bGoal) {
                bCorrner = true;
            }
            if (ball.checkOut() && !bGoal) {
                bOut = true;
            }
        }
    }

    public void tackle() {
        if (WIDTH == 240) {
            TACKLING_DISTANCE = 12;
        } else if (WIDTH == 480) {
            TACKLING_DISTANCE = 24;
        }
        if (ball.getOwner() != null) {
            if (ball.getOwner().isGK()) {
                return;
            }
            if (++this.iTackleCnt < 20) {
                return;
            }
            this.iTackleBallX = ball.getBallQuadX();
            this.iTackleBallY = ball.getBallQuadY();
            this.iTeam = ball.getOwner().getTeam().getTeamSide();
            this.iEffectivity = this.iTeam == 0 ? ScreenGame.iEffectivityYou + Globals.iPlayerTeamProperties[2] * 5 : ScreenGame.iEffectivityEnemy - Globals.iPlayerTeamProperties[4] * 5;
            for (int i = 10; i >= 0; --i) {
                FootbalPlayer fbpl = this.iTeam == 0 ? this.getTeam2().getPlayer(i) : this.getTeam1().getPlayer(i);
                if (fbpl.getTeam().getTeamSide() == 0 && !fbpl.isActive()) {
                    return;
                }
                if (fbpl.getActualGridX() != this.iTackleBallX || fbpl.getActualGridY() != this.iTackleBallY) continue;
                if (fbpl.isGK() && Math.abs(fbpl.getPosX() - ball.getBallX()) < TACKLING_DISTANCE * 2 && Math.abs(fbpl.getPosY() - ball.getBallY()) < TACKLING_DISTANCE) {
                    this.iTackleCnt = 0;
                    ball.getOwner().setCanCatch(false);
                    ball.getOwner().setHasBall(false);
                    ball.addBallToPlayer(fbpl);
                    return;
                }
                if (Math.abs(fbpl.getPosX() - ball.getBallX()) >= TACKLING_DISTANCE || Math.abs(fbpl.getPosY() - ball.getBallY()) >= TACKLING_DISTANCE) continue;
                this.iTackleCnt = 0;
                if (Common.getRandomUInt(100) >= this.iEffectivity) continue;
                ball.getOwner().setCanCatch(false);
                ball.getOwner().setHasBall(false);
                ball.addBallToPlayer(fbpl);
            }
        }
    }

    public boolean isFoul() {
        return this.bFoul;
    }

    public int getFaulPosX() {
        return iFaulX;
    }

    public int getFaulPosY() {
        return iFaulY;
    }

    public FootbalTeam getFouledTeam() {
        return this.fouledTeam;
    }

    public FootbalTeam getOtherTeam() {
        return this.otherTeam;
    }

    public FootbalPlayer getFouledPlayer() {
        return this.fbFouledPlayer;
    }

    public void setFoul(boolean b, FootbalPlayer fbPl, FootbalPlayer fouledP) {
        if (b) {
            iFaulX = fbPl.getPosX();
            iFaulY = fbPl.getPosY();
            this.fouledTeam = fbPl.getTeam() == this.getTeam1() ? this.getTeam2() : this.getTeam1();
            this.otherTeam = this.fouledTeam == this.getTeam1() ? this.getTeam2() : this.getTeam1();
            this.fbFouledPlayer = fouledP;
        }
        this.bFoul = b;
    }

    public void goal() {
        bGoal = true;
    }

    public void setCorner(boolean b) {
        bCorrner = b;
    }

    public void setOut(boolean b) {
        bCorrner = b;
    }

    public boolean isOut() {
        return bOut;
    }

    public boolean isCorrner() {
        return bCorrner;
    }

    public boolean isGoal() {
        return bGoal;
    }

    public void setScrollToMiddle() {
        iScreenScrollX = 450 - (WIDTH >> 1);
        iScreenScrollY = 660 - (HEIGHT >> 1);
    }

    public void setScrollToBall() {
        iScreenScrollX = ball.getBallX() - (WIDTH >> 1);
        iScreenScrollY = ball.getBallY() - (HEIGHT >> 1);
    }

    public void setScrollToBallDownLeft() {
        iScreenScrollX = ball.getBallX() - 25;
        iScreenScrollY = ball.getBallY() - HEIGHT + 25;
    }

    public void setScrollToBallDownRight() {
        iScreenScrollX = ball.getBallX() - WIDTH + 25;
        iScreenScrollY = ball.getBallY() - HEIGHT + 25;
    }

    public void setScrollToBallUpLeft() {
        iScreenScrollX = ball.getBallX() - Resources.pSprPlayerW;
        iScreenScrollY = ball.getBallY() - Resources.pSprPlayerH - Resources.STATUS_BAR_H - 10;
    }

    public void setScrollToBallUpRight() {
        iScreenScrollX = ball.getBallX() - WIDTH + Resources.pSprPlayerW;
        iScreenScrollY = ball.getBallY() - Resources.pSprPlayerH - Resources.STATUS_BAR_H - 10;
    }

    public void setScrollToBallLeft() {
        iScreenScrollX = ball.getBallX() - WIDTH + Resources.pSprPlayerW;
    }

    public void setScrollToBallRight() {
        iScreenScrollX = ball.getBallX() - Resources.pSprPlayerW;
    }

    public void updateScroll() {
        this.hlpX = iScreenScrollX + (WIDTH >> 1);
        this.hlpY = iScreenScrollY + (HEIGHT >> 1);
        if (Math.abs(this.hlpX - ball.getBallX()) < 16 && Math.abs(this.hlpY - ball.getBallY()) < 16) {
            iScreenScrollX = ball.getBallX() - (WIDTH >> 1);
            iScreenScrollY = ball.getBallY() - (HEIGHT >> 1);
            return;
        }
        Common.getNormVector(iScrollVector, this.hlpX, this.hlpY, ball.getBallX(), ball.getBallY());
        iTmpScrollX = iScreenScrollX << 10;
        iTmpScrollY = iScreenScrollY << 10;
        iScreenScrollX = (iTmpScrollX += iScrollVector[0] << 6) >> 10;
        iScreenScrollY = (iTmpScrollY += iScrollVector[1] << 6) >> 10;
    }

    public Ball getBall() {
        return ball;
    }

    public void paintDirTriangle(Graphics g, int x, int y, int idx) {
        int deltaY;
        g.setClipRegion(0, 0, WIDTH, HEIGHT);
        int offsetX = ball.getBallX() - x;
        int offsetY = ball.getBallY() - y + Resources.STATUS_BAR_H;
        int absOffsetX = Math.abs(offsetX);
        int absOffsetY = Math.abs(offsetY);
        if (absOffsetX < WIDTH >> 1 && absOffsetY < HEIGHT >> 1) {
            return;
        }
        int deltaX = absOffsetX - (WIDTH >> 1);
        if (deltaX < 0) {
            deltaX = 0;
        }
        if ((deltaY = absOffsetY - (HEIGHT >> 1)) < 0) {
            deltaY = 0;
        }
        for (int i = 0; i < 3; ++i) {
            if (deltaX < deltaY) {
                if (offsetY > 0) {
                    this.xPoints[i] = xPoint[i] + Math.max(0, Math.min(x - iScreenScrollX, WIDTH - 8));
                    this.yPoints[i] = yPoint[i];
                    continue;
                }
                this.xPoints[i] = xPoint[i] + Math.max(0, Math.min(x - iScreenScrollX, WIDTH - 8));
                this.yPoints[i] = HEIGHT - 1 - yPoint[i];
                continue;
            }
            if (offsetX > 0) {
                this.xPoints[i] = yPoint[i];
                this.yPoints[i] = xPoint[i] + Math.max(0, Math.min(y - iScreenScrollY, HEIGHT - 4));
                continue;
            }
            this.xPoints[i] = WIDTH - 1 - yPoint[i];
            this.yPoints[i] = xPoint[i] + Math.max(0, Math.min(y - iScreenScrollY, HEIGHT - 4));
        }
        if (offsetY > 0) {
            this.yPoints[0] = this.yPoints[0] + Resources.STATUS_BAR_H;
            this.yPoints[1] = this.yPoints[1] + Resources.STATUS_BAR_H;
            this.yPoints[2] = this.yPoints[2] + Resources.STATUS_BAR_H;
        }
        if (idx == 0) {
            g.setColor(255);
        } else {
            g.setColor(0xAAAAAA);
        }
        g.fillPoly(this.xPoints, this.yPoints);
    }

    public void updateGrassTile(int x, int y) {
        this.iGrasPosX = -(x % Resources.iGrassW);
        if (this.iGrasPosX > 0) {
            this.iGrasPosX -= Resources.iGrassW;
        }
        this.iGrasPosY = -(y % Resources.iGrassH);
        if (this.iGrasPosY > 0) {
            this.iGrasPosY -= Resources.iGrassH;
        }
    }

    private void paintGrassTile(Graphics g, int y) {
        Resources.pImgGrass.drawAtPoint(g, this.iGrasPosX, y);
        Resources.pImgGrass.drawAtPoint(g, this.iGrasPosX + Resources.iGrassW, y);
    }

    public void prepareGrass() {
        this.iGrassNb = Resources.HEIGHT / Resources.iGrassH;
        ++this.iGrassNb;
    }

    public void paintGrass(Graphics g, int iScreenScrollX, int iScreenScrollY) {
        int i;
        this.iActualGrassY = this.iGrasPosY;
        for (i = this.iGrassNb; i >= 0; --i) {
            this.paintGrassTile(g, this.iActualGrassY);
            this.iActualGrassY += Resources.iGrassH;
        }
        this.paintShadows(g, iScreenScrollX, iScreenScrollY);
        g.setColor(0xFFFFFF);
        for (i = 4; i >= 0; --i) {
            g.drawLine(this.iLines[i][0] - iScreenScrollX, this.iLines[i][1] - iScreenScrollY, this.iLines[i][2] - iScreenScrollX, this.iLines[i][3] - iScreenScrollY);
        }
        Resources.pSprCentreCyrcle.setFrame(0);
        Resources.pSprCentreCyrcle.setPosition(Resources.iCirclePosX - iScreenScrollX, Resources.iCirclePosY - iScreenScrollY);
        Resources.pSprCentreCyrcle.paint(g);
        Resources.pSprCentreCyrcle.setFrame(1);
        Resources.pSprCentreCyrcle.setPosition(Resources.iCirclePosX - iScreenScrollX, Resources.iCirclePosY + Resources.iCentreCyrcleH - iScreenScrollY);
        Resources.pSprCentreCyrcle.paint(g);
        Resources.pSprCorner.setFrame(0);
        Resources.pSprCorner.setPosition(-iScreenScrollX, -iScreenScrollY);
        Resources.pSprCorner.paint(g);
        Resources.pSprCorner.setFrame(1);
        Resources.pSprCorner.setPosition(-iScreenScrollX + 900 - Resources.iCornerW, -iScreenScrollY);
        Resources.pSprCorner.paint(g);
        Resources.pSprCorner.setFrame(2);
        Resources.pSprCorner.setPosition(-iScreenScrollX, -iScreenScrollY + 1320 - Resources.iCornerH);
        Resources.pSprCorner.paint(g);
        Resources.pSprCorner.setFrame(3);
        Resources.pSprCorner.setPosition(-iScreenScrollX + 900 - Resources.iCornerW, -iScreenScrollY + 1320 - Resources.iCornerH);
        Resources.pSprCorner.paint(g);
    }

    public void updateMap() {
        for (int i = 10; i >= 0; --i) {
            Pitch.iTeam1Arr[i][0] = (byte)(this.getTeam1().getPlayer(i).getPosX() * Resources.iMapW / 900);
            Pitch.iTeam1Arr[i][1] = (byte)(this.getTeam1().getPlayer(i).getPosY() * Resources.iMapH / 1320);
            Pitch.iTeam1Arr[i][2] = (byte)(this.getTeam1().getPlayer(i).hasBall() ? 4 : 2);
            if (iTeam1Arr[i][0] < 0) {
                Pitch.iTeam1Arr[i][0] = 0;
            }
            if (iTeam1Arr[i][1] < 0) {
                Pitch.iTeam1Arr[i][1] = 0;
            }
            Pitch.iTeam2Arr[i][0] = (byte)(this.getTeam2().getPlayer(i).getPosX() * Resources.iMapW / 900);
            Pitch.iTeam2Arr[i][1] = (byte)(this.getTeam2().getPlayer(i).getPosY() * Resources.iMapH / 1320);
            Pitch.iTeam2Arr[i][2] = (byte)(this.getTeam2().getPlayer(i).hasBall() ? 4 : 2);
            if (iTeam2Arr[i][0] < 0) {
                Pitch.iTeam2Arr[i][0] = 0;
            }
            if (iTeam2Arr[i][1] >= 0) continue;
            Pitch.iTeam2Arr[i][1] = 0;
        }
        iBallPosX = -99;
        iBallPosY = -99;
        if (!ball.hasOwner()) {
            iBallPosX = ball.getBallX() * Resources.iMapW / 900;
            iBallPosY = ball.getBallY() * Resources.iMapH / 1320;
        }
        iActivePlayerX = -99;
        iActivePlayerY = -99;
        if (this.getActivePlayer() != null) {
            iActivePlayerX = this.getActivePlayer().getPosX() * Resources.iMapW / 900;
            iActivePlayerY = this.getActivePlayer().getPosY() * Resources.iMapH / 1320;
        }
    }

    public void paintMap(Graphics g, int mapX, int mapY) {
        Resources.pImgMap.drawAtPoint(g, mapX, mapY);
        for (int i = 10; i >= 0; --i) {
            Resources.pSprMapPt.setFrame(0);
            Resources.pSprMapPt.setPosition(mapX + iTeam1Arr[i][0], mapY + iTeam1Arr[i][1]);
            Resources.pSprMapPt.paint(g);
            Resources.pSprMapPt.setFrame(1);
            Resources.pSprMapPt.setPosition(mapX + iTeam2Arr[i][0], mapY + iTeam2Arr[i][1]);
            Resources.pSprMapPt.paint(g);
        }
        Resources.pSprMapPt.setFrame(2);
        Resources.pSprMapPt.setPosition(iBallPosX + mapX, iBallPosY + mapY);
        Resources.pSprMapPt.paint(g);
        g.setColor(0);
        g.fillRect(iActivePlayerX + mapX, iActivePlayerY + mapY, 4, 4);
    }

    public void sortPlayers() {
        iActualPos = 0;
        for (int i = 10; i >= 0; --i) {
            this.iPlayersPosY[Pitch.iActualPos] = ScreenGame.getPitch().getTeam1().getPlayer(i).getPosY();
            this.iPlayersIdx[Pitch.iActualPos] = ScreenGame.getPitch().getTeam1().getPlayer(i).getPosInArray();
            this.iPlayersPosY[++Pitch.iActualPos] = ScreenGame.getPitch().getTeam2().getPlayer(i).getPosY();
            this.iPlayersIdx[Pitch.iActualPos] = ScreenGame.getPitch().getTeam2().getPlayer(i).getPosInArray() + 100;
            ++iActualPos;
        }
        Common.quickSort(this.iPlayersIdx, this.iPlayersPosY, 0, 21);
    }

    public void paintSortedPlayers(Graphics g, int iScreenScrollX, int iScreenScrollY) {
        for (int i = 0; i < 22; ++i) {
            if (this.iPlayersIdx[i] < 100) {
                ScreenGame.getPitch().getTeam1().getPlayer(this.iPlayersIdx[i]).paint(g, iScreenScrollX, iScreenScrollY);
                continue;
            }
            ScreenGame.getPitch().getTeam2().getPlayer(this.iPlayersIdx[i] - 100).paint(g, iScreenScrollX, iScreenScrollY);
        }
    }

    public void paintUpAds(Graphics g, boolean bUp) {
        if (bUp) {
            if (iScreenScrollY > 0) {
                return;
            }
            this.iAdsX = Resources.iStartAddX;
            for (int i = 0; i < Resources.iNumbX; ++i) {
                Resources.pImgAd1.drawAtPoint(g, this.iAdsX - iScreenScrollX, -Resources.iAdH * 2 - iScreenScrollY);
                this.iAdsX += Resources.iAdW;
            }
        } else {
            this.iAdsX = Resources.iStartAddX;
            for (int i = 0; i < Resources.iNumbX; ++i) {
                Resources.pImgAd1.drawAtPoint(g, this.iAdsX - iScreenScrollX, Resources.iAdH - iScreenScrollY + 1320);
                this.iAdsX += Resources.iAdW;
            }
        }
    }

    public void updateAdds(int iScreenScrollX, int iScreenScrollY) {
        this.iLAddX = -40 - Resources.iAd2W - iScreenScrollX;
        this.iRAddX = 900 - iScreenScrollX + 40;
        bLeftAdd = this.iLAddX >= -Resources.iAd2W;
        bRightAdd = this.iRAddX <= Resources.WIDTH;
    }

    public void paintVerticalAds(Graphics g, boolean bLeft) {
        block4: {
            block3: {
                iAdPosY = Resources.iAddPosY;
                if (!bLeft) break block3;
                if (!bLeftAdd) break block4;
                Resources.pSprAd2.setFrame(1);
                for (int i = Resources.iVertAddCnt; i >= 0; --i) {
                    Resources.pSprAd2.setPosition(this.iLAddX, iAdPosY - iScreenScrollY);
                    Resources.pSprAd2.paint(g);
                    iAdPosY += Resources.iAddPosInc;
                }
                break block4;
            }
            if (bRightAdd) {
                Resources.pSprAd2.setFrame(0);
                for (int i = Resources.iVertAddCnt; i >= 0; --i) {
                    Resources.pSprAd2.setPosition(this.iRAddX, iAdPosY - iScreenScrollY);
                    Resources.pSprAd2.paint(g);
                    iAdPosY += Resources.iAddPosInc;
                }
            }
        }
    }

    public void paint(Graphics g) {
        this.paintGrass(g, iScreenScrollX, iScreenScrollY);
        Resources.paintStadiumShadows(g);
        Resources.paintCorner(g, iScreenScrollX, iScreenScrollY);
        this.paintVerticalAds(g, true);
        this.paintUpAds(g, true);
        this.goalUp.paintGoalDnPart(g, iScreenScrollX, iScreenScrollY);
        this.goalDn.paintGoalDnPart(g, iScreenScrollX, iScreenScrollY);
        this.goalUp.paint(g, iScreenScrollX, iScreenScrollY);
        this.goalDn.paint(g, iScreenScrollX, iScreenScrollY);
        Pitch.paintSelector(g, ScreenGame.getPitch().getActivePlayer(), iScreenScrollX, iScreenScrollY);
        if (!ball.hasOwner() && ball.getBallZ() < Resources.pSprPlayerH) {
            ball.paint(-iScreenScrollX, -iScreenScrollY, g);
        }
        this.paintSortedPlayers(g, iScreenScrollX, iScreenScrollY);
        if (!ball.hasOwner() && ball.getBallZ() >= Resources.pSprPlayerH) {
            ball.paint(-iScreenScrollX, -iScreenScrollY, g);
        }
        this.paintVerticalAds(g, false);
        this.paintUpAds(g, false);
        if (this.activePlayer != null) {
            this.paintDirTriangle(g, this.activePlayer.getPosX(), this.activePlayer.getPosY(), 0);
        }
        this.goalUp.paintGoalUpPart(g, iScreenScrollX, iScreenScrollY);
        this.goalDn.paintGoalUpPart(g, iScreenScrollX, iScreenScrollY);
        this.paintArrow(g, iScreenScrollX, iScreenScrollY);
        this.paintMap(g, 1, Resources.HEIGHT - Resources.iMapH - 1);
        if (this.activePlayer != null) {
            this.activePlayer.paintIndicator(g, iScreenScrollX, iScreenScrollY);
        }
        FootballTeamAI.paintGoalCyrcle(g, iScreenScrollX, iScreenScrollY);
        this.paintVector(iScreenScrollX, iScreenScrollY, g);
    }

    public void paintVector(int iScreenScrollX, int iScreenScrollY, Graphics g) {
    }

    public void paintArrow(Graphics g, int iScrollX, int iScrollY) {
        this.iArrPosDiffY += this.iArrInc;
        if (this.iArrPosDiffY > 5) {
            this.iArrInc *= -1;
        }
        if (this.iArrPosDiffY < 0) {
            this.iArrInc *= -1;
        }
        if (ScreenGame.getPitch().getBall().hasOwner()) {
            Resources.pImgArrow.drawAtPoint(g, ScreenGame.getPitch().getBall().getOwner().getPosX() - iScrollX - (Resources.iArrowW >> 1), ScreenGame.getPitch().getBall().getOwner().getPosY() - iScrollY - Resources.pSprPlayerH - 20 + this.iArrPosDiffY);
        }
    }

    public static void paintSelector(FootbalPlayer fbp, int iScrollX, int iScrollY, int iActive, Graphics g) {
        iSelectorPosY = fbp.getPosY() - iScrollY - Resources.pSprPlayerH;
        Resources.pSprSelector.setFrame(iActive);
        Resources.pSprSelector.setPosition(fbp.getPosX() - iScrollX - (Resources.iSelectorW >> 1), iSelectorPosY);
        Resources.pSprSelector.paint(g);
    }

    public static void paintSelector(Graphics g, FootbalPlayer fbp, int iScrollX, int iScrollY) {
        if (fbp == null) {
            return;
        }
        int iRadiusDiff = 0;
        int RADIUS = 27;
        int RADIUS2 = RADIUS + RADIUS / 3 * 2;
        int iSelectorY = fbp.getPosY() - iScrollY - Resources.pSprPlayerH;
        Resources.pSprSelector.setFrame(0);
        Resources.pSprSelector.setPosition(fbp.getPosX() - iScrollX - (Resources.iSelectorW >> 1), iSelectorY);
        Resources.pSprSelector.paint(g);
        for (int i = 0; i < 3; ++i) {
            iR = i == 1 ? RADIUS2 : RADIUS;
            int iHlpAngle = iInitAngle[i] + fbp.getAngle2();
            Pitch.iTriangleX[i] = fbp.getPosX() - iScrollX + (Common.COS(iHlpAngle) * (iR - iRadiusDiff) >> 9);
            Pitch.iTriangleY[i] = fbp.getPosY() - iScrollY + (Common.SIN(iHlpAngle) * ((iR - iRadiusDiff >> 2) * 3) >> 9) - 5;
        }
        g.setColor(9503741);
        g.fillPoly(iTriangleX, iTriangleY);
    }

    public void paintShadows(Graphics g, int iScrollX, int iScrollY) {
        if (ScreenGame.iMode == 16) {
            return;
        }
        if (ScreenGame.iMode != 9) {
            Resources.pImgShadow.drawAtPoint(g, ball.getBallX() - iScrollX - Resources.iShadowW2, ball.getBallY() - iScrollY - Resources.iBallShadowDiffY);
        }
        for (int i = 10; i >= 0; --i) {
            if (this.getTeam1().getPlayer(i).bPaintNeed()) {
                Resources.pImgShadow.drawAtPoint(g, this.getTeam1().getPlayer(i).getPosX() - iScrollX - Resources.iShadowW2, this.getTeam1().getPlayer(i).getPosY() - iScrollY - Resources.iShadowH);
            }
            if (!this.getTeam2().getPlayer(i).bPaintNeed()) continue;
            Resources.pImgShadow.drawAtPoint(g, this.getTeam2().getPlayer(i).getPosX() - iScrollX - Resources.iShadowW2, this.getTeam2().getPlayer(i).getPosY() - iScrollY - Resources.iShadowH);
        }
    }

    public FootbalTeam getTeam1() {
        return this.team1;
    }

    public FootbalTeam getTeam2() {
        return this.team2;
    }

    private void setup() {
        int j;
        int i;
        int iPointX = 0;
        int iPointY = 0;
        iGroundMiddleX = Pitch.rotateX(iGroundMiddleX, iGroundMiddleY);
        iGroundMiddleY = Pitch.rotateY(iGroundMiddleX, iGroundMiddleY);
        for (i = 0; i < 5; ++i) {
            for (j = 0; j < 2; ++j) {
                iPointX = this.iLines[i][j * 2];
                iPointY = this.iLines[i][j * 2 + 1];
                this.iLines[i][j * 2] = Pitch.rotateX(iPointX, iPointY);
                this.iLines[i][j * 2 + 1] = Pitch.rotateY(iPointX, iPointY);
            }
        }
        PLAY_GROUND_W = this.iLines[1][2] - this.iLines[0][0];
        PLAY_GROUND_H = this.iLines[2][3] - this.iLines[0][3];
        for (i = 0; i < 5; ++i) {
            for (j = 0; j < 2; ++j) {
                int[] nArray = this.iLines[i];
                int n = j * 2;
                nArray[n] = nArray[n] - this.iLines[0][0];
                int[] nArray2 = this.iLines[i];
                int n2 = j * 2 + 1;
                nArray2[n2] = nArray2[n2] - this.iLines[0][3];
            }
        }
    }

    public static int rotateX(int x, int y) {
        return (x * Common.COS(0L) >> 8) - (y * Common.SIN(0L) >> 8);
    }

    public static int rotateY(int x, int y) {
        return (x * Common.SIN(0L) >> 8) + (y * Common.COS(0L) >> 8);
    }

    public FootbalPlayer getActivePlayer() {
        return this.activePlayer;
    }

    public void deselectPlayer() {
        this.activePlayer = null;
    }

    public void swapPlayers() {
        this.setActivePlayer(0, this.iGetClosestPlayer());
    }

    public void setActivePlayer(int iTeam, int iNumberPlayer) {
        if (this.iOldActivePlayer != -1) {
            if (iTeam == 0) {
                this.getTeam1().setPassivePlayer(this.iOldActivePlayer);
            } else {
                this.getTeam2().setPassivePlayer(this.iOldActivePlayer);
            }
        }
        if (iTeam == 0) {
            this.getTeam1().setActivePlayer(iNumberPlayer);
            this.activePlayer = this.getTeam1().getPlayer(iNumberPlayer);
        } else {
            this.getTeam2().setActivePlayer(iNumberPlayer);
            this.activePlayer = this.getTeam2().getPlayer(iNumberPlayer);
        }
        this.iOldActivePlayer = iNumberPlayer;
    }

    public int getActivePlayerIdx() {
        return this.iOldActivePlayer;
    }

    public FootbalPlayer getPlayer(int iTeam, int iNumberPlayer) {
        if (iTeam == 0) {
            return this.getTeam1().getPlayer(iNumberPlayer);
        }
        return this.getTeam2().getPlayer(iNumberPlayer);
    }

    public static int getAttQuadByPos(int side, int pos) {
        int quad = Pitch.getAttQuadByPos(pos);
        return side == 4 ? 224 - quad : quad;
    }

    public static int getDefQuadByPos(int side, int pos) {
        int quad = Pitch.getDefQuadByPos(pos);
        return side == 4 ? 224 - quad : quad;
    }

    public static int getKickOffQuadByPos(int side, int pos) {
        int quad = Pitch.getKckOffQuadByPos(pos);
        return side == 4 ? 224 - quad : quad;
    }

    public static int getQuadByIdXY(int idX, int idY) {
        return idY * 15 + idX;
    }

    public static int getAttQuadByPos(int pos) {
        switch (pos) {
            case 1: {
                return 7;
            }
            case 6: {
                return 76;
            }
            case 5: {
                return 80;
            }
            case 4: {
                return 82;
            }
            case 3: {
                return 84;
            }
            case 2: {
                return 88;
            }
            case 11: {
                return 106;
            }
            case 10: {
                return 110;
            }
            case 9: {
                return 112;
            }
            case 8: {
                return 114;
            }
            case 7: {
                return 118;
            }
            case 16: {
                return 136;
            }
            case 15: {
                return 140;
            }
            case 14: {
                return 142;
            }
            case 13: {
                return 144;
            }
            case 12: {
                return 148;
            }
            case 21: {
                return 166;
            }
            case 20: {
                return 170;
            }
            case 19: {
                return 172;
            }
            case 18: {
                return 174;
            }
            case 17: {
                return 178;
            }
            case 26: {
                return 196;
            }
            case 25: {
                return 200;
            }
            case 24: {
                return 202;
            }
            case 23: {
                return 204;
            }
            case 22: {
                return 208;
            }
        }
        return 0;
    }

    public static int getDefQuadByPos(int pos) {
        switch (pos) {
            case 1: {
                return 7;
            }
            case 6: {
                return 16;
            }
            case 5: {
                return 20;
            }
            case 4: {
                return 22;
            }
            case 3: {
                return 24;
            }
            case 2: {
                return 28;
            }
            case 11: {
                return 31;
            }
            case 10: {
                return 35;
            }
            case 9: {
                return 37;
            }
            case 8: {
                return 39;
            }
            case 7: {
                return 43;
            }
            case 16: {
                return 61;
            }
            case 15: {
                return 65;
            }
            case 14: {
                return 67;
            }
            case 13: {
                return 69;
            }
            case 12: {
                return 73;
            }
            case 21: {
                return 76;
            }
            case 20: {
                return 80;
            }
            case 19: {
                return 82;
            }
            case 18: {
                return 84;
            }
            case 17: {
                return 88;
            }
            case 26: {
                return 121;
            }
            case 25: {
                return 125;
            }
            case 24: {
                return 127;
            }
            case 23: {
                return 129;
            }
            case 22: {
                return 133;
            }
        }
        return 0;
    }

    public static int getKckOffQuadByPos(int pos) {
        switch (pos) {
            case 1: {
                return 7;
            }
            case 6: {
                return 16;
            }
            case 5: {
                return 20;
            }
            case 4: {
                return 22;
            }
            case 3: {
                return 24;
            }
            case 2: {
                return 28;
            }
            case 11: {
                return 31;
            }
            case 10: {
                return 35;
            }
            case 9: {
                return 37;
            }
            case 8: {
                return 39;
            }
            case 7: {
                return 43;
            }
            case 16: {
                return 61;
            }
            case 15: {
                return 65;
            }
            case 14: {
                return 67;
            }
            case 13: {
                return 69;
            }
            case 12: {
                return 73;
            }
            case 21: {
                return 76;
            }
            case 20: {
                return 80;
            }
            case 19: {
                return 82;
            }
            case 18: {
                return 84;
            }
            case 17: {
                return 88;
            }
            case 26: {
                return 91;
            }
            case 25: {
                return 95;
            }
            case 24: {
                return 82;
            }
            case 23: {
                return 99;
            }
            case 22: {
                return 103;
            }
        }
        return 0;
    }

    public static int getQuadrantByPos(int pos) {
        switch (pos) {
            case 2: {
                return 31;
            }
            case 3: {
                return 34;
            }
            case 4: {
                return 37;
            }
            case 5: {
                return 40;
            }
            case 6: {
                return 43;
            }
            case 7: {
                return 76;
            }
            case 8: {
                return 79;
            }
            case 9: {
                return 82;
            }
            case 10: {
                return 85;
            }
            case 11: {
                return 88;
            }
            case 12: {
                return 121;
            }
            case 13: {
                return 124;
            }
            case 14: {
                return 127;
            }
            case 15: {
                return 130;
            }
            case 16: {
                return 133;
            }
            case 17: {
                return 166;
            }
            case 18: {
                return 169;
            }
            case 19: {
                return 172;
            }
            case 20: {
                return 175;
            }
            case 21: {
                return 178;
            }
            case 22: {
                return 211;
            }
            case 23: {
                return 214;
            }
            case 24: {
                return 217;
            }
            case 25: {
                return 220;
            }
            case 26: {
                return 223;
            }
            case 1: {
                return 7;
            }
        }
        return 0;
    }

    public void getClosestPlayersArr() {
        for (int i = 9; i >= 0; --i) {
            this.iClosestPlayersIdx[i] = i;
            this.iClosestPlayersDist[i] = Common.getManhattanDis(this.team1.getPlayer(i).getPosX(), this.team1.getPlayer(i).getPosY(), ball.getBallX(), ball.getBallY());
        }
    }

    public int iGetClosestPlayer() {
        this.getClosestPlayersArr();
        Common.quickSort(this.iClosestPlayersIdx, this.iClosestPlayersDist, 0, 10);
        if (this.sorted && (this.tmpFirstThreePlayers[0] != this.iClosestPlayersIdx[0] || this.tmpFirstThreePlayers[1] != this.iClosestPlayersIdx[1] || this.tmpFirstThreePlayers[2] != this.iClosestPlayersIdx[2])) {
            this.sorted = false;
        }
        if (!this.sorted) {
            this.tmpFirstThreePlayers[0] = this.iClosestPlayersIdx[0];
            this.tmpFirstThreePlayers[1] = this.iClosestPlayersIdx[1];
            this.tmpFirstThreePlayers[2] = this.iClosestPlayersIdx[2];
            iClosestPlayerIdx = -1;
            this.sorted = true;
        }
        if (++iClosestPlayerIdx > 2) {
            iClosestPlayerIdx = 0;
        }
        return this.iClosestPlayersIdx[iClosestPlayerIdx];
    }

    public static int getQuadByXY(int x, int y) {
        int idX = x / 60;
        int idY = y / 88;
        return idY * 15 + idX;
    }

    public static int getPosXByRealQuad(int quad) {
        return quad % 15 * 60 + 30;
    }

    public static int getPosYByRealQuad(int quad) {
        return quad / 15 * 88 + 44;
    }

    public static int getIdxXByQuad(int quad) {
        return quad % 15;
    }

    public static int getIdxYByQuad(int quad) {
        return quad / 15;
    }

    public static int getPosXByQuad(int quad) {
        return Pitch.getIdxXByQuad(quad) * 60;
    }

    public static int getPosYByQuad(int quad) {
        return Pitch.getIdxYByQuad(quad) * 88;
    }

    public static int getPosKickX(int quad) {
        return Pitch.getIdxXByQuad(quad) * 60;
    }

    public static int getPosKickY(int quad) {
        return Pitch.getIdxYByQuad(quad) * 44;
    }

    public Goal getGoal(int side) {
        if (side == 0) {
            return this.goalUp;
        }
        return this.goalDn;
    }

    static {
        iActualPos = 0;
        bGoal = false;
        bOut = false;
        bCorrner = false;
        iClosestPlayerIdx = -1;
        xPoint = new int[]{0, 6, 12};
        yPoint = new int[]{8, 0, 8};
        TACKLING_DISTANCE = 12;
        iTeam1Arr = new byte[11][3];
        iTeam2Arr = new byte[11][3];
        iAdPosY = 0;
        bLeftAdd = false;
        bRightAdd = false;
        iInitAngle = new int[]{-30, 0, 30};
        iTriangleX = new int[3];
        iTriangleY = new int[3];
        iDirrectionAngle = 0;
        iR = 10;
    }
}

