/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic.spf;

import simple.video.Graphics;
import sk.inlogic.spf.Ball;
import sk.inlogic.spf.Common;
import sk.inlogic.spf.FootbalPlayer;
import sk.inlogic.spf.FootbalTeam;
import sk.inlogic.spf.Globals;
import sk.inlogic.spf.Goal;
import sk.inlogic.spf.Pitch;
import sk.inlogic.spf.Resources;
import sk.inlogic.spf.ScreenGame;

public class FootballTeamAI {
    static final int numQ = 15;
    static FootbalPlayer fbpBackup;
    static FootbalPlayer fbp;
    static Ball ball;
    static Goal pGoal;
    static int iActualPlayerPerTurn;
    static int[] iPlayerDistances;
    static int[] iPlayerIndexs;
    static byte[][] iPossibilitiesFront;
    static byte[][] iPossibilitiesDefense;
    static byte[][] iPossibilitiesLeftFront;
    static byte[][] iPossibilitiesRightFront;
    static byte[][] iPossibilities;
    static byte[][] bHlpArr;
    static int[][] iPlayerWeights;
    static int[][] iMaxWeights;
    static int iDistance;
    static int iDistanceFromBall;
    static int[] iVecP;
    static int[] iVecI;
    private static FootbalPlayer goalKeeper;
    private static int iTargetPosX;
    private static int iTargetPosY;
    static final int DOWN_GOALMAN_POS_Y = 1270;
    static final int UP_GOALMAN_POS_Y = 50;
    static int iVecPlayerX;
    static int iVecPlayerY;
    static int iPosPlayerX;
    static int iPosPlayerY;
    static int iPosPlayerVecX;
    static int iPosPlayerVecY;
    static int iPlayerNormalX;
    static int iPlayerNormalY;
    static int iFinalVecorX;
    static int iFinalVecorY;
    static int iMiddleY;
    static int iVectorX;
    static int iVectorY;
    static int iBallAngle;
    static int iGKAngle;
    static int iGKPosX;
    static int iGKPosY;
    static int iGKRoundX;
    static int iGKRoundY;
    static int iGKRoundMidX;
    static int iGKRoundMidY1;
    static int iGKRoundMidY2;
    static int iGKRoundRadius;
    private static int X0;
    private static int Y0;
    private static int iRoundRadius;
    private static int iRoundAngle;
    private static int Xp;
    private static int Yp;
    private static int Xs;
    private static int Ys;
    private static long t1;
    private static long t2;
    private static int iHlpX;
    private static int iHlpY;
    private static int x1;
    private static int y1;
    private static int x2;
    private static int y2;
    static int s1;
    static int s2;
    static double n1;
    static double n2;
    static int r;
    static long val1;
    static long val2;
    static long val3;
    static long helpVal;
    static int iAddX;
    static int iAddY;
    static float discriminant;
    static float p1;
    static float p2;
    static int a;
    static int b;
    static int c;
    static int GKSpeed;
    static FootbalTeam myTeam;
    static FootbalTeam otherTeam;
    static FootbalPlayer tmpPlayer;
    static int iCurrentAttDefQuadX;
    static int iCurrentAttDefQuadY;
    static int quad;
    static int idX;
    static int idY;
    private static FootbalPlayer footballPl;
    static int iQuad;
    static int iIndex;
    static int iTmpQuad;
    static int iTmpWeight;
    static int[] iVec;
    static int[] iPredictedPos;
    static int iPower;
    static int iDist;
    static boolean bPlayerIsGoingForBall;
    static int iMinDistance;
    static int iPlayerIdx;
    static int iHlp;

    static int getPosXByVec(int iVecX, int iVecY, int x0, int y0, int iActualY) {
        if (iVecY == 0) {
            return y0;
        }
        return x0 + iVecX * (iActualY - y0) / iVecY;
    }

    static void prepareGKs() {
        iGKRoundMidX = 450;
        if (Resources.WIDTH == 128) {
            iGKRoundRadius = (ScreenGame.getPitch().getGoalUp().iRealGoalWidth >> 1) + 50;
            iGKRoundMidY1 = -80;
            iGKRoundMidY2 = 1400;
        }
        if (Resources.WIDTH == 176) {
            iGKRoundRadius = (ScreenGame.getPitch().getGoalUp().iRealGoalWidth >> 1) + 50;
            iGKRoundMidY1 = -90;
            iGKRoundMidY2 = 1410;
        }
        if (Resources.WIDTH == 320) {
            iGKRoundRadius = (ScreenGame.getPitch().getGoalUp().iRealGoalWidth >> 1) + 50;
            iGKRoundMidY1 = -130;
            iGKRoundMidY2 = 1450;
        }
        if (Resources.WIDTH == 240) {
            iGKRoundRadius = (ScreenGame.getPitch().getGoalUp().iRealGoalWidth >> 1) + 50;
            iGKRoundMidY1 = -100;
            iGKRoundMidY2 = 1420;
            System.out.println("branka velkost: " + iGKRoundRadius);
        }
        if (Resources.WIDTH == 360) {
            iGKRoundRadius = 150;
            iGKRoundMidY1 = -90;
            iGKRoundMidY2 = 1410;
        }
        if (Resources.WIDTH == 480) {
            iGKRoundRadius = 150;
            iGKRoundMidY1 = -80;
            iGKRoundMidY2 = 1400;
        }
    }

    private static void returnToYLine(FootbalPlayer fbpl) {
        iTargetPosX = 450;
        iTargetPosY = fbpl.getTeam().getSideOfTeam() == 4 ? 1270 : 50;
        fbpl.setTarget(iTargetPosX, iTargetPosY, false);
    }

    private static boolean isGoalmanOnYPos(FootbalPlayer fbpl) {
        if (fbpl.getTeam().getSideOfTeam() == 4) {
            if (fbpl.getPosY() >= 1270) {
                return true;
            }
            if (fbpl.getPosY() <= 50) {
                return true;
            }
        }
        return false;
    }

    private static boolean goalmanHasBall(FootbalPlayer fbpl) {
        return fbpl.hasBall();
    }

    private static FootbalTeam getGoalmanTeam(FootbalPlayer fbpl) {
        if (fbpl.getTeam() == ScreenGame.getPitch().getTeam1()) {
            return ScreenGame.getPitch().getTeam1();
        }
        return ScreenGame.getPitch().getTeam2();
    }

    static boolean bGKKicking(FootbalPlayer fbpl, int team) {
        if (team == 0) {
            return false;
        }
        fbp = FootballTeamAI.getGoalmanTeam(goalKeeper).getPlayer(Common.getRandomByte(10));
        iDistance = Math.abs(fbp.getActualGridY() - fbpl.getActualGridY());
        fbp.isPassingTarget();
        fbp.setIsPassingTarget(true);
        ball.setPassTarget(fbp);
        if (iDistance < 4) {
            ScreenGame.getPitch().getBall().kickToPlayer(fbp, 60);
        } else if (iDistance < 6) {
            ScreenGame.getPitch().getBall().kickToPlayer(fbp, 70);
        } else if (iDistance < 7) {
            ScreenGame.getPitch().getBall().kickToPlayer(fbp, 80);
        } else {
            ScreenGame.getPitch().getBall().kickToPlayer(fbp, 90);
        }
        return true;
    }

    static void recalculateGKPosition(FootbalPlayer fb, int iAction) {
        int n = iMiddleY = fb.getTeam().getSideOfTeam() == 4 ? iGKRoundMidY2 : iGKRoundMidY1;
        if (iAction == 1) {
            if (ScreenGame.getPitch().getBall().getOwner() != null) {
                iVectorX = iGKRoundMidX - ScreenGame.getPitch().getBall().getOwner().getPosX();
                iVectorY = iMiddleY - ScreenGame.getPitch().getBall().getOwner().getPosY();
            }
        } else {
            iVectorX = iGKRoundMidX - ScreenGame.getPitch().getBall().getBallX();
            iVectorY = iMiddleY - ScreenGame.getPitch().getBall().getBallY();
        }
        iBallAngle = Common.atan(iVectorY, iVectorX) + 180;
        iGKAngle = iBallAngle % 360;
        iGKPosX = iGKRoundMidX + (Common.COS(iGKAngle) * iGKRoundRadius >> 8);
        iGKPosY = iMiddleY + (Common.SIN(iGKAngle) * iGKRoundRadius >> 8);
        iGKPosY = fb.getTeam().getSideOfTeam() == 4 ? (iGKPosY > 1320 ? 1320 : iGKPosY) : (iGKPosY < 0 ? 0 : iGKPosY);
    }

    static void calculatePoint(FootbalPlayer fb) {
        s1 = ScreenGame.getPitch().getBall().getVecX();
        s2 = ScreenGame.getPitch().getBall().getVecY();
        r = iGKRoundRadius;
        Xp = ScreenGame.getPitch().getBall().getBallX();
        val1 = (s1 * s1 + s2 * s2) * (r * r);
        Yp = ScreenGame.getPitch().getBall().getBallY();
        helpVal = s1 * (Yp - (Y0 = s2 < 0 ? iGKRoundMidY1 : iGKRoundMidY2)) - s2 * (Xp - (X0 = iGKRoundMidX));
        val2 = helpVal * helpVal;
        if (val1 >= val2) {
            a = s1 * (X0 - Xp) + s2 * (Y0 - Yp);
            b = Common.sqrt((int)(val1 - val2));
            c = s1 * s1 + s2 * s2;
            t1 = ((a <<= 4) + (b <<= 4)) / c;
            t2 = (a - b) / c;
            iAddX = (int)((long)s1 * t1);
            iAddY = (int)((long)s2 * t1);
            x1 = Xp + (iAddX >> 4);
            y1 = Yp + (iAddY >> 4);
            iAddX = (int)((long)s1 * t2);
            iAddY = (int)((long)s2 * t2);
            x2 = Xp + (iAddX >> 4);
            y2 = Yp + (iAddY >> 4);
        }
        if (s2 > 0) {
            if (fb.getTeam().getSideOfTeam() == 4) {
                if (y1 < 1320 && y2 < 1320) {
                    if (x1 < x2 && Xp < x1) {
                        iGKPosX = x1;
                        iGKPosY = y1;
                    } else if (x2 < x1 && Xp < x2) {
                        iGKPosX = x2;
                        iGKPosY = y2;
                    } else if (x2 > x1 && Xp > x2) {
                        iGKPosX = x2;
                        iGKPosY = y2;
                    } else if (x1 > x2 && Xp > x1) {
                        iGKPosX = x1;
                        iGKPosY = y1;
                    }
                } else {
                    if (y1 < 1320) {
                        iGKPosX = x1;
                        iGKPosY = y1;
                    }
                    if (y2 < 1320) {
                        iGKPosX = x2;
                        iGKPosY = y2;
                    }
                }
            }
        } else if (fb.getTeam().getSideOfTeam() == 2) {
            if (y1 > 0 && y2 > 0) {
                if (x1 < x2 && Xp < x1) {
                    iGKPosX = x1;
                    iGKPosY = y1;
                } else if (x2 < x1 && Xp < x2) {
                    iGKPosX = x2;
                    iGKPosY = y2;
                } else if (x2 > x1 && Xp > x2) {
                    iGKPosX = x2;
                    iGKPosY = y2;
                } else if (x1 > x2 && Xp > x1) {
                    iGKPosX = x1;
                    iGKPosY = y1;
                }
            } else {
                if (y1 > 0) {
                    iGKPosX = x1;
                    iGKPosY = y1;
                }
                if (y2 > 0) {
                    iGKPosX = x2;
                    iGKPosY = y2;
                }
            }
        }
        if (Common.getRandomUInt(100) < 10) {
            FootballTeamAI.recalculateGKPosition(fb, 0);
        }
        if (iGKPosY > 660 && fb.getTeam().getSideOfTeam() == 2) {
            FootballTeamAI.recalculateGKPosition(fb, 0);
        }
        if (iGKPosY < 660 && fb.getTeam().getSideOfTeam() == 4) {
            FootballTeamAI.recalculateGKPosition(fb, 0);
        }
        fb.resteKickedStatus();
    }

    static void paintGoalCyrcle(Graphics g, int xx, int yy) {
    }

    static boolean bGKCanMove(FootbalPlayer fb) {
        if (fb.getTeam().getSideOfTeam() == 4 && fb.getActualGridY() > 12) {
            return true;
        }
        return fb.getTeam().getSideOfTeam() == 2 && fb.getActualGridY() < 4;
    }

    static void updateGKs(int team) {
        fbp = null;
        goalKeeper = team == 0 ? ScreenGame.getPitch().getTeam1().getPlayer(10) : ScreenGame.getPitch().getTeam2().getPlayer(10);
        goalKeeper.resetJump();
        if (FootballTeamAI.goalmanHasBall(goalKeeper) && team == 1 && FootballTeamAI.bGKKicking(goalKeeper, team)) {
            return;
        }
        if (ScreenGame.getPitch().getBall().getOwner() == null && ScreenGame.getPitch().getBall().getCurrentSpeed() == 0 && FootballTeamAI.bGKCanMove(goalKeeper) && (iDistanceFromBall = Common.getManhattanDis(goalKeeper.getActualGridX(), goalKeeper.getActualGridY(), ball.getBallQuadX(), ball.getBallQuadY())) <= 2) {
            goalKeeper.setTarget(ball.getBallX(), ball.getBallY(), false);
            return;
        }
        if (Resources.WIDTH >= 360) {
            GKSpeed = Resources.WIDTH * 10 / 240;
        }
        if (ScreenGame.getPitch().getBall().getOwner() != null) {
            if (Globals.iSelectedDiff == 0) {
                FootballTeamAI.recalculateGKPosition(goalKeeper, 1);
            } else {
                FootballTeamAI.recalculateGKPosition(goalKeeper, 0);
            }
            goalKeeper.setGKSpeed(GKSpeed);
            if (Math.abs(goalKeeper.getPosX() - iGKPosX) > 10) {
                goalKeeper.setTarget(iGKPosX, iGKPosY, false);
            }
            return;
        }
        iHlp = Common.getManhattanDis(goalKeeper.getActualGridX(), goalKeeper.getActualGridY(), ball.getBallQuadX(), ball.getBallQuadY());
        if (Globals.iSelectedDiff == 0) {
            if (goalKeeper.wasBallKicked() && iHlp < 4) {
                FootballTeamAI.calculatePoint(goalKeeper);
                goalKeeper.setTarget(iGKPosX, iGKPosY, false);
                goalKeeper.setGKSpeed(GKSpeed);
            }
        } else if (Globals.iSelectedDiff == 1 && iHlp < 4) {
            if (goalKeeper.wasBallKicked()) {
                FootballTeamAI.calculatePoint(goalKeeper);
                goalKeeper.setTarget(iGKPosX, iGKPosY, false);
                goalKeeper.setGKSpeed(GKSpeed);
            }
        } else if (Globals.iSelectedDiff == 2 && iHlp < 4 && goalKeeper.wasBallKicked()) {
            FootballTeamAI.calculatePoint(goalKeeper);
            goalKeeper.setTarget(iGKPosX, iGKPosY, false);
            goalKeeper.setGKSpeed(GKSpeed * 2);
        }
    }

    public static void resetWeight() {
        for (int i = 2; i >= 0; --i) {
            for (int j = 1; j >= 0; --j) {
                FootballTeamAI.iMaxWeights[i][j] = 0;
            }
        }
    }

    private static void distributeWeightInc(int x, int y, int val, int delta, int range) {
        FootballTeamAI.distribWeights(x, y, val, delta, range, false);
    }

    private static void distributeWeightDec(int x, int y, int val, int delta, int range) {
        FootballTeamAI.distribWeights(x, y, val, delta, range, true);
    }

    private static void distribWeights(int x, int y, int val, int delta, int range, boolean decrease) {
        if (range == 0) {
            range = val / delta - 1;
        }
        int lowerX = Math.max(0, x - range);
        int upperX = Math.min(14, x + range);
        int lowerY = Math.max(0, y - range);
        int upperY = Math.min(14, y + range);
        for (int i = lowerX; i <= upperX; ++i) {
            for (int j = lowerY; j <= upperY; ++j) {
                int dist = Math.max(Math.abs(x - i), Math.abs(y - j));
                if (decrease) {
                    int[] nArray = iPlayerWeights[i];
                    int n = j;
                    nArray[n] = nArray[n] - (val - delta * dist);
                    continue;
                }
                int[] nArray = iPlayerWeights[i];
                int n = j;
                nArray[n] = nArray[n] + (val - delta * dist);
            }
        }
    }

    private static void distribWeightsVert(FootbalPlayer player, int valFront, int valBack, int delta, int yRange, int xRange, boolean decrease, boolean onlyIfZero) {
        int refY;
        int refX;
        int quad;
        if (yRange == 0) {
            yRange = valFront / delta - 1;
        }
        if (ball.getTeamOwner() == player.getTeam()) {
            quad = player.getOffensePosQuad();
            refX = Pitch.getIdxXByQuad(quad);
            refY = Pitch.getIdxYByQuad(quad);
        } else {
            quad = player.getDefensePosQuad();
            refX = Pitch.getPosXByRealQuad(quad) / 60;
            refY = Pitch.getPosYByRealQuad(quad) / 88;
        }
        int crefY = player.getActualGridY();
        int lowerX = Math.max(0, refX - xRange);
        int upperX = Math.min(14, refX + xRange);
        int lowerRange = Math.min(2, yRange);
        int lowerY = Math.max(0, refY - (player.getTeam().getSideOfTeam() == 4 ? yRange : lowerRange));
        int upperY = Math.min(14, refY + (player.getTeam().getSideOfTeam() == 4 ? lowerRange : yRange));
        int lineY = player.getTeam().getSideOfTeam() == 2 ? Math.max(lowerY, crefY + 1) : Math.min(upperY, crefY - 1);
        int ballPosY = ball.getBallQuadY();
        FootbalTeam theirTeam = player.getTeam() == ScreenGame.getPitch().getTeam1() ? ScreenGame.getPitch().getTeam2() : ScreenGame.getPitch().getTeam1();
        for (int i = lowerX; i <= upperX; ++i) {
            for (int j = lowerY; j <= upperY; ++j) {
                if (onlyIfZero && iPlayerWeights[i][j] > 0) continue;
                int val = valFront;
                if (!player.hasBall() && (theirTeam.getSideOfTeam() == 2 && j < theirTeam.getLastPlayerY() || theirTeam.getSideOfTeam() == 4 && j > theirTeam.getLastPlayerY())) continue;
                if (player.getTeam() == ball.getTeamOwner() && (player.getTeam().getSideOfTeam() == 4 && j > crefY || player.getTeam().getSideOfTeam() == 2 && j < crefY)) {
                    val = valBack;
                } else if (player.getTeam() != ball.getTeamOwner() && (player.getTeam().getSideOfTeam() == 4 && j < crefY || player.getTeam().getSideOfTeam() == 2 && j > crefY)) {
                    val = valBack;
                }
                int[] nArray = iPlayerWeights[i];
                int n = j;
                nArray[n] = nArray[n] + val;
                if (ScreenGame.getPitch().getBall().hasOwner() && ScreenGame.getPitch().getBall().getTeamOwner() == player.getTeam()) {
                    if (j == lineY) {
                        int[] nArray2 = iPlayerWeights[i];
                        int n2 = j;
                        nArray2[n2] = nArray2[n2] + 5;
                        continue;
                    }
                    if (!(player.hasBall() || player.getTeam().getSideOfTeam() != 2 || j != ballPosY && j != ballPosY + 1)) {
                        int[] nArray3 = iPlayerWeights[i];
                        int n3 = j;
                        nArray3[n3] = nArray3[n3] + 5;
                        continue;
                    }
                    if (player.hasBall() || player.getTeam().getSideOfTeam() != 4 || j != ballPosY && j != ballPosY - 1) continue;
                    int[] nArray4 = iPlayerWeights[i];
                    int n4 = j;
                    nArray4[n4] = nArray4[n4] + 5;
                    continue;
                }
                if (player.getTeam().hasBall()) continue;
                if (player.getTeam().getSideOfTeam() == 2 && (j == ballPosY || j == ballPosY - 1)) {
                    int[] nArray5 = iPlayerWeights[i];
                    int n5 = j;
                    nArray5[n5] = nArray5[n5] + 5;
                    continue;
                }
                if (player.getTeam().getSideOfTeam() != 4 || j != ballPosY && j != ballPosY + 1) continue;
                int[] nArray6 = iPlayerWeights[i];
                int n6 = j;
                nArray6[n6] = nArray6[n6] + 5;
            }
        }
    }

    public static void recalculateWeights(FootbalPlayer fbPlayer, boolean bOnlyRecalculate, boolean bIgnoreBall) {
        int i;
        if (fbPlayer.isGK()) {
            return;
        }
        if (fbPlayer.isActive()) {
            return;
        }
        ball = ScreenGame.getPitch().getBall();
        myTeam = fbPlayer.getTeam();
        otherTeam = fbPlayer.getTeam() == ScreenGame.getPitch().getTeam1() ? ScreenGame.getPitch().getTeam2() : ScreenGame.getPitch().getTeam1();
        for (i = 14; i >= 0; --i) {
            for (int j = 14; j >= 0; --j) {
                FootballTeamAI.iPlayerWeights[i][j] = 0;
            }
        }
        if (fbPlayer.hasBall()) {
            FootballTeamAI.distribWeightsVert(fbPlayer, 100, 50, 10, fbPlayer.getYZoneRange(), 2, false, true);
        } else {
            FootballTeamAI.distribWeightsVert(fbPlayer, 100, 100, 10, fbPlayer.getYZoneRange(), 2, false, true);
        }
        if (ball.getTeamOwner() == myTeam) {
            quad = fbPlayer.getOffensePosQuad();
            idX = Pitch.getIdxXByQuad(quad);
            idY = Pitch.getIdxYByQuad(quad);
        } else {
            quad = fbPlayer.getDefensePosQuad();
            idX = Pitch.getPosXByRealQuad(quad) / 60;
            idY = Pitch.getPosYByRealQuad(quad) / 88;
        }
        iCurrentAttDefQuadX = idX;
        iCurrentAttDefQuadY = idY;
        for (i = 10; i >= 0; --i) {
            tmpPlayer = myTeam.getPlayer(i);
            if (tmpPlayer == fbPlayer) continue;
            idX = tmpPlayer.getActualGridX();
            idY = tmpPlayer.getActualGridY();
            if (idX < 0 || idX > 14 || idY < 0 || idY > 14) continue;
            if (ball.getTeamOwner() == myTeam) {
                if (fbPlayer.hasBall()) {
                    FootballTeamAI.distribWeightsForPassing(fbPlayer, tmpPlayer, 100 + fbPlayer.getBasePlayerWeight(tmpPlayer), 5, false);
                    continue;
                }
                int[] nArray = iPlayerWeights[idX];
                int n = idY;
                nArray[n] = nArray[n] - 5;
                continue;
            }
            int[] nArray = iPlayerWeights[idX];
            int n = idY;
            nArray[n] = nArray[n] - 5;
        }
        if (ball.getTeamOwner() == myTeam) {
            FootballTeamAI.distribWeightsVert(fbPlayer, 100, 50, 10, fbPlayer.getYZoneRange(), 2, false, true);
        } else {
            FootballTeamAI.distribWeightsVert(fbPlayer, 100, 100, 10, fbPlayer.getYZoneRange(), 2, false, true);
        }
        if (ball.getTeamOwner() == myTeam) {
            quad = fbPlayer.getOffensePosQuad();
            idX = Pitch.getIdxXByQuad(quad);
            idY = Pitch.getIdxYByQuad(quad);
        } else {
            quad = fbPlayer.getDefensePosQuad();
            idX = Pitch.getPosXByRealQuad(quad) / 60;
            idY = Pitch.getPosYByRealQuad(quad) / 88;
        }
        iCurrentAttDefQuadX = idX;
        iCurrentAttDefQuadY = idY;
        if (!bIgnoreBall) {
            if (!ball.hasOwner() && fbPlayer.bCanCatchBall()) {
                idX = ball.getBallQuadX();
                idY = ball.getBallQuadY();
                if (ball.getTeamOwner() == myTeam) {
                    FootballTeamAI.distributeWeightInc(idX, idY, 60, 55, 1);
                } else {
                    FootballTeamAI.distributeWeightInc(idX, idY, 50, 45, 1);
                }
                if (idX != ball.getTargetX() || idY != ball.getTargetY()) {
                    idX = ball.getTargetQuadX();
                    idY = ball.getTargetQuadY();
                    if (myTeam == ball.getTeamOwner()) {
                        FootballTeamAI.distributeWeightInc(idX, idY, 5, 5, 0);
                    } else {
                        FootballTeamAI.distributeWeightInc(idX, idY, 5, 5, 0);
                    }
                }
            }
        } else {
            idX = ball.getBallQuadX();
            idY = ball.getBallQuadY();
            FootballTeamAI.distributeWeightDec(idX, idY, 80, 60, 1);
        }
        for (i = 10; i >= 0; --i) {
            tmpPlayer = otherTeam.getPlayer(i);
            idX = tmpPlayer.getActualGridX();
            idY = tmpPlayer.getActualGridY();
            if (myTeam.hasBall()) {
                FootballTeamAI.distributeWeightDec(idX, idY, 5, 5, 0);
                continue;
            }
            if (!tmpPlayer.hasBall()) continue;
            FootballTeamAI.distributeWeightInc(idX, idY, 5, 5, 0);
        }
        if (fbPlayer.isCloseToEnemyGoal()) {
            idY = fbPlayer.getTeam().getSideOfTeam() == 2 ? 14 : 0;
            int[] nArray = iPlayerWeights[6];
            int n = idY;
            nArray[n] = nArray[n] + 10;
            int[] nArray2 = iPlayerWeights[7];
            int n2 = idY;
            nArray2[n2] = nArray2[n2] + 10;
            int[] nArray3 = iPlayerWeights[8];
            int n3 = idY;
            nArray3[n3] = nArray3[n3] + 10;
        }
        if (!fbPlayer.isPassingTarget()) {
            FootballTeamAI.fillMaxWeight(fbPlayer, iCurrentAttDefQuadX, iCurrentAttDefQuadY);
        }
        if (bOnlyRecalculate) {
            FootballTeamAI.executeAction(fbPlayer, true);
        }
    }

    private static void distribWeightsForPassing(FootbalPlayer p1, FootbalPlayer p2, int val, int delta, boolean decrease) {
        int yTemp;
        int xTemp;
        if (p1.getTeam() != p2.getTeam()) {
            return;
        }
        int count = Math.max(Math.abs(p2.getActualGridX() - p1.getActualGridX()), Math.abs(p2.getActualGridY() - p1.getActualGridY()));
        if (count > 0) {
            int xAdd = (p2.getActualGridX() - p1.getActualGridX() << 8 << 8) / (count << 8);
            int yAdd = (p2.getActualGridY() - p1.getActualGridY() << 8 << 8) / (count << 8);
            int x = p1.getActualGridX() << 8;
            int y = p1.getActualGridY() << 8;
            FootbalTeam theirTeam = p1.getTeam() == ScreenGame.getPitch().getTeam1() ? ScreenGame.getPitch().getTeam2() : ScreenGame.getPitch().getTeam1();
            for (int k = --count; k >= 0; --k) {
                xTemp = (x += xAdd) >> 8;
                yTemp = (y += yAdd) >> 8;
                if (xTemp < 0 || xTemp > 14 || yTemp < 0 || yTemp > 14) continue;
                int quad = Pitch.getQuadByXY(xTemp, yTemp);
                FootbalPlayer refPlayer = FootballTeamAI.getEnemyPlayerOnQuad(quad, theirTeam);
                if (refPlayer != null) {
                    val -= delta;
                }
                if (val > 0) continue;
                return;
            }
        }
        xTemp = p2.getActualGridX();
        yTemp = p2.getActualGridY();
        if (decrease) {
            int[] nArray = iPlayerWeights[xTemp];
            int n = yTemp;
            nArray[n] = nArray[n] - val;
        } else {
            int[] nArray = iPlayerWeights[xTemp];
            int n = yTemp;
            nArray[n] = nArray[n] + val;
        }
    }

    public static FootbalPlayer getEnemyPlayerOnQuad(int quad, FootbalTeam theirTeam) {
        for (int i = 10; i >= 0; --i) {
            footballPl = theirTeam.getPlayer(i);
            if (footballPl.getCurrentQuad() != quad) continue;
            return footballPl;
        }
        return null;
    }

    public static FootbalPlayer getPlayerOnQuad(int quad, FootbalPlayer refPlayer) {
        for (int i = 10; i >= 0; --i) {
            footballPl = refPlayer.getTeam().getPlayer(i);
            if (footballPl == refPlayer || footballPl.getCurrentQuad() != quad) continue;
            return footballPl;
        }
        return null;
    }

    public static int getBetterQuad(int quad1, int w1, int quad2, int w2, FootbalPlayer fbPlayer) {
        if (w1 != w2) {
            if (w1 > w2) {
                return quad1;
            }
            return quad2;
        }
        int iQ1X = quad1 % 15;
        int iQ1Y = quad1 / 15;
        int iQ2X = quad2 % 15;
        int iQ2Y = quad2 / 15;
        ball = ScreenGame.getPitch().getBall();
        if (!ball.hasOwner()) {
            if (iQ1X == ball.getBallQuadX() && iQ1Y == ball.getBallQuadY()) {
                return quad1;
            }
            if (iQ2X == ball.getBallQuadX() && iQ2Y == ball.getBallQuadY()) {
                return quad2;
            }
        }
        int iDiffQ1 = Common.getManhattanDis(fbPlayer.getActualGridX(), fbPlayer.getActualGridY(), iQ1X, iQ1Y);
        int iDiffQ2 = Common.getManhattanDis(fbPlayer.getActualGridX(), fbPlayer.getActualGridY(), iQ2X, iQ2Y);
        int iQuad1Occupied = FootballTeamAI.isMyTeamOnQuad(iQ1X, iQ1Y, fbPlayer) ? 1 : 0;
        int iQuad2Occupied = FootballTeamAI.isMyTeamOnQuad(iQ2X, iQ2Y, fbPlayer) ? 1 : 0;
        if ((iQuad1Occupied += FootballTeamAI.isOtherTeamOnQuad(iQ1X, iQ1Y, fbPlayer) ? 2 : 0) == 0 && (iQuad2Occupied += FootballTeamAI.isOtherTeamOnQuad(iQ2X, iQ2Y, fbPlayer) ? 2 : 0) == 0) {
            if (iDiffQ1 <= iDiffQ2) {
                return quad1;
            }
            return quad2;
        }
        if (iQuad1Occupied != 0 && iQuad2Occupied != 0) {
            if (fbPlayer.getActualGridX() == iQ1X && fbPlayer.getActualGridY() == iQ1Y) {
                if (fbPlayer.hasBall() && iQuad2Occupied > 1) {
                    return quad1;
                }
                if (fbPlayer.hasBall() && iQuad2Occupied == 1) {
                    return quad2;
                }
                if (!fbPlayer.hasBall() && fbPlayer.getTeam().hasBall()) {
                    return quad1;
                }
                if (!fbPlayer.hasBall() && !fbPlayer.getTeam().hasBall()) {
                    if (iQuad2Occupied > 1) {
                        return quad2;
                    }
                    return quad1;
                }
            } else if (fbPlayer.getActualGridX() == iQ2X && fbPlayer.getActualGridY() == iQ2Y) {
                if (fbPlayer.hasBall() && iQuad1Occupied > 1) {
                    return quad2;
                }
                if (fbPlayer.hasBall() && iQuad1Occupied == 1) {
                    return quad1;
                }
                if (!fbPlayer.hasBall() && fbPlayer.getTeam().hasBall()) {
                    return quad2;
                }
                if (!fbPlayer.hasBall() && !fbPlayer.getTeam().hasBall()) {
                    if (iQuad1Occupied > 1) {
                        return quad1;
                    }
                    return quad2;
                }
            } else {
                if (iQuad1Occupied > 1 && iQuad2Occupied > 1) {
                    if (fbPlayer.getTeam().hasBall()) {
                        if (iDiffQ1 > iDiffQ2) {
                            return quad1;
                        }
                        return quad2;
                    }
                    if (iDiffQ1 < iDiffQ2) {
                        return quad1;
                    }
                    return quad2;
                }
                if (iQuad1Occupied == 1 && iQuad2Occupied == 1) {
                    if (fbPlayer.getTeam().hasBall()) {
                        if (iDiffQ1 < iDiffQ2) {
                            return quad1;
                        }
                        return quad2;
                    }
                    if (iDiffQ1 > iDiffQ2) {
                        return quad1;
                    }
                    return quad2;
                }
                if (iQuad1Occupied == 1) {
                    if (fbPlayer.getTeam().hasBall()) {
                        return quad1;
                    }
                    return quad2;
                }
                if (iQuad2Occupied == 1) {
                    if (fbPlayer.getTeam().hasBall()) {
                        return quad2;
                    }
                    if (!fbPlayer.getTeam().hasBall()) {
                        return quad1;
                    }
                }
            }
        } else if (iQuad1Occupied != 0 || iQuad2Occupied != 0) {
            if (fbPlayer.getActualGridX() == iQ1X && fbPlayer.getActualGridY() == iQ1Y) {
                return quad1;
            }
            if (fbPlayer.getActualGridX() == iQ2X && fbPlayer.getActualGridY() == iQ2Y) {
                return quad2;
            }
            if (fbPlayer.getTeam().hasBall()) {
                if (fbPlayer.hasBall()) {
                    if (iQuad1Occupied == 1) {
                        return quad1;
                    }
                    if (iQuad2Occupied == 1) {
                        return quad2;
                    }
                    if (iQuad1Occupied > 1) {
                        return quad2;
                    }
                    if (iQuad2Occupied > 1) {
                        return quad1;
                    }
                } else {
                    if (iQuad1Occupied == 1) {
                        return quad2;
                    }
                    if (iQuad2Occupied == 1) {
                        return quad1;
                    }
                    if (iQuad1Occupied > 1) {
                        return quad2;
                    }
                    if (iQuad2Occupied > 1) {
                        return quad1;
                    }
                }
            } else {
                if (iQuad1Occupied == 1) {
                    return quad2;
                }
                if (iQuad2Occupied == 1) {
                    return quad1;
                }
                if (iQuad1Occupied > 1) {
                    return quad1;
                }
                if (iQuad2Occupied > 1) {
                    return quad2;
                }
            }
        }
        return quad2;
    }

    public static void switchItem(int[][] iArr, int w, int q, FootbalPlayer fbPlayer) {
        if (iIndex > 2) {
            return;
        }
        iQuad = FootballTeamAI.getBetterQuad(q, w, iArr[iIndex][1], iArr[iIndex][0], fbPlayer);
        if (iArr[iIndex][1] == iQuad) {
            iTmpQuad = q;
            iTmpWeight = w;
        } else {
            iTmpQuad = iArr[iIndex][1];
            iTmpWeight = iArr[iIndex][0];
            iArr[FootballTeamAI.iIndex][1] = q;
            iArr[FootballTeamAI.iIndex][0] = w;
        }
        ++iIndex;
    }

    public static void determineBestWeights(int weight, int quad, FootbalPlayer fbPlayer) {
        iIndex = 0;
        FootballTeamAI.switchItem(iMaxWeights, weight, quad, fbPlayer);
        FootballTeamAI.switchItem(iMaxWeights, iTmpWeight, iTmpQuad, fbPlayer);
        FootballTeamAI.switchItem(iMaxWeights, iTmpWeight, iTmpQuad, fbPlayer);
    }

    public static void fillMaxWeight(FootbalPlayer fbPlayer, int iQuadX, int iQuadY) {
        int y2;
        int y1;
        int x2;
        int x1;
        FootballTeamAI.resetWeight();
        FootballTeamAI.fillPlayerArr(ScreenGame.getPitch().getTeam1(), ScreenGame.getPitch().getTeam2(), fbPlayer);
        boolean isThreatened = fbPlayer.isThreatened();
        if (!fbPlayer.hasBall()) {
            x1 = iQuadX - 2;
            x2 = iQuadX + 2;
            y1 = iQuadY - 2;
            y2 = iQuadY + 2;
        } else {
            x1 = 0;
            x2 = 14;
            y1 = 0;
            y2 = 14;
        }
        for (int i = 14; i >= 0; --i) {
            for (int j = 14; j >= 0; --j) {
                if (!fbPlayer.isGK()) {
                    FootbalPlayer p;
                    if (i < x1 || i > x2 || j < y1 || j > y2 || (!isThreatened || !fbPlayer.hasBall()) && (p = FootballTeamAI.getPlayerOnQuad(j * 15 + i, fbPlayer)) != null) continue;
                    FootballTeamAI.determineBestWeights(iPlayerWeights[i][j], j * 15 + i, fbPlayer);
                    continue;
                }
                if (fbPlayer.getTeam().getSideOfTeam() == 2) {
                    if (j > 1 || i < 4 || i > 10) continue;
                    FootballTeamAI.determineBestWeights(iPlayerWeights[i][j], j * 15 + i, fbPlayer);
                    continue;
                }
                if (j < 12 || i < 4 || i > 10) continue;
                FootballTeamAI.determineBestWeights(iPlayerWeights[i][j], j * 15 + i, fbPlayer);
            }
        }
    }

    public static void fillHorizontalWeight(int iPosY, int w) {
        if (iPosY < 0 || iPosY > 14) {
            return;
        }
        for (int i = 14; i >= 0; --i) {
            int[] nArray = iPlayerWeights[i];
            int n = iPosY;
            nArray[n] = nArray[n] + w;
        }
    }

    public static void fillPlayerArr(FootbalTeam fbteam1, FootbalTeam fbteam2, FootbalPlayer fbPlayer) {
        for (int i = 14; i >= 0; --i) {
            for (int j = 14; j >= 0; --j) {
                FootballTeamAI.bHlpArr[i][j] = 0;
            }
        }
        for (int i = 10; i >= 0; --i) {
            if (fbteam1.getPlayer(i) == fbPlayer || fbteam2.getPlayer(i) == fbPlayer) continue;
            int iQuadX = fbteam1.getPlayer(i).getActualGridX();
            int iQuadY = fbteam1.getPlayer(i).getActualGridY();
            if (iQuadX <= 14 && iQuadX >= 0 && iQuadY <= 14 && iQuadY >= 0) {
                byte[] byArray = bHlpArr[iQuadX];
                int n = iQuadY;
                byArray[n] = (byte)(byArray[n] | fbteam1.getSideOfTeam());
            }
            iQuadX = fbteam2.getPlayer(i).getActualGridX();
            iQuadY = fbteam2.getPlayer(i).getActualGridY();
            if (iQuadX > 14 || iQuadX < 0 || iQuadY > 14 || iQuadY < 0) continue;
            byte[] byArray = bHlpArr[iQuadX];
            int n = iQuadY;
            byArray[n] = (byte)(byArray[n] | fbteam2.getSideOfTeam());
        }
    }

    public static boolean isMyTeamOnQuad(int x, int y, FootbalPlayer fbPlayer) {
        return bHlpArr[x][y] != 0 && (bHlpArr[x][y] & fbPlayer.getTeam().getSideOfTeam()) > 1;
    }

    public static boolean isOtherTeamOnQuad(int x, int y, FootbalPlayer fbPlayer) {
        return bHlpArr[x][y] != 0 && (bHlpArr[x][y] & FootbalTeam.getOtherSideByte(fbPlayer.getTeam().getSideOfTeam())) > 1;
    }

    public static void preparePlayerArr(FootbalTeam fbTeam, int val) {
        for (int i = 14; i >= 0; --i) {
            for (int j = 14; j >= 0; --j) {
                FootballTeamAI.bHlpArr[i][j] = 0;
            }
        }
        for (int i = 0; i < 10; ++i) {
            int iQadX = fbTeam.getPlayer(i).getActualGridX();
            int iQadY = fbTeam.getPlayer(i).getActualGridY();
            if (val == 0) {
                val = (byte)(fbTeam.getPlayer(i).getPosInArray() + 1);
            }
            if (iQadX < 0 || iQadX >= 15 || iQadY < 0 || iQadY >= 15) continue;
            FootballTeamAI.bHlpArr[iQadX][iQadY] = (byte)val;
        }
    }

    public static FootbalPlayer returnOcupied(FootbalTeam fbTeam, int x, int y) {
        for (int i = 0; i < 10; ++i) {
            if (x != fbTeam.getPlayer(i).getActualGridX() || y != fbTeam.getPlayer(i).getActualGridY()) continue;
            return fbTeam.getPlayer(i);
        }
        return null;
    }

    public static boolean checkEnemyInRange(FootbalPlayer owner, FootbalPlayer target) {
        return Common.testCollisionsDDA(owner.getActualGridX(), owner.getActualGridY(), target.getActualGridX(), target.getActualGridY());
    }

    public static boolean isQuadOccupied(int x, int y) {
        return bHlpArr[x][y] != 0;
    }

    public static int getPlayerIndex(int x, int y) {
        return bHlpArr[x][y];
    }

    public static void reset() {
        for (int i = 9; i >= 0; --i) {
            ScreenGame.getPitch().getTeam2().getPlayer(i).followingBall(false);
        }
    }

    public static boolean isResetNeeded() {
        return ball.getOwner() != null && ball.getOwner().getTeam() == ScreenGame.getPitch().getTeam2();
    }

    public static boolean closestPlayerToBall() {
        if (bPlayerIsGoingForBall) {
            return false;
        }
        if (!ball.hasOwner()) {
            return false;
        }
        if (ball.getOwner().getTeam() != ScreenGame.getPitch().getTeam1()) {
            return false;
        }
        if (ball.getOwner().isGK()) {
            return false;
        }
        iMinDistance = 999;
        for (int i = 0; i < 10; ++i) {
            fbp = ScreenGame.getPitch().getTeam2().getPlayer(i);
            fbp.followingBall(false);
            iHlp = Common.getManhattanDis(fbp.getActualGridX(), fbp.getActualGridY(), ball.getBallQuadX(), ball.getBallQuadY());
            if (iMinDistance <= iHlp) continue;
            iMinDistance = iHlp;
            fbpBackup = fbp;
        }
        if (fbpBackup != null) {
            fbpBackup.setTarget(ball.getBallX(), ball.getBallY(), false);
            fbpBackup.followingBall(true);
            return true;
        }
        return false;
    }

    public static void executeAction(FootbalPlayer fbPlayer, boolean bRandom) {
        FootbalPlayer checkP;
        int iTargetQuad = -1;
        FootbalTeam theirTeam = fbPlayer.getTeam() == ScreenGame.getPitch().getTeam1() ? ScreenGame.getPitch().getTeam2() : ScreenGame.getPitch().getTeam1();
        boolean isThreatened = fbPlayer.isThreatened();
        ball = ScreenGame.getPitch().getBall();
        boolean goingForBall = false;
        boolean goingForPlayer = false;
        boolean bPrecisionNeed = false;
        fbPlayer.setShooting(false);
        if (fbPlayer.isPassingTarget()) {
            iTargetQuad = Pitch.getQuadByIdXY(ball.getTargetX(), ball.getTargetY());
        } else if (!ball.hasOwner()) {
            goingForBall = true;
            if (iMaxWeights[0][1] == ball.getCurrneQuad()) {
                iTargetQuad = iMaxWeights[0][1];
            }
            if (iMaxWeights[1][1] == ball.getCurrneQuad()) {
                iTargetQuad = iMaxWeights[1][1];
            }
            if (iMaxWeights[2][1] == ball.getCurrneQuad()) {
                iTargetQuad = iMaxWeights[2][1];
            }
            if (iTargetQuad != -1 && Common.getManhattanDis(fbPlayer.getActualGridX(), fbPlayer.getActualGridY(), ball.getBallQuadX(), ball.getBallQuadY()) > 2) {
                iTargetQuad = -1;
            }
            if (iTargetQuad == -1) {
                goingForBall = false;
            }
        } else if (fbPlayer.getTeam() != ball.getTeamOwner()) {
            goingForPlayer = true;
            if (iMaxWeights[0][1] == ball.getOwner().getCurrentQuad()) {
                iTargetQuad = iMaxWeights[0][1];
            }
            if (iMaxWeights[1][1] == ball.getOwner().getCurrentQuad()) {
                iTargetQuad = iMaxWeights[1][1];
            }
            if (iMaxWeights[2][1] == ball.getOwner().getCurrentQuad()) {
                iTargetQuad = iMaxWeights[2][1];
            }
            if (iTargetQuad != -1 && Common.getManhattanDis(fbPlayer.getActualGridX(), fbPlayer.getActualGridY(), ball.getBallQuadX(), ball.getBallQuadY()) > 2) {
                iTargetQuad = -1;
            }
            if (iTargetQuad == -1) {
                goingForPlayer = false;
                checkP = FootballTeamAI.getEnemyPlayerOnQuad(iMaxWeights[0][1], theirTeam);
                if (checkP != null) {
                    iTargetQuad = iMaxWeights[0][1];
                } else {
                    checkP = FootballTeamAI.getEnemyPlayerOnQuad(iMaxWeights[1][1], theirTeam);
                    if (checkP != null) {
                        iTargetQuad = iMaxWeights[1][1];
                    } else {
                        checkP = FootballTeamAI.getEnemyPlayerOnQuad(iMaxWeights[2][1], theirTeam);
                        if (checkP != null) {
                            iTargetQuad = iMaxWeights[2][1];
                        }
                    }
                }
            }
        } else if (fbPlayer.hasBall() && fbPlayer.getTeam() == ball.getTeamOwner()) {
            if (fbPlayer.isCloseToEnemyGoal()) {
                fbPlayer.setShooting(true);
                if (theirTeam.isGoalQuad(iMaxWeights[0][1])) {
                    iTargetQuad = iMaxWeights[0][1];
                } else if (theirTeam.isGoalQuad(iMaxWeights[1][1])) {
                    iTargetQuad = iMaxWeights[1][1];
                } else if (theirTeam.isGoalQuad(iMaxWeights[2][1])) {
                    iTargetQuad = iMaxWeights[2][1];
                }
                if (iTargetQuad == -1) {
                    fbPlayer.setShooting(false);
                }
            }
            if (iTargetQuad == -1 && isThreatened) {
                checkP = FootballTeamAI.getPlayerOnQuad(iMaxWeights[0][1], fbPlayer);
                if (checkP != null) {
                    iTargetQuad = iMaxWeights[0][1];
                } else {
                    checkP = FootballTeamAI.getPlayerOnQuad(iMaxWeights[1][1], fbPlayer);
                    if (checkP != null) {
                        iTargetQuad = iMaxWeights[1][1];
                    } else {
                        checkP = FootballTeamAI.getPlayerOnQuad(iMaxWeights[2][1], fbPlayer);
                        if (checkP != null) {
                            iTargetQuad = iMaxWeights[2][1];
                        }
                    }
                }
            }
        }
        if (iTargetQuad == -1) {
            iTargetQuad = iMaxWeights[Common.getRandomUInt(3)][1];
        }
        if (fbPlayer.isPassingTarget()) {
            if (fbPlayer.getTargetForBallX() != -1 && fbPlayer.getTargetForBallY() != -1) {
                int x = iTargetQuad % 15;
                int y = iTargetQuad / 15;
                fbPlayer.setTarget(x * 60, y * 88, false);
            } else {
                ball.getAccPercentage();
                if (ball.getAccPercentage() > 70) {
                    fbPlayer.setTarget(ball.getBallX(), ball.getBallY(), false);
                } else {
                    fbPlayer.setTarget(ball.getPredictedX(), ball.getPredictedY(), false);
                }
            }
        } else if (fbPlayer.isShooting()) {
            pGoal = fbPlayer.getTeam().getSideOfTeam() == 2 ? ScreenGame.getPitch().getGoalDn() : ScreenGame.getPitch().getGoalUp();
            int iRandX = Common.getRandomUInt(pGoal.getGoalSizeW() + 20) - 10 + pGoal.getGoalXL();
            int iRandY = fbPlayer.getTeam().getSideOfTeam() == 2 ? 1320 : 0;
            Common.getNormVector(iVec, fbPlayer.getPosX(), fbPlayer.getPosY(), iRandX, iRandY);
            ball.kick(iVec[0], iVec[1], 90);
        } else if (!fbPlayer.isPassingTarget() && (fbPlayer.getActualGridX() != iTargetQuad % 15 || fbPlayer.getActualGridY() != iTargetQuad / 15 || goingForBall || goingForPlayer)) {
            FootbalPlayer passPlayer = null;
            if (fbPlayer.hasBall()) {
                passPlayer = FootballTeamAI.getPlayerOnQuad(iTargetQuad, fbPlayer);
            }
            if (passPlayer != null && !passPlayer.isGK() && isThreatened) {
                iDist = Common.getManhattanDis(passPlayer.getPosX(), passPlayer.getPosY(), fbPlayer.getPosX(), fbPlayer.getPosY());
                if (iDist < 264) {
                    iPower = 40;
                } else if (iDist < 330) {
                    iPower = 50;
                } else if (iDist < 440) {
                    iPower = 60;
                } else if (iDist < 660) {
                    iPower = 70;
                }
                ScreenGame.getPitch().getBall().kickToPlayer(passPlayer, iPower);
                passPlayer.setIsPassingTarget(true);
                ball.setPassTarget(passPlayer);
                fbPlayer.setCanCatch(false);
            } else {
                int targetX = -1;
                int targetY = -1;
                if (goingForBall) {
                    targetX = ScreenGame.getPitch().getBall().getBallX();
                    targetY = ScreenGame.getPitch().getBall().getBallY();
                    bPrecisionNeed = true;
                } else if (goingForPlayer) {
                    if (Common.getRandomUInt(100) < 15 && fbPlayer.isNearTackling(ball)) {
                        fbPlayer.tackle(ball);
                        return;
                    }
                    targetX = ScreenGame.getPitch().getBall().getOwner().getPosX();
                    targetY = ScreenGame.getPitch().getBall().getOwner().getPosY();
                    if (ScreenGame.getPitch().getBall().getOwner() != null) {
                        targetX = ScreenGame.getPitch().getBall().getBallX();
                        targetY = ScreenGame.getPitch().getBall().getBallY();
                        bPrecisionNeed = true;
                    }
                } else {
                    targetX = iTargetQuad % 15 * 60 + 30;
                    targetY = iTargetQuad / 15 * 88 + 44;
                }
                fbPlayer.setTarget(targetX, targetY, bPrecisionNeed);
            }
        }
    }

    static {
        iActualPlayerPerTurn = 0;
        iPlayerDistances = new int[11];
        iPlayerIndexs = new int[11];
        iPossibilitiesFront = new byte[15][15];
        iPossibilitiesDefense = new byte[15][15];
        iPossibilitiesLeftFront = new byte[15][15];
        iPossibilitiesRightFront = new byte[15][15];
        iPossibilities = new byte[15][15];
        bHlpArr = new byte[15][15];
        iPlayerWeights = new int[15][15];
        iMaxWeights = new int[3][2];
        iVecP = new int[2];
        iVecI = new int[2];
        GKSpeed = 10;
        myTeam = null;
        otherTeam = null;
        tmpPlayer = null;
        iIndex = 0;
        iVec = new int[2];
        iPredictedPos = new int[2];
        bPlayerIsGoingForBall = false;
    }
}

