/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic.spf;

import simple.core.Application;
import simple.input.Keys;
import simple.scene.Sprite;
import simple.video.Graphics;
import sk.inlogic.spf.Ball;
import sk.inlogic.spf.Common;
import sk.inlogic.spf.FootbalTeam;
import sk.inlogic.spf.FootballTeamAI;
import sk.inlogic.spf.Globals;
import sk.inlogic.spf.Pitch;
import sk.inlogic.spf.Resources;
import sk.inlogic.spf.ScreenGame;
import sk.inlogic.spf.ScreenTutorial;
import sk.inlogic.spf.Vectors;

public class FootbalPlayer {
    public static final int FACING_TOP = 0;
    public static final int FACING_LEFT = 1;
    public static final int FACING_BOTTOM = 2;
    public static final int FACING_RIGHT = 3;
    public static final int FACE_DIFFY = 5;
    private Sprite pSprPlayerFace = null;
    private int iFaceType = 0;
    private int iAngle = -1;
    private FootbalTeam team;
    private FootbalPlayer fbForPass;
    private int iPlayerX;
    private int iPlayerY;
    private int iTmpPlayerX;
    private int iTmpPlayerY;
    private int iTargetX;
    private int iTargetY;
    private int targetX = -1;
    private int targetY = -1;
    private int iSpeed = 0;
    private int iPlayerFrame;
    private int iPlayerFrameNew;
    private int iVecX;
    private int iVecY;
    private int iPlayerNumero;
    private int role;
    private boolean bHasBall;
    private int defensePosQuad;
    private int offensePosQuad;
    private int kickOffPosQuad;
    private int iRadius;
    private int iCurrentPosInArr;
    private boolean isPassingTarget;
    private boolean bCanCatchBall = true;
    private int iCatchCounter;
    private int iMaxCatchTime = 10;
    private int iPosInTeamArray = 0;
    private int iActualGridX;
    private int iActualGridY;
    private boolean bPlayerIsCenter = false;
    private int iHlpPosX;
    private int iHlpPosY;
    private int iVecSpeedX;
    private int iVecSpeedY;
    private boolean isLeftSide;
    private boolean isRightSide;
    private boolean isShooting;
    private int iShootCounter;
    private int iShootPower;
    private int iShootClip = 0;
    private boolean bIsSelected = false;
    private boolean isOnTarget = false;
    private boolean bTackling = false;
    private int[] iTackleVec = new int[2];
    private boolean bDisableMove = false;
    private boolean bIsThrowing = false;
    private int iSide = 0;
    private boolean bIsTargetForPassing = false;
    private static boolean bKeyIsPressed = false;
    private boolean bBallWasKicked = false;
    private boolean bFollowingBall = false;
    private boolean bActivePlayer = false;
    private boolean bMove = false;
    int iDirrAngle = 0;
    int iDirrX = 0;
    int iDirrY = 0;
    int[] iVec = new int[2];
    int iActualAngle = 0;
    int iAngleDiff = 0;
    private int iHlpAngle = 0;
    private int iDistance;
    private boolean bShooting = false;
    public static int[] iNormVec = new int[2];
    private int iIndicatorLength;
    static final int MAX_POWER = 90;
    static final int MIN_POWER = 10;
    int[] iVector = new int[2];
    private int iTackleSpeed;
    private int iTacklePosX;
    private int iTacklePosY;
    private Ball tackleBall;
    int iAddingSpeed;
    int iGKSpeed;
    int iFaceFrame = 0;
    boolean bSwitch = false;
    static final int LEFT_JUMP = 1;
    static final int RIGHT_JUMP = 2;
    int bSideOfJump = 0;
    int iJumpFrame = 0;
    int iSideOfTeam;
    int iTeam;
    int iPaintX;
    int iPaintY;
    int iTacklingFrame = 0;
    int iFaceDiffY = 0;
    int iFaceDiffX = 0;
    int iFaceStepY = 0;
    int iSlideFrame = 1;
    int iSlideAngle = 0;
    public static final int STATUS_WAITING = 0;
    public static final int STATUS_FOLLOWING_PLAYER = 1;
    public static final int STATUS_FOLLOWING_BALL = 2;
    public static final int STATUS_HOLDING_PLAYER = 3;
    public static final int STATUS_RETURNING = 4;
    public static final int STATUS_RUSHING = 5;
    public static final int STATUS_FALLBACK = 6;
    public static final int STATUS_FOLLOW_POINT = 7;
    public static final int STATUS_ATTACKING = 8;
    private int iState = 0;
    private boolean bPrecision = false;

    public boolean isFollowingBall() {
        return this.bFollowingBall;
    }

    public void followingBall(boolean b) {
        this.bFollowingBall = b;
    }

    public void ballWasKicked() {
        this.bBallWasKicked = true;
    }

    public boolean wasBallKicked() {
        return this.bBallWasKicked;
    }

    public void resteKickedStatus() {
        this.bBallWasKicked = false;
    }

    public static void keyPress() {
        bKeyIsPressed = true;
    }

    public static void keyRelease() {
        bKeyIsPressed = false;
    }

    public FootbalPlayer(int idx, int iNumber, int role, FootbalTeam team) {
        this.role = role;
        this.iPosInTeamArray = idx;
        this.iPlayerNumero = iNumber;
        this.team = team;
        this.iRadius = Resources.pSprPlayerW;
        this.setVarsByRole(role);
        this.bHasBall = false;
        this.isPassingTarget = false;
        this.bCanCatchBall = true;
        this.isShooting = false;
        this.resetCatchState();
        int iHairStyle = Common.getRandomUInt(3) + 1;
        if (this.isGK()) {
            this.iFaceType = 0;
            this.pSprPlayerFace = Resources.pSprFace0;
        } else if (iHairStyle == 0) {
            this.iFaceType = 0;
            this.pSprPlayerFace = Resources.pSprFace0;
        } else if (iHairStyle == 1) {
            this.iFaceType = 1;
            this.pSprPlayerFace = Resources.pSprFace1;
        } else if (iHairStyle == 2) {
            this.iFaceType = 2;
            this.pSprPlayerFace = Resources.pSprFace2;
        } else if (iHairStyle == 3) {
            this.iFaceType = 3;
            this.pSprPlayerFace = Resources.pSprFace3;
        }
    }

    public void setVarsByRole(int iRole) {
        if (this.team == null) {
            return;
        }
        this.role = iRole;
        this.offensePosQuad = Pitch.getAttQuadByPos(this.team.getSideOfTeam(), this.role);
        this.defensePosQuad = Pitch.getDefQuadByPos(this.team.getSideOfTeam(), this.role);
        this.kickOffPosQuad = Pitch.getKickOffQuadByPos(this.team.getSideOfTeam(), this.role);
        this.iPlayerX = Pitch.getPosXByQuad(this.defensePosQuad);
        this.iPlayerY = Pitch.getPosYByQuad(this.defensePosQuad);
        this.iActualGridX = this.iPlayerX / 60;
        this.iActualGridY = this.iPlayerY / 88;
        this.iTmpPlayerX = this.iPlayerX << 10;
        this.iTmpPlayerY = this.iPlayerY << 10;
        if (this.team.getSideOfTeam() == 4) {
            this.iVecX = 0;
            this.iVecY = 256;
        } else {
            this.iVecX = 0;
            this.iVecY = -256;
        }
        this.countAngle();
        this.iDirrAngle = this.team.getTeamSide() == 0 ? 90 : 270;
        this.isLeftSide = FootbalPlayer.isLeftSide(this.role);
        this.isRightSide = FootbalPlayer.isRightSide(this.role);
        this.bPlayerIsCenter = this.isInMiddle(this.role);
    }

    public void prepareKickOffPos() {
        this.iPlayerX = Pitch.getPosXByQuad(this.kickOffPosQuad);
        this.iPlayerY = Pitch.getPosYByQuad(this.kickOffPosQuad);
        this.iActualGridX = this.getPosX() / 60;
        this.iActualGridY = this.getPosY() / 88;
        this.iTmpPlayerX = this.iPlayerX << 10;
        this.iTmpPlayerY = this.iPlayerY << 10;
        if (this.team.getSideOfTeam() == 4) {
            this.iVecX = 0;
            this.iVecY = -256;
        } else {
            this.iVecX = 0;
            this.iVecY = 256;
        }
        this.countAngle();
        if (this.team.getSideOfTeam() == 4) {
            this.iDirrAngle = 270;
            this.iAngle = 270;
        } else {
            this.iDirrAngle = 90;
            this.iAngle = 90;
        }
    }

    public void setPosition(int x, int y) {
        this.iPlayerX = x;
        this.iPlayerY = y;
        this.iActualGridX = this.getPosX() / 60;
        this.iActualGridY = this.getPosY() / 88;
        this.iTmpPlayerX = this.iPlayerX << 10;
        this.iTmpPlayerY = this.iPlayerY << 10;
        if (this.team.getSideOfTeam() == 4) {
            this.iVecX = 0;
            this.iVecY = 256;
        } else {
            this.iVecX = 0;
            this.iVecY = -256;
        }
        this.countAngle();
    }

    public boolean isLeftSide() {
        return this.isLeftSide;
    }

    public boolean isRightSide() {
        return this.isRightSide;
    }

    public void countAngle() {
        this.iAngle = Common.atan(this.iVecY, this.iVecX);
    }

    public int getFacing() {
        if (this.iAngle >= 225 && this.iAngle < 315) {
            return 0;
        }
        if (this.iAngle >= 315 || this.iAngle < 45) {
            return 3;
        }
        if (this.iAngle >= 45 && this.iAngle < 135) {
            return 2;
        }
        return 1;
    }

    public boolean isShooting() {
        return this.isShooting;
    }

    public void setShooting(boolean b) {
        this.isShooting = b;
    }

    public boolean isFacingTop() {
        return this.getFacing() == 0;
    }

    public boolean isFacingRight() {
        return this.getFacing() == 3;
    }

    public boolean isFacingBottom() {
        return this.getFacing() == 2;
    }

    public boolean isFacingLeft() {
        return this.getFacing() == 1;
    }

    public boolean isPassingTarget() {
        return this.isPassingTarget;
    }

    public void setIsPassingTarget(boolean b) {
        this.isPassingTarget = b;
    }

    public void disableFolowingStat() {
        this.isPassingTarget = false;
    }

    public void setCanCatch(boolean b) {
        if (!b) {
            this.resetCatchState();
        }
        this.bCanCatchBall = b;
    }

    public boolean bCanCatchBall() {
        return this.bCanCatchBall;
    }

    public int getAngle() {
        return this.iDirrAngle;
    }

    public int getDefensePosQuad() {
        return this.defensePosQuad;
    }

    public int getOffensePosQuad() {
        return this.offensePosQuad;
    }

    public int getCurrentQuad() {
        return Pitch.getQuadByIdXY(this.iActualGridX, this.iActualGridY);
    }

    public void setHasBall(boolean b) {
        this.bHasBall = b;
    }

    public boolean hasBall() {
        return this.bHasBall;
    }

    public int getRole() {
        return this.role;
    }

    public FootbalTeam getTeam() {
        return this.team;
    }

    public int getActualGridX() {
        return this.iActualGridX;
    }

    public int getActualGridY() {
        return this.iActualGridY;
    }

    public int getPosX() {
        return this.iPlayerX;
    }

    public int getPosY() {
        return this.iPlayerY;
    }

    public int getFrame() {
        return this.iPlayerFrame >> 1;
    }

    public int getNumber() {
        return this.iPlayerNumero;
    }

    public int getVectorX() {
        return this.iVecX;
    }

    public int getVectorY() {
        return this.iVecY;
    }

    public boolean isActive() {
        return this.bActivePlayer;
    }

    public void setActive() {
        this.setInitialParams();
        this.bActivePlayer = true;
    }

    public void setPassive() {
        this.bActivePlayer = false;
    }

    public int getPosInArray() {
        return this.iPosInTeamArray;
    }

    public boolean isThreatened() {
        if (!this.hasBall()) {
            return false;
        }
        FootbalTeam theirTeam = ScreenGame.getPitch().getTeam1() == this.getTeam() ? ScreenGame.getPitch().getTeam2() : ScreenGame.getPitch().getTeam1();
        for (int i = 0; i < 11; ++i) {
            FootbalPlayer p = theirTeam.getPlayer(i);
            if (this.getTeam().getSideOfTeam() == 2 && p.getPosY() < this.getPosY() || this.getTeam().getSideOfTeam() == 4 && p.getPosY() > this.getPosY() || Common.getManhattanDis(this.getActualGridX(), this.getActualGridY(), p.getActualGridX(), p.getActualGridY()) >= 2) continue;
            return true;
        }
        return false;
    }

    public void setInitialParams() {
        if (ScreenGame.getPitch() != null) {
            Common.getVector(this.iVector, this.getPosX(), this.getPosY(), ScreenGame.getPitch().getBall().getBallX(), ScreenGame.getPitch().getBall().getBallY());
            this.iAngle = Common.atan(this.iVector[1], this.iVector[0]);
        }
        this.iDirrAngle = this.iAngle;
        this.bMove = !this.isGK();
    }

    public void stopActivePlayer() {
        this.bMove = false;
    }

    public boolean isMoving() {
        return this.bMove;
    }

    public void updatePlayer() {
        if (this.bTackling) {
            return;
        }
        Vectors.getVec(this.iVec, this.iDirrAngle);
        this.iVecX = this.iVec[0];
        this.iVecY = this.iVec[1];
        if (Resources.bUseJoystick) {
            this.bMove = false;
            if (Resources.joyStickActive()) {
                this.iVecX = Resources.iJoysticVecX;
                this.iVecY = Resources.iJoysticVecY;
                this.iDirrAngle = Math.abs(Common.atan(this.iVecY, this.iVecX));
                this.bMove = true;
            }
        }
    }

    public void getVectorByAngle(int angle) {
        this.iDirrX = this.iPlayerX + (Common.COS(angle) << 3 >> 8);
        this.iDirrY = this.iPlayerY + (Common.SIN(angle) << 3 >> 8);
        Common.getNormVector(this.iVec, this.iPlayerX, this.iPlayerY, this.iDirrX, this.iDirrY);
        this.iVecX = this.iVec[0];
        this.iVecY = this.iVec[1];
    }

    public void turnLeft(int angle) {
        this.iDirrAngle -= angle;
        this.iDirrAngle %= 360;
        this.getVectorByAngle(this.iDirrAngle);
    }

    public void turnRight(int angle) {
        this.iDirrAngle += angle;
        this.iDirrAngle %= 360;
        this.getVectorByAngle(this.iDirrAngle);
    }

    public void updateState(boolean bIgnoreBall) {
        if (this.isFollowingBall()) {
            return;
        }
        FootballTeamAI.recalculateWeights(this, true, bIgnoreBall);
    }

    public void resetCatchState() {
        this.iCatchCounter = 0;
    }

    public void update() {
        if (this.tackling()) {
            return;
        }
        this.updateCatchingState();
        if (!this.bActivePlayer) {
            this.iActualAngle = this.iAngle;
            this.iSpeed = 0;
            int[] iVec = ScreenGame.getPitch() != null ? this.updateVec(this) : null;
            if (iVec == null) {
                this.isOnTarget = true;
            } else {
                this.iVecX = iVec[0];
                this.iVecY = iVec[1];
                this.isOnTarget = false;
                this.bMove = true;
            }
            this.countAngle();
            if (this.hasBall() && (this.iAngleDiff = Math.abs(this.iActualAngle - this.iAngle)) > 30 && !this.isGK()) {
                if (this.iActualAngle > this.iAngle && this.iAngleDiff < 180) {
                    this.turnLeft(10);
                } else {
                    this.turnRight(10);
                }
            }
        } else {
            Keys pKeys = Application.getSingleton().getDevice().getKeys();
            if (pKeys.isKeyPressed(54) || pKeys.isKeyPressed(5)) {
                this.updatePlayerRight();
            }
            if (pKeys.isKeyPressed(52) || pKeys.isKeyPressed(2)) {
                this.updatePlayerLeft();
            }
            if (Resources.isLeft()) {
                this.updatePlayerLeft();
            }
            if (Resources.isRight()) {
                this.updatePlayerRight();
            }
            if (ScreenGame.getPitch() != null) {
                if (Resources.isUp()) {
                    this.bMove = true;
                }
                if (Resources.isDown()) {
                    this.bMove = false;
                }
                if ((pKeys.isKeyPressed(56) || pKeys.isKeyPressed(6)) && ScreenGame.iMode == 2) {
                    this.bMove = false;
                }
                if ((pKeys.isKeyPressed(50) || pKeys.isKeyPressed(1)) && ScreenGame.iMode == 2) {
                    this.bMove = true;
                }
                if (this.isActive() && this.isGK()) {
                    this.bMove = false;
                }
            } else {
                if (Resources.isUp()) {
                    this.bMove = true;
                }
                if (Resources.isDown()) {
                    this.bMove = false;
                }
                if (pKeys.isKeyPressed(56) || pKeys.isKeyPressed(6)) {
                    this.bMove = false;
                }
                if (pKeys.isKeyPressed(50) || pKeys.isKeyPressed(1)) {
                    this.bMove = true;
                }
            }
            if (this.team.getPitch() != null) {
                if ((ScreenGame.bHasBeenReleased || Resources.hasBeenReleased()) && this.bShooting) {
                    Resources.resetRelease();
                    this.passBall(false);
                    ScreenGame.bHasBeenReleased = false;
                    this.bShooting = false;
                    ScreenGame.bCanStartGame = true;
                }
                this.fbForPass = this.updatePlayerForPass();
            } else if (ScreenTutorial.bHasBeenReleased && this.bShooting) {
                Resources.resetRelease();
                this.passBall(false);
                ScreenTutorial.bHasBeenReleased = false;
                this.bShooting = false;
            }
            this.updatePlayer();
        }
        this.updateShooting();
        this.playerMove();
        this.countAngle();
        this.iActualGridX = this.getPosX() / 60;
        this.iActualGridY = this.getPosY() / 88;
    }

    public int[] updateVec(FootbalPlayer fbp) {
        int x = fbp.getTargetX();
        int y = fbp.getTargetY();
        if (this.bPrecision ? Math.abs(x - fbp.getPosX()) < Resources.iBallW >> 1 && Math.abs(y - fbp.getPosY()) < Resources.iBallW >> 1 : Math.abs(x - fbp.getPosX()) < Resources.iBallW && Math.abs(y - fbp.getPosY()) < Resources.iBallW) {
            return null;
        }
        return Common.getNormVector(iNormVec, fbp.getPosX(), fbp.getPosY(), x, y);
    }

    public boolean isNearTackling(Ball ball) {
        if (ball.getOwner() == null) {
            return false;
        }
        if (this.getTeam() == ball.getOwner().getTeam()) {
            return false;
        }
        this.iDistance = Common.sizeofVector(this.getPosX(), this.getPosY(), ball.getOwner().getPosX(), ball.getOwner().getPosY());
        return this.iDistance > Resources.pSprPlayerW && this.iDistance < Resources.pSprPlayerW << 2;
    }

    private void updatePlayerLeft() {
        if (!this.bIsThrowing) {
            this.iDirrAngle -= 10;
            if (this.iDirrAngle <= 0) {
                this.iDirrAngle = 350;
            }
        } else {
            this.iDirrAngle -= 10;
            this.iHlpAngle -= 10;
            if (this.iDirrAngle <= 0) {
                this.iDirrAngle = 350;
            }
            if (this.iSide == 0) {
                if (this.iHlpAngle <= -90) {
                    this.iHlpAngle = -90;
                    this.iDirrAngle = 270;
                }
            } else if (this.iHlpAngle <= -90) {
                this.iHlpAngle = -90;
                this.iDirrAngle = 90;
            }
        }
    }

    private void updatePlayerRight() {
        if (!this.bIsThrowing) {
            this.iDirrAngle += 10;
            if (this.iDirrAngle >= 360) {
                this.iDirrAngle = 0;
            }
        } else {
            this.iDirrAngle += 10;
            this.iHlpAngle += 10;
            if (this.iDirrAngle >= 360) {
                this.iDirrAngle = 0;
            }
            if (this.iSide == 0) {
                if (this.iHlpAngle >= 90) {
                    this.iDirrAngle = 90;
                    this.iHlpAngle = 90;
                }
            } else if (this.iHlpAngle >= 90) {
                this.iDirrAngle = 270;
                this.iHlpAngle = 90;
            }
        }
    }

    public void pressButton1() {
        if (ScreenGame.getPitch() != null) {
            if (this.hasBall()) {
                this.setPowerForPassAndPass();
            } else {
                ScreenGame.getPitch().swapPlayers();
            }
        } else if (this.hasBall()) {
            ScreenTutorial.bHasBeenReleased = false;
            this.bShooting = true;
        } else {
            if (ScreenTutorial.ball == null) {
                return;
            }
            if (ScreenTutorial.ball.getOwner() != null && ScreenTutorial.ball.getOwner().getTeam() == this.getTeam()) {
                ScreenTutorial.swapPlayer();
            }
        }
    }

    public void pressButton2() {
        if (ScreenGame.getPitch() != null) {
            if (this.hasBall()) {
                ScreenGame.bHasBeenReleased = false;
                Resources.resetRelease();
                this.bShooting = true;
            } else if (this.isNearTackling(this.team.getPitch().getBall()) && this.team.getPitch().getBall().hasOwner()) {
                this.tackle(ScreenGame.getPitch().getBall());
            }
        } else if (this.hasBall()) {
            ScreenTutorial.bHasBeenReleased = false;
            this.bShooting = true;
        } else if (this.isNearTackling(ScreenTutorial.ball) && ScreenTutorial.ball.hasOwner()) {
            this.tackle(ScreenTutorial.ball);
        }
    }

    public void executeByPress() {
        if (ScreenGame.getPitch() != null) {
            if (this.hasBall()) {
                ScreenGame.bHasBeenReleased = false;
                Resources.resetRelease();
                this.bShooting = true;
            } else if (this.isNearTackling(this.team.getPitch().getBall())) {
                if (this.team.getPitch().getBall().hasOwner()) {
                    this.tackle(ScreenGame.getPitch().getBall());
                }
            } else {
                ScreenGame.getPitch().swapPlayers();
            }
        } else if (this.hasBall()) {
            ScreenTutorial.bHasBeenReleased = false;
            this.bShooting = true;
        } else if (this.isNearTackling(ScreenTutorial.ball)) {
            if (ScreenTutorial.ball.hasOwner()) {
                this.tackle(ScreenTutorial.ball);
            }
        } else {
            if (ScreenTutorial.ball == null) {
                return;
            }
            if (ScreenTutorial.ball.getOwner() != null && ScreenTutorial.ball.getOwner().getTeam() == this.getTeam()) {
                ScreenTutorial.swapPlayer();
            }
        }
    }

    private void updateShooting() {
        if (!this.bShooting) {
            return;
        }
        if (this.hasBall()) {
            this.iIndicatorLength = Resources.iPowerW;
            if (ScreenGame.getPitch() != null && ScreenGame.iMode == 9) {
                this.iIndicatorLength = Resources.iHalfPower;
            }
            if ((this.iShootClip += 3) >= this.iIndicatorLength) {
                this.iShootClip = this.iIndicatorLength;
                if (++this.iShootCounter < 5) {
                    return;
                }
                this.iShootClip = 0;
                this.iShootCounter = 0;
            }
        }
    }

    public void setIsTargetForPassing() {
        this.bIsTargetForPassing = true;
    }

    public void disableIsTargetForPassing() {
        this.bIsTargetForPassing = false;
    }

    public void paintPlayerAngle(Graphics g, int iScrollX, int iScrollY) {
    }

    public FootbalPlayer updatePlayerForPass() {
        FootbalPlayer fb = null;
        int iMaxAngle = this.iDirrAngle + 35;
        int iMinAngle = this.iDirrAngle - 35;
        int iLastAngle = 22;
        int iNewAngle = 0;
        for (int i = 9; i >= 0; --i) {
            this.getTeam().getPlayer(i).disableIsTargetForPassing();
            if (this.getTeam().getPlayer(i) == this) continue;
            Common.getVector(this.iVector, this.getPosX(), this.getPosY(), this.getTeam().getPlayer(i).getPosX(), this.getTeam().getPlayer(i).getPosY());
            this.iAngle = Common.atan(this.iVector[1], this.iVector[0]);
            if (iMinAngle < this.iAngle && iMaxAngle > this.iAngle && iLastAngle > (iNewAngle = Math.abs(this.iDirrAngle - this.iAngle))) {
                iLastAngle = iNewAngle;
                fb = this.getTeam().getPlayer(i);
            }
            if (fb == null || !this.hasBall()) continue;
            fb.setIsTargetForPassing();
        }
        return fb;
    }

    public boolean isPlayerForPass(FootbalPlayer fbp) {
        int iMaxAngle = this.iDirrAngle + 35;
        int iMinAngle = this.iDirrAngle - 35;
        if (fbp == this) {
            return false;
        }
        Common.getVector(this.iVector, this.getPosX(), this.getPosY(), fbp.getPosX(), fbp.getPosY());
        int iTestAngle = Common.atan(this.iVector[1], this.iVector[0]);
        return iMinAngle < iTestAngle && iMaxAngle > iTestAngle;
    }

    public void updateCatchingState() {
        if (this.bCanCatchBall) {
            return;
        }
        if (++this.iCatchCounter >= this.iMaxCatchTime) {
            this.bCanCatchBall = true;
        }
    }

    public boolean isTackling() {
        return this.bTackling;
    }

    public void tackle(FootbalPlayer fb) {
        this.iTacklingFrame = 0;
        this.bTackling = true;
        this.iTackleSpeed = 40;
        Common.getNormVector(this.iTackleVec, this.getPosX(), this.getPosY(), fb.getPosX(), fb.getPosY());
        this.iAngle = Common.atan(this.iTackleVec[1], this.iTackleVec[0]);
        this.iVecX = this.iTackleVec[0];
        this.iVecY = this.iTackleVec[1];
        this.iTacklePosX = fb.getPosX();
        this.iTacklePosY = fb.getPosY();
    }

    public void tackle(Ball ball) {
        this.iTacklingFrame = 0;
        this.bTackling = true;
        this.iTackleSpeed = 40;
        Common.getNormVector(this.iTackleVec, this.getPosX(), this.getPosY(), ball.getBallX(), ball.getBallY());
        this.iAngle = Common.atan(this.iTackleVec[1], this.iTackleVec[0]);
        this.iVecX = this.iTackleVec[0];
        this.iVecY = this.iTackleVec[1];
        this.iTacklePosX = ball.getBallX();
        this.iTacklePosY = ball.getBallY();
        this.tackleBall = ball;
    }

    public boolean tackling() {
        if (!this.bTackling) {
            return false;
        }
        this.iTmpPlayerX += this.iVecX * this.iTackleSpeed;
        this.iTmpPlayerY += this.iVecY * this.iTackleSpeed;
        this.iPlayerX = this.iTmpPlayerX >> 10;
        this.iPlayerY = this.iTmpPlayerY >> 10;
        if (Math.abs(this.iPlayerX - this.iTacklePosX) < 6 && Math.abs(this.iPlayerY - this.iTacklePosY) < 6) {
            if (this.tackleBall.hasOwner() && Math.abs(this.getPosX() - this.tackleBall.getOwner().getPosX()) < 10 && Math.abs(this.getPosY() - this.tackleBall.getOwner().getPosY()) < 10) {
                this.tackleBall.getOwner().setHasBall(false);
                this.tackleBall.lostBall();
                this.tackleBall.addBallToPlayer(this);
            }
            this.iVecX = this.iTackleVec[0];
            this.iVecY = this.iTackleVec[1];
            this.iDirrAngle = this.iAngle;
            this.tackleBall = null;
            this.bTackling = false;
        }
        if ((this.iTackleSpeed -= 2) <= 0) {
            this.iVecX = this.iTackleVec[0];
            this.iVecY = this.iTackleVec[1];
            this.iDirrAngle = this.iAngle;
            this.tackleBall = null;
            this.bTackling = false;
        }
        if (this.iTackleSpeed <= 38) {
            this.iTacklingFrame = 1;
        }
        return true;
    }

    public boolean paintTackling(Graphics g, int iScrollX, int iScrollY) {
        if (!this.bTackling) {
            return false;
        }
        Resources.pSprSlide.setHorizontalFlip(false);
        this.bSwitch = false;
        if (this.iAngle >= 245 && this.iAngle < 290) {
            Resources.pSprSlide = this.team.getTeamSide() == 0 ? Resources.pSprSlideU : Resources.pSprSlideU2;
            this.iFaceFrame = 4;
        } else if (this.iAngle >= 290 && this.iAngle < 335) {
            Resources.pSprSlide = this.team.getTeamSide() == 0 ? Resources.pSprSlideRU : Resources.pSprSlideRU2;
            this.iFaceFrame = 3;
        } else if (this.iAngle >= 335 && this.iAngle <= 360 || this.iAngle >= 0 && this.iAngle < 20) {
            Resources.pSprSlide = this.team.getTeamSide() == 0 ? Resources.pSprSlideR : Resources.pSprSlideR2;
            this.iFaceFrame = 2;
        } else if (this.iAngle >= 20 && this.iAngle < 65) {
            Resources.pSprSlide = this.team.getTeamSide() == 0 ? Resources.pSprSlideRD : Resources.pSprSlideRD2;
            this.iFaceFrame = 1;
        } else if (this.iAngle >= 65 && this.iAngle < 110) {
            Resources.pSprSlide = this.team.getTeamSide() == 0 ? Resources.pSprSlideD : Resources.pSprSlideD2;
            this.iFaceFrame = 0;
        } else if (this.iAngle >= 110 && this.iAngle < 155) {
            Resources.pSprSlide = this.team.getTeamSide() == 0 ? Resources.pSprSlideRD : Resources.pSprSlideRD2;
            Resources.pSprSlide.setHorizontalFlip(true);
            this.bSwitch = true;
            this.iFaceFrame = 1;
        } else if (this.iAngle >= 155 && this.iAngle < 200) {
            Resources.pSprSlide = this.team.getTeamSide() == 0 ? Resources.pSprSlideR : Resources.pSprSlideR2;
            Resources.pSprSlide.setHorizontalFlip(true);
            this.bSwitch = true;
            this.iFaceFrame = 2;
        } else if (this.iAngle >= 200 && this.iAngle < 245) {
            Resources.pSprSlide = this.team.getTeamSide() == 0 ? Resources.pSprSlideRU : Resources.pSprSlideRU2;
            Resources.pSprSlide.setHorizontalFlip(true);
            this.bSwitch = true;
            this.iFaceFrame = 3;
        }
        Resources.pSprSlide.setFrame(this.iTacklingFrame);
        Resources.pSprSlide.setPosition(this.getPosX() - iScrollX - Resources.pSprPlayerW2, this.getPosY() - iScrollY - Resources.pSprPlayerH);
        Resources.pSprSlide.paint(g);
        this.paintFace(g, iScrollX, iScrollY);
        return true;
    }

    public void setGKSpeed(int iSpd) {
        this.iGKSpeed = iSpd;
    }

    public void playerMove() {
        this.iAddingSpeed = this.team.getTeamSide() == 0 ? Globals.iPlayerTeamProperties[0] : Globals.iEnemyTeamProperties[0];
        this.iSpeed = 0;
        if (!this.bMove) {
            return;
        }
        if (this.isOnTarget && !this.isActive()) {
            return;
        }
        if (this.bDisableMove) {
            return;
        }
        if (this.iPlayerFrame++ > 4) {
            this.iPlayerFrame = 0;
        }
        if (++this.iPlayerFrameNew > 11) {
            this.iPlayerFrameNew = 0;
        }
        this.iFaceStepY = 0;
        if (this.iPlayerFrameNew >> 1 == 2) {
            this.iFaceStepY = -2;
        }
        if (this.iPlayerFrameNew >> 1 == 5) {
            this.iFaceStepY = -1;
        }
        this.iSpeed = 10 + this.iAddingSpeed;
        if (this.isPassingTarget) {
            this.iSpeed = 25;
        }
        if (this.isGK()) {
            this.iSpeed = this.iGKSpeed;
        }
        if (ScreenGame.getPitch() != null && this.hasBall()) {
            this.iSpeed = this.getTeam() == ScreenGame.getPitch().getTeam1() ? ScreenGame.iSpeedWithBall + this.iAddingSpeed : ScreenGame.iSpeedWithBallE + this.iAddingSpeed;
        }
        this.iVecSpeedX = this.iVecX * this.iSpeed;
        this.iVecSpeedY = this.iVecY * this.iSpeed;
        this.iHlpPosX = this.iTmpPlayerX + this.iVecSpeedX;
        this.iHlpPosY = this.iTmpPlayerY + this.iVecSpeedY;
        if (ScreenGame.getPitch() != null) {
            if (this.iHlpPosX >> 10 > -Resources.iAdH && this.iHlpPosX >> 10 < 900 + Resources.iAdH) {
                this.iTmpPlayerX += this.iVecSpeedX;
                this.iPlayerX = this.iTmpPlayerX >> 10;
            }
            if (this.iHlpPosY >> 10 > -Resources.iAdH + 10 && this.iHlpPosY >> 10 < 1320 + Resources.iAdH + 10) {
                this.iTmpPlayerY += this.iVecSpeedY;
                this.iPlayerY = this.iTmpPlayerY >> 10;
            }
        } else {
            if (this.iHlpPosX >> 10 > 0 && this.iHlpPosX >> 10 < Resources.WIDTH) {
                this.iTmpPlayerX += this.iVecSpeedX;
                this.iPlayerX = this.iTmpPlayerX >> 10;
            }
            if (this.iHlpPosY >> 10 >= Resources.pSprPlayerH && this.iHlpPosY >> 10 < Resources.HEIGHT) {
                this.iTmpPlayerY += this.iVecSpeedY;
                this.iPlayerY = this.iTmpPlayerY >> 10;
            }
        }
    }

    public boolean isOnTarget() {
        if (this.isActive()) {
            return true;
        }
        if (this.isGK()) {
            return true;
        }
        return this.isOnTarget;
    }

    public boolean isCenter() {
        return this.bPlayerIsCenter;
    }

    public void getCurrentAngle() {
    }

    public void updatePosInArr() {
        if (--this.iCurrentPosInArr < 0) {
            this.iCurrentPosInArr = 0;
        }
    }

    public boolean checkFaul() {
        return Common.getRandomUInt(100) <= 5;
    }

    public void setPowerForPassAndPass() {
        int dist = 0;
        int iMaxPower = Resources.iPowerW / 10;
        if (this.fbForPass != null) {
            dist = Common.getManhattanDis(this.getActualGridX(), this.getActualGridY(), this.fbForPass.getActualGridX(), this.fbForPass.getActualGridY());
            this.iShootClip = iMaxPower * dist;
            if (this.iShootClip < 50) {
                this.iShootClip = 50;
            }
            this.passBall(true);
        } else if (ScreenGame.getPitch() != null) {
            ScreenGame.getPitch().getBall().kick(this.iVec[0], this.iVec[1], 50);
        }
        if (ScreenGame.iMode == 8) {
            ScreenGame.bCanStartGame = true;
        }
    }

    public boolean passBall(boolean calculatePower) {
        if (!this.bHasBall) {
            return false;
        }
        if (this.isGK() && this.team.getTeamSide() == 0) {
            ScreenGame.getPitch().swapPlayers();
        }
        this.bCanCatchBall = false;
        this.resetCatchState();
        this.iShootPower = 10 + this.iShootClip * 90 / Resources.iPowerW;
        if (this.team.getPitch() != null) {
            if (this.fbForPass != null) {
                if (ScreenGame.getPitch().getBall().getPassTarget() != null) {
                    ScreenGame.getPitch().getBall().getPassTarget().setIsPassingTarget(false);
                    ScreenGame.getPitch().getBall().setPassTarget(null);
                }
                if (calculatePower) {
                    ScreenGame.getPitch().getBall().kickToPlayer(this.fbForPass, -10);
                } else {
                    ScreenGame.getPitch().getBall().kickToPlayer(this.fbForPass, this.iShootPower);
                }
                this.fbForPass.setIsPassingTarget(true);
                ScreenGame.getPitch().getBall().setPassTarget(this.fbForPass);
                this.setCanCatch(false);
            } else {
                Vectors.getVec(this.iVec, this.iDirrAngle);
                this.team.getPitch().getBall().kick(this.iVec[0], this.iVec[1], this.iShootPower);
            }
        } else if (ScreenTutorial.passingPlayer != null) {
            Common.getNormVector(this.iVec, this.getPosX(), this.getPosY(), ScreenTutorial.passingPlayer.getPosX(), ScreenTutorial.passingPlayer.getPosY());
            ScreenTutorial.ball.kick(this.iVec[0], this.iVec[1], this.iShootPower);
        } else {
            Vectors.getVec(this.iVec, this.iDirrAngle);
            ScreenTutorial.ball.kick(this.iVec[0], this.iVec[1], this.iShootPower);
        }
        this.iShootClip = 0;
        return true;
    }

    public int getPlayerSpeed() {
        return this.iSpeed;
    }

    public int getiPosX(int iScrollX, int len) {
        return this.getPosX() - iScrollX + (len * this.getVectorX() >> 8) + (Resources.pSprPlayerW >> 1) - Resources.pSprPlayerW2;
    }

    public int getiPosY(int iScrollY, int len) {
        return this.getPosY() - iScrollY + (len * this.getVectorY() >> 8) + (Resources.pSprPlayerH >> 1) - Resources.pSprPlayerH;
    }

    public int getDirPosX(int iScrollX) {
        return this.getPosX() - iScrollX + (Resources.pSprPlayerW >> 1);
    }

    public int getDirPosY(int iScrollY) {
        return this.getPosY() - iScrollY + (Resources.pSprPlayerH >> 1);
    }

    public int getAngle2() {
        return this.iAngle;
    }

    public void updateHeaing(int x, int y) {
        Common.getNormVector(this.iVec, this.getPosX(), this.getPosY(), x, y);
        this.iAngle = Common.atan(this.iVec[1], this.iVec[0]);
        this.iDirrAngle = this.iAngle / 10 * 10;
    }

    public void printHeading() {
    }

    public void jumpLeft() {
        this.iJumpFrame = 0;
        this.bSideOfJump = 1;
    }

    public void jumpRight() {
        this.iJumpFrame = 0;
        this.bSideOfJump = 2;
    }

    public boolean isJumping() {
        return this.bSideOfJump != 0;
    }

    public boolean isJumpingL() {
        return this.bSideOfJump == 1;
    }

    public boolean isJumpingR() {
        return this.bSideOfJump == 2;
    }

    public void resetJump() {
        this.bSideOfJump = 0;
    }

    private Sprite getSprite() {
        this.iTeam = this.getTeam().getTeamSide();
        this.iSideOfTeam = this.getTeam().getSideOfTeam();
        if (this.iSideOfTeam == 4) {
            this.iFaceFrame = 4;
            if (this.iTeam == 0) {
                return Resources.pSprPlayer2U;
            }
            return Resources.pSprPlayerU;
        }
        this.iFaceFrame = 0;
        if (this.iTeam == 0) {
            return Resources.pSprPlayer2D;
        }
        return Resources.pSprPlayerD;
    }

    public void paintGK(Graphics g, int iScrollX, int iScrollY) {
        Resources.pSprPlayerRender = this.getSprite();
        if (ScreenGame.getPitch().getBall().hasOwner() && ScreenGame.getPitch().getBall().getOwner() == this && this.iAngle >= 179 && this.iAngle <= 359) {
            ScreenGame.getPitch().getBall().paint(-iScrollX, -iScrollY, g);
        }
        Resources.pSprPlayerRender.setFrame(this.iPlayerFrameNew >> 1);
        Resources.pSprPlayerRender.setPosition(this.getPosX() - iScrollX - Resources.pSprPlayerW2, this.getPosY() - iScrollY - Resources.pSprPlayerH);
        Resources.pSprPlayerRender.paint(g);
        this.paintFace(g, iScrollX, iScrollY);
        if (this.iAngle >= 0 && this.iAngle <= 180 && ScreenGame.getPitch().getBall().hasOwner() && ScreenGame.getPitch().getBall().getOwner() == this) {
            ScreenGame.getPitch().getBall().paint(-iScrollX, -iScrollY, g);
        }
    }

    public boolean bPaintNeed() {
        if (ScreenGame.getPitch() == null) {
            return true;
        }
        if (this.iPaintY < 0 || this.iPaintY > Resources.iPaintableRegionH) {
            return false;
        }
        return this.iPaintX >= -Resources.pSprPlayerW2 && this.iPaintX <= Resources.iPaintableRegionW;
    }

    public void paint(Graphics g, int iScrollX, int iScrollY) {
        this.iPaintX = this.getPosX() - iScrollX;
        this.iPaintY = this.getPosY() - iScrollY;
        if (!this.bPaintNeed()) {
            return;
        }
        if (this.bIsTargetForPassing) {
            this.paintSelector(g, iScrollX, iScrollY);
        }
        if (this.isGK() && !this.bActivePlayer) {
            this.paintGK(g, iScrollX, iScrollY);
            return;
        }
        if (this.painThrowing(g, iScrollX, iScrollY, this.bIsThrowing)) {
            return;
        }
        if (this.paintTackling(g, iScrollX, iScrollY)) {
            return;
        }
        this.paintBall(g, iScrollX, iScrollY, 179, 360);
        if (this.getTeam().getTeamSide() == 0) {
            this.bSwitch = false;
            if (this.iAngle > 23 && this.iAngle <= 68) {
                Resources.pSprPlayerRender = Resources.pSprPlayer2RD;
                this.iFaceFrame = 1;
            } else if (this.iAngle > 68 && this.iAngle <= 113) {
                Resources.pSprPlayerRender = Resources.pSprPlayer2D;
                this.iFaceFrame = 0;
            } else if (this.iAngle > 113 && this.iAngle <= 158) {
                Resources.pSprPlayerRender = Resources.pSprPlayer2RD;
                this.iFaceFrame = 1;
                this.bSwitch = true;
            } else if (this.iAngle > 158 && this.iAngle <= 203) {
                Resources.pSprPlayerRender = Resources.pSprPlayer2R;
                this.iFaceFrame = 2;
                this.bSwitch = true;
            } else if (this.iAngle > 203 && this.iAngle <= 248) {
                Resources.pSprPlayerRender = Resources.pSprPlayer2RU;
                this.iFaceFrame = 3;
                this.bSwitch = true;
            } else if (this.iAngle > 248 && this.iAngle <= 293) {
                Resources.pSprPlayerRender = Resources.pSprPlayer2U;
                this.iFaceFrame = 4;
            } else if (this.iAngle > 293 && this.iAngle <= 338) {
                Resources.pSprPlayerRender = Resources.pSprPlayer2RU;
                this.iFaceFrame = 3;
            } else {
                Resources.pSprPlayerRender = Resources.pSprPlayer2R;
                this.iFaceFrame = 2;
            }
            if (Resources.pSprPlayerRender != null) {
                Resources.pSprPlayerRender.setHorizontalFlip(this.bSwitch);
                Resources.pSprPlayerRender.setFrame(this.iPlayerFrameNew >> 1);
                Resources.pSprPlayerRender.setPosition(this.getPosX() - iScrollX - Resources.pSprPlayerW2, this.getPosY() - iScrollY - Resources.pSprPlayerH);
                Resources.pSprPlayerRender.paint(g);
            }
        } else {
            this.bSwitch = false;
            if (this.iAngle > 23 && this.iAngle <= 68) {
                Resources.pSprPlayerRender = Resources.pSprPlayerRD;
                this.iFaceFrame = 1;
            } else if (this.iAngle > 68 && this.iAngle <= 113) {
                Resources.pSprPlayerRender = Resources.pSprPlayerD;
                this.iFaceFrame = 0;
            } else if (this.iAngle > 113 && this.iAngle <= 158) {
                Resources.pSprPlayerRender = Resources.pSprPlayerRD;
                this.iFaceFrame = 1;
                this.bSwitch = true;
            } else if (this.iAngle > 158 && this.iAngle <= 203) {
                Resources.pSprPlayerRender = Resources.pSprPlayerR;
                this.iFaceFrame = 2;
                this.bSwitch = true;
            } else if (this.iAngle > 203 && this.iAngle <= 248) {
                Resources.pSprPlayerRender = Resources.pSprPlayerRU;
                this.iFaceFrame = 3;
                this.bSwitch = true;
            } else if (this.iAngle > 248 && this.iAngle <= 293) {
                Resources.pSprPlayerRender = Resources.pSprPlayerU;
                this.iFaceFrame = 4;
            } else if (this.iAngle > 293 && this.iAngle <= 338) {
                Resources.pSprPlayerRender = Resources.pSprPlayerRU;
                this.iFaceFrame = 3;
            } else {
                Resources.pSprPlayerRender = Resources.pSprPlayerR;
                this.iFaceFrame = 2;
            }
            if (Resources.pSprPlayerRender != null) {
                Resources.pSprPlayerRender.setHorizontalFlip(this.bSwitch);
                Resources.pSprPlayerRender.setFrame(this.iPlayerFrameNew >> 1);
                Resources.pSprPlayerRender.setPosition(this.getPosX() - iScrollX - Resources.pSprPlayerW2, this.getPosY() - iScrollY - Resources.pSprPlayerH);
                Resources.pSprPlayerRender.paint(g);
            }
        }
        this.paintBall(g, iScrollX, iScrollY, 0, 180);
        if (ScreenGame.getPitch() != null && this.iAngle >= 0 && this.iAngle <= 180 && ScreenGame.getPitch().getBall().hasOwner() && ScreenGame.getPitch().getBall().getOwner() == this) {
            ScreenGame.getPitch().getBall().paint(-iScrollX, -iScrollY, g);
        }
        if (this.bIsSelected) {
            g.setColor(0xFFFF00);
            g.drawRect(this.getPosX() - iScrollX - Resources.pSprPlayerW2, this.getPosY() - iScrollY - Resources.pSprPlayerH, Resources.pSprPlayerW, Resources.pSprPlayerH);
        }
        this.paintFace(g, iScrollX, iScrollY);
        if (this.isActive()) {
            this.paintPlayerAngle(g, iScrollX, iScrollY);
        }
    }

    public void paintBall(Graphics g, int iScrollX, int iScrollY, int angleMin, int angleMax) {
        if (ScreenGame.getPitch() != null) {
            if (this.iAngle >= angleMin && this.iAngle <= angleMax && ScreenGame.getPitch().getBall().hasOwner() && ScreenGame.getPitch().getBall().getOwner() == this) {
                ScreenGame.getPitch().getBall().paint(-iScrollX, -iScrollY, g);
            }
        } else if (this.iAngle >= angleMin && this.iAngle <= angleMax && ScreenTutorial.ball.hasOwner() && ScreenTutorial.ball.getOwner() == this) {
            ScreenTutorial.ball.paint(-iScrollX, -iScrollY, g);
        }
    }

    public void paintFace(Graphics g, int iScrollX, int iScrollY) {
        if (this.iFaceType != 0 || this.iFaceFrame < 3) {
            this.iFaceDiffX = 0;
            if (Resources.HEIGHT <= 220) {
                if (this.iFaceType == 0) {
                    this.iFaceDiffY = -5;
                }
                if (this.iFaceType == 1) {
                    this.iFaceDiffY = 3;
                }
                if (this.iFaceType == 2) {
                    this.iFaceDiffY = 8;
                }
                if (this.iFaceType == 3) {
                    this.iFaceDiffY = 5;
                }
            } else if (Resources.HEIGHT <= 320) {
                if (this.iFaceType == 0) {
                    this.iFaceDiffY = 5;
                }
                if (this.iFaceType == 1) {
                    this.iFaceDiffY = 5;
                }
                if (this.iFaceType == 2) {
                    this.iFaceDiffY = 10;
                }
                if (this.iFaceType == 3) {
                    this.iFaceDiffY = 5;
                }
            } else if (Resources.HEIGHT <= 432) {
                if (this.iFaceType == 0) {
                    this.iFaceDiffY = 5;
                }
                if (this.iFaceType == 1) {
                    this.iFaceDiffY = 5;
                }
                if (this.iFaceType == 2) {
                    this.iFaceDiffY = 10;
                }
                if (this.iFaceType == 3) {
                    this.iFaceDiffY = 5;
                }
            } else if (Resources.HEIGHT <= 640) {
                this.iFaceDiffX = -2;
                if (this.iFaceType == 0) {
                    this.iFaceDiffY = 8;
                }
                if (this.iFaceType == 1) {
                    this.iFaceDiffY = 9;
                }
                if (this.iFaceType == 2) {
                    this.iFaceDiffY = 12;
                }
                if (this.iFaceType == 3) {
                    if (this.iFaceFrame == 2 && !this.bSwitch) {
                        this.iFaceDiffX = 0;
                    }
                    if (this.iFaceFrame == 2 && this.bSwitch) {
                        this.iFaceDiffX = -5;
                    }
                    this.iFaceDiffY = 10;
                }
            } else if (Resources.HEIGHT <= 800) {
                this.iFaceDiffX = -2;
                if (this.iFaceType == 0) {
                    this.iFaceDiffY = 8;
                }
                if (this.iFaceType == 1) {
                    this.iFaceDiffY = 9;
                }
                if (this.iFaceType == 2) {
                    this.iFaceDiffY = 12;
                }
                if (this.iFaceType == 3) {
                    if (this.iFaceFrame == 2 && !this.bSwitch) {
                        this.iFaceDiffX = 0;
                    }
                    if (this.iFaceFrame == 2 && this.bSwitch) {
                        this.iFaceDiffX = -5;
                    }
                    this.iFaceDiffY = 10;
                }
            }
            this.setSlideVars();
            this.pSprPlayerFace.setHorizontalFlip(this.bSwitch);
            this.pSprPlayerFace.setFrame(this.iFaceFrame);
            this.pSprPlayerFace.setPosition(this.getPosX() - iScrollX - Resources.pSprPlayerW2 + this.iFaceDiffX, this.getPosY() - iScrollY - Resources.pSprPlayerH - this.iFaceDiffY + this.iFaceStepY);
            this.pSprPlayerFace.paint(g);
        }
    }

    public void paintSelector(Graphics g, int iScrollX, int iScrollY) {
        if (ScreenGame.getPitch() == null) {
            return;
        }
        if (!(this.iPaintY >= 0 && this.iPaintY <= Resources.iPaintableRegionH || this.iPaintX >= -Resources.pSprPlayerW2 && this.iPaintX <= Resources.iPaintableRegionW)) {
            ScreenGame.getPitch().paintDirTriangle(g, this.getPosX(), this.getPosY(), 1);
            return;
        }
        Pitch.paintSelector(this, iScrollX, iScrollY, 1, g);
    }

    public void paintIndicator(Graphics g, int iScrollX, int iScrollY) {
        if (!this.isActive()) {
            return;
        }
        if (!this.hasBall()) {
            return;
        }
        int iBarPosX = Resources.pSprPlayerW - Resources.iPowerW >> 1;
        g.setClipRegion(this.getPosX() - iScrollX - Resources.pSprPlayerW2 + iBarPosX, this.getPosY() - iScrollY + 5, this.iShootClip, Resources.iPowerH);
        Resources.pImgPower.drawAtPoint(g, this.getPosX() - iScrollX - Resources.pSprPlayerW2 + iBarPosX, this.getPosY() - iScrollY + 5);
        g.setClipRegion(0, 0, Resources.WIDTH, Resources.HEIGHT);
    }

    public Sprite getSprite(int idxTeam, int sprite) {
        if (idxTeam == 0) {
            if (sprite == 0) {
                return Resources.pSprThrowRU1;
            }
            if (sprite == 1) {
                return Resources.pSprThrowR1;
            }
            if (sprite == 2) {
                return Resources.pSprThrowRD1;
            }
        } else {
            if (sprite == 0) {
                return Resources.pSprThrowRU2;
            }
            if (sprite == 1) {
                return Resources.pSprThrowR2;
            }
            if (sprite == 2) {
                return Resources.pSprThrowRD2;
            }
        }
        return null;
    }

    public boolean painThrowing(Graphics g, int iScrollX, int iScrollY, boolean bThrow) {
        if (!bThrow) {
            return false;
        }
        Resources.pSprPlayerRender = this.getSprite(this.getTeam().getTeamSide(), 0);
        this.bSwitch = false;
        if (this.getPosX() < 450) {
            Resources.pSprPlayerRender.setHorizontalFlip(false);
            if (this.iAngle <= 90 && this.iAngle >= 0 || this.iAngle <= 360 && this.iAngle >= 270) {
                if (this.iAngle >= 270 && this.iAngle <= 330) {
                    Resources.pSprPlayerRender = this.getSprite(this.getTeam().getTeamSide(), 0);
                    this.iFaceFrame = 3;
                } else if (this.iAngle > 330 && this.iAngle <= 360 || this.iAngle >= 0 && this.iAngle <= 30) {
                    Resources.pSprPlayerRender = this.getSprite(this.getTeam().getTeamSide(), 1);
                    this.iFaceFrame = 2;
                } else if (this.iAngle > 30 && this.iAngle <= 90) {
                    Resources.pSprPlayerRender = this.getSprite(this.getTeam().getTeamSide(), 2);
                    this.iFaceFrame = 1;
                }
                if (this.iAngle >= 270 && this.iAngle <= 330) {
                    ScreenGame.getPitch().getBall().paint(-iScrollX, -iScrollY, g);
                }
                Resources.pSprPlayerRender.setFrame(1);
                Resources.pSprPlayerRender.setPosition(this.getPosX() - iScrollX - Resources.pSprPlayerW2, this.getPosY() - iScrollY - Resources.pSprPlayerH);
                Resources.pSprPlayerRender.paint(g);
                if (this.iAngle < 270 || this.iAngle > 330) {
                    ScreenGame.getPitch().getBall().paint(-iScrollX, -iScrollY, g);
                }
            }
        } else if (this.iAngle >= 90 && this.iAngle <= 270) {
            if (this.iAngle >= 90 && this.iAngle < 150) {
                Resources.pSprPlayerRender = this.getSprite(this.getTeam().getTeamSide(), 2);
                this.iFaceFrame = 1;
            } else if (this.iAngle >= 150 && this.iAngle < 210) {
                Resources.pSprPlayerRender = this.getSprite(this.getTeam().getTeamSide(), 1);
                this.iFaceFrame = 2;
            } else if (this.iAngle >= 210 && this.iAngle <= 270) {
                Resources.pSprPlayerRender = this.getSprite(this.getTeam().getTeamSide(), 0);
                this.iFaceFrame = 3;
            }
            Resources.pSprPlayerRender.setHorizontalFlip(true);
            this.bSwitch = true;
            if (this.iAngle >= 210 && this.iAngle <= 270) {
                ScreenGame.getPitch().getBall().paint(-iScrollX, -iScrollY, g);
            }
            Resources.pSprPlayerRender.setFrame(1);
            Resources.pSprPlayerRender.setPosition(this.getPosX() - iScrollX - Resources.pSprPlayerW2, this.getPosY() - iScrollY - Resources.pSprPlayerH);
            Resources.pSprPlayerRender.paint(g);
            if (this.iAngle < 210 || this.iAngle > 270) {
                ScreenGame.getPitch().getBall().paint(-iScrollX, -iScrollY, g);
            }
        }
        this.paintFace(g, iScrollX, iScrollY);
        return true;
    }

    public boolean isTouched(int x, int y) {
        return x > this.getPosX() - Resources.pSprPlayerW2 && x < this.getPosX() - Resources.pSprPlayerW2 + Resources.pSprPlayerW && y < this.getPosY() && y > this.getPosY() - Resources.pSprPlayerH;
    }

    public void setSelected() {
        this.bIsSelected = true;
    }

    public void deselect() {
        this.bIsSelected = false;
    }

    public int getActualState() {
        return this.iState;
    }

    public void setTargetForBall(int x, int y) {
        this.targetX = x;
        this.targetY = y;
    }

    public void resetTarget() {
        this.targetX = -1;
        this.targetY = -1;
    }

    public int getTargetForBallX() {
        return this.targetX;
    }

    public int getTargetForBallY() {
        return this.targetY;
    }

    public void setTarget(int x, int y, boolean bNeedPrecision) {
        this.iTargetX = x;
        this.iTargetY = y;
        this.bPrecision = Globals.iSelectedDiff > 0 ? bNeedPrecision : false;
    }

    public int getTargetX() {
        return this.iTargetX;
    }

    public int getTargetY() {
        return this.iTargetY;
    }

    public int returnRSide() {
        return this.getPosX() + this.iRadius;
    }

    public int returnLSide() {
        return this.getPosX() - this.iRadius;
    }

    public int returnUSide() {
        return this.getPosY() + this.iRadius;
    }

    public int returnDSide() {
        return this.getPosY() - this.iRadius;
    }

    public boolean isGK() {
        return this.role == 1;
    }

    public boolean isAttacker() {
        return this.role > 21 && this.role <= 26;
    }

    public boolean isDefender() {
        return this.role > 1 && this.role < 7;
    }

    public boolean isDefMidfielder() {
        return this.role > 6 && this.role < 12;
    }

    public boolean isMidfielder() {
        return this.role > 11 && this.role < 17;
    }

    public boolean isAttMidfielder() {
        return this.role > 16 && this.role < 22;
    }

    public static boolean isLeftSide(int pos) {
        return pos == 2 || pos == 7 || pos == 12 || pos == 17 || pos == 22;
    }

    public static boolean isRightSide(int pos) {
        return pos == 6 || pos == 11 || pos == 16 || pos == 21 || pos == 26;
    }

    public int getYZoneRange() {
        if (this.isLeftSide() || this.isRightSide()) {
            return 3;
        }
        return 2;
    }

    public boolean isCloseToEnemyGoal() {
        return this.getTeam().getSideOfTeam() == 2 ? this.getActualGridY() > 11 && this.getActualGridX() > 1 && this.getActualGridX() < 13 : this.getActualGridY() < 3 && this.getActualGridX() > 1 && this.getActualGridX() < 13;
    }

    public boolean isInMiddle(int iRole) {
        switch (iRole) {
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 13: 
            case 14: 
            case 15: 
            case 18: 
            case 19: 
            case 20: 
            case 23: 
            case 24: 
            case 25: {
                return true;
            }
        }
        return false;
    }

    public int getBasePlayerWeight(FootbalPlayer ref) {
        if (this.isDefender()) {
            if (ref.isDefender()) {
                return 0;
            }
            if (ref.isDefMidfielder()) {
                return 0;
            }
            if (ref.isMidfielder()) {
                return 5;
            }
            if (ref.isAttMidfielder()) {
                return 5;
            }
            if (ref.isAttacker()) {
                return 10;
            }
            if (ref.isGK()) {
                return 0;
            }
        } else if (this.isDefMidfielder()) {
            if (ref.isDefender()) {
                return 0;
            }
            if (ref.isDefMidfielder()) {
                return 0;
            }
            if (ref.isMidfielder()) {
                return 5;
            }
            if (ref.isAttMidfielder()) {
                return 5;
            }
            if (ref.isAttacker()) {
                return 10;
            }
            if (ref.isGK()) {
                return 0;
            }
        } else if (this.isMidfielder()) {
            if (ref.isDefender()) {
                return 0;
            }
            if (ref.isDefMidfielder()) {
                return 0;
            }
            if (ref.isMidfielder()) {
                return 0;
            }
            if (ref.isAttMidfielder()) {
                return 5;
            }
            if (ref.isAttacker()) {
                return 10;
            }
            if (ref.isGK()) {
                return 0;
            }
        } else if (this.isAttMidfielder()) {
            if (ref.isDefender()) {
                return 0;
            }
            if (ref.isDefMidfielder()) {
                return 0;
            }
            if (ref.isMidfielder()) {
                return 0;
            }
            if (ref.isAttMidfielder()) {
                return 5;
            }
            if (ref.isAttacker()) {
                return 10;
            }
            if (ref.isGK()) {
                return 0;
            }
        } else if (this.isAttacker()) {
            if (ref.isDefender()) {
                return 0;
            }
            if (ref.isDefMidfielder()) {
                return 0;
            }
            if (ref.isMidfielder()) {
                return 5;
            }
            if (ref.isAttMidfielder()) {
                return 10;
            }
            if (ref.isAttacker()) {
                return 10;
            }
            if (ref.isGK()) {
                return 0;
            }
        } else if (this.isGK()) {
            if (ref.isDefender()) {
                return 0;
            }
            if (ref.isDefMidfielder()) {
                return 0;
            }
            if (ref.isMidfielder()) {
                return 5;
            }
            if (ref.isAttMidfielder()) {
                return 10;
            }
            if (ref.isAttacker()) {
                return 10;
            }
            if (ref.isGK()) {
                return 0;
            }
        }
        return 0;
    }

    public boolean isHeadingUp() {
        return this.iVecY <= 0;
    }

    public boolean isHeadingDn() {
        return this.iVecY > 0;
    }

    public boolean isOnBaseQuad() {
        if (this.bActivePlayer) {
            return true;
        }
        return this.iSpeed == 0;
    }

    public void disableMove() {
        this.bDisableMove = true;
    }

    public void enableMove() {
        this.bDisableMove = false;
    }

    public void isThrowing() {
        this.bIsThrowing = true;
        this.iSide = this.getPosX() < 450 ? 0 : 1;
        this.iHlpAngle = 0;
        if (this.iSide == 0) {
            this.iDirrAngle = 0;
            this.iAngle = 0;
        } else {
            this.iDirrAngle = 180;
            this.iAngle = 180;
        }
        Common.getNormVector(this.iVec, this.getPosX(), this.getPosY(), 450, this.getPosY());
        this.iAngle = Common.atan(this.iVec[1], this.iVec[0]);
        this.iVecX = this.iVec[0];
        this.iVecY = this.iVec[1];
        this.disableMove();
    }

    public void isPlaying() {
        this.bIsThrowing = false;
        this.enableMove();
    }

    public int getCost() {
        switch (this.role) {
            case 19: {
                return 4;
            }
            case 18: {
                return 4;
            }
            case 20: {
                return 4;
            }
            case 17: {
                return 4;
            }
            case 21: {
                return 4;
            }
            case 4: {
                return 3;
            }
            case 3: {
                return 1;
            }
            case 5: {
                return 1;
            }
            case 2: {
                return 1;
            }
            case 9: {
                return 1;
            }
            case 8: {
                return 1;
            }
            case 10: {
                return 1;
            }
            case 6: {
                return 1;
            }
            case 24: {
                return 5;
            }
            case 23: {
                return 5;
            }
            case 25: {
                return 5;
            }
            case 22: {
                return 5;
            }
            case 26: {
                return 5;
            }
            case 1: {
                return 2;
            }
            case 14: {
                return 2;
            }
            case 13: {
                return 2;
            }
            case 15: {
                return 2;
            }
            case 12: {
                return 2;
            }
            case 16: {
                return 2;
            }
            case 7: {
                return 1;
            }
            case 11: {
                return 1;
            }
        }
        return 0;
    }

    public void setSlideVars() {
        if (!this.bTackling) {
            return;
        }
        if (this.iTacklingFrame == 0) {
            if (this.iFaceType == 0) {
                this.iFaceDiffY = 0;
                this.iFaceDiffX = 7;
                if (this.iFaceFrame == 2) {
                    this.iFaceDiffX = this.bSwitch ? 12 : 2;
                }
            } else if (this.iFaceType == 1) {
                this.iFaceDiffY = 0;
                this.iFaceDiffX = 7;
                if (this.iFaceFrame == 1) {
                    this.iFaceDiffX = this.bSwitch ? 10 : 4;
                } else if (this.iFaceFrame == 2) {
                    this.iFaceDiffX = this.bSwitch ? 12 : 2;
                }
            } else if (this.iFaceType == 2) {
                this.iFaceDiffY = 6;
                this.iFaceDiffX = 7;
                if (this.iFaceFrame == 1) {
                    this.iFaceDiffX = this.bSwitch ? 8 : 6;
                } else if (this.iFaceFrame == 2) {
                    this.iFaceDiffX = this.bSwitch ? 10 : 4;
                }
            } else if (this.iFaceType == 3) {
                this.iFaceDiffY = 0;
                this.iFaceDiffX = 7;
                if (this.iFaceFrame == 1) {
                    this.iFaceDiffX = this.bSwitch ? 10 : 4;
                } else if (this.iFaceFrame == 2) {
                    this.iFaceDiffX = this.bSwitch ? 10 : 4;
                }
            }
        } else if (this.iFaceType == 0) {
            this.iFaceDiffY = 0;
            this.iFaceDiffX = 7;
            if (this.iFaceFrame == 1) {
                this.iFaceDiffY = -2;
                this.iFaceDiffX = this.bSwitch ? 14 : 2;
            }
            if (this.iFaceFrame == 2) {
                this.iFaceDiffY = -4;
                this.iFaceDiffX = this.bSwitch ? 21 : -5;
            }
        } else if (this.iFaceType == 1) {
            this.iFaceDiffY = -3;
            this.iFaceDiffX = 7;
            if (this.iFaceFrame == 1) {
                this.iFaceDiffY = -6;
                this.iFaceDiffX = this.bSwitch ? 14 : 1;
            }
            if (this.iFaceFrame == 2) {
                this.iFaceDiffY = -10;
                this.iFaceDiffX = this.bSwitch ? 14 : 1;
            }
            if (this.iFaceFrame == 3) {
                this.iFaceDiffY = -10;
                this.iFaceDiffX = this.bSwitch ? 14 : 1;
            }
            if (this.iFaceFrame == 4) {
                this.iFaceDiffY = -30;
            }
        } else if (this.iFaceType == 2) {
            this.iFaceDiffX = 8;
            this.iFaceDiffY = 1;
            if (this.iFaceFrame == 0) {
                this.iFaceDiffY = 1;
            } else if (this.iFaceFrame == 1) {
                this.iFaceDiffY = -2;
                this.iFaceDiffX = this.bSwitch ? 14 : 1;
            } else if (this.iFaceFrame == 2) {
                this.iFaceDiffY = -5;
                this.iFaceDiffX = this.bSwitch ? 15 : 0;
            } else if (this.iFaceFrame == 3) {
                this.iFaceDiffY = -5;
                this.iFaceDiffX = this.bSwitch ? 15 : 0;
            } else if (this.iFaceFrame == 4) {
                this.iFaceDiffY = -28;
            }
        } else if (this.iFaceType == 3) {
            this.iFaceDiffY = -3;
            this.iFaceDiffX = 7;
            if (this.iFaceFrame == 1) {
                this.iFaceDiffY = -6;
                this.iFaceDiffX = this.bSwitch ? 14 : 1;
            }
            if (this.iFaceFrame == 2) {
                this.iFaceDiffY = -11;
                this.iFaceDiffX = this.bSwitch ? 14 : 1;
            }
            if (this.iFaceFrame == 3) {
                this.iFaceDiffY = -10;
                this.iFaceDiffX = this.bSwitch ? 14 : 1;
            }
            if (this.iFaceFrame == 4) {
                this.iFaceDiffY = -28;
            }
        }
    }

    public void resetPower() {
        this.iShootClip = 0;
    }
}

