/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic.spf;

import java.util.Random;
import sk.inlogic.spf.FootballTeamAI;

public class Common {
    static final Random randGenerator = new Random();
    static int[] ARCSIN_TABLE = new int[]{0, 0, 0, 0, 0, 1, 1, 1, 1, 2, 2, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4, 4, 4, 5, 5, 5, 5, 6, 6, 6, 6, 6, 7, 7, 7, 7, 8, 8, 8, 8, 8, 9, 9, 9, 9, 10, 10, 10, 10, 11, 11, 11, 11, 11, 12, 12, 12, 12, 13, 13, 13, 13, 14, 14, 14, 14, 14, 15, 15, 15, 15, 16, 16, 16, 16, 17, 17, 17, 17, 17, 18, 18, 18, 18, 19, 19, 19, 19, 20, 20, 20, 20, 21, 21, 21, 21, 22, 22, 22, 22, 22, 23, 23, 23, 23, 24, 24, 24, 24, 25, 25, 25, 25, 26, 26, 26, 26, 27, 27, 27, 27, 28, 28, 28, 28, 29, 29, 29, 30, 30, 30, 30, 31, 31, 31, 31, 32, 32, 32, 32, 33, 33, 33, 33, 34, 34, 34, 35, 35, 35, 35, 36, 36, 36, 36, 37, 37, 37, 38, 38, 38, 38, 39, 39, 39, 40, 40, 40, 41, 41, 41, 41, 42, 42, 42, 43, 43, 43, 44, 44, 44, 44, 45, 45, 45, 46, 46, 46, 47, 47, 47, 48, 48, 48, 49, 49, 49, 50, 50, 51, 51, 51, 52, 52, 52, 53, 53, 53, 54, 54, 55, 55, 55, 56, 56, 57, 57, 57, 58, 58, 59, 59, 60, 60, 61, 61, 61, 62, 62, 63, 63, 64, 64, 65, 66, 66, 67, 67, 68, 69, 69, 70, 70, 71, 72, 73, 73, 74, 75, 76, 77, 78, 79, 81, 82, 84, 90};
    static int[] SIN_TABLE = new int[]{0, 4, 8, 13, 17, 22, 26, 31, 35, 40, 44, 48, 53, 57, 61, 66, 70, 74, 79, 83, 87, 91, 95, 100, 104, 108, 112, 116, 120, 124, 127, 131, 135, 139, 143, 146, 150, 154, 157, 161, 164, 167, 171, 174, 177, 181, 184, 187, 190, 193, 196, 198, 201, 204, 207, 209, 212, 214, 217, 219, 221, 223, 226, 228, 230, 232, 233, 235, 237, 238, 240, 242, 243, 244, 246, 247, 248, 249, 250, 251, 252, 252, 253, 254, 254, 255, 255, 255, 255, 255, 256, 255, 255, 255, 255, 255, 254, 254, 253, 252, 252, 251, 250, 249, 248, 247, 246, 244, 243, 242, 240, 238, 237, 235, 233, 232, 230, 228, 226, 223, 221, 219, 217, 214, 212, 209, 207, 204, 201, 198, 196, 193, 190, 187, 184, 181, 177, 174, 171, 167, 164, 161, 157, 154, 150, 146, 143, 139, 135, 131, 127, 124, 120, 116, 112, 108, 104, 100, 95, 91, 87, 83, 79, 74, 70, 66, 61, 57, 53, 48, 44, 40, 35, 31, 26, 22, 17, 13, 8, 4, 0, -4, -8, -13, -17, -22, -26, -31, -35, -40, -44, -48, -53, -57, -61, -66, -70, -74, -79, -83, -87, -91, -95, -100, -104, -108, -112, -116, -120, -124, -127, -131, -135, -139, -143, -146, -150, -154, -157, -161, -164, -167, -171, -174, -177, -181, -184, -187, -190, -193, -196, -198, -201, -204, -207, -209, -212, -214, -217, -219, -221, -223, -226, -228, -230, -232, -233, -235, -237, -238, -240, -242, -243, -244, -246, -247, -248, -249, -250, -251, -252, -252, -253, -254, -254, -255, -255, -255, -255, -255, -256, -255, -255, -255, -255, -255, -254, -254, -253, -252, -252, -251, -250, -249, -248, -247, -246, -244, -243, -242, -240, -238, -237, -235, -233, -232, -230, -228, -226, -223, -221, -219, -217, -214, -212, -209, -207, -204, -201, -198, -196, -193, -190, -187, -184, -181, -177, -174, -171, -167, -164, -161, -157, -154, -150, -146, -143, -139, -135, -131, -128, -124, -120, -116, -112, -108, -104, -100, -95, -91, -87, -83, -79, -74, -70, -66, -61, -57, -53, -48, -44, -40, -35, -31, -26, -22, -17, -13, -8, -4};
    static final int[] table = new int[]{0, 16, 22, 27, 32, 35, 39, 42, 45, 48, 50, 53, 55, 57, 59, 61, 64, 65, 67, 69, 71, 73, 75, 76, 78, 80, 81, 83, 84, 86, 87, 89, 90, 91, 93, 94, 96, 97, 98, 99, 101, 102, 103, 104, 106, 107, 108, 109, 110, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 128, 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 144, 145, 146, 147, 148, 149, 150, 150, 151, 152, 153, 154, 155, 155, 156, 157, 158, 159, 160, 160, 161, 162, 163, 163, 164, 165, 166, 167, 167, 168, 169, 170, 170, 171, 172, 173, 173, 174, 175, 176, 176, 177, 178, 178, 179, 180, 181, 181, 182, 183, 183, 184, 185, 185, 186, 187, 187, 188, 189, 189, 190, 191, 192, 192, 193, 193, 194, 195, 195, 196, 197, 197, 198, 199, 199, 200, 201, 201, 202, 203, 203, 204, 204, 205, 206, 206, 207, 208, 208, 209, 209, 210, 211, 211, 212, 212, 213, 214, 214, 215, 215, 216, 217, 217, 218, 218, 219, 219, 220, 221, 221, 222, 222, 223, 224, 224, 225, 225, 226, 226, 227, 227, 228, 229, 229, 230, 230, 231, 231, 232, 232, 233, 234, 234, 235, 235, 236, 236, 237, 237, 238, 238, 239, 240, 240, 241, 241, 242, 242, 243, 243, 244, 244, 245, 245, 246, 246, 247, 247, 248, 248, 249, 249, 250, 250, 251, 251, 252, 252, 253, 253, 254, 254, 255};
    static int[] tmp = new int[2];
    static final byte COLL_NONE = 0;
    public static final int[] AtanTable = new int[]{0, 1, 2, 3, 5, 6, 7, 8, 10, 11, 12, 13, 14, 16, 17, 18, 19, 20, 21, 22, 23, 25, 26, 27, 28, 29, 30, 30, 31, 32, 33, 34, 35, 36, 37, 37, 38, 39, 40, 40, 41, 42, 43, 43, 44, 45};

    static final int barValue(int value, int maxValue, int stretchVal) {
        return (value << 8 << 8) / (maxValue << 8) * (stretchVal << 8) >> 8 >> 8;
    }

    public static final int getRandomInt(int max) {
        return randGenerator.nextInt() % max;
    }

    public static final int getRandomUInt(int max) {
        if (max == 1) {
            return 0;
        }
        return Math.abs(randGenerator.nextInt() % max);
    }

    static final byte getRandomByte(int max) {
        return (byte)Math.abs(Common.getRandomInt(max));
    }

    static int ARCSIN(int val) {
        return ARCSIN_TABLE[Math.abs(val)] * (val < 0 ? -1 : 1);
    }

    static int SIN(long angle) {
        if ((angle %= 360L) < 0L) {
            angle = 360L + angle;
        }
        return SIN_TABLE[(int)angle];
    }

    static int COS(long angle) {
        return Common.SIN(angle += 90L);
    }

    static int sqrt(int x) {
        if (x >= 65536) {
            if (x >= 0x1000000) {
                int xn = x >= 0x10000000 ? (x >= 0x40000000 ? table[x >> 24] << 8 : table[x >> 22] << 7) : (x >= 0x4000000 ? table[x >> 20] << 6 : table[x >> 18] << 5);
                xn = xn + 1 + x / xn >> 1;
                xn = xn + 1 + x / xn >> 1;
                return xn * xn > x ? --xn : xn;
            }
            int xn = x >= 0x100000 ? (x >= 0x400000 ? table[x >> 16] << 4 : table[x >> 14] << 3) : (x >= 262144 ? table[x >> 12] << 2 : table[x >> 10] << 1);
            xn = xn + 1 + x / xn >> 1;
            return xn * xn > x ? --xn : xn;
        }
        if (x >= 256) {
            int xn = x >= 4096 ? (x >= 16384 ? table[x >> 8] + 1 : (table[x >> 6] >> 1) + 1) : (x >= 1024 ? (table[x >> 4] >> 2) + 1 : (table[x >> 2] >> 3) + 1);
            return xn * xn > x ? --xn : xn;
        }
        if (x >= 0) {
            return table[x] >> 4;
        }
        Common.illegalArgument();
        return -1;
    }

    private static void illegalArgument() {
        throw new IllegalArgumentException("Attemt to take the square root of negative number");
    }

    public static int sizeofVector(int x1, int y1, int x2, int y2) {
        int x12 = (x1 - x2) * (x1 - x2);
        int y12 = (y1 - y2) * (y1 - y2);
        int sqr = Common.sqrt(x12 + y12);
        return sqr == 0 ? 1 : sqr;
    }

    public static int[] getVector(int[] iVec, int x1, int y1, int x2, int y2) {
        iVec[0] = x2 - x1;
        iVec[1] = y2 - y1;
        return iVec;
    }

    public static int[] getNormVector(int[] iNormVec, int x1, int y1, int x2, int y2) {
        int size = Common.sizeofVector(x1, y1, x2, y2);
        size = size == 0 ? 1 : size;
        iNormVec[0] = (x2 - x1 << 8) / size;
        iNormVec[1] = (y2 - y1 << 8) / size;
        return iNormVec;
    }

    public static int getLineC(int normX, int normY, int x1, int y1) {
        return -(normX * x1 + normY * y1);
    }

    public static int getDistFromLine(int x1, int y1, int vecX, int vecY, int px, int py) {
        int[] normal = Common.getVectorNormal(vecX, vecY);
        int c = Common.getLineC(normal[0], normal[1], x1, y1);
        return Math.abs(normal[0] * px + normal[1] * py + c) / Common.sqrt(normal[0] * normal[0] + normal[1] * normal[1]);
    }

    public static int[] getVectorNormal(int x1, int y1) {
        return new int[]{y1, -x1};
    }

    public static int[] getOpostieVec(int x1, int y1) {
        return new int[]{-y1, -x1};
    }

    public static int getDotProduct(int p1x, int p1y, int p2x, int p2y, int p1dx, int p1dy) {
        Common.getNormVector(tmp, p1x, p1y, p2x, p2y);
        return tmp[0] * p1dx + tmp[1] * p1dy;
    }

    public static final int getManhattanDis(int x1, int y1, int x2, int y2) {
        return Common.sum(x1, x2, y1, y2);
    }

    public static int sum(int a, int b, int c, int d) {
        int a0 = a < b ? b - a : a - b;
        int a1 = c < d ? d - c : c - d;
        return a0 + a1;
    }

    public static final int getDistance(int x1, int y1, int x2, int y2) {
        int iSqr = (x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1);
        return Common.sqrt(iSqr);
    }

    static final void quickSort(int[] idx, int[] pz, int lo0, int hi0) {
        int lo = lo0;
        int hi = hi0;
        if (hi0 > lo0) {
            int mid = pz[(lo0 + hi0) / 2];
            while (lo <= hi) {
                while (lo < hi0 && pz[lo] < mid) {
                    ++lo;
                }
                while (hi > lo0 && pz[hi] > mid) {
                    --hi;
                }
                if (lo > hi) continue;
                if (pz[lo] != pz[hi]) {
                    int tmpInt = idx[lo];
                    idx[lo] = idx[hi];
                    idx[hi] = tmpInt;
                    tmpInt = pz[lo];
                    pz[lo] = pz[hi];
                    pz[hi] = tmpInt;
                }
                ++lo;
                --hi;
            }
            if (lo0 < hi) {
                Common.quickSort(idx, pz, lo0, hi);
            }
            if (lo < hi0) {
                Common.quickSort(idx, pz, lo, hi0);
            }
        }
    }

    public static void quick_srt(int[][] array, int low, int n) {
        int T;
        int lo = low;
        int hi = n;
        if (lo >= n) {
            return;
        }
        int mid = array[lo + hi >> 1][0];
        while (lo < hi) {
            while (lo < hi && array[lo][0] < mid) {
                ++lo;
            }
            while (lo < hi && array[hi][0] > mid) {
                --hi;
            }
            if (lo >= hi) continue;
            T = array[lo][0];
            int T1 = array[lo][1];
            array[lo][0] = array[hi][0];
            array[lo][1] = array[hi][1];
            array[hi][0] = T;
            array[hi][1] = T1;
        }
        if (hi < lo) {
            T = hi;
            hi = lo;
            lo = T;
        }
        Common.quick_srt(array, low, lo);
        Common.quick_srt(array, lo == low ? lo + 1 : lo, n);
    }

    public static void fillArrByDDA(int x1, int y1, int x2, int y2, int weight) {
        int deltax = x2 - x1;
        int deltay = y2 - y1;
        int count = Math.abs(deltax) > Math.abs(deltay) ? Math.abs(deltax) : Math.abs(deltay);
        if (x1 == x2 && y1 == y2) {
            return;
        }
        int xAdd = (deltax << 8 << 8) / (count << 8);
        int yAdd = (deltay << 8 << 8) / (count << 8);
        int x = x1 << 8;
        int y = y1 << 8;
        for (int k = --count; k >= 0; --k) {
            Common.fillArr((x += xAdd) >> 8, (y += yAdd) >> 8, weight);
        }
    }

    public static void fillArr(int x, int y, int wg) {
        if (x < 0) {
            return;
        }
        if (x > 14) {
            return;
        }
        if (y < 0) {
            return;
        }
        if (y > 14) {
            return;
        }
        int[] nArray = FootballTeamAI.iPlayerWeights[x];
        int n = y;
        nArray[n] = nArray[n] + wg;
    }

    public static boolean testCollisionsDDA(int x1, int y1, int x2, int y2) {
        if (x1 == x2 && y1 == y2) {
            return true;
        }
        int deltax = x2 - x1;
        int deltay = y2 - y1;
        int count = Math.abs(deltax) > Math.abs(deltay) ? Math.abs(deltax) : Math.abs(deltay);
        int xAdd = (deltax << 8 << 8) / (count << 8);
        int yAdd = (deltay << 8 << 8) / (count << 8);
        int x = x1 << 8;
        int y = y1 << 8;
        if (Common.inCollision(x1, y1)) {
            return true;
        }
        for (int k = --count; k >= 0; k -= 2) {
            if (!Common.inCollision((x += xAdd) >> 8, (y += yAdd) >> 8)) continue;
            return true;
        }
        return false;
    }

    static final boolean inCollision(int x, int y) {
        return Common.getCollision(x, y) < 0;
    }

    static final byte getCollision(int x, int y) {
        if (x < 0) {
            return 0;
        }
        if (y < 0) {
            return 0;
        }
        if (x > 14) {
            return 0;
        }
        if (y > 14) {
            return 0;
        }
        return FootballTeamAI.bHlpArr[x][y];
    }

    public static int atan(int Y, int X) {
        int bottom;
        boolean swap = false;
        int top = Math.abs(Y);
        if (top > (bottom = Math.abs(X))) {
            int btemp = bottom;
            bottom = top;
            top = btemp;
            swap = true;
        } else if (bottom == 0) {
            return -300;
        }
        int index = top * 45 / bottom;
        int angle = AtanTable[index];
        if (swap) {
            angle = 90 - angle;
        }
        if (X < 0 && Y < 0) {
            angle += 180;
        } else if (Y < 0) {
            angle = 90 - angle;
            angle += 270;
        } else if (X < 0) {
            angle = 90 - angle;
            angle += 90;
        }
        if (angle == 360) {
            angle = 0;
        }
        return angle;
    }
}

